/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

////css-prefix = planningNotificationReportSearch
////i18n-prefix = planningNotificationReportSearch

define([ "cdes/core/CdesVoc",
	"cdes/planning/util/PlanningNotificationHelper",
	"cdes/planning/util/PlanningNotificationTitleMultiSearchWidget",
	"cdes/util/CodeHelper",
	"cdes/util/ColumnHelper",
	"cdes/util/SearchPageHelper",
    "cdes/widget/CalendarSpinner",
	"cdes/widget/project/ProjectParticipationMultiSelect",
	"cdes/widget/util/WidgetFactory",
	"clazzes/TinyLog",
	"clazzes/dateTime/DateTimeSpinBox",
	"clazzes/form/NumberSpinner",
	"clazzes/util/DOMHelper",
	"clazzes/util/ErrorHelper",
	"clazzes/util/WidgetHelper",
	"clazzes/widgets/IconTitlePane",
	"clazzes/widgets/layout/ContentWidget",
	"dijit/form/Button",
	"dijit/form/CheckBox",
	"dijit/form/ComboBox",
	"dijit/form/Select",
	"dijit/form/TextBox",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-style",
	"dojo/keys",
	"dojo/on",
	"dojo/store/Memory",
	"dojo/string",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(CdesVoc,
	 PlanningNotificationHelper,
	 PlanningNotificationTitleMultiSearchWidget,
	 CodeHelper,
	 ColumnHelper,
     SearchPageHelper,
	 CalendarSpinner,
	 ProjectParticipationMultiSelect,
	 WidgetFactory,
	 TinyLog,
	 DateTimeSpinBox,
	 NumberSpinner,
	 DOMHelper,
	 ErrorHelper,
	 WidgetHelper,
	 IconTitlePane,
	 ContentWidget,
	 Button,
	 CheckBox,
	 ComboBox,
	 Select,
	 TextBox,
	 domClass,
	 domConstruct,
	 domStyle,
	 Keys,
	 on,
	 Memory,
	 string,
	 declare,
	 lang,
	 i18n) {

    var className = "at.cdes.web.planning.notification.PlanningNotificationReportSearchWidget";

    var log = new TinyLog(className);

    // The following CSS classes need to be changed on height changes of this widget
    // planningNotificationReportSearchFull, planningNotificationReportSearchContentDiv, planningNotificationReportSearchOptionalOrderDiv

    var PlanningNotificationReportSearchWidget = declare(className, ContentWidget, {

	constructor : function(params) {
	    lang.mixin(this, params);

	    this.columnSettings = new Object();
	    this.topDiv = this.constructTopDiv();
	    var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
	    var networkId = this.applicationContext.getPageContextPnNetworkId();
	    this.optionalFieldsVisible = this.applicationContext.getFromLocalStorage([organisationPersonId, networkId],
					                                             "/planningNotificationReport/optionalSearchFieldsVisible");
	    if (this.optionalFieldsVisible == null) {
		this.optionalFieldsVisible = false;
	    }

	    this.allFieldsValid = true;
	},

	getWidgetId : function() {
	    return "PlanningNotificationReportSearchWidget";
	},

	getDataId : function() {
	    return null;
	},

	getContainer : function() {
	    return this.topDiv;
	},

	constructTopDiv : function() {
	    var topDiv = domConstruct.create("div", null, null);
	    domClass.add(topDiv, "refNodeOfPositionAbsolute planningNotificationReportSearchFull");

	    this.titlePane = this.constructTitlePane();
	    domConstruct.place(this.titlePane.domNode, topDiv);

	    return topDiv;
	},

	postTitleClick : function() {

	    var open = this.titlePane.get("open");

	    if (open) {
		var fullClass = this.optionalFieldsVisible ? "planningNotificationReportSearchFullWithOptional" : "planningNotificationReportSearchFull";

		this.titlePane.set("title", i18n.searchOpenCaption);
		domClass.replace(this.topDiv, fullClass, "planningNotificationReportSearchReduced");
	    } else {
		this.titlePane.set("title", i18n.searchClosedCaption);
		domClass.replace(this.topDiv, "planningNotificationReportSearchReduced", "planningNotificationReportSearchFull planningNotificationReportSearchFullWithOptional");
	    }

	    on.emit(this, "titlePaneToggled");
	},

	constructTitlePane : function() {
	    this.contentDiv = this.constructEmptyContentDiv();

	    var titlePane = new IconTitlePane({
		       title   : i18n.searchOpenCaption,
		       content : this.contentDiv,
		    toggleable : true,
			  open : true,
		postTitleClick : lang.hitch(this, this.postTitleClick)
	    });
	    domClass.add(titlePane.domNode, "occupyWholeParent planningNotificationReportSearchTitlePane");

	    return titlePane;
	},

	constructEmptyContentDiv : function() {
	    var contentDiv = domConstruct.create("div", null, null);
	    domClass.add(contentDiv, "refNodeOfPositionAbsolute planningNotificationReportSearchContentDiv");

	    return contentDiv;
	},

	fillContentDiv : function(metaTags, projectIdToProject, idToWorkflowNodeTemplate) {
	    this.constructFirstLineDiv(projectIdToProject);
	    this.constructMetaTagDivs(metaTags);
	    this.constructPermanentOrderWidgets();
	    this.constructOptionalOrderWidgets(idToWorkflowNodeTemplate);
	},

	constructFirstLineDiv : function(projectIdToProject) {
	    this.firstLineDiv = domConstruct.create("div", null, null);
	    domClass.add(this.firstLineDiv, "refNodeOfPositionAbsolute planningNotificationReportSearchFirstLineDiv");
	    domConstruct.place(this.firstLineDiv, this.contentDiv);

	    // Title
	    DOMHelper.createTextNode("div", i18n.planningNotificationSearchTitleLabel, this.firstLineDiv,
			             "propertyLabel planningNotificationReportSearchTitleLabel planningNotificationReportSearchCaption");
	    this.planningNotificationMultiComboBox = new PlanningNotificationTitleMultiSearchWidget({
						label : i18n.planningNotificationColumnTitleLabel,
		                //				Use the tooltip of the PlanningNotificationTitleMultiSearchWidget
		                //				title : i18n.planningNotificationSearchTitleToolTip,
				comboBoxClass : "fixedDialogWidget planningNotificationReportSearchTitleSearchComboBox",
                selectOnClick : true
	    });
	    domClass.add(this.planningNotificationMultiComboBox.domNode, "fixedDialogWidget planningNotificationReportSearchTitleComboBox");
	    domConstruct.place(this.planningNotificationMultiComboBox.domNode, this.firstLineDiv);
	    on(this.planningNotificationMultiComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
	    this.showTitleCheckBox = this.constructShowCheckBox("title", this.firstLineDiv);


	    // Comment
	    DOMHelper.createTextNode("div", i18n.planningNotificationColumnCommentLabel, this.firstLineDiv, "propertyLabel planningNotificationReportSearchNotificationCommentLabel");
	    this.notificationCommentTextBox = new TextBox({
							label : i18n.planningNotificationColumnCommentLabel,
							title : i18n.planningNotificationSearchCommentToolTip,
            		selectOnClick : true
	    });
	    domClass.add(this.notificationCommentTextBox.domNode, "fixedDialogWidget planningNotificationReportSearchNotificationCommentTextBox");
	    domConstruct.place(this.notificationCommentTextBox.domNode, this.firstLineDiv);
	    on(this.notificationCommentTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
	    this.showNotificationCommentCheckBox = this.constructShowCheckBox("notificationComment", this.firstLineDiv);

	    // Project
	    DOMHelper.createTextNode("div", i18n.planningNotificationColumnProjectLabel, this.firstLineDiv, "propertyLabel planningNotificationReportSearchProjectLabel");
	    this.projectSelect = new Select({
		label : i18n.planningNotificationColumnProjectLabel,
		title : i18n.planningNotificationColumnProjectToolTip
	    });
	    domClass.add(this.projectSelect.domNode, "fixedDialogWidget planningNotificationReportSearchProjectSelect");
	    domConstruct.place(this.projectSelect.domNode, this.firstLineDiv);
	    on(this.projectSelect.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
	    WidgetHelper.handleSelectEvents(this.projectSelect, lang.hitch(this, this.handleProjectSelectChange));
	    this.showProjectCheckBox = this.constructShowCheckBox("project", this.firstLineDiv);
	},

	constructMetaTagDivs : function(metaTags) {
	    this.idToMetaTagInfo = new Object();

	    // Widgets shown always
	    this.permanentDiv = domConstruct.create("div", null, null);
	    domClass.add(this.permanentDiv, "refNodeOfPositionAbsolute planningNotificationReportSearchPermanentDiv");
	    domConstruct.place(this.permanentDiv, this.contentDiv);

	    this.constructSearchWidgets(metaTags, this.permanentDiv, 0);  // 0 = priority "show always"

	    // Widgets shown optionally
	    this.optionalDiv = domConstruct.create("div", null, null);
	    domClass.add(this.optionalDiv, "refNodeOfPositionAbsolute planningNotificationReportSearchOptionalDiv");
	    domConstruct.place(this.optionalDiv, this.contentDiv);

	    this.constructSearchWidgets(metaTags, this.optionalDiv, 1); // 1 = priority "show optionally"
	},

	constructSearchWidgets : function(metaTags, parentDiv, priorityFilter) {

	    for (var n = 0; n < metaTags.length; n++) {
			var metaTag = metaTags[n];
			var priority = metaTag.priority;
			var cssClass = metaTag.cssClass;
			var cssRules = metaTag.cssRules;
			var name = metaTag.name;
			var tagFormat = metaTag.tagFormat;

			if (cssClass == null) {
			    log.error("Cannot place search widget for metaTag [" + name + "] since it has no css class; will ignore it.");
			    continue;
			}

			document.getElementsByTagName("head")[0].appendChild(DOMHelper.createTextNode("style", cssRules));

			if (priority == priorityFilter) {
			    if (tagFormat == 0) {    // TAG_FORMAT_TEXT
					var labelCssClass = "planningNotificationReportSearch" + cssClass + "Label";
					DOMHelper.createTextNode("div", name, parentDiv, "propertyLabel " + labelCssClass);

					var textBoxCssClass = "planningNotificationReportSearch" + cssClass + "TextBox";
					var textBox = new TextBox({
								    label : name,
								    title : i18n.planningNotificationSearchMetasToolTip,
		            		selectOnClick : true
					});
					domClass.add(textBox.domNode, "fixedDialogWidget " + textBoxCssClass);
					domConstruct.place(textBox.domNode, parentDiv);
					on(textBox, "keyup", lang.hitch(this, this.searchIfEnter));

					var showCheckBox = this.constructShowCheckBox(cssClass, parentDiv);

					this.idToMetaTagInfo[metaTag.id] = {
						    	metaTag : metaTag,
					      primaryWidget : textBox,
					    secondaryWidget : null,
					       showCheckBox : showCheckBox
					};
			    } else if (tagFormat == 1) {  // TAG_FORMAT_DATE
					var fromLabel = string.substitute(i18n.searchFrom, { label : name });

					var fromLabelCssClass = "planningNotificationReportSearch" + cssClass + "FromLabel";
					DOMHelper.createTextNode("div", fromLabel, parentDiv, "propertyLabel " + fromLabelCssClass);

					var fromSpinnerCssClass = "planningNotificationReportSearch" + cssClass + "FromSpinner";
					var fromSpinner = new CalendarSpinner({
									label : fromLabel,
									title : name,
							      pattern : i18n.datePattern,
							     timeZone : this.applicationContext.getTimeZone(),
							   dndEnabled : false,
					    rowObjectToString : null
					});
					domClass.add(fromSpinner.domNode, "fixedDialogWidget " + fromSpinnerCssClass);
					domConstruct.place(fromSpinner.domNode, parentDiv);
					on(fromSpinner, "keyup", lang.hitch(this, this.searchIfEnter));

					var toLabelCssClass = "planningNotificationReportSearch" + cssClass + "ToLabel";
					DOMHelper.createTextNode("div", i18n.searchTo, parentDiv, "propertyLabel " + toLabelCssClass);

					var toSpinnerCssClass = "planningNotificationReportSearch" + cssClass + "ToSpinner";
					var toSpinner = new CalendarSpinner({
							label : i18n.searchTo,
							title : name,
						      pattern : i18n.datePattern,
						     timeZone : this.applicationContext.getTimeZone(),
						   dndEnabled : false,
					    rowObjectToString : null
					});
					domClass.add(toSpinner.domNode, "fixedDialogWidget " + toSpinnerCssClass);
					domConstruct.place(toSpinner.domNode, parentDiv);
					on(toSpinner, "keyup", lang.hitch(this, this.searchIfEnter));

					var showCheckBox = this.constructShowCheckBox(cssClass, parentDiv);

					this.idToMetaTagInfo[metaTag.id] = {
						    metaTag : metaTag,
					      primaryWidget : fromSpinner,
					    secondaryWidget : toSpinner,
					       showCheckBox : showCheckBox
					};
			    } else {
					throw new Error("TagFormat [" + tagFormat + "] is not yet supported, see at.cdes.oldGwtDto.MetaTagDTO");
			    }
			}
	    }
	},

	constructPermanentOrderWidgets : function() {
	    this.permanentOrderDiv = domConstruct.create("div", null, null);
	    domClass.add(this.permanentOrderDiv, "refNodeOfPositionAbsolute planningNotificationReportSearchPermanentOrderDiv");
	    domConstruct.place(this.permanentOrderDiv, this.contentDiv);

	    DOMHelper.createTextNode("div", i18n.planningNotificationSearchOrderSectionCaption, this.permanentOrderDiv,
			             "fixedDialogWidget planningNotificationReportSearchOrderSectionCaption planningNotificationReportSearchCaption");

	    // SerialNumberNumberSpinner
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderSerialNumberLabel, this.permanentOrderDiv,
			             "propertyLabel planningNotificationReportSearchSerialNumberLabel");
	    this.serialNumberSpinner = new NumberSpinner({
							label : i18n.planningNotificationOrderSerialNumberLabel,
							title : i18n.planningNotificationOrderSerialNumberToolTip,
			omitThousandSeparator : true
	    });
	    domClass.add(this.serialNumberSpinner.domNode, "fixedDialogWidget planningNotificationReportSearchSerialNumberSpinner");
	    domConstruct.place(this.serialNumberSpinner.domNode, this.permanentOrderDiv);
	    on(this.serialNumberSpinner.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
	    //	    WidgetHelper.handleSpinnerEvents(this.serialNumberSpinner, lang.hitch(this, this.updateWidgetState));
	    this.showSerialNumberCheckBox = this.constructShowCheckBox("serialNumber", this.permanentOrderDiv);

	    // TextTextBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderTextLabel, this.permanentOrderDiv, "propertyLabel planningNotificationReportSearchTextLabel");
	    this.textTextBox = new TextBox({
							label : i18n.planningNotificationOrderTextLabel,
							title : i18n.planningNotificationOrderTextToolTip,
            		selectOnClick : true
	    });
	    domClass.add(this.textTextBox.domNode, "fixedDialogWidget planningNotificationReportSearchTextTextBox");
	    domConstruct.place(this.textTextBox.domNode, this.permanentOrderDiv);
	    on(this.textTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
	    //	    WidgetHelper.handleTextBoxEvents(this.textTextBox, lang.hitch(this, this.updateWidgetState));
	    this.showTextCheckBox = this.constructShowCheckBox("text", this.permanentOrderDiv);

	    // SubjectAreaComboBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderSubjectAreaLabel, this.permanentOrderDiv,
			             "propertyLabel planningNotificationReportSearchSubjectAreaLabel");
	    this.subjectAreaComboBox = new ComboBox({
					label : i18n.planningNotificationOrderSubjectAreaLabel,
					title : i18n.planningNotificationOrderSubjectAreaToolTip,
            selectOnClick : true
	    });
	    domClass.add(this.subjectAreaComboBox.domNode, "fixedDialogWidget planningNotificationReportSearchSubjectAreaComboBox");
	    domConstruct.place(this.subjectAreaComboBox.domNode, this.permanentOrderDiv);
	    on(this.subjectAreaComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
	    //	    WidgetHelper.(this.subjectArea, lang.hitch(this, this.updateWidgetState));
	    this.showSubjectAreaCheckBox = this.constructShowCheckBox("subjectArea", this.permanentOrderDiv);

	    // AuthorizedInspectorTextBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderAuthorizedInspectorLabel, this.permanentOrderDiv,
			             "propertyLabel planningNotificationReportSearchAuthorizedInspectorLabel");
	    this.authorizedInspectorTextBox = new TextBox({
							label : i18n.planningNotificationOrderAuthorizedInspectorLabel,
							title : i18n.planningNotificationOrderAuthorizedInspectorToolTip,
            		selectOnClick : true
	    });
	    domClass.add(this.authorizedInspectorTextBox.domNode, "fixedDialogWidget planningNotificationReportSearchAuthorizedInspectorTextBox");
	    domConstruct.place(this.authorizedInspectorTextBox.domNode, this.permanentOrderDiv);
	    on(this.authorizedInspectorTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
	    //	    WidgetHelper.handleTextBoxEvents(this.authorizedInspectorTextBox, lang.hitch(this, this.updateWidgetState));
	    this.showAuthorizedInspectorCheckBox = this.constructShowCheckBox("authorizedInspector", this.permanentOrderDiv);

	    // StatutoryDutySelect
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderStatutoryDutyLabel, this.permanentOrderDiv,
			             "propertyLabel planningNotificationReportSearchStatutoryDutyLabel");
	    this.statutoryDutySelect = new Select({
		label : i18n.planningNotificationOrderStatutoryDutyLabel,
		title : i18n.planningNotificationOrderStatutoryDutyToolTip
	    });
	    domClass.add(this.statutoryDutySelect.domNode, "fixedDialogWidget planningNotificationReportSearchStatutoryDutySelect");
	    domConstruct.place(this.statutoryDutySelect.domNode, this.permanentOrderDiv);
	    //	    WidgetHelper.handleSelectEvents(this.statutoryDutySelect, lang.hitch(this, this.updateWidgetState));
	    this.showStatutoryDutyCheckBox = this.constructShowCheckBox("statutoryDuty", this.permanentOrderDiv);

	    // InvalidatedCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderInvalidatedLabel, this.permanentOrderDiv,
			             "propertyLabel planningNotificationReportSearchInvalidatedLabel");
	    this.invalidatedSelect = WidgetFactory.constructBooleanSelect();
	    this.invalidatedSelect.set("label", i18n.planningNotificationOrderInvalidatedLabel);
	    this.invalidatedSelect.set("title", i18n.planningNotificationOrderInvalidatedToolTip);
	    domClass.add(this.invalidatedSelect.domNode, "fixedDialogWidget planningNotificationReportSearchInvalidatedSelect");
	    domConstruct.place(this.invalidatedSelect.domNode, this.permanentOrderDiv);
	    //	    WidgetHelper.handleCheckBoxEvents(this.invalidatedCheckBox, lang.hitch(this, this.updateWidgetState));
	    this.showInvalidatedCheckBox = this.constructShowCheckBox("invalidated", this.permanentOrderDiv);

	    // StateSelect
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderStateLabel, this.permanentOrderDiv, "propertyLabel planningNotificationReportSearchStateLabel");
	    this.stateSelect = new Select({
		label : i18n.planningNotificationOrderStateLabel,
		title : i18n.planningNotificationOrderStateToolTip
	    });
	    domClass.add(this.stateSelect.domNode, "fixedDialogWidget planningNotificationReportSearchStateSelect");
	    domConstruct.place(this.stateSelect.domNode, this.permanentOrderDiv);
	    //	    WidgetHelper.handleSelectEvents(this.stateSelect, lang.hitch(this, this.updateWidgetState));
	    this.showStateCheckBox = this.constructShowCheckBox("state", this.permanentOrderDiv);

	    // ReferenceTextBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderReferenceLabel, this.permanentOrderDiv, "propertyLabel planningNotificationReportSearchReferenceLabel");
	    this.referenceTextBox = new TextBox({
							label : i18n.planningNotificationOrderReferenceLabel,
							title : i18n.planningNotificationOrderSearchReferenceToolTip,
            		selectOnClick : true
	    });
	    domClass.add(this.referenceTextBox.domNode, "fixedDialogWidget planningNotificationReportSearchReferenceTextBox");
	    domConstruct.place(this.referenceTextBox.domNode, this.permanentOrderDiv);
	    on(this.referenceTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
	    //	    WidgetHelper.handleTextBoxEvents(this.referenceTextBox, lang.hitch(this, this.updateWidgetState));
	    this.showReferenceCheckBox = this.constructShowCheckBox("reference", this.permanentOrderDiv);
	},

	constructOptionalOrderWidgets : function(idToWorkflowNodeTemplate) {
	    this.optionalOrderDiv = domConstruct.create("div", null, null);
	    domClass.add(this.optionalOrderDiv, "refNodeOfPositionAbsolute planningNotificationReportSearchOptionalOrderDiv");
	    domConstruct.place(this.optionalOrderDiv, this.contentDiv);

	    // StatutoryDutyFromFromDateTimeSpinBox
	    var statutoryDutyFromLabel = string.substitute(i18n.searchFrom, { label : i18n.planningNotificationOrderSearchStatutoryDutyFromFromLabel });
	    DOMHelper.createTextNode("div", statutoryDutyFromLabel, this.optionalOrderDiv, "propertyLabel planningNotificationReportSearchStatutoryDutyFromFromLabel");
	    this.statutoryDutyFromFromSpinner = new CalendarSpinner({
			    label : i18n.statutoryDutyFromLabel,
			    title : i18n.planningNotificationOrderSearchStatutoryDutyFromFromToolTip,
			  pattern : i18n.datePattern,
			 timeZone : this.applicationContext.getTimeZone(),
		       dndEnabled : false,
		rowObjectToString : null
	    });
	    domClass.add(this.statutoryDutyFromFromSpinner.domNode, "fixedDialogWidget planningNotificationReportSearchStatutoryDutyFromFromSpinner");
	    domConstruct.place(this.statutoryDutyFromFromSpinner.domNode, this.optionalOrderDiv);
	    on(this.statutoryDutyFromFromSpinner.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
	    WidgetHelper.handleSpinnerEvents(this.statutoryDutyFromFromSpinner, lang.hitch(this, this.updateWidgetState));

	    // StatutoryDutyFromToDateTimeSpinBox
	    DOMHelper.createTextNode("div", i18n.searchTo, this.optionalOrderDiv,
			             "propertyLabel planningNotificationReportSearchStatutoryDutyFromToLabel");
	    this.statutoryDutyFromToSpinner = new CalendarSpinner({
			    label : i18n.searchTo,
			    title : i18n.planningNotificationOrderSearchStatutoryDutyFromToToolTip,
			  pattern : i18n.datePattern,
			 timeZone : this.applicationContext.getTimeZone(),
		       dndEnabled : false,
		rowObjectToString : null
	    });
	    domClass.add(this.statutoryDutyFromToSpinner.domNode, "fixedDialogWidget planningNotificationReportSearchStatutoryDutyFromToSpinner");
	    domConstruct.place(this.statutoryDutyFromToSpinner.domNode, this.optionalOrderDiv);
	    on(this.statutoryDutyFromToSpinner.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
	    WidgetHelper.handleSpinnerEvents(this.statutoryDutyFromToSpinner, lang.hitch(this, this.updateWidgetState));
	    this.showStatutoryDutyFromCheckBox = this.constructShowCheckBox("statutoryDutyFrom", this.optionalOrderDiv);

	    // DocumentPageTextBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderDocumentPageLabel, this.optionalOrderDiv,
			             "propertyLabel planningNotificationReportSearchDocumentPageLabel");
	    this.documentPageTextBox = new TextBox({
							label : i18n.planningNotificationOrderDocumentPageLabel,
							title : i18n.planningNotificationOrderDocumentPageToolTip,
            		selectOnClick : true
	    });
	    domClass.add(this.documentPageTextBox.domNode, "fixedDialogWidget planningNotificationReportSearchDocumentPageTextBox");
	    domConstruct.place(this.documentPageTextBox.domNode, this.optionalOrderDiv);
	    on(this.documentPageTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
	    WidgetHelper.handleTextBoxEvents(this.documentPageTextBox, lang.hitch(this, this.updateWidgetState));
	    this.showDocumentPageCheckBox = this.constructShowCheckBox("documentPage", this.optionalOrderDiv);

	    // DocumentPositionTextBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderDocumentPositionLabel, this.optionalOrderDiv, "propertyLabel planningNotificationReportSearchDocumentPositionLabel");
	    this.documentPositionTextBox = new TextBox({
							label : i18n.planningNotificationOrderDocumentPositionLabel,
							title : i18n.planningNotificationOrderDocumentPositionToolTip,
            		selectOnClick : true
	    });
	    domClass.add(this.documentPositionTextBox.domNode, "fixedDialogWidget planningNotificationReportSearchDocumentPositionTextBox");
	    domConstruct.place(this.documentPositionTextBox.domNode, this.optionalOrderDiv);
	    on(this.documentPositionTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
	    WidgetHelper.handleTextBoxEvents(this.documentPositionTextBox, lang.hitch(this, this.updateWidgetState));
	    this.showDocumentPositionCheckBox = this.constructShowCheckBox("documentPosition", this.optionalOrderDiv);

	    // SourceTextBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderSourceLabel, this.optionalOrderDiv, "propertyLabel planningNotificationReportSearchSourceLabel");
	    this.sourceTextBox = new TextBox({
							label : i18n.planningNotificationOrderSourceLabel,
							title : i18n.planningNotificationOrderSourceToolTip,
            		selectOnClick : true
	    });
	    domClass.add(this.sourceTextBox.domNode, "fixedDialogWidget planningNotificationReportSearchSourceTextBox");
	    domConstruct.place(this.sourceTextBox.domNode, this.optionalOrderDiv);
	    on(this.sourceTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
	    WidgetHelper.handleTextBoxEvents(this.sourceTextBox, lang.hitch(this, this.updateWidgetState));
	    this.showSourceCheckBox = this.constructShowCheckBox("source", this.optionalOrderDiv);

	    // StatutoryDutyToFromDateTimeSpinBox
	    var statutoryDutyToLabel = string.substitute(i18n.searchFrom, { label : i18n.planningNotificationOrderSearchStatutoryDutyToFromLabel });
	    DOMHelper.createTextNode("div", statutoryDutyToLabel, this.optionalOrderDiv, "propertyLabel planningNotificationReportSearchStatutoryDutyToFromLabel");
	    this.statutoryDutyToFromSpinner = new CalendarSpinner({
			    label : i18n.statutoryDutyToLabel,
			    title : i18n.planningNotificationOrderSearchStatutoryDutyToFromToolTip,
			  pattern : i18n.datePattern,
			 timeZone : this.applicationContext.getTimeZone(),
		       dndEnabled : false,
		rowObjectToString : null
	    });
	    domClass.add(this.statutoryDutyToFromSpinner.domNode, "fixedDialogWidget planningNotificationReportSearchStatutoryDutyToFromSpinner");
	    domConstruct.place(this.statutoryDutyToFromSpinner.domNode, this.optionalOrderDiv);
	    on(this.statutoryDutyToFromSpinner.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
	    WidgetHelper.handleSpinnerEvents(this.statutoryDutyToFromSpinner, lang.hitch(this, this.updateWidgetState));

	    // StatutoryDutyToToDateTimeSpinBox
	    DOMHelper.createTextNode("div", i18n.searchTo, this.optionalOrderDiv,
			             "propertyLabel planningNotificationReportSearchStatutoryDutyToToLabel");
	    this.statutoryDutyToToSpinner = new CalendarSpinner({
			    label : i18n.searchTo,
			    title : i18n.planningNotificationOrderSearchStatutoryDutyToToToolTip,
			  pattern : i18n.datePattern,
			 timeZone : this.applicationContext.getTimeZone(),
		       dndEnabled : false,
		rowObjectToString : null
	    });
	    domClass.add(this.statutoryDutyToToSpinner.domNode, "fixedDialogWidget planningNotificationReportSearchStatutoryDutyToToSpinner");
	    domConstruct.place(this.statutoryDutyToToSpinner.domNode, this.optionalOrderDiv);
	    on(this.statutoryDutyToToSpinner.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
	    WidgetHelper.handleSpinnerEvents(this.statutoryDutyToToSpinner, lang.hitch(this, this.updateWidgetState));
	    this.showStatutoryDutyToCheckBox = this.constructShowCheckBox("statutoryDutyTo", this.optionalOrderDiv);

	    // PersonInChargeSelect
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderPersonInChargeLabel, this.optionalOrderDiv,
			             "propertyLabel planningNotificationReportSearchPersonInChargeLabel");
	    this.personInChargeSelect = new Select({
		label : i18n.planningNotificationOrderPersonInChargeLabel,
		title : i18n.planningNotificationOrderPersonInChargeToolTip
	    });
	    domClass.add(this.personInChargeSelect.domNode, "fixedDialogWidget planningNotificationReportSearchPersonInChargeSelect");
	    domConstruct.place(this.personInChargeSelect.domNode, this.optionalOrderDiv);
	    WidgetHelper.handleSelectEvents(this.personInChargeSelect, lang.hitch(this, this.updateWidgetState));
	    this.showPersonInChargeCheckBox = this.constructShowCheckBox("personInCharge", this.optionalOrderDiv);

	    // IntervalNumberSpinner
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderSearchIntervalLabel, this.optionalOrderDiv,
			             "propertyLabel planningNotificationReportSearchIntervalLabel");
	    this.intervalSpinner = new NumberSpinner({
		label : i18n.planningNotificationOrderSearchIntervalLabel,
		title : i18n.planningNotificationOrderSearchIntervalToolTip
	    });
	    domClass.add(this.intervalSpinner.domNode, "fixedDialogWidget planningNotificationReportSearchIntervalSpinner");
	    domConstruct.place(this.intervalSpinner.domNode, this.optionalOrderDiv);
	    on(this.intervalSpinner.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
	    WidgetHelper.handleSpinnerEvents(this.intervalSpinner, lang.hitch(this, this.updateWidgetState));
	    this.showStatutoryDutyIntervalCheckBox = this.constructShowCheckBox("interval", this.optionalOrderDiv);

	    // LeadTimeNumberSpinner
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderSearchLeadTimeLabel, this.optionalOrderDiv,
			             "propertyLabel planningNotificationReportSearchLeadTimeLabel");
	    this.leadTimeSpinner = new NumberSpinner({
		label : i18n.planningNotificationOrderSearchLeadTimeLabel,
		title : i18n.planningNotificationOrderSearchLeadTimeToolTip
	    });
	    domClass.add(this.leadTimeSpinner.domNode, "fixedDialogWidget planningNotificationReportSearchLeadTimeSpinner");
	    domConstruct.place(this.leadTimeSpinner.domNode, this.optionalOrderDiv);
	    on(this.leadTimeSpinner.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
	    WidgetHelper.handleSpinnerEvents(this.leadTimeSpinner, lang.hitch(this, this.updateWidgetState));

	    this.showStatutoryDutyLeadTimeCheckBox = this.constructShowCheckBox("leadTime", this.optionalOrderDiv);

	    // TagTextBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderSearchTagLabel, this.optionalOrderDiv, "propertyLabel planningNotificationReportSearchTagLabel");
	    this.tagTextBox = new TextBox({
							label : i18n.planningNotificationOrderSearchTagLabel,
							title : i18n.planningNotificationOrderSearchTagToolTip,
            		selectOnClick : true
	    });
	    domClass.add(this.tagTextBox.domNode, "fixedDialogWidget planningNotificationReportSearchTagTextBox");
	    domConstruct.place(this.tagTextBox.domNode, this.optionalOrderDiv);
	    on(this.tagTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
	    WidgetHelper.handleTextBoxEvents(this.tagTextBox, lang.hitch(this, this.updateWidgetState));
	    this.showTagCheckBox = this.constructShowCheckBox("tag", this.optionalOrderDiv);

	    // StatutoryDutyExpiredCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderStatutoryDutyExpiredLabel, this.optionalOrderDiv,
			             "propertyLabel planningNotificationReportSearchStatutoryDutyExpiredLabel");
	    this.statutoryDutyExpiredSelect = WidgetFactory.constructBooleanSelect();
	    this.statutoryDutyExpiredSelect.set("label", i18n.planningNotificationOrderStatutoryDutyExpiredLabel);
	    this.statutoryDutyExpiredSelect.set("title", i18n.planningNotificationOrderStatutoryDutyExpiredToolTip);
	    domClass.add(this.statutoryDutyExpiredSelect.domNode, "fixedDialogWidget planningNotificationReportSearchStatutoryDutyExpiredSelect");
	    domConstruct.place(this.statutoryDutyExpiredSelect.domNode, this.optionalOrderDiv);
	    WidgetHelper.handleCheckBoxEvents(this.statutoryDutyExpiredSelect, lang.hitch(this, this.updateWidgetState));
	    this.showStatutoryDutyExpiredCheckBox = this.constructShowCheckBox("statutoryDutyExpired", this.optionalOrderDiv);

	    // SubmitAuthorityCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderSubmitAuthorityLabel, this.optionalOrderDiv,
			             "propertyLabel planningNotificationReportSearchSubmitAuthorityLabel");
	    this.submitAuthoritySelect = WidgetFactory.constructBooleanSelect();
	    this.submitAuthoritySelect.set("label", i18n.planningNotificationOrderSubmitAuthorityLabel);
	    this.submitAuthoritySelect.set("title", i18n.planningNotificationOrderSubmitAuthorityToolTip);
	    domClass.add(this.submitAuthoritySelect.domNode, "fixedDialogWidget planningNotificationReportSearchSubmitAuthoritySelect");
	    domConstruct.place(this.submitAuthoritySelect.domNode, this.optionalOrderDiv);
	    WidgetHelper.handleCheckBoxEvents(this.submitAuthoritySelect, lang.hitch(this, this.updateWidgetState));
	    this.showSubmitAuthorityCheckBox = this.constructShowCheckBox("submitAuthority", this.optionalOrderDiv);

	    // CommentTextBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderCommentLabel, this.optionalOrderDiv, "propertyLabel planningNotificationReportSearchCommentLabel");
	    this.orderCommentTextBox = new TextBox({
							label : i18n.planningNotificationOrderCommentLabel,
							title : i18n.planningNotificationOrderCommentToolTip,
            		selectOnClick : true
	    });
	    domClass.add(this.orderCommentTextBox.domNode, "fixedDialogWidget planningNotificationReportSearchCommentTextBox");
	    domConstruct.place(this.orderCommentTextBox.domNode, this.optionalOrderDiv);
	    on(this.orderCommentTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
	    WidgetHelper.handleTextBoxEvents(this.orderCommentTextBox, lang.hitch(this, this.updateWidgetState));
	    this.showOrderCommentCheckBox = this.constructShowCheckBox("orderComment", this.optionalOrderDiv);

		//Erfüllungsprozess:
		//Baulos Vorgabe
	    DOMHelper.createTextNode("div", i18n.planningNotificationReportSearchShowBaulosLabel, this.optionalOrderDiv,
			             "fixedDialogWidget planningNotificationReportSearchOrderBaulosShowLabel");
	    this.orderBaulosTextBox = new TextBox({
							label : i18n.planningNotificationReportSearchShowBaulosLabel,
							title : i18n.planningNotificationReportSearchShowBaulosToolTip,
            		selectOnClick : true
	    });
	    domClass.add(this.orderBaulosTextBox.domNode, "fixedDialogWidget planningNotificationReportSearchOrderBaulosTextBox");
	    domConstruct.place(this.orderBaulosTextBox.domNode, this.optionalOrderDiv);
	    on(this.orderBaulosTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
	    WidgetHelper.handleTextBoxEvents(this.orderBaulosTextBox, lang.hitch(this, this.updateWidgetState));

	    //this.showOrderBaulosCheckBox = this.constructShowCheckBox("orderBaulos", this.optionalOrderDiv);

	    // DueDateFrom
	    DOMHelper.createTextNode("div", i18n.planningNotificationReportSearchDueDateFromLabel, this.optionalOrderDiv, "propertyLabel planningNotificationReportSearchDueDateFromLabel");
	    this.dueDateFromSpinner = new CalendarSpinner({
			    label : i18n.planningNotificationReportSearchDueDateFromLabel,
			    title : i18n.planningNotificationReportSearchDueDateFromToolTip,
			  pattern : i18n.datePattern,
			 timeZone : this.applicationContext.getTimeZone(),
		       dndEnabled : false,
		rowObjectToString : null
	    });
	    domClass.add(this.dueDateFromSpinner.domNode, "fixedDialogWidget planningNotificationReportSearchDueDateFromSpinner");
	    domConstruct.place(this.dueDateFromSpinner.domNode, this.optionalOrderDiv);
	    on(this.dueDateFromSpinner.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
	    WidgetHelper.handleSpinnerEvents(this.dueDateFromSpinner, lang.hitch(this, this.updateWidgetState));

	    // DueDateTo
	    DOMHelper.createTextNode("div", i18n.planningNotificationReportSearchDueDateToLabel, this.optionalOrderDiv, "propertyLabel planningNotificationReportSearchDueDateToLabel");
	    this.dueDateToSpinner = new CalendarSpinner({
			    label : i18n.planningNotificationReportSearchDueDateToLabel,
			    title : i18n.planningNotificationReportSearchDueDateToToolTip,
			  pattern : i18n.datePattern,
			 timeZone : this.applicationContext.getTimeZone(),
		       dndEnabled : false,
		rowObjectToString : null
	    });
	    domClass.add(this.dueDateToSpinner.domNode, "fixedDialogWidget planningNotificationReportSearchDueDateToSpinner");
	    domConstruct.place(this.dueDateToSpinner.domNode, this.optionalOrderDiv);
	    on(this.dueDateToSpinner.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
	    WidgetHelper.handleSpinnerEvents(this.dueDateToSpinner, lang.hitch(this, this.updateWidgetState));

	    // DueDate as text
	    DOMHelper.createTextNode("div", i18n.planningNotificationReportSearchDueDateRemarkLabel, this.optionalOrderDiv,
			             "propertyLabel planningNotificationReportSearchDueDateRemarkLabel");

	    var remarkOptions = [ { label : i18n.whatever, value : CdesVoc.WHATEVER } ];
	    var codeHelperRemarkOptions = CodeHelper.getDueDateRemarkOptions();
	    for (var n = 0; n < codeHelperRemarkOptions.length; n++) {
		remarkOptions.push(codeHelperRemarkOptions[n]);
	    }

	    this.dueDateRemarkSelect = new Select({
		  label : i18n.planningNotificationReportSearchDueDateRemarkLabel,
		  title : i18n.planningNotificationReportSearchDueDateRemarkToolTip,
		options : remarkOptions
	    });
	    domClass.add(this.dueDateRemarkSelect.domNode, "fixedDialogWidget planningNotificationReportSearchDueDateRemarkSelect");
	    domConstruct.place(this.dueDateRemarkSelect.domNode, this.optionalOrderDiv);
	    WidgetHelper.handleSelectEvents(this.dueDateRemarkSelect, lang.hitch(this, this.updateWidgetState));

	    // WorkflowNodePosition person
	    DOMHelper.createTextNode("div", i18n.planningNotificationReportSearchPositionPersonLabel, this.optionalOrderDiv, "propertyLabel planningNotificationReportSearchPositionPersonLabel");

	    this.positionPersonSelect = new ProjectParticipationMultiSelect({
			       label : i18n.planningNotificationReportSearchPositionPersonLabel,
			// Use the tooltip of the PlanningNotificationTitleMultiSearchWidget
			//			title : i18n.planningNotificationReportSearchPositionPersonToolTip,
			 selectClass : "fixedDialogWidget planningNotificationReportMultiSelectSearchSelect",
			defaultValue : CdesVoc.WHATEVER
	    });

	    domClass.add(this.positionPersonSelect.domNode, "fixedDialogWidget planningNotificationReportSearchPositionPersonSelect");
	    domConstruct.place(this.positionPersonSelect.domNode, this.optionalOrderDiv);
	    on(this.positionPersonSelect.domNode, "keyup", lang.hitch(this, this.searchIfEnter));

	    DOMHelper.createTextNode("div", i18n.planningNotificationReportSearchShowWorkflowLabel, this.optionalOrderDiv, "fixedDialogWidget planningNotificationReportSearchShowWorkflowLabel");
	    this.showWorkflowNodeCheckBox = this.constructShowCheckBox("showWorkflow", this.optionalOrderDiv);


	    // EnvironmentallyRelevantCheckBox
	    DOMHelper.createTextNode("div", i18n.planningNotificationOrderEnvironmentallyRelevantLabel, this.optionalOrderDiv,
			             "propertyLabel planningNotificationReportSearchEnvironmentallyRelevantLabel");
	    this.environmentallyRelevantSelect = WidgetFactory.constructBooleanSelect();
	    this.environmentallyRelevantSelect.set("label", i18n.planningNotificationOrderEnvironmentallyRelevantLabel);
	    this.environmentallyRelevantSelect.set("title", i18n.planningNotificationOrderEnvironmentallyRelevantLabel);
	    domClass.add(this.environmentallyRelevantSelect.domNode, "fixedDialogWidget planningNotificationReportSearchEnvironmentallyRelevantSelect");
	    domConstruct.place(this.environmentallyRelevantSelect.domNode, this.optionalOrderDiv);
	    WidgetHelper.handleCheckBoxEvents(this.environmentallyRelevantSelect, lang.hitch(this, this.updateWidgetState));

	    this.showEnvironmentallyRelevantCheckBox = this.constructShowCheckBox("environmentallyRelevant", this.optionalOrderDiv);

	    /* Use this button, or a similar one, if selective hiding of a subset of the fields should be implemented.
            // ToggleOptionalFieldsButton
            this.toggleOptionalFieldsButton = new Button({
            label : i18n.hideAdditionalSearchFieldsButtonCaption,
            title : i18n.hideAdditionalSearchFieldsButtonCaption
        });
            domClass.add(this.toggleOptionalFieldsButton.domNode, "planningNotificationSearchToggleOptionalFieldsButton");
            domConstruct.place(this.toggleOptionalFieldsButton.domNode, this.buttonDiv);
            on(this.toggleOptionalFieldsButton, "click", lang.hitch(this, this.doToggleOptionalFields));
	    */

		//review section
	    this.reviewDiv = domConstruct.create("div", null, null);
	    domClass.add(this.reviewDiv, "refNodeOfPositionAbsolute planningNotificationReportSearchReviewDiv");
	    domConstruct.place(this.reviewDiv, this.contentDiv);

	    DOMHelper.createTextNode("div", i18n.planningNotificationSearchReviewSectionCaption, this.reviewDiv,
			             "fixedDialogWidget planningNotificationReportSearchReviewSectionCaption planningNotificationReportSearchCaption");

	    DOMHelper.createTextNode("div", i18n.planningNotificationReportSearchShowWorkflowNodeNameLabel, this.reviewDiv,
			             "propertyLabel planningNotificationReportSearchWorkflowNodeNameShowLabel");
	    var templateOptions = [{ label : i18n.whatever, value : CdesVoc.WHATEVER }];
	    for (var templateId in idToWorkflowNodeTemplate) {
			templateOptions.push({ label : idToWorkflowNodeTemplate[templateId].name, value : templateId });
	    }

	    this.showWorkflowNodeNameCheckBox = this.constructShowCheckBox("workflowNodeName", this.reviewDiv);
	    this.workflowNodeNameSelect = new Select( {
		  label : i18n.planningNotificationReportSearchShowWorkflowNodeNameLabel,
		options : templateOptions
	    });
	    domClass.add(this.workflowNodeNameSelect.domNode, "fixedDialogWidget planningNotificationReportSearchWorkflowNodeNameSelect");
	    domConstruct.place(this.workflowNodeNameSelect.domNode, this.reviewDiv);
	    on(this.workflowNodeNameSelect.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
	    WidgetHelper.handleTextBoxEvents(this.workflowNodeNameSelect, lang.hitch(this, this.updateWidgetState));

	    DOMHelper.createTextNode("div", i18n.planningNotificationReportSearchShowBaulosLabel, this.reviewDiv,
			             "fixedDialogWidget planningNotificationReportSearchReviewBaulosShowLabel");
	    this.reviewBaulosTextBox = new TextBox({
							label : i18n.planningNotificationReportSearchShowBaulosLabel,
							title : i18n.planningNotificationReportSearchShowReviewerBaulosToolTip,
            		selectOnClick : true
	    });
	    domClass.add(this.reviewBaulosTextBox.domNode, "fixedDialogWidget planningNotificationReportSearchReviewBaulosTextBox");
	    domConstruct.place(this.reviewBaulosTextBox.domNode, this.reviewDiv);
	    on(this.reviewBaulosTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
	    WidgetHelper.handleTextBoxEvents(this.reviewBaulosTextBox, lang.hitch(this, this.updateWidgetState));

	    this.showReviewBaulosCheckBox = this.constructShowCheckBox("reviewBaulos", this.reviewDiv);

	    DOMHelper.createTextNode("div", i18n.planningNotificationReportSearchShowTokenInitiatorLabel, this.reviewDiv,
			             "fixedDialogWidget planningNotificationReportSearchTokenInitiatorShowLabel");
	    this.showTokenInitiatorCheckBox = this.constructShowCheckBox("tokenInitiator", this.reviewDiv);
	    DOMHelper.createTextNode("div", i18n.planningNotificationReportSearchShowReviewerLabel, this.reviewDiv,
			             "fixedDialogWidget planningNotificationReportSearchReviewerShowLabel");
	    this.showReviewerCheckBox = this.constructShowCheckBox("reviewer", this.reviewDiv);
	    DOMHelper.createTextNode("div", i18n.planningNotificationReportSearchShowIssuedLabel, this.reviewDiv,
			             "fixedDialogWidget planningNotificationReportSearchIssuedShowLabel");
	    this.showIssuedCheckBox = this.constructShowCheckBox("issued", this.reviewDiv);
	    DOMHelper.createTextNode("div", i18n.planningNotificationReportSearchShowReviewCommentLabel, this.reviewDiv,
			             "fixedDialogWidget planningNotificationReportSearchReviewCommentShowLabel");
	    this.showReviewCommentCheckBox = this.constructShowCheckBox("reviewComment", this.reviewDiv);
	    DOMHelper.createTextNode("div", i18n.planningNotificationReportSearchShowResultLabel, this.reviewDiv,
			             "fixedDialogWidget planningNotificationReportSearchResultShowLabel");
	    this.showResultCheckBox = this.constructShowCheckBox("result", this.reviewDiv);
	    DOMHelper.createTextNode("div", i18n.planningNotificationReportSearchShowAttachmentLabel, this.reviewDiv,
			             "fixedDialogWidget planningNotificationReportSearchAttachmentShowLabel");
	    this.showAttachmentCheckBox = this.constructShowCheckBox("attachment", this.reviewDiv);

	    this.buttonDiv = domConstruct.create("div", null, null);
	    domClass.add(this.buttonDiv, "refNodeOfPositionAbsolute planningNotificationReportSearchButtonDiv");
	    domConstruct.place(this.buttonDiv, this.contentDiv);

	    // ClearSearchFieldsButton
	    this.clearSearchFieldsButton = new Button({
			label : i18n.clearSearchFieldsButtonCaption,
			title : i18n.clearSearchFieldsButtonToolTip
	    });
	    domClass.add(this.clearSearchFieldsButton.domNode, "fixedDialogWidget planningNotificationReportSearchClearSearchFieldsButton");
	    domConstruct.place(this.clearSearchFieldsButton.domNode, this.buttonDiv);
	    on(this.clearSearchFieldsButton, "click", lang.hitch(this, this.clearSearchFields));

	    // SearchButton
	    this.searchButton = new Button({
			label : i18n.searchButtonCaption,
			title : i18n.planningNotificationSearchSearchButtonToolTip
	    });
	    domClass.add(this.searchButton.domNode, "fixedDialogWidget planningNotificationReportSearchSearchButton");
	    domConstruct.place(this.searchButton.domNode, this.buttonDiv);
	    on(this.searchButton, "click", lang.hitch(this, this.doSearch));
	},

	constructShowCheckBox : function(name, parentDiv) {
	    var capitalizedName = name.substring(0, 1).toUpperCase() + name.substring(1);

	    var checkBox = new CheckBox({
	    });
	    domClass.add(checkBox.domNode, "fixedDialogWidget planningNotificationReportSearch" + capitalizedName + "ShowCheckBox");
	    domConstruct.place(checkBox.domNode, parentDiv);

            WidgetHelper.handleCheckBoxEvents(checkBox, lang.hitch(this, function() {
                ColumnHelper.emitColumnsChangedPN(this.applicationContext, this, "planningNotificationReport/columns", name);
            }));
	    return checkBox;
	},

	emitColumnsChanged : function() {
	    ColumnHelper.emitColumnsChangedPN(this.applicationContext, this, "/planningNotificationReport/columns");
	},

	isAlreadyInitialized : function() {
	    return this.initialized;
	},

	updateWidgetState : function() {
	    if(this.clearSearchFieldsButton != null) {
		this.clearSearchFieldsButton.set("disabled", !!this.disabled);
	    }

	    if (this.searchButton != null) {
		this.searchButton.set("disabled", !!this.disabled);
	    }
	},

	handleProjectSelectChange : function() {
            var selectedProjectId = WidgetHelper.getSelectValue(this.projectSelect);
            var projectChanged = selectedProjectId != this.lastProjectId;
	    var currentProjectId = this.lastProjectId;
		this.lastProjectId = PlanningNotificationHelper.handleProjectSelectChange(this.projectSelect, this.planningNotificationMultiComboBox, this.projectIdToPlanningNotifications, currentProjectId, !projectChanged || !this.projectSelectAlreadyChanged);
		this.lastProjectId = PlanningNotificationHelper.handleProjectSelectChangeProjectParticipation(this.projectSelect, this.positionPersonSelect, this.projectIdToProjectParticipationJoins, currentProjectId, !projectChanged || !this.projectSelectAlreadyChanged);

		// The very first call to this function is caused by loading the initial config from local storage.
		// In this situation we want to preserve the document search widget.
		this.projectSelectAlreadyChanged = true;
	},

	processProjectChange : function(projectIdToProject, initialProjectId) {
		PlanningNotificationHelper.processProjectChange({
			projectSelect : this.projectSelect,
			projectIdToProject : projectIdToProject,
			initialProjectId   : initialProjectId,
			addWhateverOption : false,
			noWhateverDefault : false
		});
		var currentProjectId = this.lastProjectId;
		this.lastProjectId = PlanningNotificationHelper.handleProjectSelectChange(this.projectSelect, this.planningNotificationMultiComboBox, this.projectIdToPlanningNotifications, currentProjectId);
	},

	getSelectedProjectId : function() {
	    var projectId = WidgetHelper.getSelectValue(this.projectSelect);
	    if (projectId == CdesVoc.WHATEVER) {
		return null;
	    } else {
		return projectId;
	    }
	},

	initialize : function(metaTags, searchInfo, firstCall) {
		var projectIdToProject = searchInfo.projectIdToProject;
		var idToWorkflowNodeTemplate = searchInfo.idToWorkflowNodeTemplate;
		this.projectIdToPlanningNotifications = searchInfo.projectIdToPlanningNotifications;
		this.projectIdToProjectParticipationJoins = searchInfo.projectIdToProjectParticipationJoins;

		var initialProjectId = CdesVoc.WHATEVER;
		if (this.config.data.notificationSearchModel.projectId != null)
			initialProjectId = this.config.data.notificationSearchModel.projectId;

		if (!this.initialized && metaTags != null) {
			// This case is triggered while setting up the widget.
			this.fillContentDiv(metaTags, projectIdToProject, idToWorkflowNodeTemplate);
		}
		this.processProjectChange(projectIdToProject, initialProjectId);

	    var personInChargeOptions = WidgetHelper.getSelectOptionsForMap(searchInfo.idToPersonInCharge, "name",
					                                    { label : i18n.whatever, value : CdesVoc.WHATEVER });
	    WidgetHelper.setSelectOptionsAndKeepLabelIfPossible(this.personInChargeSelect, personInChargeOptions);

	    var statutoryDutyOptions = WidgetHelper.getSelectOptionsForMap(searchInfo.idToStatutoryDuty, "name",
					                                   { label : i18n.whatever, value : CdesVoc.WHATEVER });
	    WidgetHelper.setSelectOptionsAndKeepLabelIfPossible(this.statutoryDutySelect, statutoryDutyOptions);

	    var subjectAreaOptions = WidgetHelper.getSelectOptionsForMap(searchInfo.idToSubjectArea, "name");
        subjectAreaOptions.splice(0, 0, { label: i18n.allOption, value : CdesVoc.MagicSelectOption.ALL });
	    WidgetHelper.setComboBoxOptions(this.subjectAreaComboBox, subjectAreaOptions);

	    var stateOptions = [
				{ label : i18n.whatever, value : CdesVoc.WHATEVER },
				{ label : i18n.workflowStatusNotInitialized, value : CdesVoc.WORKFLOW_ENTITIY_STATUS_NOT_INITIALIZED }
	    ];
	    var stateInstances = [];
	    for (var id in searchInfo.idToWorkflowEntityStatus) {
			stateInstances.push(searchInfo.idToWorkflowEntityStatus[id]);
	    }

	    stateInstances.sort(function(instanceOne, instanceTwo) {
			return instanceOne.id - instanceTwo.id;
	    });
	    for (var v = 0; v < stateInstances.length; v++) {
		stateOptions.push({ label : stateInstances[v].name, value : stateInstances[v].id });
	    }

	    WidgetHelper.setSelectOptionsAndKeepLabelIfPossible(this.stateSelect, stateOptions);

		var currentProjectId = null;
		this.lastProjectId = PlanningNotificationHelper.handleProjectSelectChangeProjectParticipation(this.projectSelect, this.positionPersonSelect, this.projectIdToProjectParticipationJoins, currentProjectId);

	    if (firstCall) {
			this.personInChargeSelect.set("value", CdesVoc.WHATEVER);
			this.statutoryDutySelect.set("value", CdesVoc.WHATEVER);
			this.stateSelect.set("value", CdesVoc.WHATEVER);
	    }

	    this.updateOptionalFieldVisibility();

	    this.initialized = true;
        this.planningNotificationMultiComboBox.initialized = true;
        this.positionPersonSelect.initialized = true;
	    this.reload();
	},

	searchIfEnter : function(e) {
	    if (e.keyCode == Keys.ENTER) {
		this.doSearch();
	    }
	},

	updateShowOptionalFieldsButtonCaption : function() {
	    var count = 0;

	    for (var metaTagId in this.idToMetaTagInfo) {
		var metaTagInfo = this.idToMetaTagInfo[metaTagId];
		var metaTag = metaTagInfo.metaTag;
		var priority = metaTag.priority;
		var tagFormat = metaTag.tagFormat;

		if (priority == 1) {  // optional search fields

		    if (tagFormat == CdesVoc.TagFormat.TEXT) {
			if (metaTagInfo.primaryWidget != null) {
			    var text = metaTagInfo.primaryWidget.get("value");
			    count += text != null && text.trim().length > 0 ? 1 : 0;
			}
		    } else if (tagFormat == CdesVoc.TagFormat.DATE) {
			if (metaTagInfo.primaryWidget != null) {
			    count += metaTagInfo.primaryWidget.getUtcSeconds() != null ? 1 : 0;
			}

			if (metaTagInfo.secondaryWidget != null) {
			    count += metaTagInfo.secondaryWidget.getUtcSeconds() != null ? 1 : 0;
			}
		    } else {
			throw new Error("Unsupported tagFormat [" + tagFormat + "]");
		    }
		}
	    }

	    if (count == 0) {
		this.toggleOptionalFieldsButton.set("label", i18n.showAdditionalSearchFieldsButtonCaption);
		this.toggleOptionalFieldsButton.set("title", i18n.showAdditionalSearchFieldsButtonCaption);
	    } else {
		var showCaption = string.substitute(i18n.showNumberedAdditionalSearchFieldsButtonCaption, {
		    countActive : count
		});
		this.toggleOptionalFieldsButton.set("label", showCaption);
		this.toggleOptionalFieldsButton.set("title", showCaption);
	    }
	},

	clearSearchFields : function() {
	    this.planningNotificationMultiComboBox.set("value", [], false);
	    this.notificationCommentTextBox.set("value", "");
            //			Deliberately no reset
	    //            this.projectSelect.set("value", CdesVoc.WHATEVER);

	    for (var metaTagId in this.idToMetaTagInfo) {
		var metaTagInfo = this.idToMetaTagInfo[metaTagId];
		var metaTag = metaTagInfo.metaTag;
		var tagFormat = metaTag.tagFormat;

		if (tagFormat == CdesVoc.TagFormat.TEXT) {
		    if (metaTagInfo.primaryWidget != null) {
			metaTagInfo.primaryWidget.set("value", "");
		    }
		} else if (tagFormat == CdesVoc.TagFormat.DATE) {
		    if (metaTagInfo.primaryWidget != null) {
			metaTagInfo.primaryWidget.setUtcSeconds(null);
		    }

		    if (metaTagInfo.secondaryWidget != null) {
			metaTagInfo.secondaryWidget.setUtcSeconds(null);
		    }
		} else {
		    throw new Error("Unsupported tagFormat [" + tagFormat + "]");
		}
	    }

	    this.serialNumberSpinner.set("value", null, false);
	    this.textTextBox.set("value", "", false);
        SearchPageHelper.setComboBoxValue(this.subjectAreaComboBox, CdesVoc.MagicSelectOption.ALL);
	    this.authorizedInspectorTextBox.set("value", "", false);
	    this.statutoryDutySelect.set("value", CdesVoc.WHATEVER, false);
	    this.invalidatedSelect.set("value", CdesVoc.WHATEVER, false);
	    this.stateSelect.set("value", CdesVoc.WHATEVER, false);
	    this.referenceTextBox.set("value", "", false);
	    this.environmentallyRelevantSelect.set("value", CdesVoc.WHATEVER, false);

	    this.statutoryDutyFromFromSpinner.setUtcSeconds(null);
	    this.statutoryDutyFromToSpinner.setUtcSeconds(null);
	    this.documentPageTextBox.set("value", "", false);
	    this.documentPositionTextBox.set("value", "", false);
	    this.sourceTextBox.set("value", "", false);
	    this.statutoryDutyToFromSpinner.setUtcSeconds(null);
	    this.statutoryDutyToToSpinner.setUtcSeconds(null);
	    this.personInChargeSelect.set("value", CdesVoc.WHATEVER, false);
	    this.intervalSpinner.set("value", null, false);
	    this.leadTimeSpinner.set("value", null, false);
	    this.tagTextBox.set("value", "", false);
	    this.statutoryDutyExpiredSelect.set("value", CdesVoc.WHATEVER, false);
	    this.submitAuthoritySelect.set("value", CdesVoc.WHATEVER, false);
	    this.orderCommentTextBox.set("value", "", false);
	    this.orderBaulosTextBox.set("value", "", false);
	    this.dueDateFromSpinner.setUtcSeconds(null);
	    this.dueDateToSpinner.setUtcSeconds(null);
	    this.dueDateRemarkSelect.set("value", CdesVoc.WHATEVER, false);
	    this.positionPersonSelect.set("value", [ CdesVoc.WHATEVER ], false);

	    this.workflowNodeNameSelect.set("value", CdesVoc.WHATEVER, false);
	    this.reviewBaulosTextBox.set("value", "", false);

	    this.handleProjectSelectChange();

	    this.updateOptionalFieldVisibility();
	},

	getSearchModel : function() {
	    var planningNotificationEntries = this.planningNotificationMultiComboBox.get("value");
	    var comment = this.notificationCommentTextBox.get("value");

	    var networkId = this.applicationContext.getPageContextPnNetworkId();
	    var selectedProjectValue = WidgetHelper.getSelectValue(this.projectSelect);

	    var textMetaTagIdToValue = new Object();
	    var dateMetaTagIdToFrom = new Object();
	    var dateMetaTagIdToTo = new Object();

	    for (var id in this.idToMetaTagInfo) {
		var metaTagInfo = this.idToMetaTagInfo[id];
		var metaTag = metaTagInfo.metaTag;
		if (metaTag.tagFormat == 0) {         // TAG_FORMAT_TEXT
		    textMetaTagIdToValue[id] = metaTagInfo.primaryWidget.get("value");
		} else if (metaTag.tagFormat == 1) {  // TAG_FORMAT_DATE
		    dateMetaTagIdToFrom[id] = metaTagInfo.primaryWidget.getUtcSeconds();
		    dateMetaTagIdToTo[id] = metaTagInfo.secondaryWidget.getUtcSeconds();
		} else {
		    throw new Error("TagFormat [" + metaTag.tagFormat + "] is not yet supported, see at.cdes.oldGwtDto.MetaTagDTO");
		}
	    }

	    var searchModel = {
		planningNotificationEntries : planningNotificationEntries,
				   comment : comment,
		      organisationPersonId : this.applicationContext.getPageContextOrganisationPersonId(),
				 networkId : networkId,
				 projectId : selectedProjectValue == CdesVoc.WHATEVER ? null : selectedProjectValue,
		      textMetaTagIdToValue : textMetaTagIdToValue,
		       dateMetaTagIdToFrom : dateMetaTagIdToFrom,
			 dateMetaTagIdToTo : dateMetaTagIdToTo
	    };

	    return searchModel;
	},

	doToggleOptionalFields : function() {
	    this.optionalFieldsVisible = !this.optionalFieldsVisible;

	    var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
	    var networkId = this.applicationContext.getPageContextPnNetworkId();
	    this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotificationReport/optionalSearchFieldsVisible", this.optionalFieldsVisible);

	    this.updateOptionalFieldVisibility();
	},

	updateOptionalFieldVisibility : function() {
	    /*
            if (this.optionalFieldsVisible) {
            domClass.replace(this.optionalDiv, "visible", "hidden");
            this.toggleOptionalFieldsButton.set("label", i18n.hideAdditionalSearchFieldsButtonCaption);
            this.toggleOptionalFieldsButton.set("title", i18n.hideAdditionalSearchFieldsButtonCaption);
            domClass.replace(this.topDiv, "planningNotificationSearchFullWithOptional", "planningNotificationSearchFull planningNotificationSearchReduced");
        } else {
            domClass.replace(this.optionalDiv, "hidden", "visible");
	    this.updateShowOptionalFieldsButtonCaption();
            domClass.replace(this.topDiv, "planningNotificationSearchFull", "planningNotificationSearchFullWithOptional planningNotificationSearchReduced");
        }
            on.emit(this, "titlePaneToggled");
	    */
	},

	doSearch : function() {
	    on.emit(this, "doSearch");
	},

	getColumnSettings : function() {
	    return this.columnSettings;
	},

	setData : function(config) {
            // Suppress clearing the document combobox because the code things that the project changed, but in fact
            // we just reset the search widget from outside.
            this.projectSelectAlreadyChanged = false;

	    this.config = config;
	    this.reload();
	},

	reload : function() {
	    if (this.initialized) {
			this.updateWidgetsFromData();
	    }
	},

	updateWidgetsFromData : function() {
	    if (this.config.data == null) {
			this.config.data = new Object();
	    }

	    if (this.config.data.notificationSearchModel == null) {
			this.config.data.notificationSearchModel = new Object();
	    }

	    if (this.config.data.orderSearchModel == null) {
			this.config.data.orderSearchModel = new Object();
	    }
        if (this.config.data.orderSearchModel.subjectAreaId == null) {
            this.config.data.orderSearchModel.subjectAreaId = CdesVoc.MagicSelectOption.ALL;
        }

	    if (this.config.data.reviewSearchModel == null) {
			this.config.data.reviewSearchModel = new Object();
	    }

	    if (this.config.data.columnSettings == null) {
			this.config.data.columnSettings = new Object();
	    }

	    // notificationSearchModel
	    var notificationSearchModel = this.config.data.notificationSearchModel;
	    this.planningNotificationMultiComboBox.set("value", notificationSearchModel.planningNotificationEntries);
	    this.notificationCommentTextBox.set("value", notificationSearchModel.comment);

		var projectId = notificationSearchModel.projectId == null ? CdesVoc.WHATEVER : notificationSearchModel.projectId;
		WidgetHelper.setSelectValue(this.projectSelect, projectId);

	    for (var textMetaTagId in notificationSearchModel.textMetaTagIdToValue) {
			if (textMetaTagId in this.idToMetaTagInfo) {
			    var metaTagInfo = this.idToMetaTagInfo[textMetaTagId];
			    metaTagInfo.primaryWidget.set("value", notificationSearchModel.textMetaTagIdToValue[textMetaTagId]);
			}
	    }

	    for (var dateMetaTagId in notificationSearchModel.dateMetaTagIdToFrom) {
			if (dateMetaTagId in this.idToMetaTagInfo) {
			    var metaTagInfoDate = this.idToMetaTagInfo[dateMetaTagId];
			    metaTagInfoDate.primaryWidget.setUtcSeconds(notificationSearchModel.dateMetaTagIdToFrom[dateMetaTagId]);
			}
	    }

	    for (var dateTwoMetaTagId in notificationSearchModel.dateMetaTagIdToTo) {
			if (dateTwoMetaTagId in this.idToMetaTagInfo) {
			    var metaTagInfoTwo = this.idToMetaTagInfo[dateTwoMetaTagId];
			    metaTagInfoTwo.secondaryWidget.setUtcSeconds(notificationSearchModel.dateMetaTagIdToTo[dateTwoMetaTagId]);
			}
	    }

		// orderSearchModel
		var orderSearchModel = this.config.data.orderSearchModel;
		this.serialNumberSpinner.set("value", orderSearchModel.serialNumber);
		this.subjectAreaComboBox.set("value", orderSearchModel.subjectAreaName);

		SearchPageHelper.setSearchModelValueToAllableComboBox(orderSearchModel, this.subjectAreaComboBox,
                                                              "subjectAreaId", "subjectAreaName");

		WidgetFactory.setBooleanSelectValue(this.invalidatedSelect, orderSearchModel.invalidated);
		WidgetHelper.setSelectValue(this.stateSelect, orderSearchModel.state);

		this.referenceTextBox.set("value", orderSearchModel.reference);
		if (orderSearchModel.statutoryDutyId != null) {
			WidgetHelper.setSelectValue(this.statutoryDutySelect, orderSearchModel.statutoryDutyId);
		} else {
			WidgetHelper.setSelectValue(this.statutoryDutySelect, CdesVoc.WHATEVER);
		}
        if (orderSearchModel.allStatutoryDuties) {
            WidgetHelper.setSelectValue(this.statutoryDutySelect, "_ALL_");
        }

	    this.textTextBox.set("value", orderSearchModel.text);
	    this.authorizedInspectorTextBox.set("value", orderSearchModel.authorizedInspector);
	    this.statutoryDutyFromFromSpinner.setUtcSeconds(orderSearchModel.statutoryDutyFromFrom);
	    this.statutoryDutyFromToSpinner.setUtcSeconds(orderSearchModel.statutoryDutyFromTo);
	    this.statutoryDutyToFromSpinner.setUtcSeconds(orderSearchModel.statutoryDutyToFrom);
	    this.statutoryDutyToToSpinner.setUtcSeconds(orderSearchModel.statutoryDutyToTo);
	    this.intervalSpinner.set("value", orderSearchModel.statutoryDutyInterval);
	    this.leadTimeSpinner.set("value", orderSearchModel.statutoryDutyLeadTime);
	    WidgetFactory.setBooleanSelectValue(this.statutoryDutyExpiredSelect, orderSearchModel.statutoryDutyExpired);
	    this.documentPageTextBox.set("value", orderSearchModel.documentPage);
	    this.documentPositionTextBox.set("value", orderSearchModel.documentPosition);
	    this.sourceTextBox.set("value", orderSearchModel.source);
	    WidgetHelper.setSelectValue(this.personInChargeSelect, orderSearchModel.personInChargeId);
	    this.tagTextBox.set("value", orderSearchModel.tags);
	    WidgetFactory.setBooleanSelectValue(this.submitAuthoritySelect, orderSearchModel.submitAuthority);
	    this.orderCommentTextBox.set("value", orderSearchModel.comment);
	    this.orderBaulosTextBox.set("value", orderSearchModel.baulos);
	    this.dueDateFromSpinner.setUtcSeconds(orderSearchModel.dueDateFrom);
	    this.dueDateToSpinner.setUtcSeconds(orderSearchModel.dueDateTo);
	    this.dueDateRemarkSelect.set("value", orderSearchModel.dueDateRemark);
	    this.positionPersonSelect.set("value", orderSearchModel.organisationPersonIds);
	    WidgetFactory.setBooleanSelectValue(this.environmentallyRelevantSelect, orderSearchModel.environmentallyRelevant);

	    // reviewSearchModel
	    var reviewSearchModel = this.config.data.reviewSearchModel;
	    WidgetHelper.setSelectValue(this.workflowNodeNameSelect, reviewSearchModel.workflowNodeTemplateId);
	    this.reviewBaulosTextBox.set("value", reviewSearchModel.baulos);

	    // columnSettings
	    var columnSettings = this.config.data.columnSettings;

	    this.showTitleCheckBox.set("checked", !!columnSettings.showTitle);
	    this.showNotificationCommentCheckBox.set("checked", !!columnSettings.showNotificationComment);
	    this.showProjectCheckBox.set("checked", !!columnSettings.showProject);

	    for (var metaTagId in this.idToMetaTagInfo) {
		var metaTagInfo = this.idToMetaTagInfo[metaTagId];
		metaTagInfo.showCheckBox.set("checked", columnSettings.metaTagIdToShow != null && !!columnSettings.metaTagIdToShow[metaTagId]);
	    }

	    this.showSerialNumberCheckBox.set("checked", !!columnSettings.showSerialNumber);
	    this.showTextCheckBox.set("checked", !!columnSettings.showText);
	    this.showSubjectAreaCheckBox.set("checked", !!columnSettings.showSubjectArea);
	    this.showAuthorizedInspectorCheckBox.set("checked", !!columnSettings.showAuthorizedInspector);
	    this.showReferenceCheckBox.set("checked", !!columnSettings.showReference);
	    this.showStatutoryDutyCheckBox.set("checked", !!columnSettings.showStatutoryDuty);
	    this.showInvalidatedCheckBox.set("checked", !!columnSettings.showInvalidated);
            //			this.showWorkflowNodeCheckBox.set("checked", this.columnSettings.showWorkflowNode);
	    this.showStateCheckBox.set("checked", !!columnSettings.showState);
	    this.showDocumentPageCheckBox.set("checked", !!columnSettings.showDocumentPage);
	    this.showDocumentPositionCheckBox.set("checked", !!columnSettings.showDocumentPosition);
	    this.showSourceCheckBox.set("checked", !!columnSettings.showSource);
	    this.showPersonInChargeCheckBox.set("checked", !!columnSettings.showPersonInCharge);
	    this.showStatutoryDutyFromCheckBox.set("checked", !!columnSettings.showStatutoryDutyFrom);
	    this.showStatutoryDutyToCheckBox.set("checked", !!columnSettings.showStatutoryDutyTo);
	    this.showStatutoryDutyIntervalCheckBox.set("checked", !!columnSettings.showStatutoryDutyInterval);
	    this.showStatutoryDutyLeadTimeCheckBox.set("checked", !!columnSettings.showStatutoryDutyLeadTime);
	    this.showStatutoryDutyExpiredCheckBox.set("checked", !!columnSettings.showStatutoryDutyExpired);
	    this.showSubmitAuthorityCheckBox.set("checked", !!columnSettings.showSubmitAuthority);
	    this.showTagCheckBox.set("checked", !!columnSettings.showTag);
	    this.showOrderCommentCheckBox.set("checked", !!columnSettings.showOrderComment);
	    this.showWorkflowNodeCheckBox.set("checked", !!columnSettings.showWorkflowNode);
	    this.showEnvironmentallyRelevantCheckBox.set("checked", !!columnSettings.showEnvironmentallyRelevant);

	    this.showWorkflowNodeNameCheckBox.set("checked", !!columnSettings.showWorkflowNodeName);
	    this.showReviewBaulosCheckBox.set("checked", !!columnSettings.showReviewBaulos);
	    this.showTokenInitiatorCheckBox.set("checked", !!columnSettings.showTokenInitiator);
	    this.showReviewerCheckBox.set("checked", !!columnSettings.showReviewer);
	    this.showIssuedCheckBox.set("checked", !!columnSettings.showIssued);
	    this.showReviewCommentCheckBox.set("checked", !!columnSettings.showReviewComment);
	    this.showResultCheckBox.set("checked", !!columnSettings.showResult);
	    this.showAttachmentCheckBox.set("checked", !!columnSettings.showAttachment);
	},

	updateDataFromWidgets : function() {
	    // notificationSearchModel
	    var notificationSearchModel = this.config.data.notificationSearchModel;
	    notificationSearchModel.planningNotificationEntries = this.planningNotificationMultiComboBox.get("value");
	    notificationSearchModel.comment = this.notificationCommentTextBox.get("value");
	    notificationSearchModel.networkId = this.applicationContext.getPageContextPnNetworkId();
	    var selectedProjectValue = WidgetHelper.getSelectValue(this.projectSelect);
	    notificationSearchModel.projectId = selectedProjectValue == CdesVoc.WHATEVER ? null : selectedProjectValue;

	    notificationSearchModel.textMetaTagIdToValue = new Object();
	    notificationSearchModel.dateMetaTagIdToFrom = new Object();
	    notificationSearchModel.dateMetaTagIdToTo = new Object();

	    for (var id in this.idToMetaTagInfo) {
		var metaTagInfo = this.idToMetaTagInfo[id];
		var metaTag = metaTagInfo.metaTag;
		if (metaTag.tagFormat == 0) {         // TAG_FORMAT_TEXT
		    notificationSearchModel.textMetaTagIdToValue[id] = metaTagInfo.primaryWidget.get("value");
		} else if (metaTag.tagFormat == 1) {  // TAG_FORMAT_DATE
		    notificationSearchModel.dateMetaTagIdToFrom[id] = metaTagInfo.primaryWidget.getUtcSeconds();
		    notificationSearchModel.dateMetaTagIdToTo[id] = metaTagInfo.secondaryWidget.getUtcSeconds();
		} else {
		    throw new Error("TagFormat [" + metaTag.tagFormat + "] is not yet supported, see at.cdes.oldGwtDto.MetaTagDTO");
		}
	    }

	    // orderSearchModel
	    var orderSearchModel = this.config.data.orderSearchModel;

	    var selectedPersonInChargeValue = WidgetHelper.getSelectValue(this.personInChargeSelect);
	    var selectedStatutoryDutyValue = WidgetHelper.getSelectValue(this.statutoryDutySelect);
	    var selectedWorkflowEntityStatusValue = WidgetHelper.getSelectValue(this.stateSelect);

	    orderSearchModel.networkId = this.applicationContext.getPageContextPnNetworkId();
	    orderSearchModel.organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
	    orderSearchModel.serialNumber = this.serialNumberSpinner.get("value");
        SearchPageHelper.setAllableComboBoxValueToSearchModel(this.subjectAreaComboBox, orderSearchModel,
                                                                  "subjectAreaId", "subjectAreaName");
	    orderSearchModel.invalidated = WidgetFactory.getBooleanSelectValue(this.invalidatedSelect);
	    orderSearchModel.state = selectedWorkflowEntityStatusValue != CdesVoc.WHATEVER ? selectedWorkflowEntityStatusValue : null;
	    orderSearchModel.planningNotificationEntries = this.planningNotificationMultiComboBox.get("value");
	    orderSearchModel.reference = this.referenceTextBox.get("value");
            if (selectedStatutoryDutyValue == null || selectedStatutoryDutyValue == CdesVoc.WHATEVER) {
                orderSearchModel.statutoryDutyId = null;
                orderSearchModel.allStatutoryDuties = false;
            } else if (selectedStatutoryDutyValue == "_ALL_") {
                orderSearchModel.statutoryDutyId = null;
                orderSearchModel.allStatutoryDuties = true;
            } else {
                orderSearchModel.statutoryDutyId = selectedStatutoryDutyValue;
                orderSearchModel.allStatutoryDuties = false;
            }
	    orderSearchModel.text = this.textTextBox.get("value");
	    orderSearchModel.authorizedInspector = this.authorizedInspectorTextBox.get("value");
	    orderSearchModel.statutoryDutyFromFrom = this.statutoryDutyFromFromSpinner.getUtcSeconds();
	    orderSearchModel.statutoryDutyFromTo = this.statutoryDutyFromToSpinner.getUtcSeconds();
	    orderSearchModel.statutoryDutyToFrom = this.statutoryDutyToFromSpinner.getUtcSeconds();
	    orderSearchModel.statutoryDutyToTo = this.statutoryDutyToToSpinner.getUtcSeconds();
	    orderSearchModel.statutoryDutyInterval = this.intervalSpinner.get("value");
	    orderSearchModel.statutoryDutyLeadTime = this.leadTimeSpinner.get("value");
	    orderSearchModel.statutoryDutyExpired = WidgetFactory.getBooleanSelectValue(this.statutoryDutyExpiredSelect);
	    orderSearchModel.documentPage = this.documentPageTextBox.get("value");
	    orderSearchModel.documentPosition = this.documentPositionTextBox.get("value");
	    orderSearchModel.source = this.sourceTextBox.get("value");
	    orderSearchModel.personInChargeId = selectedPersonInChargeValue != CdesVoc.WHATEVER ? selectedPersonInChargeValue : null;
	    orderSearchModel.tags = this.tagTextBox.get("value");
	    orderSearchModel.submitAuthority = WidgetFactory.getBooleanSelectValue(this.submitAuthoritySelect);
	    orderSearchModel.comment = this.orderCommentTextBox.get("value");
	    orderSearchModel.environmentallyRelevant = WidgetFactory.getBooleanSelectValue(this.environmentallyRelevantSelect);

	    orderSearchModel.baulos = this.orderBaulosTextBox.get("value");
	    if (this.dueDateFromSpinner != null) {
			orderSearchModel.dueDateFrom = this.dueDateFromSpinner.getUtcSeconds();
	    }

	    if (this.dueDateToSpinner != null) {
			orderSearchModel.dueDateTo = this.dueDateToSpinner.getUtcSeconds();
	    }

	    if (this.dueDateRemarkSelect != null) {
			var dueDateRemark = WidgetHelper.getSelectValue(this.dueDateRemarkSelect);
			orderSearchModel.dueDateRemark = dueDateRemark != CdesVoc.WHATEVER ? dueDateRemark : null;
	    }

	    if (this.positionPersonSelect != null) {
			var organisationPersonIds = this.positionPersonSelect.get("value");
			var passedOrganisationPersonIds = [];
			for (var n = 0; n < organisationPersonIds.length; n++) {
			    if (organisationPersonIds[n] != null && organisationPersonIds[n] != CdesVoc.WHATEVER) {
					passedOrganisationPersonIds.push(organisationPersonIds[n]);
			    }
			}
			orderSearchModel.organisationPersonIds = passedOrganisationPersonIds;
	    }

	    var reviewSearchModel = this.config.data.reviewSearchModel;
	    var workflowNodeTemplateId = this.workflowNodeNameSelect.get("value");
	    reviewSearchModel.workflowNodeTemplateId = workflowNodeTemplateId != CdesVoc.WHATEVER ? workflowNodeTemplateId : null;
	    reviewSearchModel.baulos = this.reviewBaulosTextBox.get("value");

	    // columnSettings
	    var columnSettings = this.config.data.columnSettings;
	    columnSettings.showTitle = this.showTitleCheckBox.get("checked");
	    columnSettings.showNotificationComment = this.showNotificationCommentCheckBox.get("checked");
	    columnSettings.showProject = this.showProjectCheckBox.get("checked");
	    columnSettings.showSerialNumber = this.showSerialNumberCheckBox.get("checked");
	    columnSettings.showText = this.showTextCheckBox.get("checked");
	    columnSettings.showSubjectArea = this.showSubjectAreaCheckBox.get("checked");
	    columnSettings.showAuthorizedInspector = this.showAuthorizedInspectorCheckBox.get("checked");
	    columnSettings.showStatutoryDuty = this.showStatutoryDutyCheckBox.get("checked");
	    columnSettings.showInvalidated = this.showInvalidatedCheckBox.get("checked");
	    columnSettings.showState = this.showStateCheckBox.get("checked");
	    columnSettings.showReference = this.showReferenceCheckBox.get("checked");
	    columnSettings.showStatutoryDutyFrom = this.showStatutoryDutyFromCheckBox.get("checked");
	    columnSettings.showDocumentPage = this.showDocumentPageCheckBox.get("checked");
	    columnSettings.showDocumentPosition = this.showDocumentPositionCheckBox.get("checked");
	    columnSettings.showSource = this.showSourceCheckBox.get("checked");
	    columnSettings.showStatutoryDutyTo = this.showStatutoryDutyToCheckBox.get("checked");
	    columnSettings.showPersonInCharge = this.showPersonInChargeCheckBox.get("checked");
	    columnSettings.showStatutoryDutyInterval = this.showStatutoryDutyIntervalCheckBox.get("checked");
	    columnSettings.showStatutoryDutyLeadTime = this.showStatutoryDutyLeadTimeCheckBox.get("checked");
	    columnSettings.showTag = this.showTagCheckBox.get("checked");
	    columnSettings.showStatutoryDutyExpired = this.showStatutoryDutyExpiredCheckBox.get("checked");
	    columnSettings.showSubmitAuthority = this.showSubmitAuthorityCheckBox.get("checked");
	    columnSettings.showOrderComment = this.showOrderCommentCheckBox.get("checked");
	    columnSettings.showWorkflowNode = this.showWorkflowNodeCheckBox.get("checked");
	    columnSettings.showEnvironmentallyRelevant = this.showEnvironmentallyRelevantCheckBox.get("checked");

	    columnSettings.showWorkflowNodeName = this.showWorkflowNodeNameCheckBox.get("checked");
	    columnSettings.showReviewBaulos = this.showReviewBaulosCheckBox.get("checked");
	    columnSettings.showTokenInitiator = this.showTokenInitiatorCheckBox.get("checked");
	    columnSettings.showReviewer = this.showReviewerCheckBox.get("checked");
	    columnSettings.showIssued = this.showIssuedCheckBox.get("checked");
	    columnSettings.showReviewComment = this.showReviewCommentCheckBox.get("checked");
	    columnSettings.showResult = this.showResultCheckBox.get("checked");
	    columnSettings.showAttachment = this.showAttachmentCheckBox.get("checked");

	    // TODO
	    columnSettings.metaTagIdToShow = new Object();
	    for (var metaTagId in this.idToMetaTagInfo) {
		var metaTagInfo = this.idToMetaTagInfo[metaTagId];
		columnSettings.metaTagIdToShow[metaTagId] = !!metaTagInfo.showCheckBox.get("checked");
	    }
	}
    });

    PlanningNotificationReportSearchWidget.AsyncOperation = {

    };

    return PlanningNotificationReportSearchWidget;
});
