/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

define([ 
        "cdes/util/NameHelper",
        "clazzes/TinyLog",
        "clazzes/dgrid/ItemChooseWidget",
        "clazzes/util/DOMHelper",
        "clazzes/widgets/layout/ChooseDialog",
        "clazzes/widgets/layout/ContentWidget",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/on",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"        
], function(
            NameHelper,
            TinyLog,
            ItemChooseWidget,
            DOMHelper,
            ChooseDialog,
            ContentWidget,
            declare,
            lang,
            domClass,
            domConstruct,
            on,
            i18n
            ) {

    var className = "at.cdes.web.person.SimilarPersonChooseDialog";

    var log = new TinyLog(className);

    var SimilarPersonChooseDialog = declare(className, [ChooseDialog, ContentWidget], {

        setData : function(params) {
            this.personJoins = params.personJoins;
            this.personIdToOPJoins = params.personIdToOPJoins;

            for (var n = 0; n < this.personJoins.length; n++) {
                var personJoin = this.personJoins[n];
                var personId = personJoin.personId;
                var opJoins = (personId in this.personIdToOPJoins ? this.personIdToOPJoins[personId] : []);
                personJoin.organisationPersonJoins = opJoins;
            }
        },

        constructChooseWidget : function() {
            this.content = domConstruct.create("div", null, null);
            domClass.add(this.content, "similarPersonChooseTopDiv");

            DOMHelper.createTextNode("div", i18n.similarPersonChooseHeader, this.content, "similarPersonChooseHeader");

            var columns = this.constructColumns();
            this.itemChooseWidget = new ItemChooseWidget({
                applicationContext : this.applicationContext,
                     selectionMode : "single",
                        idProperty : "organisationPersonId",
                           columns : columns
            });     
            var itemWidgetDiv = this.itemChooseWidget.getContainer();
            domConstruct.place(itemWidgetDiv, this.content);
            on(this.itemChooseWidget, "selectionChanged", lang.hitch(this, this.updateWidgetState));

            DOMHelper.createTextNode("div", i18n.similarPersonChooseHintOne, this.content, "similarPersonChooseHeaderHintOne");
            DOMHelper.createTextNode("div", i18n.similarPersonChooseHintTwo, this.content, "similarPersonChooseHeaderHintTwo");
            DOMHelper.createTextNode("div", i18n.similarPersonChooseHintThree, this.content, "similarPersonChooseHeaderHintThree");            

            this.itemChooseWidget.setData(this.personJoins);
            this.itemChooseWidget.resize({ w : 700, h : 100 });
        },

        getChosenPersonJoin : function() {
            var selectedItems = this.itemChooseWidget.getSelectedItems();
            return selectedItems != null && selectedItems.length > 0 ? selectedItems[0] : null;
        },

        constructColumns : function() {
            var columns = [];
            columns.push({
                    field : "organisationPersonId",
                       id : "name",
                formatter : this.nameFormatter,
                 sortable : true,
                    label : i18n.nameLabel
            });
            
            columns.push({
                    field : "organisationPersonId",
                       id : "organisations",
                formatter : this.organisationsFormatter,
                 sortable : true,
                    label : i18n.similarPersonChooseOrganisationsColumnCaption
            });
            return columns;
        },

        nameFormatter : function(organisationPersonId, personJoin) {
            return NameHelper.getPersonInverseCommonName(personJoin, "person");
        },

        organisationsFormatter : function(organisationPersonId, personJoin) {
            var opJoins = personJoin.organisationPersonJoins;
            var html = "";

            for (var n = 0; n < opJoins.length; n++) {
                var opJoin = opJoins[n];
                html += opJoin.organisationName;
                if (n < opJoins.length - 1) {
                    html += "<br>";
                }
            }
            return html;
        },  
        
        updateWidgetState : function() {
			var chosenPersonJoin = this.getChosenPersonJoin();

			this.ignoreNewOrgPersonButton.set("disabled", chosenPersonJoin == null);
        }
    });

    return SimilarPersonChooseDialog;
});
