/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

//// css-prefix = participationList
//// i18n-prefix = participationList

define(["cdes/core/CdesVoc",
        "cdes/util/I18nHelper",
        "cdes/util/NameHelper",
        "cdes/widget/base/ListWidget",
        "clazzes/TinyLog",
        "clazzes/topic",
        "clazzes/util/StringHelper",
        "clazzes/widgets/layout/ContentWidget",
        "dgrid/OnDemandGrid",
        "dgrid/extensions/ColumnResizer",
        "dgrid/extensions/DijitRegistry",
        "dojo/aspect",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/on",
        "dojo/string",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(CdesVoc,
         I18nHelper,
         NameHelper,
         ListWidget,
         TinyLog,
         topic,
         StringHelper,
         ContentWidget,
         OnDemandGrid,
         ColumnResizer,
         DijitRegistry,
         aspect,
         domClass,
         domConstruct,
         on,
         string,
         declare,
         lang,
         i18n) {

    var className = "at.cdes.web.project.ProjectParticipationListWidget";

    var log = new TinyLog(className);

    var ProjectParticipationListWidget = declare(className, ListWidget, {

        dataAttributeName : "participationListJoins",

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "ProjectParticipationListWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        columnWidthKey : "participation/columnWidths",
        defaultColumnWidth : 130,

        columnIdToDefaultWidth : {
            /* TODO
            task : 130,
            serialNumber : 70,
            text : 350,
            planningNotification : 200,
            baulos : 130,
            project : 120,
            subjectArea : 130,
            authorizedInspector : 160,
            reference : 120,
            statutoryDuty : 130,
            documentPosition : 200,
            documentPage : 80,
            personInCharge : 280,
            dueDate : 120,
            state : 120,
            actions : 110,
            selection : 90
            */
        },

        getLocalStorageContextKeys : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            return [organisationPersonId];
        },

        constructColumns : function() {
            var columns = [];

            columns.push({
                   field : "networkName",
                      id : "network",
                sortable : true,
                   label : i18n.networkLabel
            });

            columns.push({
                    field : "_projectString",
                       id : "project",
                formatter : lang.hitch(this, this.projectFormatter),
                 sortable : true,
                    label : i18n.project
            });

            columns.push({
                   field : "organisationName",
                      id : "organisation",
                sortable : true,
                   label : i18n.organisationLabel
            });

            columns.push({
                   field : "cdesRoleName",
                      id : "cdesRole",
                sortable : true,
                   label : i18n.participationColumnRoleLabel
            });

            columns.push({
                    field : "_participantString",
                       id : "participant",
                formatter : lang.hitch(this, this.projectParticipantFormatter),
                 sortable : true,
                    label : i18n.participationColumnParticipantLabel
            });

            columns.push({
                    field : "_mainParticipantString",
                       id : "mainParticipant",
                formatter : lang.hitch(this, this.mainParticipantFormatter),
                 sortable : true,
                    label : i18n.participationColumnMainParticipantLabel
            });

            columns.push({
                    field : "_subProjectString",
                       id : "subProject",
                formatter : lang.hitch(this, this.subProjectFormatter),
                 sortable : true,
                    label : i18n.subProject
            });

            columns.push({
                    field : "_objectReleaseString",
                       id : "objectRelease",
                formatter : lang.hitch(this, this.objectReleaseFormatter),
                 sortable : true,
                    label : i18n.object
            });

            columns.push({
                    field : "_objectPlannerReleaseString",
                       id : "objectPlannerRelease",
                formatter : lang.hitch(this, this.objectPlannerReleaseFormatter),
                 sortable : true,
                    label : i18n.objectPlanner
            });

            columns.push({
                    field : "objectPlannerPositionDefinitionName",
                       id : "objectPlannerPositionDefinition",
                 sortable : true,
                   label : i18n.participationColumnObjectPlannerPositionDefinitionLabel
            });

            columns.push({
                    field : "reviewCycleInstanceReleasedName",
                       id : "reviewCycleInstanceReleased",
                 sortable : true,
                   label : i18n.participationColumnReviewCycleInstanceLabel
            });

            columns.push({
                    field : "_reviewCycleString",
                       id : "reviewCycle",
                formatter : lang.hitch(this, this.reviewCycleFormatter),
                 sortable : true,
                    label : i18n.participationColumnReviewCycleLabel
            });

            columns.push({
                    field : "_reviewCycleCellString",
                       id : "reviewCycleCell",
                formatter : lang.hitch(this, this.reviewCycleCellFormatter),
                 sortable : true,
                    label : i18n.reviewCycleCell
            });

            columns.push({
                    field : "_reviewCycleNodeString",
                       id : "reviewCycleNode",
                formatter : lang.hitch(this, this.reviewCycleNodeFormatter),
                 sortable : true,
                    label : i18n.reviewCycleNode
            });

            columns.push({
                    field : "_realmString",
                       id : "realm",
                formatter : lang.hitch(this, this.realmFormatter),
                 sortable : true,
                    label : i18n.participationColumnRealmLabel
            });

            return columns;
        },

        projectFormatter : function(_projectString, participationListJoin) {
            return StringHelper.getNonNullString(participationListJoin.projectCode)
            + " " + StringHelper.getNonNullString(participationListJoin.projectName);
        },

        projectParticipantFormatter : function(_participantString, participationListJoin) {
            return NameHelper.getPersonCommonName(participationListJoin, "person");
        },

        mainParticipantFormatter : function(_mainParticipantString, participationListJoin) {
            // Spalte Stellvertreter, also andersherum denken
            if (participationListJoin.baseParticipantMainParticipantFlag) {
                return i18n.no;
            } else {
                return i18n.yes;
            }
        },

        subProjectFormatter : function(_subProjectString, participationListJoin) {
            return StringHelper.getNonNullString(participationListJoin.subProjectCode)
            	+ StringHelper.getNonNullString(participationListJoin.subProjectNumber)
            	+ " " + StringHelper.getNonNullString(participationListJoin.subProjectName);
        },

        objectReleaseFormatter : function(_objectReleaseString, participationListJoin) {
            return StringHelper.getNonNullString(participationListJoin.objectReleaseCode)
            + " " + StringHelper.getNonNullString(participationListJoin.objectReleaseName);
        },

        objectPlannerReleaseFormatter : function(_objectPlannerReleaseString, participationListJoin) {
            return StringHelper.getNonNullString(participationListJoin.objectPlannerReleaseCode)
            + " " + StringHelper.getNonNullString(participationListJoin.objectPlannerReleaseArea);
        },

        reviewCycleFormatter : function(_reviewCycleString, participationListJoin) {
            var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();
            var reviewCycleName = I18nHelper.getCurrentLocaleString(participationListJoin.reviewCycleName, locale);
            return reviewCycleName;
        },

        reviewCycleCellFormatter : function(_reviewCycleCellString, participationListJoin) {
            var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();
            var reviewCycleCellName = I18nHelper.getCurrentLocaleString(participationListJoin.reviewCycleCellName, locale);
            return StringHelper.getNonNullString(participationListJoin.reviewCycleCellCode)
            + " " + StringHelper.getNonNullString(reviewCycleCellName);
        },

        reviewCycleNodeFormatter : function(_reviewCycleNodeString, participationListJoin) {
            var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();
            var reviewCycleNodeName = I18nHelper.getCurrentLocaleString(participationListJoin.reviewCycleNodeName, locale);
            return StringHelper.getNonNullString(participationListJoin.reviewCycleNodeCode)
            + " " + StringHelper.getNonNullString(reviewCycleNodeName);
        },

        realmFormatter : function(_realmString, participationListJoin) {
            var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();
            var realmName = I18nHelper.getCurrentLocaleString(participationListJoin.realmName, locale);
            return StringHelper.getNonNullString(participationListJoin.realmCode)
            + " " + StringHelper.getNonNullString(realmName);
        },

        /*
        renderProject : function(organisationPersonJoin, data, cell) {
        var topDiv = domConstruct.create("table", null, null);
        domClass.add(topDiv, "personListProjectTable");

        var projects = organisationPersonJoin.projects;
        var projectIdToRoleJoins = organisationPersonJoin.projectIdToRoleJoins;
        for (var n = 0; n < projects.length; n++) {
        var project = projects[n];
        var projectId = project.id;
        var roleJoins = projectId in projectIdToRoleJoins ? projectIdToRoleJoins[projectId] : [];

        var projectRow = domConstruct.create("tr", null, null);
        domConstruct.place(projectRow, topDiv);

        // Project Cell
        var projectCell = domConstruct.create("td", null, null);
        domClass.add(projectCell, "personListCellProjectCell");
        domConstruct.place(projectCell, projectRow);

        var projectDiv = domConstruct.create("div", null, null);
        domConstruct.place(projectDiv, projectCell);

        DOMHelper.createTextNode("span", project.code, projectDiv, null);
        DOMHelper.createTextNode("span", project.name, projectDiv, "personListCellProjectName");
        DOMHelper.createTextNode("span", " ["+organisationPersonJoin.networkName+"]", projectDiv, "personListCellProjectName");

        // Roles Cell
        var rolesCell = domConstruct.create("td", null, null);
        domClass.add(rolesCell, "personListCellRolesCell");
        domConstruct.place(rolesCell, projectRow);

        var roleLabels = [];
        for (var z = 0; z < roleJoins.length; z++) {
        var roleJoin = roleJoins[z];
        var roleLabel = string.substitute(i18n.personListRoleLabel, {
        role : roleJoin.cdesRoleName,
        surName : roleJoin.mainPersonSurName,
        givenName : roleJoin.mainPersonGivenName
    });
        roleLabels.push(roleLabel);
    }
        roleLabels.sort(function(labelOne, labelTwo) {
        return labelOne.localeCompare(labelTwo);
    });

        for (var z = 0; z < roleLabels.length; z++) {
        DOMHelper.createTextNode("div", roleLabels[z], rolesCell, null);
    }
    }
        return topDiv;
    },

        getProjectString : function(organisationPersonJoin, data, cell) {
        var projectString = "";

        var projects = organisationPersonJoin.projects;
        var projectIdToRoleJoins = organisationPersonJoin.projectIdToRoleJoins;
        for (var n = 0; n < projects.length; n++) {
        var project = projects[n];
        projectString += project.code + " " + project.name + " ";

        var projectId = project.id;
        var roleJoins = projectId in projectIdToRoleJoins ? projectIdToRoleJoins[projectId] : [];
        var roleLabels = [];
        for (var z = 0; z < roleJoins.length; z++) {
        var roleJoin = roleJoins[z];
        var roleLabel = string.substitute(i18n.personListRoleLabel, {
        role : roleJoin.cdesRoleName,
        surName : roleJoin.mainPersonSurName,
        givenName : roleJoin.mainPersonGivenName
    });
        roleLabels.push(roleLabel);
    }
        roleLabels.sort(function(labelOne, labelTwo) {
        return labelOne.localeCompare(labelTwo);
    });

        for (var z = 0; z < roleLabels.length; z++) {
        projectString += roleLabels[z] + " ";
    }
    }
        return projectString;
    },*/

        constructTopDiv : function() {
            var grid = this.constructGrid({
                idProperty : "artificialId",
                    gridId : this.gridId != null ? this.gridId : "ParticipationListGrid",
                 gridClass : "OnDemandGrid"
            });

            on(grid, "dgrid-sort", lang.hitch(this, function(e) {
                var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
                this.applicationContext.storeInLocalStorage([organisationPersonId], "/participation/sort", e.sort);
            }));

            aspect.after(this.grid, "renderRow", lang.hitch(this, function(row, args) {
                var joinDto = args[0];
                this.updateRowClass(row, joinDto);
                return row;
            }));

            return grid;
        },

        resize : function(newSize) {
            this.grid.resize(newSize);
        },

        setData : function(params) {
            this.participationListJoins = params.participationListJoins;
            this.updateAuxiliaryData();

            //var columns = this.grid.get("columns");

            if (params.columnSettings) {
                this.updateColumns(params.columnSettings);
            }

            this.reload();

            /*
            var personInfo = params.personInfo;
            this.networkIdToActions = personInfo.networkIdToActions;
            this.organisationPersonJoins = personInfo.organisationPersonJoins;
            var personIdToOrganisationJoins = personInfo.personIdToOrganisationJoins;
            var personIdToProjects = personInfo.personIdToProjects;
            var personIdToProjectIdToRoleJoins = personInfo.personIdToProjectIdToRoleJoins;
            this.organisationIdToNetworks = personInfo.organisationIdToNetworks;

            for (var n = 0; n < this.organisationPersonJoins.length; n++) {
            var organisationPersonJoin = this.organisationPersonJoins[n];
            var personId = organisationPersonJoin.personId;
            var organisationId = organisationPersonJoin.organisationId;
            organisationPersonJoin.projects = personId in personIdToProjects
                                            ? personIdToProjects[personId] : [];
            organisationPersonJoin.projectIdToRoleJoins = personId in personIdToProjectIdToRoleJoins
                                                        ? personIdToProjectIdToRoleJoins[personId] : new Object();
            organisationPersonJoin.networkIds = new Object();

            var networks = this.organisationIdToNetworks[organisationId];
            if (networks != null) {
            for (var v = 0; v < networks.length; v++) {
            var networkId = networks[v].id;
            organisationPersonJoin.networkIds[networkId] = true;
        }
        }

            organisationPersonJoin.projects.sort(function(projectOne, projectTwo) {
            var s1 = StringHelper.getNonNullString(projectOne.code) + " " + StringHelper.getNonNullString(projectOne.name);
            var s2 = StringHelper.getNonNullString(projectTwo.code) + " " + StringHelper.getNonNullString(projectTwo.name);
            return s1.localeCompare(s2);
        });
        }
            */

            this.updateAuxiliaryData();

            this.reload();
        },

        updateAuxiliaryData : function() {
            for (var n = 0; n < this.participationListJoins.length; n++) {
                var participationListJoin = this.participationListJoins[n];
                this.updateAuxiliaryDataForJoinDto(participationListJoin);
            }
        },

        updateAuxiliaryDataForJoinDto : function(participationListJoin) {
            participationListJoin._projectString = this.projectFormatter(null, participationListJoin);
            participationListJoin._participantString = this.projectParticipantFormatter(null, participationListJoin);
            participationListJoin._mainParticipantString = this.mainParticipantFormatter(null, participationListJoin);
            participationListJoin._subProjectString = this.subProjectFormatter(null, participationListJoin);
            participationListJoin._objectReleaseString = this.objectReleaseFormatter(null, participationListJoin);
            participationListJoin._objectPlannerReleaseString = this.objectPlannerReleaseFormatter(null, participationListJoin);
            participationListJoin._reviewCycleString = this.reviewCycleFormatter(null, participationListJoin);
            participationListJoin._reviewCycleCellString = this.reviewCycleCellFormatter(null, participationListJoin);
            participationListJoin._reviewCycleNodeString = this.reviewCycleNodeFormatter(null, participationListJoin);
            participationListJoin._realmString = this.realmFormatter(null, participationListJoin);
        },

        updateIndividualColumns : function() {
            this.updateColumn("network", this.columnSettings.showNetwork);
            this.updateColumn("project", this.columnSettings.showProject);
            this.updateColumn("organisation", this.columnSettings.showOrganisation);
            this.updateColumn("cdesRole", this.columnSettings.showCdesRole);
            this.updateColumn("participant", this.columnSettings.showParticipant);
            this.updateColumn("mainParticipant", this.columnSettings.showMainParticipant);
            this.updateColumn("subProject", this.columnSettings.showSubProject);
            this.updateColumn("objectRelease", this.columnSettings.showObjectRelease);
            this.updateColumn("objectPlannerRelease", this.columnSettings.showObjectPlannerRelease);
            this.updateColumn("objectPlannerPositionDefinition", this.columnSettings.showObjectPlannerPositionDefinition);
            this.updateColumn("reviewCycleInstanceReleased", this.columnSettings.showReviewCycleInstanceReleased);
            this.updateColumn("reviewCycle", this.columnSettings.showReviewCycle);
            this.updateColumn("reviewCycleCell", this.columnSettings.showReviewCycleCell);
            this.updateColumn("reviewCycleNode", this.columnSettings.showReviewCycleNode);
            this.updateColumn("realm", this.columnSettings.showRealm);
        },

        updateRowClass : function(domNode, participationListJoin) {
            if (participationListJoin.baseParticipantInactiveFlag || participationListJoin.projectParticipationInvalidated
            		|| participationListJoin.organisationPersonRetiredFlag  || participationListJoin.baseOrganisationPersonRetiredFlag) {
                domClass.add(domNode, "personListInvalidatedPerson");
            }
            /*
            domClass.remove(domNode, "personListForeignNetworkRow");

            if (organisationPersonJoin._foreignNetwork) {
            domClass.add(domNode, "personListForeignNetworkRow");
        }
            */
        },

        reload : function(params) {
            this.setStoreData(this.participationListJoins);

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

            var oldSort = this.applicationContext.getFromLocalStorage([organisationPersonId], "/participation/sort");

            if (oldSort == null) {
                // this.grid.set("sort", "_dueDateString", false);
                // this.applicationContext.storeInLocalStorage([organisationPersonId], "/participation/sort", this.grid.get("sort"));
            } else {
                this.grid.set("sort", oldSort);
            }

            this.grid.updateSortArrow(this.grid.sort);

            this.grid.refresh();
        },

        getRowId : function(participationListJoin) {
            return participationListJoin.projectParticipationId;
        },

        getQuickSearchTokensForRow : function(participationListJoin) {
            var tokens = [];
            tokens.push(participationListJoin.networkName);
            tokens.push(participationListJoin._projectString);
            tokens.push(participationListJoin.organisationName);
            tokens.push(participationListJoin.cdesRoleName);
            tokens.push(participationListJoin._participantString);
            tokens.push(participationListJoin._mainParticipantString);
            tokens.push(participationListJoin._subProjectString);
            tokens.push(participationListJoin._objectReleaseString);
            tokens.push(participationListJoin._objectPlannerReleaseString);
            tokens.push(participationListJoin.objectPlannerPositionDefinitionName);
            tokens.push(participationListJoin.reviewCycleInstanceReleasedName);
            tokens.push(participationListJoin._reviewCycleString);
            tokens.push(participationListJoin._reviewCycleCellString);
            tokens.push(participationListJoin._reviewCycleNodeString);
            tokens.push(participationListJoin._realmString);
            return tokens;
        },

        destroy : function() {
            this.inherited(arguments);
        }
    });

    return ProjectParticipationListWidget;
});
