define([ 
         "clazzes/TinyLog",
         "dijit/form/ValidationTextBox",
         "dojo/_base/declare",
         "dojo/_base/lang"
       ],
    function(
    		 TinyLog,
    		 ValidationTextBox,
    		 declare,
    		 lang,
    		 i18n
    		 ) {
	
	var className = "at.cdes.widget.document.DocumentNumberTextBox";

	var log = new TinyLog(className);
	
    var DocumentNumberTextBox = declare(className, [ValidationTextBox], {
    	
    	buildRendering : function() {
    		this.inherited(arguments);
    		
    		// Patterns supported so far: %0id, where i is the to be printed length
    		if (this.numberPartPattern == null || this.numberPartPattern.length != 4) {
    			this.length = 0;
    		} else {
    			this.length = parseInt(this.numberPartPattern.substr(2, 1));	
    		} 		
    	},
    	
    	format : function(value, constraints) {
    		if (value == null) {
    			return "";
    		} else {
    			var s = value.toString();
    			while (s.length < this.length) {
    				s = "0" + s;
    			}
    			return s;
    		}    		
    	},
    	
    	parse : function(value, constraints) {
    		if (value == null) {
    			return null;
    		} else {
    			return parseInt(value);
    		}
    	}
 	
    });
    
    return DocumentNumberTextBox;
});    