/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

////css-prefix = consortiumPage
////i18n-prefix = consortiumPage

define(["cdes/core/CdesVoc",
        "cdes/organisation/ConsortiumListWidget",
        "cdes/organisation/ConsortiumSearchWidget",
        "cdes/util/SearchPageHelper",
        "cdes/widget/ContextBar",
        "cdes/widget/choose/ItemChooseDialog",
        "clazzes/TinyLog",
        "clazzes/form/FancyButton",
        "clazzes/topic",
        "clazzes/util/DOMHelper",
        "clazzes/util/ErrorHelper",
        "clazzes/util/GridHelper",
        "clazzes/util/JobHelper",
        "clazzes/widgets/layout/ChooseDialog",
        "clazzes/widgets/layout/ContentWidget",
        "clazzes/widgets/layout/InfoDialog",
        "dijit/form/Button",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/dom-style",
        "dojo/io-query",
        "dojo/on",       
        "dojo/string",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(
         CdesVoc,
         ConsortiumListWidget,
         ConsortiumSearchWidget,
         SearchPageHelper,
         ContextBar,
         ItemChooseDialog,
         TinyLog,
         FancyButton,
         topic,
         DOMHelper,
         ErrorHelper,
         GridHelper,
         JobHelper,
         ChooseDialog,
         ContentWidget,
         InfoDialog,
         Button,
         domClass,
         domConstruct,
         domStyle,
         ioQuery,
         on,
         string,
         declare,
         lang,
         i18n) {

    var className = "at.cdes.web.organisation.ConsortiumPage";

    var log = new TinyLog(className);

    var ConsortiumPage = declare(className, ContentWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();
            this.allFieldsValid = true;

            var networkService = this.applicationContext.getService("networkService");
            networkService.getAllNetworks().then(
                lang.hitch(this, function(networks) {
                    this.registerAsyncOperationFinished(ConsortiumPage.AsyncOperation.GET_NETWORKS);

                    this.searchWidget.setNetworks(networks);

	            	this.loadSearchInfo();
                }), lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : ConsortiumPage.AsyncOperation.GET_NETWORKS,
                                opName : "getAllNetworks",
                               message : i18n.consortiumPageGetAllNetworksFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getAllNetworks]", err);
                    }));
        },

        getWidgetId : function() {
            return "ConsortiumPage";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);

            // Context Bar
            /*            this.contextBar = new ContextBar({
            applicationContext : this.applicationContext,
            mode : ContextBar.Mode.DEFAULT
        });
            this.contextBar.setData({ depth : ContextBar.Depth.NETWORK });
            this.contextBarDiv = this.contextBar.getContainer();
            domClass.add(this.contextBarDiv, "consortiumPageContextBarDiv");
            domConstruct.place(this.contextBarDiv, topDiv); 
            */
            // Caption Bar
            this.captionBarDiv = this.constructCaptionBar();
            domClass.add(this.captionBarDiv, "cdesGeneralPageCaptionBar");
            domConstruct.place(this.captionBarDiv, topDiv);

            // Content
            this.contentDiv = this.constructContentDiv();
            domConstruct.place(this.contentDiv, topDiv);

            return topDiv;
        },

        constructCaptionBar : function() {
            var captionBarDiv = domConstruct.create("div", null, null);

            // Caption
            this.captionDiv = DOMHelper.createTextNode("h1", i18n.consortiumPageCaption, captionBarDiv, "cdesGeneralPageCaption");

            return captionBarDiv;
        },

        constructExportToPdfButton : function(captionBarDiv) {
            var button = new FancyButton({
                    title : i18n.exportToPdfButtonCaption,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 exportToPdfButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, this.exportToPdf));

            domConstruct.place(button.domNode, captionBarDiv);

            return button;
        },

        constructNewButton : function(captionBarDiv) {
            var newButton = new FancyButton({ 
                label : i18n.consortiumPageNewButtonCaption,
                title : i18n.consortiumPageNewButtonToolTip
            });
            domClass.add(newButton.domNode, "textButton consortiumPageNewConsortiumButton");
            domConstruct.place(newButton.domNode, captionBarDiv);

            on(newButton, "click", lang.hitch(this, this.addNewConsortium));
            return newButton;
        },        

        addNewConsortium : function() {
            if (log.isDebugEnabled()) {
                log.debug("About to call addNewConsortium, administratedNetworks are: ");
                for (var n = 0; n < this.administratedNetworks.length; n++) {
                    var administratedNetwork = this.administratedNetworks[n];
                    log.debug("- [id = " + administratedNetwork.id + "] " + administratedNetwork.name);
                }
            }

            if (this.administratedNetworks.length == 1) {
                this.applicationContext.setPage("consortiumEdit",
                                                {        mode : ContentWidget.Mode.CREATE,
                                                    networkId : this.administratedNetworks[0].id,
                                 	    administratedNetworks : this.getNetworkIdsList(this.administratedNetworks)},
                                                null, "consortiumList", null);
            } else if (this.administratedNetworks.length > 1) {
                this.chooseNetworkAndCreateConsortium();
            }
        },

        chooseNetworkAndCreateConsortium : function() {
            var columns = [];
            columns.push({
                   field : "name",
                      id : "name",
                sortable : true,
                   label : i18n.nameLabel
            });

            var chooseDialog = new ItemChooseDialog({
                applicationContext : this.applicationContext,
                             title : i18n.organisationPageChooseNetworkCaption,
                           columns : columns,
                     selectionMode : "single",
                        idProperty : "id",
                           buttons : [ 
                                      { type : ChooseDialog.Button.CHOOSE,
                                          name : "selectButton"
                                      },
                                      { type : InfoDialog.Button.ABORT,
                                          title : i18n.abortToolTip }
                           ],
                      defaultWidth : 500,
                     defaultHeight : 200,
                             items : this.administratedNetworks
            });
            on(chooseDialog, "valueChosen", lang.hitch(this, function(networks) {
                this.applicationContext.setPage("consortiumEdit",
                                                {        mode : ContentWidget.Mode.CREATE,
                                                    networkId : networks[0].id,
                                 	    administratedNetworks : this.getNetworkIdsList(this.administratedNetworks)},
                                                null, "consortiumList", null);
            }));
            chooseDialog.show(null);            
        },

        constructContentDiv : function() {
            var contentDiv = domConstruct.create("div", null, null);
            domClass.add(contentDiv, "refNodeOfPositionAbsolute wholeRegion");

		    // Search Widget
		    this.searchWidget = new ConsortiumSearchWidget({
			applicationContext : this.applicationContext
		    });
		    this.searchWidgetDiv = this.searchWidget.getContainer();
		    domConstruct.place(this.searchWidgetDiv, contentDiv);
		    on(this.searchWidget, "titlePaneToggled", lang.hitch(this, this.resize));                   
		    on(this.searchWidget, "doSearch", lang.hitch(this, this.setData));
            on(this.searchWidget, "doReloadSearchInfo", lang.hitch(this, this.doReloadSearchInfo));

    	    // Status Bar
            this.statusBarDiv = SearchPageHelper.constructSingleLineStatusBarWithQuickSearch({
                                 baseWidget : this,
                processQuickSearchChangeFct : lang.hitch(this, this.processQuickSearchChange),
                        clearQuickSearchFct : lang.hitch(this, this.clearQuickSearch)
            });
    	    domClass.add(this.statusBarDiv, "personPageStatusBar");
    	    domConstruct.place(this.statusBarDiv, contentDiv);

            // List Widget
            this.listWidget = new ConsortiumListWidget({
                applicationContext : this.applicationContext,
                          backPage : "consortiumList",
                        backParams : new Object()
            });
            this.listWidgetDiv = this.listWidget.getContainer();
            domClass.add(this.listWidgetDiv, "fixedDialogWidget wholeRegion");       
            domConstruct.place(this.listWidgetDiv, contentDiv);         
            // Reload data after certain operations which change state have been performed
            on(this.listWidget, "discardSearchData", lang.hitch(this, this.discardSearchData));
            on(this.listWidget, "doReloadSearchInfo", lang.hitch(this, this.doReloadSearchInfo));
            on(this.listWidget, "doSearch", lang.hitch(this, this.reload));

            this.listWidget.restoreColumnWidths();

            return contentDiv;
        },

        resize : function(newSize) {
            if (newSize) {
                this.lastNewSize = newSize;
            }

            var totalHeight = this.lastNewSize.h;                   

            //                      var tableWidth = this.contextBarDiv.offsetWidth - 15;
            //              var tableWidth = this.searchWidgetDiv.offsetWidth;
            var tableHeight = totalHeight
                            - this.captionBarDiv.offsetHeight
                            - this.searchWidgetDiv.offsetHeight - domStyle.get(this.searchWidgetDiv, "margin-top") - domStyle.get(this.searchWidgetDiv, "margin-bottom") 
            //      - this.columnWidgetDiv.offsetHeight - domStyle.get(this.columnWidgetDiv, "margin-top") - domStyle.get(this.columnWidgetDiv, "margin-bottom")
            - this.statusBarDiv.offsetHeight
            - 16;
            this.listWidget.resize({/* w : tableWidth,*/ h : tableHeight });

            /*            
            var contentHeight = totalHeight
                              - this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")
                              - this.captionBarDiv.offsetHeight
                              - 16;

            domStyle.set(this.contentDiv, "height", contentHeight + "px");
                                                                  */
        },

        discardSearchData : function() {
            this.searchWidget.discardSearchData();
        },

		loadSearchInfo : function() {
            this.doReloadSearchInfo(true);
        },

        doReloadSearchInfo : function(checkAutoLoad) {
            var networkId = this.searchWidget.getSelectedNetworkId();
            if (networkId == CdesVoc.MagicSelectOption.ALL) {
                networkId = null;
            }

            if (log.isDebugEnabled()) {
                log.debug("About to reloadSearchInfo for networkId [" + networkId + "]");
            }

            DOMHelper.setInnerText(this.statusDiv, i18n.searchBeingInitialized);

		    var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
		    this.registerAsyncOperationStarted(ConsortiumPage.AsyncOperation.LOAD_SEARCH_INFO);
		    var organisationService = this.applicationContext.getService("organisationService");
		    organisationService.getConsortiumSearchInfo(organisationPersonId, networkId).then(
				lang.hitch(this, function(searchInfo) {
				    this.registerAsyncOperationFinished(ConsortiumPage.AsyncOperation.LOAD_SEARCH_INFO);
				    
				    if (log.isDebugEnabled()) {
				        log.debug("Successfully queried organisationSearchInfo for networkId [" + networkId + "]");
				    }
				    
				    this.administratedNetworks = searchInfo.administratedNetworks;
				    this.searchWidget.setSearchInfo(searchInfo, networkId);
			        this.listWidget.setAdministratedNetworks(searchInfo.administratedNetworks);
				    this.networkActions = searchInfo.networkActions;
                    this.certificateAdministrationGlobal = searchInfo.certificateAdministrationGlobal;
					this.globalActions = new Object();
					for (var n = 0; n < searchInfo.globalActions.length; n++) {
						this.globalActions[searchInfo.globalActions[n]] = true;
					}                        
				    
				    if (this.exportToPdfButton == null && this.networkActions != null) {
				        this.exportToPdfButton = this.constructExportToPdfButton(this.captionBarDiv);
				    }
				    
		            if (this.newButton == null && (this.certificateAdministrationGlobal && "administrateCertificate" in this.globalActions 
                 		|| !this.certificateAdministrationGlobal && this.administratedNetworks != null && this.administratedNetworks.length > 0)) {
				        this.newButton = this.constructNewButton(this.captionBarDiv);
				    }                                        
                    //cameBack is set via this.applicationContext.popLastPageHistoryPage({ cameBack : true});
					if (checkAutoLoad && (searchInfo.enableAutoInitSearch || this.cameBack))
				    	this.reload();
			    	else if (checkAutoLoad)
						DOMHelper.setInnerText(this.statusDiv, i18n.notYetSearched);
				}),
				lang.hitch(this, function(err) {
				    ErrorHelper.processAsyncError({
						   err : err,
						widget : this,
					asyncOperation : ConsortiumPage.AsyncOperation.LOAD_SEARCH_INFO,
						opName : "getConsortiumSearchInfo",
					       message : i18n.organisationPageGetSearchInfoFailed
				    });
				})).otherwise(
				    lang.hitch(this, function(err) {
					log.error("Error while calling function [getConsortiumSearchInfo]", err);
			    }));
	},

        setData : function() {
            this.reload();
            if (this.searchWidget.getNetworkChanged())
           		this.doReloadSearchInfo();
        },

        cloneAndConvertSearchModelForServer : function(searchModel) {
            return {
                organisationPersonId : searchModel.organisationPersonId,
                                  id : searchModel.id != CdesVoc.MagicSelectOption.ALL ? searchModel.id : null,
                                name : searchModel.name,
                      organisationId : searchModel.organisationId != CdesVoc.MagicSelectOption.ALL
                                                                   ? searchModel.organisationId : null,
                    organisationName : searchModel.organisationName,
                           networkId : searchModel.networkId != CdesVoc.MagicSelectOption.ALL ? searchModel.networkId : null,
                         networkName : searchModel.networkName
            };
        },

        reload : function() {
            this.registerAsyncOperationStarted(ConsortiumPage.AsyncOperation.LOAD);

    	    DOMHelper.setInnerText(this.statusDiv, i18n.searchRuns);

            var searchModel = this.searchWidget.getSearchModel();
		    var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
		    this.applicationContext.storeInLocalStorage([organisationPersonId], "/consortiumList/search", searchModel);

            this.quickSearchTextBox.set("value", "");
            
            searchModelRPC = this.cloneAndConvertSearchModelForServer(searchModel);
            var organisationService = this.applicationContext.getService("organisationService");
            organisationService.getConsortiumJoins(searchModelRPC).then(
                lang.hitch(this, function(consortiumInfos) {
                    this.registerAsyncOperationFinished(ConsortiumPage.AsyncOperation.LOAD);

		    var searchInfoString = this.getSearchInfoString(consortiumInfos);
		    topic.publish("message/ok", searchInfoString);
		    DOMHelper.setInnerText(this.statusDiv, searchInfoString);

                    this.listWidget.setData({
                        consortiumInfos : consortiumInfos
                    });
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : ConsortiumPage.AsyncOperation.LOAD,
                                opName : "getConsortiumJoins",
                               message : i18n.consortiumPageLoadDataFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getConsortiumJoins]", err);
                    }));
        },

        getSearchInfoString : function(consortiumInfos) {
            var numberOfConsortiums = (consortiumInfos != null ? consortiumInfos.length : 0);
            return string.substitute(i18n.consortiumPageSearchResult, {
                count : numberOfConsortiums
            });
        },

    	processQuickSearchChange : function() {
    	    var newSearch = this.quickSearchTextBox.get("value");
    	    if (newSearch != this.lastQuickSearch) {
    		this.listWidget.filter(newSearch);
    		this.lastQuickSearch = newSearch;
    	    }
    	},
    	
    	clearQuickSearch : function() {
    	    this.quickSearchTextBox.set("value", "", false);
    	    this.processQuickSearchChange();
    	},

        exportToPdf : function() {
            var columnToWidth = this.listWidget.getColumnToWidth();
            var organisationService = this.applicationContext.getService("organisationService");
            var sortSpecs = this.listWidget.getSortSpecs({ pdf : true });
            var searchModel = this.searchWidget.getSearchModel();
            topic.publish("message/info", i18n.consortiumPagePdfExportStarted);

            searchModelRPC = this.cloneAndConvertSearchModelForServer(searchModel);

            this.registerAsyncOperationStarted(ConsortiumPage.AsyncOperation.EXPORT_TO_PDF);
            organisationService.triggerExportConsortiumList(searchModelRPC, columnToWidth, sortSpecs).then(lang.hitch(this, function(jobId) {
                JobHelper.registerJobStatusQueryForDownload(this.applicationContext, jobId, function(jobId) {
                    topic.publish("message/ok", i18n.consortiumPagePdfExportFinished);

                    var parameterString = ioQuery.objectToQuery({
                        jobId : jobId
                    });
                    return "/cdes-dojo-impl/download?" + parameterString;
                });

                this.registerAsyncOperationFinished(ConsortiumPage.AsyncOperation.EXPORT_TO_PDF);
            }), lang.hitch(this, function(err) { 
                ErrorHelper.processAsyncError({
                               err : err,
                            widget : this,
                    asyncOperation : ConsortiumPage.AsyncOperation.EXPORT_TO_PDF,
                            opName : "triggerExportConsortiumList",
                           message : i18n.consortiumPagePdfExportFailed
                });                             
            })).otherwise(
                lang.hitch(this, function(err) {
                    log.error("Handling the results of executing triggerExportConsortiumList failed", err);
                }));
        },        

        updateWidgetState : function() {
            var asyncRunning = this.isAsyncOperationRunning();
            if (this.searchWidget != null) {
                this.searchWidget.setAsyncRunning(asyncRunning);
            }
        },
                  
        getNetworkIdsList : function(networks) {
            var networkIdsList = [];
            if (networks != null) {
				for (var n = 0; n < networks.length; n++) {
	                var networkId = networks[n].id;                
	                if (!(networkId in networkIdsList))
	                    networkIdsList.push(networkId);
                }
            }
            return networkIdsList;
        },

        destroy : function() {
            this.inherited(arguments);
            this.listWidget.destroy();
        }
    });

    ConsortiumPage.AsyncOperation = {
        EXPORT_TO_PDF : "ExportToPdf",
        GET_NETWORKS : "GetNetworks",
        LOAD : "Load",
        LOAD_SEARCH_INFO : "LoadSearchInfo"
    };

    return ConsortiumPage;
});
