define(["cdes/admin/import/ImportAdminPage",
        "cdes/admin/job/JobPage",
        "cdes/admin/job/JobResultPage",
        "cdes/certificate/CertificatePage",
        "cdes/challengeLogin/ChallengeLoginPage",
        "cdes/challengeLogin/NewPasswordPage",
        "cdes/certificate/RequestUserPolicyPage",
        "cdes/core/ApplicationContext",
        "cdes/document/DocumentComparePage",
        "cdes/document/DocumentInvalidatePage",
        "cdes/document/DocumentPage",
        "cdes/document/RequestOriginalDocumentPage",
        "cdes/help/AboutPage",
        "cdes/organisation/ConsortiumEditPage",
        "cdes/organisation/ConsortiumPage",
        "cdes/organisation/OrganisationEditPage",
        "cdes/organisation/OrganisationPage",
        "cdes/person/PersonEditPage",
        "cdes/pdc/PlanDeliverCatalogue",
        "cdes/pdc/PlanDeliverNewPage",
        "cdes/pdc/PlanDeliverReleasePage",
        "cdes/person/PersonPage",
        "cdes/planning/notification/PlanningNotificationEditPage",
        "cdes/planning/notification/PlanningNotificationPage",
        "cdes/planning/notification/PlanningNotificationSharepointImportPage",
        "cdes/planning/order/PlanningNotificationOrderEditPage",
        "cdes/planning/order/PlanningNotificationOrderExtractPage",
        "cdes/planning/order/PlanningNotificationOrderImportPage",
        "cdes/planning/order/PlanningNotificationOrderPage",
        "cdes/planning/project/PlanningNotificationProjectPage",
        "cdes/planning/report/PlanningNotificationReportPage",
        "cdes/planning/task/PlanningNotificationTaskPage",
        "cdes/planning/task/ReviewPage",
        "cdes/planning/task/ReviewProtocolPage",
        "cdes/planning/template/MetaTagEditPage",
        "cdes/planning/template/PlanningNotificationTemplateEditPage",
        "cdes/planning/template/PlanningNotificationTemplatePage",
        "cdes/planning/workflow/DefineWorkflowPage",
        "cdes/plot/PlotOrderChargePage",
        "cdes/plot/PlotOrderEditPage",
        "cdes/plot/PlotOrderPage",
        "cdes/plot/PlotOrderSignPage",
        "cdes/plot/PlotOrderTemplateChoosePage",
        "cdes/project/ProjectEditPage",
        "cdes/project/ProjectParticipationPage",
        "cdes/review/ReviewProtocol",
        "cdes/widget/ErrorPage",
        "cdes/widget/mail/SendEmailPage",
        "clazzes/LoginGuardXhr",
        "clazzes/LogMessagePane",
        "clazzes/LogMessagePaneWithHistory",
        "clazzes/TinyLog",
        "clazzes/topic",
        "clazzes/util/ErrorHelper",
        "dijit/Destroyable",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/hash",
        "dojo/io-query",
        "dojo/on",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
],
function(
         ImportAdminPage,
         JobPage,
         JobResultPage,
         CertificatePage,
         ChallengeLoginPage,
         NewPasswordPage,
         RequestUserPolicyPage,
         ApplicationContext,
         DocumentComparePage,
         DocumentInvalidatePage,
         DocumentPage,
         RequestOriginalDocumentPage,
         AboutPage,
         ConsortiumEditPage,
         ConsortiumPage,
         OrganisationEditPage,
         OrganisationPage,
         PersonEditPage,
         PlanDeliverCatalogue,
         PlanDeliverNewPage,
         PlanDeliverReleasePage,
         PersonPage,
         PlanningNotificationEditPage,
         PlanningNotificationPage,
         PlanningNotificationSharepointImportPage,
         PlanningNotificationOrderEditPage,
         PlanningNotificationOrderExtractPage,
         PlanningNotificationOrderImportPage,
         PlanningNotificationOrderPage,
         PlanningNotificationProjectPage,
         PlanningNotificationReportPage,
         PlanningNotificationTaskPage,
         ReviewPage,
         ReviewProtocolPage,
         MetaTagEditPage,
         PlanningNotificationTemplateEditPage,
         PlanningNotificationTemplatePage,
         DefineWorkflowPage,
         PlotOrderChargePage,
         PlotOrderEditPage,
         PlotOrderPage,
         PlotOrderSignPage,
         PlotOrderTemplateChoosePage,
         ProjectEditPage,
         ProjectParticipationPage,
         ReviewProtocol,
         ErrorPage,
         SendEmailPage,
         LoginGuardXhr,
         LogMessagePane,
         LogMessagePaneWithHistory,
         TinyLog,
         topic,
         ErrorHelper,
         Destroyable,
         domClass,
         domConstruct,
         hash,
         ioQuery,
         on,
         declare,
         lang,
         i18n
         ) {

    var className = "at.cdes.web.pages.PageChooser";

    var log = new TinyLog(className);
    var messageLog = new TinyLog(className + "_Messages");

    var PageChooser = declare(className, Destroyable, {

        pathPrefix : "/cdes-web/",

        pageFactories : {
                                           about : {
                                               constructPage : function(params) {
                                                   return new AboutPage(params);
                                               }
                                           },

                                  challengeLogin : {
                                      constructPage : function(params) {
                                          var page = new ChallengeLoginPage(params);
                                          page.reload();
                                          return page;
                                      }
                                  },

                                  newPassword : {
                                      constructPage : function(params) {
                                          var page = new NewPasswordPage(params);
                                          page.updateWidgetState();
                                          return page;
                                      }
                                  },

                                  requestUserPolicy : {
                                      constructPage : function(params) {
                                          var page = new RequestUserPolicyPage(params);
                                          page.updateWidgetState();
                                          return page;
                                      }
                                  },

                                          consortiumEdit : {
                                              constructPage : function(params) {
                                                  return new ConsortiumEditPage(params);
                                              }
                                          },

                                  consortiumList : {
                                      constructPage : function(params) {
                                          return new ConsortiumPage(params);
                                      }
                                  },

                                  defineWorkflow : {
                                      constructPage : function(params) {
                                          if (true) { // TODO privileges
                                              return new DefineWorkflowPage(params);
                                          } else {
                                              var page = new ErrorPage();
                                              page.setData("TODO");
                                              return page;
                                          }
                                      }
                                  },

                             documentComparePage : {
                                 constructPage : function(params) {
                                     if (true) { // TODO privileges
                                         return new DocumentComparePage(params);
                                     } else {
                                         var page = new ErrorPage();
                                         page.setData("TODO");
                                         return page;
                                     }
                                 }
                             },

                             documentInvalidatePage : {
                                 constructPage : function(params) {
                                     if (true) {
                                         return new DocumentInvalidatePage(params);
                                     } else {
                                         var page = new ErrorPage();
                                         page.setData("TODO");
                                         return page;
                                     }
                                 }
                             },

                                    documentList : {
                                        constructPage : function(params) {
                                            var applicationContext = params.applicationContext;
                                            if (applicationContext.getPageContextSubProject() == null) {
                                                document.location.href = "/cdes/app?service=SecureDirectService/1/DocumentList/documentVersionsOverview/selectContext&ts="
                                                                       + dojoConfig.tabSessionId;
                                                return null;
                                            }

                                            if (applicationContext.isActionAllowedForProject("documentVersionsOverview")) {
                                                return new DocumentPage(params);
                                            } else {
                                                var page = new ErrorPage();
                                                page.setData("TODO");
                                                return page;
                                            }
                                        }
                                    },

                                     importAdmin : {
                                         constructPage : function(params) {
                                             return new ImportAdminPage(params);
                                         }
                                     },

                                     metaTagEdit : {
                                         constructPage : function(params) {
                                             if (true) { // TODO privileges
                                                 return new MetaTagEditPage(params);
                                             } else {
                                                 var page = new ErrorPage();
                                                 page.setData("TODO");
                                                 return page;
                                             }
                                         }
                                     },

                                         jobList : {
                                             constructPage : function(params) {
                                                 if (true) { // TODO privileges
                                                     return new JobPage(params);
                                                 } else {
                                                     var page = new ErrorPage();
                                                     page.setData("TODO");
                                                     return page;
                                                 }
                                             }
                                         },

                                       jobResult : {
                                           constructPage : function(params) {
                                               if (true) { // TODO privileges
                                                   return new JobResultPage(params);
                                               } else {
                                                   var page = new ErrorPage();
                                                   page.setData("TODO");
                                                   return page;
                                               }
                                           }
                                       },

                                          organisationEdit : {
                                              constructPage : function(params) {
                                                  return new OrganisationEditPage(params);
                                              }
                                          },

                                organisationList : {
                                    constructPage : function(params) {
                                        return new OrganisationPage(params);
                                    }
                                },

                                      participationList : {
                                          constructPage : function(params) {
                                              return new ProjectParticipationPage(params);
                                          }
                                      },

                                          personEdit : {
                                              constructPage : function(params) {
                                                  console.info("params: ", params);
                                                  return new PersonEditPage(params);
                                              }

/*
                                                  var personId = "id" in params ? params["id"] : null;
                                                  var page;
                                                  if (true && personId != null) {
                                                      page = new PersonEditPage(params);
                                                      page.setData(personId);
                                                  } else {
                                                      page = new ErrorPage();
                                                      page.setData("TODO");
                                                  }
                                                  return page;
                                              }                    */
                                          },

                                      personList : {
                                          constructPage : function(params) {
                                              return new PersonPage(params);
                                          }
                                      },

                            planDeliverCatalogue : {
                                constructPage : function(params) {
                                    var applicationContext = params.applicationContext;
                                    if (applicationContext.getPageContextSubProject() == null) {
                                        document.location.href = "/cdes/app?service=SecureDirectService/1/PlanDeliverCatalogueOverview/planDeliverCatalogueOverview/selectContext&ts="
                                                               + dojoConfig.tabSessionId;
                                        return null;
                                    }

                                    if (applicationContext.isActionAllowedForProject("planDeliverCatalogueOverview")) {
                                        return new PlanDeliverCatalogue(params);
                                    } else {
                                        var page = new ErrorPage();
                                        page.setData(i18n.planDeliverCatalogueMissingPermissions);
                                        return page;
                                    }
                                }
                            },

                                  planDeliverNew : {
                                      constructPage : function(params) {
                                          if (true) { // TODO privileges
                                              return new PlanDeliverNewPage(params);
                                          } else {
                                              var page = new ErrorPage();
                                              page.setData("TODO");
                                              return page;
                                          }
                                      }
                                  },

                              planDeliverRelease : {
                                  constructPage : function(params) {
                                      if (params.applicationContext.isActionAllowedForProject("releasePlanDeliverCatalogue")) {
                                          return new PlanDeliverReleasePage(params);
                                      } else {
                                          var page = new ErrorPage();
                                          page.setData("TODO");
                                          return page;
                                      }
                                  }
                              },

                        planningNotificationEdit : {
                            constructPage : function(params) {
                                if (true) { // TODO privileges
                                    return new PlanningNotificationEditPage(params);
                                } else {
                                    var page = new ErrorPage();
                                    page.setData("TODO");
                                    return page;
                                }
                            }
                        },

                        planningNotificationList : {
                            constructPage : function(params) {
                                if (true) { // TODO privileges
                                    return new PlanningNotificationPage(params);
                                } else {
                                    var page = new ErrorPage();
                                    page.setData("TODO");
                                    return page;
                                }
                            }
                        },

                   planningNotificationOrderEdit : {
                       constructPage : function(params) {
                           if (true) { // TODO privileges
                               return new PlanningNotificationOrderEditPage(params);
                           } else {
                               var page = new ErrorPage();
                               page.setData("TODO");
                               return page;
                           }
                       }
                   },

                planningNotificationOrderExtract : {
                    constructPage : function(params) {
                        if (true) { // TODO privileges
                            return new PlanningNotificationOrderExtractPage(params);
                        } else {
                            var page = new ErrorPage();
                            page.setData("TODO");
                            return page;
                        }
                    }
                },

                 planningNotificationOrderImport : {
                     constructPage : function(params) {
                         if (true) { // TODO privileges
                             return new PlanningNotificationOrderImportPage(params);
                         } else {
                             var page = new ErrorPage();
                             page.setData("TODO");
                             return page;
                         }
                     }
                 },

                   planningNotificationOrderList : {
                       constructPage : function(params) {
                           if (true) { // TODO privileges
                               return new PlanningNotificationOrderPage(params);
                           } else {
                               var page = new ErrorPage();
                               page.setData("TODO");
                               return page;
                           }
                       }
                   },

                 planningNotificationProjectList : {
                     constructPage : function(params) {
                         if (true) { // TODO privileges
                             return new PlanningNotificationProjectPage(params);
                         } else {
                             var page = new ErrorPage();
                             page.setData("TODO");
                             return page;
                         }
                     }
                 },

                      planningNotificationReport : {
                          constructPage : function(params) {
                              if (true) { // TODO privileges
                                  return new PlanningNotificationReportPage(params);
                              } else {
                                  var page = new ErrorPage();
                                  page.setData("TODO");
                                  return page;
                              }
                          }
                      },

            planningNotificationSharepointImport : {
                constructPage : function(params) {
                    if (true) { // TODO privileges
                        return new PlanningNotificationSharepointImportPage(params);
                    } else {
                        var page = new ErrorPage();
                        page.setData("TODO");
                        return page;
                    }
                }
            },

                    planningNotificationTaskList : {
                        constructPage : function(params) {
                            if (true) { // TODO privileges
                                return new PlanningNotificationTaskPage(params);
                            } else {
                                var page = new ErrorPage();
                                page.setData("TODO");
                                return page;
                            }
                        }
                    },

                planningNotificationTemplateList : {
                    constructPage : function(params) {
                        var page;
                        if (true) { // TODO privileges
                            page = new PlanningNotificationTemplatePage(params);
                            page.reload();
                        } else {
                            page = new ErrorPage();
                            page.setData("TODO");
                            return page;
                        }
                        return page;
                    }
                },

                planningNotificationTemplateEdit : {
                    constructPage : function(params) {
                        if (true) { // TODO privileges
                            return new PlanningNotificationTemplateEditPage(params);
                        } else {
                            var page = new ErrorPage();
                            page.setData("TODO");
                            return page;
                        }
                    }
                },

                                 plotOrderCharge : {
                                     constructPage : function(params) {
                                         var plotOrderIds = [];
                                         var idFound = true;
                                         var n = 1;
                                         while (idFound) {
                                             var paramName = "id" + n.toString();
                                             if (paramName in params) {
                                                 plotOrderIds.push(params[paramName]);
                                                 n++;
                                             } else {
                                                 idFound = false;
                                             }
                                         }
                                         var page;
                                         if (true && plotOrderIds.length > 0) {
                                             page = new PlotOrderChargePage(params);
                                             page.setData(plotOrderIds);
                                         } else {
                                             page = new ErrorPage();
                                             page.setData("TODO");

                                         }
                                         return page;
                                     }
                                 },

                                   plotOrderEdit : {
                                       constructPage : function(params) {
                                           var plotOrderId = "id" in params ? params["id"] : "sp" in params ? params["sp"] : null;
                                           if (true && plotOrderId != null) {
                                               var page = new PlotOrderEditPage(params);
                                               page.setData(plotOrderId);
                                               return page;
                                           } else {
                                               return new PlotOrderPage(params);
                                               //                      this.page = new ErrorPage();
                                               //                      this.page.setData("error: no id set for plotOrderEditPage");
                                           }
                                       }
                                   },

                                      plotOrders : {
                                          constructPage : function(params) {
                                              var applicationContext = params.applicationContext;
                                              if (applicationContext.getPageContextProject() == null) {
                                                  document.location.href = "/cdes/app?service=SecureDirectService/1/ProjectPlotOrderOverview/showProjectPlotOrders/selectContext&ts=" + dojoConfig.tabSessionId;
                                                  return null;
                                              }

                                              if (true) {
                                                  return new PlotOrderPage(params);
                                              } else {
                                                  var page = new ErrorPage();
                                                  page.setData("TODO");
                                                  return page;
                                              }
                                          }
                                      },

                                   plotOrderSign : {
                                       constructPage : function(params) {
                                           var applicationContext = params.applicationContext;
                                           /*
                                           if (applicationContext.getPageContextProject() == null) {
                                           document.location.href = "/cdes/app?service=SecureDirectService/1/ProjectPlotOrderOverview/showProjectPlotOrders/selectContext&ts=" + dojoConfig.tabSessionId;
                                           return null;
                                       }
                                           */

                                           if (true) {
                                               return new PlotOrderSignPage(params);
                                           } else {
                                               var page = new ErrorPage();
                                               page.setData("TODO");
                                               return page;
                                           }
                                       }
                                   },

                         plotOrderTemplateChoose : {
                             constructPage : function(params) {
                                 var applicationContext = params.applicationContext;
                                 /*
                                 if (applicationContext.getPageContextProject() == null) {
                                 document.location.href = "/cdes/app?service=SecureDirectService/1/ProjectPlotOrderOverview/showProjectPlotOrders/selectContext&ts=" + dojoConfig.tabSessionId;
                                 return null;
                             }
                                 */

                                 if (true) {
                                     return new PlotOrderTemplateChoosePage(params);
                                 } else {
                                     var page = new ErrorPage();
                                     page.setData("TODO");
                                     return page;
                                 }
                             }
                         },

                         requestOriginalDocument : {
                             constructPage : function(params) {
                                 if (true) { // TODO privileges
                                     return new RequestOriginalDocumentPage(params);
                                 } else {
                                     var page = new ErrorPage();
                                     page.setData("TODO");
                                     return page;
                                 }
                             }
                         },

                                     projectEdit : {
                                         constructPage : function(params) {
                                             if (true) { // TODO privileges
                                                 return new ProjectEditPage(params);
                                             } else {
                                                 var page = new ErrorPage();
                                                 page.setData("TODO");
                                                 return page;
                                             }
                                         }
                                     },

                                    certificates : {
                                        constructPage : function(params) {
                                            var applicationContext = params.applicationContext;
                                            if (applicationContext.getPageContextNetwork() == null) {
                                                document.location.href = "/cdes/app?service=SecureDirectService/1/ContextCertificatesOverview/editPerson/selectContext&ts=" + dojoConfig.tabSessionId;
                                                return null;
                                            }

                                            if (true) {
                                                return new CertificatePage(params);
                                            } else {
                                                var page = new ErrorPage();
                                                page.setData("TODO");
                                                return page;
                                            }
                                        }
                                    },

                                  reviewProtocol : {
                                      constructPage : function(params) {
                                          if (true) { // TODO privileges
                                              return new ReviewProtocol(params);
                                          } else {
                                              var page = new ErrorPage();
                                              page.setData("TODO");
                                              return page;
                                          }
                                      }
                                  },

                                  sendEmail : {
                                      constructPage : function(params) {
                                          return new SendEmailPage(params);
                                      }
                                  },

                                  workflowReview : {
                                      constructPage : function(params) {
                                          if (true) { // TODO privileges
                                              return new ReviewPage(params);
                                          } else {
                                              var page = new ErrorPage();
                                              page.setData("TODO");
                                              return page;
                                          }
                                      }
                                  },

                          workflowReviewProtocol : {
                              constructPage : function(params) {
                                  if (true) { // TODO privileges
                                      return new ReviewProtocolPage(params);
                                  } else {
                                      var page = new ErrorPage();
                                      page.setData("TODO");
                                      return page;
                                  }
                              }
                          }
        },

        constructor : function() {
            if (log.isDebugEnabled())
            	log.info("Creating PageChooser; dojoConfig.ts = [" + dojoConfig.ts + "]", dojoConfig);
            this.applicationContext = new ApplicationContext(this);
            this.logMessagePane = new LogMessagePaneWithHistory();
            LogMessagePane.registerTopics({
                controllerWidget : this,
                  logMessagePane : this.logMessagePane,
                      messageLog : messageLog
            });

            var pageName = this.getPageName();

            if (pageName == "importAdmin") {
                var tabSessionCreatorService = this.applicationContext.getService("tabSessionCreatorService");
                tabSessionCreatorService.openTabSession().then(lang.hitch(this, function(loginInfo) {
                    this.fetchRawContextAndInitialize(loginInfo.tabSessionId);
                }),
                    lang.hitch(this, function(err) {
                        ErrorHelper.processAsyncError({
                                       err : err,
                                    widget : this,
                            asyncOperation : null,
                                    opName : "openTabSession",
                                   message : i18n.pageChooserOpenTabSessionFailedMessage
                        });
                    })
                    ).otherwise(lang.hitch(this, function(err) {
                        log.error("Error while opening tab session: ", err);
                    }));
            } else if (pageName == "challengeLogin") {
                this.initializeChallengeLogin();
            } else if (pageName == "newPassword") {
                this.initializeNewPassword();
            } else {
                this.fetchRawContextAndInitialize(dojoConfig.tabSessionId);
            }
        },

        getWidgetId : function() {
            return "PageChooser";
        },

        getDataId : function() {
            return null;
        },

        fetchRawContextAndInitialize : function(tabSessionId) {
            var tabSessionContextService = this.applicationContext.getService("tabSessionContextService");
            tabSessionContextService.getPageContextFromTabSession(tabSessionId).then(
                lang.hitch(this, function(pageContext) {
                    this.initialize(pageContext);
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : null,
                                opName : "getPageContext",
                               message : i18n.pageChooserFetchPageContextDataFailedMessage
                    });
                })
                ).otherwise(lang.hitch(this, function(err) {
                    log.error("Error while processing fetched page context: ", err);
                }));

            /*
            LoginGuardXhr.get("/cdes/app?service=GetPageContextService", { handleAs : "json" } ).then(lang.hitch(this, function(rawPageContext) {
            log.info("Fetched raw page context: ", rawPageContext);

            this.fetchContextAndInitialize(rawPageContext);
        }),
            lang.hitch(this, function(err) {
            ErrorHelper.processAsyncError({
            err : err,
            widget : this,
            asyncOperation : null,
            opName : "fetchPageContextFromTapestry",
            message : i18n.pageChooserFetchPageContextFailedMessage
        });
        })
        ).otherwise(lang.hitch(this, function(err) {
            log.error("Error while processing fetched raw page context: ", err);
        }));
            */
        },

        fetchContextAndInitialize : function(rawContext) {
            var contextService = this.applicationContext.getService("contextService");
            contextService.getPageContext(rawContext.activeNetworkId,
                                          rawContext.activeProjectId,
                                          rawContext.activeSubProjectId,
                                          rawContext.activeOrganisationPersonId).then(
                                              lang.hitch(this, function(pageContext) {
                                                  this.initialize(pageContext);
                                              }),
                                              lang.hitch(this, function(err) {
                                                  ErrorHelper.processAsyncError({
                                                                 err : err,
                                                              widget : this,
                                                      asyncOperation : null,
                                                              opName : "getPageContext",
                                                             message : i18n.pageChooserFetchPageContextDataFailedMessage
                                                  });
                                              })
                                              ).otherwise(lang.hitch(this, function(err) {
                                                  log.error("Error while processing fetched page context: ", err);
                                              }));
        },

        registerHashChangeEvent : function() {
            this.own(
                topic.subscribe("/dojo/hashchange", lang.hitch(this, function(hashString) {
                    // In case constructPageFromHash is called explicitely (e.g. because the calling code wants to pass extra
                    // parameters to the page), prevent dojo/hashchange triggering a second call to constructPageFromHash.
                    if (!this.locked) {
                        this.constructPageFromHash();
                    } else {
                        // See ApplicationContext.setPage
                        this.removeLock();
                    }
                }), this)
                     );
        },

        initialize : function(pageContext) {
            this.applicationContext.setPageContext(pageContext);

            this.constructPageFromHash();

            this.registerHashChangeEvent();
        },

        initializeChallengeLogin : function() {
            this.constructPageFromHash();

            this.registerHashChangeEvent();
        },

        initializeNewPassword : function() {
            this.constructPageFromHash();

            this.registerHashChangeEvent();
        },

        setLocked : function() {
            this.locked = true;
        },

        removeLock : function() {
            this.locked = false;
        },

        getHashString : function() {
            var hashString = window.location.hash;
            if (hashString.charAt(0) == "#") {
                hashString = hashString.substr(1);
            }
            return hashString;
        },

        getPageName : function() {
            var hashString = this.getHashString();
            var params = ioQuery.queryToObject(hashString);
            return "page" in params ? params["page"] : null;
        },

        constructPageFromHash : function(extraParams) {
            var hashString = this.getHashString();
            if (log.isDebugEnabled()) {
                log.debug("Called constructPageFromHash with hashString [" + hashString + "]");
            }

            this.oldHashString = hashString;

            var params = ioQuery.queryToObject(hashString);
            params.applicationContext = this.applicationContext;
            lang.mixin(params, extraParams);

            if (this.page) {
                this.page.destroy();
                delete this.page;
            }

            if ("page" in params) {
                var pageName = params["page"];
                var pageFactory = this.pageFactories[pageName];
                if (pageFactory != null) {
                    this.page = pageFactory.constructPage(params);
                } else {
                    log.warn("Unknown page: [" + pageName + "] ===> Will construct nothing.");
                }
            } else {
                log.warn("No page specified ===> Will construct nothing.");
            }

            if (this.page) {
                var tmpNode = domConstruct.create("div", null, null);
                domConstruct.place(this.logMessagePane.domNode, tmpNode);

                domConstruct.empty("appLayout");

                var topDiv = this.page.getContainer();
                domConstruct.place(topDiv, "appLayout");
                domConstruct.place(this.logMessagePane.domNode, "appLayout");
                domClass.add(topDiv, "cdes");

                this.page.resize({ w : window.innerWidth, h : window.innerHeight - this.logMessagePane.domNode.offsetHeight});
                on(window, "resize", lang.hitch(this, function(e) {
                    this.page.resize({ w : window.innerWidth, h : window.innerHeight - this.logMessagePane.domNode.offsetHeight });
                }));
                on(this.page, "triggerResize", lang.hitch(this, function(e) {
                    this.page.resize({ w : window.innerWidth, h : window.innerHeight - this.logMessagePane.domNode.offsetHeight });
                }));
            } else {
                // This case especially applies, if page construction decided to open the SelectContext page (currently still implemented in
                // Tapestry) first.  Nothing to be done here in this case.
            }
        }
    });

    return PageChooser;
});
