/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

define([ "cdes/core/CdesVoc",
        "cdes/util/SearchPageHelper",
        "cdes/widget/ContextBar",
	"clazzes/TinyLog",
        "clazzes/form/MultiWidget",
	"clazzes/util/DOMHelper",
	"clazzes/util/ErrorHelper",
	"clazzes/widgets/layout/ContentWidget",
        "dijit/form/ComboBox",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-style",
	"dojo/on",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(
         CdesVoc,
         SearchPageHelper,
         ContextBar,
	 TinyLog,
         MultiWidget,
	 DOMHelper,
	 ErrorHelper,
	 ContentWidget,
         ComboBox,
	 domClass,
	 domConstruct,
	 domStyle,
	 on,
	 declare,
	 lang,
	 i18n) {

    var className = "at.cdes.web.planning.util.PlanningTitleSearchTitleMultiContentWidget";

    var log = new TinyLog(className);

    var PlanningTitleSearchTitleMultiContentWidget = declare(className, ContentWidget, {

	constructor : function(params) {
	    lang.mixin(this, params);

	    this.topDiv = this.constructTopDiv();

	    this.changed = true;
	    this.allFieldsValid = true;
	},

	getWidgetId : function() {
	    return "PlanningTitleSearchTitleMultiContentWidget";
	},

	getDataId : function() {
	    return null;
	},

	getContainer : function() {
	    return this.topDiv;
	},

	constructTopDiv : function() {
	    var topDiv = domConstruct.create("div", null, null);
	    domClass.add(topDiv, "refNodeOfPositionAbsolute planningTitleSearchMultiTopDiv");

	    var comboBoxConstructorFct = lang.hitch(this, function() {
		return new ComboBox({
		    label : i18n.planningTitleSearchComboBoxLabel,
		    title : i18n.planningTitleSearchComboBoxToolTip,
		    store : this.store		    
		});
	    });

	    this.multiWidget = new MultiWidget({
			  addButtonLabel : i18n.planningTitleAddTitleLabel,
		      addButtonIconClass : "fancyButtonIcon17x18 fancyButton17x18 addButton",
		       addButtonCssClass : "planningTitleSearchMultiWidgetAddButton",
		       deleteButtonLabel : i18n.planningTitleRemoveTitleLabel,
		   deleteButtonIconClass : "fancyButtonIcon17x18 fancyButton17x18 deleteButton",
		      lineWidgetCssClass : "planningTitleMultiWidgetLineWidget",
		lineRemoveButtonCssClass : "multiWidgetLineRemoveButton",
			  constructorFct : comboBoxConstructorFct,
			       getterFct : function(widget) {
                                   var entry = new Object();
                                   SearchPageHelper.setAllableComboBoxValueToSearchModel(widget, entry, "id", "title");
                                   return entry;
                               },
			       setterFct : function(widget, entry) {
                                   if (entry == null) {
                                       entry = {
                                           id : CdesVoc.MagicSelectOption.ALL,
                                           title : i18n.allOption
                                       };
                                   }
                                   SearchPageHelper.setSearchModelValueToAllableComboBox(entry, widget, "id", "title");
                               }
	    });
	    domClass.add(this.multiWidget.domNode, "fixedDialogWidget planningTitleSearchMultiMultiWidget");	    
	    domConstruct.place(this.multiWidget.domNode, topDiv);

	    return topDiv;
	},

	resize : function(newSize) {

	},

	setData : function(params) {
	    this.store = params.store;

	    var entries = params.entries;

	    var items = [];
	    for (var n = 0; n < entries.length; n++) {
			items.push({
				   id : n,
				value : entries[n],
			    removable : true	    
			});		    
	    }

	    this.multiWidget.set("value", items);	    
	},

	reload : function() {
	},

    save : function() {
    	var entries = this.multiWidget.get("value");
        var entryValues = [];
        if (entries != null) {
            for (var n = 0; n < entries.length; n++) {
                var entry = entries[n];
                if (entry.value != null) {
                    entryValues.push(entry.value);
                }
            }
        }

    	on.emit(this, "titlesChosen", entryValues);
    },

	updateWidgetState : function() {

	},

	destroy : function() {
	    this.inherited(arguments);
	}
    });

    PlanningTitleSearchTitleMultiContentWidget.AsyncOperation = {

    };

    return PlanningTitleSearchTitleMultiContentWidget;
});
