define([ 
         "clazzes/TinyLog",
         "cdes/widget/CalendarSpinner",
         "clazzes/util/DOMHelper",
         "clazzes/util/StringHelper",
         "clazzes/widgets/IconTitlePane",
         "dijit/form/Button",
         "dijit/form/CheckBox",
         "dijit/form/NumberSpinner",
         "dijit/form/TextBox",
         "dojo/dom-class",
         "dojo/dom-construct",
         "dojo/Evented",
         "dojo/keys",
         "dojo/on",
         "dojo/_base/declare",
         "dojo/_base/lang",
         "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
       ],
    function(
    		 TinyLog,
    		 CalendarSpinner,
    		 DOMHelper,
    		 StringHelper,
    		 IconTitlePane,
    		 Button,
    		 CheckBox,
    		 NumberSpinner,
    		 TextBox,
    		 domClass,
    		 domConstruct,
    		 Evented,
    		 Keys,
    		 on,
    		 declare,
    		 lang,
    		 i18n
    		 ) {
	
	var className = "at.cdes.web.plot.PlotOrderSearchWidget";

	var log = new TinyLog(className);
	
    var PlotOrderSearchWidget = declare(className, Evented, {
    	
    	constructor : function(params) {
    		lang.mixin(this,params);
    		
    		this.topDiv = this.constructTopDiv();
    		this.populateSearchFields();

    		this.allFieldsValid = true;
    	},
    	
    	getWidgetId : function() {
    		return "PlotOrderSearchWidget";
    	},
    	
    	getDataId : function() {
    		return null;
    	},
    	
    	getContainer : function() {
    		return this.topDiv;
    	},
    	
    	constructTopDiv : function() {
    		var topDiv = domConstruct.create("div", null, null);
    		domClass.add(topDiv, "refNodeOfPositionAbsolute plotOrderSearchTopDivFull");
    		
    		this.titlePane = this.constructTitlePane();
    		domConstruct.place(this.titlePane.domNode, topDiv);
    		
    		return topDiv;    		
    	},
    	
    	postTitleClick : function() {
    		var open = this.titlePane.get("open");
    		if (open) {
    			this.titlePane.set("title", i18n.searchOpenCaption);
    			domClass.replace(this.topDiv, "plotOrderSearchTopDivFull", "plotOrderSearchTopDivReduced");
    		} else {
    			this.titlePane.set("title", i18n.searchClosedCaption);
    			domClass.replace(this.topDiv, "plotOrderSearchTopDivReduced", "plotOrderSearchTopDivFull");
    		}
    		on.emit(this, "titlePaneToggled");
    	},
    	
     	constructTitlePane : function() {
     		var searchDiv = this.constructSearchDiv();
     		
			var titlePane = new IconTitlePane({
				         title   : i18n.searchOpenCaption,
    				     content : searchDiv,
				      toggleable : true,
				            open : true,
				  postTitleClick : lang.hitch(this, this.postTitleClick)
			});
			domClass.add(titlePane.domNode, "occupyWholeParent");
			
			return titlePane;
     	},
     	
     	constructSearchDiv : function() {
     		var searchDiv = domConstruct.create("div", null, null);
     		domClass.add(searchDiv, "refNodeOfPositionAbsolute plotOrderSearchDiv");
     		
     		// Job number
     		DOMHelper.createTextNode("div", i18n.plotOrderSearchJobNumberLabel, searchDiv, "propertyLabel plotOrderSearchJobNumberLabel");
     		this.jobNumberTextBox = new TextBox({
     			label : i18n.plotOrderSearchJobNumberLabel,
     			title : i18n.plotOrderSearchJobNumberToolTip
     		});
     		domClass.add(this.jobNumberTextBox.domNode, "fixedDialogWidget plotOrderSearchjobNumberTextBox");     		
     		domConstruct.place(this.jobNumberTextBox.domNode, searchDiv);
     		on(this.jobNumberTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
     		
     		// Organisation name
     		DOMHelper.createTextNode("div", i18n.plotOrderSearchOrganisationLabel, searchDiv, "propertyLabel plotOrderSearchOrganisationLabel");
     		this.organisationTextBox = new TextBox({
     			label : i18n.plotOrderSearchOrganisationLabel,
     			title : i18n.plotOrderSearchOrganisationToolTip
     		});
     		domClass.add(this.organisationTextBox.domNode, "fixedDialogWidget plotOrderSearchOrganisationTextBox");     		
     		domConstruct.place(this.organisationTextBox.domNode, searchDiv);
     		on(this.organisationTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
     		
     		// OrderAddress - Organisation name
     		DOMHelper.createTextNode("div", i18n.plotOrderSearchOrderAddressLabel, searchDiv, "propertyLabel plotOrderSearchOrderAddressLabel");
     		this.orderAddressTextBox = new TextBox({
     			label : i18n.plotOrderSearchOrderAddressLabel,
     			title : i18n.plotOrderSearchOrderAddressToolTip
     		});
     		domClass.add(this.orderAddressTextBox.domNode, "fixedDialogWidget plotOrderSearchOrderAddressTextBox");     		
     		domConstruct.place(this.orderAddressTextBox.domNode, searchDiv); 
     		on(this.orderAddressTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
     		
     		// From
     		DOMHelper.createTextNode("div", i18n.plotOrderSearchFromLabel, searchDiv, "propertyLabel plotOrderSearchFromLabel");
     		this.fromSpinner = new CalendarSpinner({
     			     label : i18n.plotOrderSearchFromLabel,
     			     title : i18n.plotOrderSearchFromToolTip,
        		   pattern : i18n.datePattern,
    		    dndEnabled : false,
         rowObjectToString : null
     		});
     		domClass.add(this.fromSpinner.domNode, "fixedDialogWidget plotOrderSearchFromSpinBox");
     		domConstruct.place(this.fromSpinner.domNode, searchDiv);
     		on(this.fromSpinner.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
     		
     		// To
     		DOMHelper.createTextNode("div", i18n.plotOrderSearchToLabel, searchDiv, "propertyLabel plotOrderSearchToLabel");
     		this.toSpinner = new CalendarSpinner({
     			     label : i18n.plotOrderSearchToLabel,
     			     title : i18n.plotOrderSearchToToolTip,
        		   pattern : i18n.datePattern,
       		    dndEnabled : false,
         rowObjectToString : null
     		});
     		domClass.add(this.toSpinner.domNode, "fixedDialogWidget plotOrderSearchToSpinBox");
     		domConstruct.place(this.toSpinner.domNode, searchDiv); 
     		on(this.toSpinner.domNode, "keyup", lang.hitch(this, this.searchIfEnter));     		
     		
    		// Show complete plot orders checkbox
			this.showCompleteCheckBox = new CheckBox({
				label : i18n.plotOrderSearchShowCompleteLabel,
				title : i18n.plotOrderSearchShowCompleteToolTip
			});
			domClass.add(this.showCompleteCheckBox.domNode, "fixedDialogWidget plotOrderSearchIncludeCompletedCheckBox");
			domConstruct.place(this.showCompleteCheckBox.domNode, searchDiv);
     		on(this.showCompleteCheckBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));     		
			
			DOMHelper.createTextNode("div", i18n.plotOrderSearchShowCompleteLabel, searchDiv, "fixedDialogWidget plotOrderSearchIncludeCompletedLabel");   
     		
			this.searchButton = new Button({
     			label : i18n.searchButtonCaption,
     			title : i18n.plotOrderSearchSearchButtonToolTip
     		});
     		domClass.add(this.searchButton.domNode, "fixedDialogWidget plotOrderSearchSearchButton");
     		domConstruct.place(this.searchButton.domNode, searchDiv);
     		
     		on(this.searchButton, "click", lang.hitch(this, this.doSearch));			
     		
     		return searchDiv;
     	},
    	
     	getSearchModel : function() {
 			var searchModel = {
 					       jobNumber : this.jobNumberTextBox.get("value"),
 					     plotterName : this.organisationTextBox.get("value"),
 					organisationName : this.orderAddressTextBox.get("value"),
 					            from : this.fromSpinner.getUtcSeconds(),
 					              to : this.toSpinner.getUtcSeconds(),
 					includeCompleted : this.showCompleteCheckBox.get("checked")
			};
			
			return searchModel;
     	},
     	
     	populateSearchFields : function() {
    		var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
    		var networkId = this.applicationContext.getPageContextNetworkId();
    		var oldSearchModel = this.applicationContext.getFromLocalStorage([organisationPersonId, networkId], "/plotOrder/search");
    		
    		if (oldSearchModel != null) {
        		var from = !StringHelper.isEmpty(oldSearchModel.from) ? oldSearchModel.from : null;
        		var to = !StringHelper.isEmpty(oldSearchModel.to) ? oldSearchModel.to : null;
        		
        		if (from != null) {
        			this.fromSpinner.setUtcSeconds("value", from);	
        		}
        		if (to != null) {
        			this.toSpinner.setUtcSeconds("value", to);	
        		}        		
        		
        		if (!StringHelper.isEmpty(oldSearchModel.jobNumber)) {
        			this.jobNumberTextBox.set("value", parseInt(oldSearchModel.jobNumber));	
        		}         		
        		this.organisationTextBox.set("value", oldSearchModel.plotterName);
        		this.orderAddressTextBox.set("value", oldSearchModel.organisationName);
        		this.showCompleteCheckBox.set("checked", oldSearchModel.includeCompleted);
    		}
     	},     	
     	
     	searchIfEnter : function(e) {
 			if (e.keyCode == Keys.ENTER) {
 				this.doSearch();
 			}
     	},
     	
     	doSearch : function() {
			on.emit(this, "doSearch");
     	}
    });
    
    return PlotOrderSearchWidget;
});