/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

////css-prefix = planningNotificationProjectList
////i18n-prefix = planningNotificationProjectList


define([ "cdes/core/CdesVoc",
	"cdes/util/ActionHelper",
	"cdes/widget/base/ListWidget",
	"clazzes/TinyLog",
	"clazzes/form/FancyButton",
	"clazzes/util/ErrorHelper",
	"clazzes/widgets/layout/ContentWidget",
	"clazzes/widgets/layout/InfoDialog",
	"dgrid/OnDemandGrid",
	"dgrid/extensions/ColumnResizer",
	"dgrid/extensions/DijitRegistry",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/on",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dstore/Memory",
	"dstore/Trackable",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
	function(CdesVoc,
			ActionHelper,
			ListWidget,
			TinyLog,
			FancyButton,
			ErrorHelper,
			ContentWidget,
			InfoDialog,
			OnDemandGrid,
			ColumnResizer,
			DijitRegistry,
			domClass,
			domConstruct,
			on,		
			declare,
			lang,
			Memory,
			Trackable,
			i18n) {

	var className = "at.cdes.web.planning.project.PlanningNotificationProjectListWidget";

	var log = new TinyLog(className);

	var PlanningNotificationProjectListWidget = declare(className, ListWidget, {

		constructor : function(params) {
			lang.mixin(this, params);

			this.topDiv = this.constructTopDiv();

			this.allFieldsValid = true;
		},

		getWidgetId : function() {
			return "PlanningNotificationProjectListWidget";
		},

		getDataId : function() {
			return null;
		},

		getContainer : function() {
			return this.topDiv;
		},

        columnWidthKey : "planningNotificationProject/columnWidths",

        getLocalStorageContextKeys : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextPnNetworkId();
            return [organisationPersonId, networkId];
        },

		constructColumns : function() {
			var columns = [];

			columns.push({
				field : "code",
				id : "code",
				sortable : true,
				label : i18n.planningNotificationProjectListCodeColumn
			});

			columns.push({
				field : "name",
				id : "name",
				sortable : true,
				label : i18n.planningNotificationProjectListNameColumn
			});	    

			columns.push({
				field : "comment",
				id : "comment",
				sortable : true,
				label : i18n.planningNotificationProjectListCommentColumn
			});

			columns.push({
				field : "id",
				id : "actions",
				renderCell : lang.hitch(this, this.renderActionCell),
				sortable : false,
				label : i18n.actionColumnCaption
			});

			return columns;
		},

		fooFormatter : function(field, dataObject) {
			// TODO
		},

		renderActionCell : function(project, data, cell) {
			var buttonDiv = domConstruct.create("div", null, null);

			if ("editPlanningNotificationProject" in project.allowedActions) {
				var editButton = this.constructEditButton(project);
				domConstruct.place(editButton.domNode, buttonDiv);
			}

			if (!("editPlanningNotificationProject" in project.allowedActions) && project.allowedNetworkActions != null && "insertPlanningNotificationProject" in project.allowedNetworkActions) {
				var makeProjectAdminButton = this.constructMakeProjectAdministratorButton(project);
				domConstruct.place(makeProjectAdminButton.domNode, buttonDiv);
			}

			if ("projectParticipationsOverview" in project.allowedActions) {
				var showProjectParticipationsButton = this.constructShowProjectParticipationsButton(project);
				domConstruct.place(showProjectParticipationsButton.domNode, buttonDiv);
			}

			if ("deletePlanningNotificationProject" in project.allowedActions) { 
				var deleteProjectButton = this.constructDeleteProjectButton(project);
				domConstruct.place(deleteProjectButton.domNode, buttonDiv);
			}

			return buttonDiv;
		},

		constructShowProjectParticipationsButton : function(project) {
			var button = new FancyButton({
				title : i18n.planningNotificationProjectListShowProjectParticipationsToolTip,
				iconClass : "fancyButtonIcon17x18 fancyButton17x18 projectParticipationsButton"
			});

			domClass.add(button.domNode, "listButton");

			on(button, "click", lang.hitch(this, function() {
			    var projectId = project.id;

                            var msgObj = {
                                action : "routerPush",
                                page : "teilnehmerBuek",
                                projectId : projectId
                            };

                            window.parent.postMessage(msgObj, window.origin);

                            /*
				document.location.href = "/cdes/app?service=SecureDirectService/1/ReviewSectionOverview/projectParticipationsOverviewPN/$SecureDirectLink$4"
				+ "&sp=Sproject&sp=SProjectParticipationAdministration&sp=" + projectId + "&ts=" + dojoConfig.tabSessionId;*/

				// Probably rather obscure: The old GWT code handled the case projectId == null, jumping to 
				// SecureDirectService/1/Top/projectParticipationsOverview/$MenuReview.$MenuDirectLink$5&sp=SProjectParticipationAdministration		
			}));
			return button;
		},

    constructEditButton : function(project) {
			var button = new FancyButton({
				title : i18n.planningNotificationProjectListEditToolTip,
				iconClass : "fancyButtonIcon17x18 fancyButton17x18 editButton"
			});

			domClass.add(button.domNode, "listButton");

			on(button, "click", lang.hitch(this, function() {
				this.applicationContext.setPage("projectEdit",
						{ mode : ContentWidget.Mode.EDIT, id : project.id, module : CdesVoc.Module.PLANNING_NOTIFICATION },
						{ backPage : this.backPage, backParams : this.backParams });
			}));
			return button;
		},

		constructMakeProjectAdministratorButton : function(project) {
			var button = new FancyButton({
				title : i18n.planningNotificationProjectListMakeProjectAdminToolTip,
				iconClass : "fancyButtonIcon17x18 fancyButton17x18 makeProjectAdminButton"
			});

			domClass.add(button.domNode, "listButton");

			on(button, "click", lang.hitch(this, function() {
				this.askMakeProjectAdministrator(project);
			}));
			return button;
		},	    

		askMakeProjectAdministrator : function(project) {
			InfoDialog.showQuestion({
				title : i18n.planningNotificationProjectListAskMakeProjectAdministratorDialogCaption,
				message : i18n.planningNotificationProjectListAskMakeProjectAdministratorDialogQuestion,
				buttons : [
					{ type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
						this.makeProjectAdministrator(project);
					})},    			           
					{ type : InfoDialog.Button.NO }
					]
			});    		
		},

		makeProjectAdministrator : function(project) {
			var networkService = this.applicationContext.getService("networkService");
			this.registerAsyncOperationStarted(PlanningNotificationProjectListWidget.AsyncOperation.MAKE_PROJECT_ADMIN);

			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
			var networkId = this.applicationContext.getPageContextPnNetworkId();	    
			networkService.makeProjectAdministrator(organisationPersonId, networkId, project.id).then(
					lang.hitch(this, function() {
						this.registerAsyncOperationFinished(PlanningNotificationProjectListWidget.AsyncOperation.MAKE_PROJECT_ADMIN);

						this.reload();
					}),
					lang.hitch(this, function(err) {
						ErrorHelper.processAsyncError({
							err : err,
							widget : this,
							asyncOperation : PlanningNotificationProjectListWidget.AsyncOperation.MAKE_PROJECT_ADMIN,
							opName : "makeProjectAdministrator",
							message : i18n.planningNotificationProjectListMakeProjectAdminFailed
						});
					})).otherwise(
							lang.hitch(this, function(err) {
								log.error("Error while calling function [makeProjectAdministrator]", err);
							}));

		},

		constructDeleteProjectButton : function(project) {
			var button = new FancyButton({
				title : i18n.planningNotificationProjectListDeleteProjectToolTip,
				iconClass : "fancyButtonIcon17x18 fancyButton17x18 deleteButton"
			});

			domClass.add(button.domNode, "listButton");

			on(button, "click", lang.hitch(this, function() {
				this.askDeleteProject(project);
			}));
			return button;
		},	    

		askDeleteProject : function(project) {
			InfoDialog.showQuestion({
				title : i18n.planningNotificationProjectListAskDeleteProjectDialogCaption,
				message : i18n.planningNotificationProjectListAskDeleteProjectDialogQuestion,
				buttons : [
					{ type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
						this.deleteProject(project);
					})},    			           
					{ type : InfoDialog.Button.NO }
					]
			});    		
		},

		deleteProject : function(project) {
			var planningNotificationService = this.applicationContext.getService("planningNotificationService");
			this.registerAsyncOperationStarted(PlanningNotificationProjectListWidget.AsyncOperation.DELETE);

			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
			planningNotificationService.deletePlanningNotificationProject(organisationPersonId, project.id).then(
					lang.hitch(this, function(result) {
						this.registerAsyncOperationFinished(PlanningNotificationProjectListWidget.AsyncOperation.DELETE);
						if (!result){
							InfoDialog.showError({
							     title : i18n.planningNotificationProjectListDeleteProjectFailedCaption,
							    message : i18n.planningNotificationProjectListDeleteProjectFailedToolTip
							});
						}else
							on.emit(this, "doSearch");
					}),
					lang.hitch(this, function(err) {
						ErrorHelper.processAsyncError({
							err : err,
							widget : this,
							asyncOperation : PlanningNotificationProjectListWidget.AsyncOperation.DELETE,
							opName : "deletePlanningNotificationProject",
							message : i18n.planningNotificationProjectListDeleteProjectFailed
						});
					})).otherwise(
							lang.hitch(this, function(err) {
								log.error("Error while calling function [deletePlanningNotificationProject]", err);
							}));

		},	

		constructTopDiv : function() {
			var grid = this.constructGrid({
				idProperty : "id", 
				gridId : "PlanningNotificationProjectListWidgetGrid"
			});

			on(grid, "dgrid-sort", lang.hitch(this, function(e) {
				var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
				var networkId = this.applicationContext.getPageContextPnNetworkId();
				this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotificationProject/sort", e.sort);
			}));

			return grid;	    
		},

		resize : function(newSize) {
			this.grid.resize(newSize);
		},

		setData : function(params) {
			this.projects = params.projects;
			var projectIdToAllowedActions = params.projectIdToAllowedActions;
			var actionsForNetwork = params.actionsForNetwork;
			for (var n = 0; n < this.projects.length; n++) {
				var project = this.projects[n];
				var allowedActionsList = projectIdToAllowedActions[project.id];
				var allowedActionsSet = new Object();
				for (var z = 0; allowedActionsList != null && z < allowedActionsList.length; z++) {
					allowedActionsSet[allowedActionsList[z]] = true;
				}

				project.allowedActions = allowedActionsSet;
				project.allowedNetworkActions = actionsForNetwork;
			}

			this.reload();
		},

		reload : function(params) {

			this.store.setData(this.projects);

			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
			var networkId = this.applicationContext.getPageContextPnNetworkId();
			var oldSort = this.applicationContext.getFromLocalStorage([organisationPersonId, networkId], "/planningNotificationProject/sort");

			if (oldSort == null) {
				this.grid.set("sort", "code", false);
				this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotificationProject/sort", this.grid.get("sort"));
			} else {
				this.grid.set("sort", oldSort);
			}		

			this.grid.updateSortArrow(this.grid.sort);
			this.grid.refresh();
		},

		destroy : function() {
			this.inherited(arguments);

			this.grid.destroy();
		}
	});

	PlanningNotificationProjectListWidget.AsyncOperation = {
			MAKE_PROJECT_ADMIN : "MakeProjectAdmin",
			DELETE : "Delete"	
	};

	return PlanningNotificationProjectListWidget;
});
