define([ 
         "cdes/core/CdesVoc",
    	 "cdes/util/FancyColumnResizer",
    	 "cdes/util/JobHelper",
    	 "cdes/widget/base/ListWidget",
         "clazzes/TinyLog",
         "clazzes/topic",
         "clazzes/dateTime/DateHelper",
         "clazzes/util/DOMHelper",
         "clazzes/util/ErrorHelper",
         "clazzes/widgets/layout/ContentWidget",
         "clazzes/widgets/DisableButton",
         "clazzes/widgets/layout/InfoDialog",
         "dgrid/Editor",
         "dgrid/OnDemandGrid",
         "dgrid/Selection",
         "dgrid/extensions/ColumnResizer",
         "dgrid/extensions/DijitRegistry",
         "dgrid/util/misc",
         "dojo/dom-class",
         "dojo/dom-construct",
         "dojo/io-query",
         "dojo/on",
         "dojo/string",
         "dojo/_base/declare",
         "dojo/_base/lang",
         "dstore/Memory",
         "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
       ],
    function(
    	CdesVoc,
        FancyColumnResizer,
    	JobHelper,
        ListWidget,        
    	TinyLog,
    	topic,
    	DateHelper,
    	DOMHelper,
        ErrorHelper,
    	ContentWidget,
    	DisableButton,
        InfoDialog,
    	Editor,
    	OnDemandGrid,
    	Selection,
    	ColumnResizer,
    	DijitRegistry,
    	dgridMiscUtil,
    	domClass,
    	domConstruct,
    	ioQuery,
    	on,
    	string,
    	declare,
    	lang,
    	Memory,
    	i18n
    ) {
	
	var className = "at.cdes.web.plot.PlotOrderListWidget";

	var log = new TinyLog(className);
	
    var PlotOrderListWidget = declare(className, ListWidget, {
    	
    	constructor : function(params) {
    		lang.mixin(this,params);
    		
    		this.topDiv = this.constructTopDiv();
    		
    		this.allFieldsValid = true;
    	},
    	
    	getWidgetId : function() {
    		return "PlotOrderListWidget";
    	},
    	
    	getDataId : function() {
    		return null;
    	},
    	
    	getContainer : function() {
    		return this.topDiv;
    	},
    	
        columnWidthKey : "plotOrderList/columnWidths",

        getLocalStorageContextKeys : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextNetworkId();
            return [organisationPersonId, networkId];
        },

    	constructColumns : function() {
    		var columns = [];
    		
       		columns.push({
       				field : "_jobNumber",
       				   id : "plotOrderJobNumber",
       		    formatter : lang.hitch(this, this.jobNumberFormatter),
  	             sortable : true,
  			        label : i18n.plotOrderListOrderNumberColumnCaption
       		});
       		
       		columns.push({
   				    field : "_plotter",
   				       id : "organisationId",
   				formatter : lang.hitch(this, this.plotterFormatter),
	             sortable : true,
			        label : i18n.plotOrderListContractorColumnCaption
       		});
       		
       		columns.push({
				    field : "_customer",
				       id : "billingAddressId",
				formatter : lang.hitch(this, this.customerFormatter),
				 sortable : true,
		            label : i18n.plotOrderListCustomerColumnCaption
       		});
       		
       		columns.push({
			         field : "_request",
			            id : "requestStepId",
			     formatter : lang.hitch(this, this.requestFormatter),
			      sortable : true,
	                 label : i18n.plotOrderListCreationColumnCaption
       		});
       		
       		columns.push({
		             field : "_acceptance",
		                id : "acceptanceStepId",
		         formatter : lang.hitch(this, this.acceptanceFormatter),
		          sortable : true,
                     label : i18n.plotOrderListReceiptColumnCaption
       		});
       		
       		columns.push({
	                 field : "_completed",
	                    id : "completedStepId",
	             formatter : lang.hitch(this, this.completedFormatter),
	              sortable : true,
                     label : i18n.plotOrderListDeliveryColumnCaption
       		});
       		
       		columns.push({
                     field : "_received",
                        id : "received",
                 formatter : lang.hitch(this, this.receivedFormatter),
                  sortable : true,
                     label : i18n.plotOrderListDeliveredAmountColumnCaption
       		});
       		
       		columns.push({
                     field : "charged",
                        id : "charged",
                 formatter : lang.hitch(this, this.chargedFormatter),
                  sortable : true,
                     label : i18n.plotOrderListChargedColumnCaption
       		});
       		
       		if (this.mode == PlotOrderListWidget.Mode.DEFAULT) {
    			columns.push({
			         field : "plotOrderId",
			            id : "actions",
		        renderCell : lang.hitch(this, this.renderActionCell),			            
			      sortable : true,
			         label : i18n.actionColumnCaption 
    			});       			
       		}        		
 		
    		return columns;
    	},
    	
    	jobNumberFormatter : function(jobNumber, plotOrderJoin) {
    		return plotOrderJoin.plotOrderJobNumber != null ? plotOrderJoin.plotOrderJobNumber.toString() : "---";
    	},
    	
    	plotterFormatter : function(organisationId, plotOrderJoin) {
    		return plotOrderJoin.plotterName + "<br>"
    			 + plotOrderJoin.plotterPostalAddress + "<br>"
    			 + plotOrderJoin.plotterPostalCode + " " + plotOrderJoin.plotterLocalityName + "<br>"
    			 + plotOrderJoin.plotterCountryDescDe;
    	},
    	
    	customerFormatter : function(billingAddressId, plotOrderJoin) {
    		return plotOrderJoin.billingAddressOrganisationName + "<br>"
    			 + plotOrderJoin.billingAddressPostalAddress + "<br>"
    			 + plotOrderJoin.billingAddressPostalCode + " " + plotOrderJoin.billingAddressLocalityName + "<br>"
    			 + plotOrderJoin.orderAddressCountryDescDe;
    	},
    	
    	requestFormatter : function(requestStepId, plotOrderJoin) {
    		if (plotOrderJoin.requestStepFinished != null) {
    			return DateHelper.formatUtcSecondsWithTimeZone(plotOrderJoin.requestStepFinished, this.applicationContext.getTimeZone(), i18n.dateWithSecondsPattern);	
    		} else {
    			return "";
    		}    		
    	},
    	
    	acceptanceFormatter : function(acceptanceStepId, plotOrderJoin) {
    		if (plotOrderJoin.acceptanceStepFinished != null) {
    			var modeString;
    			if (plotOrderJoin.acceptanceStepAcceptedMode == 0) {
    				modeString = null;
    			} else if (plotOrderJoin.acceptanceStepAcceptedMode == 1) {
    				modeString = i18n.plotOrderListReceivedState;
    			} else if (plotOrderJoin.acceptanceStepAcceptedMode == 2) {
    				modeString = i18n.plotOrderListDeclinedState;
    			}    			
    			
    			return DateHelper.formatUtcSecondsWithTimeZone(plotOrderJoin.acceptanceStepFinished, this.applicationContext.getTimeZone(), i18n.dateWithSecondsPattern)
    							+ (modeString != null ? "<br>" + modeString : "");
    		} else {
    			return "";
    		}       		
    	},
    	
    	completedFormatter : function(completedStepId, plotOrderJoin) {
    		if (plotOrderJoin.completedStepFinished != null) {
    			var modeString;
    			if (plotOrderJoin.completedStepAcceptedMode == 0) {
    				modeString = null;
    			} else if (plotOrderJoin.completedStepAcceptedMode == 1) {
    				modeString = i18n.plotOrderListOkState;
    			} else if (plotOrderJoin.completedStepAcceptedMode == 2) {
    				modeString = i18n.plotOrderListNotOkState;
    			}    			
    			
    			return DateHelper.formatUtcSecondsWithTimeZone(plotOrderJoin.completedStepFinished, this.applicationContext.getTimeZone(), i18n.dateWithSecondsPattern)
								+ (modeString != null ? "<br>" + modeString : "");    			
    		} else {
    			return "";
    		}   
    	},   
    	
    	receivedFormatter : function(plottOrderId, plotOrderJoin) {
    		
    		var countTotal = plotOrderJoin.plotOrderCountsCountTotal;
    		var countSigned = plotOrderJoin.plotOrderCountsCountSigned;
    		var countDeclined = plotOrderJoin.plotOrderCountsCountDeclined;
    		
        	if (countSigned == countTotal && countDeclined == 0) {
        		return i18n.plotOrderListAllOk;
        	} else if (countSigned == countTotal && countDeclined != 0) {
        		return i18n.plotOrderListNotOk;
        	} else {
        		return string.substitute(i18n.plotOrderListSomeOk, {
        			   ok : countSigned.toString(),
        			notOk : countTotal.toString() 
        		});
        	}
    	},    
    	
    	chargedFormatter : function(plottOrderId, plotOrderJoin) {
    		if (plotOrderJoin.chargedStepFinished != null) {
    			return DateHelper.formatUtcSecondsWithTimeZone(plotOrderJoin.chargedStepFinished, this.applicationContext.getTimeZone(), i18n.dateWithSecondsPattern);
    		} else {
    			return "";
    		}
    	},
    	
    	renderActionCell : function(joinDto, data, cell) {
    		var buttonDiv = domConstruct.create("div", null, null);
    		
    		var project = this.applicationContext.getPageContextProject();
    		
    		if (project != null) {
        		//delete plottOrder
        		if (this.applicationContext.isActionAllowedForProject("editProject") 
    				&& project.access == CdesVoc.ProjectAccess.READ_WRITE
        			&& joinDto.acceptanceStepSignatureId == null) {
        			var deleteButton = this.constructDeleteButton(joinDto);
        			domConstruct.place(deleteButton.domNode, buttonDiv);
        		}
        		//call plottOrderEdit page
        		if (this.applicationContext.isActionAllowedForProject("showProjectPlotOrders")
       				 	&& project.access == CdesVoc.ProjectAccess.READ_WRITE
        				&& joinDto.acceptanceStepSignature == null) {
        			var editButton = this.constructEditButton(joinDto);
        			domConstruct.place(editButton.domNode, buttonDiv);
        		}/* else if (this.applicationContext.isActionAllowedForProject("showProject")
        				|| this.applicationContext.isActionAllowedForProject("showProjectPlotOrders")) {
        			
        			var showButton = this.constructShowButton(joinDto);
        			domConstruct.place(showButton.domNode, buttonDiv);
        		}*/
        		
        		//Lieferung bestätigen
/*        		if (this.applicationContext.isActionAllowedForProject("chargePlotOrder")
        			&&  joinDto.acceptanceStepAcceptedMode != CdesVoc.OrderStepMode.DECLINED
        			&&  joinDto.completedStepAcceptedMode != CdesVoc.OrderStepMode.DECLINED
        			&& (joinDto.plotOrderCountsCountTotal == 0 || joinDto.plotOrderCountsCountSigned != joinDto.plotOrderCountsCountTotal)
        			&&  joinDto.plotOrderCountsCountOwn > 0){
        			
        			var confirmDeliveryButton = this.constructConfirmDeliveryButton(joinDto);
        			domConstruct.place(confirmDeliveryButton.domNode, buttonDiv);
        		}*/
        		//call plottOrder charge (verrechnet erklären)
        		if (this.applicationContext.isActionAllowedForProject("editProject")
        				&& joinDto.chargedStepSignatureId == null 
        				&& joinDto.plotOrderCountsCountSigned != null
        				&& joinDto.plotOrderCountsCountDeclined != null
        				&& joinDto.plotOrderCountsCountTotal != null 
        				&& joinDto.plotOrderCountsCountSigned + joinDto.plotOrderCountsCountDeclined == joinDto.plotOrderCountsCountTotal) {
        			var chargeButton = this.constructChargeButton(joinDto);
        			domConstruct.place(chargeButton.domNode, buttonDiv);
        		}
        		
        		//download zip- archive
        		if (this.applicationContext.isActionAllowedForProject("showProjectPlotOrders")
            			&&  joinDto.acceptanceStepAcceptedMode == CdesVoc.OrderStepMode.ACCEPTED) {
        			var zipExportButton = this.constructZipExportButton(joinDto);
        			domConstruct.place(zipExportButton.domNode, buttonDiv);
        		}
    		}
    		
    		return buttonDiv;
    	},    	
    	
    	
    	/********************************************** Action Buttons ************************************************/
    	
    	constructDeleteButton : function(joinDto) {
       	 	return new DisableButton({
       	 		        label : i18n.deleteButtonCaption,
       	 		    showLabel : false,
       	 		        title : i18n.plotOrderListDeleteButtonToolTip,
   			          onClick : lang.hitch(this, function() {
   			        	  this.deletePlotOrder(joinDto);
   			          }),
                    iconClass : "deleteButton",
                      "class" : "cdesWebButton17x18 gridButton",
             controllerWidget : this,
                 disableEvent : "disableButtons",
             _destroyOnRemove : true
       	 	});
    	},
    	
    	constructEditButton : function(joinDto) {
       	 	return new DisableButton({
       	 		        label : i18n.editButtonCaption,
       	 		    showLabel : false,
       	 		        title : i18n.plotOrderListEditButtonToolTip,
   			          onClick : lang.hitch(this, function() {
   			        	  this.applicationContext.setPage("plotOrderEdit", {
   			        		 id : joinDto.plotOrderId 
   			        	  }, {from : "plotOrders"});
   			          }),
                    iconClass : "editButton",
                      "class" : "cdesWebButton17x18 gridButton",
             controllerWidget : this,
                 disableEvent : "disableButtons",
             _destroyOnRemove : true
       	 	});
    	},
    	
    	constructShowButton : function(joinDto) {
       	 	return new DisableButton({
       	 		        label : i18n.showButtonCaption,
       	 		    showLabel : false,
       	 		        title : i18n.plotOrderListShowButtonToolTip,
   			          onClick : lang.hitch(this, function() {
   			        	  //TODO:
   			          }),
                    iconClass : "showButton",
                      "class" : "cdesWebButton17x18 gridButton",
             controllerWidget : this,
                 disableEvent : "disableButtons",
             _destroyOnRemove : true
       	 	});
    	},
    	
    	constructConfirmDeliveryButton : function(joinDto) {
       	 	return new DisableButton({
       	 		        label : i18n.plotOrderListDeliveryButtonCaption,
       	 		    showLabel : false,
       	 		        title : i18n.plotOrderListDeliveryButtonToolTip,
   			          onClick : lang.hitch(this, function() {
                                      var msgObj = {
                                          action : "routerPush",
                                          page : "plotOrderAcceptanceTask",
                                          plotOrderId : joinDto.plotOrderId
                                      };

                                      window.parent.postMessage(msgObj, window.origin);                                  

//   			        	  document.location.href = "/cdes/app?service=SecureDirectService/1/ProjectPlotOrderOverview/showProjectPlotOrders/receiveOrder&sp=" + joinDto.plotOrderId + "&ts=" + dojoConfig.tabSessionId;
   			          }),
                    iconClass : "plotOrderDeliveryButton",
                      "class" : "cdesWebButton17x18 gridButton",
             controllerWidget : this,
                 disableEvent : "disableButtons",
             _destroyOnRemove : true
       	 	});
    	},
    	
    	constructChargeButton : function(joinDto) {
    		return new DisableButton({
    			             label : i18n.plotOrderListChargeButtonCaption,
    			         showLabel : false,
    			             title : i18n.plotOrderListChargeButtonToolTip,
    			           onClick : lang.hitch(this, function() {
    			        	   this.declarePlotOrdersCharged([joinDto]);
    			           }),
                         iconClass : "plotOrderChargeButton",
                           "class" : "cdesWebButton17x18 gridButton",
                  controllerWidget : this,
                      disableEvent : "disableButtons",
                  _destroyOnRemove : true    			      
    			      
    		      });
    	},
    	
    	constructZipExportButton : function(joinDto) {
       	 	return new DisableButton({
	 	    	        label : i18n.plotOrderListZipExportButtonCaption,
	 	    	    showLabel : false,
	 		            title : i18n.plotOrderListZipExportButtonToolTip,
		              onClick : lang.hitch(this, function() {
		            	  this.triggerZipExport(joinDto);
		              }),
		            iconClass : "downloadIcon",
		              "class" : "cdesWebButton17x18 gridButton",
             controllerWidget : this,
                 disableEvent : "disableButtons",
             _destroyOnRemove : true
       	 	});    		
    	},
    	
    	constructTopDiv : function() {

    		var columns = this.constructColumns();
    		this.store = new Memory({data : [], idProperty : "plotOrderId"});
    		
    		var MyGrid = declare([OnDemandGrid, FancyColumnResizer, DijitRegistry, Selection, Editor]);
    		this.grid = new MyGrid({
    			collection : this.store,
    			   columns : columns
    			   		//id : "PlotOrderListGrid"
    		});
    		domClass.add(this.grid.domNode, "plotOrderListGrid");

            this.grid.afterResizeMouseUp = lang.hitch(this, this.handleColumnResize);
    		
    		this.grid.startup();
    		
//    		this.gridRuleSelectorPrefix = "#" + dgridMiscUtil.escapeCssIdentifier(this.grid.domNode.id) + " .dgrid-column-";
    		
    		return this.grid.domNode;
    	},
    	
    	resize : function(newSize) {
    		this.grid.resize(newSize);
    	},
    	
    	setData : function(params) {
    		
    		this.plotOrderJoins = params.data;
    		this.updateAuxiliaryData();
    		
    		/*
    		log.info("Start: setData")
    		
    		this.planDeliverJoinDtos = dataAndColumns.data;
    		for (var n = 0; n < this.planDeliverJoinDtos.length; n++) {
    			var joinDto = this.planDeliverJoinDtos[n];
    			this.calculateStartDateStrings(joinDto);
    			this.calculateEndDateStrings(joinDto);
    		}
    		
    		if (dataAndColumns.columns) {
    			this.setColumnSettings(dataAndColumns.columns);	
    		}    		
    		this.objectPlannerIdToActions = dataAndColumns.objectPlannerIdToActions;
    		*/
    		this.reload();
    	},
    	
    	updateAuxiliaryData : function() {
    		for (var n = 0; n < this.plotOrderJoins.length; n++) {
    			var joinDto = this.plotOrderJoins[n];
    			joinDto._jobNumber = this.jobNumberFormatter(null, joinDto);
    			joinDto._plotter = this.plotterFormatter(null, joinDto);
    			joinDto._customer = this.customerFormatter(null, joinDto);
    			joinDto._request = this.requestFormatter(null, joinDto);
    			joinDto._acceptance = this.acceptanceFormatter(null, joinDto);
    			joinDto._completed = this.completedFormatter(null, joinDto);
    			joinDto._received = this.receivedFormatter(null, joinDto);
    		}
    	},
    	
    	//PLAN_DELIVER_SORT_PROPERTIES : [{ attribute : "documentName", descending : false}],
    	    	
    	reload : function() {    	    		
    		this.store.setData(this.plotOrderJoins);
    		this.grid.refresh();
    		
    		log.info("End: reload");

    	},
    	
    	getPlotOrderJoins : function() {
    		return this.plotOrderJoins;
    	},
    	
    	deletePlotOrder : function(joinDto) {
    		InfoDialog.showQuestion({
    			  title : i18n.plotOrderItemListReallyDeleteCaption,
    			message : string.substitute(i18n.plotOrderListReallyDeleteText, {
    				plotOrderNumber : this.jobNumberFormatter(null, joinDto),
    					   customer : joinDto.billingAddressOrganisationName,
    				     contractor : joinDto.plotterName,
    				   creationDate : this.requestFormatter(null, joinDto)
    			}),
    			buttons : [
    			           { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
    			        	   this.doDeletePlotOrder(joinDto);
    			           })},    			           
    			           { type : InfoDialog.Button.NO }
    			           ]
      		});      		
    	},
    	
    	doDeletePlotOrder : function(joinDto) {
    		var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
    		var projectId = this.applicationContext.getPageContextProjectId();
    		
    		var plotService = this.applicationContext.getService("plotService");
    		
    		this.registerAsyncOperationStarted(PlotOrderListWidget.AsyncOperation.DELETE_PLOT_ORDER);
    		plotService.deletePlotOrder(joinDto.plotOrderId, organisationPersonId, projectId).then(lang.hitch(this, function() {

    				topic.publish("message/ok", string.substitute(i18n.plotOrderListDeleteOk, {
    					jobNumber : joinDto.plotOrderJobNumber
    				}));
    			
    				// Remove the deleted document from the grid, and update its contents without reloading data from the server
    				var newJoinDtos = [];
    				for (var n = 0; n < this.plotOrderJoins.length; n++) {
    					if (this.plotOrderJoins[n].plotOrderId != joinDto.plotOrderId) {
    						newJoinDtos.push(this.plotOrderJoins[n]);
    					}
    				}
    				this.plotOrderJoins = newJoinDtos;

    				this.reload();
    				
    				this.registerAsyncOperationFinished(PlotOrderListWidget.AsyncOperation.DELETE_PLOT_ORDER);
    			}),
    			lang.hitch(this, function(err) {
       				ErrorHelper.processAsyncError({
                                 err : err,
                              widget : this,
                      asyncOperation : PlotOrderListWidget.AsyncOperation.DELETE_PLOT_ORDER,
                              opName : "deletePlotOrder",
                             message : i18n.plotOrderListDeleteFailed
       				});    				
				})
    		).otherwise(lang.hitch(this, function(err) {
    			log.error("Error while processing the results of a call to deletePlotOrder: ", err);
    		}));    		
    	},
    	
    	declarePlotOrdersCharged : function(joinDtos) {
    		var params = new Object();
    		for (var n = 0; n < joinDtos.length; n++) {
    			params["id" + (n + 1).toString()] = joinDtos[n].plotOrderId;
    		}
    		
     		this.applicationContext.setPage("plotOrderCharge", params, {
     			// Pass no additional data to ensure that always the current data is displayed in the PlotOrderChargePage
     		});    		
    	},
    	
    	triggerZipExport : function(joinDto) {
    		var plotService = this.applicationContext.getService("plotService");
    		
			topic.publish("message/info", i18n.plotOrderListExportPlotOrderStarted);

    		this.registerAsyncOperationStarted(PlotOrderListWidget.AsyncOperation.EXPORT_PLOT_ORDER);
    		
    		var projectId = this.applicationContext.getPageContextProjectId();
    		var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
    		var personVariablesUserLocale = this.applicationContext.getPageContextPersonVariablesUserLocale();
    		
    		// TODO: Pass additional data for privilege check    		
    		plotService.triggerExportCompletePlotOrder(organisationPersonId, projectId, joinDto.plotOrderId, personVariablesUserLocale).then(lang.hitch(this, function(jobId) {
    			// TODO: Treat the case that the jobStatus code throws an exception correctly.  Currently, it will log the error, but
    			// *not* jump into the ErrorHelper code below.
				JobHelper.registerJobStatusQueryForDownload(this.applicationContext, jobId, function(jobId) {
					topic.publish("message/ok", i18n.plotOrderListExportPlotOrderFinished);
					var parameterString = ioQuery.objectToQuery({
						jobId : jobId
					});
					return "/cdes-dojo-impl/download?" + parameterString;
				});
				this.registerAsyncOperationFinished(PlotOrderListWidget.AsyncOperation.EXPORT_PLOT_ORDER);
			}),
			lang.hitch(this, function(err) {
   				ErrorHelper.processAsyncError({
                             err : err,
                          widget : this,
                  asyncOperation : PlotOrderListWidget.AsyncOperation.EXPORT_PLOT_ORDER,
                          opName : "triggerExportCompletePlotOrder",
                         message : i18n.plotOrderListExportPlotOrderFailed
   				});    				
			})
		).otherwise(lang.hitch(this, function(err) {
			log.error("Error while processing the results of a call to triggerExportCompletePlotOrder: ", err);
		}));     		
    	},
    	
    	declareSelectedPlotOrdersCharged : function() {
    		var selectedPlotOrderJoins = [];
    		for (var n = 0; n < this.plotOrderJoins.length; n++) {
    			var plotOrderId = this.plotOrderJoins[n].plotOrderId;
    			if (plotOrderId in this.grid.selection) {
    				selectedPlotOrderJoins.push(this.plotOrderJoins[n]);
    			}
    		}
    		
    		var params = new Object();
    		for (var n = 0; n < selectedPlotOrderJoins.length; n++) {
    			params["id" + (n + 1).toString()] = selectedPlotOrderJoins[n].plotOrderId;
    		}
    		
    		if (selectedPlotOrderJoins.length > 0) {
        		this.applicationContext.setPage("plotOrderCharge", params, {
         			// Pass no additional data to ensure that always the current data is displayed in the PlotOrderChargePage    			
        		});    			
    		} else {
    			InfoDialog.showError({ title : i18n.plotOrderListChargeNothingSelectedCaption, message : i18n.plotOrderListChargeNothingSelectedMessage });    			
    		}
    	},

    	/*
    	save : function() {
    		this.grid.save();
    	},
    	
    	getPlanDeliverJoinDtos : function() {
    		return this.planDeliverJoinDtos;
    	},
    	    	*/
    	
    	/***************************************** Filter *******************************************/
    	
    	filter : function(searchString) {
/*
    		// Don´t filter too often.  If filtering starts while one is typing, and the list is big,
    		// then the textbox freezes while one types until filtering has finished.
			if (this.filterHandle) {
				window.clearInterval(this.filterHandle);
				delete this.filterHandle;
			}
			
			this.filterHandle = window.setInterval(lang.hitch(this, function() {
				this.startFilterUtcMillis = (new Date()).getTime();
				
				var searchStrings = StringHelper.isEmpty(searchString) ? [] : searchString.split(",");
				var trimmedSearchStrings = [];
				for (var n = 0; n < searchStrings.length; n++) {
					if (searchStrings[n] && searchStrings[n].trim().length > 0) {
						trimmedSearchStrings.push(searchStrings[n].trim());
					}
				}
				
	   			var middleMillis = (new Date()).getTime();
				
	   			for (var n = 0; n < this.planDeliverJoinDtos.length; n++) {
	       			var row = this.grid.row(n);
	       			this.filterRow(row.data, row.element, trimmedSearchStrings);
	       		}
	   			
	   			var endMillis = (new Date()).getTime();
	   			log.info("Finished filtering after " + (endMillis - this.startFilterUtcMillis) + "ms");
	   			
	   			window.clearInterval(this.filterHandle);
	   			delete this.filterHandle;
			}), 0);
*/			    		
    	},
    	
    	filterRow : function(joinDto, rowNode, searchStrings) {
/*    		    		
    		if (searchStrings.length == 0) {
    			domClass.remove(rowNode, "hiddenRow");
    		} else {
    			var tokens = [];
    			
    			if (this.columnSettings.showPlannerPerson && this.columnSettings.showPlannerOrganisation) {
    				tokens.push(this.plannerFormatter(null, joinDto));
    			}
    			if (this.columnSettings.showObjectNumber && this.columnSettings.showObjectName) {
    				tokens.push(this.objectFormatter(null, joinDto));
    			}
    			if (this.columnSettings.showObjectPlannerCode && this.columnSettings.showObjectPlannerName) {
    				tokens.push(this.objectPlannerFormatter(null, joinDto));
    			}
    			if (this.columnSettings.showDocumentNumber) {  // No bug, just the number is stored in field "name", and the name in "content"...
    				tokens.push(joinDto.documentName);	
    			}
    			if (this.columnSettings.showDocumentName) {
    				tokens.push(joinDto.documentContent);	
    			}
    			if (this.columnSettings.showScale) {
        			tokens.push(joinDto.documentScale);    				
    			}
    			if (this.columnSettings.showStart) {
    				tokens.push(joinDto.startDateFormatted);
    			}
    			if (this.columnSettings.showEnd) {
    				tokens.push(joinDto.endDateFormatted);
    			}
    			if (this.columnSettings.showPeriod) {
    				tokens.push(joinDto.documentDuration);
    			}
    			if (this.columnSettings.showComment) {
    				tokens.push(joinDto.documentComment);
    			}
    			
    			var allFound = true;

				for (var z = 0; z < searchStrings.length; z++) {
					
					var found = false;
					for (var n = 0; n < tokens.length; n++) {
						if (tokens[n] != null) {
							if (!(typeof tokens[n] == "string")) {
								tokens[n] = tokens[n].toString();
							}	
        				
            				if (tokens[n].indexOf(searchStrings[z]) != -1) {
            					found = true;
            					break;
            				}        					
        				}    					
    				}
					
					if (!found) {
						allFound = false;
						break;
					}
    			}
    			
    			if (allFound) {
    				domClass.remove(rowNode, "hiddenRow");
    			} else {
    				domClass.add(rowNode, "hiddenRow");
    			}
    		}
*/    		
    	},
    	
    	/****************************************** CanEdit ******************************************/
    	/*
    	canEditDocumentContent : function(joinDto) {
    		return this.editing && ActionHelper.hasObjectPlannerPermission(this.objectPlannerIdToActions, joinDto.objectPlannerId, "editPlanDeliverCatalogue");
    	},
    	*/
    	
    	/**************************************** Formatters *****************************************/
    	
    	/*
    	plannerFormatter : function(projectParticipationId, planDeliverJoinDto) {
    		if (this.columnSettings.showPlannerPerson && this.columnSettings.showPlannerOrganisation) {
		    	return string.substitute(i18n.planDeliverPlannerString, {
		    		organisation : planDeliverJoinDto.organisationName,
		    		      person : NameHelper.getPersonCommonName(planDeliverJoinDto, "person")
		    	});				
			} else if (this.columnSettings.showPlannerPerson) {
				return NameHelper.getPersonCommonName(planDeliverJoinDto, "person");
			} else if (this.columnSettings.showPlannerOrganisation) {
				return planDeliverJoinDto.organisationName;
			} else {
				return "";
			}    		
    	},
    	*/
    	
    	destroy : function() {
    		this.inherited(arguments);
    		this.grid.destroy();
    	}
    });
    
    PlotOrderListWidget.AsyncOperation = {
        	DELETE_PLOT_ORDER : "DeletePlotOrder",
        	EXPORT_PLOT_ORDER : "ExportPlotOrder"
    };
    
    PlotOrderListWidget.Mode = {
        	DEFAULT         : "Default",
        	CHARGE          : "Charge"
        };    
    
    return PlotOrderListWidget;
});
