/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

////css-prefix = jobResultPage
////i18n-prefix = jobResultPage


         
define([
    "cdes/admin/job/JobResultListWidget",
    "cdes/core/CdesVoc",
    "cdes/widget/ContextBar",
    "clazzes/TinyLog",
    "clazzes/topic",
    "clazzes/util/DOMHelper",
    "clazzes/util/ErrorHelper",
    "clazzes/widgets/layout/ContentWidget",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/json",
    "dojo/on",	 
    "dojo/string",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(
    JobResultListWidget,
    CdesVoc,
    ContextBar,
    TinyLog,
    topic,
    DOMHelper,
    ErrorHelper,
    ContentWidget,
    domClass,
    domConstruct,
    domStyle,
    json,
    on,		
    string,
    declare,
    lang,
    i18n) {

	var className = "at.cdes.web.admin.job.JobResultPage";

	var log = new TinyLog(className);

	var JobResultPage = declare(className, ContentWidget, {

		constructor : function(params) {
                    // jobId

		    lang.mixin(this, params);

		    this.topDiv = this.constructTopDiv();

		    this.allFieldsValid = true;
                    this.reload();
		},

		getWidgetId : function() {
			return "JobResultPage";
		},

		getDataId : function() {
			return null;
		},

		getContainer : function() {
			return this.topDiv;
		},

		constructTopDiv : function() {
			var topDiv = domConstruct.create("div", null, null);

			// Caption Bar
			this.captionBarDiv = this.constructCaptionBar();
			domClass.add(this.captionBarDiv, "cdesGeneralPageCaptionBar");
			domConstruct.place(this.captionBarDiv, topDiv);

			// Content
			this.contentDiv = this.constructContentDiv();
			domConstruct.place(this.contentDiv, topDiv);

			// List Widget
			this.listWidget = new JobResultListWidget({
			    applicationContext : this.applicationContext
			});
			this.listWidgetDiv = this.listWidget.getContainer();
			domConstruct.place(this.listWidgetDiv, topDiv);

			return topDiv;
		},

		constructCaptionBar : function() {
			var captionBarDiv = domConstruct.create("div", null, null);

			// Caption
			this.captionDiv = DOMHelper.createTextNode("h1", i18n.jobResultPageCaption, captionBarDiv, "cdesGeneralPageCaption");

			return captionBarDiv;
		},

		constructContentDiv : function() {
			var contentDiv = domConstruct.create("div", null, null);
			domClass.add(contentDiv, "refNodeOfPositionAbsolute", "jobResultPageContentDiv");

			return contentDiv;
		},

		resize : function(newSize) {
			if (newSize) {
				this.lastNewSize = newSize;
			}

			var totalHeight = this.lastNewSize.h;    		

			var tableHeight = totalHeight
			//- this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")
			- this.captionBarDiv.offsetHeight
			//	- this.searchWidgetDiv.offsetHeight - domStyle.get(this.searchWidgetDiv, "margin-top") - domStyle.get(this.searchWidgetDiv, "margin-bottom") 
			//	- this.columnWidgetDiv.offsetHeight - domStyle.get(this.columnWidgetDiv, "margin-top") - domStyle.get(this.columnWidgetDiv, "margin-bottom")
			// 	- this.statusBarDiv.offsetHeight
			- 16;
			this.listWidget.resize({ h : tableHeight });
		},

		setData : function() {
		},

	         reload : function() {
			if (log.isDebugEnabled()) {
				log.debug("Started PlanningNotificationProjectPage.reload, about to call contextBar.reload()");	    
			}		

			//this.contextBar.reload();
			this.listWidget.setData({ messageDtos : [] });

                     var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();                     
		     this.registerAsyncOperationStarted(JobResultPage.AsyncOperation.LOAD);
		     var networkService = this.applicationContext.getService("networkService");
		     this.getJobsHandle = networkService.getPersistentJobJoin(organisationPersonId, this.jobId).then(
			 lang.hitch(this, function(jobJoin) {
			     this.registerAsyncOperationFinished(JobResultPage.AsyncOperation.LOAD);

			     this.jobJoin = jobJoin;

                             var type = this.jobJoin.jobType;
                             var result = this.jobJoin.jobResult;
                             var messageDtos = [];
                             if (result != null) {
                                 var resultObj = json.parse(result);

                                 if (type == CdesVoc.JobType.EXPORT_DOCUMENT_ARCHIVE) {
                                     messageDtos = resultObj.archiveMessages;
                                 } else {
                                     messageDtos = resultObj;
                                 }                                     
                             }                                 

                             this.listWidget.setData({
                                                   messageDtos : messageDtos,
                                           showDocumentVersion : (type == CdesVoc.JobType.EXPORT_DOCUMENTS_TO_MSP),
                                 showPlanningNotificationOrder : (type == CdesVoc.JobType.EXPORT_STATUTORY_DUTY_TO_MSP)                                 
                             });                                 

			     topic.publish("message/ok", i18n.jobResultPageSearchSuccessful);
			 }),
			 lang.hitch(this, function(err) {
			     ErrorHelper.processAsyncError({
					    err : err,
					 widget : this,
				 asyncOperation : JobResultPage.AsyncOperation.LOAD,
					 opName : "getPersistentJobJoin",
					message : i18n.jobResultPageLoadFailed
			     });
			 })).otherwise(
			     lang.hitch(this, function(err) {
				 log.error("Error while calling function [getPersistentJobJoin]", err);
			     }));
		},

		updateWidgetState : function() {

		},

		destroy : function() {
			this.inherited(arguments);
//			this.listWidget.destroy();
		}
	});

	JobResultPage.AsyncOperation = {
	    LOAD : "Load"
	};

	return JobResultPage;
});
