/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

//// css-prefix = taskSearch
//// i18n-prefix = taskSearch

define([ "cdes/core/CdesVoc",
    "cdes/util/CodeHelper",
    "cdes/widget/CalendarSpinner",
    "clazzes/TinyLog",
    "clazzes/dateTime/DateHelper",
    "clazzes/dateTime/FancyDate",
    "clazzes/form/FancyButton",
    "clazzes/form/NumberSpinner",
    "clazzes/util/DOMHelper",
    "clazzes/util/ErrorHelper",
    "clazzes/util/MathHelper",
    "clazzes/util/WidgetHelper",
    "clazzes/widgets/layout/ContentWidget",
    "dijit/form/Button",
    "dijit/form/CheckBox",
    "dijit/form/RadioButton",
    "dijit/form/Select",
    "dijit/form/TextBox",
    "dojo/dom-attr",
    "dojo/dom-class",
    "dojo/dom-construct",       
    "dojo/keys",
    "dojo/on",
    "dojo/string",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(
    CdesVoc,
    CodeHelper,
    CalendarSpinner,
    TinyLog,
    DateHelper,
    FancyDate,
    FancyButton,
    NumberSpinner,
    DOMHelper,
    ErrorHelper,
    MathHelper,
    WidgetHelper,
    ContentWidget,
    Button,
    CheckBox,
    RadioButton,
    Select,
    TextBox,
    domAttr,
    domClass,
    domConstruct,
    Keys,
    on,
    string,    
    declare,
    lang,
    i18n) {

    var className = "at.cdes.web.task.TaskSearchWidget";

    var log = new TinyLog(className);

    var TaskSearchWidget = declare(className, ContentWidget, {
        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();
            this.initSearchFields();

            this.allFieldsValid = true;

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

            this.registerAsyncOperationStarted(TaskSearchWidget.AsyncOperation.LOAD_SEARCH_INFO);
            var planningNotificationService = this.applicationContext.getService("planningNotificationService");
            planningNotificationService.getPlanningNotificationTaskInfo(organisationPersonId).then(
                lang.hitch(this, function(contextJoins) {
                    if (contextJoins.length >= 2) {
                        var options = [{ label : i18n.whatever, value : CdesVoc.WHATEVER }];
                        for (var n = 0; n < contextJoins.length; n++) {
                            var contextJoin = contextJoins[n];
                            var networkName = contextJoin.networkName != null ? contextJoin.networkName : "";
                            var projectName = contextJoin.projectName != null ? contextJoin.projectName : "";
                            if (networkName.length > 20) {
                                networkName = networkName.substr(0, 20) + "...";
                            }
                            if (projectName.length > 34) {
                                projectName = projectName.substr(0, 34) + "...";
                            }                                

                            options.push({ value : contextJoin.projectId, label : networkName + " \u2015 " + projectName });                     
                        }
                        this.projectSelect.set("options", options);
                        WidgetHelper.setSelectValue(this.projectSelect, CdesVoc.WHATEVER);
                        this.showProject = true;
                    } else {
                        this.showProject = false;
                    }                        

                    this.registerAsyncOperationFinished(TaskSearchWidget.AsyncOperation.LOAD_SEARCH_INFO);
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : TaskSearchWidget.AsyncOperation.LOAD_SEARCH_INFO,
                                opName : "getPlanningNotificationTaskInfo",
                               message : i18n.taskSearchGetTaskInfoFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getPlanningNotificationTaskInfo]", err);
                    }));

            this.reloadCounts();
        },

        getWidgetId : function() {
            return "TaskSearchWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);
            domClass.add(topDiv, "refNodeOfPositionAbsolute taskSearchTopDiv");

            this.explicitDateMode = null;

            // ModeSelect
            var modeOptions = [
                { value : CdesVoc.TaskSearchMode.OWN, label : i18n.taskSearchModeOwnTasks },
                { value : CdesVoc.TaskSearchMode.OPEN, label : i18n.taskSearchModeOpenTasks }/*,
                { value : CdesVoc.TaskSearchMode.LATE, label : i18n.taskSearchModeBelatedTasks }*/
            ];                
            
            modeOptions.push({ value : CdesVoc.TaskSearchMode.BATCH, label : i18n.taskSearchModeBatchSignatures });

            this.modeSelect = new Select({
                  label : i18n.taskSearchModeSelectLabel,
                  title : i18n.taskSearchModeSearchTitle,
                options : modeOptions            
            });
            domClass.add(this.modeSelect.domNode, "fixedDialogWidget taskSearchModeSelect");
            domConstruct.place(this.modeSelect.domNode, topDiv);
            WidgetHelper.handleSelectEvents(this.modeSelect, lang.hitch(this, function() {
                this.updateWidgetState();
                
                var newMode = WidgetHelper.getSelectValue(this.modeSelect);
                if (this.mode != newMode) {
                    this.doSearch();
                    this.mode = newMode;
                }
            }));                
            if (this.initialMode != null) {
                WidgetHelper.setSelectValue(this.modeSelect, this.initialMode);
            }                

            // Date
            DOMHelper.createTextNode("div", i18n.taskSearchDateLabel, topDiv, "propertyLabel taskSearchDateLabel");            

            // Explicit Date Radio Button
            this.explicitDateCheckBox = new CheckBox({
                  label : i18n.taskSearchExplicitDateLabel,
                  title : i18n.taskSearchExplicitDateToolTip,
                checked : this.explicitDateMode != null && this.explicitDateMode
            });
            domClass.add(this.explicitDateCheckBox.domNode, "fixedDialogWidget taskSearchExplicitDateRadioButton");
            domConstruct.place(this.explicitDateCheckBox.domNode, topDiv);
            WidgetHelper.handleCheckBoxEvents(this.explicitDateCheckBox, lang.hitch(this, this.onDateModeChange));

            // From
            this.fromSpinner = new CalendarSpinner({
                            label : i18n.taskSearchFromLabel,
                          pattern : i18n.datePattern,
                         timeZone : this.applicationContext.getTimeZone(),
                       dndEnabled : false,
                rowObjectToString : null
            });
            domClass.add(this.fromSpinner.domNode, "fixedDialogWidget taskSearchFromSpinner");
            domConstruct.place(this.fromSpinner.domNode, topDiv);
            on(this.fromSpinner, "keyup", lang.hitch(this, this.searchIfEnter));
            WidgetHelper.handleSpinnerEvents(this.fromSpinner, lang.hitch(this, this.updateWidgetState));
            WidgetHelper.handleSpinnerEvents(this.fromSpinner, lang.hitch(this, this.updateFromDateDifference));

            // RelativeFrom            
            this.relativeFromDiv = DOMHelper.createTextNode("div", "", topDiv, "propertyLabel taskSearchRelativeFromLabel");
            
            DOMHelper.createTextNode("div", i18n.taskSearchToLabel, topDiv, "propertyLabel taskSearchToLabel");

            // To
            this.toSpinner = new CalendarSpinner({
                            label : i18n.taskSearchToLabel,
                          pattern : i18n.datePattern,
                         timeZone : this.applicationContext.getTimeZone(),
                       dndEnabled : false,
                rowObjectToString : null
            });
            domClass.add(this.toSpinner.domNode, "fixedDialogWidget taskSearchToSpinner");
            domConstruct.place(this.toSpinner.domNode, topDiv);
            on(this.toSpinner, "keyup", lang.hitch(this, this.searchIfEnter));
            WidgetHelper.handleSpinnerEvents(this.toSpinner, lang.hitch(this, this.updateWidgetState));
            WidgetHelper.handleSpinnerEvents(this.toSpinner, lang.hitch(this, this.updateToDateDifference));

            // RelativeTo
            this.relativeToDiv = DOMHelper.createTextNode("div", "", topDiv, "propertyLabel taskSearchRelativeToLabel");


            // Remark Date CheckBox
            this.remarkDateCheckBox = new CheckBox({
                  label : i18n.taskSearchRemarkDateLabel,
                  title : i18n.taskSearchRemarkDateToolTip,
                checked : this.explicitDateMode != null && !this.explicitDateMode
            });
            domClass.add(this.remarkDateCheckBox.domNode, "fixedDialogWidget taskSearchRemarkDateRadioButton");
            domConstruct.place(this.remarkDateCheckBox.domNode, topDiv);
            WidgetHelper.handleCheckBoxEvents(this.remarkDateCheckBox, lang.hitch(this, this.onDateModeChange));

            // RemarkSelect
            this.remarkDateSelect = new Select({
                  label : i18n.dueDateEditRemarkDueDateLabel,
                options : CodeHelper.getDueDateRemarkOptions({ label : i18n.whatever, value : CdesVoc.WHATEVER })
                //       disabled : true     
            });
            domClass.add(this.remarkDateSelect.domNode, "fixedDialogWidget taskSearchRemarkDateSelect");
            domConstruct.place(this.remarkDateSelect.domNode, topDiv);
            WidgetHelper.handleSelectEvents(this.remarkDateSelect, lang.hitch(this, this.updateWidgetState));

            // Lfd. Nummer
            DOMHelper.createTextNode("div", i18n.planningNotificationOrderSerialNumberLabel, topDiv, "propertyLabel taskSearchSerialNumberLabel");

            this.serialNumberSpinner = new NumberSpinner({
                                label : i18n.planningNotificationOrderSerialNumberLabel,
                omitThousandSeparator : true
            });
            domClass.add(this.serialNumberSpinner.domNode, "fixedDialogWidget taskSearchSerialNumberSpinner");
            domConstruct.place(this.serialNumberSpinner.domNode, topDiv);
            on(this.serialNumberSpinner, "keyup", lang.hitch(this, this.searchIfEnter));

            // FilterTextBox
            DOMHelper.createTextNode("div", i18n.taskSearchQuickSearchLabel, topDiv, "propertyLabel taskSearchFilterLabel");
            this.quickSearchTextBox = new TextBox({
		                label : i18n.taskSearchQuickSearchLabel,
		                title : i18n.quickSearchToolTip,
        		selectOnClick : true 
            });
            domClass.add(this.quickSearchTextBox.domNode, "fixedDialogWidget taskSearchFilterTextBox");
            domConstruct.place(this.quickSearchTextBox.domNode, topDiv);
            domAttr.set(this.quickSearchTextBox.domNode, "autocomplete", "country");
            domAttr.set(this.quickSearchTextBox.focusNode, "autocomplete", "country");
            domAttr.set(this.quickSearchTextBox.focusNode, "autocomplete", "country");
            domAttr.set(this.quickSearchTextBox.focusNode, "tabindex", 9999);
            domAttr.set(this.quickSearchTextBox.focusNode, "name", "foobarfilter");            
            WidgetHelper.handleTextBoxEvents(this.quickSearchTextBox, lang.hitch(this, function() {
                on.emit(this, "quickSearchChange", this.quickSearchTextBox.get("value"));
            }));

            this.quickSearchClearButton = new FancyButton({
                    title : i18n.quickSearchClearToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 deleteButton"
            });
            domClass.add(this.quickSearchClearButton.domNode, "fixedDialogWidget taskSearchFilterClearButton");
            domConstruct.place(this.quickSearchClearButton.domNode, topDiv);            
            on(this.quickSearchClearButton, "click", lang.hitch(this, this.clearQuickSearch));            

            // Project
            this.projectLabel = DOMHelper.createTextNode("div", i18n.project, topDiv, "propertyLabel taskSearchProjectLabel");
            this.projectSelect = new Select({
                label : i18n.project
            });
            domClass.add(this.projectSelect.domNode, "fixedDialogWidget taskSearchProjectSelect");
            domConstruct.place(this.projectSelect.domNode, topDiv);            

            // SearchButton
            this.searchButton = new Button({
                label : i18n.searchButtonCaption,
                title : i18n.searchButtonCaption
            });            
            domClass.add(this.searchButton.domNode, "fixedDialogWidget taskSearchSearchButton");
            domConstruct.place(this.searchButton.domNode, topDiv);
            on(this.searchButton, "click", lang.hitch(this, this.doSearch));            

            return topDiv;
        },
        
        getMode : function() {
            return WidgetHelper.getSelectValue(this.modeSelect);
        },

        reloadCounts : function() {
            if (this.asyncOperations[TaskSearchWidget.AsyncOperation.GET_COUNTS]) {
                return;
            }                

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

            this.registerAsyncOperationStarted(TaskSearchWidget.AsyncOperation.GET_COUNTS);
            var planningNotificationService = this.applicationContext.getService("planningNotificationService");
            planningNotificationService.getPlanningNotificationTaskCounts(organisationPersonId).then(
                lang.hitch(this, function(taskCounts) {

                    var oldValue = WidgetHelper.getSelectValue(this.modeSelect);

                    // ModeSelect
                    var modeOptions = [
                        { value : CdesVoc.TaskSearchMode.OWN, label : i18n.taskSearchModeOwnTasks + " " + taskCounts.numberOfOwnTasks},
                        { value : CdesVoc.TaskSearchMode.OPEN, label : i18n.taskSearchModeOpenTasks + " " + taskCounts.numberOfOpenTasks}/*,
                        { value : CdesVoc.TaskSearchMode.LATE, label : i18n.taskSearchModeBelatedTasks + " " + taskCounts.numberOfLateTasks}*/
                    ];                
            
                    // TODO permission
                    if (true) {
                        modeOptions.push({ value : CdesVoc.TaskSearchMode.BATCH, label : i18n.taskSearchModeBatchSignatures + " " + taskCounts.numberOfBatchTasks});
                    }

                    this.modeSelect.set("options", modeOptions);
                    if (oldValue != null) {
                        WidgetHelper.setSelectValue(this.modeSelect, oldValue);
                    } else {
                        WidgetHelper.setSelectValue(this.modeSelect, modeOptions[0].value);
                    }                        

                    this.registerAsyncOperationFinished(TaskSearchWidget.AsyncOperation.GET_COUNTS);
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : TaskSearchWidget.AsyncOperation.GET_COUNTS,
                                opName : "getPlanningNotificationTaskCounts",
                               message : i18n.taskSearchGetCountsFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getPlanningNotificationTaskCounts]", err);
                    }));            
        },

        initSearchFields : function() {
            var currentUtcSeconds = DateHelper.getCurrentTimeSeconds();
            var timeZone = this.applicationContext.getTimeZone();
            var fromUtcSeconds = DateHelper.addDeltaToUtcSeconds(currentUtcSeconds, timeZone, { sign : -1, months : 1 });
            var toUtcSeconds = DateHelper.addDeltaToUtcSeconds(currentUtcSeconds, timeZone, { sign : 1, days : 3 }); 
            this.fromSpinner.setUtcSeconds(fromUtcSeconds);
            this.toSpinner.setUtcSeconds(toUtcSeconds);
            this.updateFromDateDifference();
            this.updateToDateDifference();            
        },

        clearQuickSearch : function() {
            this.quickSearchTextBox.set("value", "", false);
            on.emit(this, "quickSearchChange", this.quickSearchTextBox.get("value"));    
        },

        updateWidgetState : function() {
            var mode = WidgetHelper.getSelectValue(this.modeSelect);
            var soFarDisabled = this.toSpinner.get("disabled");
            var toDisabled = this.explicitDateMode == null || !this.explicitDateMode;
            if (mode == CdesVoc.TaskSearchMode.LATE) {
                if (this.oldToSeconds == null) {
                    this.oldToSeconds = this.toSpinner.getUtcSeconds();
                }                    

                var currentTimeSeconds = DateHelper.getCurrentTimeSeconds();
                var timeZone = this.applicationContext.getTimeZone();
                var currentTimeDate = new FancyDate({
                    utcSeconds : currentTimeSeconds,
                      timeZone : timeZone
                });
                currentTimeDate.addToComponent("days", -1);
                this.toSpinner.setUtcSeconds(currentTimeDate.getUtcSeconds());                
                this.updateToDateDifference();

                toDisabled = true;
            } else {
                if (soFarDisabled && this.oldToSeconds != null) {
                    this.toSpinner.setUtcSeconds(this.oldToSeconds);
                    this.updateToDateDifference();
                }
                this.oldToSeconds = null;                
            }                

            this.showProject = (mode == CdesVoc.TaskSearchMode.OPEN || mode == CdesVoc.TaskSearchMode.LATE);
            if (this.showProject) {
                domClass.remove(this.projectLabel, "invisible");
                domClass.remove(this.projectSelect.domNode, "invisible");
                domClass.remove(this.topDiv, "projectInvisible");
            } else {
                domClass.add(this.projectLabel, "invisible");
                domClass.add(this.projectSelect.domNode, "invisible");
                domClass.add(this.topDiv, "projectInvisible");
            }

            this.fromSpinner.set("disabled", this.explicitDateMode == null || !this.explicitDateMode);
            this.toSpinner.set("disabled", toDisabled);
            this.remarkDateSelect.set("disabled", this.explicitDateMode == null || this.explicitDateMode);
        },

        onDateModeChange : function(e) {
            var explicitClicked = (e.target != null && e.target.id == this.explicitDateCheckBox.id);
            var explicitChecked = this.explicitDateCheckBox.get("checked");
            var remarkChecked = this.remarkDateCheckBox.get("checked");

            log.info("explicit: [" + explicitChecked + "], remark = [" + remarkChecked + "], explicitClicked = [" + explicitClicked + "]");

            if (explicitClicked) {
                this.explicitDateMode = explicitChecked;
            } else {
                this.explicitDateMode = !remarkChecked;
            }

            if (!explicitChecked && !remarkChecked) {
                this.explicitDateMode = null;
            }

            if (explicitClicked) {
                this.remarkDateCheckBox.set("checked", false);
            } else {
                this.explicitDateCheckBox.set("checked", false);
            }

            this.updateWidgetState();  
        },

        updateFromDateDifference : function() {
            var currentTimeSeconds = DateHelper.getCurrentTimeSeconds();
            var timeZone = this.applicationContext.getTimeZone();
            var currentTimeDate = new FancyDate({
                utcSeconds : currentTimeSeconds,
                  timeZone : timeZone
            });

            var fromSeconds = this.fromSpinner.getUtcSeconds();
            var fromDate = new FancyDate({
                utcSeconds : fromSeconds,
                  timeZone : timeZone                
            });
            if (fromSeconds < currentTimeSeconds) {
                currentTimeDate.setHour(23);
                currentTimeDate.setMinute(59);
                currentTimeDate.setSecond(59);
                currentTimeDate.setMilliSecond(9999);                
            } else {
                currentTimeDate.setHour(0);
                currentTimeDate.setMinute(0);
                currentTimeDate.setSecond(0);
                currentTimeDate.setMilliSecond(0);
            }                

            var fromDifference = DateHelper.getDifference(currentTimeDate, fromDate);
            var differenceString = this.getDifferenceString(fromDifference);
            DOMHelper.setInnerText(this.relativeFromDiv, differenceString);
        },            

        updateToDateDifference : function() {
            var currentTimeSeconds = DateHelper.getCurrentTimeSeconds();
            var timeZone = this.applicationContext.getTimeZone();
            var currentTimeDate = new FancyDate({
                utcSeconds : currentTimeSeconds,
                  timeZone : timeZone
            });            

            var toSeconds = this.toSpinner.getUtcSeconds();
            var toDate = new FancyDate({
                utcSeconds : toSeconds,
                  timeZone : timeZone                
            });
            if (toSeconds < currentTimeSeconds) {
                currentTimeDate.setHour(23);
                currentTimeDate.setMinute(59);
                currentTimeDate.setSecond(59);
                currentTimeDate.setMilliSecond(9999);                
            } else {
                currentTimeDate.setHour(0);
                currentTimeDate.setMinute(0);
                currentTimeDate.setSecond(0);
                currentTimeDate.setMilliSecond(0);
            }     

            var toDifference = DateHelper.getDifference(currentTimeDate, toDate);
            var differenceString = this.getDifferenceString(toDifference);
            DOMHelper.setInnerText(this.relativeToDiv, differenceString);
        },

        getDifferenceString : function(difference) {
            var years = difference.years;
            var months = difference.months;
            var days = difference.days;
            var sign = difference.sign;

            var majorString = null;
            if (sign < 0) {
                majorString = i18n.timeDifferencePast;                
            } else if (sign > 0) {
                majorString = i18n.timeDifferenceFuture;
            } else {
                majorString = i18n.timeDifferenceToday;
            }                

            var deltaString = null;
            if (years != null && years != 0) {
                if (years == 1) {
                    deltaString = i18n.timeDifferenceOneYear;
                } else if (years > 1) {
                    deltaString = string.substitute(i18n.timeDifferenceYears, {
                        years : years
                    });                        
                }                    
            } else if (months != null && months != 0) {
                if (months == 1) {
                    deltaString = i18n.timeDifferenceOneMonth;
                } else if (months > 1) {
                    deltaString = string.substitute(i18n.timeDifferenceMonths, {
                        months : months
                    });                        
                }
            } else if (days != null && days != 0) {
                if (days == 1) {
                    if (sign < 0) {
                        majorString = i18n.timeDifferenceYesterday;                        
                    } else if (sign > 0) {
                        majorString = i18n.timeDifferenceTomorrow;
                    }                        
                } else if (days == 2) {
                    if (sign < 0) {
                        majorString = i18n.timeDifferenceDayBeforeYesterday;                        
                    } else if (sign > 0) {
                        majorString = i18n.timeDifferenceDayAfterTomorrow;
                    }                        
                } else if (days > 2 && days < 7) {
                    deltaString = string.substitute(i18n.timeDifferenceDays, {
                        days : days
                    });                        
                } else if (days < 14) {
                    deltaString = i18n.timeDifferenceOneWeek;
                } else {
                    deltaString = string.substitute(i18n.timeDifferenceWeeks, {
                        weeks : MathHelper.div(days, 7)
                    });                        
                }                    
            } else if (days == 0) {
                majorString = i18n.timeDifferenceToday;
            }                

            if (deltaString != null) {
                return string.substitute(majorString, {
                    difference : deltaString
                });                    
            } else {
                return majorString;
            }
        },

     	searchIfEnter : function(e) {
 	    if (e.keyCode == Keys.ENTER) {
 		this.doSearch();
 	    }
     	},

        doSearch : function() {
            on.emit(this, "doSearch");            
        },

        getSearchModel : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

            var mode = WidgetHelper.getSelectValue(this.modeSelect);
            var from = this.explicitDateMode != null && this.explicitDateMode ? this.fromSpinner.getUtcSeconds() : null;
            var to = this.explicitDateMode != null && this.explicitDateMode ? this.toSpinner.getUtcSeconds() : null;
            var remarkOption = this.explicitDateMode != null && !this.explicitDateMode ? WidgetHelper.getSelectValue(this.remarkDateSelect) : null;
            var serialNumber = this.serialNumberSpinner.get("value");            
            var projectId = this.showProject ? WidgetHelper.getSelectValue(this.projectSelect) : null;
            var filter = this.quickSearchTextBox.get("value");

            if (remarkOption != null) {
                if (remarkOption == "beforeConstruction") {
                    remarkOption = "BEFORE_CONSTRUCTION";
                } else if (remarkOption == "whileConstruction") {
                    remarkOption = "WHILE_CONSTRUCTION";
                } else if (remarkOption == "duringConstruction") {
                    remarkOption = "DURING_CONSTRUCTION";
                } else if (remarkOption == "beforeStarting") {
                    remarkOption = "BEFORE_STARTING";
                } else if (remarkOption == "afterConstruction") {
                    remarkOption = "AFTER_CONSTRUCTION";
                } else if (remarkOption == "inOperation") {
                    remarkOption = "IN_OPERATION";
                } else if (remarkOption == "tillOperationApproval") {
                    remarkOption = "TILL_OPERATION_APPROVAL";
                }                    
            }

            return {
                organisationPersonId : organisationPersonId,
                     workflowTokenId : null,
                                mode : mode,
                                from : from,
                                  to : to,
                        remarkOption : remarkOption != CdesVoc.WHATEVER ? remarkOption : null,
                        serialNumber : serialNumber,
                           projectId : projectId != CdesVoc.WHATEVER ? projectId : null,
                              filter : filter                
            };                
        }
    });

    TaskSearchWidget.AsyncOperation = {
        LOAD_SEARCH_INFO : "LoadSearchInfo",
        GET_COUNTS : "GetCounts"        
    };        

    return TaskSearchWidget;
});
