define([ 
         "clazzes/TinyLog",
         "clazzes/util/DOMHelper",
         "clazzes/util/WidgetHelper",
         "clazzes/widgets/IconTitlePane",
         "clazzes/widgets/layout/ContentWidget",
         "dijit/form/CheckBox",
         "dojo/dom-class",
         "dojo/dom-construct",
         "dojo/Evented",
         "dojo/on",
         "dojo/_base/declare",
         "dojo/_base/lang",
         "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
       ],
    function(
    		 TinyLog,
    		 DOMHelper,
    		 WidgetHelper,
    		 IconTitlePane,
    		 ContentWidget,
    		 CheckBox,
    		 domClass,
    		 domConstruct,
    		 Evented,
    		 on,
    		 declare,
    		 lang,
    		 i18n
    		 ) {
	
	var className = "at.cdes.web.plan.PlanDeliverColumnWidget";

	var log = new TinyLog(className);
	
    var PlanDeliverColumnWidget = declare(className, ContentWidget, {
    	
    	constructor : function(params) {
    		lang.mixin(this,params);
    		
    		this.topDiv = this.constructTopDiv();
    		this.updateTitlePane();
    		
    		this.allFieldsValid = true;
    	},
    	
    	getWidgetId : function() {
    		return "PlanDeliverColumnWidget";
    	},
    	
    	getDataId : function() {
    		return null;
    	},
    	
    	getContainer : function() {
    		return this.topDiv;
    	},
    	
    	constructTopDiv : function() {
    		var topDiv = domConstruct.create("div", null, null);
    		domClass.add(topDiv, "refNodeOfPositionAbsolute planDeliverColumnTopDivReduced");
    		
    		this.titlePane = this.constructTitlePane();
    		domConstruct.place(this.titlePane.domNode, topDiv);
    		
    		return topDiv;
    	},
    	
    	updateTitlePane : function() {
    		var open = this.titlePane.get("open");
    		if (open) {
    			this.titlePane.set("title", i18n.columnOpenCaption);
    			domClass.replace(this.topDiv, "planDeliverColumnTopDivFull", "planDeliverColumnTopDivReduced");
    		} else {
    			this.titlePane.set("title", i18n.columnClosedCaption);
    			domClass.replace(this.topDiv, "planDeliverColumnTopDivReduced", "planDeliverColumnTopDivFull");
    		}    		
    	},
    	
    	postTitleClick : function() {
    		this.updateTitlePane();
    		on.emit(this, "titlePaneToggled");
    	},
    	
     	constructTitlePane : function() {
     		var columnDiv = this.constructColumnDiv();
     		
			var titlePane = new IconTitlePane({
				         title   : i18n.planDeliverColumnOpenCaption,
    				     content : columnDiv,
				      toggleable : true,
				            open : false,
				  postTitleClick : lang.hitch(this, this.postTitleClick)
			});
			domClass.add(titlePane.domNode, "occupyWholeParent");
			
			return titlePane;
     	},
     	
     	constructColumnDiv : function() {
     		var columnDiv = domConstruct.create("div", null, null);
     		domClass.add(columnDiv, "refNodeOfPositionAbsolute planDeliverColumnDiv");
     		
     		// Planner (Person)
     		this.plannerPersonCheckBox = new CheckBox({
     			label : i18n.planDeliverPlannerPersonColumnLabel,
     			title : i18n.planDeliverPlannerPersonColumnToolTip
     		});
     		domClass.add(this.plannerPersonCheckBox.domNode, "fixedDialogWidget planDeliverPlannerPersonColumnCheckBox");
     		domConstruct.place(this.plannerPersonCheckBox.domNode, columnDiv);
     		DOMHelper.createTextNode("div", i18n.planDeliverPlannerPersonColumnLabel, columnDiv, "fixedDialogWidget planDeliverPlannerPersonColumnLabel");
     		WidgetHelper.handleCheckBoxEvents(this.plannerPersonCheckBox, lang.hitch(this, this.emitColumnsChanged));
     		
     		// Planner (Organisation)
     		this.plannerOrganisationCheckBox = new CheckBox({
     			label : i18n.planDeliverPlannerOrganisationColumnLabel,
     			title : i18n.planDeliverPlannerOrganisationColumnToolTip
     		});
     		domClass.add(this.plannerOrganisationCheckBox.domNode, "fixedDialogWidget planDeliverPlannerOrganisationColumnCheckBox");
     		domConstruct.place(this.plannerOrganisationCheckBox.domNode, columnDiv);
     		DOMHelper.createTextNode("div", i18n.planDeliverPlannerOrganisationColumnLabel, columnDiv, "fixedDialogWidget planDeliverPlannerOrganisationColumnLabel");     		
     		WidgetHelper.handleCheckBoxEvents(this.plannerOrganisationCheckBox, lang.hitch(this, this.emitColumnsChanged));
     		
     		// Document number
     		this.documentNumberCheckBox = new CheckBox({
     			label : i18n.planDeliverDocumentNumberColumnLabel,
     			title : i18n.planDeliverDocumentNumberColumnToolTip
     		});
     		domClass.add(this.documentNumberCheckBox.domNode, "fixedDialogWidget planDeliverDocumentNumberColumnCheckBox");
     		domConstruct.place(this.documentNumberCheckBox.domNode, columnDiv);
     		DOMHelper.createTextNode("div", i18n.planDeliverDocumentNumberColumnLabel, columnDiv, "fixedDialogWidget planDeliverDocumentNumberColumnLabel");     		
     		WidgetHelper.handleCheckBoxEvents(this.documentNumberCheckBox, lang.hitch(this, this.emitColumnsChanged));
     		
     		// Document name
     		this.documentNameCheckBox = new CheckBox({
     			label : i18n.planDeliverDocumentNameColumnLabel,
     			title : i18n.planDeliverDocumentNameColumnToolTip
     		});
     		domClass.add(this.documentNameCheckBox.domNode, "fixedDialogWidget planDeliverDocumentNameColumnCheckBox");
     		domConstruct.place(this.documentNameCheckBox.domNode, columnDiv);
     		DOMHelper.createTextNode("div", i18n.planDeliverDocumentNameColumnLabel, columnDiv, "fixedDialogWidget planDeliverDocumentNameColumnLabel");     		
     		WidgetHelper.handleCheckBoxEvents(this.documentNameCheckBox, lang.hitch(this, this.emitColumnsChanged));
     		
     		// Object number
     		this.objectCodeCheckBox = new CheckBox({
     			label : i18n.planDeliverObjectCodeColumnLabel,
     			title : i18n.planDeliverObjectCodeColumnToolTip
     		});
     		domClass.add(this.objectCodeCheckBox.domNode, "fixedDialogWidget planDeliverObjectCodeColumnCheckBox");
     		domConstruct.place(this.objectCodeCheckBox.domNode, columnDiv);
     		DOMHelper.createTextNode("div", i18n.planDeliverObjectCodeColumnLabel, columnDiv, "fixedDialogWidget planDeliverObjectCodeColumnLabel");
     		WidgetHelper.handleCheckBoxEvents(this.objectCodeCheckBox, lang.hitch(this, this.emitColumnsChanged));
     		
     		// Object name
     		this.objectNameCheckBox = new CheckBox({
     			label : i18n.planDeliverObjectNameColumnLabel,
     			title : i18n.planDeliverObjectNameColumnToolTip
     		});
     		domClass.add(this.objectNameCheckBox.domNode, "fixedDialogWidget planDeliverObjectNameColumnCheckBox");
     		domConstruct.place(this.objectNameCheckBox.domNode, columnDiv);
     		DOMHelper.createTextNode("div", i18n.planDeliverObjectNameColumnLabel, columnDiv, "fixedDialogWidget planDeliverObjectNameColumnLabel");
     		WidgetHelper.handleCheckBoxEvents(this.objectNameCheckBox, lang.hitch(this, this.emitColumnsChanged));
     		
     		// Object planner code
     		this.objectPlannerCodeCheckBox = new CheckBox({
     			label : i18n.planDeliverObjectPlannerCodeColumnLabel,
     			title : i18n.planDeliverObjectPlannerCodeColumnToolTip
     		});
     		domClass.add(this.objectPlannerCodeCheckBox.domNode, "fixedDialogWidget planDeliverObjectPlannerCodeColumnCheckBox");
     		domConstruct.place(this.objectPlannerCodeCheckBox.domNode, columnDiv);
     		DOMHelper.createTextNode("div", i18n.planDeliverObjectPlannerCodeColumnLabel, columnDiv, "fixedDialogWidget planDeliverObjectPlannerCodeColumnLabel");
     		WidgetHelper.handleCheckBoxEvents(this.objectPlannerCodeCheckBox, lang.hitch(this, this.emitColumnsChanged));
     		
     		// Object planner name
     		this.objectPlannerNameCheckBox = new CheckBox({
     			label : i18n.planDeliverObjectPlannerNameColumnLabel,
     			title : i18n.planDeliverObjectPlannerNameColumnToolTip
     		});
     		domClass.add(this.objectPlannerNameCheckBox.domNode, "fixedDialogWidget planDeliverObjectPlannerNameColumnCheckBox");
     		domConstruct.place(this.objectPlannerNameCheckBox.domNode, columnDiv);
     		DOMHelper.createTextNode("div", i18n.planDeliverObjectPlannerNameColumnLabel, columnDiv, "fixedDialogWidget planDeliverObjectPlannerNameColumnLabel");
     		WidgetHelper.handleCheckBoxEvents(this.objectPlannerNameCheckBox, lang.hitch(this, this.emitColumnsChanged));
     		
     		// Start
     		this.startCheckBox = new CheckBox({
     			label : i18n.planDeliverFromColumnLabel,
     			title : i18n.planDeliverFromColumnToolTip
     		});
     		domClass.add(this.startCheckBox.domNode, "fixedDialogWidget planDeliverFromColumnCheckBox");
     		domConstruct.place(this.startCheckBox.domNode, columnDiv);
     		DOMHelper.createTextNode("div", i18n.planDeliverFromColumnLabel, columnDiv, "fixedDialogWidget planDeliverFromColumnLabel");
     		WidgetHelper.handleCheckBoxEvents(this.startCheckBox, lang.hitch(this, this.emitColumnsChanged));
     		
     		// End
     		this.endCheckBox = new CheckBox({
     			label : i18n.planDeliverToColumnLabel,
     			title : i18n.planDeliverToColumnToolTip
     		});
     		domClass.add(this.endCheckBox.domNode, "fixedDialogWidget planDeliverToColumnCheckBox");
     		domConstruct.place(this.endCheckBox.domNode, columnDiv);
     		DOMHelper.createTextNode("div", i18n.planDeliverToColumnLabel, columnDiv, "fixedDialogWidget planDeliverToColumnLabel");
     		WidgetHelper.handleCheckBoxEvents(this.endCheckBox, lang.hitch(this, this.emitColumnsChanged));
     		
     		// Scale
     		this.scaleCheckBox = new CheckBox({
     			label : i18n.planDeliverScaleColumnLabel,
     			title : i18n.planDeliverScaleColumnToolTip
     		});
     		domClass.add(this.scaleCheckBox.domNode, "fixedDialogWidget planDeliverScaleColumnCheckBox");
     		domConstruct.place(this.scaleCheckBox.domNode, columnDiv);
     		DOMHelper.createTextNode("div", i18n.planDeliverScaleColumnLabel, columnDiv, "fixedDialogWidget planDeliverScaleColumnLabel");
     		WidgetHelper.handleCheckBoxEvents(this.scaleCheckBox, lang.hitch(this, this.emitColumnsChanged));
     		
     		// Period
     		this.periodCheckBox = new CheckBox({
     			label : i18n.planDeliverPeriodColumnLabel,
     			title : i18n.planDeliverPeriodColumnToolTip
     		});
     		domClass.add(this.periodCheckBox.domNode, "fixedDialogWidget planDeliverPeriodColumnCheckBox");
     		domConstruct.place(this.periodCheckBox.domNode, columnDiv);
     		DOMHelper.createTextNode("div", i18n.planDeliverPeriodColumnLabel, columnDiv, "fixedDialogWidget planDeliverPeriodColumnLabel");
     		WidgetHelper.handleCheckBoxEvents(this.periodCheckBox, lang.hitch(this, this.emitColumnsChanged));     
     		
     		// Comment
     		this.commentCheckBox = new CheckBox({
     			label : i18n.planDeliverCommentColumnLabel,
     			title : i18n.planDeliverCommentColumnToolTip
     		});
     		domClass.add(this.commentCheckBox.domNode, "fixedDialogWidget planDeliverCommentColumnCheckBox");
     		domConstruct.place(this.commentCheckBox.domNode, columnDiv);
     		DOMHelper.createTextNode("div", i18n.planDeliverCommentColumnLabel, columnDiv, "fixedDialogWidget planDeliverCommentColumnLabel");     		
     		WidgetHelper.handleCheckBoxEvents(this.commentCheckBox, lang.hitch(this, this.emitColumnsChanged));     
     		
     		return columnDiv;
     	},
     	
     	emitColumnsChanged : function() {
     		on.emit(this, "columnsChanged");
     	},
     	
    	setData : function(columnSettings) {
    		this.columnSettings = columnSettings;
    		this.reload();
    	},
    	
    	reload : function() {
    		this.plannerPersonCheckBox.set("checked", this.columnSettings.showPlannerPerson);
    		this.plannerOrganisationCheckBox.set("checked", this.columnSettings.showPlannerOrganisation);
    		this.commentCheckBox.set("checked", this.columnSettings.showComment);
    		this.objectCodeCheckBox.set("checked", this.columnSettings.showObjectNumber);
    		this.objectNameCheckBox.set("checked", this.columnSettings.showObjectName);
    		this.objectPlannerCodeCheckBox.set("checked", this.columnSettings.showObjectPlannerCode);
    		this.objectPlannerNameCheckBox.set("checked", this.columnSettings.showObjectPlannerName);
    		this.documentNumberCheckBox.set("checked", this.columnSettings.showDocumentNumber);
    		this.documentNameCheckBox.set("checked", this.columnSettings.showDocumentName);
    		this.startCheckBox.set("checked", this.columnSettings.showStart);
    		this.endCheckBox.set("checked", this.columnSettings.showEnd);
    		this.scaleCheckBox.set("checked", this.columnSettings.showScale);
    		this.periodCheckBox.set("checked", this.columnSettings.showPeriod);
    	},
    	
    	updateDataFromWidgets : function() {
     		this.columnSettings.showPlannerPerson = this.plannerPersonCheckBox.get("checked");
     		this.columnSettings.showPlannerOrganisation = this.plannerOrganisationCheckBox.get("checked");
     		this.columnSettings.showComment = this.commentCheckBox.get("checked");
     		this.columnSettings.showObjectNumber = this.objectCodeCheckBox.get("checked");
     		this.columnSettings.showObjectName = this.objectNameCheckBox.get("checked");
     		this.columnSettings.showObjectPlannerCode = this.objectPlannerCodeCheckBox.get("checked");
     		this.columnSettings.showObjectPlannerName = this.objectPlannerNameCheckBox.get("checked");
     		this.columnSettings.showDocumentNumber = this.documentNumberCheckBox.get("checked");
     		this.columnSettings.showDocumentName = this.documentNameCheckBox.get("checked");          
     		this.columnSettings.showStart = this.startCheckBox.get("checked");
     		this.columnSettings.showEnd = this.endCheckBox.get("checked");
     		this.columnSettings.showScale = this.scaleCheckBox.get("checked");
     		this.columnSettings.showPeriod = this.periodCheckBox.get("checked");    		
    	},
     	
     	getColumnSettings : function() {
     		this.updateDataFromWidgets();
     		return this.columnSettings;
     	}
    });
    
    return PlanDeliverColumnWidget;
});