define([
    "cdes/core/CdesVoc",
    "cdes/util/CodeHelper",
        "cdes/util/NameHelper",
        "cdes/util/SearchPageHelper",
        "clazzes/TinyLog",
        "clazzes/dateTime/DateHelper",
        "clazzes/util/DOMHelper",
        "clazzes/util/DataHelper",
        "clazzes/util/StringHelper",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/string",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
       ],
    function(
        CdesVoc,
    	CodeHelper,
    		NameHelper,
             SearchPageHelper,
    	     TinyLog,
    		DateHelper,
    		DOMHelper,
             DataHelper,
    		StringHelper,
    		domClass,
    		domConstruct,
    	string,
        lang,        
    		i18n
    		) {
	
	var className = "at.cdes.web.util.PlanDeliverHelper";
	
	var log = new TinyLog(className);
	
    var PlanDeliverHelper = {
    
        setPersonRoleJoinsForSearchComboBox : function(params) {
            var personRoleJoins = params.personRoleJoins;
            var plannerMemory = params.plannerMemory;            
            
     	    var organisationPersonIdToJoins = new Object();
     	    for (var n = 0; n < personRoleJoins.length; n++) {
     		var organisationPersonId = personRoleJoins[n].organisationPersonId;
     		if (!(organisationPersonId in organisationPersonIdToJoins)) {
     		    organisationPersonIdToJoins[organisationPersonId] = [];
     		}
     		organisationPersonIdToJoins[organisationPersonId].push(personRoleJoins[n]);
     	    }
     	    
     	    plannerMemory.setData(PlanDeliverHelper.getPlannerMemoryData(organisationPersonIdToJoins));
            return organisationPersonIdToJoins;            
        },

     	getPlannerMemoryData : function(organisationPersonIdToJoins, roleIdFilter) {
            
     		var data = [{name: i18n.ownUser, id: CdesVoc.UserCategory.OWN_USER},
     		            SearchPageHelper.constructComboBoxAllOption() ];
     		
     		if (organisationPersonIdToJoins) {
     			var personEntries = [];
     			
     			for (var organisationPersonId in organisationPersonIdToJoins) {
     				var personJoins = organisationPersonIdToJoins[organisationPersonId];

     				// Assemble string of roles
                                var roleFilterFound = (roleIdFilter == null);
     				var roleStringSet = new Object();
     			    for (var n = 0; n < personJoins.length; n++) {
                                if (roleIdFilter != null && personJoins[n].cdesRoleId != null
                                    && personJoins[n].cdesRoleId == roleIdFilter) {
                                        roleFilterFound = true;
                                    }
     					if (personJoins[n].cdesRoleName != null) {
     						roleStringSet[personJoins[n].cdesRoleName] = true;
     					}
     				}
     				var roleStrings = [];
     				for (var roleString in roleStringSet) {
     					roleStrings.push(roleString);
     				}
     				
     				roleStrings.sort(function(a, b) {
     					return a.localeCompare(b);
     				});
     				var roleString = "";
     				for (var n = 0; n < roleStrings.length; n++) {
     					roleString += roleStrings[n];
     					if (n < roleStrings.length - 1) {
     						roleString += ",";
     					}
     				}
     				
                            if (roleFilterFound) {
     				// Assumption: Only organisationPersonIds for which actually a join exists were added to the map.
     				var personJoin = personJoins[0];
    				var givenName = personJoin.personGivenName ? personJoin.personGivenName : "";
     				var surName = personJoin.personSurName ? personJoin.personSurName : "";
     				var organisationName = personJoin.organisationName ? personJoin.organisationName : "";

     				// Create entry
     				personEntries.push({
     					              name : PlanDeliverHelper.getPlannerPersonLine(personJoin, roleString),
     					                id : organisationPersonId,
     					  organisationName : organisationName,
     					        personName : givenName + " " + surName
     				});
                            }
     			}
     			
     			personEntries.sort(function(entryOne, entryTwo) {
     				var organisationOrder;
     				if (entryOne.organisationName == null) {
     					organisationOrder = -1;
     				} else if (entryTwo.organisationName == null) {
     					organisationOrder = 1;
     				} else {
     					organisationOrder = entryOne.organisationName.localeCompare(entryTwo.organisationName);
     				}
     				
     				if (organisationOrder != 0) {
     					return organisationOrder;
     				} else {
     					if (entryOne.personName == null) {
     						return -1;
     					} else if (entryTwo.personName == null) {
     						return 1;
     					} else {
     						return entryOne.personName.localeCompare(entryTwo.personName);
     					}
     				}
     			});
     			
     			for (var n = 0; n < personEntries.length; n++) {
     				var entry = personEntries[n];
     				data.push({
     					name : entry.name,
     					  id : entry.id
     				});
     			}
     		}
     		return data;
     	},        

     	getPlannerPersonLine : function(personJoin, roleString) {
	    var givenName = personJoin.personGivenName ? personJoin.personGivenName : "";
 	    var surName = personJoin.personSurName ? personJoin.personSurName : "";
 	    var organisation = personJoin.organisationName ? personJoin.organisationName : "";
 	    return organisation + " (" + givenName + " " + surName + ") [" + roleString + "]";
     	},

        getRoleMemoryData : function(roles) {
     	    var data = [];
            if (roles != null) {
                for (var n = 0; n < roles.length; n++) {
                    data.push({ name : roles[n].name, id : roles[n].id });
                }
     		data.sort(function(entryOne, entryTwo) {
                    var nameOne = entryOne.name != null ? entryOne.name : "";
                    var nameTwo = entryTwo.name != null ? entryTwo.name : "";
     		    return nameOne.localeCompare(nameTwo);
     		});
            }
            data.splice(0, 0, SearchPageHelper.constructComboBoxAllOption());
            return data;
        },

        getReviewCycleInstanceReleasedMemoryData : function(reviewCycleInstanceReleaseds) {
     	    var data = [];
            if (reviewCycleInstanceReleaseds != null) {
                for (var n = 0; n < reviewCycleInstanceReleaseds.length; n++) {
                    data.push({ name : reviewCycleInstanceReleaseds[n].name, id : reviewCycleInstanceReleaseds[n].id });
                }
     		data.sort(function(entryOne, entryTwo) {
                    var nameOne = entryOne.name != null ? entryOne.name : "";
                    var nameTwo = entryTwo.name != null ? entryTwo.name : "";
     		    return nameOne.localeCompare(nameTwo);
     		});
            }
            data.splice(0, 0, SearchPageHelper.constructComboBoxAllOption());
            return data;
        },

    		constructVersionOptions : function(params) {
    			var applicationContext = params.applicationContext;
    			var documentListReleaseVersions = params.documentListReleaseVersions;
    			    			
         		var options = [];
         		var unreleasedDocumentId = null;
         		var actualReleasedDocumentId = null;

         		// First the unreleased version, which is part of the join, i.e. present in all JoinDtos for all released versions;
         		// just pick the first one.
         		if (documentListReleaseVersions.length > 0) {
         			var versionDto = documentListReleaseVersions[0];
         			unreleasedDocumentId = versionDto.documentListId;
         			actualReleasedDocumentId = versionDto.documentListReleaseId;
         			var versionString = versionDto.documentListVersion < 10 ? "0" + versionDto.documentListVersion : versionDto.documentListVersion;
             		var unreleasedLabel = string.substitute(i18n.planDeliverSearchUnreleasedVersionString, {
             			version : versionString
             		});
             		options.push({ label : unreleasedLabel, value : documentListReleaseVersions[0].documentListId });
         		}

         		// Then all released versions
         		for (var n = 0; n < documentListReleaseVersions.length; n++) {
         			var versionDto = documentListReleaseVersions[n];
         			
         			if (versionDto.documentListReleaseId != null) {
             			var versionString = versionDto.documentListReleaseVersion < 10 ? "0" + versionDto.documentListReleaseVersion : versionDto.documentListReleaseVersion;
             			var dateString = DateHelper.formatUtcSecondsWithTimeZone(versionDto.signatureTime, applicationContext.getTimeZone(), i18n.dateWithTimePattern);
             			var commonNameString;
             			if (StringHelper.isEmpty(versionDto.personGivenName)) {
             				if (StringHelper.isEmpty(versionDto.personSurName)) {
             					commonNameString = "";
             				} else {
             					commonNameString = versionDto.personSurName;
             				}
             			} else {
             				if (StringHelper.isEmpty(versionDto.personSurName)) {
             					commonNameString = versionDto.personGivenName;
             				} else {
             					commonNameString = versionDto.personGivenName + " " + versionDto.personSurName;
             				}     				
             			}
             			
             			var label = string.substitute(i18n.planDeliverSearchVersionString, {
             				version : versionString,
             				   date : dateString,
             				 person : commonNameString
             			});
             			
             			options.push({ label : label, value : versionDto.documentListReleaseId });     				
         			}
         		} 
         		
         		return {
         			             options : options,
         			unreleasedDocumentId : unreleasedDocumentId,
         		actualReleasedDocumentId : actualReleasedDocumentId
         		}
    		},
    		
        	getPlannerMap : function(joinDtos) {
        		var projectParticipationIdToDto = new Object();

        		for (var n = 0; n < joinDtos.length; n++) {
       				projectParticipationIdToDto[joinDtos[n].projectParticipationId] = joinDtos[n]; 
        		}
        		
        		return projectParticipationIdToDto;
        	},
        	
        	getObjectMap : function(joinDtos) {
        		var objectIdToDto = new Object();

        		for (var n = 0; n < joinDtos.length; n++) {
       				objectIdToDto[joinDtos[n].objectId] = joinDtos[n]; 
        		}
        		
        		return objectIdToDto;    		
        	},
        	
        	getObjectPlannerMap : function(joinDtos) {
        		var objectPlannerIdToDto = new Object();

        		for (var n = 0; n < joinDtos.length; n++) {
       				objectPlannerIdToDto[joinDtos[n].objectPlannerId] = joinDtos[n]; 
        		}
        		
        		return objectPlannerIdToDto;    		
        	},
        	
        	getSearchInfoString : function(joinDtos, plannerMap, objectMap, objectPlannerMap) {
        		
        		var plannerString;
        		var numberOfPlanners = DataHelper.getMapSize(plannerMap);
        		if (numberOfPlanners == 1) {
        			var joinDto = null;
        			for (var projectParticipationId in plannerMap) {
        				joinDto = plannerMap[projectParticipationId];
        			}
        			
        			plannerString = string.substitute(i18n.planDeliverCatalogueOnePlannerString, {
        				organisationName : joinDto.organisationName != null ? joinDto.organisationName : "",
        				personCommonName : NameHelper.getPersonCommonName(joinDto, "person")
        			});
        		} else {
        			plannerString = string.substitute(i18n.planDeliverCatalogueManyPlannersString, {
        				numberOfPlanners : numberOfPlanners
        			});
        		}
        		
        		var objectString;
        		var numberOfObjects = DataHelper.getMapSize(objectMap);
        		if (numberOfObjects == 1) {
        			var joinDto = null;
        			for (var objectId in objectMap) {
        				joinDto = objectMap[objectId];
        			}
        			
        			objectString = string.substitute(i18n.planDeliverCatalogueOneObjectString, {
        				object : CodeHelper.getObjectCode(joinDto) + " " + joinDto.objectName
        			});
        		} else {
        			objectString = string.substitute(i18n.planDeliverCatalogueManyObjectsString, {
        				numberOfObjects : numberOfObjects
        			});
        		}
        		
        		var objectPlannerString;
        		var numberOfObjectPlanners = DataHelper.getMapSize(objectPlannerMap);
        		if (numberOfObjectPlanners == 1) {
        			var joinDto = null;
        			for (var objectPlannerId in objectPlannerMap) {
        				joinDto = objectPlannerMap[objectPlannerId];
        			}
        			
        			objectPlannerString = string.substitute(i18n.planDeliverCatalogueOneObjectPlannerString, {
        				objectPlanner : joinDto.objectPlannerCode + " " + joinDto.objectPlannerArea
        			});
        		} else {
        			objectPlannerString = string.substitute(i18n.planDeliverCatalogueManyObjectPlannersString, {
        				numberOfObjectPlanners : numberOfObjectPlanners
        			});
        		}    		
        	
        		var searchInfoString = string.substitute(i18n.planDeliverCatalogueSearchInfo, {
        			numberOfDocuments : joinDtos.length.toString(),
        			   documentString : i18n.manyDocuments2,
//        			   documentString : joinDtos.length == 1 ? i18n.oneDocument : i18n.manyDocuments,
        			    plannerString : plannerString,
        			     objectString : objectString,
        	      objectPlannerString : objectPlannerString
        		});
        		return searchInfoString;
        	},
        	
        	filterForNonEmptyDocuments : function(joinDtos) {
        		var filteredJoinDtos = [];
        		for (var n = 0; n < joinDtos.length; n++) {
        			if (joinDtos[n].documentId != null) {
        				filteredJoinDtos.push(joinDtos[n]);
        			}
        		}
        		return filteredJoinDtos;
        	},
        	
        	constructPlanDeliverLegend : function(topDiv) {
        		var legendDiv = domConstruct.create("div", null, null);
        		domClass.add(legendDiv, "listLegendDiv");
        		
        		DOMHelper.createTextNode("span", i18n.planDeliverLegendExample, legendDiv, "smallFont documentModifiedNew");
        		DOMHelper.createTextNode("span", i18n.planDeliverLegendNew, legendDiv, "smallFont planDeliverLegendNew");
        		DOMHelper.createTextNode("span", i18n.planDeliverLegendExample, legendDiv, "smallFont documentModifiedGeneral");
        		DOMHelper.createTextNode("span", i18n.planDeliverLegendChangedGeneral, legendDiv, "smallFont planDeliverLegendModifiedGeneral");
        		DOMHelper.createTextNode("span", i18n.planDeliverLegendExample, legendDiv, "smallFont documentModifiedDate");
        		DOMHelper.createTextNode("span", i18n.planDeliverLegendChangedDates, legendDiv, "smallFont planDeliverLegendDatesModified");
        		
        		return legendDiv;
        	},
            				
        	documentNameToString : function() {
        		//log.info("documentNameToString returns ", this.value._clientCalculatedName, this);
        		return this.value != null && this.value._clientCalculatedName != null ? this.value._clientCalculatedName : "";
        		/*
        		var documentName = CodeHelper.getDocumentName(this.value);
        		log.info("Calculated documentName [" + documentName + "] for ", this.value);
        		return documentName;
        		*/
        	},
        	
        	startDateToString : function() {
        		return this.value != null && this.value.getUtcSeconds() != null ? this.value.getUtcSeconds().toString() : "";
    	    },
    	    
        	endDateToString : function() {
        		return this.value != null && this.value.getUtcSeconds() != null ? this.value.getUtcSeconds().toString() : "";
    	    },	  
    	    
    	    commentToString : function() {
    	    	return this.value ? this.value.toString() : "";
    	    },
    	    
    	    contentToString : function() {
    	    	return this.value ? this.value.toString() : "";
    	    },
    	    
    	    scaleToString : function() {
    	    	return this.value ? this.value.toString() : "";
    	    }        	
    };
    
    return PlanDeliverHelper;
});
