/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

////css-prefix = planningNotificationColumn
////i18n-prefix = planningNotificationColumn


define([
    "cdes/util/ColumnHelper",
    "cdes/planning/util/PlanningNotificationHelper",
    "clazzes/TinyLog",
    "clazzes/util/DOMHelper",
    "clazzes/util/MathHelper",
    "clazzes/util/WidgetHelper",
    "clazzes/widgets/IconTitlePane",
    "clazzes/widgets/layout/ContentWidget",
    "dijit/form/CheckBox",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/on",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(
    ColumnHelper,
    PlanningNotificationHelper,
    TinyLog,
    DOMHelper,
    MathHelper,
    WidgetHelper,
    IconTitlePane,
    ContentWidget,
    CheckBox,
    domClass,
    domConstruct,
    domStyle,
    on,
    declare,
    lang,
    i18n) {

    var className = "at.cdes.web.planning.notification.PlanningNotificationColumnWidget";

    var log = new TinyLog(className);

    var PlanningNotificationColumnWidget = declare(className, ContentWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();
            this.postTitleClick();

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "PlanningNotificationColumnWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);
            domClass.add(topDiv, "refNodeOfPositionAbsolute planningNotificationColumnFull");

            this.titlePane = this.constructTitlePane();
            domConstruct.place(this.titlePane.domNode, topDiv);

            return topDiv;
        },

        postTitleClick : function() {
            var open = this.titlePane.get("open");

            if (open) {
                this.titlePane.set("title", i18n.planningNotificationColumnFullCaption);
                domClass.replace(this.topDiv, "planningNotificationColumnFull", "planningNotificationColumnReduced");
            } else {
                this.titlePane.set("title", i18n.planningNotificationColumnReducedCaption);
                domClass.replace(this.topDiv, "planningNotificationColumnReduced", "planningNotificationColumnFull");
            }

            on.emit(this, "titlePaneToggled");
        },

        constructTitlePane : function() {
            this.contentDiv = this.constructEmptyContentDiv();

            var titlePane = new IconTitlePane({
                       title   : i18n.planningNotificationColumnFullCaption,
                       content : this.contentDiv,
                    toggleable : true,
                          open : false,
                postTitleClick : lang.hitch(this, this.postTitleClick)
            });
            domClass.add(titlePane.domNode, "occupyWholeParent");

            return titlePane;
        },

        constructEmptyContentDiv : function() {
            var contentDiv = domConstruct.create("div", null, null);
            domClass.add(contentDiv, "refNodeOfPositionAbsolute planningNotificationColumnContentDiv");

            return contentDiv;
        },



        fillContentDiv : function(metaTags) {

            // Title
            DOMHelper.createTextNode("div", i18n.planningNotificationColumnTitleLabel, this.contentDiv, "fixedDialogWidget planningNotificationColumnTitleLabel");
            this.titleCheckBox = new CheckBox({
                label : i18n.planningNotificationColumnTitleLabel,
                title : i18n.planningNotificationColumnTitleToolTip
            });
            domClass.add(this.titleCheckBox.domNode, "fixedDialogWidget planningNotificationColumnTitleCheckBox");
            domConstruct.place(this.titleCheckBox.domNode, this.contentDiv);
            this.handleCheckBoxEvents(this.titleCheckBox, "title");

            if (this.mode == PlanningNotificationColumnWidget.Mode.DEFAULT) {
                // Comment
                DOMHelper.createTextNode("div", i18n.planningNotificationColumnCommentLabel, this.contentDiv, "fixedDialogWidget planningNotificationColumnCommentLabel");
                this.commentCheckBox = new CheckBox({
                    label : i18n.planningNotificationColumnCommentLabel,
                    title : i18n.planningNotificationColumnCommentToolTip
                });
                domClass.add(this.commentCheckBox.domNode, "fixedDialogWidget planningNotificationColumnCommentCheckBox");
                domConstruct.place(this.commentCheckBox.domNode, this.contentDiv);
                this.handleCheckBoxEvents(this.commentCheckBox, "notificationComment");

                // Project
                DOMHelper.createTextNode("div", i18n.planningNotificationColumnProjectLabel, this.contentDiv, "fixedDialogWidget planningNotificationColumnProjectLabel");
                this.projectCheckBox = new CheckBox({
                    label : i18n.planningNotificationColumnProjectLabel,
                    title : i18n.planningNotificationColumnProjectToolTip
                });
                domClass.add(this.projectCheckBox.domNode, "fixedDialogWidget planningNotificationColumnProjectCheckBox");
                domConstruct.place(this.projectCheckBox.domNode, this.contentDiv);
                this.handleCheckBoxEvents(this.projectCheckBox, "project");
            }                

            this.idToMetaTagInfo = new Object();
            for (var n = 0; n < metaTags.length; n++) {
                var metaTag = metaTags[n];
                var cssClass = metaTag.cssClass;
                var cssRules = metaTag.cssRules;
                var name = metaTag.name;
    		    //note: metaTag.getName must be defined in resourceBundle (without whitespaces)
                // TODO: direct call eg. by "i18n.planningNotificationMetaTag_"+metaName 
//    		    var metaName = metaTag.name.replace(/\s+/g, '');
    		    var metaName = PlanningNotificationHelper.getI18nParameter(name);

                var checkBoxCssClass = "planningNotificationColumn" + cssClass + "CheckBox";
                var labelCssClass = "planningNotificationColumn" + cssClass + "Label";
             // TODO: label is not translated, only title?
                var currCheckBox = new CheckBox({
                    label : metaName,
                    title : metaName
                });
                domClass.add(currCheckBox.domNode, "fixedDialogWidget " + checkBoxCssClass);
                domConstruct.place(currCheckBox.domNode, this.contentDiv);                
                this.handleCheckBoxEvents(currCheckBox, cssClass);

                DOMHelper.createTextNode("div", name, this.contentDiv, "fixedDialogWidget " + labelCssClass);

                this.idToMetaTagInfo[metaTag.id] = {
                     metaTag : metaTag,
                    checkBox : currCheckBox                    
                };
            }                
        },

        handleCheckBoxEvents : function(checkBox, columnId) {
            WidgetHelper.handleCheckBoxEvents(checkBox, lang.hitch(this, function() {
                ColumnHelper.emitColumnsChangedPN(this.applicationContext, this, this.localStoragePath, columnId);
            }));                        
        },

        initialize : function(metaTags) {
            if (metaTags != null) {
                this.fillContentDiv(metaTags);            
                this.initialized = true;
            }                
        },

        setData : function(columnSettings) {
            this.columnSettings = columnSettings;
            this.reload();
        },

        reload : function() {
            if (this.initialized) {
                this.titleCheckBox.set("checked", this.columnSettings.showTitle);
                if (this.mode == PlanningNotificationColumnWidget.Mode.DEFAULT) {
                    this.commentCheckBox.set("checked", !!this.columnSettings.showNotificationComment);
                    this.projectCheckBox.set("checked", !!this.columnSettings.showProject);
                }

                for (var metaTagId in this.idToMetaTagInfo) {
                    var metaTagInfo = this.idToMetaTagInfo[metaTagId];
                    metaTagInfo.checkBox.set("checked", !!this.columnSettings["showMetaTag" + metaTagId]);
                }                
            }                
        },

        updateDataFromWidgets : function() {
            if (this.initialized) {
                this.columnSettings.showTitle = this.titleCheckBox.get("checked");
                if (this.mode == PlanningNotificationColumnWidget.Mode.DEFAULT) {
                    this.columnSettings.showNotificationComment = this.commentCheckBox.get("checked");
                    this.columnSettings.showProject = this.projectCheckBox.get("checked");
                }

                for (var metaTagId in this.idToMetaTagInfo) {
                    var metaTagInfo = this.idToMetaTagInfo[metaTagId];
                    this.columnSettings["showMetaTag" + metaTagId] = metaTagInfo.checkBox.get("checked");
                }                
            }
        },            

        getColumnSettings : function() {
            return this.columnSettings;
        },            

        updateWidgetState : function() {

        }
    });

    PlanningNotificationColumnWidget.AsyncOperation = {

    };

    PlanningNotificationColumnWidget.Mode = {
        DEFAULT : "Default",
        SHAREPOINT : "Sharepoint"        
    };        

    return PlanningNotificationColumnWidget;
});
