/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

define([ 
    "cdes/plot/PlotHelper",
    "cdes/util/ActionHelper",
    "cdes/util/CodeHelper",
    "cdes/util/NameHelper",
    "cdes/widget/base/ListWidget",
    "clazzes/TinyLog",
    "clazzes/form/NumberSpinner",
    "clazzes/util/ErrorHelper",
    "clazzes/util/WidgetHelper",
    "clazzes/widgets/layout/ContentWidget",
    "dgrid/Editor",
    "dgrid/OnDemandGrid",
    "dgrid/extensions/ColumnResizer",
    "dgrid/extensions/DijitRegistry",
    "dijit/form/CheckBox",
    "dijit/form/Select",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/on",
    "dojo/string",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dstore/Memory",
    "dstore/Trackable",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
], function(
    PlotHelper,
    ActionHelper,
    CodeHelper,
    NameHelper,
    ListWidget,
    TinyLog,
    NumberSpinner,
    ErrorHelper,
    WidgetHelper,
    ContentWidget,
    Editor,    
    OnDemandGrid,
    ColumnResizer,
    DijitRegistry,
    CheckBox,
    Select,
    domClass,
    domConstruct,
    on,    
    string,
    declare,
    lang,
    Memory,
    Trackable,
    i18n
) {

    var className = "at.cdes.web.plot.PlotOrderItemListWidget";

    var log = new TinyLog(className);

    var PlotOrderItemListWidget = declare(className, ListWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "PlotOrderItemListWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        columnWidthKey : "plotOrderItemList/columnWidths",

        getLocalStorageContextKeys : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextNetworkId();
            return [organisationPersonId, networkId];
        },

        constructColumns : function() {
            var columns = [];

            if (this.showPaperQuality) {
                columns.push({
                         field : "_paperQuality",
                            id : "plottPropertiesPaperQuality",
		     formatter : lang.hitch(this, this.paperQualityFormatter),                
                        editor : Select,
                    editorArgs : {
                        options : PlotHelper.getPaperQualityOptions()
                    },
                       canEdit : lang.hitch(this, this.canEditPaperQuality),                
                      sortable : true,
                         label : i18n.plotOrderItemPaperQualityCaption
                });
            }                

            if (this.showColor) {
                columns.push({
                         field : "_color",
                            id : "plottPropertiesIsInColor",
                        editor : Select,
                    editorArgs : {
                        options : PlotHelper.getChromaticityOptions()
                    },
                       canEdit : lang.hitch(this, this.canEditColor),
                      sortable : true,
                         label : i18n.plotOrderItemColorCaption
                });
            }                

            if (this.showMargin) {
                columns.push({
                         field : "_margin",
                            id : "plottPropertiesMargin",
		     formatter : lang.hitch(this, this.marginFormatter),                
                        editor : Select,
                    editorArgs : {
                        options : PlotHelper.getMarginOptions()
                    },                    
                       canEdit : lang.hitch(this, this.canEditMargin),
                      sortable : true,
                         label : i18n.plotOrderItemMarginCaption
                });
            }                

            if (this.showMirror) {
                columns.push({
                       field : "_mirror",
                          id : "plottPropertiesMirror",
                      editor : CheckBox,
                     canEdit : lang.hitch(this, this.canEditMirror),                
                    sortable : true,
                       label : i18n.plotOrderItemMirrorCaption
                });
            }                

            if (this.showScale) {
                columns.push({
                         field : "plottPropertiesScale",
                            id : "plottPropertiesScale",
                        editor : Select,
                    editorArgs : {
                        options : PlotHelper.getScaleOptions()
                    },
                       canEdit : lang.hitch(this, this.canEditScale),                
                      sortable : true,
                         label : i18n.plotOrderItemScaleCaption
                });            
            }                

            if (this.showCount) {
                columns.push({
                       field : "_count",
                          id : "plottPropertiesCount",
                      editor : NumberSpinner,
                     canEdit : lang.hitch(this, this.canEditCount),                
                    sortable : true,
                       label : i18n.plotOrderItemCountCaption
                });
            }                

            if (this.showArea) {
                columns.push({
                       field : "_area",
                          id : "area",
                    sortable : true,
                       label : i18n.plotOrderItemAreaCaption
                });
            }                

            if (this.showReceiver) {
                columns.push({
                         field : "_receiver",
                            id : "receiverOrganisationPersonId",
                        editor : Select,
                     formatter : lang.hitch(this, this.receiverFormatter),
                    editorArgs : {
                        options : this.getValidReceiverOptions()
                    },                    
                      sortable : false,
                       canEdit : lang.hitch(this, this.canEditReceiver),
                         label : i18n.plotOrderItemListDeliveryColumnCaption                    
                });                    
            }

            return columns;
        },

    	paperQualityFormatter : function(_paperQuality, itemJoin) {
    		return _paperQuality;
    	},
    	
    	marginFormatter : function(_margin, itemJoin) {
    		return _margin;
    	},

        receiverFormatter : function(_receiver, itemJoin) {
            if (this.validReceivers == null || this.validReceivers.length == 0) {
                return "";
            } else if (this.validReceivers.length == 1) {
                var receiver = this.validReceivers[0];
                return string.substitute(i18n.plotOrderItemListReceiverAddress, {
                                organisationName : receiver.organisationName,
                                personCommonName : NameHelper.getPersonCommonName(receiver, "person"),
                       organisationPostalAddress : receiver.organisationPostalAddress,
                          organisationPostalCode : receiver.organisationPostalCode,
                        organisationLocalityName : receiver.organisationLocalityName,
                                 opCountryDescDe : receiver.opCountryDescDe
                });
            } else {
                return _receiver;
            }                
        },            

        canEditPaperQuality : function() {
            return this.editablePlotProperties;
        },

        canEditColor : function() {
            return this.editablePlotProperties;
        },

        canEditMargin : function() {
            return this.editablePlotProperties;
        },

        canEditMirror : function() {
            return this.editablePlotProperties;
        },

        canEditScale : function() {
            return true;
        },

        canEditCount : function() {
            return true;
        },

        canEditReceiver : function() {
            return this.validReceivers != null && this.validReceivers.length > 0;            
        },

        getValidReceiverOptions : function() {
            var options = [];

            if (this.validReceivers != null) {
                for (var n = 0; n < this.validReceivers.length; n++) {
                    options.push({
                        value : this.validReceivers[n].organisationPersonId,
                        label : NameHelper.getOrganisationPersonName({ organisationPersonJoin : this.validReceivers[n] })
                    });                        
                }                
            }
            options.sort(lang.hitch(this, function(optionOne, optionTwo) {
                return optionOne.label.localeCompare(optionTwo.label);
            }));

            return options;            
        },

        constructTopDiv : function() {
            this.constructGrid({
		idProperty : "plottOrderItemTemplateId", 
            	    gridId : "plotOrderItemListGrid",
                 gridClass : "Grid",
                   modules : [ Editor ]
            });
            return this.grid.domNode;
        },

        resize : function(newSize) {
            this.grid.resize(newSize);
        },

        setData : function(params) {
            this.itemJoins = params.itemJoins;
            this.validReceivers = params.validReceivers;            
            this.editablePlotProperties = params.editablePlotProperties;
    	    this.updateAuxiliaryData();
            this.reload();
        },

        reload : function(params) {
            this.setStoreData(this.itemJoins);

            var rowNodes = this.grid.contentNode.childNodes;
            for (var n = 0; n < rowNodes.length; n++) {
                if (this.canEditCount()) {
                    var countCell = this.grid.cell(rowNodes[n], "plottPropertiesCount");
                    if (countCell && countCell.element && countCell.element.widget) {
                        var numberSpinner = countCell.element.widget;
                        WidgetHelper.setMustField(numberSpinner, true);
                        WidgetHelper.handleSpinnerEvents(numberSpinner, lang.hitch(this, this.updateWidgetState));
                    }                    
                }                    

                var receiverCell = this.grid.cell(rowNodes[n], "receiverOrganisationPersonId");
                if (receiverCell && receiverCell.element && receiverCell.element.widget) {
                    var select = receiverCell.element.widget;
                    var options = this.getValidReceiverOptions();
                    WidgetHelper.setSelectOptionsAndKeepLabelIfPossible(select, options);
                    if (options.length > 0) {
                        select.set("value", options[0].value);
                    }                        
                }                    
            }

            this.updateWidgetState();
//            this.grid.set("sort", "plottPropertiesScale", false);
//            this.grid.updateSortArrow(this.grid.sort);
        },

        updateWidgetState : function() {
            var allFieldsValid = true;

            if (this.grid.contentNode != null) {
                var rowNodes = this.grid.contentNode.childNodes;
                for (var n = 0; n < rowNodes.length; n++) {
                    if (this.canEditCount()) {
                        var countCell = this.grid.cell(rowNodes[n], "plottPropertiesCount");
                        if (countCell && countCell.element && countCell.element.widget) {
                            var numberSpinner = countCell.element.widget;
                            WidgetHelper.updateEmptySpinnerState(numberSpinner);
                            allFieldsValid &= WidgetHelper.isNumberSpinnerValid(numberSpinner);                        
                        }
                    }
                }
            }                

            if (allFieldsValid != this.allFieldsValid) {
    		this.allFieldsValid = allFieldsValid;
    		on.emit(this, "validStateChanged");
            }                
        },

    	updateAuxiliaryData : function() {
    	    for (var n = 0; n < this.itemJoins.length; n++) {
    		var itemJoin = this.itemJoins[n];
                itemJoin._color = PlotHelper.getColorString(itemJoin.plottPropertiesIsInColor);                    
    		itemJoin._paperQuality = itemJoin.plottPropertiesPaperQuality;
    		itemJoin._margin = itemJoin.plottPropertiesMargin;
    		
    		itemJoin._mirror = CodeHelper.getBooleanYesNo(itemJoin.plottPropertiesMirror);
    		itemJoin._count = (this.canEditCount() ? itemJoin.plottPropertiesCount : PlotHelper.getCountString(itemJoin.plottPropertiesCount));
    		itemJoin._areaValue = PlotHelper.getArea({
                llx : itemJoin.plottPropertiesLlx,
                lly : itemJoin.plottPropertiesLly,
                urx : itemJoin.plottPropertiesUrx,
                ury : itemJoin.plottPropertiesUry,
              scale : itemJoin.plottPropertiesScale,
              count : itemJoin.plottPropertiesCount                        
                });
                itemJoin._area = PlotHelper.getLongAreaString(itemJoin._areaValue);

                if (this.validReceivers != null) {
                    if (this.validReceivers.length == 0) {
                        itemJoin._receiver = null;
                    } else if (this.validReceivers.length == 1) {
                        itemJoin._receiver = NameHelper.getOrganisationPersonName({ organisationPersonJoin : this.validReceivers[0] });
                    } else {
                        itemJoin._receiver = this.validReceivers[0].organisationPersonId;
                    }                        
                }                    
            }
        },            

        getSignInfos : function() {
            var signInfos = [];

            var rowNodes = this.grid.contentNode.childNodes;
            for (var n = 0; n < rowNodes.length; n++) {
                var row = this.grid.row(rowNodes[n]);

                var signInfo = new Object({
                    // signInfos (and rows in the grid) exist only if there is at least one itemJoin,
                    // and all itemJoins share the same plottOrderTemplateId                    
                    plottOrderItemTemplateOrderContractId : this.itemJoins[0].plottOrderItemTemplateOrderContractId,
                                                      llx : row.data.plottPropertiesLlx,
                                                      lly : row.data.plottPropertiesLly,
                                                      urx : row.data.plottPropertiesUrx,
                                                      ury : row.data.plottPropertiesUry,
                                                 userUnit : row.data.plottPropertiesUserUnit                    
                });

                if (this.canEditPaperQuality()) {
                    var paperQualityCell = this.grid.cell(rowNodes[n], "plottPropertiesPaperQuality");
                    signInfo.paperQuality = paperQualityCell.element.widget.get("value");
                } else {
                    signInfo.paperQuality = row.data.plottPropertiesPaperQuality;
                }

                if (this.canEditColor()) {
                    var colorCell = this.grid.cell(rowNodes[n], "plottPropertiesIsInColor");
                    signInfo.isInColor = colorCell.element.widget.get("value");                    
                } else {
                    signInfo.isInColor = row.data.plottPropertiesIsInColor;
                }                    

                if (this.canEditMargin()) {
                    var marginCell = this.grid.cell(rowNodes[n], "plottPropertiesMargin");
                    signInfo.margin = marginCell.element.widget.get("value");
                } else {
                    signInfo.margin = row.data.plottPropertiesMargin;
                }                    

                if (this.canEditMirror()) {
                    var mirrorCell = this.grid.cell(rowNodes[n], "plottPropertiesMirror");
                    signInfo.mirror = mirrorCell.element.widget.get("checked");
                } else {
                    signInfo.mirror = row.data.plottPropertiesMirror;
                }                    

                if (this.canEditScale()) {
                    var scaleCell = this.grid.cell(rowNodes[n], "plottPropertiesScale");
                    signInfo.scale = scaleCell.element.widget.get("value");
                } else {
                    signInfo.scale = row.data.plottPropertiesScale;
                }                    

                if (this.canEditCount()) {
                    var countCell = this.grid.cell(rowNodes[n], "plottPropertiesCount");
                    signInfo.count = countCell.element.widget.get("value");                    
                } else {
                    signInfo.count = row.data.plottPropertiesCount;
                }                    

                if (this.canEditReceiver()) {
                    var receiverCell = this.grid.cell(rowNodes[n], "receiverOrganisationPersonId");
                    signInfo.receiverOrganisationPersonId = receiverCell.element.widget.get("value");
                } else {
                    signInfo.receiverOrganisationPersonId = null;
                }                    

                signInfos.push(signInfo);
            }
            return signInfos;;
        },

        destroy : function() {
            this.inherited(arguments);

            this.grid.destroy();
        }
    });

    PlotOrderItemListWidget.AsyncOperation = {

    };

    return PlotOrderItemListWidget;
});
