/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/



define([ "cdes/widget/project/ProjectParticipationMultiContentWidget",
         "clazzes/ClazzesVoc",
	     "clazzes/TinyLog",
         "clazzes/form/FancyButton",
         "clazzes/form/MultiWidget",
         "clazzes/util/DOMHelper",
         "clazzes/util/WidgetHelper",
         "clazzes/widgets/layout/EditDialog",
         "dijit/Tooltip",
         "dijit/_WidgetBase",
         "dijit/form/ComboBox",
         "dijit/form/Select",
         "dijit/form/TextBox",
	     "dojo/dom-class",
	     "dojo/dom-construct",
	     "dojo/dom-style",
	     "dojo/on",
         "dojo/string",
	     "dojo/_base/declare",
	     "dojo/_base/lang",
         "dojo/touch",
	     "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],

       function(ProjectParticipationMultiContentWidget,
                ClazzesVoc,
		        TinyLog,
                FancyButton,
                MultiWidget,
                DOMHelper,
                WidgetHelper,
		        EditDialog,
                Tooltip,
                _WidgetBase,
                ComboBox,
                Select,
                TextBox,
		        domClass,
		        domConstruct,
		        domStyle,
		        on,
                string,
		        declare,
		        lang,
                touch,
		        i18n) {

    var className = "at.cdes.web.widget.project.ProjectParticipationMultiSelect";

    var log = new TinyLog(className);

    var ProjectParticipationMultiSelect = declare(className, _WidgetBase, {

    	buildRendering: function() {
	    this.inherited(arguments);
	    domClass.add(this.domNode, "participationMultiSelectTopDiv");

        if (this.projectParticipationIds == null) {
            this.projectParticipationIds = [];
        }

	    this.select = new Select({
		        label : i18n.projectParticipationMultiSelectSelectLabel,
		        title : i18n.projectParticipationMultiSelectSelectToolTip
	    });
	    if (this.selectClass != null) {
			domClass.add(this.select.domNode, this.selectClass);
	    }

	    this.select._onDropDownMouseDown = function(/*Event*/ e){
		// summary:
		//		Callback when the user mousedown/touchstart on the arrow icon.

		if(this.disabled || this.readOnly){
		    return;
		}

		// Prevent default to stop things like text selection, but don't stop propagation, so that:
		//		1. TimeTextBox etc. can focus the <input> on mousedown
		//		2. dropDownButtonActive class applied by _CssStateMixin (on button depress)
		//		3. user defined onMouseDown handler fires
		//
		// Also, don't call preventDefault() on MSPointerDown event (on IE10) because that prevents the button
		// from getting focus, and then the focus manager doesn't know what's going on (#17262)
		if(e.type != "MSPointerDown") {// && e.type != "pointerdown"){
		     e.preventDefault();
		 }

		this.own(on.once(this.ownerDocument, touch.release, lang.hitch(this, "_onDropDownMouseUp")));

		this.toggleDropDown();
	    },

	    domConstruct.place(this.select.domNode, this.domNode);
        WidgetHelper.handleSelectEvents(this.select, lang.hitch(this, this.updateParticipationsFromSelect));

        // ... or a read only text box
        this.chooseInfoTextBox = new TextBox({
                label : i18n.projectParticipationMultiSelectTextBoxLabel,
             disabled : true
         });
        domClass.add(this.chooseInfoTextBox.domNode, "fixedDialogWidget " + this.selectClass);
        domConstruct.place(this.chooseInfoTextBox.domNode, this.domNode);

        // ToolTip
	    this.chooseInfoToolTip = new Tooltip({
		 connectId : [this.chooseInfoTextBox.domNode],
		 label     : ""
	     });

	    // DOJOSKETCH-119: It seems that the built-in code for hiding the ToolTip provided by
	    //                 Dojo (using connectId specified above) does not work reliable on
	    //                 Firefox.
	    this.own(
	    	 on(this.chooseInfoToolTip.domNode, "mouseleave", lang.hitch(this, function(event) {
    	     this.chooseInfoToolTip._onUnHover();
	    	 }))
	    );

            // New / edit button
	    this.newButton = this.constructNewButton();
	    domClass.add(this.newButton.domNode, "fixedDialogWidget participationMultiSelectAddButton");
	    domConstruct.place(this.newButton.domNode, this.domNode);

        this.updateWidgetState();
	},

	constructNewButton : function() {
   	    var button = new FancyButton({
   	    	title : i18n.projectParticipationMultiSelectAddLabel,
            iconClass : "fancyButtonIcon17x18 fancyButton17x18 addButton"
   	    });

	    on(button, "click", lang.hitch(this, function() {
                var contentWidget = new ProjectParticipationMultiContentWidget({
                    applicationContext : this.applicationContext
                });

		var editDialog = new EditDialog({
		    contentWidget : contentWidget,
		    defaultWidth  : 800,  // Should be in sync with corresponding rules in CSS
		    defaultHeight : 350,
			    title : i18n.projectParticipationMultiSelectConfigureTitlesCaption,
    		          buttons : [ { type : ClazzesVoc.Button.OK,
					label : i18n.projectParticipationMultiSelectAlterSearchLabel,
					title : i18n.projectParticipationMultiSelectAlterSearchToolTip },
    				      { type : ClazzesVoc.Button.ABORT, title : i18n.abortButtonCaption } ]
		        });
                on(contentWidget, "participationsChosen", lang.hitch(this, function(projectParticipationIds) {
                    this.projectParticipationIds = projectParticipationIds;
                    this.updateWidgetsFromData();
                    this.updateWidgetState();
                }));

		editDialog.setData({
				    options : this.options,
                    projectParticipationIds : this.projectParticipationIds
		});
		editDialog.show();
	    }));

	    domConstruct.place(button.domNode, this.domNode);

	    return button;
	},


	_setValueAttr : function(projectParticipationIds) {
            // Compatibility to PlanningNotificationHelper.handleProjectSelectChange, which was
            // originally implemented for a ComboBox widget receiving a string, not an array as
            // our widget here.  The empty string means, reset it.
/*            if (typeof titles == "string") {
                 if (titles.length == 0) {
                     titles = [];
                 } else {
                     log.warn("Widget called with string value, but an array value (or the empty string) is required.");
                     titles = [];
                 }
            }                */

            this.projectParticipationIds = projectParticipationIds != null ? projectParticipationIds : [];

            this.updateWidgetsFromData();
            this.updateWidgetState();
	},

	_getValueAttr : function() {
            return this.projectParticipationIds;
	},

        _setOptionsAttr : function(options) {
            this.options = options;
            for (var n = 0; n < this.options.length; n++) {
                this.options[n].selected = false;
            }

	    this.projectParticipationIdToLabel = new Object();
	    for (var n = 0; n < this.options.length; n++) {
			this.projectParticipationIdToLabel[this.options[n].value] = this.options[n].label;
	    }
        if (this.projectParticipationIds == null || this.projectParticipationIds.length <= 1) {
            this.select.set("options", options);
        }

	    this.select.set("value", this.defaultValue, !!this.initialized);
    },

    updateWidgetsFromData : function() {
        if (this.projectParticipationIds == null || this.projectParticipationIds.length == 0) {
            this.select.set("value", this.defaultValue, !!this.initialized);
        } else if (this.projectParticipationIds.length == 1) {
            this.select.set("value", this.projectParticipationIds[0]);
        } else {
            var chooseInfo = string.substitute(i18n.projectParticipationMultiSelectChooseInfo, {
               count : this.projectParticipationIds.length
            });
            this.chooseInfoTextBox.set("value", chooseInfo);

            var toolTipString = "<ul>";
            for (var n = 0; n < this.projectParticipationIds.length; n++) {
            	var label = this.projectParticipationIdToLabel[this.projectParticipationIds[n]];
                toolTipString += "<li>" + label + "</li>";
            }

            toolTipString += "</ul>";
            this.chooseInfoToolTip.set("label", toolTipString);
        }
    },

    updateParticipationsFromSelect : function() {
        var projectParticipationId = this.select.get("value");
        if (projectParticipationId == null) {
            this.projectParticipationIds = [];
        } else {
            this.projectParticipationIds = [ projectParticipationId ];
        }
    },

    updateWidgetState : function() {
        domClass.replace(this.select.domNode, "invisible", "visible");
        domClass.replace(this.chooseInfoTextBox.domNode, "invisible", "visible");

        if (this.projectParticipationIds == null || this.projectParticipationIds.length <= 1) {
            domClass.replace(this.select.domNode, "visible", "invisible");
            this.newButton.set("title", i18n.projectParticipationMultiSelectAddLabel);
            this.newButton.set("iconClass", "fancyButtonIcon17x18 fancyButton17x18 addButton");
        } else {
            domClass.replace(this.chooseInfoTextBox.domNode, "visible", "invisible");
            this.newButton.set("title", i18n.projectParticipationMultiSelectEditLabel);
            this.newButton.set("iconClass", "fancyButtonIcon17x18 fancyButton17x18 editButton");
        }
    },

	isValid : function(isValidFct) {
	    var allValid = true;
	    return allValid;
	}
    });

    return ProjectParticipationMultiSelect;
});
