/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

define([ 
    "cdes/document/DocumentHelper",
    "cdes/widget/base/ListWidget",
    "clazzes/TinyLog",
    "clazzes/dateTime/DateHelper",
    "clazzes/util/DOMHelper",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/on",
    "dojo/string",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
], function(
    DocumentHelper,
    ListWidget,
    TinyLog,
    DateHelper,
    DOMHelper,
    domClass,
    domConstruct,
    domStyle,
    on,
    string,    
    declare,
    lang,
    i18n
) {

    var className = "at.cdes.document.ReviewProtocolReferenceWidget";

    var log = new TinyLog(className);

    var ReviewProtocolReferenceWidget = declare(className, ListWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "ReviewProtocolReferenceWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructColumns : function() {
            var columns = [];

	    columns.push({
		     field : "documentReferenceRealm",
			id : "documentReferenceRealm",
		  sortable : true,
		    label : i18n.reviewProtocolReferenceRealmCaption
	    });

	    columns.push({
		     field : "documentReferenceReference",
		        id : "documentReferenceReference",
                renderCell : lang.hitch(this, this.renderReferenceCell),
		  sortable : true,
		     label : i18n.reviewProtocolReferenceReferenceCaption
	    });            

	    columns.push({
		     field : "documentReferenceGz",
			id : "documentReferenceGz",
		  sortable : true,
		    label : i18n.reviewProtocolReferenceGzCaption
	    });            

	    columns.push({
		    field : "documentReferenceCreated",
		       id : "documentReferenceCreated",
                formatter : lang.hitch(this, this.formatDate),
		 sortable : true,
		    label : i18n.reviewProtocolReferenceCreatedCaption
	    });

	    columns.push({
		    field : "_validFor",
		       id : "validFor",
                formatter : lang.hitch(this, this.formatValidFor),
		 sortable : true,
		    label : i18n.reviewProtocolReferenceValidForCaption
	    });

            return columns;            
        },

	renderReferenceCell : function(reviewProtocolReferenceJoin, data, cell) {
            // description:
            //     Needed fields in reviewProtocolVersionJoin:
            //       - documentVersionFiletype
            //       - documentVersionStatus
            //       - subProjectInvalidated
            //       - previewSupportDocumentVersionId (if null, the comparison button just won't be shown)            
            //       - _objectPlannerActions

            var referenceDiv = domConstruct.create("div", null, null);
            var reference = reviewProtocolReferenceJoin.documentReferenceReference;            
            // Safe html thanks to server side
        	var node = domConstruct.create("div", { innerHTML : reference });
            domClass.add(node, "reviewProtocolPositionComment");                    
            domConstruct.place(node, referenceDiv);                

            var objectPlannerId = reviewProtocolReferenceJoin.documentObjectPlannerId;
            var actions = objectPlannerId in reviewProtocolReferenceJoin._objectPlannerIdToActions
                ? reviewProtocolReferenceJoin._objectPlannerIdToActions[objectPlannerId] : new Object();

            // Inverse addition, to make float:right place the attachmentButtonDiv *right* of the buttonDiv constructed below (if both exist)
            if (reviewProtocolReferenceJoin.documentReferenceAttachmentFilename != null && "downloadAttachment" in actions) {
                var attachmentButtonDiv = DocumentHelper.renderAttachmentFileButton({
                      documentListJoin : reviewProtocolReferenceJoin,
                    applicationContext : this.applicationContext
                });
                domClass.add(attachmentButtonDiv, "reviewProtocolVersionAttachmentButtonDiv");
                domConstruct.place(attachmentButtonDiv, referenceDiv);           
            }                
            
            if (reviewProtocolReferenceJoin.documentReferenceReferencedVersionId != null) {
                var buttonDiv = DocumentHelper.renderFileButtons({
                                          documentListJoin : reviewProtocolReferenceJoin,
                                        applicationContext : this.applicationContext,
                            checkForInvalidDocumentVersion : false,
                    checkForInvalidDocumentVersionDownload : true                                
                });
                domClass.add(buttonDiv, "reviewProtocolVersionGridButtonDiv");
                domConstruct.place(buttonDiv, referenceDiv);
            }



            return referenceDiv;
        },        

        formatDate : function(date, reviewProtocolReferenceJoin) {
            var created = reviewProtocolReferenceJoin.documentReferenceCreated;
    	    if (created != null) {
    		return DateHelper.formatUtcSecondsWithTimeZone(created, this.applicationContext.getTimeZone(), i18n.datePattern); 
    	    } else {
    		return "";
    	    }            
        },

        formatValidFor : function(_validFor, reviewProtocolReferenceJoin) {
            var sinceVersionPartA = reviewProtocolReferenceJoin.sinceDocumentVersionVersionParta;
            var sinceVersionPartB = reviewProtocolReferenceJoin.sinceDocumentVersionVersionPartb;
            var sinceVersionPartSeparator = reviewProtocolReferenceJoin.sinceDocumentVersionVersionPartSeperator;

            var untilVersionPartA = reviewProtocolReferenceJoin.untilDocumentVersionVersionParta;
            var untilVersionPartB = reviewProtocolReferenceJoin.untilDocumentVersionVersionPartb;
            var untilVersionPartSeparator = reviewProtocolReferenceJoin.untilDocumentVersionVersionPartSeperator;                        

            var validFor = string.substitute(i18n.reviewProtocolReferenceValidFor, {
                        sinceVersionPartA : (sinceVersionPartA != null ? sinceVersionPartA : ""),
                        sinceVersionPartB : (sinceVersionPartB != null ? sinceVersionPartB : ""),
                sinceVersionPartSeparator : (sinceVersionPartSeparator != null ? sinceVersionPartSeparator : ""),
                        untilVersionPartA : (untilVersionPartA != null ? untilVersionPartA : ""),
                        untilVersionPartB : (untilVersionPartB != null ? untilVersionPartB : ""),
                untilVersionPartSeparator : (untilVersionPartSeparator != null ? untilVersionPartSeparator : "")
            });
            return validFor;            
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);

	    var gridNode = this.constructGrid({
		idProperty : "documentReferenceId", 
		    gridId : "ReviewProtocolReferenceGrid",
                 gridClass : "Grid"
	    });
            domClass.add(gridNode, "hidden");
            domConstruct.place(gridNode, topDiv);

            this.noEntriesLabel = DOMHelper.createTextNode("div", i18n.reviewProtocolNoReferencesLabel, topDiv, "hidden");
            /*            
	    on(grid, "dgrid-sort", lang.hitch(this, function(e) {
		var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
		var networkId = this.applicationContext.getPageContextPnNetworkId();
		this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotification/sort", e.sort);
	    }));
            */

            return topDiv;
        },

        setData : function(params) {
            this.referenceJoins = params.referenceJoins;
            this.referenceJoins.sort(function(joinOne, joinTwo) {
                var createdOne = joinOne.documentReferenceCreated;
                var createdTwo = joinTwo.documentReferenceCreated;
                return createdOne - createdTwo;                
            });                

            this.updateAuxiliaryData();

            this.reload();
        },

        reload : function() {
            if (this.referenceJoins != null && this.referenceJoins.length > 0) {
                domClass.remove(this.grid.domNode, "hidden");
                domClass.add(this.noEntriesLabel, "hidden");               
            } else {
                domClass.add(this.grid.domNode, "hidden");
                domClass.remove(this.noEntriesLabel, "hidden");
            }                

            this.setStoreData(this.referenceJoins);
            this.grid.resize();
        },

	updateAuxiliaryData : function() {
	    for (var n = 0; n < this.referenceJoins.length; n++) {
		var referenceJoin = this.referenceJoins[n];
                referenceJoin._validFor = this.formatValidFor(null, referenceJoin);
	    }
	},

        updateWidgetState : function() {

        },

        resize : function(newSize,omitHeightAdjustment) {
            // We need to perform the resize in two steps.
            // First set the desired width, and some arbitrary height.
            if (omitHeightAdjustment) {
                this.grid.resize(newSize);
            } else {
                var width = newSize.w + 0.01;
                var height = this.getActualHeight();
                this.grid.resize({ w : width, h : height });
            }
        },

        destroy : function() {
            this.inherited(arguments);
            this.grid.destroy();
        }
    });

    ReviewProtocolReferenceWidget.AsyncOperation = {
        DELETE : "Delete"
    };        

    return ReviewProtocolReferenceWidget;
});
