define([
        "cdes/core/CdesVoc",
        "clazzes/TinyLog",
        "clazzes/util/DOMHelper",
        "clazzes/util/WidgetHelper",
        "dijit/form/Button",
        "dijit/form/TextBox",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
],
function(
         CdesVoc,
         TinyLog,
         DOMHelper,
         WidgetHelper,
         Button,
         TextBox,
         domClass,
         domConstruct,
         i18n
         ) {

    var className = "at.cdes.web.util.SearchPageHelper";

    var log = new TinyLog(className);

    var SearchPageHelper = {
        constructSingleLineStatusBarWithQuickSearch : function(params) {
            // Populates the following members in baseWidget:
            // - statusDiv
            // - quickSearchTextBox
            // - quickSearchClearButton

            var baseWidget = params.baseWidget;
            var processQuickSearchChangeFct = params.processQuickSearchChangeFct;
            var clearQuickSearchFct = params.clearQuickSearchFct;
            var omitQuickSearch = params.omitQuickSearch;

            var statusBarDiv = domConstruct.create("div", null, null);
            domClass.add(statusBarDiv, "refNodeOfPositionAbsolute");

            baseWidget.statusDiv = DOMHelper.createTextNode("div", i18n.notYetSearched, statusBarDiv, "fixedDialogWidget singleLineStatusBarDiv");

            // Quick Search
            if (!omitQuickSearch) {
                DOMHelper.createTextNode("div", i18n.quickSearchLabel, statusBarDiv, "propertyLabel singleLineStatusBarQuickSearchLabel");
                baseWidget.quickSearchTextBox = new TextBox({
                    label : i18n.quickSearchLabel,
                    title : i18n.quickSearchToolTip
                });
                domClass.add(baseWidget.quickSearchTextBox.domNode, "fixedDialogWidget singleLineStatusBarQuickSearchTextBox");
                domConstruct.place(baseWidget.quickSearchTextBox.domNode, statusBarDiv);
                WidgetHelper.handleTextBoxEvents(baseWidget.quickSearchTextBox, processQuickSearchChangeFct);

                baseWidget.quickSearchClearButton = new Button({
                      label : i18n.quickSearchClearLabel,
                      title : i18n.quickSearchClearToolTip,
                    onClick : clearQuickSearchFct
                });
                domClass.add(baseWidget.quickSearchClearButton.domNode, "fixedDialogWidget singleLineStatusBarQuickSearchClearButton");
                domConstruct.place(baseWidget.quickSearchClearButton.domNode, statusBarDiv);
            }

            return statusBarDiv;
        },

        constructComboBoxAllOption : function() {
            return {name: i18n.allOption, id : CdesVoc.MagicSelectOption.ALL};
        },

        isComboBoxSetToAll : function(comboBox) {
            if (comboBox.item != null && comboBox.item.id != null) {
                return comboBox.item.id == CdesVoc.MagicSelectOption.ALL;
            } else {
                var value = comboBox.get("value");
                return value == null || value.trim() == i18n.allOption || value.trim().length == 0;
            }
        },

        getAllableComboBoxId : function(comboBox) {
            if (SearchPageHelper.isComboBoxSetToAll(comboBox)) {
                return null;
            } else {
                return comboBox.item != null ? comboBox.item.id : null;
            }
        },

        setAllableComboBoxValueToSearchModel : function(comboBox, searchModel, idAttributeName, nameAttributeName) {
            if (SearchPageHelper.isComboBoxSetToAll(comboBox)) {
                var value = comboBox.get("value");
                if (comboBox.item == null && (value == null || value.trim().length == 0)) {
                    SearchPageHelper.setComboBoxValue(comboBox, CdesVoc.MagicSelectOption.ALL);
                }
                searchModel[idAttributeName] = CdesVoc.MagicSelectOption.ALL;
                searchModel[nameAttributeName] = null;
            } else if (comboBox.item != null && comboBox.item.id != null) {
                searchModel[nameAttributeName] = null;
				searchModel[idAttributeName] = comboBox.item.id;
		    } else {
                var value = comboBox.get("value");
                if (value == null || value.trim().length == 0) {
                    SearchPageHelper.setComboBoxValue(comboBox, CdesVoc.MagicSelectOption.ALL);
                }
                searchModel[idAttributeName] = null;
				searchModel[nameAttributeName] = value;
		    }
        },

        setSearchModelValueToAllableComboBox : function(searchModel, comboBox, idAttributeName, nameAttributeName) {
            var id = searchModel[idAttributeName];
            var name = searchModel[nameAttributeName];

            if (id == null && name == null) {
                id = CdesVoc.MagicSelectOption.ALL;
            }

            if (id != null && comboBox.store != null) {
                var item = comboBox.store.get(id);
                if (item != null) {
                    comboBox.set("value", item.name);
                }
                comboBox.item = item;
            } else {
                comboBox.set("value", name);
            }
        },

        setComboBoxValue : function(comboBox, value, withEvents) {
            withEvents = withEvents != null ? withEvents : true;
            var item = comboBox.store.get(value);
            if (item != null) {
                comboBox.set("value", item.name, withEvents);
            }
            comboBox.item = item;
        }
    };

    return SearchPageHelper;
});
