/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

////css-prefix = planningNotificationList
////i18n-prefix = planningNotificationList


define([
    "cdes/core/CdesVoc",
    "cdes/planning/order/PlanningNotificationOrderImportWidget",
    "cdes/planning/util/PlanningNotificationHelper",
    "cdes/planning/util/PlanningNotificationListHelper",
    "cdes/util/ActionHelper",
    "cdes/util/ColumnHelper",
    "cdes/widget/base/ListWidget",
    "clazzes/ClazzesVoc",
    "clazzes/TinyLog",
    "clazzes/dateTime/DateHelper",
    "clazzes/form/FancyButton",
    "clazzes/topic",
    "clazzes/util/ErrorHelper",
    "clazzes/widgets/layout/ContentWidget",
    "clazzes/widgets/layout/EditDialog",
    "clazzes/widgets/layout/InfoDialog",
    "dgrid/OnDemandGrid",
    "dgrid/extensions/ColumnResizer",
    "dgrid/extensions/DijitRegistry",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/on",
    "dojo/string",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dstore/Memory",
    "dstore/Trackable",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(CdesVoc,
    PlanningNotificationOrderImportWidget,
    PlanningNotificationHelper,
    PlanningNotificationListHelper,
    ActionHelper,
    ColumnHelper,
    ListWidget,
    ClazzesVoc,
    TinyLog,
    DateHelper,
    FancyButton,
    topic,
    ErrorHelper,
    ContentWidget,
    EditDialog,
    InfoDialog,
    OnDemandGrid,                
    ColumnResizer,
    DijitRegistry,
    domClass,
    domConstruct,
    on,
    string,
    declare,
    lang,
    Memory,
    Trackable,
    i18n) {

    var className = "at.cdes.web.planning.notification.PlanningNotificationListWidget";

    var log = new TinyLog(className);

    var PlanningNotificationListWidget = declare(className, ListWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "PlanningNotificationListWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructColumns : function() {
            // CAUTION: The column ids are also used at server side, for rendering the PDF output.
            // See at.cdes.impl.export.planning.PlanningNotificationListExporter            

            var columns = [];

            PlanningNotificationListHelper.pushPlanningNotificationTitleColumn(columns);

            if (this.mode == PlanningNotificationListWidget.Mode.DEFAULT) {
                PlanningNotificationListHelper.pushNotificationCommentColumn(columns);
                PlanningNotificationListHelper.pushProjectColumn(columns);
            }

            if (this.metaTags != null) {
                PlanningNotificationListHelper.pushMetaTagColumns(columns, this.metaTags);
            }           

            if (this.mode != PlanningNotificationListWidget.Mode.SHAREPOINT) {
                columns.push({
                         field : "_planningNotificationId",
                            id : "file",
                    renderCell : lang.hitch(this, this.renderFileCell),
                      sortable : false,
                         label : i18n.planningNotificationFileColumnCaption
                });             
            }           

            columns.push({
                     field : "_planningNotificationId",
                        id : "actions",
                renderCell : lang.hitch(this, this.renderActionCell),
                  sortable : false,
                     label : i18n.actionColumnCaption
            });

            return columns;
        },

        columnIdToDefaultWidth : {
                          title : 300,
            notificationComment : 150,
                        project : 150,           
                           file : 70,
                        actions : 150            
        },            

        defaultColumnWidth : 130,

        formatMetaTag : function(metaTag, planningNotificationInfo) {
            var metaTagId = metaTag.id;
            if (metaTag.tagFormat == CdesVoc.TagFormat.TEXT) {
                var textMetaInformations = planningNotificationInfo.metaTagIdToDateMetaInformation[metaTagId];
                return PlanningNotificationListHelper.maybeMultipleTextFormatter(textMetaInformations, planningNotificationInfo);
            } else if (metaTag.tagFormat == CdesVoc.TagFormat.DATE) {
                var dateMetaInformations = planningNotificationInfo.metaTagIdToDateMetaInformation[metaTagId];
                return PlanningNotificationListHelper.maybeMultipleDateFormatter(dateMetaInformations, planningNotificationInfo);
            } else {
                throw new Error("Illegal tagFormat [" + metaTag.tagFormat + "]");
            }           
        },

        projectFormatter : function(planningNotificationId, planningNotificationInfo) {
            var projects = planningNotificationInfo.projects;
            var projectString = "";
            for (var n = 0; n < projects.length; n++) {
                if (n > 0) {
                    projectString += ", ";
                }

                projectString += "<b>" + projects[n].code + "</b> " + projects[n].name;
            }

            return projectString;           
        },

        updateIndividualColumns : function() {
            // Update the individual columns
            this.updateColumn("title", this.columnSettings.showTitle);
            this.updateColumn("notificationComment", this.columnSettings.showNotificationComment);
            this.updateColumn("project", this.columnSettings.showProject);

            if (this.metaTags != null) {
                for (var n = 0; n < this.metaTags.length; n++) {
                    var metaTag = this.metaTags[n];
                    var show = !!this.columnSettings["showMetaTag" + metaTag.id];
                    this.updateColumn(metaTag.cssClass, !!show);
                }                   
            }           
        },          

        fooFormatter : function(field, dataObject) {
            // TODO
        },

        renderActionCell : function(planningNotificationInfo, data, cell) {
            var buttonDiv = domConstruct.create("div", null, null);

            if (this.mode == PlanningNotificationListWidget.Mode.DEFAULT) {
                // Only allow editing for planning notifications created by us.
                // Sharepoint notifications have type 1, our notifications have type 0, but in former times, also -1 was used for them.
                // So, to be safe, make everything <= 0 editable.           
                if ("editPlanningNotification" in planningNotificationInfo.allowedProjectActions) {
                    var editButton = this.constructEditButton(planningNotificationInfo);
                    domConstruct.place(editButton.domNode, buttonDiv);
                }


                var planningNotification = planningNotificationInfo.planningNotification;
                var path = planningNotification.path != null ? planningNotification.path : "";
                if ("editPlanningNotification" in planningNotificationInfo.allowedProjectActions
                    && "downloadPlanningNotification" in planningNotificationInfo.allowedProjectActions
                    && path != null && path.lastIndexOf(".pdf") == path.length - 4) {
                    var extractButton = this.constructExtractButton(planningNotificationInfo);
                    domConstruct.place(extractButton.domNode, buttonDiv);
                }               

                if ("editPlanningNotificationOrder" in planningNotificationInfo.allowedProjectActions) {
                    var newOrderButton = this.constructNewOrderButton(planningNotificationInfo);
                    domConstruct.place(newOrderButton.domNode, buttonDiv);
                }

                if ("editPlanningNotification" in planningNotificationInfo.allowedProjectActions) {
                    var csvImportButton = this.constructCsvImportButton(planningNotificationInfo);
                    domConstruct.place(csvImportButton.domNode, buttonDiv);
                }           

                if ("deletePlanningNotification" in planningNotificationInfo.allowedProjectActions) {
                    var deleteButton = this.constructDeleteButton(planningNotificationInfo);
                    domConstruct.place(deleteButton.domNode, buttonDiv);
                }           
            } else if (this.mode == PlanningNotificationListWidget.Mode.SHAREPOINT) {
                if (true) {//"downloadPlanningNotification" in planningNotificationInfo.allowedProjectActions) {
                    var showFromSharepointButton = this.constructShowFromSharepointButton(planningNotificationInfo);
                    domConstruct.place(showFromSharepointButton.domNode, buttonDiv);
                }                   

                var planningNotification = planningNotificationInfo.planningNotification;
                var sharepointLink = planningNotification.sharepointLink != null ? planningNotification.sharepointLink : "";            
                if (sharepointLink != null && sharepointLink.lastIndexOf(".pdf") == sharepointLink.length - 4) {
                    var importFromSharepointButton = this.constructImportFromSharepointButton(planningNotificationInfo);
                    domConstruct.place(importFromSharepointButton.domNode, buttonDiv);
                }                       
            } else {
                throw new Error("Illegal mode [" + this.mode + "]");
            }           

            return buttonDiv;
        },

        renderFileCell : function(planningNotificationInfo, data, cell) {
            var buttonDiv = domConstruct.create("div", null, null);

            if (this.mode == PlanningNotificationListWidget.Mode.SHAREPOINT) {
                var downloadButton = this.constructDownloadFromMspButton(planningNotificationInfo);
                domConstruct.place(downloadButton.domNode, buttonDiv);
            } else if ("downloadPlanningNotification" in planningNotificationInfo.allowedProjectActions) {
                var planningNotification = planningNotificationInfo.planningNotification;
                if (planningNotification.type == CdesVoc.PlanningNotificationType.REFERENCED) {
                    if (planningNotification.sharepointLink != null) {
                        var downloadFromMspButton = this.constructDownloadFromMspButton(planningNotificationInfo);
                        domConstruct.place(downloadFromMspButton.domNode, buttonDiv);
                    }                        
                    if (planningNotification.path != null) {
                        var downloadFromFileButton = this.constructDownloadFromFileButton(planningNotificationInfo);
                        domConstruct.place(downloadFromFileButton.domNode, buttonDiv);
                    }                        
                } else { //if (planningNotification.type == CdesVoc.PlanningNotificationType.UPLOADED) {
                    if (planningNotification.path != null) {
	                    var downloadFromFileButtonTwo = this.constructDownloadFromFileButton(planningNotificationInfo);
	                    domConstruct.place(downloadFromFileButtonTwo.domNode, buttonDiv);
                    }
                }                            
                
            }                        

            return buttonDiv;       
        },          

        constructEditButton : function(planningNotificationInfo) {
            var button = new FancyButton({
                    title : i18n.planningNotificationListEditToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 editButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function() {
                this.applicationContext.setPage("planningNotificationEdit",
                    { mode : ContentWidget.Mode.EDIT, id : planningNotificationInfo.planningNotification.id },
                    { backPage : this.backPage, backParams : this.backParams });
            }));
            return button;
        },

        constructExtractButton : function(planningNotificationInfo) {
            var button = new FancyButton({
                    title : i18n.planningNotificationListExtractToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 adoptButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function() {
                this.applicationContext.setPage("planningNotificationOrderExtract",
                    { id : planningNotificationInfo.planningNotification.id },
                    { backPage : this.backPage, backParams : this.backParams });
            }));
            return button;
        },

        constructShowFromSharepointButton : function(planningNotificationInfo) {
            var button = new FancyButton({
                    title : i18n.planningNotificationListShowFromSharepointToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 downloadIcon"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function() {
                window.open(planningNotificationInfo.planningNotification.path);
            }));
            return button;
        },

        constructImportFromSharepointButton : function(planningNotificationInfo) {
            var button = new FancyButton({
                    title : i18n.planningNotificationListImportFromSharepointToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 importFromSharepointButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function() {
                // Fetch the projectId selected in the search widget before this page was opened
                // from local storage, instead of trying to propagate it through the widgets.                       
                var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
                var networkId = this.applicationContext.getPageContextPnNetworkId();
                var searchModel = this.applicationContext.getFromLocalStorage([organisationPersonId, networkId], "/planningNotification/search");
                this.applicationContext.setPage("planningNotificationEdit",
                    { mode : ContentWidget.Mode.CREATE, sharepoint : true },
                    {
                                              saveBackPage : "planningNotificationSharepointImport",
                                            saveBackParams : new Object(),
                                                  backPage : "planningNotificationList",
                                                backParams : new Object(),                                                
                                             abortBackPage : "planningNotificationSharepointImport",
                                           abortBackParams : new Object(),                                                
                        sharepointPlanningNotificationInfo : planningNotificationInfo,
                                                 projectId : searchModel.projectId
                    });
            }));
            return button;
        },

        constructNewOrderButton : function(planningNotificationInfo) {
            var button = new FancyButton({
                    title : i18n.planningNotificationListNewOrderToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 newButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function() {
                this.applicationContext.setPage("planningNotificationOrderEdit",
                    { mode : ContentWidget.Mode.CREATE, initialProjectId : null, initialPlanningNotificationId : planningNotificationInfo.planningNotification.id, mayChangePlanningNotification : false },
                    { backPage : this.backPage, backParams : this.backParams });
            }));
            return button;
        },

        constructCsvImportButton : function(planningNotificationInfo) {
            var button = new FancyButton({
                    title : i18n.planningNotificationListCsvImportToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 importCSVButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function() {
                this.importFromCsv(planningNotificationInfo);   
            }));                

            return button;          
        },

        constructDeleteButton : function(planningNotificationInfo) {
            var button = new FancyButton({
                    title : i18n.planningNotificationListDeleteOrderToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 deleteButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function() {
                this.askDeletePlanningNotification(planningNotificationInfo);
            }));
            return button;            
        },

        constructDownloadFromMspButton : function(planningNotificationInfo) {
            var planningNotification = planningNotificationInfo.planningNotification;
            var button = new FancyButton({
                    title : i18n.planningNotificationListDownloadFromSharePointToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 downloadSharepointButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function() {
                var planningNotification = planningNotificationInfo.planningNotification;
                window.open(planningNotification.sharepointLink);
            }));
            
            return button;            
        },

        constructDownloadFromFileButton : function(planningNotificationInfo) {
            var planningNotification = planningNotificationInfo.planningNotification;

            var button = new FancyButton({
                    title : i18n.planningNotificationListDownloadToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 previewPdfButton"
            });
            
            domClass.add(button.domNode, "listButton");
            
            on(button, "click", lang.hitch(this, function() {
                var planningNotification = planningNotificationInfo.planningNotification;
                var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
                window.open("/cdes-dojo-impl/repositoryDownload/planning/" + organisationPersonId + "/" + planningNotification.id);
            }));
            
            return button;            
        },

        importFromCsv : function(planningNotificationInfo) {
            this.applicationContext.setPage("planningNotificationOrderImport",
                { planningNotificationId : planningNotificationInfo.planningNotification.id },
                { backPage : this.backPage, backParams : this.backParams });

            /*
            var editDialog = new EditDialog({
                contentWidget : new PlanningNotificationOrderImportWidget({
                        applicationContext : this.applicationContext,
                                  backPage : this.backPage,
                                backParams : this.backParams,
                    planningNotificationId : planningNotificationInfo.planningNotification.id
                }),
                defaultWidth  : 500,  // Should be in sync with corresponding rules in CSS
                defaultHeight : 150,
                        title : i18n.planningNotificationListImportCsvCaption,
                      buttons : [ { type : ClazzesVoc.Button.SAVE, label : i18n.importButtonCaption, title : i18n.planningNotificationListImportButtonToolTip },
                          { type : ClazzesVoc.Button.ABORT, title : i18n.abortButtonCaption } ]
            });
            editDialog.setData({
                planningNotificationInfo : planningNotificationInfo
            });
            editDialog.show();                        
            */
        },

        askDeletePlanningNotification : function(planningNotificationInfo) {
            var message = string.substitute(i18n.planningNotificationListAskDeleteDialogQuestion, {
                title : planningNotificationInfo.planningNotification.title
            });

            InfoDialog.showQuestion({
                  title : i18n.planningNotificationListAskDeleteDialogCaption,
                message : message,
                buttons : [
                    { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
                        this.deletePlanningNotificationOrder(planningNotificationInfo);
                    })},                                   
                    { type : InfoDialog.Button.NO }
                ]
            });                 
        },

        deletePlanningNotificationOrder : function(planningNotificationInfo) {
            var planningNotificationService = this.applicationContext.getService("planningNotificationService");
            this.registerAsyncOperationStarted(PlanningNotificationListWidget.AsyncOperation.DELETE);

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            planningNotificationService.deletePlanningNotification(organisationPersonId, planningNotificationInfo.planningNotification.id).then(
                lang.hitch(this, function() {
                    this.registerAsyncOperationFinished(PlanningNotificationListWidget.AsyncOperation.DELETE);

                    topic.publish("message/ok", i18n.planningNotificationListDeleteSuccess);

                    on.emit(this, "doSearch");
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : PlanningNotificationListWidget.AsyncOperation.DELETE,
                                opName : "deletePlanningNotification",
                               message : i18n.planningNotificationListDeleteFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [deletePlanningNotification]", err);
                    }));
        },      

        constructTopDiv : function() {
            var grid = this.constructGrid({
                idProperty : "_planningNotificationId", 
                    gridId : "PlanningNotificationListWidgetGrid"
            });

            on(grid, "dgrid-sort", lang.hitch(this, function(e) {
                var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
                var networkId = this.applicationContext.getPageContextPnNetworkId();
                this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotification/sort", e.sort);
            }));

            return grid;
        },

        resize : function(newSize) {
            this.grid.resize(newSize);
        },

        setData : function(params) {
            this.planningNotificationInfos = params.planningNotificationInfos;
            this.updateAuxiliaryData();

            var columns = this.grid.get("columns");

            if (params.columnSettings) {
                this.setColumnSettings(params.columnSettings);
            }

            this.reload();
        },

        updateAuxiliaryData : function() {
            for (var n = 0; n < this.planningNotificationInfos.length; n++) {
                var planningNotificationInfo = this.planningNotificationInfos[n];
                PlanningNotificationListHelper.updatePlanningNotificationAuxiliaryData(planningNotificationInfo, this.applicationContext);
            }
        },

        columnWidthKey : "planningNotification/columnWidths",

        getLocalStorageContextKeys : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextPnNetworkId();
            return [organisationPersonId, networkId];
        },        

        reload : function(params) {

            this.updateColumns();

            this.store.setData(this.planningNotificationInfos);

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextPnNetworkId();
            var oldSort = this.applicationContext.getFromLocalStorage([organisationPersonId, networkId], "/planningNotification/sort");

            if (oldSort == null) {
                this.grid.set("sort", "_planningNotificationTitle", false);
                this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotification/sort", this.grid.get("sort"));
            } else {
                this.grid.set("sort", oldSort);
            }           

            this.grid.updateSortArrow(this.grid.sort);
            this.grid.refresh();
        },

        initialize : function(metaTags) {
            if (metaTags != null) {
                this.metaTags = metaTags;           
                var columns = this.constructColumns();
                this.grid.set("columns", columns);          
            }
        },          

        destroy : function() {
            this.inherited(arguments);
        }
    });

    PlanningNotificationListWidget.AsyncOperation = {

    };

    PlanningNotificationListWidget.Mode = {
        DEFAULT : "Default",
        DELETE : "Delete",
        SHAREPOINT : "Sharepoint"        
    };        

    return PlanningNotificationListWidget;
});
