/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

////css-prefix = planningNotificationOrderList
////i18n-prefix = planningNotificationOrderList

define([
    "cdes/planning/util/PlanningNotificationHelper",
    "cdes/planning/util/PlanningNotificationListHelper",
    "cdes/util/ActionHelper",
    "cdes/util/CodeHelper",
    "cdes/util/ColumnHelper",
    "cdes/util/NameHelper",
    "cdes/widget/base/ListWidget",
    "clazzes/TinyLog",
    "clazzes/dateTime/DateHelper",
    "clazzes/form/FancyButton",
    "clazzes/topic",
    "clazzes/util/DOMHelper",
    "clazzes/util/ErrorHelper",
    "clazzes/widgets/layout/ContentWidget",
    "clazzes/widgets/layout/InfoDialog",
    "dgrid/OnDemandGrid",
    "dgrid/extensions/ColumnResizer",
    "dgrid/extensions/DijitRegistry",
    "dojo/aspect",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/io-query",
    "dojo/on",
    "dojo/string",
    "dstore/Memory",
    "dstore/Trackable",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(
    PlanningNotificationHelper,
    PlanningNotificationListHelper,
    ActionHelper,
    CodeHelper,
    ColumnHelper,
    NameHelper,
    ListWidget,
    TinyLog,
    DateHelper,
    FancyButton,
    topic,
    DOMHelper,
    ErrorHelper,
    ContentWidget,
    InfoDialog,
    OnDemandGrid,
    ColumnResizer,
    DijitRegistry,
    aspect,
    domClass,
    domConstruct,
    declare,
    lang,
    ioQuery,
    on,
    string,
    Memory,
    Trackable,
    i18n) {

    var className = "at.cdes.web.planning.order.PlanningNotificationOrderListWidget";

    var log = new TinyLog(className);

    var PlanningNotificationOrderListWidget = declare(className, ListWidget, {

        dataAttributeName : "orderJoins",

        constructor : function(params) {
            lang.mixin(this, params);

            if (this.sortStorageKey == null) {
                this.sortStorageKey = "/planningNotificationOrder/sort";
            }                       

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "PlanningNotificationOrderListWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        columnWidthKey : "planningNotificationOrder/columnWidths",
        defaultColumnWidth : 130,

        columnIdToDefaultWidth : {
                       serialNumber : 70,
                               text : 350, //
               planningNotification : 200, //
                            project : 120,
                        subjectArea : 130, //
                authorizedInspector : 160, //
                          reference : 100, //
                      statutoryDuty : 130,
                        invalidated : 70,
                       workflowNode : 150, //
                              state : 100,
                       documentPage : 80,
                   documentPosition : 200,
                             source : 130, //
                     personInCharge : 280, //
                  statutoryDutyFrom : 120, //
                    statutoryDutyTo : 120, //
              statutoryDutyInterval : 200,
              statutoryDutyLeadTime : 120,
                           siteType : 100, //
               statutoryDutyExpired : 120, //
                    submitAuthority : 110, //
                                tag : 130, //
                       orderComment : 150, //
            environmentallyRelevant : 140, //
                            actions : 80            
        },            

        getLocalStorageContextKeys : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextPnNetworkId();
            return [organisationPersonId, networkId];
        },        

        constructColumns : function() {
            var columns = [];

            PlanningNotificationListHelper.pushAllPlanningNotificationOrderColumns(columns, this, this.documentCaption);

            if (this.showActions) {
                columns.push({
                         field : "planningNotificationOrderWorkflowEntityId",
                            id : "actions",
                    renderCell : lang.hitch(this, this.renderActionCell),
                      sortable : false,
                         label : i18n.actionColumnCaption
                });
            }

            return columns;
        },

        renderReferenceCell : function(orderJoin, data, cell) {
            return PlanningNotificationHelper.renderReferenceCell(orderJoin.referenceInfos, this, this.referenceDestination);
        },              

        renderActionCell : function(orderJoin, data, cell) {
            var buttonDiv = domConstruct.create("div", null, null);

            if ("editPlanningNotificationOrder" in orderJoin.allowedProjectActions) {
                var editButton = this.constructEditButton(orderJoin);
                domConstruct.place(editButton.domNode, buttonDiv);
            }

            if ("editPlanningNotificationOrder" in orderJoin.allowedProjectActions) {
                var defineWorkflowButton = this.constructDefineWorkflowButton(orderJoin);
                domConstruct.place(defineWorkflowButton.domNode, buttonDiv);
            }

            if ("planningNotificationOverview" in orderJoin.allowedProjectActions) {
                var reviewProtocolButton = this.constructReviewProtocolButton(orderJoin);
                domConstruct.place(reviewProtocolButton.domNode, buttonDiv);
            }

            if ("deletePlanningNotification" in orderJoin.allowedProjectActions && !orderJoin.workflowInitialized) {
                var deleteButton = this.constructDeleteButton(orderJoin);
                domConstruct.place(deleteButton.domNode, buttonDiv);
            }

            if (this.mode == PlanningNotificationOrderListWidget.Mode.CHOOSE_REFERENCE) {
                var removeButton = this.constructRemoveButton(orderJoin);
                domConstruct.place(removeButton.domNode, buttonDiv);
            }                       

            return buttonDiv;
        },

        constructReviewProtocolButton : function(orderJoin) {
            var button = new FancyButton({
                    title : i18n.planningNotificationTaskListReviewProtocolToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 reviewProtocolButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function(e) {
                // e.ctrlKey
                /*
                PlanningNotificationHelper.openReviewProtocolInDialog({
                      workflowEntityId : orderJoin.planningNotificationOrderWorkflowEntityId,
                    applicationContext : this.applicationContext                
                });                 
                */
                var sortedDataPromise = this.getSortedData();
                sortedDataPromise.then(lang.hitch(this, function(sortedData) {

                    if (e.ctrlKey) {
                        var workflowEntityIdString = "";
                        for (var n = 0; n < sortedData.length; n++) {
                            workflowEntityIdString += (n > 0 ? "," : "") + sortedData[n].workflowEntityId.toString();
                        }

                        var paramsObject = {
                            ts : dojoConfig.tabSessionId
                        };
                        var hashObject = {                            
                            page : "workflowReviewProtocol",
                              id : orderJoin.planningNotificationOrderWorkflowEntityId
                        };
                        var paramsString = ioQuery.objectToQuery(paramsObject);
                        var hashString = ioQuery.objectToQuery(hashObject);                            
                        var newWindow = window.open("/cdes/frame.html?" + paramsString + "#" + hashString);
                        newWindow.addEventListener("load", lang.hitch(this, function() {
                            var hiddenField = newWindow.document.createElement("input");
                            hiddenField.setAttribute("type", "hidden");
                            hiddenField.setAttribute("name", "workflowEntityIds");
                            hiddenField.setAttribute("value", workflowEntityIdString);
                            newWindow.document.body.appendChild(hiddenField);
                        }));
                    } else {
                        var workflowEntityIds = [];
                        for (var n = 0; n < sortedData.length; n++) {
                            workflowEntityIds.push(sortedData[n].workflowEntityId);
                        }

                        this.applicationContext.setPage("workflowReviewProtocol",
                                                        { id : orderJoin.planningNotificationOrderWorkflowEntityId },
                                                        {            backPage : this.backPage,
                                                                   backParams : this.backParams,
                                                            workflowEntityIds : workflowEntityIds
                                                        });
                    }                                
                }), lang.hitch(this, function(err) {
                    log.error("Error while fetching sorted data.", err);                    
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while fetching sorted data.", err);
                    }));
            }));
            return button;
        },

        constructDefineWorkflowButton : function(orderJoin) {
            var button = new FancyButton({
                    title : i18n.planningNotificationOrderListDefineWorkflowToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 defineWorkflowNodePositionButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function() {
                this.applicationContext.setPage("defineWorkflow",
                    { mode : ContentWidget.Mode.EDIT, id : orderJoin.planningNotificationOrderWorkflowEntityId },
                    { backPage : this.backPage, backParams : this.backParams });
            }));
            return button;
        },

        constructEditButton : function(orderJoin) {
            var button = new FancyButton({
                    title : i18n.planningNotificationOrderListEditToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 editButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function() {
                this.applicationContext.setPage("planningNotificationOrderEdit",
                    { mode : ContentWidget.Mode.EDIT, id : orderJoin.planningNotificationOrderWorkflowEntityId },
                    { backPage : this.backPage, backParams : this.backParams });
            }));
            return button;
        },

        constructDeleteButton : function(orderJoin) {
            var button = new FancyButton({
                    title : i18n.planningNotificationOrderListDeleteToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 deleteButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function() {
                this.askDeletePlanningNotificationOrder(orderJoin);
            }));
            return button;
        },

        askDeletePlanningNotificationOrder : function(orderJoin) {
            var message = string.substitute(i18n.planningNotificationOrderListAskDeleteDialogQuestion, {
                serialNumber : orderJoin.planningNotificationOrderSerialNumber
            });             

            InfoDialog.showQuestion({
                  title : i18n.planningNotificationOrderListAskDeleteDialogCaption,
                message : message,
                buttons : [
                    { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
                        this.deletePlanningNotificationOrder(orderJoin);
                    })},                                       
                    { type : InfoDialog.Button.NO }
                ]
            });             
        },

        deletePlanningNotificationOrder : function(orderJoin) {
            var planningNotificationService = this.applicationContext.getService("planningNotificationService");
            this.registerAsyncOperationStarted(PlanningNotificationOrderListWidget.AsyncOperation.DELETE);

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            planningNotificationService.deletePlanningNotificationOrder(organisationPersonId, orderJoin.planningNotificationOrderWorkflowEntityId).then(
                lang.hitch(this, function() {
                    this.registerAsyncOperationFinished(PlanningNotificationOrderListWidget.AsyncOperation.DELETE);

                    topic.publish("message/ok", i18n.planningNotificationOrderListDeleteSuccess);

                    on.emit(this, "doSearch");                  
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : PlanningNotificationOrderListWidget.AsyncOperation.DELETE,
                                opName : "deletePlanningNotificationOrder",
                               message : i18n.planningNotificationOrderListDeleteFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [deletePlanningNotificationOrder]", err);
                    }));
        },      

        updateIndividualColumns : function() {
            PlanningNotificationListHelper.updatePlanningNotificationOrderColumns(this, this.columnSettings);
        },

        constructRemoveButton : function(orderJoin) {
            var button = new FancyButton({
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 deleteButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, function() {
                this.askRemoveOrderJoin(orderJoin);
            }));
            return button;
        },

        askRemoveOrderJoin : function(orderJoin) {
            var message = string.substitute(i18n.planningNotificationOrderListAskRemoveDialogQuestion, {
                serialNumber : orderJoin.planningNotificationOrderSerialNumber
            });             

            InfoDialog.showQuestion({
                  title : i18n.planningNotificationOrderListAskRemoveDialogCaption,
                message : message,
                buttons : [
                    { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
                        this.removeOrderJoin(orderJoin);
                    })},                                       
                    { type : InfoDialog.Button.NO }
                ]
            });             
        },

        removeOrderJoin : function(orderJoin) {
            for (var n = 0; n < this.orderJoins.length; n++) {
                if (this.orderJoins[n].planningNotificationOrderWorkflowEntityId == orderJoin.planningNotificationOrderWorkflowEntityId) {
                    this.orderJoins.splice(n, 1);
                    break;                              
                }                                   
            }

            this.reload({
                noSort : false
            });

            on.emit(this, "planningNotificationOrderRemoved", orderJoin.planningNotificationOrderWorkflowEntityId);
        },      

        constructTopDiv : function() {
            var grid = this.constructGrid({
                   idProperty : "planningNotificationOrderWorkflowEntityId", 
                       gridId : this.gridId != null ? this.gridId : "PlanningNotificationOrderListWidgetGrid",
                     idSuffix : this.idSuffix,                       
                selectionMode : this.selectionMode                          
            });

            on(grid, "dgrid-sort", lang.hitch(this, function(e) {
                var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
                var networkId = this.applicationContext.getPageContextPnNetworkId();
                this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], this.sortStorageKey, e.sort);
            }));

            aspect.after(this.grid, "renderRow", lang.hitch(this, function(row, args) {
                var joinDto = args[0];
                this.updateRowClass(row, joinDto);
                return row;
            }));

            if (this.selectionMode != null) {
                on(grid, "dgrid-select", lang.hitch(this, this.emitSelectionChanged));
                on(grid, "dgrid-deselect", lang.hitch(this, this.emitSelectionChanged));
            }                       

            return grid;        
        },

        updateRowClass : function(domNode, joinDto) {
            domClass.remove(domNode, "planningNotificationOrderInvalidated");

            if (joinDto.workflowEntityInvalidated) {
                domClass.add(domNode, "planningNotificationOrderInvalidated");
            }
        },

        emitSelectionChanged : function() {
            var orderJoins = this.getSelectedItems();
            var orderInfos = [];
            for (var n = 0; n < orderJoins.length; n++) {
                var orderJoin = orderJoins[n];
                var orderInfo = {
                    allowedProjectActions : new Object(),
                                orderJoin : {
                                                       planningNotificationId : orderJoin.planningNotificationId,
                                                    planningNotificationTitle : orderJoin.planningNotificationTitle,
                                    planningNotificationOrderWorkflowEntityId : orderJoin.planningNotificationOrderWorkflowEntityId,
                                        planningNotificationOrderSerialNumber : orderJoin.planningNotificationOrderSerialNumber,
                                                planningNotificationOrderText : orderJoin.planningNotificationOrderText,
                                                    workflowEntityInvalidated : orderJoin.workflowEntityInvalidated
                                },
                                 projectJoins : orderJoin.projectJoins
                };

                orderInfos.push(orderInfo);                 
            }                   

            on.emit(this, "selectionChanged", orderInfos);
        },

        resize : function(newSize) {
            this.grid.resize(newSize);
        },

        setData : function(params) {
            var columnSettings = params.columnSettings;
            var noSort = params.noSort;

            // Use this code to introduce an upper bound towards the number of cells shown in the grid at once          
            // var numberOfShownColumns = columnSettings ? ColumnHelper.getNumberOfShownColumns(params.columnSettings, true) : null;
            // var gridLineLimit = numberOfShownColumns != null ? (this.applicationContext.getGridCellLimit() / numberOfShownColumns) + 1 : null;

            var planningNotificationOrderInfos = params.planningNotificationOrderInfos;
            this.orderJoins = [];
            for (var n = 0; n < planningNotificationOrderInfos.length; n++) {
                // For performance reasons: Prevent showing too many lines of data.

                /*
                if (gridLineLimit != null && n >= gridLineLimit) {
                    var details = string.substitute(i18n.gridLinesSuppressedWarningText, { 
                          totalNumberOfTuples : planningNotificationOrderInfos.length,
                        numberOfMissingTuples : planningNotificationOrderInfos.length - n,
                                gridCellLimit : this.applicationContext.getGridCellLimit()
                    });

                    topic.publish("message/warn", {
                         dialogTitle : i18n.gridLinesSuppressedWarningCaption,
                             message : details,                         
                        showInDialog : true
                    });
                    break;
                }
                */

                var orderInfo = planningNotificationOrderInfos[n];
                var orderJoin = orderInfo.orderJoin;
                if (noSort) {
                    orderJoin._artificialIndex = n;
                }                                   

                orderJoin.projectJoins = orderInfo.projectJoins ? orderInfo.projectJoins : [];
                orderJoin.referenceInfos = orderInfo.referenceInfos ? orderInfo.referenceInfos : [];
                orderJoin.baulosMetaInformations = orderInfo.baulosMetaInformations ? orderInfo.baulosMetaInformations : [];
                orderJoin.tags = orderInfo.tags ? orderInfo.tags : [];
                orderJoin.siteTypes = orderInfo.siteTypes ? orderInfo.siteTypes : [];
                orderJoin.workflowNodeJoins = orderInfo.workflowNodeJoins;
                orderJoin.workflowNodeIdToPositions = orderInfo.workflowNodeIdToPositions;
                orderJoin.workflowNodePositionIdToBaulose = orderInfo.workflowNodePositionIdToBaulose;
                orderJoin.allowedProjectActions = orderInfo.allowedProjectActions;
                orderJoin.workflowInitialized = orderInfo.workflowInitialized;
                this.orderJoins.push(orderJoin);
            }
            this.updateAuxiliaryData();

            if (columnSettings) {
                this.setColumnSettings(params.columnSettings);
            }

            this.reload({
                noSort : noSort
            });
        },

        updateAuxiliaryData : function() {
            for (var n = 0; n < this.orderJoins.length; n++) {
                var joinDto = this.orderJoins[n];
                PlanningNotificationListHelper.updatePlanningNotificationOrderAuxiliaryData(joinDto, this.applicationContext);
            }
        },

        getOrderJoins : function() {
            return this.orderJoins != null ? this.orderJoins : [];
        },

        getSerialNumberQuickSearchTokensForRow : function(orderJoin) {
            var tokens = [];

            // NOTE: Only implemented for serialNumber, text, planningNotification and projects, as we currently use
            // it only in the dialog for choosing references.               

            if (this.columnSettings.showSerialNumber) {
                tokens.push(orderJoin.planningNotificationOrderSerialNumber == null ? "" : orderJoin.planningNotificationOrderSerialNumber.toString());
            }

            return tokens;      
        },          

        getTextDocumentProjectQuickSearchTokensForRow : function(orderJoin) {
            var tokens = [];

            // NOTE: Only implemented for serialNumber, text, planningNotification and projects, as we currently use
            // it only in the dialog for choosing references.               

            if (this.columnSettings.showText) {
                tokens.push(orderJoin.planningNotificationOrderText == null ? "" : orderJoin.planningNotificationOrderText);
            }

            if (this.columnSettings.showPlanningNotification) {
                tokens.push(orderJoin._planningNotification);
            }

            if (this.columnSettings.showProject) {
                tokens.push(orderJoin._project);
            }

            return tokens;      
        },          


        reload : function(params) {
            var noSort = params.noSort;

            this.updateColumns(this.columnSettings);

            this.store.setData(this.orderJoins);
            this.grid.set("store", this.store);

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextPnNetworkId();
            var oldSort = this.applicationContext.getFromLocalStorage([organisationPersonId, networkId], this.sortStorageKey);

            if (noSort) {
                this.grid.set("sort", "_artificialIndex", false);
            } else {
                if (oldSort == null) {
                    this.grid.set("sort", "planningNotificationOrderSerialNumber", false);
                    this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], this.sortStorageKey, this.grid.get("sort"));
                } else {
                    this.grid.set("sort", oldSort);
                }               

                this.grid.updateSortArrow(this.grid.sort);
            }

            this.grid.refresh();
        },

        sort : function(column) {
            this.grid.set("sort", column, false);
            this.grid.updateSortArrow(this.grid.sort);
            this.grid.refresh();
        },

        getRowId : function(joinDto) {
            return joinDto.planningNotificationOrderWorkflowEntityId;
        },

        destroy : function() {
            this.inherited(arguments);
        }
    });

    PlanningNotificationOrderListWidget.AsyncOperation = {
        DELETE : "Delete"
    };

    PlanningNotificationOrderListWidget.Mode = {
        CHOOSE_REFERENCE : "ChooseReference"    
    };      

    return PlanningNotificationOrderListWidget;
});
