/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

define([ 
    "clazzes/TinyLog",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
], function(
    TinyLog,
    declare,
    lang,    
    i18n
) {

    var className = "at.cdes.review.ReviewProtocolContext";

    var log = new TinyLog(className);

    var ReviewProtocolContext = declare(className, null, {

        // globalActions
        // baseJoin
        // versionJoins, sorted by uploaded ascending
        // idToVersionJoin
        // documentVersionIdToCellResultIds
        // idToCellResultJoin
        // cellResultIdToNodeResultMap
        // nodeResultIdToPositionResultMap
        // idToPositionResultJoin
        // idToResultOption
        // documentVersionIdToNodePositionJoins
        // documentVersionIdToAttachedNodePositionJoins
        // documentVersionIdToCellConnectionResultJoins
        // documentVersionIdToEntryResultJoins        
        // positionResultIdToAttachments
        // nodeResultIdToOebbCommentJoins
        // showAll

        constructor : function(params) {
            lang.mixin(this, params);

            var globalActionsMap = new Object();
            for (var n = 0; n < this.globalActions.length; n++) {
                globalActionsMap[this.globalActions[n]] = true;
            }
            this.globalActions = globalActionsMap;            
        },

        hasGlobalAction : function(actionName) {
            return actionName in this.globalActions;
        },

        getBaseJoin : function() {
            return this.baseJoin;
        },

        getVersionJoins : function() {
            return this.versionJoins;
        },

        getVersionJoin : function(documentVersionId) {
            return this.idToVersionJoin[documentVersionId];
        },            

        isLastVersion : function(documentVersionId) {
            if (this.versionJoins.length == 0) {
                return false;
            }
            var lastVersionJoin = this.versionJoins[this.versionJoins.length - 1];
            var reactivatedId = lastVersionJoin.documentVersionReactivatedDocumentVersionId;
            if (reactivatedId != null) {
                lastVersionJoin = this.versionJoins[reactivatedId];
            }
            return lastVersionJoin.documentVersionId == documentVersionId;            
        },            

        getNodeResultJoinsByDocumentVersionId : function(documentVersionId) {
            var nodeResultJoins = [];
            var cellResultIds = (documentVersionId in this.documentVersionIdToCellResultIds ? this.documentVersionIdToCellResultIds[documentVersionId] : []);
            for (var n = 0; n < cellResultIds.length; n++) {
                var cellResultId = cellResultIds[n];                
                var nodeResultIdToJoin = this.cellResultIdToNodeResultMap[cellResultId];
                for (var nodeResultId in nodeResultIdToJoin) {
                    nodeResultJoins.push(nodeResultIdToJoin[nodeResultId]);
                }                    
            }
            return nodeResultJoins;            
        },

        getNodeResultJoinsByCellResultId : function(cellResultId) {
            if (cellResultId in this.cellResultIdToNodeResultMap) {
                var nodeResultIdToNodeResultJoin = this.cellResultIdToNodeResultMap[cellResultId];
                var nodeResultJoins = [];
                for (var nodeResultId in nodeResultIdToNodeResultJoin) {
                    nodeResultJoins.push(nodeResultIdToNodeResultJoin[nodeResultId]);                    
                }
                return nodeResultJoins;                
            } else {
                return [];
            }                
        },

        getCellResultIdsByDocumentVersionId : function(documentVersionId) {
            return documentVersionId in this.documentVersionIdToCellResultIds ? this.documentVersionIdToCellResultIds[documentVersionId] : [];
        },

        getPositionResultJoinsByDocumentVersionId : function(documentVersionId) {
            var positionResultJoins = [];
            var cellResultIds = this.getCellResultIdsByDocumentVersionId(documentVersionId);
            for (var n = 0; n < cellResultIds.length; n++) {
                var cellResultId = cellResultIds[n];
                var nodeResultIdToJoin = cellResultId in this.cellResultIdToNodeResultMap ? this.cellResultIdToNodeResultMap[cellResultId] : new Object();
                for (var nodeResultId in nodeResultIdToJoin) {
                    var positionResultIdToJoin = nodeResultId in this.nodeResultIdToPositionResultMap ? this.nodeResultIdToPositionResultMap[nodeResultId] : new Object();
                    for (var positionResultId in positionResultIdToJoin) {
                        positionResultJoins.push(positionResultIdToJoin[positionResultId]);
                    }                        
                }                    
            }                
            return positionResultJoins;
        },

        getPositionResultJoinsByNodeResultId : function(nodeResultId) {
            var positionResultJoins = [];
            var positionResultIdToJoin = nodeResultId in this.nodeResultIdToPositionResultMap ? this.nodeResultIdToPositionResultMap[nodeResultId] : new Object();
            for (var positionResultId in positionResultIdToJoin) {
                positionResultJoins.push(positionResultIdToJoin[positionResultId]);
            }
            return positionResultJoins;            
        },

        hasResultOptionWithPositionTypeId : function(positionTypeId) {
            for (var id in this.idToResultOption) {
                var resultOption = this.idToResultOption[id];
                if (resultOption.reviewCyclePositionTypeId == positionTypeId) {
                    return true;
                }                    
            }
            return false;            
        },            

        getResultOption : function(id) {
            return this.idToResultOption[id];
        },

        getNodePositionJoins : function(documentVersionId) {
            if (documentVersionId in this.documentVersionIdToNodePositionJoins) {
                return this.documentVersionIdToNodePositionJoins[documentVersionId];
            } else {
                return [];
            }                
        },

        getPositionResultJoin : function(positionResultId) {
            if (positionResultId in this.idToPositionResultJoin) {
                return this.idToPositionResultJoin[positionResultId];
            } else {
                return null;
            }                
        },

        getAttachedNodePositionJoins : function(documentVersionId) {
            if (documentVersionId in this.documentVersionIdToAttachedNodePositionJoins) {
                return this.documentVersionIdToAttachedNodePositionJoins[documentVersionId];
            } else {
                return [];
            }                
        },

        getPositionResultAttachments : function(positionResultId) {
            if (positionResultId in this.positionResultIdToAttachments) {
                return this.positionResultIdToAttachments[positionResultId];
            } else {
                return [];
            }                
        },            

        hasPositionResultAttachments : function(positionResultId) {
            return positionResultId in this.positionResultIdToAttachments && this.positionResultIdToAttachments[positionResultId].length > 0;
        },            

        getStatementResultJoins : function(documentVersionId) {
            var statementResultJoins = [];
            if (documentVersionId in this.documentVersionIdToCellConnectionResultJoins) {
                var cellConnectionResultJoins = this.documentVersionIdToCellConnectionResultJoins[documentVersionId];
                for (var n = 0; n < cellConnectionResultJoins.length; n++) {
                    statementResultJoins.push(cellConnectionResultJoins[n]);
                }
            }
            if (documentVersionId in this.documentVersionIdToEntryResultJoins) {
                var entryResultJoins = this.documentVersionIdToEntryResultJoins[documentVersionId];
                for (var z = 0; z < entryResultJoins.length; z++) {
                    statementResultJoins.push(entryResultJoins[z]);
                }
            }
            return statementResultJoins;            
        },

        hasOebbComments : function(nodeResultId) {
            return nodeResultId in this.nodeResultIdToOebbCommentJoins && this.nodeResultIdToOebbCommentJoins[nodeResultId].length > 0;            
        },

        getOebbComments : function(nodeResultId) {
            if (nodeResultId in this.nodeResultIdToOebbCommentJoins) {
                return this.nodeResultIdToOebbCommentJoins[nodeResultId];
            } else {
                return [];
            }                
        },

        doShowAll : function() {
            return this.showAll;
        }            
    });

    return ReviewProtocolContext;
});
