/*
 * $Id: ValueEditDialog.js 1321 2013-06-25 16:29:25Z mda $
 *
 * Copyright (C) 2016 ev-i IT GmbH
 */

define([
        "clazzes/TinyLog",
        "clazzes/topic",
        "clazzes/util/DOMHelper",
        "clazzes/widgets/layout/ChooseDialog",
        "dgrid/OnDemandGrid",
        "dgrid/Selection",
        "dgrid/extensions/DijitRegistry",
        "dgrid/util/misc",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/on",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dstore/Memory",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
        ],
        function(
        		 TinyLog,
        		 topic,
        		 DOMHelper,
        		 ChooseDialog,
        		 OnDemandGrid,
        		 Selection,
        		 DijitRegistry,
        		 DGridUtilMisc,
        		 domClass,
        		 domConstruct,
        		 on,
        		 declare,
        		 lang,
        		 Memory,
        		 i18n
        ) {

	var className = "at.cdes.web.certificate.CertificateInviteChooseDialog";

	var log = new TinyLog(className);

	var CertificateInviteChooseDialog = declare(className, ChooseDialog, {
		
		constructChooseWidget : function() {
			// summary:
			//     Constructs the widget in which the user chooses some piece of data.
			// description:
			//     That widget must be saved in the variable this.content, and will 
			//     subsequently be placed in the dialog by superclass code.
			//     If some value is chosen by the user in that widget (e.g. a choosable 
			//     tree node is clicked), the subclass must call setChosenValue.  
			//     Optionally, after doing so, the subclass may emit the valueChosen 
			//     event, and close the dialog (e.g. on a double click into the tree).
			
			this.content = domConstruct.create("div", null, null);
			domClass.add(this.content, "certificateInviteChooseContent");
	           
			DOMHelper.createTextNode("div", i18n.certificateInviteNetworkColumnCaption, this.content, null);
			
    		var columns = this.constructColumns();
    		this.store = new Memory({data : [], idProperty : "id"});
    		
    		var MyGrid = declare([OnDemandGrid, DijitRegistry, Selection]);
    		this.grid = new MyGrid({
    			         collection : this.store,
    			            columns : columns,
    			            selectionMode : "single"
    		});
    		
    		this.grid.startup();
    		domConstruct.place(this.grid.domNode, this.content);
    		
    		on(this.grid, "dgrid-select", lang.hitch(this, this.updateWidgetState));
    		on(this.grid, "dgrid-deselect", lang.hitch(this, this.updateWidgetState));
    		
    		this.grid.resize({ h : 350 });
    		
            this.grid.afterResizeMouseUp = lang.hitch(this, this.handleColumnResize);                 		
    		
    		var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
    		
    		var certificateService = this.applicationContext.getService("certificateService");
    		var deferred = certificateService.getNetworksForInvitation(organisationPersonId);
    		deferred.then(lang.hitch(this, function(networks) {
    			
	            networks.sort(function(networkOne, networkTwo) {
	                var nameOne = networkOne.name != null ? networkOne.name : "";
	                var nameTwo = networkTwo.name != null ? networkTwo.name : "";
	                return nameOne.localeCompare(nameTwo);
	            });
	    		this.store.setData(networks);
	    		this.grid.refresh();
    			
				delete deferred;
    		}),
   			lang.hitch(this, function(err) {    			
				delete deferred;
				
				topic.publish("message/error", {
				     message : i18n.certificateInviteFetchNetworksFailed,
				showInDialog : true
				});							
			})
    		).otherwise(lang.hitch(this, function(err) {
    			log.error("Error while processing the results of calling getNetworksForInvitation: ", err);
    		}));    		
		},
		
    	constructColumns : function() {
    		var columns = [];
    		
    		columns.push({
    				field : "name",
    				   id : "name",
    		     sortable : true,
    		        label : i18n.networkColumnCaption
    		});
    		
    		return columns;
    	},
		
		emitValueChosen : function(buttonName) {
			var selectedNetwork = this.getSelectedNetwork();
			if (selectedNetwork != null) {
				on.emit(this, "valueChosen", { networkId : selectedNetwork.id, buttonName : buttonName });	
			}			
		},
		
		updateWidgetState : function() {
			var selectedNetwork = this.getSelectedNetwork();

			this.allPerMailButton.set("disabled", selectedNetwork == null);
		},
		
    	getSelectedNetwork : function() {
    		// Assumption : Single selection
    		var selection = this.grid.selection;
    		for (var id in selection) {
    			if (selection[id]) {
    				return this.grid.row(id).data;
    			}
    		}
    		return null;
    	},		
	});
	
	CertificateInviteChooseDialog.AsyncOperation = {
		GET_NETWORKS : "GetNetworks"	
	};
	
	return CertificateInviteChooseDialog;
});