/* Copyright (C) 2022 ev-i Informationstechnologie GmbH */

define([
    "clazzes/LoginGuardRpcService",
    "clazzes/TinyLog",
    "clazzes/util/DOMHelper",
    "clazzes/util/ErrorHelper",
    "clazzes/util/JobHelper",
    "clazzes/util/WidgetHelper",
    "clazzes/util/StringHelper",
    "clazzes/widgets/layout/ContentWidget",
    "clazzes/widgets/layout/InfoDialog",
    "cdes/util/PasswordValidator",
    "dijit/form/Button",
    "dijit/form/TextBox",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/io-query",
    "dojo/on",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/string",
    //        "dojo/text!/cdes/svc/adminService?smd",
    //        "dojo/text!/cdes-dojo-impl/jobStatus?smd",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
],
       function(
    	   LoginGuardRpcService,
    	   TinyLog,
    	   DOMHelper,
           ErrorHelper,
           JobHelper,
           WidgetHelper,
           StringHelper,
    	   ContentWidget,
    	   InfoDialog,
           PasswordValidator,
    	   Button,
	   	   TextBox,
    	   domClass,
    	   domConstruct,
    	   domStyle,
           ioQuery,
    	   on,
    	   declare,
    	   lang,
           string,
	   //    		 adminServiceSmd,
	   //    		 jobStatusServiceSmd,
    	   i18n
       ) {

	   var className = "at.cdes.web.certificate.RequestUserPolicyPage";

	   var log = new TinyLog(className);

	   var RequestUserPolicyPage = declare(className, ContentWidget, {

    	   constructor : function(params) {
    		   lang.mixin(this,params);

    		   this.topDiv = this.constructTopDiv();
    	   },

    	   getWidgetId : function() {
    		   return "RequestUserPolicyPage";
   	   },

    	   getDataId : function() {
    		   return null;
    	   },

    	   getContainer : function() {
    		   return this.topDiv;
    	   },

    	   constructTopDiv : function() {
    		   var topDiv = domConstruct.create("div", null, null);
               topDiv.classList.add("requestUserPolicyPageTopDiv");

	           // IntroText
	           DOMHelper.createTextNode("h4", i18n.requestUserPolicyWarning, topDiv, null);

			   this.inputsDiv = domConstruct.create("div", null, null);
               domConstruct.place(this.inputsDiv, topDiv);

	           // Details Text
	           this.detailText = DOMHelper.createTextNode("div", null, this.inputsDiv, null);
	           DOMHelper.createTextNode("p", "", this.inputsDiv, null);
	           this.linkText = DOMHelper.createTextNode("div", null, this.inputsDiv, null);

               this.applicationContext.getService("resetPasswordService").getUserPolicyInfo(this.applicationContext.getPageContextPersonId()).then(lang.hitch(this, function (info) {
                       this.userPolicyDeadline = info.userPolicyDeadline;
                       this.userPolicyVersion = info.userPolicyVersion;
                       this.orgPersonIds = info.orgPersonIds;
                       this.updateWidgetState();
               }));

	           // download link
               this.userPolicyLink = domConstruct.create("a", {
                   textContent: i18n.requestUserPolicyUserPolicyLink,
                   href: "/cdes/svc/userPolicy?sp=L"+this.applicationContext.getPageContextOrganisationPersonId()
               }, this.inputsDiv);
			   
	           var buttonDiv = DOMHelper.createTextNode("div", "", this.inputsDiv, null);
               this.closeButton = new Button({
                   onClick: lang.hitch(this, function() {
                       document.dispatchEvent(new CustomEvent("close"));
                   }),
                   label: i18n.closeButtonCaption,
                   "class": "requestUserPolicyButton"
               });
		       domConstruct.place(this.closeButton.domNode, buttonDiv);


    		   return topDiv;
    	   },

    	   updateWidgetState : function() {

			   var detailText = string.substitute(i18n.requestUserPolicyText, {
            		 userPolicyDeadline : !StringHelper.isEmpty(this.userPolicyDeadline) ? this.userPolicyDeadline : ""
	           });
			   var multipleLinkLabel = string.substitute(i18n.requestUserPolicyMultipleLinkLabel, {
	            		 count : this.orgPersonIds != null?this.orgPersonIds.length:0
	           });
		
			   DOMHelper.setInnerText(this.detailText, detailText);
			   DOMHelper.setInnerText(this.linkText, (this.orgPersonIds != null && this.orgPersonIds.length>1)?multipleLinkLabel:i18n.requestUserPolicyLinkLabel);
			   
               if (this.orgPersonIds != null){
			   	   var hrefText = "/cdes/svc/userPolicy?";
				   for (var i=0; i<this.orgPersonIds.length; i++) {
						hrefText += "sp=L" + this.orgPersonIds[i] + (this.orgPersonIds.length>i+1?"&":"");
			   	   }
			   	   this.userPolicyLink.setAttribute("href", hrefText);
			   }
    	   },

    	   resize : function(newSize) {
		       // Account for margin = 8 of body
		       domStyle.set(this.topDiv, "width", (newSize.w - 16) + "px");
		       domStyle.set(this.topDiv, "height", (newSize.h - 16 - 4) + "px");
	       }
    });

	   return RequestUserPolicyPage;
});
