/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

////css-prefix = planningNotificationPage
////i18n-prefix = planningNotificationPage

define([     "cdes/core/CdesVoc",
        "cdes/planning/notification/PlanningNotificationColumnWidget",
	"cdes/planning/notification/PlanningNotificationListWidget",
	"cdes/planning/notification/PlanningNotificationSearchWidget",
	"cdes/planning/util/PlanningNotificationHelper",
	"cdes/util/ColumnHelper",
	"cdes/util/JobHelper",
	"cdes/widget/ContextBar",
	"clazzes/TinyLog",
	"clazzes/dateTime/DateHelper",
	"clazzes/form/FancyButton",
	"clazzes/topic",
	"clazzes/util/DOMHelper",
	"clazzes/util/ErrorHelper",
	"clazzes/widgets/layout/ContentWidget",
	"dijit/form/Button",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-style",
	"dojo/io-query",
	"dojo/on",	 
	"dojo/string",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
	function(
                 CdesVoc,
                 PlanningNotificationColumnWidget,
			PlanningNotificationListWidget,
			PlanningNotificationSearchWidget,
			PlanningNotificationHelper,
			ColumnHelper,
			JobHelper,
			ContextBar,
			TinyLog,
			DateHelper,
			FancyButton,
			topic,
			DOMHelper,
			ErrorHelper,
			ContentWidget,
			Button,
			domClass,
			domConstruct,
			domStyle,
			ioQuery,
			on,
			string,		
			declare,
			lang,
			i18n) {

	var className = "at.cdes.web.planning.notification.PlanningNotificationPage";

	var log = new TinyLog(className);

	var PlanningNotificationPage = declare(className, ContentWidget, {

		constructor : function(params) {
			// Remaining TODOs:
			// - search by enter
			// - disabling while async operations are running
			// - input validation
			// - sorting in grid
			// - tab order
			// - search / column widget heights (compare PlanningNotificationOrderPage)

			lang.mixin(this, params);

			this.topDiv = this.constructTopDiv();

			this.reloadSearchInfo(true);

			this.allFieldsValid = true;
		},

		getWidgetId : function() {
			return "PlanningNotificationPage";
		},

		getDataId : function() {
			return null;
		},

		getContainer : function() {
			return this.topDiv;
		},

		constructTopDiv : function() {
			var topDiv = domConstruct.create("div", null, null);

			// Caption Bar
			this.captionBarDiv = this.constructCaptionBar();
			domClass.add(this.captionBarDiv, "cdesGeneralPageCaptionBar");
			domConstruct.place(this.captionBarDiv, topDiv);

			// Search Widget
			this.searchWidget = new PlanningNotificationSearchWidget({
				applicationContext : this.applicationContext
			});
			this.searchWidgetDiv = this.searchWidget.getContainer();
			domConstruct.place(this.searchWidgetDiv, topDiv);
			on(this.searchWidget, "titlePaneToggled", lang.hitch(this, this.resize));    		
			on(this.searchWidget, "doSearch", lang.hitch(this, this.reload));

			// Column Widget
			this.columnWidget = new PlanningNotificationColumnWidget({
				applicationContext : this.applicationContext,
				mode : PlanningNotificationColumnWidget.Mode.DEFAULT,
				localStoragePath : "planningNotification/columns"
			});
			this.columnWidgetDiv = this.columnWidget.getContainer();
			domConstruct.place(this.columnWidgetDiv, topDiv);
			on(this.columnWidget, "titlePaneToggled", lang.hitch(this, this.resize));
			on(this.columnWidget, "columnsChanged", lang.hitch(this, this.processColumnsChanged));

			// List Widget
			this.listWidget = new PlanningNotificationListWidget({
				applicationContext : this.applicationContext,
				backPage : "planningNotificationList",
				backParams : new Object(),
				mode : PlanningNotificationListWidget.Mode.DEFAULT
			});
			this.listWidgetDiv = this.listWidget.getContainer();
			domConstruct.place(this.listWidgetDiv, topDiv);

			topic.subscribe("context/change", lang.hitch(this, function() {
				var networkId = this.applicationContext.getPageContextPnNetworkId();
				if (this.lastPageContextPnNetworkId != null && this.lastPageContextPnNetworkId != networkId) {
					this.searchWidget.clearSearchFields();

					var searchModel = this.searchWidget.getSearchModel();
					var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
					searchModel.timestamp = DateHelper.getCurrentTimeSeconds();

					this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotification/search", searchModel);            
				}

				this.lastPageContextPnNetworkId = networkId;
				this.reloadSearchInfo(false);
			}));			    

			// Reload data after certain operations which change state have been performed
			on(this.listWidget, "doSearch", lang.hitch(this, this.reload));

			return topDiv;
		},

		getColumnWidget : function() {
			return this.columnWidget;	    
		},	    

		constructCaptionBar : function() {
			var captionBarDiv = domConstruct.create("div", null, null);

			// Caption
			this.captionDiv = DOMHelper.createTextNode("h1", i18n.planningNotificationPageCaption, captionBarDiv, "cdesGeneralPageCaption");

			this.constructExportToPdfButton(captionBarDiv);
			this.newSharepointButton = this.constructNewSharepointButton(captionBarDiv);
			domClass.add(this.newSharepointButton.domNode, "hidden");
			this.newButton = this.constructNewButton(captionBarDiv);
			domClass.add(this.newButton.domNode, "hidden");

			return captionBarDiv;
		},

		constructExportToPdfButton : function(captionBarDiv) {
			var button = new FancyButton({
				title : i18n.planningNotificationExportToPdfButtonToolTip,
				iconClass : "fancyButtonIcon17x18 fancyButton17x18 exportToPdfButton"
			});

			domClass.add(button.domNode, "listButton");

			on(button, "click", lang.hitch(this, this.exportToPdf));

			domConstruct.place(button.domNode, captionBarDiv);	    

			return button;
		},	    
		/*
// This would be the icon variant of the button
	constructNewButton : function(captionBarDiv) {
       	    var button = new FancyButton({
		    title : i18n.planningNotificationNewButtonToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 addButton"
       	    });

	    domClass.add(button.domNode, "listButton planningNotificationNewButton");

	    on(button, "click", lang.hitch(this, function() {
     		this.applicationContext.setPage("planningNotificationEdit",
						{ mode : ContentWidget.Mode.CREATE },
						{ backPage : "planningNotificationList", backParams : new Object() });
	    }));

	    domConstruct.place(button.domNode, captionBarDiv);	    

	    return button;
	},	    
		 */
		constructNewButton : function(captionBarDiv) {
			// Save button
			var button = new Button({
				label : i18n.planningNotificationNewButtonCaption,
				title : i18n.planningNotificationNewButtonToolTip
			});
			domClass.add(button.domNode, "planningNotificationNewButton");
			domConstruct.place(button.domNode, captionBarDiv);

			on(button, "click", lang.hitch(this, function() {
				var selectedProjectId = this.searchWidget.getSelectedProjectId();

				var params = { mode : ContentWidget.Mode.CREATE };
				if (selectedProjectId != null) {
					params.projectId = selectedProjectId;
				}		    

				this.applicationContext.setPage("planningNotificationEdit",
						params,
						{ backPage : "planningNotificationList", backParams : new Object() });
			}));		

			return button;	    
		},

		constructNewSharepointButton : function(captionBarDiv) {
			// Save button
			var button = new Button({
				label : i18n.planningNotificationNewSharepointButtonCaption,
				title : i18n.planningNotificationNewSharepointButtonToolTip
			});
			domClass.add(button.domNode, "planningNotificationNewSharepointButton");
			domConstruct.place(button.domNode, captionBarDiv);

			on(button, "click", lang.hitch(this, function() {
				this.applicationContext.setPage("planningNotificationSharepointImport",
						{ mode : ContentWidget.Mode.CREATE },
						{ backPage : "planningNotificationList", backParams : new Object() });
			}));		

			return button;	    
		},	    


             cloneAndConvertSearchModelForServer : function(searchModel) {
                 var retModel = {
                                             id : searchModel.id,
                                        comment : searchModel.comment,
                                           path : searchModel.path,
                                       filename : searchModel.filename,
                           organisationPersonId : searchModel.organisationPersonId,
                                      networkId : searchModel.networkId,
                                      projectId : searchModel.projectId,
                           textMetaTagIdToValue : searchModel.textMetaTagIdToValue,
                            dateMetaTagIdToFrom : searchModel.dateMetaTagIdToFrom,
                              dateMetaTagIdToTo : searchModel.dateMetaTagIdToTo,
                        planningNotificationIds : searchModel.planningNotificationIds,                     
                 };

                 var entries = searchModel.planningNotificationEntries;
                 var planningNotificationTitles = [];
                 var planningNotificationIds = [];
                 for (var n = 0; n < entries.length; n++) {
                     var entry = entries[n];
                     if (entry.id != CdesVoc.MagicSelectOption.ALL && (entry.title == null || entry.title.trim() != i18n.allOption)) {
                         if (entry.id != null) {
                             planningNotificationIds.push(entry.id);
                         } else if (entry.title != null && entry.title.trim().length > 0) {
                             planningNotificationTitles.push(entry.title);
                         }
                     }
                 }
                 retModel.planningNotificationIds = planningNotificationIds;
                 retModel.planningNotificationTitles = planningNotificationTitles;

                 return retModel;
             },
                 

		exportToPdf : function() {
			var columnToWidth = new Object();
			var columns = this.listWidget.grid.get("columns");
			for (var n = 0; n < columns.length; n++) {
				var column = columns[n];
				if (!column.hidden) {
					columnToWidth[column.id] = (column.headerNode != null ? column.headerNode.clientWidth : null);
				}		    
			}		

			var planningNotificationService = this.applicationContext.getService("planningNotificationService");

			var sortSpecs = this.listWidget.getSortSpecs();

			var searchModel = this.searchWidget.getSearchModel();
                    searchModel = this.cloneAndConvertSearchModelForServer(searchModel);

			topic.publish("message/info", i18n.planningNotificationPdfExportStarted);

			this.registerAsyncOperationStarted(PlanningNotificationPage.AsyncOperation.EXPORT_TO_PDF);
			planningNotificationService.triggerExportPlanningNotificationList(searchModel, columnToWidth, sortSpecs).then(lang.hitch(this, function(jobId) {
				JobHelper.registerJobStatusQueryForDownload(this.applicationContext, jobId, function(jobId) {
					topic.publish("message/ok", i18n.planningNotificationPdfExportFinished);

					var parameterString = ioQuery.objectToQuery({
						jobId : jobId
					});
					return "/cdes-dojo-impl/download?" + parameterString;
				});

				this.registerAsyncOperationFinished(PlanningNotificationPage.AsyncOperation.EXPORT_TO_PDF);
			}), lang.hitch(this, function(err){				
				ErrorHelper.processAsyncError({
					err : err,
					widget : this,
					asyncOperation : PlanningNotificationPage.AsyncOperation.EXPORT_TO_PDF,
					opName : "triggerExportPlanningNotificationList",
					message : i18n.planningNotificationExportListFailed
				}); 				
			})).otherwise(
					lang.hitch(this, function(err) {
						log.error("Handling the results of executing triggerExportPlanningNotificationList failed", err);
					}));    		
		},    	


		/* With icon

		 */
		constructContentDiv : function() {
			var contentDiv = domConstruct.create("div", null, null);
			domClass.add(contentDiv, "refNodeOfPositionAbsolute", "planningNotificationPageContentDiv");

			return contentDiv;
		},

		resize : function(newSize) {
			if (newSize) {
				this.lastNewSize = newSize;
			}

			var totalHeight = this.lastNewSize.h;    		

			var tableWidth = this.captionBarDiv.offsetWidth - 15;
			var tableHeight = totalHeight
			//- this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")
			- this.captionBarDiv.offsetHeight
			- this.searchWidgetDiv.offsetHeight - domStyle.get(this.searchWidgetDiv, "margin-top") - domStyle.get(this.searchWidgetDiv, "margin-bottom") 
			- this.columnWidgetDiv.offsetHeight - domStyle.get(this.columnWidgetDiv, "margin-top") - domStyle.get(this.columnWidgetDiv, "margin-bottom")
			// 	- this.statusBarDiv.offsetHeight
			- 20;
			this.listWidget.resize({ w : tableWidth, h : tableHeight });
		},

		reloadSearchInfo : function(includeMetaTags) {
			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
			var networkId = this.applicationContext.getPageContextPnNetworkId();

			this.registerAsyncOperationStarted(PlanningNotificationPage.AsyncOperation.LOAD_SEARCH_INFO);
			var planningNotificationService = this.applicationContext.getService("planningNotificationService");
			planningNotificationService.getPlanningNotificationSearchInfo(organisationPersonId, networkId, includeMetaTags).then(
					lang.hitch(this, function(searchInfo) {		    
						this.registerAsyncOperationFinished(PlanningNotificationPage.AsyncOperation.LOAD_SEARCH_INFO);

						var metaTags = includeMetaTags ? searchInfo.metaTags : null;
						if (metaTags != null) {
							metaTags.sort(function(metaTagOne, metaTagTwo) {
								return (metaTagOne.position != null ? metaTagOne.position : 0) - (metaTagTwo.position != null ? metaTagTwo.position : 0);
							});
						}			

						this.searchWidget.initialize(metaTags, searchInfo.projectIdToProject, searchInfo.projectIdToPlanningNotifications);
						this.columnWidget.initialize(metaTags);
						this.listWidget.initialize(metaTags);
						this.projectIdToActions = searchInfo.projectIdToAllowedActions;
						
						var defaultColumnSettings = ColumnHelper.getDefaultColumnSettingsPN(this.applicationContext, this, null, "planningNotification/columns");
						this.columnWidget.setData(defaultColumnSettings);

						this.reload();		    
					}),
					lang.hitch(this, function(err) {
						ErrorHelper.processAsyncError({
							err : err,
							widget : this,
							asyncOperation : PlanningNotificationPage.AsyncOperation.LOAD_SEARCH_INFO,
							opName : "getPlanningNotificationSearchInfo",
							message : i18n.planningNotificationPageGetPlanningNotificationSearchInfoFailed
						});
					})).otherwise(
							lang.hitch(this, function(err) {
								log.error("Error while calling function [getPlanningNotificationSearchInfo]", err);
							}));
		},

		setData : function() {

		},

		reload : function() {
			//this.contextBar.reload();

			this.listWidget.setData({ planningNotificationInfos : [], columnSettings : this.columnWidget.getColumnSettings() });

			this.updateWidgetState();

			if (this.searchWidget.isAlreadyInitialized()) {
				this.reloadData();
			}
		},

		reloadData : function() {
			// Set up searchmodel
			var searchModel = this.searchWidget.getSearchModel();
			searchModel.timestamp = DateHelper.getCurrentTimeSeconds();

			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
			var networkId = this.applicationContext.getPageContextPnNetworkId();
			this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotification/search", searchModel);

			// Synchronize project id between planningNotification and planningNotificationOrder search widgets            
			var planningNotificationOrderSearchModel = this.applicationContext.getFromLocalStorage([organisationPersonId, networkId], "/planningNotificationOrder/search");
			if (planningNotificationOrderSearchModel == null) {
				planningNotificationOrderSearchModel = new Object();		
			}		
			planningNotificationOrderSearchModel.projectId = searchModel.projectId;
			planningNotificationOrderSearchModel.planningNotificationEntries = searchModel.planningNotificationEntries;	    
			this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotificationOrder/search", planningNotificationOrderSearchModel);

			this.adaptReportSearchModelInLocalStorage(organisationPersonId, networkId, searchModel);

			if (searchModel.networkId == null) {
				var columnSettings = ColumnHelper.getColumnSettingsForReload(this, searchModel);
				this.listWidget.setData({ 
					planningNotificationInfos : [],
					columnSettings : columnSettings
				});
				topic.publish("message/warn", i18n.contextBarNoNetworkSetWarning);
			} else {
				topic.publish("message/info", i18n.searchRuns);

            searchModel = this.cloneAndConvertSearchModelForServer(searchModel);
			// Update visibility of new button and export to msp button 
			var anyProjectHasNewAction = false;
			if (this.projectIdToActions != null) {
				for (var projectId in this.projectIdToActions) {
					var actions = this.projectIdToActions[projectId];
					if (actions != null) {
						for (var n = 0; n < actions.length; n++) {
							anyProjectHasNewAction |= (actions[n] == "editPlanningNotification");
						}                                    
					}                                
				}
			}
			if (anyProjectHasNewAction){ 
				domClass.remove(this.newButton.domNode, "hidden");
				/*domClass.remove(this.newSharepointButton.domNode, "hidden");*/
			}else{
				domClass.add(this.newButton.domNode, "hidden");
				domClass.add(this.newSharepointButton.domNode, "hidden");
			}

			this.registerAsyncOperationStarted(PlanningNotificationPage.AsyncOperation.LOAD_DATA);
			var planningNotificationService = this.applicationContext.getService("planningNotificationService");
			planningNotificationService.getPlanningNotificationJoins(searchModel).then(
					lang.hitch(this, function(planningNotificationInfos) {
						this.registerAsyncOperationFinished(PlanningNotificationPage.AsyncOperation.LOAD_DATA);

						// Transform from List to Set, for easier handling lateron.
						for (var n = 0; n < planningNotificationInfos.length; n++) {
							var planningNotificationInfo = planningNotificationInfos[n];
							var allowedProjectActionsList = planningNotificationInfo.allowedProjectActions;
							var allowedProjectActionsSet = new Object();
							for (var v = 0; v < allowedProjectActionsList.length; v++) {
								allowedProjectActionsSet[allowedProjectActionsList[v]] = true;
							}

							planningNotificationInfo.allowedProjectActions = allowedProjectActionsSet;
						}			    

						var columnSettings = ColumnHelper.getColumnSettingsForReload(this, searchModel);

						this.listWidget.setData({ 
							planningNotificationInfos : planningNotificationInfos,
							columnSettings : columnSettings
						});

						var message = string.substitute(i18n.planningNotificationSearchSuccessful, {
							count : planningNotificationInfos.length
						});
						topic.publish("message/ok", message);			
					}),
					lang.hitch(this, function(err) {
						ErrorHelper.processAsyncError({
							err : err,
							widget : this,
							asyncOperation : PlanningNotificationPage.AsyncOperation.LOAD_DATA,
							opName : "getPlanningNotificationJoins",
							message : i18n.planningNotificationSearchGetPlanningNotificationJoinsFailed
						});
					})).otherwise(
							lang.hitch(this, function(err) {
								log.error("Error while calling function [getPlanningNotificationJoins]", err);
							}));	    
			}
		},            

		adaptReportSearchModelInLocalStorage : function(organisationPersonId, networkId, searchModel) {
			var reportConfig = this.applicationContext.getFromLocalStorage([organisationPersonId, networkId],
					"/planningNotificationReport/config");

			if (reportConfig == null) {
				reportConfig = PlanningNotificationHelper.constructEmptyReportConfig();
			}
			if (reportConfig.data.columnSettings.metaTagIdToShow == null) {
				reportConfig.data.columnSettings.metaTagIdToShow = new Object();
			}

			reportConfig.options.projectId = searchModel.projectId;
			reportConfig.data.notificationSearchModel.planningNotificationEntries = searchModel.planningNotificationEntries;
			reportConfig.data.notificationSearchModel.comment = searchModel.comment;
			reportConfig.data.notificationSearchModel.networkId = searchModel.networkId;
			reportConfig.data.notificationSearchModel.projectId = searchModel.projectId;
			reportConfig.data.notificationSearchModel.textMetaTagIdToValue = searchModel.textMetaTagIdToValue;
			reportConfig.data.notificationSearchModel.dateMetaTagIdToFrom = searchModel.dateMetaTagIdToFrom;
			reportConfig.data.notificationSearchModel.dateMetaTagIdToTo = searchModel.dateMetaTagIdToTo;

			reportConfig.data.columnSettings.showNotificationComment = searchModel.comment != null && searchModel.comment.length > 0;

			var touchedMetaTagIds = new Object();
			for (var textMetaTagId in searchModel.textMetaTagIdToValue) {
				reportConfig.data.columnSettings.metaTagIdToShow[textMetaTagId]
				= searchModel.textMetaTagIdToValue[textMetaTagId] != null && searchModel.textMetaTagIdToValue[textMetaTagId].length > 0;
				touchedMetaTagIds[textMetaTagId] = true;
			}		
			for (var dateFromMetaTagId in searchModel.dateMetaTagIdToFrom) {
				reportConfig.data.columnSettings.metaTagIdToShow[dateFromMetaTagId]
				= searchModel.dateMetaTagIdToFrom[dateFromMetaTagId] != null;
				touchedMetaTagIds[dateFromMetaTagId] = true;
			}		
			for (var dateToMetaTagId in searchModel.dateMetaTagIdToTo) {
				// Case distinction necessary, as "undefined | false" evaluates to 0, which then causes the JsonRPC protocol to report an error.
				if (dateToMetaTagId in reportConfig.data.columnSettings.metaTagIdToShow
						&& reportConfig.data.columnSettings.metaTagIdToShow[dateToMetaTagId] != null) {
					reportConfig.data.columnSettings.metaTagIdToShow[dateToMetaTagId]
					= reportConfig.data.columnSettings.metaTagIdToShow[dateToMetaTagId] 
					|| searchModel.dateMetaTagIdToTo[dateToMetaTagId] != null;
				} else {
					reportConfig.data.columnSettings.metaTagIdToShow[dateToMetaTagId]
					= searchModel.dateMetaTagIdToTo[dateToMetaTagId] != null;	    		
				}
				touchedMetaTagIds[dateToMetaTagId] = true;
			}		

			for (var metaTagId in reportConfig.data.columnSettings.metaTagIdToShow) {
				if (!(metaTagId in touchedMetaTagIds)) {
					reportConfig.data.columnSettings.metaTagIdToShow[metaTagId] = false;
				}		    
			}		

			this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotificationReport/config", reportConfig);            	    
		},

		updateWidgetState : function() {

		},

		getAutomaticColumnSettings : function(searchModel) {
			return {
				showTitle : true,
				showComment : true,
				showProject : true		
			};		
		},


		processColumnsChanged : function(columnId) {
		    var columnSettings = this.columnWidget.getColumnSettings();
		    this.listWidget.setColumns(columnSettings, columnId);
		    this.manualColumns = true;
		},

		destroy : function() {
			this.inherited(arguments);
			this.listWidget.destroy();
		}
	});

	PlanningNotificationPage.AsyncOperation = {
			EXPORT_TO_PDF : "ExportToPdf",
			LOAD_DATA : "LoadData",
			LOAD_SEARCH_INFO : "LoadSearchInfo"	
	};

	return PlanningNotificationPage;
});
