/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

define([ 
    "cdes/core/CdesVoc",
    "clazzes/TinyLog",
    "clazzes/util/DOMHelper",
    "clazzes/util/WidgetHelper",
    "clazzes/widgets/layout/ContentWidget",
    "dijit/form/Select",
	"dijit/form/CheckBox",
    "dojo/string",
    "dojo/_base/declare",
    "dojo/_base/lang",    
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"    
], function(
    CdesVoc,
    TinyLog,
    DOMHelper,
    WidgetHelper,
    ContentWidget,
    Select,
	CheckBox,
    string,    
    declare,
    lang,
    domClass,
    domConstruct,
    i18n        
) {

    var className = "at.cdes.web.document.ArchiveOptionWidget";

    var log = new TinyLog(className);

    var ArchiveOptionWidget = declare(className, ContentWidget, {

        constructor : function(params) {
            lang.mixin(this, params);
            this.allFieldsValid = true;

            this.topDiv = this.constructTopDiv();
        },
        
        getWidgetId : function() {
            return "DocumentPage";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);
            domClass.add(topDiv, "archiveOptionTopDiv");

            // ContentSelect
            DOMHelper.createTextNode("div", i18n.archiveOptionContentLabel, topDiv, "propertyLabel archiveOptionContentLabel");
            this.contentSelect = new Select({
                  label : i18n.archiveOptionContentLabel,
                  title : i18n.archiveOptionContentToolTip,
                options : this.getContentOptions()                
            });
            domClass.add(this.contentSelect.domNode, "fixedDialogWidget archiveOptionContentSelect");
            domConstruct.place(this.contentSelect.domNode, topDiv);
            WidgetHelper.handleSelectEvents(this.contentSelect, lang.hitch(this, this.updateWidgetState));
            
            // ReviewHistoryCheckBox
            if (this.applicationContext.isActionAllowedForProject("archiveReviewHistory")) {
				DOMHelper.createTextNode("div", i18n.archiveOptionReviewHistoryCheckBoxLabel, topDiv, "propertyLabel archiveOptionReviewHistoryCheckBoxLabel");
				this.reviewHistoryCheckBox = new CheckBox({
					label : i18n.archiveOptionReviewHistoryCheckBoxLabel,
					title : i18n.archiveOptionReviewHistoryCheckBoxToolTip
				});
				domClass.add(this.reviewHistoryCheckBox.domNode, "fixedDialogWidget archiveOptionReviewHistoryCheckBox"); 
				domConstruct.place(this.reviewHistoryCheckBox.domNode, topDiv);            
            }
            
            // FormatSelect
            DOMHelper.createTextNode("div", i18n.archiveOptionFormatLabel, topDiv, "propertyLabel archiveOptionFormatLabel");
            this.formatSelect = new Select({
                  label : i18n.archiveOptionFormatLabel,
                  title : i18n.archiveOptionFormatToolTip,
                options : this.getFormatOptions()                
            });
            domClass.add(this.formatSelect.domNode, "fixedDialogWidget archiveOptionFormatSelect");
            domConstruct.place(this.formatSelect.domNode, topDiv);
            WidgetHelper.handleSelectEvents(this.contentSelect, lang.hitch(this, this.updateWidgetState));

            DOMHelper.createTextNode("div", i18n.archiveOptionCountLabel, topDiv, "propertyLabel archiveOptionCountLabel");
//            var countString = string.substitute(i18n.archiveOptionDocumentsLabel, {
//                numberOfDocuments : this.numberOfDocuments
//            });
            var countString = this.numberOfDocuments;
            DOMHelper.createTextNode("div", countString, topDiv, "fixedDialogWidget archiveOptionDocumentsLabel");

            DOMHelper.createTextNode("div", i18n.archiveOptionEstimatedLabel, topDiv, "propertyLabel archiveOptionEstimatedLabel hidden");
            var estimatedString = string.substitute(i18n.archiveOptionEstimatedSizeLabel, {
                estimatedSize : (new Number(this.archiveCreateData.estimatedArchiveSize / 1000000.0)).toFixed(2)
            });
            DOMHelper.createTextNode("div", estimatedString, topDiv, "fixedDialogWidget archiveOptionEstimatedSizeLabel hidden");

            DOMHelper.createTextNode("div", i18n.archiveOptionFreeSpaceLabel, topDiv, "propertyLabel archiveOptionFreeSpaceLabel hidden");
            var freeSpaceString = string.substitute(i18n.archiveOptionFreeSpaceSizeLabel, {
                freeSpace : (new Number(this.archiveCreateData.freeDiskSpace / 1000000.0)).toFixed(2)
            });
            DOMHelper.createTextNode("div", freeSpaceString, topDiv, "fixedDialogWidget archiveOptionFreeSpaceSizeLabel hidden");

            return topDiv;            
        },

        getContentOptions : function() {
            var options = [
                { value : CdesVoc.ArchiveScope.ARCHIVE_SCOPE_RECENT.toString(), label : i18n.archiveScopeRecent }
            ];
            if (this.applicationContext.isActionAllowedForProject("archiveReviewHistory")) {
                options.push({ value : CdesVoc.ArchiveScope.ARCHIVE_SCOPE_ALL.toString(), label : i18n.archiveScopeAll });
            }
            return options;            
        },            

        getFormatOptions : function() {
        	var options = [
                { value : CdesVoc.ArchiveFileFormat.ARCHIVE_TYPE_PDF.toString(), label : i18n.pdfLabel }
            ];
//            if (this.applicationContext.isActionAllowedForProject("archiveReviewHistory")) {
                options.push({ value : CdesVoc.ArchiveFileFormat.ARCHIVE_TYPE_ORIGINAL.toString(), label : i18n.archiveTypeOriginal });
                options.push({ value : CdesVoc.ArchiveFileFormat.ARCHIVE_TYPE_BOTH.toString(), label : i18n.archiveTypeBoth });
//            }
            return options;            
        },

        getArchiveScope : function() {
            return WidgetHelper.getSelectValue(this.contentSelect);
        },

		doIncludeReviewHistory : function() {
            if (this.applicationContext.isActionAllowedForProject("archiveReviewHistory"))
            	return !!this.reviewHistoryCheckBox.get("checked");
            else
            	return false;
		},            

        getArchiveFileFormat : function() {
            return WidgetHelper.getSelectValue(this.formatSelect);
        }            
    });

    return ArchiveOptionWidget;
});
