define([ 
         "cdes/plot/PlotOrderListWidget",         
         "cdes/plot/PlotOrderSearchWidget",
         "cdes/util/JobHelper",
         "cdes/widget/ContextBar",
         "clazzes/FancyIFrame",
         "clazzes/TinyLog",
         "clazzes/topic",
         "clazzes/LoginGuardXhr",
         "clazzes/util/DOMHelper",
         "clazzes/util/ErrorHelper",
         "clazzes/widgets/layout/ContentWidget",
         "clazzes/widgets/DisableButton",
         "dijit/form/RadioButton",
         "dojo/dom-class",
         "dojo/dom-construct",
         "dojo/dom-style",
         "dojo/io-query",
         "dojo/on",
         "dojo/string",
         "dojo/_base/declare",
         "dojo/_base/lang",
         "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
       ],
    function(
    		 PlotOrderListWidget,
    		 PlotOrderSearchWidget,
    		 JobHelper,
    		 ContextBar,
    		 FancyIFrame,
    		 TinyLog,
    		 topic,
    		 LoginGuardXhr,
    		 DOMHelper,
    		 ErrorHelper,
    		 ContentWidget,
    		 DisableButton,
    		 RadioButton,
    		 domClass,
    		 domConstruct,
    		 domStyle,
    		 ioQuery,
    		 on,
    		 string,
    		 declare,
    		 lang,
    		 i18n
    		 ) {
	
	var className = "at.cdes.web.plot.PlotOrderPage";

	var log = new TinyLog(className);
	
    var PlotOrderPage = declare(className, ContentWidget, {
    	
    	constructor : function(params) {
    		lang.mixin(this,params);
    		
    		this.topDiv = this.constructTopDiv();
    		
    		//registerBasePage
    		var tabSessionContextService = this.applicationContext.getService("tabSessionContextService");
    		var pageName = "plotOrders";
    		
    		tabSessionContextService.addToPageList(dojoConfig.tabSessionId, pageName, true).then(lang.hitch(this, function() {    		
					log.info("Called UpdatePageContextService");
			}),
			lang.hitch(this, function(err) {
		        ErrorHelper.processAsyncError({
                               err : err,
                            widget : this,
                    asyncOperation : null,
                            opName : "UpdatePageContextService",
                           message : i18n.updatePageContextServiceFailedMessage
		        });     				
			})).otherwise(lang.hitch(this, function(err) {
				log.error("Error while processing UpdatePageContextService: ", err);
			}));
    		
			this.updateWidgetState();
			this.reload();
    		
    		//var networkId = this.applicationContext.getPageContextNetworkId();
    		
    		this.allFieldsValid = true;
    	},
    	
    	getWidgetId : function() {
    		return "PlotOrderPage";
    	},
    	
    	getDataId : function() {
    		return null;
    	},
    	
    	getContainer : function() {
    		return this.topDiv;
    	},
    	
    	constructTopDiv : function() {    		
    		var topDiv = domConstruct.create("div", null, null);
    		
    		// Caption Bar
    		this.captionBarDiv = this.constructCaptionBar();
    		domClass.add(this.captionBarDiv, "plotOrderPageCaptionBar");
    		domConstruct.place(this.captionBarDiv, topDiv);
    		
    		// Export to pdf button
    		this.exportToPdfButton = this.constructExportToPdfButton();
    		
    		// Declare selected plot orders charged button
    		if (this.applicationContext.isActionAllowedForProject("chargePlotOrder")) {
    			this.declareSelectedChargedButton = this.constructDeclareSelectedChargedButton();
    		}
    		
    		// Search Widget
    		this.searchWidget = new PlotOrderSearchWidget({
    			applicationContext : this.applicationContext
    		});
    		this.searchWidgetDiv = this.searchWidget.getContainer();
    		domConstruct.place(this.searchWidgetDiv, topDiv);
    		on(this.searchWidget, "titlePaneToggled", lang.hitch(this, this.resize));
    		on(this.searchWidget, "doSearch", lang.hitch(this, this.reload));
    		
    		// List Widget
    		this.listWidget = new PlotOrderListWidget({
    			applicationContext : this.applicationContext,
    			              mode : PlotOrderListWidget.Mode.DEFAULT
    		});
    		this.listWidgetDiv = this.listWidget.getContainer();
    		domConstruct.place(this.listWidgetDiv, topDiv);
            this.listWidget.restoreColumnWidths();    		
    		
    		this.downloadFrame = new FancyIFrame({hidden : true});
    		domConstruct.place(this.downloadFrame.domNode, topDiv);    
    		on(this.downloadFrame, "documentLoad", lang.hitch(this, function(event) {
    			if (event.document && event.document.body && event.document.body.innerHTML != "") {
    				// TODO error handling topic.publish("messageBar/showError", i18n.exportFailedTechnicalProblem);
    			}
    		}));    		
    		
    		return topDiv;
    	},
    	
    	constructCaptionBar : function() {
    		// Caption Bar consisting of caption and context bar right of the caption
    		var captionBarDiv = domConstruct.create("div", null, null);
//    		domClass.add(captionBarDiv, "planDeliverCatalogueCaptionBar");
    		
    		// Caption
    		this.captionDiv = DOMHelper.createTextNode("h1", i18n.plotOrderPageCaption, captionBarDiv, "plotOrderPageCaption");
     		
    		return captionBarDiv;
    	},    	
    	
    	constructExportToPdfButton : function() {
    		var exportToPdfButton = new DisableButton({
                label : i18n.plotOrderPageExportToPdfButtonCaption,
            showLabel : false,
                title : i18n.plotOrderPageExportToPdfButtonToolTip,
              onClick : lang.hitch(this, function() {
            	  this.exportToPdf();
              }),
            iconClass : "exportToPdfButton",
              "class" : "cdesWebButton17x18 gridButton",
     controllerWidget : this,
         disableEvent : "disableButtons",
     _destroyOnRemove : true
       	 	});    		
    		domConstruct.place(exportToPdfButton.domNode, this.captionBarDiv);    		
    		return exportToPdfButton;    		
    	},
    	
    	constructDeclareSelectedChargedButton : function() {
    		var declareSelectedChargedButton = new DisableButton({
                label : i18n.plotOrderPageDeclareSelectedChargedButtonCaption,
            showLabel : false,
                title : i18n.plotOrderPageDeclareSelectedChargedButtonToolTip,
              onClick : lang.hitch(this, function() {
            	  this.declareSelectedPlotOrdersCharged();
              }),
            iconClass : "plotOrderChargeButton",
              "class" : "cdesWebButton17x18 gridButton",
     controllerWidget : this,
         disableEvent : "disableButtons",
     _destroyOnRemove : true
       	 	});    		
    		domConstruct.place(declareSelectedChargedButton.domNode, this.captionBarDiv);    		
    		return declareSelectedChargedButton;    		
    	},
    	
    	declareSelectedPlotOrdersCharged : function() {
    		this.listWidget.declareSelectedPlotOrdersCharged();
    	},
    	
    	exportToPdf : function() {
    		var plotService = this.applicationContext.getService("plotService");
    
    		var plotOrderJoins = this.listWidget.getPlotOrderJoins();
    		var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
    		var network = this.applicationContext.getPageContextNetwork();
    		var project = this.applicationContext.getPageContextProject();
    		var personVariablesUserLocale = this.applicationContext.getPageContextPersonVariablesUserLocale();
    		
    		this.registerAsyncOperationStarted(PlotOrderPage.AsyncOperation.EXPORT_TO_PDF);
    		
			topic.publish("message/ok", i18n.plotOrderListExportStarted);
			
			plotService.triggerExportPlotOrdersToPdf(organisationPersonId, network, project, plotOrderJoins, personVariablesUserLocale).then(lang.hitch(this, function(jobId) {
				JobHelper.registerJobStatusQueryForDownload(this.applicationContext, jobId, function(jobId) {
					topic.publish("message/ok", i18n.plotOrderListExportFinished);
					var parameterString = ioQuery.objectToQuery({
						jobId : jobId
					});
					return "/cdes-dojo-impl/download?" + parameterString;
				});
				
				this.registerAsyncOperationFinished(PlotOrderPage.AsyncOperation.EXPORT_TO_PDF);
			}), lang.hitch(this, function(err){				
   				ErrorHelper.processAsyncError({
                            err : err,
                         widget : this,
                 asyncOperation : PlotOrderPage.AsyncOperation.EXPORT_TO_PDF,
                         opName : "exportPlotOrderListToPdf",
                        message : i18n.plotOrderListExportFailed
   				}); 				
			})
			).otherwise(lang.hitch(this, function(err) {
				log.error("Handling the results of executing exportPlotOrderListToPdf failed", err);
			}));    		
    	},    	
    	
    	resize : function(newSize) {

            if (newSize != null) {
                this.oldNewSize = newSize;
            }
            newSize = this.oldNewSize;

            if (newSize == null) {
                return;
            }
    		
    		var totalHeight = newSize.h;
    		
    		var tableWidth = this.searchWidgetDiv.offsetWidth;
    		var tableHeight = totalHeight
    					//- this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")
    					- this.captionBarDiv.offsetHeight
    					- this.searchWidgetDiv.offsetHeight - domStyle.get(this.searchWidgetDiv, "margin-top") - domStyle.get(this.searchWidgetDiv, "margin-bottom") 
    					- 16;
    		this.listWidget.resize({ w : tableWidth, h : tableHeight });
    	},
    	
    	setData : function() {
    		// Search model is fetched automatically from searchWidget, thus nothing is to be done here.
    	},
    	
    	reload : function() {
    		//this.contextBar.reload();
    		
    		this.listWidget.setData({ data : [] });
    		this.registerAsyncOperationStarted(PlotOrderPage.AsyncOperation.GET_DATA);
    		this.updateWidgetState();
    		
    		// Set up searchmodel
    		var searchModel = this.searchWidget.getSearchModel();
    		
    		var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
    		var networkId = this.applicationContext.getPageContextNetworkId();
    		this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/plotOrder/search", searchModel);    		
    		
    		searchModel.organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
    		searchModel.projectId = this.applicationContext.getPageContextProjectId();
    		
			topic.publish("message/info", i18n.searchRuns);

			var plotService = this.applicationContext.getService("plotService");
    		
    		// If the previous search still runs, cancel it
    		if (this.joinDeferred != null) {
    			log.info("Previous joinDeferred still runs, will cancel it.");
    			this.joinDeferred.cancel();
    		}
    		
			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
    		this.joinDeferred = plotService.getPlotOrderJoin(organisationPersonId, searchModel);
    		this.joinDeferred.then(lang.hitch(this, function(plotOrderJoins) {
    			
    			topic.publish("message/ok", string.substitute(i18n.plotOrderPageLoadOk, {
    				numberOfPlotOrders : plotOrderJoins.length
    			}));
    			
    			this.listWidget.setData({ data : plotOrderJoins });
				delete this.joinDeferred;
				
	    		this.registerAsyncOperationFinished(PlotOrderPage.AsyncOperation.GET_DATA);
				this.updateWidgetState();    			
    		}),
   			lang.hitch(this, function(err) {    			
				delete this.joinDeferred;
				
		        ErrorHelper.processAsyncError({
		        		          err : err,
		        		       widget : this,
 		               asyncOperation : PlotOrderPage.AsyncOperation.GET_DATA,
 				               opName : "getPlotOrderJoin",
 			                  message : i18n.plotOrderPageLoadFailed
		        });
			})
    		).otherwise(lang.hitch(this, function(err) {
    			log.error("Error while processing the results of calling getPlotOrderJoin: ", err);
    		}));
    	},
    	
    	updateWidgetState : function() {
    		var operationRunning = this.isAsyncOperationRunning();
    	},
    	
    	destroy : function() {
    		this.inherited(arguments);
    		this.listWidget.destroy();
    	}
    });
    
    PlotOrderPage.AsyncOperation = {
    		     GET_DATA : "GetData",
    		EXPORT_TO_PDF : "ExportToPdf"
    };
    
    return PlotOrderPage;
});
