/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

////css-prefix = planningNotificationReportList
////i18n-prefix = planningNotificationReportList

define([
    "cdes/planning/util/PlanningNotificationHelper",
    "cdes/planning/util/PlanningNotificationListHelper",
    "cdes/util/ActionHelper",
    "cdes/util/CodeHelper",
    "cdes/util/ColumnHelper",
    "cdes/util/NameHelper",
    "cdes/widget/base/ListWidget",
    "clazzes/TinyLog",
    "clazzes/dateTime/DateHelper",
    "clazzes/form/FancyButton",
    "clazzes/topic",
    "clazzes/util/DOMHelper",
    "clazzes/util/ErrorHelper",
    "clazzes/widgets/layout/ContentWidget",
    "clazzes/widgets/layout/InfoDialog",
    "dgrid/OnDemandGrid",
    "dgrid/extensions/ColumnResizer",
    "dgrid/extensions/DijitRegistry",
    "dojo/aspect",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/on",
    "dojo/string",
    "dstore/Memory",
    "dstore/Trackable",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(
    PlanningNotificationHelper,
    PlanningNotificationListHelper,
    ActionHelper,
    CodeHelper,
    ColumnHelper,
    NameHelper,
    ListWidget,
    TinyLog,
    DateHelper,
    FancyButton,
    topic,
    DOMHelper,
    ErrorHelper,
    ContentWidget,
    InfoDialog,
    OnDemandGrid,
    ColumnResizer,
    DijitRegistry,
    aspect,
    domClass,
    domConstruct,
    declare,
    lang,
    on,
    string,
    Memory,
    Trackable,
    i18n) {

    var className = "at.cdes.web.planning.report.PlanningNotificationReportListWidget";

    var log = new TinyLog(className);

    var PlanningNotificationReportListWidget = declare(className, ListWidget, {

        dataAttributeName : "orderJoins",

        constructor : function(params) {
            lang.mixin(this, params);

            if (this.sortStorageKey == null) {
                this.sortStorageKey = "/planningNotificationOrder/sort";
            }

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "PlanningNotificationOrderListWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        columnWidthKey : "planningNotificationReport/columnWidths",
        defaultColumnWidth : 130,

        columnIdToDefaultWidth : {
                              title : 300,
                notificationComment : 150,
                            project : 150,           
                               file : 70,
                       serialNumber : 70,
                               text : 350,
               planningNotification : 200,
                            project : 120,
                        subjectArea : 130,
                authorizedInspector : 160,
                          reference : 100,
                      statutoryDuty : 130,
                        invalidated : 70,
                       workflowNode : 150,
                              state : 100,
                       documentPage : 80,
                   documentPosition : 200,
                             source : 130,
                     personInCharge : 280,
                  statutoryDutyFrom : 120,
                    statutoryDutyTo : 120,
              statutoryDutyInterval : 200,
              statutoryDutyLeadTime : 120,
                           siteType : 100,
               statutoryDutyExpired : 120,
                    submitAuthority : 110,
                                tag : 130,
                       orderComment : 150,
            environmentallyRelevant : 140
        },            

        getLocalStorageContextKeys : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextPnNetworkId();
            return [organisationPersonId, networkId];
        },

        constructColumns : function() {
            var columns = [];


            PlanningNotificationListHelper.pushOrderSerialNumberColumn(columns);
            PlanningNotificationListHelper.pushOrderTextColumn(columns);
            PlanningNotificationListHelper.pushPlanningNotificationTitleColumn(columns);
            PlanningNotificationListHelper.pushNotificationCommentColumn(columns);
            PlanningNotificationListHelper.pushProjectColumn(columns);
            //                      PlanningNotificationListHelper.pushOrderPlanningNotificationColumn(columns, documentCaption);

            if (this.metaTags != null) {
                PlanningNotificationListHelper.pushMetaTagColumns(columns, this.metaTags);
            }               
            PlanningNotificationListHelper.pushSubjectAreaColumn(columns);
            PlanningNotificationListHelper.pushAuthorizedInspectorColumn(columns);
            PlanningNotificationListHelper.pushReferenceColumn(columns, this);
            PlanningNotificationListHelper.pushStatutoryDutyColumn(columns);
            PlanningNotificationListHelper.pushOrderInvalidatedColumn(columns);
            PlanningNotificationListHelper.pushDocumentPositionColumn(columns);
            PlanningNotificationListHelper.pushDocumentPageColumn(columns);
            PlanningNotificationListHelper.pushSourceColumn(columns);
            PlanningNotificationListHelper.pushPersonInChargeColumn(columns);
            PlanningNotificationListHelper.pushStatutoryDutyFromColumn(columns);
            PlanningNotificationListHelper.pushStatutoryDutyToColumn(columns);
            PlanningNotificationListHelper.pushStatutoryDutyIntervalColumn(columns);
            PlanningNotificationListHelper.pushStatutoryDutyLeadTimeColumn(columns);
            PlanningNotificationListHelper.pushStatutoryDutyExpiredColumn(columns);
            PlanningNotificationListHelper.pushSubmitAuthorityColumn(columns);
            PlanningNotificationListHelper.pushTagColumn(columns);
            PlanningNotificationListHelper.pushOrderCommentColumn(columns);
            PlanningNotificationListHelper.pushEnvironmentallyRelevantColumn(columns);
            PlanningNotificationListHelper.pushWorkflowNodeColumn(columns);
            PlanningNotificationListHelper.pushStateColumn(columns);

            return columns;
        },

        renderReferenceCell : function(orderJoin, data, cell) {
            return PlanningNotificationHelper.renderReferenceCell(orderJoin.referenceInfos, this, this.referenceDestination);
        },              

        updateIndividualColumns : function() {
            PlanningNotificationListHelper.updatePlanningNotificationColumns(this, this.columnSettings, this.metaTags);
            PlanningNotificationListHelper.updatePlanningNotificationOrderColumns(this, this.columnSettings);
        },

        constructTopDiv : function() {
            var grid = this.constructGrid({
                   idProperty : "planningNotificationOrderWorkflowEntityId", 
                       gridId : this.gridId != null ? this.gridId : "PlanningNotificationReportListWidgetGrid",
                     idSuffix : this.idSuffix,                       
                selectionMode : this.selectionMode                          
            });

            on(grid, "dgrid-sort", lang.hitch(this, function(e) {
                var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
                var networkId = this.applicationContext.getPageContextPnNetworkId();
                this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], this.sortStorageKey, e.sort);
            }));

            aspect.after(this.grid, "renderRow", lang.hitch(this, function(row, args) {
                var joinDto = args[0];
                this.updateRowClass(row, joinDto);
                return row;
            }));

            if (this.selectionMode != null) {
                on(grid, "dgrid-select", lang.hitch(this, this.emitSelectionChanged));
                on(grid, "dgrid-deselect", lang.hitch(this, this.emitSelectionChanged));
            }                       

            return grid;        
        },

        updateRowClass : function(domNode, joinDto) {
            domClass.remove(domNode, "planningNotificationOrderInvalidated");
            
            if (joinDto.workflowEntityInvalidated) {
                domClass.add(domNode, "planningNotificationOrderInvalidated");
            }
        },

        resize : function(newSize) {
            this.grid.resize(newSize);
        },

        setData : function(params) {
            var columnSettings = params.columnSettings;
            var reportInfos = params.reportInfos;

            this.reportJoins = [];
            for (var n = 0; n < reportInfos.length; n++) {
                var reportInfo = reportInfos[n];
                var reportJoin = reportInfo.reportJoin;

                reportJoin.metaTagIdToDateMetaInformations = reportInfo.metaTagIdToDateMetaInformations ? reportInfo.metaTagIdToDateMetaInformations : {};
                reportJoin.metaTagIdToTextMetaInformations = reportInfo.metaTagIdToTextMetaInformations ? reportInfo.metaTagIdToTextMetaInformations : {};
                reportJoin.projects = reportInfo.projects ? reportInfo.projects : [];
                reportJoin.projectJoins = reportInfo.projectJoins ? reportInfo.projectJoins : [];
                reportJoin.referenceInfos = reportInfo.referenceInfos ? reportInfo.referenceInfos : [];
                reportJoin.baulosMetaInformations = reportInfo.baulosMetaInformations ? reportInfo.baulosMetaInformations : [];
                reportJoin.tags = reportInfo.tags ? reportInfo.tags : [];
                reportJoin.workflowNodeJoins = reportInfo.workflowNodeJoins;
                reportJoin.workflowNodeIdToPositions = reportInfo.workflowNodeIdToPositions;
                reportJoin.workflowNodePositionIdToBaulose = reportInfo.workflowNodePositionIdToBaulose;
                reportJoin.allowedProjectActions = reportInfo.allowedProjectActions;
                reportJoin.workflowInitialized = reportInfo.workflowInitialized;
                this.reportJoins.push(reportJoin);
            }
            this.updateAuxiliaryData();

            if (columnSettings) {
                this.setColumns(params.columnSettings);
            }

            this.reload({
            });


        },

        updateAuxiliaryData : function() {
            for (var n = 0; n < this.reportJoins.length; n++) {
                var joinDto = this.reportJoins[n];
                this.updatePlanningNotificationAuxiliaryData(joinDto);
                PlanningNotificationListHelper.updatePlanningNotificationOrderAuxiliaryData(joinDto, this.applicationContext);
            }
        },

        updatePlanningNotificationAuxiliaryData : function(joinDto) {
            joinDto._applicationContext = this.applicationContext;
            joinDto._planningNotificationId = joinDto.planningNotificationId;
            joinDto._planningNotificationTitle = joinDto.planningNotificationTitle;
            joinDto._planningNotificationComment = joinDto.planningNotificationComment;

            PlanningNotificationListHelper.updatePlanningNotificationMetaDataAuxiliaryData(joinDto);
        },              

        reload : function(params) {
            var noSort = params.noSort;

            this.store.setData(this.reportJoins);
            this.grid.set("store", this.store);

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextPnNetworkId();
            var oldSort = this.applicationContext.getFromLocalStorage([organisationPersonId, networkId], this.sortStorageKey);

            if (noSort) {
                this.grid.set("sort", "_artificialIndex", false);
            } else {
                if (oldSort == null) {
                    this.grid.set("sort", "planningNotificationOrderSerialNumber", false);
                    this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], this.sortStorageKey, this.grid.get("sort"));
                } else {
                    this.grid.set("sort", oldSort);
                }               

                this.grid.updateSortArrow(this.grid.sort);
            }

            this.grid.refresh();
        },

        sort : function(column) {
            this.grid.set("sort", column, false);
            this.grid.updateSortArrow(this.grid.sort);
            this.grid.refresh();
        },

        getRowId : function(joinDto) {
            return joinDto.planningNotificationOrderWorkflowEntityId;
        },


        initialize : function(metaTags) {
            if (metaTags != null) {
                this.metaTags = metaTags;           
                var columns = this.constructColumns();
                this.grid.set("columns", columns);          
            }
        },          

        destroy : function() {
            this.inherited(arguments);

            this.grid.destroy();
        }
    });

    return PlanningNotificationReportListWidget;
});
