define([
    "clazzes/LoginGuardRpcService",
    "clazzes/LogViewer",
    "clazzes/TinyLog",
    "clazzes/util/DOMHelper",
    "clazzes/widgets/layout/ContentWidget",
    "dijit/form/Button",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/io-query",
    "dojo/json",
    "dojo/on",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/text!/cdes/svc/adminServiceWeb?smd",
    "dojo/text!/cdes-dojo-impl/jobStatus?smd",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
], function(
    LoginGuardRpcService,
    LogViewer,
    TinyLog,
    DOMHelper,
    ContentWidget,
    Button,
    domClass,
    domConstruct,
    domStyle,
    ioQuery,
    json,
    on,
    declare,
    lang,
    adminServiceSmd,
    jobStatusServiceSmd,
    i18n
) {
    
    var className = "at.cdes.web.admin.db.DBAdminPage";

    var log = new TinyLog(className);
    
    var DBAdminPage = declare(className, ContentWidget, {
        
        constructor : function(params) {
            lang.mixin(this,params);
            this.uuid = null;
            
            this.adminService = new LoginGuardRpcService(json.parse(adminServiceSmd));          
            this.jobStatusService = new LoginGuardRpcService(json.parse(jobStatusServiceSmd));
            
            this.topDiv = this.constructTopDiv();
            
            this.updateWidgetState();
            
            this.allFieldsValid = true;
        },
        
        getWidgetId : function() {
            return "DBAdminPage";
        },
        
        getDataId : function() {
            return null;
        },
        
        getContainer : function() {
            return this.topDiv;
        },
        
        constructTopDiv : function() {  
            var topDiv = domConstruct.create("div", null, null);
            
            // Caption Bar
            this.captionBarDiv = this.constructCaptionBar();
            domClass.add(this.captionBarDiv, "dbAdminEditPageCaptionBar");
            domConstruct.place(this.captionBarDiv, topDiv);
            
            this.buttonDiv = this.constructButtonDiv();
            domClass.add(this.buttonDiv, "dbAdminPageButtonDiv");
            domConstruct.place(this.buttonDiv, topDiv);
            
            return topDiv;
        },
        
        constructCaptionBar : function() {
            // Caption Bar consisting of caption and context bar right of the caption
            var captionBarDiv = domConstruct.create("div", null, null);
            
            // Caption
            this.captionDiv = DOMHelper.createTextNode("h1", i18n.dbAdminPageCaption, captionBarDiv, "dbAdminEditPageCaption");
            
            return captionBarDiv;
        },
        
        constructButtonDiv : function() {
            var buttonDiv = domConstruct.create("div", null, null);
            domClass.add(buttonDiv, "refNodeOfPositionAbsolute");
            
            this.constructCertificateCaButton(buttonDiv);
            this.constructLogViewerButton(buttonDiv);
            
            return buttonDiv;
        },
        
        constructCertificateCaButton : function(buttonDiv) {
            this.certificateCaButton = new Button({
                label : i18n.dbAdminCertificateCaButtonCaption
            });
            domClass.add(this.certificateCaButton.domNode, "fixedDialogWidget dbAdminCertificateCaButton");
            domConstruct.place(this.certificateCaButton.domNode, buttonDiv);
            
            on(this.certificateCaButton, "click", lang.hitch(this, function() {
                this.fixCertificatesToCa();
            }));
        },
        
        constructLogViewerButton : function(buttonDiv) {
            this.logViewerButton = new Button({
                label : i18n.dbAdminLogViewerButtonCaption
            });
            domClass.add(this.logViewerButton.domNode, "fixedDialogWidget dbAdminLogViewerButton");
            domConstruct.place(this.logViewerButton.domNode, buttonDiv);
            
            on(this.logViewerButton, "click", lang.hitch(this, function() {
                var logView = new LogViewer({
                               title : i18n.dbAdminLogViewerTitle,
                    jobStatusService : this.jobStatusService,
                               jobId : this.uuid
                });
                logView.show();
            }));
        },

        fixCertificatesToCa : function() {
			/* Currently out of use, to reactive add proper privilege checks.
            this.adminService.triggerFixCertificateCaForeignKeys().then(lang.hitch(this, function(uuid) {
                this.uuid = uuid;
                this.updateWidgetState();
            }), lang.hitch(this, function(err) {
                    
            })).otherwise(lang.hitch(this, function(err) {
                log.error("Error while processing the results of a call to triggerFixCertificateCaForeignKeys: ", err);
            }));
			*/            
        },

        resize : function(newSize) {            
            var buttonDivWidth = newSize.w - 16;
            var buttonDivHeight = newSize.h
                - this.captionBarDiv.offsetHeight
                - 32;
            domStyle.set(this.buttonDiv, "width", buttonDivWidth + "px");
            domStyle.set(this.buttonDiv, "height", buttonDivHeight + "px");
        },
        
        setData : function() {
            this.reload();
        },
        
        reload : function() {
        },
        
        updateWidgetState : function() {
            var operationRunning = this.isAsyncOperationRunning();
            
            this.logViewerButton.set("disabled", this.uuid == null);            
        }
    });
    
    return DBAdminPage;
});
