/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

//// css-prefix = documentSearch
//// i18n-prefix = documentSearch

define([ 
        "cdes/core/CdesVoc",
        "cdes/pdc/PlanDeliverHelper",
        "cdes/util/CodeHelper",
        "cdes/util/I18nHelper",
        "cdes/util/SearchPageHelper",
        "cdes/widget/CalendarSpinner",
        "clazzes/TinyLog",
        "clazzes/form/FancySelect",
        "clazzes/util/DOMHelper",
        "clazzes/util/WidgetHelper",
        "clazzes/widgets/IconTitlePane",
        "clazzes/widgets/layout/ContentWidget",
        "dijit/form/Button",
        "dijit/form/CheckBox",
        "dijit/form/ComboBox",
        "dijit/form/Select",
        "dijit/form/TextBox",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/keys",
        "dojo/on",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js",    
        "dojo/store/Memory"
], function(
            CdesVoc,
            PlanDeliverHelper,
            CodeHelper,
            I18nHelper,
            SearchPageHelper,
            CalendarSpinner,
            TinyLog,
            FancySelect,
            DOMHelper,
            WidgetHelper,
            IconTitlePane,
            ContentWidget,
            Button,
            CheckBox,
            ComboBox,
            Select,
            TextBox,
            domClass,    
            domConstruct,
            Keys,    
            on,
            declare,
            lang,
            i18n    ,
            Memory
            ) {

    var className = "at.cdes.web.document.DocumentSearchWidget";

    var log = new TinyLog(className);

    var DocumentSearchWidget = declare(className, ContentWidget, {
        constructor : function(params) {
            lang.mixin(this, params);
            this.searchModel = new Object();
            this.topDiv = this.constructTopDiv();
            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "PlanningNotificationSearchWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);
            domClass.add(topDiv, "refNodeOfPositionAbsolute documentSearchFull");

            this.titlePane = this.constructTitlePane();
            domConstruct.place(this.titlePane.domNode, topDiv);

            return topDiv;
        },

        constructTitlePane : function() {
            this.contentDiv = this.constructContentDiv();

            var titlePane = new IconTitlePane({
                       title   : i18n.searchOpenCaption,
                       content : this.contentDiv,
                    toggleable : true,
                          open : true,
                postTitleClick : lang.hitch(this, this.postTitleClick)
            });
            domClass.add(titlePane.domNode, "occupyWholeParent");

            return titlePane;
        },

        constructContentDiv : function() {
            var contentDiv = domConstruct.create("div", null, null);
            domClass.add(contentDiv, "refNodeOfPositionAbsolute documentSearchContentDiv");

            // StatusSelect - Status
            DOMHelper.createTextNode("div", i18n.documentSearchStatusLabel, contentDiv, "propertyLabel documentSearchStatusLabel");
            this.statusSelect = new Select({
                  label : i18n.documentSearchStatusLabel,
                  title : i18n.documentSearchStatusToolTip,
                options : CodeHelper.getDocumentVersionStatusOptions()                
            });
            domClass.add(this.statusSelect.domNode, "fixedDialogWidget documentSearchStatusSelect");
            domConstruct.place(this.statusSelect.domNode, contentDiv);
            WidgetHelper.handleSelectEvents(this.statusSelect, lang.hitch(this, this.recordChanged));

            // DelayOptionSelect - Termin
            DOMHelper.createTextNode("div", i18n.documentSearchDelayOptionLabel, contentDiv, "propertyLabel documentSearchDelayOptionLabel");
            this.delayOptionSelect = new Select({
                  label : i18n.documentSearchDelayOptionLabel,
                  title : i18n.documentSearchDelayOptionToolTip,
                options : CodeHelper.getReviewCycleStatusSearchDelayOptions()                
            });
            domClass.add(this.delayOptionSelect.domNode, "fixedDialogWidget documentSearchDelayOptionSelect");
            domConstruct.place(this.delayOptionSelect.domNode, contentDiv);
            WidgetHelper.handleSelectEvents(this.delayOptionSelect, lang.hitch(this, this.recordChanged));

            // ReviewCycleSelect
            DOMHelper.createTextNode("div", i18n.documentSearchReviewCycleLabel, contentDiv, "propertyLabel documentSearchReviewCycleLabel");
            this.reviewCycleSelect = new FancySelect({
                  label : i18n.documentSearchReviewCycleLabel,
                  title : i18n.documentSearchReviewCycleToolTip,
                options : [{ label : i18n.whatever, value : CdesVoc.WHATEVER }],
                  value : CdesVoc.WHATEVER                                
            });
            domClass.add(this.reviewCycleSelect.domNode, "fixedDialogWidget documentSearchReviewCycleSelect");
            domConstruct.place(this.reviewCycleSelect.domNode, contentDiv);
            WidgetHelper.handleSelectEvents(this.reviewCycleSelect, lang.hitch(this, this.recordChanged));


            // DocumentTypeSelect - Plantyp
            DOMHelper.createTextNode("div", i18n.documentSearchDocumentTypeLabel, contentDiv, "propertyLabel documentSearchDocumentTypeLabel");
            this.documentTypeSelect = new FancySelect({
                  label : i18n.documentSearchDocumentTypeLabel,
                  title : i18n.documentSearchDocumentTypeToolTip,
                options : [{ label : i18n.whatever, value : CdesVoc.WHATEVER }],
                  value : CdesVoc.WHATEVER                
            });
            domClass.add(this.documentTypeSelect.domNode, "fixedDialogWidget documentSearchDocumentTypeSelect");
            domConstruct.place(this.documentTypeSelect.domNode, contentDiv);
            WidgetHelper.handleSelectEvents(this.documentTypeSelect, lang.hitch(this, this.recordChanged));

            // ObjectSelect - Objekt
            this.objectSelectLabel = DOMHelper.createTextNode("div", i18n.documentSearchObjectLabel, contentDiv, "propertyLabel documentSearchObjectLabel");
            this.objectSelect = new FancySelect({
                  label : i18n.documentSearchObjectLabel,
                  title : i18n.documentSearchObjectToolTip,
				  options : [{ label : i18n.whatever, value : CdesVoc.WHATEVER }],
                  value : CdesVoc.WHATEVER                
            });
            domClass.add(this.objectSelect.domNode, "fixedDialogWidget documentSearchObjectSelect");
            domConstruct.place(this.objectSelect.domNode, contentDiv);
            WidgetHelper.handleSelectEvents(this.objectSelect, lang.hitch(this, this.recordChanged));

            // IncludeObjectPlannersCheckBox
            this.includeObjectPlannersCheckBox = new CheckBox({
                title : i18n.documentSearchIncludeObjectPlannersCheckBoxToolTip
            });
            domClass.add(this.includeObjectPlannersCheckBox.domNode, "fixedDialogWidget documentSearchIncludeObjectPlannersCheckBox");
            domConstruct.place(this.includeObjectPlannersCheckBox.domNode, contentDiv);
            WidgetHelper.handleCheckBoxEvents(this.includeObjectPlannersCheckBox, lang.hitch(this, this.includeObjectPlannersCheckBoxChanged));

            // ReviewCycleInstanceReleased
            DOMHelper.createTextNode("div", i18n.documentSearchReviewCycleInstanceLabel, contentDiv, "propertyLabel documentSearchReviewCycleInstanceLabel");
            this.reviewCycleInstanceReleasedMemory = new Memory({
                data : []
            });
            this.reviewCycleInstanceReleasedComboBox = new ComboBox({
		               label : i18n.documentSearchReviewCycleInstanceLabel,
		               title : i18n.documentSearchReviewCycleInstanceToolTip,
		     		   store : this.reviewCycleInstanceReleasedMemory,
   				   queryExpr : "*${0}*", //any search string
				autoComplete : false,
               selectOnClick : true
            });
            domClass.add(this.reviewCycleInstanceReleasedComboBox.domNode, "fixedDialogWidget documentSearchReviewCycleInstanceComboBox");
            domConstruct.place(this.reviewCycleInstanceReleasedComboBox.domNode, contentDiv);
            on(this.reviewCycleInstanceReleasedComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
            WidgetHelper.handleComboBoxEvents(this.reviewCycleInstanceReleasedComboBox, lang.hitch(this, this.recordChanged));

            // DateFilter
            var dateFilterOptions = [
                                     { label : i18n.documentSearchDateFilterUploadType, value : DocumentSearchWidget.DateFilterType.UPLOAD },
                                     { label : i18n.documentSearchDateFilterReleaseType, value : DocumentSearchWidget.DateFilterType.RELEASE }
            ];
            this.dateFilterSelect = new Select({
                  label : i18n.documentSearchDateFilterSelectLabel,
                options : dateFilterOptions
            });
            domClass.add(this.dateFilterSelect.domNode, "fixedDialogWidget documentSearchDateFilterSelect");
            domConstruct.place(this.dateFilterSelect.domNode, contentDiv);            
            WidgetHelper.handleSelectEvents(this.dateFilterSelect, lang.hitch(this, this.recordChanged));

            // Date From
            this.fromSpinner = new CalendarSpinner({
                            label : i18n.documentSearchFromLabel,
                            title : i18n.documentSearchFromLabel,
                          pattern : i18n.datePattern,
                         timeZone : this.applicationContext.getTimeZone(),                
                       dndEnabled : false,
                rowObjectToString : null
            });
            domClass.add(this.fromSpinner.domNode, "fixedDialogWidget documentSearchFromSpinner");
            domConstruct.place(this.fromSpinner.domNode, contentDiv);
            WidgetHelper.handleSpinnerEvents(this.fromSpinner, lang.hitch(this, this.recordChanged));
            on(this.fromSpinner.domNode, "keyup", lang.hitch(this, this.searchIfEnter));

            DOMHelper.createTextNode("div", i18n.searchTo, contentDiv, "propertyLabel documentSearchToLabel");            

            // Date To
            this.toSpinner = new CalendarSpinner({
                            label : i18n.documentSearchToLabel,
                            title : i18n.documentSearchToLabel,
                          pattern : i18n.datePattern,
                         timeZone : this.applicationContext.getTimeZone(),                
                       dndEnabled : false,
                rowObjectToString : null
            });
            domClass.add(this.toSpinner.domNode, "fixedDialogWidget documentSearchToSpinner");
            domConstruct.place(this.toSpinner.domNode, contentDiv);
            WidgetHelper.handleSpinnerEvents(this.toSpinner, lang.hitch(this, this.recordChanged));
            on(this.toSpinner.domNode, "keyup", lang.hitch(this, this.searchIfEnter));

            // NameTextBox - Plannummer
            DOMHelper.createTextNode("div", i18n.documentSearchNameLabel, contentDiv, "propertyLabel documentSearchNameLabel");
            this.nameTextBox = new TextBox({
		                label : i18n.documentSearchNameLabel,
		                title : i18n.documentSearchNameToolTip,
                selectOnClick : true
            });
            domClass.add(this.nameTextBox.domNode, "fixedDialogWidget documentSearchNameTextBox");
            domConstruct.place(this.nameTextBox.domNode, contentDiv);
            on(this.nameTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
            WidgetHelper.handleTextBoxEvents(this.nameTextBox, lang.hitch(this, this.recordChanged));

            // ContentTextBox
            DOMHelper.createTextNode("div", i18n.documentSearchContentLabel, contentDiv, "propertyLabel documentSearchContentLabel");
            this.contentTextBox = new TextBox({
		                label : i18n.documentSearchContentLabel,
		                title : i18n.documentSearchContentToolTip,
                selectOnClick : true
            });
            domClass.add(this.contentTextBox.domNode, "fixedDialogWidget documentSearchContentTextBox");
            domConstruct.place(this.contentTextBox.domNode, contentDiv);
            on(this.contentTextBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
            WidgetHelper.handleTextBoxEvents(this.contentTextBox, lang.hitch(this, this.recordChanged));

            // ProjectParticipationSelect
            DOMHelper.createTextNode("div", i18n.documentSearchProjectParticipationLabel, contentDiv, "propertyLabel documentSearchProjectParticipationLabel");
    	    this.plannerMemory = new Memory({
    		data : PlanDeliverHelper.getPlannerMemoryData(this.organisationPersonIdToJoins)
    	    });
            this.plannerComboBox = new ComboBox({
		               label : i18n.documentSearchProjectParticipationLabel,
		               title : i18n.documentSearchProjectParticipationToolTip,
		     		   store : this.plannerMemory,
   				   queryExpr : "*${0}*", //any search string
				autoComplete : false,
               selectOnClick : true
            });
            domClass.add(this.plannerComboBox.domNode, "fixedDialogWidget documentSearchProjectParticipationSelect");
            domConstruct.place(this.plannerComboBox.domNode, contentDiv);
            on(this.plannerComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
            WidgetHelper.handleComboBoxEvents(this.plannerComboBox, lang.hitch(this, this.recordChanged));

            DOMHelper.createTextNode("div", i18n.documentSearchRoleLabel, contentDiv, "propertyLabel documentSearchRoleLabel");
            this.roleMemory = new Memory({
                data : [ ]
            });
            this.roleComboBox = new ComboBox({
		               label : i18n.documentSearchRoleLabel,
		               title : i18n.documentSearchRoleToolTip,
		     	       store : this.roleMemory,
   				   queryExpr : "*${0}*", //any search string
				autoComplete : false,
               selectOnClick : true
            });
            domClass.add(this.roleComboBox.domNode, "fixedDialogWidget documentSearchRoleComboBox");
            domConstruct.place(this.roleComboBox.domNode, contentDiv);
            on(this.roleComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
            WidgetHelper.handleComboBoxEvents(this.roleComboBox, lang.hitch(this, this.roleComboBoxChanged));

            // StatusDiv
			this.statusDiv = DOMHelper.createTextNode("div", i18n.notYetSearched, contentDiv, "fixedDialogWidget documentSearchStatusDiv");

            // ShowDeletedCheckBox
            this.showDeletedLabel = DOMHelper.createTextNode("div", i18n.documentSearchShowDeletedLabel, contentDiv, "fixedDialogWidget documentSearchShowDeletedLabel");
            this.showDeletedCheckBox = new CheckBox({
                label : i18n.documentSearchShowDeletedLabel,
                title : i18n.documentSearchShowDeletedToolTip
            });
            domClass.add(this.showDeletedCheckBox.domNode, "fixedDialogWidget documentSearchShowDeletedCheckBox");
            domConstruct.place(this.showDeletedCheckBox.domNode, contentDiv);
            WidgetHelper.handleCheckBoxEvents(this.showDeletedCheckBox, lang.hitch(this, this.recordChanged));

            // Buttons
            this.buttonDiv = domConstruct.create("div", null, null);
            domClass.add(this.buttonDiv, "fixedDialogWidget documentSearchButtonDiv");
            domConstruct.place(this.buttonDiv, contentDiv);            

            // ClearSearchFieldsButton
            this.clearSearchFieldsButton = new Button({
                label : i18n.clearSearchFieldsButtonCaption,
                title : i18n.clearSearchFieldsButtonToolTip
            });
            domClass.add(this.clearSearchFieldsButton.domNode, "documentSearchClearSearchFieldsButton");
            domConstruct.place(this.clearSearchFieldsButton.domNode, this.buttonDiv);
            on(this.clearSearchFieldsButton, "click", lang.hitch(this, this.clearSearchFields));            

            // SearchButton
            this.searchButton = new Button({
                label : i18n.searchButtonCaption,
                title : i18n.searchButtonCaption
            });            
            domClass.add(this.searchButton.domNode, "documentSearchSearchButton");
            domConstruct.place(this.searchButton.domNode, this.buttonDiv);
            on(this.searchButton, "click", lang.hitch(this, this.doSearch));

            return contentDiv;          
        },

        postTitleClick : function() {
            var open = this.titlePane.get("open");

            if (open) {
                this.titlePane.set("title", i18n.searchOpenCaption);
                domClass.replace(this.topDiv, "documentSearchFull", "documentSearchReduced");
            } else {
                this.titlePane.set("title", i18n.searchClosedCaption);
                domClass.replace(this.topDiv, "documentSearchReduced", "documentSearchFull");
            }

            on.emit(this, "titlePaneToggled");
        },

        roleComboBoxChanged : function() {
            var cdesRoleId = SearchPageHelper.getAllableComboBoxId(this.roleComboBox);
            
            if (cdesRoleId != this.cdesRoleId) {
                var plannerMemoryData = PlanDeliverHelper.getPlannerMemoryData(this.organisationPersonIdToJoins, cdesRoleId);
                this.plannerMemory.setData(plannerMemoryData);
                this.cdesRoleId = cdesRoleId;
            }
            this.recordChanged();
        },

        includeObjectPlannersCheckBoxChanged : function() {
            var includeObjectPlanners = this.includeObjectPlannersCheckBox.get("checked");
            var objectId = null;
            var objectPlannerId = null;
            var objectIdOrObjectPlannerId = WidgetHelper.getSelectValue(this.objectSelect);
            if (objectIdOrObjectPlannerId != null && objectIdOrObjectPlannerId != CdesVoc.WHATEVER) {
                if (objectIdOrObjectPlannerId in this.objectIds) {
                    objectId = objectIdOrObjectPlannerId;
                } else {
                    objectPlannerId = objectIdOrObjectPlannerId;
                    var objectPlannerReleases = this.documentPageInfo.objectPlannerReleases;
                    var objectReleases = this.documentPageInfo.objectReleases;
		            for (var z = 0; z < objectPlannerReleases.length; z++) {
		                var objectPlannerRelease = objectPlannerReleases[z];
		                if (objectPlannerRelease.objectPlannerId == objectPlannerId){
		                	objectReleaseId = objectPlannerRelease.objectId;
				            for (var k = 0; k < objectReleases.length; k++) {
				                var objectRelease = objectReleases[k];
				                if (objectRelease.id == objectReleaseId){
				                	objectId = objectRelease.objectId;
				                	break;
			                	}
				            }
	                	}
		            }
                }
            }

            if (includeObjectPlanners){
            	DOMHelper.setInnerText(this.objectSelectLabel, i18n.documentSearchObjectLabel);
            	WidgetHelper.setSelectOptionsAndKeepLabelIfPossible(this.objectSelect, this.objectReleaseOptions);
        	}else{
            	DOMHelper.setInnerText(this.objectSelectLabel, i18n.documentSearchObjectPlannerLabel);
            	WidgetHelper.setSelectOptionsAndKeepLabelIfPossible(this.objectSelect, this.objectReleaseWithoutPlannersOptions);
            	WidgetHelper.setSelectValue(this.objectSelect, objectId);
        	}
            if (objectId == null)
                WidgetHelper.setSelectValue(this.objectSelect, objectId);
        	
            this.recordChanged();
        },

        recordChanged : function() {
            this.changed = true;
        },

        constructButtons : function() {
            // ClearSearchFieldsButton
            this.clearSearchFieldsButton = new Button({
                label : i18n.clearSearchFieldsButtonCaption,
                title : i18n.clearSearchFieldsButtonToolTip
            });
            domClass.add(this.clearSearchFieldsButton.domNode, "documentSearchClearSearchFieldsButton");
            domConstruct.place(this.clearSearchFieldsButton.domNode, this.buttonDiv);
            on(this.clearSearchFieldsButton, "click", lang.hitch(this, this.clearSearchFields));        

            // SearchButton
            this.searchButton = new Button({
                label : i18n.searchButtonCaption,
                title : i18n.planningNotificationSearchSearchButtonToolTip
            });            
            domClass.add(this.searchButton.domNode, "documentSearchSearchButton");
            domConstruct.place(this.searchButton.domNode, this.buttonDiv);
            on(this.searchButton, "click", lang.hitch(this, this.doSearch));
        },            

		addToDocumentTypeOptions : function(options, documentTypes, indendation) {
			documentTypes.sort(function(documentTypeOne, documentTypeTwo) {
				return documentTypeOne.code - documentTypeTwo.code;
			});
			
			for (var n = 0; n < documentTypes.length; n++) {
				var documentType = documentTypes[n];
				var longLabel = (documentType._children == null || documentType._children.length == 0 
						? documentType.code + " - " + documentType.name : "<b>" + documentType.code + " - " + documentType.name + "</b>");
				for (var z = 0; z < indendation; z++) {
					longLabel = "&#160;&#160;&#160;" + longLabel;
				}
				
				options.push({
					    label : documentType.code,
					longLabel : longLabel,
					    value : documentType.id
				});
				
				if (documentType._children != null && documentType._children.length > 0) {
					this.addToDocumentTypeOptions(options, documentType._children, indendation + 1);
				}
			}
		},

        initialize : function(documentPageInfo) {
            this.documentPageInfo = documentPageInfo;

            // DocumentType            
            var idToDocumentType = documentPageInfo.idToDocumentType;
            var documentTypeOptions = [{ label : i18n.whatever, value : CdesVoc.WHATEVER }];
            var documentTypes = [];
			var documentTypesGroups = [];
			// Add a transient documentType._children attribute.
            for (var documentTypeId in idToDocumentType) {
			    var documentType = idToDocumentType[documentTypeId];
			    if (documentType.documentTypeGroupId != null) {
			        var parentId = documentType.documentTypeGroupId;
			        if (idToDocumentType[parentId]._children == null) {
			            idToDocumentType[parentId]._children = [];
			        }
			        idToDocumentType[parentId]._children.push(documentType);
			    } else if (documentType.documentTypeGroupId == null)
					documentTypesGroups.push(documentType);	
				
                documentTypes.push(idToDocumentType[documentTypeId]);
            }

			this.addToDocumentTypeOptions(documentTypeOptions, documentTypesGroups, 0);
			WidgetHelper.setSelectOptionsAndKeepLabelIfPossible(this.documentTypeSelect, documentTypeOptions);

            // ObjectRelease
            var objectReleases = documentPageInfo.objectReleases;
            objectReleases.sort(function(objectReleaseOne, objectReleaseTwo) {
	         	var objectTypeOne = (objectReleaseOne.objectTypeId != null ? documentPageInfo.objectTypeIdToObjectType[objectReleaseOne.objectTypeId] : null);
	         	var objectTypeSuffixOne = (objectTypeOne != null ? objectTypeOne.code : "");
	         	var objectTypeTwo = (objectReleaseTwo.objectTypeId != null ? documentPageInfo.objectTypeIdToObjectType[objectReleaseTwo.objectTypeId] : null);
	         	var objectTypeSuffixTwo = (objectTypeTwo != null ? objectTypeTwo.code : "");
				var one = objectReleaseOne.code + objectTypeSuffixOne;
				var two = objectReleaseTwo.code + objectTypeSuffixTwo;
                return one.localeCompare(two);
            });                

            var objectPlannerReleases = documentPageInfo.objectPlannerReleases;
            var objectReleaseIdToObjectPlannerReleases = new Object();
            for (var z = 0; z < objectPlannerReleases.length; z++) {
                var objectPlannerRelease = objectPlannerReleases[z];
                var objectReleaseId = objectPlannerRelease.objectId; // correct, name misleading in data model
                if (!(objectReleaseId in objectReleaseIdToObjectPlannerReleases)) {
                    objectReleaseIdToObjectPlannerReleases[objectReleaseId] = [];
                }
                objectReleaseIdToObjectPlannerReleases[objectReleaseId].push(objectPlannerRelease);
            }

            this.objectReleaseOptions = [];
            this.objectReleaseWithoutPlannersOptions = [];
            this.objectIds = new Object();
           //objects
            for (var z = 0; z < objectReleases.length; z++) {
                var objectRelease = objectReleases[z];
                var value = objectRelease.objectId;
                this.objectIds[value] = true;
	         	var objectType = (objectRelease.objectTypeId != null ? documentPageInfo.objectTypeIdToObjectType[objectRelease.objectTypeId] : null);
	         	var objectTypeSuffix = (objectType != null ? objectType.code : "");
	         	var longLabel =  objectRelease.code + objectTypeSuffix + " " + objectRelease.name;
                var label = (longLabel.length <= 32 ? longLabel : longLabel.substr(0, 32) + "...");
                
                this.objectReleaseOptions.push({ 
		                	value : value, 
		                longLabel : "<b>" + longLabel + "</b>", 
		                	label : label 
                });
                
                this.objectReleaseWithoutPlannersOptions.push({ 
		                	value : value, 
		                longLabel : longLabel, 
		                	label : label 
                });

                var objectPlannerReleases = objectRelease.id in objectReleaseIdToObjectPlannerReleases ? objectReleaseIdToObjectPlannerReleases[objectRelease.id] : [];
                objectPlannerReleases.sort(function(objectPlannerReleaseOne, objectPlannerReleaseTwo) {
                    return objectPlannerReleaseOne.code.localeCompare(objectPlannerReleaseTwo.code);
                });                
                
                //objectPlanners
                for (var n = 0; n < objectPlannerReleases.length; n++) {
                    var objectPlannerRelease = objectPlannerReleases[n];

                    var objectPlannerId = objectPlannerRelease.objectPlannerId;
                    var longLabel = objectPlannerRelease.code + " " + objectPlannerRelease.area;
                    var label = (longLabel.length <= 32 ? longLabel : longLabel.substr(0, 32) + "...");
                    this.objectReleaseOptions.push({
                            value : objectPlannerId,
                        longLabel : "&#160;&#160;&#160;&#160;" + longLabel,
                            label : label
                    });
                }
            }
            this.objectReleaseOptions.splice(0, 0, { label : i18n.whatever, value : CdesVoc.WHATEVER });
            this.objectReleaseWithoutPlannersOptions.splice(0, 0, { label : i18n.whatever, value : CdesVoc.WHATEVER });

            // ReviewCycleInstanceReleased
            this.reviewCycleInstanceReleasedMemoryData
                = PlanDeliverHelper.getReviewCycleInstanceReleasedMemoryData(this.documentPageInfo.reviewCycleInstanceReleaseds);
            this.reviewCycleInstanceReleasedMemory.setData(this.reviewCycleInstanceReleasedMemoryData);

            // ReviewCycleSelect
            var reviewCycles = documentPageInfo.reviewCycles;
            var reviewCycleIdToCells = documentPageInfo.reviewCycleIdToCells;
            var reviewCycleCellIdToNodes = documentPageInfo.reviewCycleCellIdToNodes;

            reviewCycles = reviewCycles.sort(function(reviewCycleOne, reviewCycleTwo) {
                var nameOne = reviewCycleOne.name != null ? reviewCycleOne.name : "";
                var nameTwo = reviewCycleTwo.name != null ? reviewCycleTwo.name : "";
                return nameOne.localeCompare(nameTwo);
            });

            documentPageInfo.idToReviewCycle = new Object();
            documentPageInfo.idToReviewCycleNode = new Object();
            documentPageInfo.idToReviewCycleCell = new Object();

            var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();

            var reviewCycleOptions = [{ label : i18n.whatever, value : CdesVoc.WHATEVER }];
            for (var n = 0; n < reviewCycles.length; n++) {
                var reviewCycle = reviewCycles[n];
                documentPageInfo.idToReviewCycle[reviewCycle.id] = reviewCycle;                            
                
                var reviewCycleName = I18nHelper.getCurrentLocaleString(reviewCycle.name, locale);
                reviewCycleOptions.push({
                        label : reviewCycleName,
                    longLabel : "<b>" + reviewCycleName + "</b>",
                        value : reviewCycle.id
                });

                var reviewCycleCells = reviewCycleIdToCells[reviewCycle.id] != null ? reviewCycleIdToCells[reviewCycle.id] : [];
                reviewCycleCells = reviewCycleCells.sort(function(reviewCycleCellOne, reviewCycleCellTwo) {
                    var positionOne = reviewCycleCellOne.position != null ? reviewCycleCellOne.position : 0;
                    var positionTwo = reviewCycleCellTwo.position != null ? reviewCycleCellTwo.position : 0;
                    if (positionOne != positionTwo) {
                        return positionOne - positionTwo;
                    } else {
                        var nameOne = reviewCycleCellOne.name != null ? reviewCycleCellOne.name : "";
                        var nameTwo = reviewCycleCellTwo.name != null ? reviewCycleCellTwo.name : "";
                        return nameOne.localeCompare(nameTwo);
                    }
                });

                for (var z = 0; z < reviewCycleCells.length; z++) {
                    var reviewCycleCell = reviewCycleCells[z];
                    documentPageInfo.idToReviewCycleCell[reviewCycleCell.id] = reviewCycleCell;

                    var reviewCycleCellName = I18nHelper.getCurrentLocaleString(reviewCycleCell.name, locale);
                    reviewCycleOptions.push({
                            label : reviewCycleCellName,
                        longLabel : "&#160;&#160;&#160;&#160;" + reviewCycleCellName,
                            value : reviewCycleCell.id
                    });

                    var reviewCycleNodes = reviewCycleCellIdToNodes[reviewCycleCell.id] != null ? reviewCycleCellIdToNodes[reviewCycleCell.id] : [];
                    reviewCycleNodes = reviewCycleNodes.sort(function(reviewCycleNodeOne, reviewCycleNodeTwo) {
                        var positionOne = reviewCycleNodeOne.position != null ? reviewCycleNodeOne.position : 0;
                        var positionTwo = reviewCycleNodeTwo.position != null ? reviewCycleNodeTwo.position : 0;
                        if (positionOne != positionTwo) {
                            return positionOne - positionTwo;
                        } else {
                            var nameOne = reviewCycleNodeOne.name != null ? reviewCycleNodeOne.name : "";
                            var nameTwo = reviewCycleNodeTwo.name != null ? reviewCycleNodeTwo.name : "";
                            return nameOne.localeCompare(nameTwo);
                        }
                    });

                    for (var k = 0; k < reviewCycleNodes.length; k++) {
                        var reviewCycleNode = reviewCycleNodes[k];
                        documentPageInfo.idToReviewCycleNode[reviewCycleNode.id] = reviewCycleNode;
                        var reviewCycleNodeName = I18nHelper.getCurrentLocaleString(reviewCycleNode.name, locale);
                        reviewCycleOptions.push({
                                label : reviewCycleNodeName,
                            longLabel : "&#160;&#160;&#160;&#160;" + "&#160;&#160;&#160;&#160;" + reviewCycleNodeName,
                                value : reviewCycleNode.id
                        });
                    }                    
                }                    
            }
            WidgetHelper.setSelectOptionsAndKeepLabelIfPossible(this.reviewCycleSelect, reviewCycleOptions);

            // Planner
            this.organisationPersonIdToJoins = PlanDeliverHelper.setPersonRoleJoinsForSearchComboBox({
                personRoleJoins : this.documentPageInfo.persons,
                  plannerMemory : this.plannerMemory
            });

            // Role
            this.roleMemoryData = PlanDeliverHelper.getRoleMemoryData(this.documentPageInfo.cdesRoles);
            this.roleMemory.setData(this.roleMemoryData);

            this.updateWidgetState();

     	    if (!this.initialized) {
	        	this.populateSearchFields();
	     		this.initialized = true;
     	    }
            //cameBack is set via this.applicationContext.popLastPageHistoryPage({ cameBack : true});

            var activeOrganisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var initialLoad = this.applicationContext.getFromLocalStorage([ activeOrganisationPersonId ], "/documentList/initialLoad");
            if (initialLoad) {
                this.applicationContext.storeInLocalStorage([ activeOrganisationPersonId ], "/documentList/initialLoad", false);
            }
            
	    if (this.documentPageInfo.enableAutoInitSearch || this.cameBack || initialLoad) {
	        on.emit(this, "doSearch");
            }
        },

        isAlreadyInitialized : function() {
            return this.initialized;
        },

        updateWidgetState : function() {
            var hideDeletedCheckBox = this.documentPageInfo.showDeletedCheckBoxDisabled;
            if (hideDeletedCheckBox) {
                domClass.add(this.showDeletedLabel, "invisible");
                domClass.add(this.showDeletedCheckBox.domNode, "invisible");
            } else {
                domClass.remove(this.showDeletedLabel, "invisible");
                domClass.remove(this.showDeletedCheckBox.domNode, "invisible");
            }
        },

     	populateSearchFields : function() {
    	    var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
    	    var networkId = this.applicationContext.getPageContextNetworkId();
    	    var oldSearchModel = this.applicationContext.getFromLocalStorage([organisationPersonId, networkId], "/documentList/search");
    	    
            if (oldSearchModel != null)
                this.searchModel = oldSearchModel;                
            this.updateWidgetsFromData();                
     	},

        updateWidgetsFromData : function() {
            var status = this.searchModel.status != null ? this.searchModel.status : CdesVoc.WHATEVER;
            WidgetHelper.setSelectValue(this.statusSelect, status);

            var delayOption = this.searchModel.delayOption != null ? this.searchModel.delayOption : CdesVoc.WHATEVER;
            WidgetHelper.setSelectValue(this.delayOptionSelect, delayOption);

            var reviewCycleIds = this.searchModel.reviewCycleIds;
            var reviewCycleCellIds = this.searchModel.reviewCycleCellIds;
            var reviewCycleNodeIds = this.searchModel.reviewCycleNodeIds;
            if (reviewCycleIds != null && reviewCycleIds.length > 0) {
                WidgetHelper.setSelectValue(this.reviewCycleSelect, reviewCycleIds[0]);
            } else if (reviewCycleCellIds != null && reviewCycleCellIds.length > 0) {
                WidgetHelper.setSelectValue(this.reviewCycleSelect, reviewCycleCellIds[0]);
            } else if (reviewCycleNodeIds != null && reviewCycleNodeIds.length > 0) {
                WidgetHelper.setSelectValue(this.reviewCycleSelect, reviewCycleNodeIds[0]);
            }                    

            var documentTypeId = this.searchModel.documentTypeId != null ? this.searchModel.documentTypeId : CdesVoc.WHATEVER;
            WidgetHelper.setSelectValue(this.documentTypeSelect, documentTypeId);

            var includeObjectPlanners = this.searchModel.includeObjectPlanners != null ? this.searchModel.includeObjectPlanners : "true";
            this.includeObjectPlannersCheckBox.set("checked", includeObjectPlanners);

            if (includeObjectPlanners){
            	DOMHelper.setInnerText(this.objectSelectLabel, i18n.documentSearchObjectLabel);
            	WidgetHelper.setSelectOptionsAndKeepLabelIfPossible(this.objectSelect, this.objectReleaseOptions);
        	}else{
            	DOMHelper.setInnerText(this.objectSelectLabel, i18n.documentSearchObjectPlannerLabel);
            	WidgetHelper.setSelectOptionsAndKeepLabelIfPossible(this.objectSelect, this.objectReleaseWithoutPlannersOptions);
        	}
            if (this.searchModel.objectId == null && this.searchModel.objectPlannerId == null) {
                WidgetHelper.setSelectValue(this.objectSelect, CdesVoc.WHATEVER);
            } else if (this.searchModel.objectId != null) {
                WidgetHelper.setSelectValue(this.objectSelect, this.searchModel.objectId);
            } else {
                WidgetHelper.setSelectValue(this.objectSelect, this.searchModel.objectPlannerId);
            }

        	
            var uploadedFrom = this.searchModel.uploadedFrom;
            var uploadedTo = this.searchModel.uploadedTo;
            var releasedFrom = this.searchModel.releasedFrom;
            var releasedTo = this.searchModel.releasedTo;
            if (uploadedFrom != null || uploadedTo != null) {
                this.dateFilterSelect.set("value", DocumentSearchWidget.DateFilterType.UPLOAD);
                this.fromSpinner.setUtcSeconds(uploadedFrom);
                this.toSpinner.setUtcSeconds(uploadedTo);
            } else {
                this.dateFilterSelect.set("value", DocumentSearchWidget.DateFilterType.RELEASE);
                this.fromSpinner.setUtcSeconds(releasedFrom);
                this.toSpinner.setUtcSeconds(releasedTo);
            }                    

            var name = this.searchModel.name;
            this.nameTextBox.set("value", name);

            var content = this.searchModel.content;
            this.contentTextBox.set("value", content);

            var showDeleted = !!this.searchModel.showDeleted;
            this.showDeletedCheckBox.set("checked", showDeleted);

            SearchPageHelper.setSearchModelValueToAllableComboBox(this.searchModel, this.reviewCycleInstanceReleasedComboBox,
                                                                  "reviewCycleInstanceReleasedId",
                                                                  "reviewCycleInstanceReleasedName");

            SearchPageHelper.setSearchModelValueToAllableComboBox(this.searchModel, this.roleComboBox,
                                                                  "cdesRoleId", "cdesRoleName");

            // The same code is placed also in PlanDeliverSearchWidget, and might be placed into some helper function in future.
            var plannerOrgPersonId = this.searchModel.plannerOrgPersonId;
            var plannerName = this.searchModel.plannerName;                
            var ownOrganisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

            if (plannerOrgPersonId == ownOrganisationPersonId) {
     	        this.plannerComboBox.set("value", i18n.ownUser);
                this.plannerComboBox.item = this.plannerComboBox.store.query({ id : CdesVoc.UserCategory.OWN_USER })[0];
            } else if (plannerOrgPersonId != null) {
                var item = this.plannerComboBox.store.query({ id : plannerOrgPersonId })[0];
                if (item == null) {
                    // If an organisationPersonId stored previously is no longer available, instead fall back to ALL
                    SearchPageHelper.setComboBoxValue(this.plannerComboBox, CdesVoc.MagicSelectOption.ALL);
                } else {
                    this.plannerComboBox.set("value", item != null ? item.name : null);
                    this.plannerComboBox.item = this.plannerComboBox.store.query({ id : plannerOrgPersonId })[0];                    
                }
            } else if (plannerName == null) {
                SearchPageHelper.setComboBoxValue(this.plannerComboBox, CdesVoc.MagicSelectOption.ALL);
            } else {
                this.plannerComboBox.set("value", plannerName);

                if (plannerName == i18n.ownUser) {
                    this.plannerComboBox.item = this.plannerComboBox.store.query({ id : CdesVoc.UserCategory.OWN_USER })[0];
                }                    
            }
        },

        updateDataFromWidgets : function() {
            var status = WidgetHelper.getSelectValue(this.statusSelect);
            var delayOption = WidgetHelper.getSelectValue(this.delayOptionSelect);

            var reviewCycleSelectedId = WidgetHelper.getSelectValue(this.reviewCycleSelect);
            reviewCycleSelectedId = reviewCycleSelectedId != CdesVoc.WHATEVER ? reviewCycleSelectedId : null;
            var reviewCycleIds = reviewCycleSelectedId != null && reviewCycleSelectedId in this.documentPageInfo.idToReviewCycle ? [ reviewCycleSelectedId ] : null;
            var reviewCycleCellIds = reviewCycleSelectedId != null && reviewCycleSelectedId in this.documentPageInfo.idToReviewCycleCell ? [ reviewCycleSelectedId ] : null;
            var reviewCycleNodeIds = reviewCycleSelectedId != null && reviewCycleSelectedId in this.documentPageInfo.idToReviewCycleNode ? [ reviewCycleSelectedId ] : null;

            var documentTypeId = WidgetHelper.getSelectValue(this.documentTypeSelect);
            var objectId = null;
            var objectPlannerId = null;
            var objectIdOrObjectPlannerId = WidgetHelper.getSelectValue(this.objectSelect);
            if (objectIdOrObjectPlannerId != null && objectIdOrObjectPlannerId != CdesVoc.WHATEVER) {
                if (objectIdOrObjectPlannerId in this.objectIds) {
                    objectId = objectIdOrObjectPlannerId;
                } else {
                    objectPlannerId = objectIdOrObjectPlannerId;
                }
            }
            
            var dateFilterType = WidgetHelper.getSelectValue(this.dateFilterSelect);
            var from = this.fromSpinner.getUtcSeconds();
            var to = this.toSpinner.getUtcSeconds();
            var showDeleted = (this.documentPageInfo.showDeletedCheckBoxDisabled ? false : !!this.showDeletedCheckBox.get("checked"));

            this.searchModel = {
                organisationPersonId : this.applicationContext.getPageContextOrganisationPersonId(),
                        subProjectId : this.applicationContext.getPageContextSubProjectId(),
                              status : status != CdesVoc.WHATEVER ? status : null,
                         delayOption : delayOption != CdesVoc.WHATEVER ? delayOption : null,
                      reviewCycleIds : reviewCycleIds,
                  reviewCycleCellIds : reviewCycleCellIds,
                  reviewCycleNodeIds : reviewCycleNodeIds,
                      documentTypeId : documentTypeId != CdesVoc.WHATEVER ? documentTypeId : null,
                            objectId : objectId,
                     objectPlannerId : objectPlannerId,
                        uploadedFrom : dateFilterType == DocumentSearchWidget.DateFilterType.UPLOAD ? from : null,
                          uploadedTo : dateFilterType == DocumentSearchWidget.DateFilterType.UPLOAD ? to : null,
                        releasedFrom : dateFilterType == DocumentSearchWidget.DateFilterType.RELEASE ? from : null,
                          releasedTo : dateFilterType == DocumentSearchWidget.DateFilterType.RELEASE ? to : null,
                                name : this.nameTextBox.get("value"),
                             content : this.contentTextBox.get("value"),
                         showDeleted : showDeleted,
          	   includeObjectPlanners : this.includeObjectPlannersCheckBox.get("checked")
            };                

            // ReviewCycleInstanceReleased
            SearchPageHelper.setAllableComboBoxValueToSearchModel(this.reviewCycleInstanceReleasedComboBox, this.searchModel,
                                                                  "reviewCycleInstanceReleasedId",
                                                                  "reviewCycleInstanceReleasedName");

            // The same code can be found in PlanDeliverSearchWidget, might be placed in some helper
            if (SearchPageHelper.isComboBoxSetToAll(this.plannerComboBox)) {
                this.searchModel.plannerOrgPersonId = null;
                this.searchModel.plannerName = null;
            } else if (this.plannerComboBox.item && this.plannerComboBox.item.id) {
                this.searchModel.plannerName = null;
				if (this.plannerComboBox.item.id == CdesVoc.UserCategory.OWN_USER) {
				    this.searchModel.plannerOrgPersonId = this.applicationContext.getPageContextOrganisationPersonId();
				} else {
				    this.searchModel.plannerOrgPersonId = this.plannerComboBox.item.id;
				}				
		    } else {
                this.searchModel.plannerOrgPersonId = null;
				this.searchModel.plannerName = this.plannerComboBox.get("value");
		    }

            SearchPageHelper.setAllableComboBoxValueToSearchModel(this.roleComboBox, this.searchModel, "cdesRoleId", "cdesRoleName");
        },

        searchIfEnter : function(e) {
            if (e.keyCode == Keys.ENTER) {
                this.doSearch();
            }
        },

        clearSearchFields : function() {
            WidgetHelper.setSelectValue(this.statusSelect, CdesVoc.WHATEVER);
            WidgetHelper.setSelectValue(this.delayOptionSelect, CdesVoc.WHATEVER);
            WidgetHelper.setSelectValue(this.reviewCycleSelect, CdesVoc.WHATEVER);
            WidgetHelper.setSelectValue(this.documentTypeSelect, CdesVoc.WHATEVER);
            WidgetHelper.setSelectValue(this.objectSelect, CdesVoc.WHATEVER);
            SearchPageHelper.setComboBoxValue(this.reviewCycleInstanceReleasedComboBox, CdesVoc.MagicSelectOption.ALL);            
            WidgetHelper.setSelectValue(this.dateFilterSelect, DocumentSearchWidget.DateFilterType.UPLOAD);
            this.fromSpinner.setUtcSeconds(null);
            this.toSpinner.setUtcSeconds(null);
            this.nameTextBox.set("value", null);
            this.contentTextBox.set("value", null);
            SearchPageHelper.setComboBoxValue(this.roleComboBox, CdesVoc.MagicSelectOption.ALL);
            SearchPageHelper.setComboBoxValue(this.plannerComboBox, CdesVoc.MagicSelectOption.ALL);
            this.showDeletedCheckBox.set("checked", false);
        },

        doSearch : function() {
            this.changed = false;
            on.emit(this, "doSearch");            
        },

        setChanged : function(changed) {
            this.changed = changed;
        },            

        isChanged : function() {
            return this.changed;
        },            

        setData : function(searchModel) {
            this.searchModel = searchModel != null ? searchModel : new Object();
            this.updateWidgetsFromData();            
        },

        getSearchModel : function() {
            this.updateDataFromWidgets();
            return this.searchModel;            
        },            

        doToggleOptionalFields : function() {
            /*            
            this.optionalFieldsVisible = !this.optionalFieldsVisible;

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextPnNetworkId();
            this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotification/optionalSearchFieldsVisible", this.optionalFieldsVisible);

            this.updateOptionalFieldVisibility();
            */
        },            

        updateOptionalFieldVisibility : function() {
            /*
            if (this.optionalFieldsVisible) {
            domClass.replace(this.optionalDiv, "visible", "hidden");
            this.toggleOptionalFieldsButton.set("label", i18n.hideAdditionalSearchFieldsButtonCaption);
            this.toggleOptionalFieldsButton.set("title", i18n.hideAdditionalSearchFieldsButtonCaption);
            domClass.replace(this.topDiv, "planningNotificationSearchFullWithOptional", "planningNotificationSearchFull planningNotificationSearchReduced");
        } else {
            domClass.replace(this.optionalDiv, "hidden", "visible");                
            this.updateShowOptionalFieldsButtonCaption();
            domClass.replace(this.topDiv, "planningNotificationSearchFull", "planningNotificationSearchFullWithOptional planningNotificationSearchReduced");
        }
            on.emit(this, "titlePaneToggled");
            */
        }
    });

    DocumentSearchWidget.DateFilterType = {
        UPLOAD : "Upload",
        RELEASE : "Release"        
    };        

    return DocumentSearchWidget;
});
