/*
 * $Id: cdes-web-i18n.js 1449 2014-08-14 15:44:45Z mda $
 *
 * Copyright (C) 2016 ev-i IT GmbH
 */

////english
define(
		({
	//// General
    	datePattern : [ {component : 'year', style : 'decimal', minLength : 4}, "-",
    	                {component : 'month', style : 'decimal', minLength : 2}, '-',
    	                {component : 'date', style : 'decimal', minLength : 2}
	    ],

	    dateWithTimePattern : [ {component : 'year', style : 'decimal', minLength : 4}, "-",
	        	                {component : 'month', style : 'decimal', minLength : 2}, '-',
	        	                {component : 'date', style : 'decimal', minLength : 2}, " ",
        	                	{component : "hour", style : "decimal", length : 2}, ":",
        	                	{component : "minute", style : "decimal", length : 2}
      	],

      	dateWithSecondsPattern : [ {component : 'year', style : 'decimal', minLength : 4}, "-",
	        	                   {component : 'month', style : 'decimal', minLength : 2}, '-',
	        	                   {component : 'date', style : 'decimal', minLength : 2}, " ",
        	                	   {component : "hour", style : "decimal", length : 2}, ":",
        	                	   {component : "minute", style : "decimal", length : 2}, ":",
        	                	   {component : "second", style : "decimal", length : 2}
      	],

        nameLabel : "Name",
      	saveAndExitButtonCaption : "Save and Exit",
        saveButtonCaption : "Speichern",
      	searchButtonCaption : "Search",
      	searchOpenCaption : "Hide search field",
      	searchClosedCaption : "Show search field",

      	showAdditionalSearchFieldsButtonCaption : "Show additional search fields",
      	showNumberedAdditionalSearchFieldsButtonCaption : "Show  additional (${countActive} davon aktiv) search fields",
      	hideAdditionalSearchFieldsButtonCaption : "Hide additional search fields",
      	clearSearchFieldsButtonCaption : "Clear search fields",
      	clearSearchFieldsButtonToolTip : "Clear all search fields",

        searchBeingInitialized : "The search is being initialized...",
      	notYetSearched : "Not yet searched.",
      	searchRuns : "New search runs...",
      	searchCancelled : "Search cancelled.",

      	quickSearchLabel : "Filter",
      	quickSearchToolTip : "Filter list, without searching again.   Only the cells will be shown, that include the typed in.",
      	quickSearchClearLabel : "X",
      	quickSearchClearToolTip : "Clear filter",

      	columnOpenCaption : "Hide column options",
      	columnClosedCaption : "Show column options",

      	actionColumnCaption : "Actions",

      	editButtonCaption : "Edit",
      	showButtonCaption : "Show",
      	deleteButtonCaption : "Delete",
      	previewButtonCaption : "Preview",
      	abortButtonCaption : "Abort",
      	abortToolTip : "Abort, and do not save.",
      	skipButtonCaption : "Skip",
      	closeButtonCaption : "Close",
      	signButtonCaption : "Sign",
      	batchSignButtonCaption : "Sign folder",
      	importButtonCaption : "Import",
      	pleaseChoose : "--- Please choose ---",
        allOption : "--- all ---",
      	chooseFile : "Choose file",
      	chooseFileShort : "Choose",
      	replaceFile : "Replace file",
      	replaceFileShort : "Replace",
      	back : "Back",
      	backToolTip : "Back to previous page",
      	createButtonCaption : "Create",
      	exportToPdfButtonCaption : "Export to PDF",
      	inMonths : "in months",
		comment : "comment",

        english : "Englisch",
        german : "German",
        slovene : "Slovene",
        italian : "Italian",

      	goLeftButtonCaption : "<",
      	goRightButtonCaption : ">",

      	unused : "Currently without function.",
      	forward : "forward",
      	error : "Error",

      	uploadStatusNoFileChosen : "No file chosen.",
      	uploadStatusUploadRunning : "File ${fileName} is running...",
      	workflowStatusNotInitialized : "not initialized",
      	workflowStatusInvalidated : "Specification invalidated",

      	urlLabel : "Url",
      	oneDocument : "Plan",
      	manyDocuments : "Plans",
      	manyDocuments2 : "Plans",

        networkLabel : "Network",
        organisationLabel : "Organization",
        consortiumLabel : "Consortium",
      	commonName : "${givenName} ${surName}",
      	organisationCommonName : "${organisationName} (${personCommonName})",
      	deputyPerson : "i.b.o. ${person}",
      	deputyPersonWithOrganisation : "i.b.o. ${person} (${organisation})",
      	ownUser : "Me",
      	allUsers : "---",

        addressLabel : "Address",
        postalCodeLabel : "Postcode",
        localityNameLabel : "Location",
        countryLabel : "State",
        phoneLabel : "Telephone",
        mobileLabel : "Mobile phone",
        faxLabel : "Fax",
        mailLabel : "E-mail",
        noValidMailLabel : "Not a valid e-mail address",

      	nothing : "\u2015",
      	unknown : "unknown",
      	withoutDueDate : "without due date",

      	yes : "Yes",
      	no : "No",
      	whatever : "...",
      	and : "and",
      	all : "all",
      	ok : "ok",
      	notOk : "nor ok",
      	privilegeMissingDialogCaption : "Missing privilege",

      	searchFrom : "${label} from",
      	searchTo : "to",

      	accepted : "accepted",
      	declined : "declines",

      	maleGender : "male",
      	femaleGender : "female",
      	unknownGender : "unknown",

      	deliverDirectly : "for the attention of ${destination}",
      	passwordLabel : "Password",
      	signButtonLabel : "Sign",

      	project : "Project",
        subProject : "Sub project",
      	planner : "Planer",
      	object : "Object",
      	            objectPlanner : "Object planner",

        reviewCycleCell : "Cell",
        reviewCycleNode : "Node",

      	attachmentFileLabel : "Attachment File",

      	pdfLabel : "pdf",
      	xlsLabel : "xls",
      	portraitLabel : "portrait",
      	landscapeLabel : "landscape",

      	timeDifferencePast : "from ${difference}",
      	timeDifferenceFuture : "in ${difference}",
      	timeDifferenceToday : "Today",
      	timeDifferenceOneYear : "one Year",
      	timeDifferenceYears : "${years} years",
      	timeDifferenceOneMonth : "one month",
      	timeDifferenceMonths : "${months} moths",
      	timeDifferenceOneWeek : "one week",
      	timeDifferenceWeeks : "${weeks} weeks",
      	timeDifferenceYesterday : "Yesterday",
      	timeDifferenceTomorrow : "Tomorrow",
      	timeDifferenceDayBeforeYesterday : "The day before yesterday",
      	timeDifferenceDayAfterTomorrow : "Day after tomorrow",
        timeDifferenceDays : "${days} days",

        emailSendModeNever : "Never",
        emailSendModeBrief : "Daily summary at",
        emailSendModeAlways : "Immediately",

      	projectParticipantNameOrganisationFirst : "${organisationName} (${personSurName} ${personGivenName})",
      	projectParticipantNameOrganisationFirstwComment : "${organisationName} (${personSurName} ${personGivenName})${projectParticipationComment}",

      	gridLinesSuppressedWarningCaption : "Depiction limit exceeded",
      	gridLinesSuppressedWarningText : "From in total ${totalNumberOfTuples} found data sets ${numberOfMissingTuples} data sets are not shown for performance reasons, due to the exceedance of the  depiction limit of ${gridCellLimit} cells (column multipled by line.  You can repeat the search with stricter search criterias, or less shown columns. All found data sets will always be includes in a PDF export.",

      	resultSummaryCaption : "Implemented data bank cooperation",
      	resultSummaryContentStart : "(Dialogue is only shown due to  debug reasons)",
      	resultSummaryReceived : "Loaded from table ${table}: ${count}",
      	resultSummaryReceivedJoin : "Loaded as Join / Join-component ${table}: ${count}",
      	resultSummaryInserted : "Inserted in ${table}: ${count}",
      	resultSummaryUpdated : "Changed in ${table}: ${count}",
      	resultSummaryDeleted : "Deleted in ${table}: ${count}",

      	entries : "entries",
      	dueDateRemarkNoEntries : "No entries",
      	dueDateRemarkBeforeConstruction : "before construction",
      	dueDateRemarkWhileConstruction : "after construction",
      	dueDateRemarkDuringConstruction : "whole construction time",
      	dueDateRemarkBeforeStarting : "before commitioning",
      	dueDateRemarkAfterConstruction : "after construction",
      	dueDateRemarkInOperation : "Operating phase",
      	dueDateRemarkTillOperationApproval : "Until operating licence",

      	topicLogButtonLabel : "Write Topic-Log",
      	topicLogButtonToolTip : "Due to debug reasons write the currently registered clazzes/topic-Listener-relationships.",

      	wrongPasswordOrMissingPrivilegesMessage : "Possible reasons are a wrong passwort, or a missing licence.",

      	fileUploadNoFileSelected : "No file selected.",
      	fileUploadFileSelected : "${fileName} selected (Größe ${fileSize})",
      	fileUploadUploadingFile : "Transfer ${fileName} (Größe ${fileSize})...",
      	uploadFailed : "File upload failed.",
      	uploadFailedWrongType : "File upload failed. The selected file type is not supported. Only pdf documents without embedded attachments are allowed.",

      	networkColumnCaption : "Network",



      	//// DocumentVersion legend
      	documentVersionStatusULegendExample : "AF-BR01KI-02-0002-E00",
      	documentVersionStatusULegendLabel : "Lapse without replacement - Status U",
      	documentVersionStatusUObjectPlannerDeletedLegendLabel : "Object planner deleted - Status U",
      	documentVersionStatusXLegendExample : "AF-BR01KI-02-0002-E00",
      	documentVersionStatusXLegendLabel : "Invalid and again at test run - Status X",

      	//// PlanDeliver legend
      	planDeliverLegendChangedDates : "Entries with changed dates",
      	planDeliverLegendChangedGeneral : "Entry with general changes",
      	planDeliverLegendExample : "70-BR01-02-0002",
      	planDeliverLegendNew : "new entry",

      	//// cdes/admin/db/DBAdminPage
      	dbAdminCertificateCaButtonCaption : "Complete secondary key of certificate to Ca",
      	dbAdminLogViewerButtonCaption : "View log",
      	dbAdminLogViewerTitle : "Log",
      	dbAdminPageCaption : "Data bank sceme administration",

      	//// cdes/admin/import/ImportAdminPage
      	importAdminImporterLabel : "Plugin",
      	importAdminImporterToolTip : "Choose a plugin, that  provide a specific kind of importing datas or rather automatically adapt them.",
      	importAdminLogViewerTitle : "Log",
      	importAdminPageCaption : "Data import and adjustment ",
      	importAdminSBTNImportButtonCaption : "Import SBTN Access data bank",
      	importAdminSBTNLogViewerButtonCaption : "View log",

      	//// cdes/admin/job/JobListWidget
      	jobListAskDeleteFinishedJobDialogCaption : "Delete job from list?",
      	jobListAskDeleteFinishedJobDialogQuestion : "Do you really want to delete the job, which is executed by ${givenName} ${surName}?  This action DOES NOT have any consequences on their results, it is soley for cleaning the list.",
      	jobListAskDeletePlannedJobDialogCaption : "Really delete planned job?",
      	jobListAskDeletePlannedJobDialogQuestion : "Do you really want to delete the job planned by ${givenName} ${surName}?  The consequence will be that the job will not be executed.",
      	jobListAskDestroyJobDialogCaption : "Really cancel job?",
      	jobListAskDestroyJobDialogQuestion : "Do you really want to abort the job started at ${startTs} by ${givenName} ${surName}?",
      	jobListCreatedColumn : "Created",
      	jobListDeleteFailed : "Deleting the job has failed.",
      	jobListDeleteFinishedJob : "Delete the already executed job.  This action has no consequences on their results and is simply for cleaning the list",
      	jobListDeletePlannedJob : "Delete planned job, so it will not be executed.",
      	jobListDeleteSuccessful : "The job was successfully deleted.",
      	jobListDestroyFailed : "An error occurred while aborting the job. It is unclear if it is still running.",
      	jobListDestroySuccessful : "The job will be canceled.",
      	jobListDestroyToolTip : "Cancel this job",
      	jobListDownloadToolTip : "download file ${fileName}",
      	jobListEndTimestampColumn : "Finished at",
      	jobListExportDocumentArchive : "Creation Plan archive",
      	jobListExportDocumentsToMspType : "Export plans to MSP",
      	jobListExportPdfReportType : "Create PDF report",
      	jobListExportStatutoryDutyToMspType : "Export legal obligation to MSP",
      	jobListExportXlsReportType : "Creation XLS report",
      	jobListNetworkColumn : "Network / project",
      	jobListOrganisationPersonColumn : "Started by",
      	jobListShowToolTip : "Show job details",
      	jobListSizeColumn : "Amount datasets",
      	jobListStartTimestampColumn : "Started at",
      	jobListStateColumn : "Status",
      	jobListTypeColumn : "Job",
      	jobStateFailed : "Failed",
      	jobStateFinished : "Finished",
      	jobStateInterrupted : "Interrupted",
      	jobStateScheduled : "Scheduled",
      	jobStateStarted : "Running",

      	//// cdes/admin/job/JobPagen
      	jobListReloadButtonCaption : "Reload",
      	jobListReloadButtonToolTip : "Load current condition of jobs.",
      	jobPageCaption : "Jobs",
      	jobPageSearchSuccessful : "Loading ${count} jobs has been completed successfully.",

      	//// cdes/admin/job/JobResultPage
      	jobResultPageCaption : "Job results",
      	jobResultPageLoadFailed : "Loading the detail information of the job has failed.",
      	jobResultPageSearchSuccessful : "Loading the  detail information oft he job has been successful.",

      	//// cdes/admin/job/JobResultListPage
      	jobResultListCategoryColumn : "Result",
      	jobResultListDocumentVersionIdColumn : "Intern data bank-ID",
      	jobResultListDocumentVersionNameColumn : "Plan number",
      	jobResultListMessageColumn : "Details",

      	//// cdes/certificate/CertificateColumnWidget
      	certificateInvitationColumnLabel : "Invitation on",
      	certificateInvitationColumnToolTip : "Show date on that the invitation for the certificate was sent",
      	certificateInvitatorNameColumnLabel : "Invited by",
      	certificateInvitatorNameColumnToolTip : "Show person who sent the invitation for certificate",
      	certificateIssuerColumnLabel : "Issued by",
      	certificateIssuerColumnToolTip : "Show person who issued the certificate",
      	certificateNameColumnLabel : "Name",
      	certificateNameColumnToolTip : "Show name of person",
      	certificateNetworkColumnLabel : "Network",
      	certificateNetworkColumnToolTip : "Show network",
      	certificateOrganisationColumnLabel : "for organisation",
      	certificateOrganisationColumnToolTip : "Show organisation fitting to person",
      	certificateRequestedNameColumnLabel : "Request",
      	certificateRequestedNameColumnToolTip : "Show time period when the requirement was confirmed by clicking on the link.",
      	certificateSerialNumberColumnLabel : "Serial number",
      	certificateSerialNumberColumnToolTip : "Show serial number of certificate",
      	certificateStatusColumnLabel : "Status",
      	certificateStatusColumnToolTip : "Information to validity and licences of the certificate",
      	certificateValidColumnLabel : "Valid",
      	certificateValidColumnToolTip : "Show time in where certificate is valid",

      	//// cdes/certificate/CertificateCreateWidget
      	certificateCreateChooseFileLabel : "Choose file",
      	certificateCreateInvalidCertificate : "The renewal / issuance of the certificate is not possible, due to a lack of relevant attributes of the available data set.",
      	certificateCreatePersonLabel : "Certificate for",
      	certificateCreatePersonToolTip : "Person, for which the certificate should be issued",
      	certificateCreateSignFailed : "An error occured when signing the certificate. Possibly the transmitted password is incorrect or there already exists a valid one fort he same organization.",
      	certificateCreateSignOk : "The Certificate ${givenName} ${surName} was successfully signed and can be used now.",
      	certificateCreateUploadLabel : "Requirement-PDF",
      	certificateCreateUserCaLabel : "Used UserCA",
      	certificateCreateUserCaPasswordLabel : "Password UserCA",
      	certificateCreateUserCaPasswordToolTip : "Password for UserCA",
      	certificateCreateUserCaToolTip : "UserCA, on which base the new certificate should be issued",

      	//// cdes/certificate/CertificateInviteChooseDialog
      	certificateInviteFetchNetworksFailed : "When determining networks for the network selection, an error has occured.",
      	certificateInviteNetworkColumnCaption : "Network for which you want to invite",

      	////== CertificateList related status
      	certificateExpiredStatus : "Expired",
      	certificateInconsistentStatus : "Inconsistent",
      	certificateListInvitationStatus : "Invitation",
      	certificateListLockedStatus : "Locked",
      	certificateListNoCertificateStatus : "No Certificate",
      	certificateListRequestStatus : "Request",
      	certificateListValidExpiresSoonStatus : "Still valid",
      	certificateListValidStatus : "Valid",
      	certificateMayLoginStatus : "Login",
      	certificateMaySignStatus : "Sign",
      	certificateInvalidUserPolicy : "UP invalid",
      	certificateValidUserPolicy : "UP valid",
      	certificateNoUserPolicy : "UP missing",
      	certificatePasswordExpired : "password expired",
      	certificatePasswordWillExpire : "password will expire",

      	//// cdes/certificate/CertificateListWidget
      	certificateListAskSendConfirmationLetterDialogCaption : "Send confirmation firm: certificate request?",
      	certificateListAskSendConfirmationLetterDialogQueston : "By klicking 'OK, an E-Mail with the instruction for downloading the confirmation firm for the chosen organization will be sent. It is requested to wait for the return of this firm, before continuing with the certificate issuing of this participant with the action 'Reissue certificate with already existing requirement'.",
      	certificateListConfirmCertificateButtonCaption : "Create confirmation form certificate request",
      	certificateListConfirmCertificateButtonToolTip : "Create Confirmation form certificate request",
      	certificateListCreateDialogCaption : "Create and sign user certificate",
      	certificateListCreateSignButtonToolTip : "Issue and sign the new user certifucate.",
      	certificateListDeleteAccessButtonCaption : "Delete access",
      	certificateListDeleteAccessButtonToolTip : "Delete the access of the person belonging to the certificate",
      	certificateListDeleteInvitationButtonCaption : "Delete invitation",
      	certificateListDeleteInvitationButtonToolTip : "Delete invitation",
      	certificateListDeleteInvitationFailed : "Deleting the invitation to ${givenName} ${surName} has failed.",
      	certificateListDeleteInvitationOk : "The invitation for ${givenName} ${surName} has been successfully deleted.",
      	certificateListDeleteRequestButtonCaption : "Delete requirement",
      	certificateListDeleteRequestButtonToolTip : "Delete requirement",
      	certificateListDeleteRequestFailed : "Deleting the requirement for ${givenName} ${surName} has failed.",
      	certificateListDeleteRequestOk : "The Requirement for ${givenName} ${surName} has been successfully deleted.",
      	certificateListDownloadRequestButtonCaption : "Download requirement file",
      	certificateListDownloadRequestButtonToolTip : "Download the requirement pdf that has been filled out by the user due to the request",
      	certificateListEditPersonButtonCaption : "Edit person data",
      	certificateListEditPersonButtonToolTip : "Show and if necessary edit person's data that belongs to the certificate",
      	certificateListGetOtherCertificateFailed : "Determining of a possibly already existing certificate of the person has failed..",
      	certificateListInvalidateButtonCaption : "Lock",
      	certificateListInvalidateButtonToolTip : "Lock certificate",
      	certificateListInvalidateCertificateFailed : "An error occured when locking the certificate. Possibly is is still valid.",
      	certificateListInvalidateCertificateOk : "The certificate issued for ${organisationName} from ${givenName} ${surName} was successfull locked.",
      	certificateListInvalidateLoginFailed : "An error occured while deleting the access from person ${givenName} ${surName}.  The person might be still authorized.",
      	certificateListInvalidateLoginOk : "The access of person ${givenName} ${surName} was successfully deleted.",
      	certificateListInvitationColumnCaption : "Invited on",
      	certificateListInvitationSendAllFailed : "Error while trying to send invitation and security code for ${givenName} ${surName} to the address ${mail}.",
      	certificateListInvitationSendAllOk : "Invitation and security code for ${givenName} ${surName} were successfully sent to the address ${mail}.",
      	certificateListInvitationSendInvitationFailed : "Error while trying to send the invitation for ${givenName} ${surName} to the address ${mail}.",
      	certificateListInvitationSendInvitationOk : "The invitation for ${givenName} ${surName} has been send to the address ${mail}.",
      	certificateListInvitatorColumnCaption : "Invitation by",
      	certificateListInviteForCertificateButtonCaption : "Invite to certificate requirement",
      	certificateListInviteForCertificateButtonToolTip : "Invited certificate requirement",
      	certificateListIssueCertificateButtonCaption : "Create certificate",
      	certificateListIssueCertificateButtonToolTip : "Issue certificate",
      	certificateListIssuerColumnCaption : "Issued by",
      	certificateListMayInvalidateLoginDialogCaption : "Privilege missing",
      	certificateListMayInvalidateLoginDialogMessage : "You do not have the privilege to delete the person's access. Please check your roles.",
      	certificateListMayInvalidateLoginFailed : "By examining if the person is authorized to delete the access, an error has occurred.",
      	certificateListNameColumnCaption : "Name",
      	certificateListNetworkColumnCaption : "Network",
      	certificateListNewCertificateButtonCaption : "Reissue with already existing requirement",
      	certificateListNewCertificateButtonToolTip : "Reissue certificate with already existing requirement",
      	certificateListNoOtherCertificateCaption : "No certificate found",
      	certificateListNoOtherCertificateMessage : "No valid certificate for another organization affiliation of this person could have been found.  Therefore, the issuance of a new certificate on the basis of an already existing requirement is not possible..",
      	certificateListOrganisationColumnCaption : "for organisation",
      	certificateListRenewButtonCaption : "Renew",
      	certificateListRenewButtonToolTip : "Renew certificate",
      	certificateListRequestedColumnCaption : "Requirement on",
      	certificateListSendConformationLetterOk : "The confirmation form for requiring the certificate was successfully sent.",
      	certificateListSendConfirmationLetterFailed : "Sending the confirmation form for the certificate request has failed.",
      	certificateListSerialNumberColumnCaption : "Serial number",
      	certificateListShowDetailsButtonCaption : "Show details",
      	certificateListShowDetailsButtonToolTip : "Show details",
      	certificateListStatusColumnCaption : "Status",
      	certificateListUnlockButtonCaption : "Unlock",
      	certificateListUnlockButtonToolTip : "Unlock the certificate which is still valid .",
      	certificateListUnlockCertificateFailed : "An error occured when unblocking the certificate.  Supposedly it is not available .",
      	certificateListUnlockCertificateOk : "The certificate, which was issued for ${organisationName} , from ${givenName} ${surName} has been successfully unlocked.",
      	certificateListValidColumnCaption : "valid",
      	certificateListValidPeriod : "${from} until ${to}",
      	invalidateCertificateReallyDoDialogCaption : "Really block certificate?",
      	invalidateCertificateReallyDoQuestion : "Do you really want to block the certificate?",
      	invalidateUserLoginReallyDoDialogCaption : "Really delete access?",
      	invalidateUserLoginReallyDoQuestion : "Do you really want to delete the access of ${givenName} ${surName} ?",
      	unlockCertificateReallyDoDialogCaption : "Unlock certificate",
      	unlockCertificateReallyDoQuestion : "Do you really want to  unlock the certificate?",

      	extendChangePasswordButtonCaption : "Extend deadline",
      	extendChangePasswordButtonToolTip : "Extend the period for changing the expired password by ${amount} days",
      	extendChangePasswordOK : "The deadline for changing the expired password for ${givenName} ${surName} was extended by ${amount} days.",
      	extendChangePasswordFailed : "An error occurred while extending the deadline for changing the expired password for ${givenName} ${surName}.",
      	extendChangePasswordAskCaption : "Extend deadline",
      	extendChangePasswordAskQuestion : "Are you sure you want to extend the deadline for ${givenName} ${surName} by ${amount} days?",

      	////== Confirmation dialogs
      	certificateInvitationAskDeleteCaption : "Really delete invitation?",
      	certificateInvitationAskDeleteQuestion : "Do you really want to delete the invitation?",
      	certificateListAskForInvitationDialogCaption : "Send invitation for ivitation requirement",
      	certificateListAskForInvitationDialogQuestion : "Hereby an e-mail with the invitation for requesting the certificate will be sent to the person ${givenName} ${surName}. For the implementation of the certificate a security code is needed.  The code can either be immediately send in a seperate email or later, for example per mail.",
      	certificateListAskForInvitationAllPerMailButtonCaption : "Send invitation and security code per e-mail",
      	certificateListAskForInvitationAllPerMailButtonToolTip : "Send invitation and security codes in two seperate e-mails",
      	certificateListAskForInvitationOnlyInvitationButtonCaption : "Send invitation per e-mail",
      	certificateListAskForInvitationOnlyInvitationButtonToolTip : "Only send invitation via email.  The security code has to be send separately later, e.g. via mail.",
      	certificateRequestAskDeleteCaption : "Really delete request?",
      	certificateRequestAskDeleteQuestion : "Do you really want to delete the request?",

      	//// cdes/certificate/CertificatePage
      	certificatePageCertificates : "${certificateInfo} certificates",
      	certificatePageExpiredSearchInfo : "${numberOfExpired} expired",
      	certificatePageGetDataFailed : "Loading the certificates has failed.",
      	certificatePageInconsistentSearchInfo : "${numberOfInconsistent} inconsistent certificates",
      	certificatePageInvitationsSearchInfo : "${numberOfInvitations} invitations",
      	certificatePageNoneFoundSearchInfo : "No certificates found.  Please adjust search fields.",
      	certificatePagePersonsWithoutCertificateSearchInfo : "${numberOfPersons} persons without certificate",
      	certificatePageRequestsSearchInfo : "${numberOfRequests} requests",
      	certificatePageSearchInfo : "${tokens} found",
      	certificatePageValidSearchInfo : "${numberOfValid} valid",

        broadcastUserPolicyLabel : "Send user policy",
        broadcastUserPolicyToolTip : "Send the user policy to all active users and ask for a signed return.",
        broadcastUserPolicyConfirmationTitle : "Send user policy",
        broadcastUserPolicyConfirmationMessage : "With this action, an e-mail is sent to ALL active users of c.des with the currently valid user policy as an attachment, as well as the request to return this signed. Continue?",

      	//// cdes/certificate/CertificateRequestShowWidget
      	certificateRequestAskSendInvitationCaption : "Send invitation again?",
      	certificateRequestAskSendInvitationQuestion : "Do you want to send the invitation again?",
      	certificateRequestChallengeOneLabel : "Challenge 1 (ID)",
      	certificateRequestChallengeOneToolTip : "The security code to invitation, which is part of the link sent to the user.",
      	certificateRequestChallengeTwoLabel : "Challenge 2 (Security code)",
      	certificateRequestChallengeTwoToolTip : "The security code which will been sent to the user in a separate email and which has to be entered on the confirmation page.",
      	certificateRequestDateLabel : "Date",
      	certificateRequestDateToolTip : "Time stamp, on which the certificate invitation was created",
      	certificateRequestMailLabel : "Invitation was sent to",
      	certificateRequestMailToolTip : "E-Mail address, to which the  invitation was sent.",
      	certificateRequestPdfToolTip : "Download invitation letter as PDF",
      	certificateRequestSecurityCodeLabel : "Security code",
      	certificateRequestSendInvitationMailFailed : "Sending the invitation has failed.",
      	certificateRequestSendInvitationMailOk : "The Invitation has been sent successfully.",
      	certificateRequestSendMailAgainToolTip : "Send E-Mail again ",
      	certificateRequestShowDialogCaption : "Invitation for certificate for ${givenName} ${surName}",

      	certificateRequestUserPolicyMailLabel : "User policy was sent to",
      	certificateRequestUserPolicyMailToolTip : "E-Mail address, to which the user policy was sent.",
		certificateRequestSendUserPolicyMailAgainToolTip: "Resend email with user policy",
       	certificateRequestAskSendUserPolicyCaption: "Resend user policy?",
       	certificateRequestAskSendUserPolicyQuestion: "Do you want to resend the user policy?",
       	certificateRequestSendUserPolicyMailOk: "The user policy was sent successfully.",

      	//// cdes/certificate/CertificateSearchWidget
      	certificatePageCaption : "Certificates",

      	/*

    	Name                 Von      Gültige                Gültige, in 30 Tagen ablaufend
    	Ausgestellt für      Bis      Einladungen            Anforderungen
    	Ausgestellt durch             Abgelaufene            Personen ohne Zertifikat
    	Suchen
      	 */

      	////== First Column
      	certificateSearchIssuerLabel : "Issued by",
      	certificateSearchIssuerToolTip : "Name of the person, who issued the certificate.",
      	certificateSearchOrganisationNameLabel : "for organisation",
      	certificateSearchOrganisationNameToolTip : "Name of the organisation, which the certificate has been issued for.",
      	certificateSearchPersonNameLabel : "Name",
      	certificateSearchPersonNameToolTip : "Name of the Person, for which ther certificate is issued for.",
      	certificateSearchSearchButtonToolTip : " Search certificates or rather persons in connection with certificates",

      	////== Second Column
      	certificateSearchFromLabel : "valid from",
      	certificateSearchFromToolTip : "Only search for certificates where ist validation expires at this date or later",
      	certificateSearchNetworkLabel : "Network",
      	certificateSearchNetworkToolTip : "Network",
      	certificateSearchToLabel : "to",
      	certificateSearchToToolTip : "Only find certificates which validation expires at the date or later",

      	////== Third Column
      	certificateSearchShowExpiredLabel : "Expired",
      	certificateSearchShowExpiredToolTip : "Find expired certificates",
      	certificateSearchShowInvitationsLabel : "Invitations",
      	certificateSearchShowInvitationsToolTip : "Find invitations, which have not lead to requirement / certificate issuance",
      	certificateSearchShowValidLabel : "Valid ",
      	certificateSearchShowValidToolTip : "Find valid certificates",

      	////== Fourth Column
      	certificateSearchFetchNetworksFailed : "Loading the list of all networks (for the network selection at search fields) has failed.",
      	certificateSearchShowPersonsWithoutCertificateLabel : "Persons  without certificates",
      	certificateSearchShowPersonsWithoutCertificateToolTip : "Find persons which neither have a valid or expired certificate nor a invitation or request.",
      	certificateSearchShowRequestedLabel : "Requests",
      	certificateSearchShowRequestedToolTip : "Find requests which have not yet lead to certificate classification.",
      	certificateSearchShowValidExpiredSoonLabel : "Valid, expires in the next 30 days",
      	certificateSearchShowValidExpiredSoonToolTip : "Find valid certificates which expire in the next 30 days.",

      	/*
    	certificateSearchViewLabel : "View",
    	certificateSearchCertificateViewLabel : "Certificates",
    	certificateSearchCertificateViewToolTip : "",
    	certificateSearchRequestViewLabel : "Requests",
    	certificateSearchRequestViewToolTip : "",
    	certificateSearchInvitationsViewLabel : "Invitations",
    	certificateSearchInvitationsViewToolTip : "",
    	certificateSearchPersonsWithoutCertificateViewLabel : "People without certificate",
    	certificateSearchPersonsWithoutCertificateViewToolTip : "",
      	 */

      	//// cdes/certificate/RenewCertificateDialog
      	renewCertificateCAPasswordLabel : "Password UserCA",
      	renewCertificateCAPasswordToolTip : "The matching password for User-CA",
      	renewCertificateDialogCaption : "Demand certificate",
      	renewCertificateOrganisationLabel : "in organization",
      	renewCertificateOrganisationToolTip : "Ornagization of the person for which the certificate was issued.",
      	renewCertificatePersonLabel : "Certificate for",
      	renewCertificatePersonToolTip : "Person for which the certificate has been issued.",
      	renewCertificateSignButtonCaption : "Sign certificate",
      	renewCertificateSignButtonToolTip : "Sign certificate extension.",
      	renewCertificateUserCALabel : "Used UserCA",
      	renewCertificateUserCAToolTip : "The User-CA which aids to extend the certificate.",

      	////== Result messages
      	renewCertificateOk : "The certificate issued for ${organisationName} from ${givenName} ${surName} was successfully extended.",
      	renewCertificateGetUserCasFailedMessage : "Loading the lists of all valid UserCAs has failed.",
      	renewCertificateFailedMessage : "Result: Extending the certificate has failed. Please check your password.",

      	//// cdes/challengeLogin/ChallengeLoginPage
      	challengeLoginFacsimileLabel : "Fax: ${facsimile}",
      	challengeLoginFetchPersonDataFailed : "Loading the person's data has failed.",
      	challengeLoginJustFinishedState : "The certificate request was successfully transmitted.",
      	challengeLoginGeneratePdfFailed : "Generating the pdf form has failed.",
      	challengeLoginLoginLabel : "After the certificate is arranged, you are able to log in into the plan platform c.des.  You will be informed automatically per email.",
      	challengeLoginLoginSectionLabel : "The following data are needed for the future registration in the plan platform c.des and can be choosen freely by you.",
      	challengeLoginMailLabel : "E-Mail: ${mail}",
      	challengeLoginPageCaption : "Certification requirement ${givenName} ${surName}",
      	challengeLoginPageNoDataFound : "The certification requirement could not be found.  Has it already been deleted?",
      	challengeLoginPasswordLabel : "Password",
      	challengeLoginPasswordAnswerLabel : "Answer to security question",
      	challengeLoginPasswordAnswerToolTip : "The right answer to the chosen security question",
      	challengeLoginPasswordQuestionLabel : "Security question",
      	challengeLoginPasswordQuestionToolTip : "In case you forgot your password, you have to answer your chosen security question.",
      	challengeLoginPasswordToolTip : "Please choose your password here.",
      	challengeLoginPasswordTwoLabel : "Confirm password",
      	challengeLoginPasswordTwoToolTip : "Please retry your password.",
      	challengeLoginPdfLabel : "Pdf form ",
      	challengeLoginPleasePrintPdfLabel : "Please send following and signed Pdf form to one of the two following addresses:",
      	challengeLoginHasUserPolicyPathPleasePrintPdfLabel : "Please send the signed user policy that you received in the course of the certificate invitation back to the address given in the document.",
      	challengeLoginReceiveLabel : "When this confirmation of requesting the certificate has arrived at the administrator, your certificate will be arranged.",
      	challengeLoginHasUserPolicyPathReceiveLabel : "When this confirmation of requesting the certificate and the signed user policy has arrived at the administrator, your certificate will be arranged.",
      	challengeLoginRequestCertificateButtonLabel : "Request certificate",
      	challengeLoginRequestCertificateButtonToolTip : "Request certificate",
      	challengeLoginRequestFailed : "Creating the certificate has failed.",
      	challengeLoginSecurityQuestionSectionLabel : "Following data is needed to request a forgotten password",
      	challengeLoginUserNameLabel : "Username",
      	challengeLoginUserNameToolTip : "Please choose your username.",

      	////== Warnings
      	challengeLoginNoUserNameWarning : "Please speficy a username.",
      	challengeLoginRootWarning : "The username 'root' is not allower.",
      	challengeLoginIllegalUserNameWarning : "The username contains characters that are not allowed.  It has to start with the characters [A-Z] or [a-z], and is allowed to contain characters like [A-Z], [a-z], [0-9] such as underscores, hyphens and full stops in the further course of the password.",
      	challengeLoginPasswordMissingWarning : "Please enter a password.",
      	challengeLoginPasswordTooShortWarning : "The password must be at least ${passwordMinLength} characters long.",
      	challengeLoginPasswordLackingDiversityWarning : "The password must contain characters out of at least three of the following categories: lower case letters, upper case letters, special characters, numbers.",
      	challengeLoginPasswordsDontMatchWarning : "Both password inputs are not identical.",
      	challengeLoginNoQuestionWarning : "Please choose a security question.",
      	challengeLoginNoAnswerWarning : "Please indicate an answer to the security question.",
      	challengeLoginIllegalAnswerWarning : "The answer to the security question contains characters that are not allowed.  Allowed are [A-Z] and umlauts upper and lower case, numbers, spaces, underscores, hyphens and periods.",
      	challengeLoginUserNameAlreadyExistsWarning : "You already have a valid username. Continuing will replace the logindata. If you have additional organisations, these signature passwords will also be reset. Continue?",

      	//// cdes/newPassword/NewPasswordpage
		newPasswordIntroText: "The maximum validity period of your password is ${passwordMaxAge} days and will expire in ${passwordRemainingDays} days. You must choose a new password to continue logging in after this period. In the course of this, the security question/answer must also be selected again",
        newPasswordAdditionalInfoText: "You can also change the password under 'Settings|Access data'.",
        newPasswordOldPassword: "Password old",
        newPasswordNewPassword: "Password new",
        newPasswordNewPassword2: "Confirm password",
        newPasswordSubmitLabel: "Change password",
        newPasswordWrongPassword: "Wrong old password",
        newPasswordInvalidPassword: "Invalid password",
        newPasswordError: "An error occurred. Please try to change the password under 'Settings|Access data'.",
        newPasswordSuccess: "The password was changed successfully.",
        newPasswordNoOldPassword: "Please enter your old password",
        newPasswordNoNewPassword: "Please enter a new password",
        newPasswordNoRepeatPassword: "Please repeat the new password.",
        newPasswordPasswordMismatch: "The two password entries are not identical.",

      	//// cdes/requestUserPolicy/NewPasswordpage
		requestUserPolicyWarning: "There is a new version of user policy available.",
        rquestUserPolicyText: "You should have recently received an e-mail with the new user policy as an attachment. Please sign it and return it to the e-mail address specified in the document by ${userPolicyDeadline}. Otherwise access will be blocked after this deadline. ",
        requestUserPolicyLinkLabel: "You can download the user policy now using the following link",
        requestUserPolicyMultipleLinkLabel: "You can download ${count} user policies for your organisations now using the following link",
        requestUserPolicyUserPolicyLink: "download User policy",

        //// cdes/certificate/SetUserPolicyWidget
        setUserPolicyUploadText: "Here you can upload the user's requested signed user policy to unlock his access.",
        setUserPolicyReplaceText: "A user policy already exists. This is hereby overwritten!",
        setUserPolicyUploadLabel: "User Policy",
        setUserPolicySubmit: "Upload user policy",
      	setUserPolicyUploadError : "No certificate request found.",

        certificateListSetUserPolicyCaption: "User policy for $ {givenName} $ {surName}",
        certificateListSetUserPolicyCaption: "User policy for $ {givenName} $ {surName}",
		certificateListSetUserPolicyButtonCaption: "User Policy",
		certificateListSetUserPolicyButtonToolTip: "Upload signed user policy",

      	//// cdes/core/ApplicationContext
      	applicationContextLoadMasterDataFailed : "Loading the global meta data has failed.",

      	//// cdes/core/CdesVoc
      	pdfListLabel : "pdf in list",

      	//// cdes/document/ArchiveOptionWidget
      	archiveOptionContentLabel : "document version",
      	archiveOptionContentToolTip : "document version",
      	archiveOptionCountLabel : "Selection:",
      	archiveOptionDocumentsLabel : "${numberOfDocuments} documents",
      	archiveOptionEstimatedLabel : "Estimazed archive size:",
      	archiveOptionEstimatedSizeLabel : "${estimatedSize} MB",
      	archiveOptionFormatLabel : "File format",
      	archiveOptionFormatToolTip : "File format",
      	archiveOptionFreeSpaceLabel : "Free space:",
      	archiveOptionFreeSpaceSizeLabel : "${freeSpace} MB",
      	archiveOptionReviewHistoryCheckBoxLabel : "with review history",
      	archiveOptionReviewHistoryCheckBoxToolTip : "Include review history into the archive",
      	archiveScopeAll : "all",
      	archiveScopeAllWithHistory : "whole review history",
      	archiveScopeRecent : "only recent",
      	archiveTypeBoth : "both",
      	archiveTypeOriginal : "original",

      	//// cdes/document/DocumentCompareOverviewWidget
      	documentCompareOverviewHideToolTip : "Hide overview",
      	documentCompareOverviewRotateLeftToolTip : "Rotate plan counter clock wise by 90 degrees",
      	documentCompareOverviewRotateRightToolTip : "Rotate plan clock wise by 90 degrees",
      	documentCompareOverviewShowToolTip : "Show overview",
      	documentCompareThumbImageDisplayFailed : "The presentation of the review has failed.",
      	documentCompareThumbImageEditImageLoading : "Loading the image...",
      	documentCompareThumbImageEditNoImageLoaded : "",

      	//// cdes/document/DocumentComparePage
      	documentComparePageCaption : "Compare plan \"${baseDocumentName}\" with plan",
      	documentVersionCompareGetDocumentCompareDataFailed : "Loading the data to the plans has failed.",
      	documentVersionCompareVersionLabel : "",
      	documentVersionCompareVersionToolTip : "",

      	//// cdes/document/DocumentHelper
      	documentHelperOpenPreviewFailed : "Opening the plan preview has failed.",
      	documentReferenceAttachmentToolTip : "Open data attachment: ${originalFileName}${fileType}",

      	//// cdes/document/DocumentInvalidatePage
        documentInvalidateCaption : "Invalidate document",
        documentInvalidateLoadDataFailed : "Loading the data for the document has failed.",
        documentInvalidateSignFailed : "Signing has failed.  The document could not be invalidated.  Please verify that you have entered the correct password, and contact the administrator if necessary.",
        documentInvalidateChooseAction : "Please choose one of the following actions",
        documentInvalidateDocumentNotAvailableHint : "This option cannot be chosen, since either already reviews exist, or the document has state 'released', or the upload timestamp is more than one working day in the past.",
        documentInvalidateAsBuiltHint : "The options 'Revert upload' and 'Status X' cannot be chosen, since references to this version (e.g. from Bestandsplanung) exist.",
        documentInvalidateNoOptionsHint : "Options couldn't be calculated.",
        documentInvalidateAuthorizationLabel : "The action was agreed with the customer.",
        documentInvalidateReactivateLabel : "Reactivate previously released version.",
        documentInvalidateReactivateToolTip : "Delete this version, and reactivate the previously released version.",

      	//// cdes/document/DocumentListWidget
      	documentListDocumentComparisonToolTip : "Compare plan with previous version",
      	documentListDocumentVersionNameShowAllVersionsToolTip : "Show all versions to this document",
      	documentListDocumentVersionNameShowHideAllVersionsToolTip : "Hide all versions to this ducument",
      	documentListDownloadToolTip : "Save file locally",
      	documentListFileColumnCaption : "File",
      	documentListFormerDocumentVersionLabel : "Version ${version}",
      	documentListNameColumnCaption : "Plan number",
      	documentListNumberColumnCaption : "#",
      	documentListObjectPlannerLabel : "${objectPlannerReleaseCode} [${reviewCycleInstanceReleasedName}]",
      	documentListPreviewPdfToolTip : "PDF plan preview",
      	documentListPreviewPngToolTip : "PNG plan preview",
      	documentListReleasedVersionStillValidLabel : "(Released version still valid)",
      	documentListRequestManualPlotToolTip : "Create plot order",
      	documentListRequestOriginalToolTip : "Request original file",
      	documentListStatusColumnCaption : "Plan release [Date of release]",
      	documentListReviewStatusColumnCaption : "Review state",
      	documentListTitleColumnCaption : "Title / Content",
      	documentListUploadedColumnCaption : "Date Upload",
      	documentListWidgetGetFormerVersionsFailed : "Reloading the earlier versions has failed.",
      	documentObjectPlannerColumnCaption : "Object/-planner [review sheet]",
      	openReviewProtocolOldToolTip : "Show old review protocol",
      	openReviewProtocolToolTip : "Show review protocol",
        documentListChooseToolTip : "Choose",

      	//// cdes/document/DocumentPage
      	documentPageAnlagentypImportDialogCaption : "Indicate system types",
      	documentPageAnlagentypXlsHasErrorsCaption : "Please adjust the following points to the system type Xls:",
      	documentPageAnlagentypXlsProblemCaption : "Responses to system type-Xls",
      	documentPageAskDeleteDialogCaption : "Really delete search?",
      	documentPageAskDeleteDialogQuestion : "Do you really want to delete the search ${name} ?",
      	documentPageAskExportToMspCaption : "Really exporting to Msp?",
      	documentPageAskExportToMspMessage : "Do you really want to export the ${count} chosen plans, delayed, into the die MSP-library ${mspTitle}?  The export will start at 10 pm.  If you want that the export should be earlier executed, you can do that at the register Networks / Jobs.",
      	documentPageCaption : "Uploaded Documents",
      	documentPageCreateArchiveButtonCaption : "Create plan archive",
      	documentPageCreateArchiveDialogCaption : "Options for creating plan archive",
      	documentPageCreateButtonToolTip : "Save the content of search fields as SMH53] new search",
      	documentPageCreateRefusedMessage : "The search could not be  saved.  Please choose a name that is not used yet.",
      	documentPageCreateSearchCaption : "Save under new name ",
      	documentPageDeleteButtonToolTip : "Delete search.",
      	documentPageEditButtonToolTip : "Assume the content of the search fields into the current chosen search.",
      	documentPageEditSearchCaption : "Rename search",
      	documentPageExportArchiveFailed : "Creating the plan archive has failed.",
      	documentPageExportArchiveFinished : "The plan archive has been successfully created in ${duration}s ",
      	documentPageExportArchiveStarted : "Creating the plan archive is running...",
      	documentPageExportFailed : "Exporting the plan directory has  failed.",
      	documentPageExportToMspButtonCaption : "Export to Msp ",
      	documentPageExportToMspButtonToolTip : "Export the plans, included in the current search result, delayed while night hours to Msp.",
      	documentPageExportToPdfButtonToolTip : "Export plan directory to PDF",
      	documentPageExportToPdfStarted : "The export of the plans to PDF is running...",
      	documentPageExportToPdfFinished : "The export of the plans to PDF was successfully completed",
		documentPageExportToXlsButtonToolTip : "Export review state to XLS",
      	documentPageExportToXlsStarted : "The review status export to XLS is running...",
      	documentPageExportToXlsFinished : "Der review status export to XLS has completed successfully.",
      	documentPageGetArchiveCreateDataFailed : "Determining the needed or rather the free storage space for creating the plan archive has failed.",
      	documentPageGetInfoFailed : "Initializing the plan directory search mask has failed.",
      	documentPageLegendSampleNumber : "AF-BR01KI-02-0002-E00",
      	documentPageLoadDataFailed : "Loading the plans has failed.",
      	documentPageLoadDataRunning : "The search of the plans is running...",
      	documentPageLoadDataSuccess : "${count} plans found in ${time}s ",
//      	documentPageNewSearchButtonToolTip : "",
      	documentPageReadAndCheckAnlagentypFileFailed : "While reading the system types-XLS-file an error occured.",
      	documentPageRegisterMspExportFailed : "Registrating the nightly export of documents to Msp has failed.",
      	documentPageRegisterMspExportSuccess : "Exporting the chosen document to MSP has been successfully sceduled for the next possible date.",
      	documentPageRenameButtonToolTip : "Rename search",
      	documentPageRunMspExportNowCaption : "Msp-Export now performing",
      	documentPageRunMspExportNowFailed : "The processing of the Msp exports has failed.",
      	documentPageRunMspExportNowSuccess : "The processing of the Msp exports is completed.  Please check the results at Networks / Jobs.",
      	documentPageRunMspExportNowToolTip : "In normal operation the Msp-Export will be performed at night.  On trial installation, there is also the oppurtunity to trigger the immediate execution of all relevant tasks.",
      	documentPageJumpToBPDocListButtonCaption : "Take over plans from  ${status}",
      	documentPageJumpToBPDocListButtonToolTip : "Load plans from the referenced project status for the as-built status.",
      	documentPageJumpToBPDocListSaveButtonCaption : "Save plans from  ${status}",
      	documentPageSaveSearchButtonToolTip : "",
      	documentPageSearchLabel : "Search",
      	documentPageSearchToolTip : "Choose one search.",
      	//AsBuiltSignWidget
      	documentPageAsBuiltCaption : "Take over plans from  ${status}",
       	documentPageAsBuiltSaveLabel : "Take over unchanged",
       	documentPageAsBuiltSaveToolTip: "Take over selected plans unchanged",
       	documentPageAsBuiltSaveOnlyDocumentReferenceLabel : "Take over upload later",
       	documentPageAsBuiltSaveOnlyDocumentReferenceToolTip: "Take over selected plans and upload later",
       	documentPageAsBuiltAbortLabelToolTip : "Abort and return to Uploaded Documents",
      	documentPageAsBuiltSignFailed : "While signing the Take over of selected plans an error occurred.",
       	
      	//// cdes/document/DocumentSearchWidget
      	documentSearchContentLabel : "Title/Content",
      	documentSearchContentToolTip : "Title/Content",
      	documentSearchDateFilterReleaseType : "Release",
      	documentSearchDateFilterSelectLabel : "Type of date filter",
      	documentSearchDateFilterUploadType : "Upload",
      	documentSearchDelayOptionLabel : "Date",
      	documentSearchDelayOptionToolTip : "Date",
      	documentSearchDocumentTypeLabel : "Type of plan",
      	documentSearchDocumentTypeToolTip : "type of plan",
      	documentSearchFromLabel : "Date from",
      	documentSearchNameLabel : "Plan number",
      	documentSearchNameToolTip : "Plan number",
      	documentSearchObjectLabel : "Object/-planner",
      	documentSearchObjectPlannerLabel : "Object",
      	documentSearchIncludeObjectPlannersCheckBoxToolTip : "Objects incl. Objectplanners selectable",
      	documentSearchObjectToolTip : "Object",
      	documentSearchProjectParticipationLabel : "... responsible",
      	documentSearchProjectParticipationToolTip : "responsible",
		documentSearchReviewCycleInstanceLabel : "Review sheet",
		documentSearchReviewCycleInstanceToolTip : "Review sheet",
      	documentSearchReviewCycleLabel : "Review cycle",
      	documentSearchReviewCycleToolTip : "Review cycle",
		documentSearchRoleLabel : "With role...",
		documentSearchRoleToolTip : "Role with which the person in charge is responsible for the document",
      	documentSearchShowDeletedLabel : "Show plans of deleted object sheets",
      	documentSearchShowDeletedToolTip : "Turning on/off Show plans of deleted object sheets",
      	documentSearchStatusLabel : "Status",
      	documentSearchStatusToolTip : "The plan's status",
      	documentSearchToLabel : "Date to",

		//// cdes/document/AsBuiltSignWidget
		asBuiltSignSelectAllCheckBoxLabel : "Select all",
		asBuiltSignSelectAllCheckBoxToolTip : "Select all plans on/off",

      	//// cdes/document/RequestOriginalDocumentPage
      	requestOriginalAdditionalOrganisationsHeader : "Additional organizations",
      	requestOriginalCommentLabel : "Request",
      	requestOriginalCommentToolTip : "Request",
      	requestOriginalDocumentGetDataFailed : "Loading the necessary information (plan title, organizations) for showing the page has failed.",
      	requestOriginalDocumentPageCaption : "Request original",
      	requestOriginalNameLabel : "Plan",
      	requestOriginalOwnOrganisationHeader : "Own organisation",
      	requestOriginalRequestButtonCaption : "Request",
      	requestOriginalRequestFailed : "Requesting the original file has failed",
      	requestOriginalRequestForLabel : "Request for",
      	requestOriginalOrganisationsLabel : "chosen organisations",
      	requestOriginalOrganisationsToolTip : "chosen organisations",
      	requestOriginalPersonalLabel : "me personally",
      	requestOriginalPersonalToolTip : "me personally",

      	//// cdes/document/ReviewProtocolVersionWidget
      	reviewProtocolVersionAskDeleteDialogCaption : "Really delete document version?",
      	reviewProtocolVersionAskDeleteDialogQuestion : "Do you want to permanently and irretrievably delete the document version ${name} including all reviews?",
      	reviewProtocolVersionCommentCaption : "Revision marks and upload comment",
      	reviewProtocolVersionDateCaption : "Date",
      	reviewProtocolVersionDeleteButtonToolTip : "Delete document version irreversibly.",
      	reviewProtocolVersionDeleteFailed : "Deleting the document version has failed.",
      	reviewProtocolVersionDeleteNotPossible : "The document version ${name} can not be deleted.  Possible reasons: A subsequent version or plan is referenced by another plan.",
      	reviewProtocolVersionDeleteSuccessful : "The document version ${name} was deleted irreversibly.",
      	reviewProtocolVersionDocumentContent : "Title / Content",
      	reviewProtocolVersionDocumentName : "Plan number",
      	reviewProtocolVersionDocumentScale : "Scale",
      	reviewProtocolVersionFileCaption : "File",
      	reviewProtocolVersionFileUnchangedLabel : "(undertake unchanged)",
      	reviewProcotolVersionStatusCurrentlyReleasedVersion : "(current released version)",
      	reviewProcotolVersionStatusDeleted : "(deleted)",
      	reviewProcotolVersionStatusInReviewStillValid : "(in review \u2015 released version still valid)",
      	reviewProcotolVersionStatusInvalidNewVersionInReview : "(invalid \u2015 new version to release in review)",
      	reviewProcotolVersionStatusInvalidPreviousVersionReactivated : "(invalid \u2015 previous version reactiviated)",
      	reviewProcotolVersionStatusInvalidReplaced : "(invalid \u2015 replaced by new released version)",
      	reviewProtocolVersionUploadPersonCaption : "Upload by",
      	reviewProtocolVersionVersionCaption : "Version and alternative Plan number",
      	reviewProtocolVersionVersionInfo : "Version ${version}",

      	//// cdes/help/AboutPage
      	aboutPageCaption : "Information to this programm",
      	aboutPageDateLabel : "Date",
      	aboutPageDateToolTip : "Time, when the present release of the software was created.",
      	aboutPageImplementationContent : "ev-i Informationstechnologie GmbH, 6020 Innsbruck",
      	aboutPageImplementationLabel : "Concept and development",
      	aboutPageImplementationToolTip : "Concept and development",
      	aboutPageLoadFailed : "Loading the version information has failed.",
      	aboutPageLoadOk : "The version information has successfully loaded.",
      	aboutPageNameContent : "design coordination | management",
      	aboutPageNameLabel : "Name",
      	aboutPageNameToolTip : "Name of application",
      	aboutPageRevisionLabel : "Revision",
      	aboutPageRevisionToolTip : "Version (according to the version management system) which was used to create the present release of the software.",
      	aboutPageVersionLabel : "Version",
      	aboutPageVersionToolTip : "Release version",
      	aboutPageWebDesignLabel : "Webdesign",
      	aboutPageWebDesignToolTip : "Webdesign",
      	aboutPageWebDesignContent : "stufe2.at and mediaT",

      	//// cdes/pages/PageChooser
      	pageChooserFetchPageContextDataFailedMessage : "Loading additional files for application context has failed.",
      	pageChooserFetchPageContextFailedMessage : "Collecting the application context has failed.",
      	pageChooserOpenTabSessionFailedMessage : "Creating Cdes-sessions for the recent browser tab has failed.",

      	//// cdes/pdc/DocumentDateHistoryWidget
      	documentDateHistoryChangedColumnCaption : "changed on",
      	documentDateHistoryEndDateColumnCaption : "End date ",
      	documentDateHistoryNumberColumnCaption : "Nr.",
      	documentDateHistoryStartDateColumnCaption : "Start date",

      	//// cdes/pdc/PlanDeliverCatalogue
      	planDeliverCatalogueCaption : "Plan delivery catalog",
      	planDeliverCatalogueGetVersionsFailed : "Determining the already released plan delivery catalogue versions has failed.",
      	planDeliverCatalogueMissingPermissions : "The plan delivery catalogue cannot be displayed due to the lack of rights.",
      	planDeliverCatalogueNewEntriesCaption : "Plan delivery catalogue - Add new entries",
      	planDeliverCatalogueQuickSearchClearLabel : "X",
      	planDeliverCatalogueQuickSearchClearToolTip : "Delete filter",
      	planDeliverCatalogueQuickSearchLabel : "Filter",
      	planDeliverCatalogueQuickSearchToolTip : "Filter the list, which has been calculated in accordance with the search critera above, without searching again.",
      	planDeliverCatalogueVersionLabel : "Version",
      	planDeliverCatalogueVersionToolTip : "Here please choose one of the already released versions of the plan delivery catalogue for displayal, or change to version that is currently at editing.",
      	updatePageContextServiceFailedMessage : "Updating the page context has failed.",

      	////== Buttons
      	planDeliverCatalogueAbortEditButtonCaption : "Cancel",
      	planDeliverCatalogueAbortEditButtonToolTip : "Abort editing, and discart possible changes.",
      	planDeliverCatalogueEditButtonCaption : "Edit",
      	planDeliverCatalogueEditButtonToolTip : "Edit Sceduled date-ending date, title, scale ,and comment, (as search results) of the current plans shown in the table (as far as appropriate permissions exist)",
      	planDeliverCatalogueExportToPdfButtonCaption : "PDF",
      	planDeliverCatalogueExportToPdfButtonToolTip : "Export the whole and currently chosen version of the plan delivery catalogue to PDF.  Possibly available filter settings cannot be .",
      	planDeliverCatalogueExportToXlsButtonCaption : "XLS",
      	planDeliverCatalogueExportToXlsButtonToolTip : "Export the whole and currently chosen version of the plan delivery catalogue to XLS.",
      	planDeliverCatalogueNewButtonCaption : "New",
      	planDeliverCatalogueNewButtonToolTip : "Add new entries",

      	planDeliverCatalogueReleaseButtonCaption : "Release",
      	planDeliverCatalogueReleaseButtonToolTip : "Release the recent version of the plan delivery catalogue including possibly effected changes.",
      	planDeliverCatalogueSaveAndQuitEditButtonCaption : "Save and exit",
      	planDeliverCatalogueSaveAndQuitEditButtonToolTip : "Save, and immediately end editing.",
      	planDeliverCatalogueSaveAndReleaseButtonCaption : "Save and release",
      	planDeliverCatalogueSaveAndReleaseButtonToolTip : "Save, and immediately change to release",
      	planDeliverCatalogueSaveButtonCaption : "Save",
      	planDeliverCatalogueSaveButtonToolTip : "Save, but keep editing",

      	////== Feedback messages
      	planDeliverCatalogueManyObjectPlannersString : "${numberOfObjectPlanners} object sheets",
      	planDeliverCatalogueManyObjectsString : "${numberOfObjects} Objects",
      	planDeliverCatalogueManyPlannersString : "${numberOfPlanners} Planners",
      	planDeliverCatalogueNewDocumentsInserted : "${numberOfDocuments} new plans were successfully created.",
      	planDeliverCatalogueOneNewDocumentInserted : "A new plan was successfully created.",
      	planDeliverCatalogueOneObjectPlannerString : "Object planner ${objectPlanner}",
      	planDeliverCatalogueOneObjectString : "Object ${object}",
      	planDeliverCatalogueOnePlannerString : "Planner ${organisationName} (${personCommonName})",
      	planDeliverCatalogueReleaseInfo : "The plan delivery catalogue was sucessfully released.",
      	planDeliverCatalogueSaveFailed : "Saving the plan delivery catalogue entries has failed.",
      	planDeliverCatalogueSaveOk : "Changes on ${numberOfDocuments} plans have been successfully saved.  Due to automatic converts the number can be higher as anticipated.",
      	planDeliverCatalogueSearchFailed : "An error occured while searching the plan delivery catalogue entries",
//      	planDeliverCatalogueSearchInfo : "${numberOfDocuments} ${documentString} von ${plannerString} zu ${objectString} und ${objectPlannerString} gefunden",
      	planDeliverCatalogueSearchInfo : "${numberOfDocuments} ${documentString} from ${plannerString} to ${objectString} and ${objectPlannerString} found",
      	planDeliverDocumentNumberError: "Document ${documentName}: ${detailMessage}",
      	planDeliverHolidayError : "Dokument ${documentName}: Please choose a day that is nether a holiday nor on a weekend.",

      	//// cdes/pdc/PlanDeliverColumnWidget
      	// Widget currently unused, but might be re-introduced without much work, if needed
      	planDeliverCommentColumnLabel : "Comment",
      	planDeliverCommentColumnToolTip : "",
      	planDeliverDocumentNameColumnLabel : "Plan title",
      	planDeliverDocumentNameColumnToolTip : "",
      	planDeliverDocumentNumberColumnLabel : "Plan number",
      	planDeliverDocumentNumberColumnToolTip : "",
      	planDeliverFromColumnLabel : "Start",
      	planDeliverFromColumnToolTip : "",
      	planDeliverObjectCodeColumnLabel : "Object",
      	planDeliverObjectCodeColumnToolTip : "",
      	planDeliverObjectNameColumnLabel : "Object name",
      	planDeliverObjectNameColumnToolTip : "",
      	planDeliverObjectPlannerCodeColumnLabel : "Object planner",
      	planDeliverObjectPlannerCodeColumnToolTip : "",
      	planDeliverObjectPlannerNameColumnLabel : "Name of object planner",
      	planDeliverObjectPlannerNameColumnToolTip : "",
      	planDeliverPeriodColumnLabel : "Duration",
      	planDeliverPeriodColumnToolTip : "",
      	planDeliverPlannerOrganisationColumnLabel : "Planner (Organisation)",
      	planDeliverPlannerOrganisationColumnToolTip : "",
      	planDeliverPlannerPersonColumnLabel : "Planner (Person)",
      	planDeliverPlannerPersonColumnToolTip : "",
      	planDeliverScaleColumnLabel : "Scale",
      	planDeliverScaleColumnToolTip : "",
      	planDeliverToColumnLabel : "End",
      	planDeliverToColumnToolTip : "",

      	//// cdes/pdc/PlanDeliverListWidget
      	planDeliverCommentColumnCaption : "Comment",
      	planDeliverFromColumnCaption : "Start target [is]",
      	planDeliverFromReleaseColumnCaption : "Start target",
      	planDeliverDocumentNumberColumnCaption : "Plan number",
      	planDeliverDocumentNameColumnCaption : "Title / Content",
      	planDeliverListDateHistoryButtonLabel : "Date history",
      	planDeliverListDateHistoryButtonToolTip : "Show date history",
      	planDeliverListDateHistoryDialogCaption : "History of date of document ${document}",
      	planDeliverListDeleteButtonLabel : "Delete",
      	planDeliverListDeleteButtonToolTip : "Delete the plan.  Only possible as long as no file was uploaded.",
      	planDeliverListDeleteDocumentFailed : "Deleting the document has failed.",
      	planDeliverListDeleteDocumentOk : "The plan with the number ${documentName} and the title ${documentContent} has been successfully deleted.",
      	planDeliverListLoadMetaDataFailedMessage : "Loading the meta data for editing the plan delivery catalogue entries has failed.",
      	planDeliverListReallyDeleteDocumentCaption : "Really delete document?",
      	planDeliverListReallyDeleteDocumentText : "Do you really want to delete the document ${documentContent} with the number ${documentNumber} ?",
      	planDeliverListShowObjectPlannerButtonLabel : "Object sheet",
      	planDeliverListShowObjectPlannerButtonToolTip : "Show details to object sheet",
      	planDeliverListUploadButtonLabel : "Upload plan",
      	planDeliverListUploadButtonToolTip : "Upload the plan as pdf- or hpgl- file and initializing the review cycle.",
      	planDeliverObjectColumnCaption : "Object",
      	planDeliverObjectPlannerColumnCaption : "Object planner",
      	planDeliverPeriodColumnCaption : "Duration [is]",
      	planDeliverPlannerColumnCaption : "Planer",
      	planDeliverPlannerString : "${organisation} (${person})",
      	planDeliverScaleColumnCaption : "Scale",
      	planDeliverShortDocumentNumberColumnCaption : "#",
      	planDeliverToColumnCaption : "End target [is]",
      	planDeliverToReleaseColumnCaption : "End target",
      	planDeliverVersionString : "[Version ${versionPartA}${versionSeparator}${versionPartB} ${dateString}]",

      	////== Inline editing fields in grid
      	planDeliverListCommentTextBoxLabel : "Comment",
      	planDeliverListCommentTextBoxToolTip : "A random comment to plan",
      	planDeliverListContentTextBoxLabel : "Title/Content",
      	planDeliverListContentTextBoxToolTip : "Title of plan",
      	planDeliverListEndTextBoxLabel : "Should-End",
      	planDeliverListEndTextBoxToolTip : "Planned release of the plan",
      	planDeliverListScaleTextBoxLabel : "Scale",
      	planDeliverListScaleTextBoxToolTip : "Plan scale",
      	planDeliverListStartTextBoxLabel : "Start target ",
      	planDeliverListStartTextBoxToolTip : "Planned date of the upload (planned beginning of the review cycle)",

      	//// cdes/pdc/PlanDeliverNewWidgetn
      	planDeliverNewAbortButtonCaption : "Abort",
      	planDeliverNewAbortButtonToolTip : "Abort creating new plans, already entered data will be discarted.",
      	planDeliverNewAddButtonCaption : "Add",
      	planDeliverNewAddButtonToolTip : "Add one input line for a new plan under this one.",
      	planDeliverNewAddFiveButtonCaption : "Add five ",
      	planDeliverNewAddFiveButtonToolTip : "Add five new input lines for new plans under this one.",
      	planDeliverNewCsvImportError : "Line ${lineNumber}: ${message}",
      	planDeliverNewDefaultStatusMessage : "",
      	planDeliverNewDurationLabel : "Duration",
      	planDeliverNewDurationString : "${duration} work days",
      	planDeliverNewDurationToolTip : "The duration of the review run, prescribed by the review sheet.",
      	planDeliverNewImportButtonCaption : "CSV-Import",
      	planDeliverNewImportToolTip : "",
      	planDeliverNewObjectPlannerSelectToolTip : "After an object was chosen for the new plan, one of its object sheets can be chosen here.",
      	planDeliverNewObjectSelectToolTip : "Choose the object that should be assigned to the new plan.",
      	planDeliverNewPlannerSelectToolTip : "As the planner of the new plan, the own person will be automatically signed in.",
      	planDeliverNewRemoveButtonCaption : "Remove",
      	planDeliverNewRemoveButtonToolTip : "Remove this input line for a new plan.",
      	planDeliverNewSaveButtonCaption : "Save and exit",
      	planDeliverNewSaveButtonToolTip : "Create corresponding new plans for all input lines with filled in titles, and change back to list view of the plan delivery catalogue.",
      	planDeliverNewUploadFinishedStatus : "The file ${fileName} was successfully processed, ${numberOfDocuments} entries were imported.",
      	planDeliverNewUploadFinishedWithErrorStatus : "The processing of the file ${fileName} is completed.  ${numberOfDocuments} entries were imported, which at ${numberOfErrors} errors have occured (see previous reports in the status row).",

      	////== Columns
      	planDeliverNewCommentColumnCaption : "Comment",
      	planDeliverNewContentColumnCaption : "Title / Conent",
      	planDeliverNewEndDateColumnCaption : "End date",
      	planDeliverNewNumberColumnCaption : "Number",
      	planDeliverNewScaleColumnCaption : "Scale",
      	planDeliverNewStartDateColumnCaption : "Start date",

      	////== Messages
      	planDeliverNewLoadMetaDataFailedMessage : "Loading the Meta data for the new set up of plan delivery catalogue entries has failed.",
      	planDeliverNewNoObjectMessage : "No object found for subproject ${subProjectName}.  Please create one first.",
      	planDeliverNewNoObjectPlannerMessage : "No object sheet found for the chosen object.  Please create one first.",
      	planDeliverNewNotUniqueNumberError : "This plan number is already taken.  Please choose another.  The number ${freeNumber} would be free, for example",
      	planDeliverNewUploadFailedMessage : "Processing the file has failed.  Possibly it does not have the right format.",
      	planDeliverNewSaveFailedMessage : "Saving the new plan delivery catalogue entries has failed.",
      	planDeliverNewSaveOk : "${numberOfDocuments} new plans have been saved successfully.",
      	planDeliverNewSaveFailedDublicateNumberMessage : "Das Speichern der neuen Planlieferkatalogeinträge ist fehlgeschlagen. The plan number ${documentNumber} already exists in the object!",
      	planDeliverNewSaveFailedDublicateOtherNumberMessage : "Das Speichern der neuen Planlieferkatalogeinträge ist fehlgeschlagen. The existing plan number ${documentNumber} is not unique. Please contact the support.",

      	//// cdes/pdc/PlanDeliverReleasePage
      	planDeliverReleaseAbortButtonLabel : "Abort",
      	planDeliverReleaseAbortButtonToolTip : "Abort the release of a new plan delivery catalogue version.",
      	planDeliverReleaseGetDataFailed : "The pickup of the needed files for release has failed.",
        planDeliverReleaseGetReleaseDataFailed : "Loading the languages configured for content has failed.",
      	planDeliverReleasePageCaption : "Release plan delivery catalogue version ${version}",
      	planDeliverReleasePasswordLabel : "Password",
      	planDeliverReleasePasswordToolTip : "Password for signing the new plan delivery catalogue version",
      	planDeliverReleaseUpdateAllDocumentsCheckBoxLabel : "update all documents",
      	planDeliverReleaseUpdateAllDocumentsCheckBoxToolTip : "Releasing the plan delivery catalogue will update all documents",
      	planDeliverReleaseSignButtonLabel : "Sign",
      	planDeliverReleaseSignButtonToolTip : "Sign the new plan delivery catalogue version with a valid certificate.",
      	planDeliverReleaseSignFailed : "While releasing the plan delivery catalogue an error has occured.  It has not been released.",
      	planDeliverReleaseSignOk : "The plan delivery catalogue was successfully released.",

      	//// cdes/pdc/PlanDeliverSearchWidget
      	planDeliverSearchCommentLabel : "Comment",
      	planDeliverSearchCommentToolTip : "Only plans with this comment will be found.  A wildcard search with * is possible, upper and lower case spelling does not matter.",
      	planDeliverSearchDocumentNameLabel : "Plan title",
      	planDeliverSearchDocumentNameToolTip : "Title of plan",
      	planDeliverSearchDocumentNumberLabel : "Plan number",
      	planDeliverSearchDocumentNumberToolTip : "Search for plan number, or parts of it.  The entry 'TU03' might deliver results such as '30-TU03-01-001' and '30-TU03-01-002'.",
      	planDeliverSearchFromLabel : "Date from",
      	planDeliverSearchFromToolTip : "Beginning of period, where plans will be found.  Refers to sceduled dates.",
        planDeliverSearchRoleLabel : "With role",
        planDeliverSearchRoleToolTip : "Responsible with this role",
      	planDeliverSearchSearchButtonToolTip : "Search for plans that meet the specified search critera.  The list of results can be even further restricted immediately afterwards with the immediate filter on the right.",
      	planDeliverSearchToLabel : "to",
      	planDeliverSearchToToolTip : "End of the period where plans are found.  Refers to sceduled dates.",
      	planDeliverSearchObjectLabel : "Object",
      	planDeliverSearchObjectPlannerLabel : "Object planner",
      	planDeliverSearchObjectPlannerToolTip : "Optional selection of an object sheet or a search with free text string.  The former only if an object was chosen.  A placeholder search with * is possible.",
      	planDeliverSearchObjectToolTip : "Optional selection of an object or a search with free text string.  A placeholder search with * is possible .",
      	planDeliverSearchPlannerLabel : "Responsible",
      	planDeliverSearchPlannerToolTip : "Names of a responsible person with a fitting role, or rather the name of their organization.  Searching for a part of these names is possible.  Entering 'Me' restricts the result of the plans that one is responsible for.",
      	planDeliverSearchUnreleasedVersionString : "Unreleased Version ${version}",
      	planDeliverSearchVersionString : "Version ${version} of ${date} (${person})",

      	//// cdes/planning/notification/PlanningNotificationColumnWidget
      	planningNotificationColumnCommentLabel : "Comment",
      	planningNotificationColumnCommentToolTip : "Show comment as column",
      	planningNotificationColumnFullCaption : "Hide column settings",
      	planningNotificationColumnProjectLabel : "Project",
      	planningNotificationColumnProjectToolTip : "Show project as column",
      	planningNotificationColumnReducedCaption : "Show column settings",
      	planningNotificationColumnTitleLabel : "Notification",
      	planningNotificationColumnTitleToolTip : "Show notification name as column of the table ",

      	//// cdes/planning/notification/PlanningNotificationEditPage
      	planningNotificationEditAbortSharepointToolTip : "Abort, do not save new notification, and go back to sharepoint tree",
      	planningNotificationEditAddMultiLabel : "Add ${name}",
      	planningNotificationEditAlreadyUploaded : "File ${fileName} has already been uploaded.",
      	planningNotificationEditCommentToolTip : "Any comment to notification or document",
        planningNotificationEditCopySharepointFileFailed : "Copying the file from MSP Sharepoint to c.des failed.",
      	planningNotificationEditCreateCaption : "Create notification",
      	planningNotificationEditCreateSharepointToolTip : "Save the new notification, and go back to the notification list .",
      	planningNotificationEditCreateToolTip : "Create the new notification.  The file attachment will be saved (only) here.",
      	planningNotificationEditDeleteFileToolTip : "Delete the attached file.  The deletion will only be properly executed while saving the dialogue.",
      	planningNotificationEditDeleteMultiLabel : "Delete ${name}.",
        planningNotificationEditDuplicateBaulosError : "Multiple Bauloses with name ${baulos} were specified.  Please choose another name.",
      	planningNotificationEditEditCaption : "Edit notification",
      	planningNotificationEditFilePathLabel : "File",
      	planningNotificationEditFilePathToolTip : "Url to usually saved in sharepoint, put down file",
      	planningNotificationEditFileUploadLabel : "Path in MSP",
      	planningNotificationEditGetJoinFailed : "Loading the notification has failed.",
      	planningNotificationEditNameToolTip : "Notification respectively document title.  Attention: Entry maximum of 110 signs.",
      	planningNotificationEditNoTemplateError : "No template could been found.  Because of that, no dynamically configurated additional fields can be used.",
      	planningNotificationEditPageGetEditInfoFailed : "Loading the additional data (such as the dynamically configurated fields) has failed.",
      	planningNotificationEditProjectToolTip : "The project where the notification was created.",
        planningNotificationEditReplaceByMspButtonCaption : "Load from MSP",
        planningNotificationEditReplaceByMspButtonToolTip : "Load the file from MSP, and save it within c.des",
      	planningNotificationEditSaveFailed : "Creating or rather saving the notification has failed.",
      	planningNotificationEditSaveSharepointToolTip : "Create the new notification, and go back to the sharepoint tree.",
      	planningNotificationEditSaveSuccessful : "Notification successfully saved",
      	planningNotificationEditSaveToolTip : "Save changes on notification.  If the file attachment was replaced the change will (at first) be saved here.",
      	planningNotificationEditTitleLabel : "Notification",
      	planningNotificationEditUploadFinishedPrefix : "The file",
      	planningNotificationEditUploadFinishedPostfix : "has been successfully uploaded.  But it will be actually used after confirming the saving and after clicking the End-Button.",

      	//// cdes/planning/notification/PlanningNotificationListWidget
      	planningNotificationFileColumnCaption : "File",
      	planningNotificationListAskDeleteDialogCaption : "Really delete notification?",
      	planningNotificationListAskDeleteDialogQuestion : "Do you really want to delete the notification ${title}? Please note that an notification can only be deleted without system admin right if no guidelines with initiated fullfullment process is available.",
      	planningNotificationListCsvImportToolTip : "Import guidelines from a CSV file",
      	planningNotificationListDeleteFailed : "Deleting the notification has failed.",
      	planningNotificationListDeleteOrderToolTip : "Deleting notification respectively document.",
      	planningNotificationListDeleteSuccess : "The notification has been deleted successfully.",
      	planningNotificationListDownloadFromSharePointToolTip : "File preview from Sharepoint",
      	planningNotificationListDownloadToolTip : "File preview from c.des",
      	planningNotificationListEditToolTip : "Edit notification.",
      	planningNotificationListExtractToolTip : "Import orders directly from notification automatically.",
      	planningNotificationListImportButtonToolTip : "Import any desired amount of orders from a CSV- file.",
      	planningNotificationListImportCsvCaption : "Import orders from CSV",
      	planningNotificationListImportFromSharepointToolTip : "Import notification from Sharepoint",
      	planningNotificationListNewOrderToolTip : "Manually create orders",
      	planningNotificationListShowFromSharepointToolTip : "Show notification from Sharepoint",

      	//// cdes/planning/notification/PlanningNotificationPage
      	planningNotificationExportListFailed : "Exporting the notification list has failed.",
      	planningNotificationExportToPdfButtonToolTip : "Export notification list to pdf",
      	planningNotificationNewButtonCaption : "Add notification",
      	planningNotificationNewButtonToolTip : "All notifications, documents, etc. can be uploaded here, which contain orders for the selected project",
      	planningNotificationNewSharepointButtonCaption : "Import notification from MSP",
      	planningNotificationNewSharepointButtonToolTip : "All notifications, documents, etc. can be imported from MSP here, which contain orders for the selected project.",
      	planningNotificationPageCaption : "Notifications",
      	planningNotificationPageGetPlanningNotificationSearchInfoFailed : "Loading the additional column and project information has failed.",
      	planningNotificationPdfExportFinished : "The export of the notification list has finished successfully.",
      	planningNotificationPdfExportStarted : "The export of the notification list is running...",
      	planningNotificationSearchSuccessful : "${count} notifications loaded successfully",

      	//// cdes/planning/notification/PlanningNotificationSearchWidget
      	planningNotificationSearchCommentToolTip : "Notification comment",
      	planningNotificationSearchGetPlanningNotificationJoinsFailed : "Loading the notifications has failed.",
      	planningNotificationSearchSearchButtonToolTip : "Please observe the status columns, hide or show column settings",
      	planningNotificationSearchTitleLabel : "Notification",
      	planningNotificationSearchTitleToolTip : "Title of the notification respectively the document",
      	planningNotificationSearchMetasToolTip : "You can enter parts or several search terms separated by spaces.",
      	planningNotificationSearchToToolTip : "",

      	//// cdes/planning/notification/PlanningNotificationSharepointImportPage
      	planningNotificationSharepointImportGetMetaTagsFailed : "Loading the available meta attributes has failed.",
      	planningNotificationSharepointImportPageCaption : "Import notification from MSP",
      	sharePointLoadFolderDocumentsFinished : "${count} notifications have successfully loaded. ",
      	sharePointLoadFolderDocumentsStarted : "Loading notifications...",

      	//// cdes/planning/notification/SharepointTreeModel
      	sharePointTreeModelGetFolderDocumentsFailed : "Loading the subordinated documents and folders in Ordner im sharepoint tree has failed.",
      	sharePointTreeModelGetProjectFoldersFailed : "Loading the sharepoint folder (a tree level below the projects) has failed.",
      	sharePointTreeModelGetProjectsFailed : "Loading the sharepoint projects has failed.",

      	//// cdes/planning/order/PlanningNotificationOrderChooseDialog
      	planningNotificationOrderChooseQuickSearchLabel : "Guideline text, notification, project",
      	planningNotificationOrderChooseQuickSearchToolTip : "Scour guideline text, and project for any desired text.  Different search terms can be seperatated by commas and strung together, as e.g. 'Refuel,Semmering'",

      	//// cdes/planning/order/PlanningNotificationOrderColumnWidget
      	planningNotificationOrderColumnFullCaption : "",
      	planningNotificationOrderColumnLeadTimeLabel : "Lead time",
      	planningNotificationOrderColumnLeadTimeToolTip : "Lead time",
      	planningNotificationOrderColumnReducedCaption : "",
      	planningNotificationOrderColumnSiteTypeLabel : "System type",
      	planningNotificationOrderColumnStatutoryDutyFromLabel : "Beginning of legal obligation",
      	planningNotificationOrderColumnStatutoryDutyFromToolTip : "Beginning of legal obligation",
      	planningNotificationOrderColumnStatutoryDutyIntervalLabel : "Interval legal obligation",
      	planningNotificationOrderColumnStatutoryDutyIntervalToolTip : "Interval of legal obligation",
      	planningNotificationOrderColumnStatutoryDutyToLabel : "End of legal obligation",
      	planningNotificationOrderColumnStatutoryDutyToToolTip : "End of legal obligation",
      	planningNotificationOrderColumnTagLabel : "Key words",
      	planningNotificationOrderColumnTagToolTip : "Key words",
      	planningNotificationOrderColumnWorkflowNodeLabel : "Review definition ",
      	planningNotificationOrderColumnWorkflowNodeToolTip : "Who is in charge for what in which phase of the review cycle",

      	//// cdes/planning/order/PlanningNotificationOrderEditPage
      	planningNotificationOrderEditAddTagLabel : "Assign a new key word to the guideline",
      	planningNotificationOrderEditCreateToolTip : "Create template and go back to list",
      	planningNotificationOrderEditGetJoinFailed : "Loading the template has failed.",
      	planningNotificationOrderEditPageGetEditInfoFailed : "Loading the available options on the site (e.g. legal obligations) has failed.",
      	planningNotificationOrderEditProjectToolTip : "The project where the notification is located and the guideline is assigned to the notification.",
      	planningNotificationOrderEditReferenceLabel : "Reference",
      	planningNotificationOrderEditRemoveTagLabel : "Remove keyword",
      	planningNotificationOrderEditSaveFailed : "Saving the guideline has failed.  Your changes were not saved.",
      	planningNotificationOrderEditAskSaveDialogCaption : "Save Planning Notification Order - Notification changed",
      	planningNotificationOrderEditAskSaveDialogQuestion : "You have assigned a new Notification to the Planning Notification Order. If you continue, existing review assignments in the fulfillment process, as well as reviews already been carried out, will be assigned to the construction lots of the same name in the new notification. Missing construction lots in the new Notification will be added automatically. Continue?",
      	planningNotificationOrderEditSaveSuccessful : "The template has been successfully saved.",
      	planningNotificationOrderEditSaveToolTip : "Save the changes on the template and go back to list",
      	planningNotificationOrderEditTagLabel : "Catchword",
      	planningNotificationOrderCreateDefineWorkflowButtonCaption : "Determine creation and fullfillment process",
      	planningNotificationOrderCreateDefineWorkflowToolTip : "Create requirement, and nominate project participants for review.",
      	planningNotificationOrderSaveDefineWorkflowButtonCaption : "Save and determine fullfillment process",
      	planningNotificationOrderSaveDefineWorkflowToolTip : "Save the changes on the template and nomonate project participants for review.",

      	//// cdes/planning/order/PlanningNotificationOrderEditWidget
      	planningNotificationOrderEditAddReferenceButtonCaption : "Add reference",
      	planningNotificationOrderEditAddReferenceCaption : "Add new reference",
      	planningNotificationOrderEditCreateCaption : "Create order",
      	planningNotificationOrderEditCreateToolTip : "Create the new order",
      	planningNotificationOrderEditEditCaption : "Edit order",
      	planningNotificationOrderEditExportedToMspLabel : "Hand over requirement to MSP",
      	planningNotificationOrderEditExportedToMspToolTip : "Hand over requirement to MSP",
      	planningNotificationOrderEditLoadReferenceCandidatesFailed : "Loading the possible reference goals has failed.",
      	planningNotificationOrderEditPlanningNotificationLabel : "Notification",
      	planningNotificationOrderEditReferenceDocumentCaption : "Notification",
      	planningNotificationOrderEditSaveToolTip : "Save changes on requirement",
      	planningNotificationOrderEnvironmentallyRelevantLabel : "Enviromentally relevant",
      	planningNotificationOrderExtractAuthorizedInspectorTooltip : "Can be typed in manually",
      	planningNotificationOrderExtractDocumentPageToolTip : "The chosen page will be automatically assumed",
      	planningNotificationOrderExtractDocumentPositionTooltip : "Can be typed in manually.",
      	planningNotificationOrderInvalidateWarningCaption : "References",
      	planningNotificationOrderInvalidateWarningMessage : "You are about to transfer this guideline to the status 'Guideline to be omitted'.  Please keep in mind: As soon as you have saved this change it cannot be reversed again.",
      	planningNotificationOrderPageNumber : "Page ${page}",
      	planningNotificationOrderSiteTypeLabel : "System type",
      	planningNotificationOrderSiteTypeAddLabel : "Add system type.  Only possible, if a legal obligation is choosen.",

      	//// cdes/planning/order/PlanningNotificationOrderExtractPage
      	planningNotificationOrderExtractChooseAndAppendButtonCaption : "Attach chosen text",
      	planningNotificationOrderExtractChooseAndAppendToolTip : "Already complements chosen text at page break.",
      	planningNotificationOrderExtractChooseAndReplaceButtonCaption : "Assume chosen text",
      	planningNotificationOrderExtractChooseAndReplaceToolTip : "For this, select the desired text with the computer mouse in the notification.",
      	planningNotificationOrderExtractGoLeftToolTip : "Change to previous page",
      	planningNotificationOrderExtractGoRightToolTip : "Change to next page",
      	planningNotificationOrderExtractPageCaption : "Automatically  assume notice",
      	planningNotificationOrderExtractPageGetBoundingBoxesFailed : "The extraction of the pages of the PDF-notification has failed.",
      	planningNotificationOrderExtractPageLabel : "Page",
      	planningNotificationOrderExtractPageSelectLabel : "Page ${pageNumber}/${numberOfPages}",
      	planningNotificationOrderExtractPageToolTip : "Page selection in notification",
      	planningNotificationOrderExtractSaveAndExitButtonCaption : "Save and exit",
      	planningNotificationOrderExtractSaveAndExitToolTip : "Save and go back to main page",
      	planningNotificationOrderExtractSaveAndNextButtonCaption : "Save and assume next guideline",
      	planningNotificationOrderExtractSaveAndNextToolTip : "Save, and immediately again create a guideline",
      	planningNotificationOrderExtractTextFailed : "The extraction of the chosen texts has failed.",

      	//// cdes/planning/order/PlanningNotificationOrderExtractWidget
      	planningNotificationOrderExtractWidgetCaption : "",

      	//// cdes/planning/order/PlanningNotificationOrderImportPage
      	planningNotificationOrderImportPageCaption : "CSV import from requirements",

      	//// cdes/planning/order/PlanningNotificationOrderImportWidget
      	planningNotificationOrderImportFailed : "Importing the CSV-file has failed.",
      	planningNotificationOrderImportFailedSummaryCaption : "Import failed",
      	planningNotificationOrderImportLabel : "Please choose a file for the CSV-Import",
      	planningNotificationOrderImportResult : "The import was successfully completed.  Following numbers were created: ${serialNumbers}.",
      	planningNotificationOrderImportResultSummaryCaption : "Import has finished successfully",

      	//// cdes/planning/order/PlanningNotificationOrderListWidget
      	planningNotificationOrderListAskDeleteDialogCaption : "Really delete order?",
      	planningNotificationOrderListAskDeleteDialogQuestion : "Do you really want to delete the guideline with the serial number ${serialNumber} ? Please keep in mind that a guideline can only be deleted without system admin right if no fullfullment process is initiated to it!",
      	planningNotificationOrderListAskRemoveDialogCaption : "Really delete reference?",
      	planningNotificationOrderListAskRemoveDialogQuestion : "Do you really want to remove the reference with the running number ${serialNumber}?  The removal will take effect when saving the requirement.",
      	planningNotificationOrderListBaulosLabel : "Construction section",
      	planningNotificationOrderListDefineWorkflowToolTip : "Nominate project participants for review.",
      	planningNotificationOrderListDeleteFailed : "Deleting the order has failed.",
      	planningNotificationOrderListDeleteSuccess : "The order has been deleted successfully.",
      	planningNotificationOrderListDeleteToolTip : "Delete order",
      	planningNotificationOrderListEditToolTip : "Edit order",
      	planningNotificationOrderListNoPersonsInWorkflow : "No person assigned",
      	planningNotificationOrderListPlanningNotificationLabel : "Notification / Construction lot",
      	planningNotificationOrderListSerialNumberLabel : "Number",
      	planningNotificationOrderListStatutoryDutyLabel : "Legal obligation",

      	//// cdes/planning/order/PlanningNotificationOrderPage
      	planningNotificationOrderAskExportToMspCaption : "Really transfer guidelines to MSP?",
      	planningNotificationOrderAskExportToMspQuestionIgnoredClause : "${alreadyExportedCount} further persons also have legal obligation, but have already been exported and will therefore be ignored. ",
      	planningNotificationOrderAskExportToMspQuestionInvalidatedClause : "${orderInvalidatedCount} requirements are omitted and will also be ignored. ",
      	planningNotificationOrderAskExportToMspQuestionQuestion : "Do you want to continue?",
      	planningNotificationOrderAskExportToMspQuestionSummary : "At the moment, ${totalCount} requirements are chosen.  If you continue, ${exportCount} of these requirements will be traserred to MSP due to the registered legal obligation. ",
      	planningNotificationOrderChooseMspProjectForExportCaption : "Choose target project in MSP",
      	planningNotificationOrderExportListFailed : "Exporting the guideline list has failed.",
      	planningNotificationOrderExportToMspButtonCaption : "Export to MSP",
      	planningNotificationOrderExportToMspButtonToolTip : "Export to MSP.  Only possible, if all requirements in the search result are assinged to the same project.",
      	planningNotificationOrderExportToPdfButtonToolTip : "Export requirement list to pdf",
      	planningNotificationOrderMspExportNoneFoundCaption : "No fitting requirements for legal obligation",
      	planningNotificationOrderMspExportNoneFoundText : "None oft he chosen requirements fulfilly the terms needed for an export to MSP!  The available rights and duties have already been transferred to MSP.",
      	planningNotificationOrderMspExportFailed : "While transferringt he requirements to MSP an error occurred.",
      	planningNotificationOrderMspExportFinished : "Transferring the requirements to MSP has been successfully completed.",
      	planningNotificationOrderNewButtonCaption : "Create new order",
      	planningNotificationOrderNewButtonToolTip : "Creater orders manually",
      	planningNotificationOrderPageCaption : "Orders",
      	planningNotificationOrderPageGetJoinsFailed : "The search has failed due to technical reasons.",
      	planningNotificationOrderPageGetPlanningNotificationOrderSearchInfoFailed : "Loading the metadata that are required for the search mask has failed.",
      	planningNotificationOrderPdfExportFinished : "The export of the requirement list has been successfully completed.",
      	planningNotificationOrderPdfExportStarted : "The export of the requirement list is running...",
      	planningNotificationOrderSearchSuccessful : "${count} requirements successfully loaded",
      	planningNotificationOrderTriggerExportToMspFailed : "While trying to trigger the transfer of the requirements to MSP, an error occurred.",
      	planningNotificationOrderTriggerMspExportFinished : "The transmission oft he requirements to MSP is running...",

      	//// cdes/planning/order/PlanningNotificationOrderSearchWidget
      	planningNotificationOrderAuthorizedInspectorLabel : "Expert",
      	planningNotificationOrderAuthorizedInspectorToolTip : "The expert",
      	planningNotificationOrderBaulosLabel : "Construction lot",
      	planningNotificationOrderBaulosToolTip : "Construction lots",
      	planningNotificationOrderCommentLabel : "Comment",
      	planningNotificationOrderCommentToolTip : "Comment to order",
      	planningNotificationOrderDocumentPageLabel : "Page",
      	planningNotificationOrderDocumentPageToolTip : "Page",
      	planningNotificationOrderDocumentPositionLabel : "Imposition point",
      	planningNotificationOrderDocumentPositionToolTip : "Imposition point",
      	planningNotificationOrderEditStatutoryDutyToolTip : "If a kind of legal obligation is choosen, the dependant fields have to be filled .",
      	planningNotificationOrderInvalidatedLabel : "Requirement is dropped",
      	planningNotificationOrderInvalidatedToolTip : "Indicate, if requirement has been dropped",
      	planningNotificationOrderPersonInChargeLabel : "Person in charge for execution",
      	planningNotificationOrderPersonInChargeToolTip : "Person in charge of legal obligation after transfer / commissioning",
      	planningNotificationOrderPlanningNotificationLabel : "Notification",
      	planningNotificationOrderPlanningNotificationToolTip : "The notification with the order assigned to.",
      	planningNotificationOrderProjectLabel : "Project",
      	planningNotificationOrderProjectToolTip : "The project which the notification and the requirement is assigned to.",
      	planningNotificationOrderReferenceLabel : "Reference",
      	planningNotificationOrderSearchFullCaption : "",
      	planningNotificationOrderSearchIntervalLabel : "Intervall legal obligation",
      	planningNotificationOrderSearchIntervalToolTip : "Intervall of legal obligation, measured in months",
      	planningNotificationOrderSearchLeadTimeLabel : "Lead time",
      	planningNotificationOrderSearchLeadTimeToolTip : "lead time, in months",
      	planningNotificationOrderSearchReducedCaption : "",
      	planningNotificationOrderSearchReferenceToolTip : "List, separated by commas of running numbers of requirements which are linked with this requirement",
      	planningNotificationOrderSearchSearchButtonToolTip : "Please observe status column, hide or show column settings",
      	planningNotificationOrderSerialNumberLabel : "Lfd. number",
      	planningNotificationOrderSerialNumberToolTip : "The explicit and running number of the guideline within the project.  Will be automatically generated when saving the first time.",
      	planningNotificationOrderSearchStatutoryDutyFromFromLabel : "Beginning legal obligation",
      	planningNotificationOrderSearchStatutoryDutyFromFromToolTip : "Find reqirement, which legal obligation beginning is on this date or after",
      	planningNotificationOrderSearchStatutoryDutyFromToToolTip : "Find requirements, which legal obligation beginning is on this date or before",
      	planningNotificationOrderSearchStatutoryDutyToFromLabel : "End legal obligation",
      	planningNotificationOrderSearchStatutoryDutyToFromToolTip : "Find requirements, which ending of legal obligation is on this date or after",
      	planningNotificationOrderSearchStatutoryDutyToToToolTip : "Find requirements, which ending of legal obligation is on this date or before",
      	planningNotificationOrderSearchTagLabel : "Key words",
      	planningNotificationOrderSearchTagToolTip : "Search after one or (separated by commas) several key words",
      	planningNotificationOrderSourceLabel : "Reference",
      	planningNotificationOrderSourceToolTip : "Text field to reference other notifications and texts",
      	planningNotificationOrderStateLabel : "Status",
      	planningNotificationOrderStateToolTip : "The test status of the requirement",
      	planningNotificationOrderStatutoryDutyExpiredLabel : "Legal obligation expired",
      	planningNotificationOrderStatutoryDutyExpiredToolTip : "Legal obligation expired",
      	planningNotificationOrderStatutoryDutyLabel : "Type of legal obligation",
      	planningNotificationOrderStatutoryDutyToolTip : "Type of legal obligation",
      	planningNotificationOrderSubjectAreaLabel : "Specialist area",
      	planningNotificationOrderSubjectAreaToolTip : "The specialst area that is assigned for the requirement.",
      	planningNotificationOrderSubmitAuthorityLabel : "to submit the authority",
      	planningNotificationOrderSubmitAuthorityToolTip : "to submit the authority",
      	planningNotificationOrderTextLabel : "Guideline text",
      	planningNotificationOrderTextToolTip : "The (possibly quite detailled) context of the requirement.",

      	//// cdes/planning/project/PlanningNotificationProjectListWidget
      	planningNotificationProjectListAskDeleteProjectDialogCaption : "Really delete project?",
      	planningNotificationProjectListAskDeleteProjectDialogQuestion : "Should the project be deleted including all its data?  Please reconsider this. This decision cannot be reversed gemacht werden. At the moment only one project can be deleted if all notifications are deleted before.",
      	planningNotificationProjectListAskMakeProjectAdministratorDialogCaption : "Assign as project administrator?",
      	planningNotificationProjectListAskMakeProjectAdministratorDialogQuestion : "Do you want to register yourself as a project administator for this project, to gain rights in the context of the project?",
      	planningNotificationProjectListCodeColumn : "Abbreviations",
      	planningNotificationProjectListCommentColumn : "Comment",
      	planningNotificationProjectListDeleteProjectFailed : "Deleting the projects has failed.",
      	planningNotificationProjectListDeleteProjectFailedCaption : "Delete failed project",
      	planningNotificationProjectListDeleteProjectFailedToolTip : "The project could not be deleted. Please delete still existing notifications and try it again.",
      	planningNotificationProjectListDeleteProjectToolTip : "Delete the project including all its data (notifications and so forth)",
      	planningNotificationProjectListEditToolTip : "Edit abbreviations, name and comment of the project",
      	planningNotificationProjectListMakeProjectAdminFailed : "While trying to classify as a project admin, a technical error occurred.",
      	planningNotificationProjectListMakeProjectAdminToolTip : "To classify yourself as project admin for this project",
      	planningNotificationProjectListNameColumn : "Name",
      	planningNotificationProjectListShowProjectParticipationsToolTip : "Show list of project participants assigned for this project",

      	//// cdes/planning/project/PlanningNotificationProjectPage
      	planningNotificationProjectPageCaption : "Notification monitoring catalogue - projects",
      	planningNotificationProjectPageGetProjectsFailed : "Loding the projects has failed.",
      	planningNotificationProjectPageNewToolTip : "Create a new project",
      	planningNotificationProjectSearchSuccessful : "${count} projects successfully loaded",
      	projectPageNewLabel : "Create new project",

      	//// cdes/planning/report/PlanningNotificationReportCoverWidget
      	planningNotificationReportCoverCommentLabel : "Comment cover sheet",
      	planningNotificationReportCoverCommentToolTip : "A random report comment which shows on the cover sheet of the report.",
      	planningNotificationReportCoverPageCaption : "Cover sheet report",

      	//// cdes/planning/report/PlanningNotificationReportDataWidget
      	planningNotificationReportDataMspButtonCaption : "Create report for MSP",
      	planningNotificationReportDataMspButtonToolTip : "Create a report for export to MSP.  After creation and monitoring of the report, you can decide if the report should really be transmitted to MSP in this form.",
      	planningNotificationReportDataPageCaption : "Individual report",
      	planningNotificationReportExportStarted : "Creating the des Report is running...",
      	planningNotificationReportExportToMspRuns : "Exporting the report to MSP is running...",

      	//// cdes/planning/report/PlanningNotificationReportOptionsWidget
      	planningNotificationReportDoGenerateCaption : "Create report",
      	planningNotificationReportDoGenerateToolTip : "Create report",
      	planningNotificationReportLoadProjectsFailed : "Loading the project has failed.",
      	planningNotificationReportGotoCoverCaption : "Comment cover sheet",
      	planningNotificationReportGotoCoverToolTip : "Configurate cover sheet",
      	planningNotificationReportGotoDataCaption : "Go to data selection",
      	planningNotificationReportGotoDataToolTip : "Choose data for the individual report",
      	planningNotificationReportOptionsDataFontSizeLabel : "Font size table content",
      	planningNotificationReportOptionsFileFormatLabel : "File format",
      	planningNotificationReportOptionsFileFormatToolTip : "File format",
      	planningNotificationReportOptionsFileNameLabel : "File name",
      	planningNotificationReportOptionsFileNameToolTip : "Optional file name instead of an automatically generated file name",
      	planningNotificationReportOptionsHeaderFontSizeLabel : "Font size table heading",
      	planningNotificationReportOptionsLayoutFormatLabel : "Layout format",
      	planningNotificationReportOptionsLayoutFormatToolTip : "Layout format of review",
      	planningNotificationReportOptionsOrderStatusLabel : "Create status graphics according to requirements",
      	planningNotificationReportOptionsOrderStatusToolTip : "Create status graphics according to requirements",
      	planningNotificationReportOptionsOverallStatusLabel : "Create graphics for overall status",
      	planningNotificationReportOptionsOverallStatusToolTip : "Create graphics for overall status",
      	planningNotificationReportOptionsPageCaption : "Report options",
      	planningNotificationReportOptionsProjectLabel : "Project",
      	planningNotificationReportOptionsProjectTitle : "The created general report contains all requirements in this project",
      	planningNotificationReportOptionsTypeLabel : "Kind of report",
      	planningNotificationReportOptionsTypeTitle : "Kind of report",
      	planningNotificationReportTypeAll : "Overall report",
      	planningNotificationReportTypeIndividual : "Individual report",

      	//// cdes/planning/report/PlanningNotificationReportPage
      	planningNotificationReportBackButtonCaption : "Back",
      	planningNotificationReportBackButtonToolTip : "Back",
      	planningNotificationReportConfigPageCaption : "Creation Report",
      	planningNotificationReportCreateRefusedMessage : "The report could not be saved. Please name it with a not yet existing name.",
      	planningNotificationReportDeleteFailed : "Deleting the report has failed.",
      	planningNotificationReportDeleteLocalStorageCaption : "Delete browser data ",
      	planningNotificationReportDeleteLocalStorageSuccess : "The browser data for reporting (inter alia options, comments, searchfields such as notification or project, column setting) were deleted for this network.",
      	planningNotificationReportDeleteLocalStorageToolTip : "Deletes some data that has been temporarily stored in the browser (e.g. which project was chosen last).  This button is ONLY available in test versions.",
      	planningNotificationReportDeleteSearchButtonToolTip : "Delete report",
      	planningNotificationReportEditSearchButtonToolTip : "Rename the report",
      	planningNotificationReportForwardButtonCaption : "Next",
      	planningNotificationReportForwardButtonCaption : "Next",
      	planningNotificationReportGetSearchFailed : "Loading the report has failed.",
      	planningNotificationReportNewSearchButtonToolTip : "Create a new report. Cover sheet comment, search fields and options will be saved.",
      	planningNotificationReportOutputLocalStorageToLogCaption : "Browserdata into Log",
      	planningNotificationReportOutputLocalStorageToLogFailed : "Error while trying to write the browser data into log.",
      	planningNotificationReportOutputLocalStorageToLogSuccess : "The browser data were successfully written into the log.",
      	planningNotificationReportOutputLocalStorageToLogToolTip : "Writes some of the data that is temporarily stored in the browser (e.g. which project was chosen last) for the purpose of fault analysis.  This button is ONLY available in test versions.",
      	planningNotificationReportSaveSearchButtonToolTip : "Save edits of cover sheet comments, search fields and options of the currently chosen report",
      	planningNotificationReportSaveSuccessful : "The Report ${name} has been saved successfully.",
      	planningNotificationReportSearchLabel : "Report",
      	planningNotificationReportSearchToolTip : "Choose a report.  Cover sheet comments, search fields and options will be assumed.",
      	planningReportCreateSearchCaption : "Create new report",
      	planningReportEditSearchCaption : "Rename report",
        planningNotificationReportShowAllLabel : "Show reports of other users",
        planningNotificationReportShowAllToolTip : "Show all reports of other users, which are both accessible and located in the same network.",
      	planningReportSearchAskDeleteDialogCaption : "Really delete report?",
      	planningReportSearchAskDeleteDialogQueston : "Do you really want to delete report ${name}?",

      	//// cdes/planning/report/PlanningNotificationReportSearchEditWidget
      	planningReportSearchEditNameLabel : "Name",

      	//// cdes/planning/report/PlanningNotificationReportSearchWidget
      	planningNotificationReportSearchDueDateFromLabel : "Due date from",
      	planningNotificationReportSearchDueDateFromToolTip : "Find requirements, which at least have a due date on this date or after",
      	planningNotificationReportSearchDueDateRemarkLabel : "or",
      	planningNotificationReportSearchDueDateRemarkToolTip : "Find requirements, for which the paraphrase, dependent from the project progress is at least defined once",
      	planningNotificationReportSearchDueDateToLabel : "to",
      	planningNotificationReportSearchDueDateToToolTip : " Find requirements, which at least have a due date on this date or after",
      	planningNotificationReportSearchPositionPersonLabel : "by",
      	planningNotificationReportSearchPositionPersonToolTip : "Find requirements, for which in at least in one phase, this reviewer is assigned to.",
      	planningNotificationReportSearchShowWorkflowLabel : "Show review definition",
      	planningNotificationReportSearchShowAttachmentLabel : "Attachment",
      	planningNotificationReportSearchShowBaulosLabel : "Construction section",
      	planningNotificationReportSearchShowBaulosToolTip : "Find Construction sections assigned to a review definition. You can enter parts or several search terms separated by spaces.",
      	planningNotificationReportSearchShowIssuedLabel : "Date",
      	planningNotificationReportSearchShowResultLabel : "Result",
      	planningNotificationReportSearchShowReviewColumnsLabel : "Columns to reviews (only pdf/xls):",
      	planningNotificationReportSearchShowReviewCommentLabel : "Comment",
      	planningNotificationReportSearchShowReviewerLabel : "Reviewer",
      	planningNotificationReportSearchShowTokenInitiatorLabel : "Initiator",
      	planningNotificationReportSearchShowWorkflowNodeNameLabel : "Phase",
      	planningNotificationReportSearchShowReviewerBaulosToolTip : "Find Construction sections assigned to a review. You can enter parts or several search terms separated by spaces.",
      	planningNotificationSearchReviewSectionCaption : "Review",
      	planningNotificationSearchOrderSectionCaption : "Requirements",

      	//// cdes/planning/task/PlanningNotificationTaskColumnWidget
      	planningNotificationTaskColumnTaskToolTip : "Task",
      	planningNotificationTaskDueDateLabel : "Date",
      	planningNotificationTaskDueDateToolTip : "Date",
      	planningNotificationTaskTaskLabel : "Task",

      	//// cdes/planning/task/PlanningNotificationTaskListWidget
      	planningNotificationTaskListAskRemoveBatchDialogCaption : "Really delete review from signature folder?",
      	planningNotificationTaskListAskRemoveBatchDialogQuestion : "Do you really want to delete the review oft he requirement ${serialNumber} \"${text}\" from the signature folder?  This leads tot he situation that the review has to be executed completely again to a later date.  Possible uploaded attachments will get lost.",
      	planningNotificationTaskListAssignReviewToolTip : "Assigns review",
      	planningNotificationTaskListChooseParticipantDialogCaption : "Choose project participats",
      	planningNotificationTaskListDoReviewToolTip : "Execute review",
      	planningNotificationTaskListDropWorkflowTokenFromBatchFailed : "Removing the review from the signature folder has failed.",
      	planningNotificationTaskListDropWorkflowTokenFromBatchSuccessful : "The review has been removed from the signature folder.  It has to be executed completely again to a later date.",
      	planningNotificationTaskListReassignFailed : "While trying to transmit the task, an error occurred.",
      	planningNotificationTaskListReassignSuccessful : "The task has been successfully transferred.",
      	planningNotificationTaskListRemoveBatchToolTip : "Remove from signature folder so that the review is again available as a task.",
      	planningNotificationTaskListReviewProtocolToolTip : "Open review protocol",
      	planningNotificationTaskSelectionColumnLabel : "Selected",
      	planningTaskListSameChosenDialogCaption : "Reviewer selection",
      	planningTaskListSameChosenDialogText : "With this action no changes at the reviewer allocation will be the result (because the same person was chosen which is already allocated)",

      	//// cdes/planning/task/PlanningNotificationTaskPage
      	planningNotificationTaskExportListFailed : "Exporting the task list has failed.",
      	planningNotificationTaskExportToPdfButtonToolTip : "Export task list to PDF",
      	planningNotificationTaskPageCaption : "Tasks",
      	planningNotificationTaskPageGetJoinsFailed : "Loading the tasks has failed.",
      	planningNotificationTaskPdfExportFinished : "The export of the task list has been successfully ended, the PDF is now ready to download.",
      	planningNotificationTaskPdfExportStarted : "Exporting the task list is running ...",
      	planningNotificationTaskSearchSuccessful : "${count} tasks have successfully loaded",
      	planningNotificationTaskSearchSuccessfulMaxItems : "${count} tasks successfully loaded, for reasons of performance, only ${maxItems} are shown, but quick search etc. consider all",
      	planningNotificationTaskSelectAllCaption : "All",
      	planningNotificationTaskSelectLabel : "Select all",
      	planningNotificationTaskSelectNoneCaption : "none",
      	planningNotificationTaskSignBatchCaption : "Sign sign batch",
      	planningNotificationTaskSignBatchToolTip : "Select all tasks in the signature folder.",

      	//// cdes/planning/task/PlanningNotificationTaskSearchWidget

      	//// cdes/planning/task/ReviewPage
      	reviewPageCaption : "Review guideline ${serialNumber}",

      	//// cdes/planning/task/ReviewProtocolPage
      	reviewProtocolExportFailed : "Exporting the review protocol has failed..",
      	reviewProtocolExportToPdfToolTip : "Export review protocol to PDF.",
      	reviewProtocolGetTaskResultInfoFailed : "The pick up of the information to the tasks and reviews has failed.",
      	reviewProtocolHistoryCaption : "Past review",
      	reviewProtocolHistoryShowAllLabel : "Show all construction sections",
      	reviewProtocolOpenReviewsCaption : "Open reviews",
      	reviewProtocolPdfExportFinished : "The export of the review protocol has successfully finished.",
      	reviewProtocolPdfExportStarted : "Exporting the review protocol is running...",
        reviewProtocolPreviousOrderCaption : "Previous",
        reviewProtocolNextOrderCaption : "Next",
      	workflowReviewProtocolPageCaption : "Requirements \u2015 review protocol",

      	//// cdes/planning/task/ReviewSignListWidget
      	reviewSignListAttachmentsColumnCaption : "Attachments",
      	reviewSignListCommentColumnCaption : "Comment",
      	reviewSignListIssued : "reviewed on",
      	reviewSignListResultColumnCaption : "Result",
      	reviewSignListReviewerColumnCaption : "Reviewer",
      	reviewSignListReviewerPostfix : " i.b.o. ${personSurName} ${personGivenName}",
      	reviewSignListReviewerWithOrganisationPostfix : " i.b.o. ${personSurName} ${personGivenName} (${organisationName})",
      	reviewSignListReviewerPrefix : "${organisationName} (${personSurName} ${personGivenName})",

      	//// cdes/planning/task/ReviewSignWidget
      	reviewSignBatchSignFailed : "While signing the review results an error occurred.",
      	reviewSignBatchNoSuchFileException : "The file attachment could not be found for at least one review. Please try uploading the file again.",
      	reviewSignPasswordToolTip : "Please type in the nessesary password for signing.",
      	reviewSignSignButtonToolTip : "Sign the review result above with the typed in password.",
      	reviewSignSignFailed : "While signing the review result an error occurred.  Your data could not be saved and the tasks stays open .",
      	reviewSignNoSuchFileException : "The attachment could not be found. Please try uploading the file again.",
      	reviewSignWidgetCaption : "Approve review",

      	//// cdes/planning/task/WorkflowReviewResultWidget
      	workflowReviewResultAbortButtonToolTip : "Abort and go back to input of review result.",
      	workflowReviewResultAddForLaterSignatureFailed : "Error while trying to transfer review into signature folder.",
      	workflowReviewResultBatchButtonToolTip : "Put review into the signature folder to sign them later collectively.",
      	workflowReviewResultCaption : "My review \u2015 ${workflowNodeName} \u2015 ${construction section}",
      	workflowReviewResultCheckFileSizeFailed : "The review of the file size has failed.",
      	workflowReviewResultDeleteButton : "Remove the just uploaded file.",
      	workflowReviewResultGetSafeHtmlFailed : "Error at validating the as html typed in comment",
      	workflowReviewResultInitiatorLabel : "Construction section/Initiator",
      	workflowReviewResultInitiatorToolTip : "Construction and initiator of the review",
      	workflowReviewResultMainParticipantLabel : "responsible",
      	workflowReviewResultMainParticipantToolTip : "",
      	workflowReviewResultNoResultChosenCaption : "Please choose review result ",
      	workflowReviewResultNoResultChosenText : "Please choose one of the offered options above the sign-button for the review result, on the offered options above the signing button for the review result.",
      	workflowReviewResultSignButtonToolTip : "Immediately sign review",
      	workflowReviewResultSkipToolTip : "Skip this task, and review next",
      	workflowReviewResultTaskNumberLabel : "${taskNumber} / ${count}",
      	workflowReviewResultToNextLabel : "directly to following",

      	//// cdes/planning/template/MetaTagEditPage
      	metaTagEditCreatePageCaption : "Create Meta-Tag",
      	metaTagEditCreationFailed : "Creating the Meta-Tag has failed.",
      	metaTagEditCssClassToolTip : "On the base this prefix, new CSS for the individual masks, where the MetaTag exists, will be generated (e.g. search masks or edit dialogues).  By uploading a file of CSS rules these masks can be compiled relatively freely only by the use of CSS and without code changes.",
      	metaTagEditCssRulesLabel : "CSS rules",
      	metaTagEditCssRulesToolTip : "Here a freely selectable sentence of CSS rules can be uploaded, which should be coordinated expediently with the CSS rule prefix, which also has to be indicated.",
      	metaTagEditEditPageCaption : "Edit Meta-Tag",
      	metaTagEditLoadFailed : "Loading the metatags has failed.",
      	metaTagListMandatoryColumn : "Mandatory column",
      	metaTagEditMandatoryToolTip : "A Metatag must always be assigned a value.",
      	metaTagEditMultipleToolTip : "Indicates if more additional information of this kind can be entered",
      	metaTagEditNameToolTip : "The name of the Meta-Tag.  Will be shown in, for broader user circles visible, GUI-elements.",
      	metaTagEditPositionToolTip : "Controls the order of the attributed in the table",
      	metaTagEditShowAlwaysPriority : "Always",
      	metaTagEditShowOnRequestPriority : "Optional",
      	metaTagEditPriorityLabel : "Visibleness",
      	metaTagEditPriorityToolTip : "Controls the visibleness in search masks and the like",
      	metaTagEditSharepointReferenceToolTip : "",
      	metaTagEditTagFormatToolTip : "",
      	metaTagEditTypeToolTip : "",
      	metaTagEditUpdateFailed : "Saving the Meta-Tag has failed.",

      	//// cdes/planning/template/MetaTagListWidget
      	metaTagDateTagFormat : "Date",
      	metaTagDateTimeTagFormat : "Date and time",
      	metaTagListAskDeleteCaption : "Really delete Meta-Tag?",
      	metaTagListAskDeleteQuestion : "Do yo really want to delete the Meta-Tag?",
      	metaTagListCssClassColumn : "Prefix for Css-classes",
      	metaTagListDeleteMetaTagFailed : "Deleting the Meta-Tag has failed.",
      	metaTagListDeleteNotPossible : "The Meta-Tag could not been deleted.  It can only be deleted when not used in a notification.",
      	metaTagListDeleteToolTip : "Delete the Meta-Tag.  Only possible, if ot was not already used within an notification.",
      	metaTagListEditToolTip : "Edit Meta-Tag",
      	metaTagListMultipleColumn : "Multiple",
      	metaTagListNameColumn : "Meta-Tag",
      	metaTagListPositionColumn : "Position",
      	metaTagListSharepointReferenceNameColumn : "Sharepoint Reference",
      	metaTagListShowAlwaysPriority : "Always",
      	metaTagListShowOnRequestPriority : "Optional",
      	metaTagListTagFormatColumn : "Format",
      	metaTagListTypeColumn : "Type",
      	metaTagPlanningNotificationType : "Notification",
      	metaTagTextTagFormat : "Text",
      	metaTagWorkflowNodePositionOptionalType : "Fulfillment optional",
      	metaTagWorkflowNodePositionType : "Fulfillment date",

      	//// cdes/planning/template/PlanningNotificationTemplateEditPage
      	planningNotificationTemplateEditAbortToolTip : "Abort and discard changes on the template.  Changes on the Meta-Tags stay saved.",
      	planningNotificationTemplateEditCommentToolTip : "A random comment to meta data template",
      	planningNotificationTemplateEditCreatePageCaption : "Create template of Metadata",
      	planningNotificationTemplateEditCreateTemplateFailed : "Creating the template has failed.",
      	planningNotificationTemplateEditCreateToolTip : "Create the new template.  Meta-Tags can be added to a later point.",
      	planningNotificationTemplateEditEditPageCaption : "Edit Meta data template",
      	planningNotificationTemplateEditGetTemplateInfoFailed : "Loading the template has failed.",
      	planningNotificationTemplateEditGlobalToolTip : "",
      	planningNotificationTemplateEditMetaTagSaveHint : "Note: Meta-Tags can only be issued after the template was issued by means of the Issue-Button.",
      	planningNotificationTemplateEditNameToolTip : "Name of template",
      	planningNotificationTemplateEditNewMetaTagButtonCaption : "Add new Meta-Tag",
      	planningNotificationTemplateEditNewMetaTagButtonToolTip : "Add a new Meta-Tag to the list.  It will be saved immediately.",
      	planningNotificationTemplateEditSaveToolTip : "Save changes on the characteristics of the template.  Changes on the Meta-Tags will be saved independently of the button.",
      	planningNotificationTemplateEditUpdateTemplateFailed : "Saving the template has failed.",

      	//// cdes/planning/template/PlanningNotificationTemplateListWidget
      	planningNotificationTemplateListAskDeleteCaption : "Really delete template?",
      	planningNotificationTemplateListAskDeleteQuestion : "Do you really want to delete the template?",
      	planningNotificationTemplateListCommentColumn : "Comment",
      	planningNotificationTemplateListDeleteFailed : "Deleting the template has failed due to technical reasons.",
      	planningNotificationTemplateListDeleteNotPossible : "The template could not have been deleted.  Possibly it still contains Meta-Tags, or is already used as part of notifications.",
      	planningNotificationTemplateListDeleteToolTip : "Delete the template.  Only possible if no Meta tag is contained and not in use in any notification.",
      	planningNotificationTemplateListEditToolTip : "Edit the template and its assigned Meta-Tags",
      	planningNotificationTemplateListGlobalTemplateColumn : "Global",
      	planningNotificationTemplateListNameColumn : "Name",

      	//// cdes/planning/template/PlanningNotificationTemplatePage
      	planningNotificationTemplatePageCaption : "Meta data template for notifications",
      	planningNotificationTemplatePageGetAllFailed : "",
      	planningNotificationTemplatePageNewLabel : "Create new template",
      	planningNotificationTemplatePageNewToolTip : "Create new template, and assign its Meta-Tags.",

      	//// cdes/planning/util/PlanningNotificationHelper
      	planningNotificationHelperAskExportToMspCaption : "Really export report as MSP?",
      	planningNotificationHelperAskExportToMspMessage : "Do you really want to export the just created report to MSP?",
      	planningNotificationHelperChooseMspItemForExportCaption : "Choose library",
      	planningNotificationOrderReferenceLinkToolTip : "Open the referenced requirement",
      	planningNotificationOrderReferenceNoFollowPrivilege : "Due to the lack of rights in the concerning project, the display of the guideline is not possible.",
      	planningNotificationReportExportFailed : "Exporting the report has failed.",
      	planningNotificationReportExportFinished : "Exporting the report has been successfully completed.",
      	planningNotificationReportExportToMspFinished : "Exporting the report to Msp was successfully completed.",
      	planningNotificationReportMspExportFailed : "Exporting the report to Msp has failed.",

      	//// cdes/planning/util/PlanningNotificationTitleMultiSearchWidget
      	planningTitleAddLabel : "Add more documents to search",
      	planningTitleAddTitleLabel : "Add another document",
      	planningTitleAlterSearchLabel : "Ok",
      	planningTitleAlterSearchToolTip : "Assume the chosen documents or rather search terms into the search",
      	planningTitleRemoveTitleLabel : "Remove document from search",
      	planningTitleSearchChooseInfo : "${count} Documents/search terms chosen, for details see Tooltip",
      	planningTitleSearchComboBoxLabel : "Document",
      	planningTitleSearchComboBoxTitle : "Document title or search term for documents that is searched for",
      	planningTitleSearchConfigureTitlesCaption : "Add several documents/search terms to search",
      	planningTitleSearchInfoTextBoxLabel : "Searched documents",
      	planningTitleSearchInfoTextBoxToolTip : "Searched documents and search term; for changing the list please click right",

      	//// cdes/planning/util/PlanningTitleSearchTitleMultiContentWidget
      	planningTitleSearchTitleMultiContentWidgetCaption : "",

      	//// cdes/planning/workflow/DefineWorkflowPage
      	defineWorkflowCloseButtonToolTip : "Go back to main page.  Possible changes has been saved when approving the subdialogue.",
      	defineWorkflowGetJoinFailed : "Loading the Fulfillment process has failed.",
      	defineWorkflowInitWorkflowButtonCaption : "Initiate fulfillment process",
      	defineWorkflowInitWorkflowQuestionCaption : "Really initiate fulfillment process?",
      	defineWorkflowInitWorkflowQuestionText : "Do you really want to initiate the fulfillment process?",
      	defineWorkflowInitWorkflowToolTip : "The initiation requires the nomination of users in the roles execution and release.  The role approval of the execution is optional.",
      	defineWorkflowInitializeWorkflowFailed : "The initiation of the fulfillment process has failed due to technical reasons.",
      	defineWorkflowInitializeWorkflowNotPossibleText : "The review run could not be initiated.  Please check if the phases execution or rather release are occupied, or rather the new executives were complemented.",
      	defineWorkflowInitializeWorkflowNotPossibleTitle : "Test figures could not be initialized",
      	defineWorkflowLongPageCaption : "Fulfillment process \u2015 target ${serialNumber}",
      	defineWorkflowReInitWorkflowButtonCaption : "Again initiate fulfilment process",
      	defineWorkflowShortPageCaption : "Completion process",
      	defineWorkflowResetWorkflowToolTip : "reset process and delete all reviews and reviewers",
      	defineWorkflowResetWorkflowTitle : "reset process",
      	defineWorkflowResetWorkflowText : "Do you really want to reset process and delete all all reviews and reviewers?",
      	defineWorkflowResetWorkflowFailed : "Reseting process failed.",
      	defineWorkflowResetResultWithPositions : "Reviews and reviewers successfully deleted",
      	defineWorkflowResetResultWithoutPositions : "Reviews successfully deleted",
      	defineWorkflowResetButtonWithPositions : "Delete reviews and reviewers",
      	defineWorkflowResetButtonWithPositionsToolTip : "Reset process: deleting reviews and reviewers",
      	defineWorkflowResetButtonWithoutPositions : "Delete reviews",
      	defineWorkflowResetButtonWithoutPositionsToolTip : "Reset process: deleting reviews",

      	//// cdes/planning/workflow/DueDateEditWidget
      	dueDateEditAsDateLabel : "as date",
      	dueDateEditAsRemarkLabel : "dependant on project progress",
      	dueDateEditDueDateLabel : "Completion date",
      	dueDateEditExplicitDueDateLabel : "Explicit date",
      	dueDateEditExplicitDueDateToolTip : "Choose a concrete date as agreed date of performance",
      	dueDateEditRemarkDueDateLabel : "Relative date",
      	dueDateEditRemarkDueDateToolTip : "Choose a date, relative to the construction process (e.g. 'before commissioning')",
      	dueDateEditUpdateDueDateFailed : "Saving the edited date had failed.",

      	//// cdes/planning/workflow/OptionalDueDateEditWidget
      	optionalDueDateEditOptionalDueDateLabel : "intermediate date",
      	optionalDueDateEditOptionalDueDateToolTip : "",

      	//// cdes/planning/workflow/WorkflowActivityResultListWidget
      	workflowActivityResultListAttachment : "Attachment",
      	workflowActivityResultListBaulos : "construction section",
      	workflowActivityResultListComment : "Comment",
      	workflowActivityResultListIssued : "Date",
      	workflowActivityResultListResult : "Result",
      	workflowActivityResultListReviewer : "Reviewer",
      	workflowActivityResultListTokenInitiator : "Initiator",
      	workflowActivityResultListWorkflowNodeName : "Phase",
      	workflowActivityResultListDeleteActivityResult : "Prüfung löschen",
      	workflowActivityResultListDeleteActivityResultAskDeleteDialogQuestion : "Wollen Sie die Prüfung wirklich löschen? ACHTUNG: Es werden auch vorhandene Aufgaben gelöscht.",
      	workflowActivityResultListDeleteActivityResultFailed : "Das Löschen der Prüfung ist fehlgeschlagen.",
      	workflowActivityResultListDeleteActivityResultSuccess : "Die Prüfung wurde erfolgreich gelöscht.",

      	//// cdes/planning/workflow/WorkflowNodeEditWidget
      	workflowNodeEditForbiddenCombinationCaption : "Error Assigning Reviewer/Batch",
        workflowNodeEditForbiddenCombinationMessage : "The saving of this reviewer assignment failed. The selected combination of examiner/batch assignments probably may not be supported for technical reasons. Please check for valid combinations according to the manual.",
        workflowNodeEditMissingValidEndNodeConfigMessage : "The saving of this reviewer assignment failed. A valid entry in the release node is probably missing for the selected combination of examiner/batch assignments. Please check for valid combinations according to the manual.",
      	workflowNodeEditAlreadyExistingDialogCaption : "Reviewer already allocated",
      	workflowNodeEditAlreadyExistingDialogContentStart : "The following reviewers were already assigned to the respective construction section before the call of the dialogue was made.  The respective entries were neither complemented, nor replaced; in particular, the already existing dates were not replayed by the newly entered ones.",
      	workflowNodeEditAlreadyExistingDialogContent : "The following reviewer was already assigned before the call of the dialogue was made.  The entry was neither complemented, nor replaced.",
      	workflowNodeEditAlreadyExistingEntry : "Reviewer ${participation}, construction section ${baulos}",
      	workflowNodeEditAlreadyExistingEntryWithoutMeta : "Reviewer ${participation}",
      	workflowNodeEditCaption : "${position}. Phase \u2015 ${name}",
      	workflowNodeEditAddParticipantButtonCaption : "Add reviewer",
      	workflowNodeEditAddParticipantButtonToolTip : "Add the chosen person as a reviewer.  This change will be saved immediately.",
      	workflowNodeEditAddParticipantDialogCaption : "Add reviewer",
      	workflowNodeEditAddWorkflowNodePositionsFailed : "Saving the new reviewer allocation has failed.  Your entries could have not been saved.",
      	workflowNodeEditGetParticipationJoinsFailed : "Loading the possible project participants has failed.",
      	workflowNodeEditMultipleMandatoryTitle : "Here any number of reviewers can be nominated, but it has to be at least one.",
      	workflowNodeEditMultipleTitle : "Here any number of reviewers can be nominated.",
      	workflowNodeEditNewButtonToolTip : "Add reviewer",
      	workflowNodeEditSingleMandatoryTitle : "Here exactly one reviewer has to be nominated.",
      	workflowNodeEditSingleTitle : "Here a maximum of one reviewer can be nominated.",

      	//// cdes/planning/workflow/WorkflowNodeParticipantChooseDialog
      	workflowNodeParticipantChooseBaulosColumnCaption : "Construction section",
      	workflowNodeParticipantChooseParticipantColumnCaption : "Project participants",

      	//// cdes/planning/workflow/WorkflowNodePositionListWidget
      	workflowNodePositionListAskDeleteDialogCaption : "Delete reviewer?",
      	workflowNodePositionListAskDeleteDialogQuestion : "Do you really want to delete reviewer ${participant}?",
      	workflowNodePositionListAskDeleteWithTaskDialogQuestion : "Caution: Existing task will be deleted!",
      	workflowNodePositionListAskDeleteWithTaskMoveDialogQuestion : "Caution: Existing task will be deleted and moved to the next node!",
        workflowNodePositionListAskReinitDialogCaption : "Restart review?",
        workflowNodePositionListAskReinitDialogQuestion : "Do you really want to restart the already finished review, done by ${participant}?",
      	workflowNodePositionListAskReplaceDialogCaption : "Replace reviewer?",
      	workflowNodePositionListAskReplaceDialogQuestion : "Do you really want to replace reviewer ${participant}? By continuing, you can choose a new person that takes on the task of this reviewer.",
      	workflowNodePositionListBaulosColumn : "Construction section",
      	workflowNodePositionListDeleteBlockedCaption : "Deleting not allowed",
      	workflowNodePositionListDeleteBlockedText : "The reviewer must not be removed because the review is already too advanced.",
      	workflowNodePositionListDeleteNoReleasePosition : "No reviewer assigned to the release node.",
      	workflowNodePositionListDeleteNoReleasePositionForBaulos : "The reviewer cannot be deleted, because there are reviewers in previous nodes for the same construction section or the reviewer of this node is responsible for all construction sections.",
      	workflowNodePositionListDeleteTokenAtReleasePosition : "There are existing tasks for the reviewer and therefore cannot be deleted.",
      	workflowNodePositionListDeleteTokenCouldNotBeMoved : "Task could not be moved to next node.",
      	workflowNodePositionListDeleteHasAllreadyResult : "There are existing review results and therefore the reviewer cannot be deleted.",
      	workflowNodePositionListDeletePositionFailed : "Deleting the reviewer has failed due to technical reasons.",
      	workflowNodePositionListDeleteProjectToolTip : "Delete project participants",
      	workflowNodePositionListDueDateColumn : "Completion date",
        workflowNodePositionListReinitBlockedCaption : "Restarting the review not possible",
        workflowNodePositionListReinitBlockedText : "Restarting the review was not possible.  Restarting is only possible, if the review as already finished, and if currently in no phase of the review process, any open review exists.",
        workflowNodePositionListReinitFailed : "Restarting the review failed for unknown technical reasons.",
        workflowNodePositionListReinitToolTip : "Restart the review for this reviewer",
        workflowNodePositionListRestoreToolTip : "Restore the review for this reviewer",
      	workflowNodePositionListReplaceParticipantDialogCaption : "Replace reviewer",
      	workflowNodePositionListReplaceParticipantButtonCaption : "Replace reviewer",
      	workflowNodePositionListReplaceParticipantButtonToolTip : "Replace the old reviewer with the chosen person.  This change will be saved immediately.",
      	workflowNodePositionListReplaceProjectToolTip : "Replace project participant with someone else",
      	workflowNodePositionListReplaceWorkflowNodePositionsFailed : "Saving the new reviewer assignment has failed.  Your entries could not be saved.",
      	workflowNodePositionListDeleteOptionalDueDateToolTip : "Delete intermediate date ",
      	workflowNodePositionListEditDueDateCaption : "Edit completion date",
      	workflowNodePositionListEditDueDateToolTip : "Edit completion date",
      	workflowNodePositionListEditOptionalDueDateCaption : "Edit intermediate deadline",
      	workflowNodePositionListEditOptionalDueDateToolTip : "Edit intermediate deadline",
      	workflowNodePositionListNewDueDateCaption : "Add completion date",
      	workflowNodePositionListNewDueDateToolTip : "With this function a date for a review can be defined. The reviewer will be invited per mail.",
      	workflowNodePositionListNewOptionalDueDateCaption : "Add intermediate deadline",
      	workflowNodePositionListNewOptionalDueDateToolTip : "With this function an intermediate deadline can be defines for a current review. The reviewer will be invited per mail.",
      	workflowNodePositionListOptionalDueDateColumn : "Intermediate deadline",
      	workflowNodePositionListProjectParticipantColumn : "Project participants",

      	//// cdes/plot/PlotHelper
      	plotColorInColor : "Color",
      	plotColorLikeTemplate : "as displayed",
      	plotColorMonochrome : "s/w",
      	plotMarginFoldWithEdge : "Fold with 20mm edge",
      	plotMarginFoldWithoutEdge : "Fold without edge",
      	plotMarginNotFold : "Not fold",
      	plotPaperQualityInkjet80 : "Inkjet 80g/m²",
      	plotPaperQualityInkjet90 : "Inkjet 90g/m²",
      	plotPaperQualityLaser80 : "Laserplot 80g/m²",
      	plotPaperQualityLaser90 : "Laserplot 90g/m²",
      	plotScaleA0 : "A0",
      	plotScaleA1 : "A1",
      	plotScaleA2 : "A2",
      	plotScaleA3 : "A3",
      	plotScaleA4 : "A4",
      	plotScaleNone : "None",

      	//// cdes/plot/PlotOrderChargePage
      	plotOrderChargeAbortButtonToolTip : "Abort the charging of the plot orders.",
      	plotOrderChargeGetDataFailed : "Loading the plot orders, which have to be charged, has failed.",
      	plotOrderChargeGetDataOk : "Data for ${numberOfPlotOrders} plot orders to be charged have successfully loaded.",
      	plotOrderChargePageCaption : "Charging of plot orders",
      	plotOrderChargePasswordToolTip : "Password for marking plotorders as charged",
      	plotOrderChargeSignButtonToolTip : "Declare the plot orders as charged and sign them with an own, valid certificate.",
      	plotOrderChargeSignFailed : "The attempt to declare the plot orders as charged has failed.",
      	plotOrderChargeSignOk : "${numberOfPlotOrders} Plot orders has been successfully declared as charged.",
      	plotOrderChargeSubCaption : "Declare the plot orders below as charged",

      	//// cdes/plot/PlotOrderEditPage
      	plotOrderEditMultipleReceiptsCaption : "Delivery notes",
      	plotOrderEditMultipleReceiptsQuestionCaption : "Collected download",
      	plotOrderEditMultipleReceiptsQuestionContent : "This plot order contains several delivery addresses for which seperate delivery notes has to be created. These can be downloaded in the form of a compacted ZIP archive. If you continue you will be navigated to an overview site for collective downloads, where you have to select \'Save File\' at the corresponding plot order.  Do you want to continue?",
      	plotOrderEditOneReceiptCaption : "Delivery note",
      	plotOrderEditPageCaption : "Plot order",
      	plotOrderEditPageExportReceiptButtonCaption : "Delivery note",
      	plotOrderEditPageExportReceiptButtonToolTip : "Download delivery note.",
      	plotOrderEditPageExportToPdfButtonCaption : "Export to PDF",
      	plotOrderEditPageExportToPdfButtonToolTip : "Export this plot order to PDF.",

      	//// cdes/plot/PlotOrderEditWidget
      	plotOrderEditBillingAddressLabel : "Billing adress: see client",
      	plotOrderEditClientCodeLabel : "Client code: ",
      	plotOrderEditCommentLabel : "Additional information: ",
      	plotOrderEditCompletionComment : "Comment: ${comment}",
      	plotOrderEditCompletionDecision : "Decision: ${decision}",
      	plotOrderEditCompletionPerson : "on ${date} by ${person}",
      	plotOrderEditDeliveryDateLabel : "Delivery date:",
      	plotOrderEditGetDataFailed : "Loading the files from plot order has failed.",
      	plotOrderEditGetDataOk : "Detail information to plot order with ${numberOfItems} plot positions has successfully loaded.",
      	plotOrderEditItemCaption : "Ordered positions",
      	plotOrderEditJobNumberLabel : "Job number: ",
      	plotOrderEditKindOfDeliveryLabel : "Kind of delivery: ",
      	plotOrderEditNetworkLabel : "Network: ${networkName}",
      	plotOrderEditOrderCompletionCaption : "Order completion",
      	plotOrderEditOrderConfirmationCaption : "Order confirmation",
      	plotOrderEditOrderReceiptCaption : "Incoming orders",
      	plotOrderEditProjectLabel : "Project: ${projectCode} ${projectName}",
      	plotOrderEditReceiptPerson : "on ${date} by ${person}",
      	plotOrderEditReceiptDecision : "Decision: ${decision}",
      	plotOrderEditReceiptComment : "Comment: ${comment}",
      	plotOrderEditRequestCreatedLabel : "Date: ",

      	//// cdes/plot/PlotOrderItemListWidget
      	plotOrderItemListAreaColumnCaption : "Area",
      	plotOrderItemListAreaLabel : "${area} m²",
      	plotOrderItemListAreaSum : "Area sum",
      	plotOrderItemListPagesColumnCaption : "Pages",
      	plotOrderItemListAsDisplayedLabel : "As displayed",
      	plotOrderItemListAutomaticallyGeneratedLabel : "Automatically generated by review node \"${reviewCycleNodeName}\"",
      	plotOrderItemListBlackWhiteLabel : "S/W",
      	plotOrderItemListBlackWhiteSumLabel : "S/W ${area} m²",
      	plotOrderItemListColorColumnCaption : "Color",
      	plotOrderItemListColorLabel : "Color",
      	plotOrderItemListColorSumLabel : "Color ${area} m²",
      	plotOrderItemListCountColumnCaption : "Amount",
      	plotOrderItemListCountLabel : "${count} pieces",
      	plotOrderItemListDeleteButtonToolTip : "Delete this position of the plot order.  Only possible as long as the plot order has not been accepted.",
      	plotOrderItemListDeleteItemFailed : "Deleting the plot position has failed.",
      	plotOrderItemListDeleteItemOk : "The plot position for the plan with the number ${documentName} and the title ${documentContent} was successfully deleted.",
      	plotOrderItemListDeliveryColumnCaption : "Delivery to",
      	plotOrderItemListDocumentNumberColumnCaption : "Plan number",
      	plotOrderItemListItemLabel : "${item}: ${area} m²",
      	plotOrderItemListLikeTemplateSumLabel : "as shown ${area} m²",
      	plotOrderItemListManuallyGeneratedLabel : "Manually generated by ${personName}",
      	plotOrderItemListMarginColumnCaption : "Margin",
      	plotOrderItemListMirrorColumnCaption : "Mirror",
      	plotOrderItemListPaperColumnCaption : "Paper",
      	plotOrderItemListPreviewButtonToolTip : "Oper preview",
      	plotOrderItemListPreviewTitle : "Plan ${documentName}",
      	plotOrderItemListReallyDeleteCaption : "Really delete plot position?",
      	plotOrderItemListReallyDeleteText : "Do you really want to delete the plot position for the plan ${documentName} with the number ${documentNumber}?",
      	plotOrderItemListReceivedColumnCaption : "recieved",
      	plotOrderItemListReceiverAddress : "${organisationName}<br>z.Hd. ${personCommonName}<br>${organisationPostalAddress}<br>${organisationPostalCode} ${organisationLocalityName}<br>${opCountryDescDe}",
      	plotOrderItemListScaleColumnCaption : "Scale",
      	plotOrderItemListTotalSumLabel : "Total area ${area} m²",
      	plotOrderItemListTypeColumnCaption : "Type",
      	plotOrderItemListPagesSumLabel : "Pages ${pages}",

      	//// cdes/plot/PlotOrderPage
      	plotOrderPageCaption : "Plot orders",
      	plotOrderPageDeclareSelectedChargedButtonCaption : "Declare as cleared",
      	plotOrderPageDeclareSelectedChargedButtonToolTip : "Declare all below, selected and completely received plot orders as cleared",
      	plotOrderPageExportToPdfButtonCaption : "Export as PDF",
      	plotOrderPageExportToPdfButtonToolTip : "Export the list of plot orders below as PDF.",
      	plotOrderPageLoadFailed : "Loading the plot orders has failed.",
      	plotOrderPageLoadOk : " ${numberOfPlotOrders} plot orders have loaded successfully.",

      	//// cdes/plot/PlotOrderListWidget
      	plotOrderListAllOk : "all ok",
      	plotOrderListChargedColumnCaption : "Charged",
      	plotOrderListChargeNothingSelectedCaption : "No plot order choosen",
      	plotOrderListChargeNothingSelectedMessage : "Please choose the plot orders by selecting them in the list below.",
      	plotOrderListContractorColumnCaption : "Contractor",
      	plotOrderListCreationColumnCaption : "Erstellt",
      	plotOrderListCustomerColumnCaption : "Client",
      	plotOrderListDeclinedState : "declined",
      	plotOrderListDeleteFailed : "Deleting the plot order has failed.",
      	plotOrderListDeleteOk : "The plot order with the order number ${jobNumber} was successfully deleted.",
      	plotOrderListDeliveredAmountColumnCaption : "Delivery",
      	plotOrderListDeliveryColumnCaption : "Completed",
      	plotOrderListExportStarted : "Exporting the plot order list is running...",
      	plotOrderListExportFinished : "Exporting the plot order list successfully finished.",
      	plotOrderListExportFailed : "Exporting the plot order list has failed.",
      	plotOrderListExportPlotOrderStarted : "Exporting the plot order to ZIP-Archiv is running...",
      	plotOrderListExportPlotOrderFinished : "Exporting the plot order to ZIP-Archiv successfully finished.",
      	plotOrderListExportPlotOrderFailed : "Exporting the plot order to ZIP-Archiv has failed.",
      	plotOrderListNotOk : "not ok",
      	plotOrderListNotOkState : "not ok",
      	plotOrderListOkState : "ok",
      	plotOrderListOrderNumberColumnCaption : "job number",
      	plotOrderListReceiptColumnCaption : "Accepted",
      	plotOrderListReceivedState : "accepted",
      	plotOrderListSomeOk : "${ok}/${notOk}",

      	////== Buttons
      	plotOrderListChargeButtonCaption : "Declare as cleared",
      	plotOrderListChargeButtonToolTip : "Declare this plot order as cleared",
      	plotOrderListDeleteButtonToolTip : "Delete this plot order.  Only possible as long as it has not been recieved.",
      	plotOrderListDeliveryButtonCaption : "Confirm delivery",
      	plotOrderListDeliveryButtonToolTip : "Confirmation of adressee that they have received the delivery.",
      	plotOrderListEditButtonToolTip : "Show the single positions with paper, color, amount, and so on including further information to the plot order.  Here single positions can be removed as log as the plot order was not accepted.",
      	plotOrderListReallyDeleteCaption : "Really delete plot order?",
      	plotOrderListReallyDeleteText : "Do you really want to delete the plot order with the number ${plotOrderNumber} from ${customer} for ${contractor}, created on ${creationDate}?",
      	plotOrderListShowButtonToolTip : "",
      	plotOrderListZipExportButtonCaption : "Collected download",
      	plotOrderListZipExportButtonToolTip : "Download zip archive with the documents to single position, as well as the complete overview.",

      	checkAndCreatePlotTaskCaption : "Check Plottask and recreate it",
      	checkAndCreatePlotTaskCaptionToolTip : "Really want to check for this PlotOrder the task and recreate it.",

      	//// cdes/plot/PlotOrderSearchWidget
      	plotOrderSearchFromLabel : "From",
      	plotOrderSearchFromToolTip : "The earliest date which is searched for.  Refers to creation date, receipt date and delivery date equally.",
      	plotOrderSearchJobNumberLabel : "Job number",
      	plotOrderSearchJobNumberToolTip : "Search for order numbers or a parts therof.",
      	plotOrderSearchOrderAddressLabel : "Client",
      	plotOrderSearchOrderAddressToolTip : " Search for the name of the client.",
      	plotOrderSearchOrganisationLabel : "Contractor",
      	plotOrderSearchOrganisationToolTip : "Search for the name of the contractor.",
      	plotOrderSearchSearchButtonToolTip : "Search plot orders according to search criterias above.",
      	plotOrderSearchShowCompleteLabel : "Show completed",
      	plotOrderSearchShowCompleteToolTip : "Completed orders will be marked as comleted by Plotstudio - also show them here.",
      	plotOrderSearchToLabel : "To",
      	plotOrderSearchToToolTip : "The latest possible time that is searched for.  ",

      	//// cdes/plot/PlotOrderSignPage
      	plotOrderSignAdditionalInformationLabel : "Additional informations to plot order",
      	plotOrderSignAdditionalInfoTextArea : "",
      	plotOrderSignDeliveryAddressLabel : "Billing adress: see client",
      	plotOrderSignDeliveryDateLabel : "Delivery date: ",
      	plotOrderSignDeliveryKindOfDeliveryLabel : "Kind of delivery: ${kindOfDelivery}",
      	plotOrderSignPageCaption : "Edit and sign manual plot order (for document ${documentName} ${documentContent})",
      	plotOrderSignSignFailed : "The creation or rather signing of the manual plot order has failed.  Possibly a wrong password has been typed in.",
      	plotOrderSignSignSuccessful : "The plot order has been successfully created and signed.",

      	//// cdes/plot/PlotOrderTemplateAddressListWidget
      	plotOrderTemplateAddressListBillingColumnCaption : "Bill adress",
      	plotOrderTemplateAddressListPlotterColumnCaption : "Repro house",

      	//// cdes/plot/PlotOrderTemplateChoosePage
      	plotOrderTemplateChooseCaption : "Manual plotting order for ${documentName} ${documentContent}",
      	plotOrderTemplateChooseLoadFailed : "Loading the plot templates has failed.",
      	plotOrderTemplateChoosePleaseChooseLabel : "Please choose one of the following templates",

      	//// cdes/plot/PlotOrderTemplateChooseWidget
      	plotOrderTemplateChooseCreateButtonCaption : "Create plot order",
      	plotOrderTemplateWidgetChooseCaption : "Template ${plotOrderTemplateName}",

      	//// cdes/plot/PlotOrderTemplateItemListWidget
      	plotOrderItemAreaCaption : "Area",
      	plotOrderItemColorCaption : "Color",
      	plotOrderItemCountCaption : "Amount",
      	plotOrderItemMarginCaption : "Margin",
      	plotOrderItemMirrorCaption : "Mirror",
      	plotOrderItemPaperQualityCaption : "Paper",
      	plotOrderItemScaleCaption : "Scale",

      	//// cdes/plot/PlotOrderTemplateWidget

      	//// cdes/project/ProjectEditPage
        projectEditBaulosForAllNodesLabel : "Completion process: Specify construction section in all phases.",
        projectEditBaulosForAllNodesToolTip : "Allow specifying the construction section in all phases (not only the very first phase) when setting up the completion process.",
      	projectEditCodeLabel : "Abbreviation",
      	projectEditCodeToolTip : "Usually an abbreviation consisting of few letters, by which the project is labelled on different places.",
      	projectEditCommentLabel : "Comment",
      	projectEditCommentToolTip : "An arbitrary comment to project",
      	projectEditCreateToolTip : "Create new project",
      	projectEditGetProjectFailed : "Loading the project data has failed.",
      	projectEditNameLabel : "Name",
      	projectEditNameToolTip : "Name of the project",
      	projectEditOrdinaryCreateCaption : "Create new project",
      	projectEditOrdinaryEditCaption : "Edit project",
      	projectEditPlanningNotificationCreateCaption : "Create new project in decision monitoring catalogue",
      	projectEditPlanningNotificationEditCaption : "Edit decision monitoring catalogue project",
      	projectEditSaveFailed : "Saving the project has failed. Your changes could not be saved.",
      	projectEditSaveToolTip : "Save changes on current Projekt",

        //// cdes/project/ProjectParticipationSearchWidget
		participationSearchObjectPlannerPositionDefinitionLabel : "Object planner position",
		participationSearchObjectPlannerPositionDefinitionToolTip : "Object planner position",
        participationSearchPersonLabel : "Responsible",
        participationSearchPersonToolTip : "Responsible",
        participationSearchMainParticipantLabel : "Person involved as",
        participationSearchMainParticipantItem : "Primarily responsible",
        participationSearchDeputyItem : "Deputy",
        participationSearchOrganisationLabel : "Organisation",
        participationSearchOrganisationToolTip : "Organisation",
		participationSearchReviewCycleInstanceReleased : "Review sheet",
		participationSearchReviewCycleInstanceReleasedLabel : "Review sheet",
		participationSearchReviewCycleInstanceReleasedToolTip : "Review sheet",
		participationSearchReviewCycleLabel : "Review cycle",
        participationSearchRoleLabel : "Role",
		participationSearchRoleToolTip : "Role",
		realm : "Realm",

      	//// cdes/review/ReviewProtocol
      	reviewProtocolCaption : "Review protocol",
      	reviewProtocolExportFailed : "The export of the review protocol to PDF had failed.",
      	reviewProtocolExportToPdfButtonToolTip : "Export to PDF",
      	reviewProtocolExportToPdfFinished : "The export of the review protocol to PDF was successfully completed, running time ${duration}s",
      	reviewProtocolExportToPdfStarted : "The export of the review protocol to PDF is running...",
      	reviewProtocolLoadFailed : "Loading the necessary files für the review protocol has failed.",
      	reviewProtocolObjectHeaderTitle : "Plan ${documentVersion} /// Project ${project} /// Object ${object} /// Object planner ${objectPlanner} /// km ${km}",
      	reviewProtocolReferenceCaption : "Used References",
      	reviewProtocolShowAllLabel : "Show all nodes",
      	reviewProtocolSvgStatusCaption : "Review status",
      	reviewProtocolVersionCaption : "Dosument and versions",
      	reviewProtocolVersionTitlePaneTitle : "${reviewCycleCellName} - Version ${versionPart}${suffix}",
      	reviewProtocolTitleReactivedSuffix : " (invalid \u2015 previous version reactivated) ",
      	reviewProtocolTitleReplacedSuffix : " (invalid \u2015 released version available) ",
      	reviewProtocolTitleRevisionSuffix : " (Revision to released plan) ",

      	//// cdes/review/ReviewProtocolCrossCommentListWidget
      	reviewProtocolCrossCommentCaption : "comments to previous reviews \u2015 ${nodeName}",
      	reviewProtocolCrossCommentCommentCaption : "Comment to review",
      	reviewProtocolCrossCommentNodeCaption : "Phase",
      	reviewProtocolCrossCommentRealmCaption : "FB",
      	reviewProtocolCrossCommentResultCaption : "Result",
      	reviewProtocolCrossCommentResultDateCaption : "Date",
      	reviewProtocolCrossCommentReviewCaption : "Review",
      	reviewProtocolCrossCommentReviewerCaption : "Reviewer",

      	//// cdes/review/ReviewProtocolInvalidationListWidget
      	reviewCyclePositionResultAuthorized : "The action was agreed with the AG.",
      	reviewProtocolAskDeletePositionResultDialogCaption : "Really delete review?",
      	reviewProtocolDeletePositionResultButtonToolTip : "Delete review",
      	reviewProtocolDeletePositionResultDialogQuestion : "Do you really want to the delete the chosen review from ${resultDate} to Version ${documentVersionName}? This cannot be reversed.",
      	reviewProtocolDeletePositionResultNotPossible : "The review from ${resultDate} to version ${documentVersion} could not be deleted.",
      	reviewProtocolDeletePositionResultSuccessful : "The review from ${resultDate} to version ${documentVersionName} was successfully deleted.",
      	reviewProtocolInvalidationCommentCaption : "Comment",
      	reviewProtocolInvalidationPersonCaption : "Who (responsible)",
      	reviewProtocolInvalidationResultDateCaption : "Date",
      	reviewProtocolInvalidationResultOptionCaption : "Type",
      	reviewProtocolPositionResultDeleteFailed : "While deleting the review an error occured.",

      	//// cdes/review/ReviewProtocolNodeWidget
      	reviewProtocolNodeArrivalDate : "Start: ${arrivalDate}",
      	reviewProtocolNodeDeleteNodeResultButtonToolTip : "Delete node, back to previous node and generate tasks.",
      	reviewProtocolNodeDeleteNodeResultFailed : "Deleting the des node has failed.",
      	reviewProtocolNodeDeleteNodeResultNotPossible : "Deleting the node ${name} is not possible.",
      	reviewProtocolNodeDeleteNodeResultSuccessful : "The node ${name} has been successfully deleted.",
      	reviewProtocolNodeDeletePositionResultDialogCaption : "Really delete?",
      	reviewProtocolNodeDeletePositionResultDialogQuestion : "This function?",
      	reviewProtocolNodeDepartureDate : "Ende: ${departureDate}",
      	reviewProtocolNodeEndNodeGenerateMissingTasksToolTip : "Generate missing review tasks and delete obsolete ones.",
      	reviewProtocolNodeGenerateMissingTasksDialogCaption : "Generate missing tasks?",
      	reviewProtocolNodeGenerateMissingTasksDialogQuestion : "Do you really want to generatet the missing tasks for this node Aufgaben and delete the obsolete ones?",
      	reviewProtocolNodeGenerateMissingTasksFailed : "Generating the missing tasks has failed.",
      	reviewProtocolNodeGenerateMissingTasksNotPossible : "Generating the missing tasks is not possible.",
      	reviewProtocolNodeGenerateMissingTasksSuccessful : "The missing tasks has been generated successfully.",
      	reviewProtocolNodeGenerateMissingTasksToolTip : "Generate missing planing task",
      	reviewProtocolNodeMoveToNextNodeButtonToolTip : "Generate next node with corresponding tasks",
      	reviewProtocolNodeMoveToNextNodeDialogCaption : "Generate next node?",
      	reviewProtocolNodeMoveToNextNodeDialogQuestion : "Do you really want to generate the next node?",
      	reviewProtocolNodeMoveToNextNodeFailed : "Generating the des next node has failed.",
      	reviewProtocolNodeMoveToNextNodeNotPossible : "Generating the next node is not possible.",
      	reviewProtocolNodeMoveToNextNodeSuccessful : "Generating the next node has been completed successfully.",

      	//// cdes/review/ReviewProtocolOebbCommentListWidget
      	reviewProtocolOebbCommentCaption : "${nodeName} \u2015 comments to previous reviews",
      	reviewProtocolOebbCommentCommentCaption : "Comment to review",
      	reviewProtocolOebbCommentNegativeResultLabel : "not approved",
      	reviewProtocolOebbCommentNoResultLabel : "\u2015",
      	reviewProtocolOebbCommentPositiveResultLabel : "approved",
      	reviewProtocolOebbCommentRealmCaption : "FB",
      	reviewProtocolOebbCommentResultCaption : "Result",
      	reviewProtocolOebbCommentReviewerCaption : "add reviewer (responsible person)",

      	//// cdes/review/ReviewProtocolPositionListWidget
      	reviewProtocolNoPositionsLabel : "No entries available",
      	reviewProtocolPositionAttachedReviewLabel : "[optional review]",
      	reviewProtocolPositionAttachedPositionLabel : "[optional review]",
      	reviewProtocolPositionDateCaption : "Date",
      	reviewProtocolPositionNotReviewedLabel : "task waved through \u2015 comment:",
      	reviewProtocolPositionOpenFile : "Open file attachment: ${fileName}",
      	reviewProtocolPositionOpenGraphicalReview : "Open graphical plan review",
      	reviewProtocolPositionOverridingLabel : "Delayed task undertaken by ${personCommonName} \u2015 Comment:",
      	reviewProtocolPositionRealmCaption : "FB",
      	reviewProtocolPositionResultCaption : "Result",
      	reviewProtocolPositionReviewCaption : "Review",
      	reviewProtocolPositionReviewerCaption : "Reviewer",

      	//// cdes/review/ReviewProtocolReferenceWidget
      	reviewProtocolNoReferencesLabel : "No used documents available",
      	reviewProtocolReferenceCreatedCaption : "Date",
      	reviewProtocolReferenceGzCaption : "Reference number",
      	reviewProtocolReferenceRealmCaption : "FB",
      	reviewProtocolReferenceReferenceCaption : "Used documents for the objective plan",
      	reviewProtocolReferenceValidFor : "${sinceVersionPartA}${sinceVersionPartSeparator}${sinceVersionPartB} until ${untilVersionPartA}${untilVersionPartSeparator}${untilVersionPartB}",
      	reviewProtocolReferenceValidForCaption : "valid for versions",

      	//// cdes/review/ReviewProtocolResultListWidget
      	reviewProtocolResultDateCaption : "Date",
      	reviewProtocolResultRealmCaption : "Statement to",
      	reviewProtocolResultResultCaption : "Result",
      	reviewProtocolResultReviewCaption : "Comment",
      	reviewProtocolResultReviewerCaption : "Planner",

      	//// cdes/review/ReviewProtocolVersionWidget
      	reviewProtocolVersionDocumentDeletedCaption : "Document has been deleted ",
      	reviewProtocolVersionInvalidDocumentCaption : "Document has been declared as invalid",
      	reviewProtocolVersionResultCaption : "Statements to this upload",
      	reviewProtocolVersionReviewAbortedCaption : "Review aborted",

      	//// cdes/task/TaskSearchWidget
      	taskSearchDateLabel : "Date",
      	taskSearchExplicitDateLabel : "Explicit date",
      	taskSearchExplicitDateToolTip : "",
      	taskSearchFromLabel : "From",
      	taskSearchGetCountsFailed : "The determination of the amount of the tasks has failed.",
      	taskSearchGetTaskInfoFailed : "Loading the projects has failed.",
      	taskSearchModeBatchSignatures : "Signature folder",
      	taskSearchModeBelatedTasks : "Belated tasks",
      	taskSearchModeOpenTasks : "Open tasks",
      	taskSearchModeOwnTasks : "My tasks",
      	taskSearchModeSelectLabel : "Kind of tasks",
      	taskSearchModeSearchTitle : "Set, which tasks should be found",
      	taskSearchQuickSearchLabel : "Immediate filter",
      	taskSearchRemarkDateLabel : "Date specification by paraphrases",
      	taskSearchRemarkDateToolTip : "",
      	taskSearchToLabel : "to",

      	//// cdes/task/TaskListWidget
      	taskListDueDateColumnCaption : "Date",
      	taskListTaskColumnCaption : "Task",

      	//// cdes/util/CodeHelper
      	documentVersionStateActive : "Active",
      	documentVersionStateAsBuilt : "Inverntory",
      	documentVersionStateDeleted : "Revoke upload",
      	documentVersionStateInReview : "In review ",
      	documentVersionStateInvalidatedAll : "Invalid- Status U",
      	documentVersionStateInvalidatedVersion : "Invalid - Status X",
      	documentVersionStateNotInReview : "Not released",
      	documentVersionStatePrereviewed : "Without Review cycle",
      	documentVersionStateReleasedPositiv : "Released",
      	documentVersionStateReleasedNegativ : "Release rejected",
      	documentVersionStatusAborted : "Review aborted",
      	documentVersionStatusNoStatus : "No status",
      	documentVersionStatusNotUploaded : "Not uploaded",
      	documentVersionStatusReplaced : "Replaced with inventory planning",
      	reviewCycleStatusSearchDelay : "Delayed",
      	reviewCycleStatusSearchLongDelay : "Delayed (> 3 days)",
      	reviewCycleStatusSearchNoDelay : "No delay",

      	//// cdes/util/MspHelper
      	mspHelperTriggerExportDocumentsNowFailure : "An error occurred while processing the export orders. Pleae check the task status under networks/jobs",
      	mspHelperTriggerExportDocumentsNowRunning : "The processing of the export orders is running...",
      	mspHelperTriggerExportDocumentsNowSuccess : "The processing oft he export orders is completed. Please check the results under networks/jobs.",

      	//// cdes/widget/CalendarSpinner
      	calendarSpinnerOpenCalendarLabel : "Calendar",
      	calendarSpinnerOpenCalendarToolTip : "Choose date from calendar",

      	//// cdes/widget/ContextBar
      	contextBarGetAllNetworksFailed : "Loading the list with all networks has failed.",
      	contextBarNetworkCaption : "Network:",
      	contextBarNoNetworkSet : "(No network set)",
      	contextBarNoNetworkSetWarning : "Please choose a network.  Without network this mask cannot be used properly.",
      	contextBarProjectCaption : "Project:",
      	contextBarSetPlanningNotificationNetworkToTabSessionFailed : "Saving the changed network into the context has failed.",
      	contextBarSubProjectCaption : "Sub project:",

        //// cdes/widget/base/SearchControllingWidget
        searchControllingPersonToolTip : "Created by ${givenName} ${surName}",

      	//// cdes/widget/document/DocumentNumberEditor
      	documentNumberEditorNumberGroupSelectedCaption : "Plan number Plan type",
      	documentNumberEditorNumberGroupSelectedMessage : "Invalid selection of a plan type group. Please choose a plantype that is included in the plan type group.",
      	documentNumberEditorNumberSpinnerLabel : "Plan number",
      	documentNumberEditorNumberSpinnerToolTip : "Determine the part of the plan number which is clearly per object sheet or rather object (depending on configurated plan number sceme).",
      	documentNumberEditorTypeSelectLabel : "Plan type",
      	documentNumberEditorTypeSelectToolTip : "Choose a plan type from the list",
      	documentNumberEditorPartSelectLabel : "Part",
      	documentNumberEditorPartSelectToolTip : "Choose a part from the list",

      	//// cdes/widget/msp/AnlagentypImportDialog
      	anlagentypImportFileInfoLabel : "File ${name} uploaded (${size} KB)",
      	anlagentypImportFileLabel : "XLS-file",
      	anlagentypImportPleaseUploadLabel : "Please upload a XLS-file with the assignment from Types of Systems to Object Sheet. First, create a file with the function 'Export object list to Excel' on the page 'Objects' and then complete the types of systms in the last column of system types (one per cell).",

      	//// cdes/widget/msp/MspProjectChooseDialog
      	mspProjectChooseGetProjectsFailed : "Loading the MSP-Projects has failed.",
      	mspProjectChooseProjectCaption : "Project",

      	//// cdes/widget/object/ObjectHeaderWidget
      	objectHeaderKmFromToLabel : "km from-to",
      	objectHeaderNoPlannerDefined : "No planner defined",
      	objectHeaderPlannerLabel : "Planer \u2015 ${organisationName} (${personCommonName}) ${plannerComment}",
      	objectHeaderReviewCycleInstanceLabel : "Test sheet \u2015 ${reviewCycleInstanceName}",

      	//// cdes/widget/project/ProjectParticipationMultiContentWidget
      	projectParticipationMultiAddParticipationLabel : "",
      	projectParticipationMultiRemoveParticipationLabel : "",

      	//// cdes/widget/project/ProjectParticipationMultiSelect
      	projectParticipationMultiSelectChooseInfo : "${count} Review chosen, for details see tool tip",
      	projectParticipationMultiSelectConfigureTitlesCaption : "Add reviewer to search",
      	projectParticipationMultiSelectSelectLabel : "Reviewer",
      	projectParticipationMultiSelectSelectToolTip : "Reviewer, that is searched for",

      	//// cdes/widget/search/SearchEditWidget
      	searchEditSaveRefusedMessage : "",
      	searchEditSaveOrUpdateFailed : "Saving has failed.",

        //// cdes/widget/util/TextAreaDnDCellWidget
        textAreaDnDEditTranslationsCaption : "Translations",
        textAreaDnDEditTranslationsCaptionToolTip : "Manage additional translations",

        //// cdes/widget/util/MultiI18nTextAreaDialog
        multiI18nTextAreaTranslationLabel : "Translation",
        multiI18nTextAreaTranslationToolTip : "The translation in the respective language.",


        //// cdes/project/ProjectParticipationColumnWidget
        participationColumnMainParticipantLabel : "Deputy",
        participationColumnObjectPlannerPositionDefinitionLabel : "Object planner position",
        participationColumnParticipantLabel : "Person in charge",
        participationColumnRealmLabel : "Departments",
        participationColumnReviewCycleInstanceLabel : "Review sheet",
        participationColumnReviewCycleLabel : "Based on review cycle",

		//// metaTagNames
		planningNotificationMetaTag_Baulos : "phase",
		planningNotificationMetaTag_GZ : "BN",
		planningNotificationMetaTag_Behörde : "authority",
		planningNotificationMetaTag_Verfahren : "proceedings",
		planningNotificationMetaTag_Dokumentendatum : "documents date",
		planningNotificationMetaTag_Gültigkeit : "validity",
		planningNotificationMetaTag_Abschnitt : "section",
		planningNotificationMetaTag_Strecke : "route",
		planningNotificationMetaTag_kmvon : "km from",
		planningNotificationMetaTag_kmbis : "km to",
	    planningNotificationMetaTag_Schlagwort : "headword",
        participationColumnRoleLabel : "Role",

        //// cdes/person/OrganisationPersonEditWidget
        organisationPersonEditOrganisationLabel : "Organisation",
        organisationPersonEditOrganisationLabelToolTip : "Name of Organisation\nAs you type, a list of matching existing entries is displayed.",
        organisationPersonEditCertificateLabel : "Certificates: ",
        organisationPersonEditCertificateNoneLabel : "No certificates, invitations or requirements available",
        organisationPersonEditCertificatePleaseCorrectFields : "'Save and Certify' is only available when all required (yellow) fields are correctly filled.",
        organisationPersonEditValidCertificates : "${count} valid",
        organisationPersonEditValidExpiresSoonCertificates : "${count} valid but soon expiring",
        organisationPersonEditExpiredCertificates : "${count} expired",
        organisationPersonEditInvitations : "${count} invitations",
        organisationPersonEditRequests : "${count} requirements",

        organisationPersonEditCertificateCreateLabel : "Certificate not available",
        organisationPersonEditCertificateExistsLabel : "Certificate available (valid until ${certValidTo})",
        organisationPersonEditMultipleCertificatesExistsLabel : "Multiple certificates available",
        organisationPersonEditCertificateNotPossibleLabel : "Certificate issuance not possible (no suitable base certificate found)",
        organisationPersonEditInactiveLabel : "organizational person inactive with the following comment",
        organisationPersonEditInactiveToolTip : "organizational person inactive",
        organisationPersonEditOrganisationalUnitLabel : "Department",
        organisationPersonEditOrganisationalUnitToolTip : "Department",
        organisationPersonEditRetiredCommentLabel : "Comment on inactive organizational person",
        organisationPersonEditMailSendModeLabel : "email delivery",
        organisationPersonEditMailSendModeToolTip : "Type of email delivery. Can only be changed by the person themselves.",
        organisationPersonEditMailSendTimeLabel : "at",
        organisationPersonEditMailSendTimeToolTip : "time of email delivery",
        organisationPersonEditSaveAndCertifyLabel : "Save the new organizational person and then certify as follows:",
        organisationPersonEditSaveAndInviteFailed : "Saving and subsequently inviting the new organizational person failed.",
        organisationPersonEditUseAddressButtonLabel : "Adopt address",
        organisationPersonEditUseAddressButtonToolTip : "Adopt the address data of the organization.",
        organisationPersonEditWidgetGetNetworkOrganisationNamesFailed : "Loading the possible organizations failed.",

        //// cdes/person/PersonEditPage
        personEditPageAddOrganisationPersonLabel : "Add organisation",
        personEditPageAddOrganisationPersonToolTip : "Add organisation",
        personEditPageAddTrainingButton : "Add",
        personEditPageAddTrainingToolTip : "",
    	personEditPageCaption : "edit ${surName} ${givenName} person",
      	personEditPageFetchPersonWithTrainingsFailedMessage : "Loading the person's data has failed.",
        personEditPageCreateCaption : "Add Person ${surName} ${givenName}",
        personEditPageEditCaption : "Edit person ${surName} ${givenName}",
        personEditPageShowCaption : "Person ${surName} ${givenName}",
        personEditPageDeleteOrganisationPersonToolTip : "Delete the organizational person. Only possible if the organizational person was not really active yet, for example if it was created by mistake and should be deleted immediately.",
        personEditPageFetchPersonsFailedMessage : "Loading the personal data failed.",
        personEditPageOrganisationPersonClosedCaption : "Show organizational person ${organisationName}",
        personEditPageOrganisationPersonNewClosedCaption : "Show new organizational person ${organisationName}",
        personEditPageOrganisationPersonNewOpenCaption : "Hide new organizational person ${organisationName}",
        personEditPageOrganisationPersonNewPleaseChoose : "Choose organisation for new organizational person",
        personEditPageOrganisationPersonOpenCaption : "Hide organizational person ${organisationName}",
        personEditPageOrganisationPleaseChooseCaption : "Please choose organisation",
        personEditPagePersonDataClosedCaption : "Person data", // Removed due to CDES-2635, Pkt 2: Show personen's data",
        personEditPagePersonDataOpenCaption : "Person data", // Removed due to CDES-2635, Pkt 2: Hide personen's data",
        personEditSaveSucccessful : "Person successfully saved .",
        personEditPageSaveContinueEditingLabel : "Continue editing",
        personEditPageSaveContinueEditingToolTip : "Close this warning, do not save, and continue editing the person",
        personEditPageSaveIgnoreWarningAndSave : "Ignore warning and save",
        personEditPageSaveOrUpdatePersonAndOrganisationPersonsFailed : "Saving the personal data failed.",
        personEditPageSaveSimilarPersonFound : "Similar persons found",
        personEditPageTrainingCaption : "Training",
        personEditPageTrainingToolTip : "",


        //// cdes/person/PersonEditWidget
        personEditFemaleLabel : "Miss",
        personEditFemaleToolTip : "",
        personEditGenderLabel : "Gender",
        personEditGenderToolTip : "",
        personEditGivenNameLabel : "Name",
        personEditGivenNameToolTip : "",
        personEditLoginLabel : "Username",
        personEditLoginToolTip : "",
        personEditMaleLabel : "Mister",
        personEditMaleToolTip : "",
        personEditRoleLabel : "Role",
        personEditRoleToolTip : "",
        personEditSurNameLabel : "Surname",
        personEditSurNameToolTip : "",
        personEditTitleLabel : "Title",
        personEditTitleToolTip : "",
        personEditUserLocaleLabel : "User locale",
        personEditUserLocaleToolTip : "The language the userinterface will be dispayed.",
        personEditZTPermissionLabel : "ZT-permission",
        personEditZTPermissionToolTip : "",

        //// cdes/person/PersonListWidget
    	personEditPageShowProjectParticipationsToolTip : "Search and show project participations",
        personListAskDeleteInvalidateDialogCaption : "Delete or deactivate?",
        personListAskDeleteInvalidateDialogText : "The person ${givenName} ${surName} may",
        personListAskInvalidateDialogCaption : "Person löschen?",
        personListAskDeleteInvalidateDeleteItem : "be irretrievably deleted",
        personListAskDeleteInvalidateInvalidateItem : "only be set to inactive",
        personListAskUndeleteDialogCaption : "Remove deletion marker?",
        personListAskUndeleteDialogText : "Should the deletion mark be removed from the person ${givenName} ${surName}?",
        personListDeleteButtonToolTip : "Delete the person permanently. This option is only available if the person has not been active to a large extent.",
        personListDeletePersonFailed : "Deleting the person failed.",
        personListDeleteInvalidateNotPossibleDialogCaption : "Neither deletion nor deactivation possible",
        personListDeleteInvalidateNotPossibleDialogText : "The person ${givenName} ${surName} can neither be deleted nor deactivated. Reasons:",
        personListDeleteNotPossibleDialogCaption : "deletion not possible",
        personListDeleteNotPossibleDialogText : "The person ${givenName} ${surName} cannot be deleted because there are no corresponding authorizations for the following organizational persons:",
        personListDeleteSuccessfulMessage : "The person ${givenName} ${surName} was successfully deleted.",
        personListInvalidateButtonCaption : "Set to Inactive",
        personListInvalidateButtonToolTip : "Set the person inactive.",
        personListInvalidatePersonFailed : "Setting the person to inactive failed.",
        personListInvalidateSuccessfulMessage : "The person ${givenName} ${surName} was successfully deactivated.",
        personListOrganisationPersonColumnCaption : "Tel./Fax",
        personListOrganisationProjectRoleCaption : "Organizations, project participation and roles",
        personListProjectParticipationColumnCaption : "Project participation / Roles",
        personListRoleColumnCaption : "role (responsible person)",
        personListDeleteToolTip : "Delete the person.",
        personListUnit : "department",
        personListEmailPrefix : "e",
        personListPhonePrefix : "t",
        personListMobilePrefix : "m",
        personListFaxPrefix : "f",
        personListRoleLabel : "${role} (${surName} ${givenName})",
        personListEditToolTip : "Edit data and organizational persons",
        personListGetUndeletableOrganisationPersonJoinsByPersonFailed : "The check to what extent the organization and its organizational persons can be deleted failed.",
        personListInvalidateDialogText : "The person ${givenName} ${surName} cannot be deleted because the following organizational persons are in use.",
        personListInvalidateDialogTextTwo : "Would you like to make the person inactive instead?\Project participations in responsibility are transferred to a deputy if possible, otherwise set inactive.\nProject participations in representation are deleted.",
        personListUndeleteSuccessful : "The deletion mark was removed successfully from person ${givenName} ${surName}.",
        personListUndeleteToolTip : "Remove deletion mark",
        personListWidgetUndeletePersonFailed : "Removing the deletion mark failed.",
        personListPersonLoginCaption : "Show persons login",

        //// cdes/person/PersonPage
        consortiumListFailed : "The export of the consortium list failed.",
        consortiumPagePdfExportFinished : "The export of the consortium list was successfully completed. It is now available for download.",
        organisationListFailed : "Exporting the organization list failed.",
        organisationPagePdfExportFinished : "The export of the organization list was completed successfully. It is now available for download.",
        personPageCaption : "Persons",
        personPageNewButtonCaption : "Add a person",
        personPageNewButtonToolTip : "Add a new person",
        personPageGetSearchInfoFailed : "Loading the additional information for the search mask failed.",
        personPageLoadDataFailed : "The search for people failed.",
        personPagePdfExportFailed : "The export of the person list failed.",
        personPagePdfExportFinished : "The export of the person list was completed successfully. It is now available for download.",
        personPagePdfExportStarted : "The export of the person list is running...",
        personPageSearchResult : "${count} persons found.",

        //// cdes/person/PersonSearchWidget
        personSearchNameLabel : "Name",
        personSearchNameToolTip : "Name of the person you are looking for, in the sequence 'Last name First name', wildcards like '*' allowed.",
        personSearchOrganisationLabel : "Organisation",
        personSearchOrganisationToolTip : "Organisation",
        personSearchNetworkLabel : "Network",
        personSearchNetworkToolTip : "Network",
        personSearchProjectLabel : "Involved in project",
        personSearchProjectToolTip : "Involved in the project",
        personSearchRoleLabel : "in role",
        personSearchRoleToolTip : "in the role",
        personSearchShowDetailsLabel : "Show project participations and roles with filter",
        personSearchShowDetailsToolTip : "Display the project participations and roles as an additional column, and optionally restrict the content of the cells in this column to specific projects or roles",
		personSearchShowInvalidLabel : "Show inactive people",
		personSearchShowInvalidToolTip : "",

        //// cdes/person/PersonTrainingListWidget
        personTrainingListCommentColumnCaption : "Comment",
        personTrainingListCommentToolTip : "",
        personTrainingListDateColumnCaption : "Date",
        personTrainingListDateToolTip : "",
        personTrainingListTypeColumnCaption : "Type of training",
        personTrainingListTypeToolTip : "",

        //// cdes/person/SimilarPersonChooseDialog
        similarPersonChooseHeader : "The following people with similar or the same name already exist in the active or other networks:",
        similarPersonChooseHintOne : "If this note is not relevant for you, you can still save your entries.",
        similarPersonChooseHintTwo : "Alternatively, you can cancel saving and, for example, continue editing your entries or link one of the displayed persons to another organization.",
        similarPersonChooseHintThree : "Note: You can check on the overview pages of the various networks if it is the same person as in your entry.",
        similarPersonChooseOrganisationsColumnCaption : "organizational persons",

        //// cdes/project/ProjectParticipationPage
        participationPageCaption : "Project Participations",
        participationPageLoadDataFailed : "Loading the project participations has failed.",
        participationPageSearchInfoFailed : "Loading the information necessary for the search dialog failed.",
        participationPageSearchResult : "Search successful, loaded [${count}] project participations in [${duration}s].",

        //// cdes/organisation/ConsortiumListWidget
        consortiumListAskAddToNetworkCaption : "Really add consortium to the network?",
        consortiumListAskAddToNetworkQuestion : "Do you really want to link the consortium ${organisationName} with your own network ${networkName}?",
        consortiumListAskDeleteCaption : "Really delete consortium ${organisationName}?",
        consortiumListAskDeleteQuestion : "Do you really want to delete the consortium ${organisationName} irretrievably?",
        consortiumListDeleteNotPossibleDialogCaption : "deletion not possible",
        consortiumListDeleteNotPossibleDialogText : "The consortium ${organisationName} cannot be deleted. Reasons:",
        consortiumListEditToolTip : "Edit the consortium and its members",
        consortiumListReferenceToolTip : "Connect to network",
        consortiumListShowToolTip : "View the consortium and its members",
        consortiumListWidgetAddOrganisationToNetworkFailed : "Adding the consortium to the active network failed.",
        consortiumListWidgetAddOrganisationToNetworkSuccess : "The consortium ${organisationName} was successfully added to the network ${networkName}.",
        consortiumListWidgetDeleteOrganisationFailed : "Deleting the consortium ${organisationName} failed.",
        consortiumListWidgetDeleteOrganisationSuccess : "The consortium ${organisationName} was successfully deleted.",
        consortiumListWidgetGetOrganisationInUseHintsFailed : "The check whether the consortium can be deleted failed.",
        consortiumPageOrganisationsColumnCaption : "Organisations",

        //// cdes/organisation/ConsortiumPage
        consortiumPageCaption : "Consortiums",
        consortiumPageGetAllNetworksFailed : "Fetching the networks failed.",
        consortiumPageLoadDataFailed : "The search for consortiums failed.",
        consortiumPageNewButtonCaption : "Adding consortium",
        consortiumPageNewButtonToolTip : "Adding new consortium",
        consortiumPagePdfExportFailed : "The export of the consortium list failed.",
        consortiumPagePdfExportStarted : "The export of the consortium is running ...",
        consortiumPageSearchResult : "Found ${count} consortiums.",

        //// cdes/organisation/OrganisationListWidget
        organisationListAddressColumnCaption : "Contact",
        organisationListAskAddToNetworkCaption : "Add organization to network?",
        organisationListAskAddToNetworkQuestion : "Do you really want to link the organization ${organisationName} with your own network ${networkName}?",
        organisationListAskDeleteCaption : "Really delete organization ${organisationName}?",
        organisationListAskDeleteQuestion : "Do you really want to permanently delete the organization ${organisationName}?",
        organisationListAskRemoveCaption : "Really remove organization ${organisationName}?",
        organisationListAskRemoveQuestion : "Do you really want to cancel the membership of the organization ${organisationName} in the consortium? If you answer yes, the change will only take effect when you save it.",
        organisationListDeleteNotPossibleDialogCaption : "deletion not possible",
        organisationListDeleteNotPossibleDialogText : "The organization ${organisationName} cannot be deleted. Reasons:",
        organisationListDeleteToolTip : "Delete the organization",
        organisationListEditToolTip : "Edit the organization and its employees",
        organisationListPhoneColumnCaption : "Tel./Fax",
        organisationListNetwoksColumnCaption : "networks",
        organisationListReferenceToolTip : "Connect to network.",
        organisationListReferenceToolTipExt : "Currently linked to",
        organisationListRemoveToolTip : "Remove the organization",
        organisationListShowToolTip : "View the organization and its employees",
        organisationListWidgetAddOrganisationToNetworkFailed : "Adding the organization to the active network failed.",
        organisationListWidgetAddOrganisationToNetworkSuccess : "The organization ${organisationName} was successfully added to the network ${networkName}.",
        organisationListWidgetDeleteOrganisationFailed : "Deleting the organization ${organisationName} failed.",
        organisationListWidgetDeleteOrganisationSuccess : "The organization ${organisationName} was successfully deleted.",
        organisationListWidgetGetOrganisationInUseHintsFailed : "The check whether the organization can be deleted failed.",

        //// cdes/organisation/OrganisationPage
        organisationPageCaption : "Organisations",
        organisationPageChooseNetworkCaption : "Select network for linking",
        organisationPageGetSearchInfoFailed : "Loading the additional information for the search mask failed.",
        organisationPageLoadDataFailed : "The search for organizations failed.",
        organisationPageNewButtonCaption : "Add organization",
        organisationPageNewButtonToolTip : "Add new organization",
        organisationPagePdfExportFailed : "Exporting the organization list failed.",
        organisationPagePdfExportStarted : "Exporting the organization list is running ...",
        organisationPageSearchResult : "${count} organisations found.",

        //// cdes/organisation/OrganisationEditPage
        organisationEditGetOrganisationCreateInfoFailed : "Loading the data for the creation dialog has failed.",
        organisationEditGetOrganisationEditInfoFailed : "Loading the organisation data failed",
       	organisationEditGetOrganisationEditInfoSuccess : "Successfully loaded the data for organisation ${organisationName}",
       	organisationEditMemberClosedCaption : "Show staff",
       	organisationEditMemberOpenCaption : "Hide staff",
       	organisationEditOrganisationDataClosedCaption : "Show organisation",
       	organisationEditOrganisationDataOpenCaption : "Hide organisation",
       	organisationEditPageCreateCaption : "Create organisation ${organisationName}",
       	organisationEditPageEditCaption : "Edit organisation ${organisationName}",
       	organisationEditPageGetSimilarOrganisationsFailed : "Deriving possibly already existing organisations failed.",
       	organisationEditPageSaveContinueEditingToolTip : "Ignore this warning, do not save, and continue editing the organisation.",
       	organisationEditPageSaveOrUpdateOrganisationFailed : "Saving the organisation ${organisationName} failed.",
                    organisationEditPageShowCaption : "Organisation ${organisationName}",
       	organisationEditSaveSuccessful : "Successfully saved organiation ${organisationName}.",
       	organisationEditPageSaveSimilarPersonFound : "Similar organisations found",
        organisationalUnitLabel : "Department",

        //// cdes/organisation/OrganisationEditWidget
        organisationEditWidgetNameLabelToolTip : "Organization name\nAs you type, a list of matching existing entries will appear.",


        //// cdes/organisation/OrganisationMemberListWidget
       	organisationMemberListEditToolTip : "Edit the employee data",
       	organisationMemberListMailToolTip : "Write an email to the employee",
       	organisationMemberListShowToolTip : "Show the employee data",


        //// cdes/widget/mail/SendEmailPage
       	sendEmailBodyLabel : "Body",
       	sendEmailFromLabel : "From",
       	sendEmailPageCaption : "Send email to ${name}",
       	sendEmailPageGetOrganisationPersonJoinsFailed : "Loading the information necessary for sending the email has failed.",
       	sendEmailPageSendEmailFailed : "Sending the email failed.",
       	sendEmailPageSendEmailSuccess : "Triggered sending the email to ${receiver}",
       	sendEmailReceiverLabel : "To",
       	sendEmailSendButtonCaption : "Send",
       	sendEmailSendButtonToolTip : "Send the email to the indicated receiver.  The sender automatically receivers a copy.",
       	sendEmailSubjectLabel : "Subject",
       	sendEmailToContent : "${receiver} <${email}>",


        //// cdes/organisation/ConsortiumEditPage
        consortiumEditGetOrganisationEditInfoSuccess : "Successfully loaded the data for consortium ${organisationName}",
   		consortiumEditMemberClosedCaption : "Show member organisations",
	   	consortiumEditMemberOpenCaption : "Hide member organisations",
	   	consortiumEditPageAddMemberToolTip : "Add a new member",
	   	consortiumEditPageChooseMembersCaption : "Choose organisations",
	   	consortiumEditPageCreateCaption : "Create consortium ${organisationName}",
	   	consortiumEditPageEditCaption : "Edit consortium ${organisationName}",
        consortiumEditPageShowCaption : "Consortium ${organisationName}",
	   	consortiumEditPageGetNetworkOrganisationInfosFailed : "Loading the list of selectable organisations has failed.",
	   	consortiumEditPageGetSimilarConsortiumsFailed : "Deriving possibly already existing similar consortiums failed.",
	   	consortiumEditPageSaveContinueEditingToolTip : "Ignore this warning, do not save, and continue editing the consortium.",
	   	consortiumEditPageSaveOrUpdateOrganisationFailed : "Saving the consortium ${organisationName} failed.",
	   	consortiumEditPageSaveSimilarConsortiumFound : "Similar consortium found",
	   	consortiumEditSaveSucccessful : "Successfully saved consortium ${organisationName}.",


        //// cdes/organisation/SimilarOrganisationChooseDialog
        similarOrganisationChooseHeader : "The following organisations with the same, or a similar name already exist:",
        similarOrganisationChooseHintOne : "Organisations not yet linked with the context network are displayed gray.  You may choose to link them with the context network now using the corresponding action button at the right (assuming appropriate permissions).",
        similarOrganisationChooseHintTwo : "You may now either choose to ignore this hint and save anyway, or to abort the save, and to continue with an already existing organisation.",

        passwordIllegalCharsWarning : "The password contains illegal characters.  Allowed are: Upper- and lowercase letters (including umlauts and ß), digits, usual punctuation marks and special characters (i.e. .-_/\!?,:<>§$%&€), brackets (i.e. ()[]{}). In particular spaces are not allowed.",

        securityQuestionAnswerMissing: "No security question answer was provided.",
        securityQuestionAnswerTooShort: "The answer to the security question must have at least ${minLength} characters.",
        securityQuestionAnswerInvalidCharacters: "The answer to the security question contains illegal characters.  Allowed are: Upper- and lowercase letters (including umlauts and ß), digits, usual punctuation marks and special characters (i.e. .-_/\!?,:<>§$%&€), brackets (i.e. ()[]{}). In particular spaces are not allowed."
    })
);
