/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

//// css-prefix = projectEdit
//// i18n-prefix = projectEdit

         
define([ "cdes/core/CdesVoc",
	 "cdes/widget/ContextBar",
	 "clazzes/TinyLog",
	 "clazzes/util/DOMHelper",
	 "clazzes/util/ErrorHelper",
         "clazzes/util/WidgetHelper",
	 "clazzes/widgets/layout/ContentWidget",
         "dijit/form/Button",
    "dijit/form/CheckBox",
    "dijit/form/TextBox",
         "dijit/form/Textarea",
         "dijit/form/ValidationTextBox",
	 "dojo/dom-class",
	 "dojo/dom-construct",
	 "dojo/dom-style",
	 "dojo/on",
	 "dojo/_base/declare",
	 "dojo/_base/lang",
	 "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
       function(CdesVoc,
		ContextBar,
		TinyLog,
		DOMHelper,
		ErrorHelper,
                WidgetHelper,
		ContentWidget,
                Button,
           CheckBox,
           TextBox,
                Textarea,
                ValidationTextBox,
		domClass,
		domConstruct,
		domStyle,
		on,
		declare,
		lang,
		i18n) {

    var className = "at.cdes.web.project.ProjectEditPage";

    var log = new TinyLog(className);

    var ProjectEditPage = declare(className, ContentWidget, {

	// Remaining TODOs:
	// - Unify constants, module instead of ContextBar specific mode should suffice for ContextBar as well	
        // - Disable buttons while async operations are running


	constructor : function(params) {
	    lang.mixin(this, params);

	    this.contextBarMode = null;
	    if (this.module == CdesVoc.Module.PLANNING_NOTIFICATION) {
			this.contextBarMode = ContextBar.Mode.PLANNING_NOTIFICATION;
	    } else if (this.module == CdesVoc.Module.CORE) {
			this.contextBarMode = ContextBar.Mode.DEFAULT;
	    } else {
			throw new Error("Module [" + this.module + "] is not supported.");
	    }		

	    this.topDiv = this.constructTopDiv();
	    this.reload();

	    this.allFieldsValid = true;
	},

	getWidgetId : function() {
	    return "ProjectEditPage";
	},

	getDataId : function() {
	    return null;
	},

	getContainer : function() {
	    return this.topDiv;
	},

	constructTopDiv : function() {
	    var topDiv = domConstruct.create("div", null, null);

	    // Caption Bar
	    this.captionBarDiv = this.constructCaptionBar();
	    domClass.add(this.captionBarDiv, "cdesGeneralPageCaptionBar");
	    domConstruct.place(this.captionBarDiv, topDiv);

	    // Content
	    this.contentDiv = this.constructContentDiv();
	    domConstruct.place(this.contentDiv, topDiv);

	    return topDiv;
	},

	constructCaptionBar : function() {
	    var captionBarDiv = domConstruct.create("div", null, null);

	    // Caption
	    var captionLabel = null;
	    if (this.mode == ContentWidget.Mode.CREATE) {
		if (this.module == CdesVoc.Module.PLANNING_NOTIFICATION) {
		    captionLabel = i18n.projectEditPlanningNotificationCreateCaption;
		} else if (this.mode == CdesVoc.Module.CORE) {
		    captionLabel = i18n.projectEditOrdinaryCreateCaption;
		} else {
		    throw new Error("Unsupported module [" + this.module + "]");
		}		    
	    } else if (this.mode == ContentWidget.Mode.EDIT) {
		if (this.module == CdesVoc.Module.PLANNING_NOTIFICATION) {
		    captionLabel = i18n.projectEditPlanningNotificationEditCaption;
		} else if (this.mode == CdesVoc.Module.CORE) {
		    captionLabel = i18n.projectEditOrdinaryEditCaption;
		} else {
		    throw new Error("Unsupported module [" + this.module + "]");
		}		    
	    } else {
		throw new Error("Mode [" + this.mode + "] is not supported.");
	    }

	    this.captionDiv = DOMHelper.createTextNode("h1", captionLabel, captionBarDiv, "cdesGeneralPageCaption");

	    return captionBarDiv;
	},

	constructContentDiv : function() {
	    var contentDiv = domConstruct.create("div", null, null);
	    domClass.add(contentDiv, "refNodeOfPositionAbsolute", "projectEditPageContentDiv");

	    var inputDiv = domConstruct.create("div", null, null);
	    domClass.add(inputDiv, "fixedDialogWidget projectEditPageInputDiv");
	    domConstruct.place(inputDiv, contentDiv);	    

	    // CodeTextBox
	    DOMHelper.createTextNode("div", i18n.projectEditCodeLabel, inputDiv, "propertyLabel projectEditCodeLabel");
	    this.codeTextBox = new ValidationTextBox({
		    label : i18n.projectEditCodeLabel,
		    title : i18n.projectEditCodeToolTip,
		maxLength : 16
	    });
	    domClass.add(this.codeTextBox.domNode, "fixedDialogWidget projectEditCodeTextBox");
	    domConstruct.place(this.codeTextBox.domNode, inputDiv);
	    WidgetHelper.handleTextBoxEvents(this.codeTextBox, lang.hitch(this, this.updateWidgetState));
	    WidgetHelper.setMustField(this.codeTextBox, true);

	    // NameTextBox
	    DOMHelper.createTextNode("div", i18n.projectEditNameLabel, inputDiv, "propertyLabel projectEditNameLabel");
	    this.nameTextBox = new ValidationTextBox({
		    label : i18n.projectEditNameLabel,
		    title : i18n.projectEditNameToolTip,
		maxLength : 80		
	    });
	    domClass.add(this.nameTextBox.domNode, "fixedDialogWidget projectEditNameTextBox");
	    domConstruct.place(this.nameTextBox.domNode, inputDiv);
	    WidgetHelper.handleTextBoxEvents(this.nameTextBox, lang.hitch(this, this.updateWidgetState));
	    WidgetHelper.setMustField(this.nameTextBox, true);

	    // CommentTextArea
	    DOMHelper.createTextNode("div", i18n.projectEditCommentLabel, inputDiv, "propertyLabel projectEditCommentLabel");
	    this.commentTextArea = new Textarea({
		    label : i18n.projectEditCommentLabel,
		    title : i18n.projectEditCommentToolTip,
		maxLength : 255
	    });
	    domClass.add(this.commentTextArea.domNode, "fixedDialogWidget projectEditCommentTextArea");
	    domConstruct.place(this.commentTextArea.domNode, inputDiv);
	    WidgetHelper.handleTextBoxEvents(this.commentTextArea, lang.hitch(this, this.updateWidgetState));

            // BaulosForAllNodesCheckBox
            this.baulosForAllNodesCheckBox = new CheckBox({
                label : i18n.projectEditBaulosForAllNodesLabel,
                title : i18n.projectEditBaulosForAllNodesToolTip             
            });
            domClass.add(this.baulosForAllNodesCheckBox.domNode, "fixedDialogWidget projectEditBaulosForAllNodesCheckBox");
            domConstruct.place(this.baulosForAllNodesCheckBox.domNode, inputDiv);            

	    DOMHelper.createTextNode("div", i18n.projectEditBaulosForAllNodesLabel, inputDiv, "fixedDialogWidget projectEditBaulosForAllNodesLabel");

	    var buttonDiv = domConstruct.create("div", null, null);
	    domClass.add(buttonDiv, "fixedDialogWidget projectEditPageButtonDiv");
	    domConstruct.place(buttonDiv, contentDiv);	    

	    // Save button
     	    this.saveButton = new Button({
     		label : i18n.saveAndExitButtonCaption,
     		title : i18n.projectEditSaveToolTip
     	     });
     	    domClass.add(this.saveButton.domNode, "projectEditSaveButton");
     	    domConstruct.place(this.saveButton.domNode, buttonDiv);

	    on(this.saveButton, "click", lang.hitch(this, this.save));

	    // Abort button
     	    this.abortButton = new Button({
     		 label : i18n.abortButtonCaption,
     		 title : i18n.abortToolTip
     	     });
     	    domClass.add(this.abortButton.domNode, "projectEditAbortButton");
     	    domConstruct.place(this.abortButton.domNode, buttonDiv);
	    on(this.abortButton, "click", lang.hitch(this, this.abort));

	    return contentDiv;
	},

	save : function() {
	    this.updateDataFromWidgets();

	    var networkService = this.applicationContext.getService("networkService");
    	    this.registerAsyncOperationStarted(ProjectEditPage.AsyncOperation.SAVE);

	    var fct;
	    if (this.mode == ContentWidget.Mode.CREATE) {
		fct = "createProject";
	    } else if (this.mode == ContentWidget.Mode.EDIT) {
		fct = "updateProject";
	    } else {
		throw new Error("Unsupported mode [" + this.mode + "]");
	    }		

	    var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
	    networkService[fct](this.projectJoin, organisationPersonId).then(
		lang.hitch(this, function() {
    		    this.registerAsyncOperationFinished(ProjectEditPage.AsyncOperation.SAVE);

		    if (this.backPage != null) {
     			this.applicationContext.setPage(this.backPage, new Object(), this.backParams);
		    }
		}),
		lang.hitch(this, function(err) {
		    ErrorHelper.processAsyncError({
				   err : err,
				widget : this,
			asyncOperation : ProjectEditPage.AsyncOperation.SAVE,
				opName : fct,
			       message : i18n.projectEditSaveFailed
		    });
		})).otherwise(
		lang.hitch(this, function(err) {
		    log.error("Error while calling function [" + fct + "]", err);
		}));
	},

        abort : function() {
	    if (this.backPage != null) {
     		this.applicationContext.setPage(this.backPage, new Object(), this.backParams);
	    }            
        },	

	resize : function(newSize) {
	    var totalHeight = newSize.h;

	    var width = this.captionBarDiv.offsetWidth - 15;
	    var contentHeight = totalHeight
		//- this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")
		- this.captionBarDiv.offsetHeight
		- 16;

	    domStyle.set(this.contentDiv, "height", contentHeight + "px");
	},

	setData : function() {

	},

	reload : function() {
	    //this.contextBar.reload();

	    if (this.mode == ContentWidget.Mode.CREATE) {
			this.projectJoin = new Object();
			this.projectJoin.projectCode = "";
			this.projectJoin.projectName = "";
			this.projectJoin.projectComment = "";
			this.projectJoin.projectStretchKmFrom = 0.0;
			this.projectJoin.projectStretchKmTo = 0.0;		
			this.projectJoin.projectRouteName = "";
			this.projectJoin.projectNetworkId = this.applicationContext.getPageContextPnNetworkId();
			this.projectJoin.projectWithParticipantsSubProjectRestriction = false;
			this.projectJoin.projectIgnorePlotOrderReceivedSteps = false;		
			this.projectJoin.projectStatus = CdesVoc.ProjectStatus.PLANNING_NOTIFICATION_PROJECT;
			this.projectJoin.projectAccess = CdesVoc.ProjectAccess.READ_WRITE;
	        this.projectJoin.projectConfigWorkflowBaulosForAllNodes = false;
	        this.projectJoin.projectUsePDCStartDateForTasks = false;
			this.updateWidgetsFromData();		
			this.updateWidgetState();
	    } else if (this.mode == ContentWidget.Mode.EDIT) {
	    	var networkService = this.applicationContext.getService("networkService");
    		this.registerAsyncOperationStarted(ProjectEditPage.AsyncOperation.LOAD);

    		networkService.getProjectJoin(this.id).then(
		    lang.hitch(this, function(projectJoin) {
			this.projectJoin = projectJoin;

			this.updateWidgetsFromData();
    			this.registerAsyncOperationFinished(ProjectEditPage.AsyncOperation.LOAD);
		    }),
		    lang.hitch(this, function(err) {
			ErrorHelper.processAsyncError({
				       err : err,
				    widget : this,
			    asyncOperation : ProjectEditPage.AsyncOperation.LOAD,
				    opName : "getProject",
				   message : i18n.projectEditGetProjectFailed
			});
		    })).otherwise(
		    lang.hitch(this, function(err) {
			log.error("Error while calling function [getProject]", err);
		    }));
	    } else {
		throw new Error("Mode [" + this.mode + "] is not supported.");
	    }		
	},

	updateWidgetState : function() {
	    if (this.mode == ContentWidget.Mode.CREATE) {
//		this.saveButton.set("label", i18n.createButtonCaption);
		this.saveButton.set("title", i18n.projectEditCreateToolTip);
	    } else if (this.mode == ContentWidget.Mode.EDIT) {
//		this.saveButton.set("label", i18n.saveButtonCaption);
		this.saveButton.set("title", i18n.projectEditSaveToolTip);
	    } else {
		throw new Error("Unsupported mode [" + this.mode + "]");
	    }		

	    WidgetHelper.updateEmptyTextBoxState(this.codeTextBox);
	    WidgetHelper.updateEmptyTextBoxState(this.nameTextBox);

	    var allFieldsValid = WidgetHelper.isTextBoxValid(this.codeTextBox) && WidgetHelper.isTextBoxValid(this.nameTextBox);
	    var saveDisabled = !!(!allFieldsValid || this.isAsyncOperationRunning());
	    this.saveButton.set("disabled", saveDisabled);
	},

	updateDataFromWidgets : function() {
	    this.projectJoin.projectCode = this.codeTextBox.get("value");
	    this.projectJoin.projectName = this.nameTextBox.get("value");
	    this.projectJoin.projectComment = this.commentTextArea.get("value");
            this.projectJoin.projectConfigWorkflowBaulosForAllNodes = this.baulosForAllNodesCheckBox.get("checked");
	},

	updateWidgetsFromData : function() {
	    this.codeTextBox.set("value", this.projectJoin.projectCode);
	    this.nameTextBox.set("value", this.projectJoin.projectName);
	    this.commentTextArea.set("value", this.projectJoin.projectComment);
            this.baulosForAllNodesCheckBox.set("checked", !!this.projectJoin.projectConfigWorkflowBaulosForAllNodes);            
	},	    

	destroy : function() {
	    this.inherited(arguments);
	}
    });

    ProjectEditPage.AsyncOperation = {

    };

    return ProjectEditPage;
});
