/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

////css-prefix = optionalDueDateEdit
////i18n-prefix = optionalDueDateEdit


define([ "cdes/util/CodeHelper",
	"cdes/widget/CalendarSpinner",
	"clazzes/TinyLog",
	"clazzes/dateTime/DateTimeSpinBox",
	"clazzes/util/DOMHelper",
	"clazzes/util/ErrorHelper",
	"clazzes/util/WidgetHelper",
	"clazzes/widgets/layout/ContentWidget",
	"dijit/form/RadioButton",
	"dijit/form/Select",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-style",
	"dojo/on",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
	function(CodeHelper,
			CalendarSpinner,
			TinyLog,
			DateTimeSpinBox,
			DOMHelper,
			ErrorHelper,
			WidgetHelper,
			ContentWidget,
			RadioButton,
			Select,
			domClass,
			domConstruct,
			domStyle,
			on,
			declare,
			lang,
			i18n) {

	var className = "at.cdes.web.planning.workflow.OptionalDueDateEditWidget";

	var log = new TinyLog(className);

	var OptionalDueDateEditWidget = declare(className, ContentWidget, {

		constructor : function(params) {
			lang.mixin(this, params);

			this.topDiv = this.constructTopDiv();

			this.allFieldsValid = true;
			this.changed = true;
		},

		getWidgetId : function() {
			return "OptionalDueDateEditWidget";
		},

		getDataId : function() {
			return null;
		},

		getContainer : function() {
			return this.topDiv;
		},

		constructTopDiv : function() {
			var topDiv = domConstruct.create("div", null, null);
			domClass.add(topDiv, "optionalDueDateEditTopDiv");

			DOMHelper.createTextNode("div", i18n.optionalDueDateEditOptionalDueDateLabel, topDiv, "propertyLabel optionalDueDateEditOptionalDueDateLabel");

			this.optionalDueDateSpinner = new CalendarSpinner({
				label : i18n.optionalDueDateEditOptionalDueDateLabel,
				/*     			    title : i18n.optionalDueDateEditOptionalDueDateToolTip, */ // Removed on ÖBB Request
				pattern : i18n.datePattern,
				timeZone : this.applicationContext.getTimeZone(),
				dndEnabled : false,
				rowObjectToString : null
			});
			domClass.add(this.optionalDueDateSpinner.domNode, "fixedDialogWidget optionalDueDateEditOptionalDueDateSpinner");
			domConstruct.place(this.optionalDueDateSpinner.domNode, topDiv);
			WidgetHelper.handleSpinnerEvents(this.optionalDueDateSpinner, lang.hitch(this, this.updateWidgetState));

			return topDiv;
		},

		setData : function(workflowNodePosition) {
			this.workflowNodePosition = workflowNodePosition;
			this.reload();	    
		},

		reload : function() {
			this.updateWidgetsFromData();
		},

		updateWidgetState : function() {
			var allFieldsValid = this.optionalDueDateSpinner.isValid();
			if (this.allFieldsValid != allFieldsValid) {
				this.allFieldsValid = allFieldsValid;
				on.emit(this, "validStateChange");		
			}
		},

		updateWidgetsFromData : function() {
			this.optionalDueDateSpinner.setUtcSeconds(this.workflowNodePosition.optionalDueDate);
		},

		updateDataFromWidgets : function() {
			this.workflowNodePosition.optionalDueDate = this.optionalDueDateSpinner.getUtcSeconds();
		},

		save : function() {
			this.updateDataFromWidgets();

			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
			var workflowNodePositionId = this.workflowNodePosition.id;
			var optionalDueDate = this.workflowNodePosition.optionalDueDate;

			var planningNotificationService = this.applicationContext.getService("planningNotificationService");
			this.registerAsyncOperationStarted(OptionalDueDateEditWidget.AsyncOperation.SAVE);
			return planningNotificationService.updateOptionalDueDate(organisationPersonId, workflowNodePositionId, optionalDueDate).then(
					lang.hitch(this, function() {
						this.registerAsyncOperationFinished(OptionalDueDateEditWidget.AsyncOperation.SAVE);
					}),
					lang.hitch(this, function(err) {
						ErrorHelper.processAsyncError({
							err : err,
							widget : this,
							asyncOperation : OptionalDueDateEditWidget.AsyncOperation.SAVE,
							opName : "updateOptionalDueDate",
							message : i18n.dueDateEditUpdateDueDateFailed
						});
					})).otherwise(
							lang.hitch(this, function(err) {
								log.error("Error while calling function [updateOptionalDueDate]", err);
							}));			    
		},	    

		destroy : function() {
			this.inherited(arguments);
		}
	});

	OptionalDueDateEditWidget.AsyncOperation = {
			SAVE : "Save"
	};

	return OptionalDueDateEditWidget;
});
