define([ 
        "cdes/widget/ContextBar",
        "clazzes/TinyLog",
        "clazzes/topic",
        "clazzes/util/DOMHelper",
        "clazzes/util/ErrorHelper",
        "clazzes/widgets/layout/ContentWidget",
        "dijit/form/TextBox",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/dom-style",
        "dojo/dom-attr",
        "dojo/on",
        "dojo/string",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
],
function(
         ContextBar,
         TinyLog,
         topic,
         DOMHelper,
         ErrorHelper,
         ContentWidget,
         TextBox,
         domClass,
         domConstruct,
         domStyle,
         domAttr,
         on,
         string,
         declare,
         lang,
         i18n
         ) {
    
    var className = "at.cdes.web.help.AboutPage";

    var log = new TinyLog(className);
    
    var AboutPage = declare(className, ContentWidget, {
        
        constructor : function(params) {
            lang.mixin(this,params);
            
            this.topDiv = this.constructTopDiv();
            
            this.updateWidgetState();
            
            this.allFieldsValid = true;
            
            this.reload();
        },
        
        getWidgetId : function() {
            return "AboutPage";
        },
        
        getDataId : function() {
            return null;
        },
        
        getContainer : function() {
            return this.topDiv;
        },
        
        constructTopDiv : function() {                  
            var topDiv = domConstruct.create("div", null, null);
            
            // Caption Bar
            this.captionBarDiv = this.constructCaptionBar();
            domClass.add(this.captionBarDiv, "aboutPageCaptionBar");
            domConstruct.place(this.captionBarDiv, topDiv);

            // PlotOrderListWidget
            this.contentDiv = this.constructContentDiv();
            domConstruct.place(this.contentDiv, topDiv);

            return topDiv;
        },
        
        constructCaptionBar : function() {
            // Caption Bar consisting of caption and context bar right of the caption
            var captionBarDiv = domConstruct.create("div", null, null);
            
            // Caption
            this.captionDiv = DOMHelper.createTextNode("h1", i18n.aboutPageCaption, captionBarDiv, "aboutPageCaption");
            
            return captionBarDiv;
        },

        constructContentDiv : function() {
            var contentDiv = domConstruct.create("div", null, null);
            domClass.add(contentDiv, "refNodeOfPositionAbsolute aboutPageContentDiv");
            
            // Name
            //              DOMHelper.createTextNode("span", i18n.aboutPageNameLabel, contentDiv, "propertyLabel aboutPageNameLabel");
            nodeName = DOMHelper.createTextNode("span", "", contentDiv, "propertyLabel aboutPageNameTextBox");
            domStyle.set(nodeName, "text-align", "left");
            domStyle.set(nodeName, "font-size", "18px");
            domStyle.set(nodeName, "font-weight", "bold");
            //              this.nameTextBox = new TextBox({
            //                          label : i18n.aboutPageNameLabel,
            //                          title : i18n.aboutPageNameToolTip,
            //                       disabled : true
            //              });
            //              domClass.add(this.nameTextBox.domNode, "fixedDialogWidget aboutPageNameTextBox");
            //              domConstruct.place(this.nameTextBox.domNode, contentDiv);
            
            // Version
            DOMHelper.createTextNode("span", i18n.aboutPageVersionLabel, contentDiv, "propertyLabel aboutPageVersionLabel");
            nodeVersion = DOMHelper.createTextNode("span", "", contentDiv, "propertyLabel aboutPageVersionTextBox");
            domStyle.set(nodeVersion, "text-align", "left");
            domStyle.set(nodeVersion, "font-weight", "bold");
            //              this.versionTextBox = new TextBox({
            //                          label : i18n.aboutPageVersionLabel,
            //                          title : i18n.aboutPageVersionToolTip,
            //                       disabled : true
            //              });
            //              domClass.add(this.versionTextBox.domNode, "fixedDialogWidget aboutPageVersionTextBox");
            //              domConstruct.place(this.versionTextBox.domNode, contentDiv);
            
            // Revision
            DOMHelper.createTextNode("span", i18n.aboutPageRevisionLabel, contentDiv, "propertyLabel aboutPageRevisionLabel");
            nodeRevision = DOMHelper.createTextNode("span", "", contentDiv, "propertyLabel aboutPageRevisionTextBox");
            domStyle.set(nodeRevision, "text-align", "left");
            domStyle.set(nodeRevision, "font-weight", "bold");
            //              this.revisionTextBox = new TextBox({
            //                          label : i18n.aboutPageRevisionLabel,
            //                          title : i18n.aboutPageRevisionToolTip,
            //                       disabled : true
            //              });
            //              domClass.add(this.revisionTextBox.domNode, "fixedDialogWidget aboutPageRevisionTextBox");
            //              domConstruct.place(this.revisionTextBox.domNode, contentDiv);
            
            // Date
            DOMHelper.createTextNode("span", i18n.aboutPageDateLabel, contentDiv, "propertyLabel aboutPageDateLabel");
            nodeDate = DOMHelper.createTextNode("span", "", contentDiv, "propertyLabel aboutPageDateTextBox");
            domStyle.set(nodeDate, "text-align", "left");
            domStyle.set(nodeDate, "font-weight", "bold");
            //              this.dateTextBox = new TextBox({
            //                          label : i18n.aboutPageDateLabel,
            //                          title : i18n.aboutPageDateToolTip,
            //                       disabled : true
            //              });
            //              domClass.add(this.dateTextBox.domNode, "fixedDialogWidget aboutPageDateTextBox");
            //              domConstruct.place(this.dateTextBox.domNode, contentDiv);
            
            // Implementation
            DOMHelper.createTextNode("span", i18n.aboutPageImplementationLabel, contentDiv, "propertyLabel aboutPageImplementationLabel");
            nodeImplementation = DOMHelper.createTextNode("span", "", contentDiv, "propertyLabel aboutPageImplementationTextBox");
            domStyle.set(nodeImplementation, "text-align", "left");
            domStyle.set(nodeImplementation, "font-weight", "bold");
            //              this.implementationTextBox = new TextBox({
            //                          label : i18n.aboutPageImplementationLabel,
            //                          title : i18n.aboutPageImplementationToolTip,
            //                       disabled : true
            //              });
            //              domClass.add(this.implementationTextBox.domNode, "fixedDialogWidget aboutPageImplementationTextBox");
            //              domConstruct.place(this.implementationTextBox.domNode, contentDiv);
            
            // WebDesign
            //              DOMHelper.createTextNode("span", i18n.aboutPageWebDesignLabel, contentDiv, "propertyLabel aboutPageWebDesignLabel");
            //              nodeWebDesign = DOMHelper.createTextNode("span", "", contentDiv, "propertyLabel aboutPageWebDesignTextBox");
            //              domStyle.set(nodeWebDesign, "text-align", "left");
            //              domStyle.set(nodeWebDesign, "font-weight", "bold");
            //              this.webDesignTextBox = new TextBox({
            //                          label : i18n.aboutPageWebDesignLabel,
            //                          title : i18n.aboutPageWebDesignToolTip,
            //                       disabled : true
            //              });
            //              domClass.add(this.webDesignTextBox.domNode, "fixedDialogWidget aboutPageWebDesignTextBox");
            //              domConstruct.place(this.webDesignTextBox.domNode, contentDiv);
            
            
            return contentDiv;
        },
        
        resize : function(newSize) {
            var totalHeight = newSize.h;  

            var tableWidth = this.contextBarDiv.offsetWidth - 15;
            var contentHeight = totalHeight
                              //- this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")
                              - this.captionBarDiv.offsetHeight
                              - 16;
            
            domStyle.set(this.contentDiv, "height", contentHeight + "px");
        },
        
        setData : function() {

        },
        
        reload : function() {
            //this.contextBar.reload();
            
            var contextService = this.applicationContext.getService("contextService");
            
            // If the previous search still runs, cancel it
            if (this.deferred != null) {
                this.deferred.cancel();
            }
            
            // Trigger async search request
            this.deferred = contextService.getVersionInfo();
            
            // Update button state etc.
            this.registerAsyncOperationStarted(AboutPage.AsyncOperation.GET_DATA);
            this.updateWidgetState();
            this.deferred.then(lang.hitch(this, function(versionInfo) {
                
                topic.publish("message/ok", i18n.aboutPageLoadOk);

                delete this.deferred;
                
                domAttr.set(nodeName, "innerHTML", "c.des concurrent design " +i18n.aboutPageNameContent);
                domAttr.set(nodeVersion, "innerHTML", versionInfo.bundleVersion);
                domAttr.set(nodeRevision, "innerHTML", versionInfo.svnVersion);
                domAttr.set(nodeDate, "innerHTML", versionInfo.buildTimeStamp);
                domAttr.set(nodeImplementation, "innerHTML", i18n.aboutPageImplementationContent);
                //                      domAttr.set(nodeWebDesign, "innerHTML", i18n.aboutPageWebDesignContent);
                
                //                              this.nameTextBox.set("value", i18n.aboutPageNameContent);
                //                              this.versionTextBox.set("value", versionInfo.bundleVersion);
                //                              this.revisionTextBox.set("value", versionInfo.svnVersion);
                //                              this.dateTextBox.set("value", versionInfo.buildTimeStamp);
                //                              this.implementationTextBox.set("value", i18n.aboutPageImplementationContent);
                //                              this.webDesignTextBox.set("value", i18n.aboutPageWebDesignContent);                     
                
                this.registerAsyncOperationFinished(AboutPage.AsyncOperation.GET_DATA);
                this.updateWidgetState();
            }),
                lang.hitch(this, function(err) {                        
                    delete this.deferred;
                    
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : AboutPage.AsyncOperation.GET_DATA,
                                opName : "getVersionInfo",
                               message : i18n.aboutPageLoadFailed
                    });                             
                })
                ).otherwise(lang.hitch(this, function(err) {
                    log.error("Error while processing the results of calling getVersionInfo: ", err);
                }));  
        },
        
        updateWidgetState : function() {

        },
        
        destroy : function() {
            this.inherited(arguments);
        }
    });
    
    AboutPage.AsyncOperation = {
        GET_DATA : "GetData"
    };
    
    return AboutPage;
});
