/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

////css-prefix = planningNotificationTemplateList
////i18n-prefix = planningNotificationTemplateList

define([ "cdes/util/ActionHelper",
	"cdes/widget/base/ListWidget",
	"clazzes/TinyLog",
	"clazzes/form/FancyButton",
	"clazzes/util/ErrorHelper",
	"clazzes/widgets/layout/ContentWidget",
	"clazzes/widgets/layout/InfoDialog",
	"dgrid/OnDemandGrid",
	"dgrid/extensions/ColumnResizer",
	"dgrid/extensions/DijitRegistry",
	"dijit/form/Button",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/on",
	"dojo/topic",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dstore/Memory",
	"dstore/Trackable",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
	function(ActionHelper,
			ListWidget,
			TinyLog,
			FancyButton,
			ErrorHelper,
			ContentWidget,
			InfoDialog,
			OnDemandGrid,
			ColumnResizer,
			DijitRegistry,
			Button,
			domClass,
			domConstruct,
			on,
			topic,
			declare,
			lang,
			Memory,
			Trackable,
			i18n) {

	var className = "at.cdes.web.planning.template.PlanningNotificationTemplateListWidget";

	var log = new TinyLog(className);

	var PlanningNotificationTemplateListWidget = declare(className, ListWidget, {

		constructor : function(params) {
			lang.mixin(this, params);

			this.topDiv = this.constructTopDiv();

			this.allFieldsValid = true;
		},

		getWidgetId : function() {
			return "PlanningNotificationTemplateListWidget";
		},

		getDataId : function() {
			return null;
		},

		getContainer : function() {
			return this.topDiv;
		},

        columnWidthKey : "planningNotificationTemplate/columnWidths",

        getLocalStorageContextKeys : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            return [organisationPersonId ];
        },

		constructColumns : function() {
			var columns = [];

			columns.push({
				field : "name",
				id : "name",
				sortable : true,
				label : i18n.planningNotificationTemplateListNameColumn
			});

			columns.push({
				field : "comment",
				id : "comment",
				sortable : true,
				label : i18n.planningNotificationTemplateListCommentColumn
			});	    

			columns.push({
				field : "globalTemplate",
				id : "globalTemplate",
				formatter : lang.hitch(this, this.globalTemplateFormatter),
				sortable : true,
				label : i18n.planningNotificationTemplateListGlobalTemplateColumn
			});	    

			columns.push({
				field : "id",
				id : "actions",
				renderCell : lang.hitch(this, this.renderActionCell),
				sortable : false,
				label : i18n.actionColumnCaption
			});

			return columns;
		},

		globalTemplateFormatter : function(globalTemplate, planningNotificationTemplate) {
			if (globalTemplate) {
				return i18n.yes;
			} else {
				return i18n.no;
			}		
		},

		renderActionCell : function(dataObject, data, cell) {
			var buttonDiv = domConstruct.create("div", null, null);

			if (true) { // TODO
				var editButton = this.constructEditButton(dataObject);
				domConstruct.place(editButton.domNode, buttonDiv);
			}

			if (true) {
				var deleteButton = this.constructDeleteButton(dataObject);
				domConstruct.place(deleteButton.domNode, buttonDiv);		
			}

			return buttonDiv;
		},

		constructEditButton : function(planningNotificationTemplate) {
			var button = new FancyButton({
				title : i18n.planningNotificationTemplateListEditToolTip,
				iconClass : "fancyButtonIcon17x18 fancyButton17x18 editButton"
			});

			domClass.add(button.domNode, "listButton");

			on(button, "click", lang.hitch(this, function() {
				this.applicationContext.setPage("planningNotificationTemplateEdit",
						{ mode : ContentWidget.Mode.EDIT, id : planningNotificationTemplate.id },
						{ backPage : this.backPage, backParams : this.backParams });
			}));
			return button;
		},

		constructDeleteButton : function(template) {
			var button = new FancyButton({
				title : i18n.planningNotificationTemplateListDeleteToolTip,
				iconClass : "fancyButtonIcon17x18 fancyButton17x18 deleteButton"
			});
			domClass.add(button.domNode, "listButton");

			on(button, "click", lang.hitch(this, function() {
				InfoDialog.showQuestion({
					title : i18n.planningNotificationTemplateListAskDeleteCaption,
					message : i18n.planningNotificationTemplateListAskDeleteQuestion,
					buttons : [
						{ type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
							this.doDeleteTemplate(template);
						})},    			           
						{ type : InfoDialog.Button.NO }
						]
				});
			}));		    
			return button;
		},

		doDeleteTemplate : function(template) {	
			var planningNotificationService = this.applicationContext.getService("planningNotificationService");
			this.registerAsyncOperationStarted(PlanningNotificationTemplateListWidget.AsyncOperation.DELETE);

			planningNotificationService.deleteTemplate(template).then(
					lang.hitch(this, function(result) {
						this.registerAsyncOperationFinished(PlanningNotificationTemplateListWidget.AsyncOperation.DELETE);
						if (!result) {
							topic.publish("message/error", {
								message : i18n.planningNotificationTemplateListDeleteNotPossible,
								showInDialog : true,
								details : null
							}); 
						} else {
							on.emit(this, "doSearch");
						}
					}),
					lang.hitch(this, function(err) {
						ErrorHelper.processAsyncError({
							err : err,
							widget : this,
							asyncOperation : PlanningNotificationTemplateListWidget.AsyncOperation.DELETE,
							opName : "deleteTemplate",
							message : i18n.planningNotificationTemplateListDeleteFailed
						});
					})).otherwise(
							lang.hitch(this, function(err) {
								log.error("Error while calling function [deleteMetaTag]", err);
							}));
		},	    

		constructTopDiv : function() {
			return this.constructGrid({
				idProperty : "id", 
				gridId : "PlanningNotificationTemplateListGrid"
			});
		},

		resize : function(newSize) {
			this.grid.resize(newSize);
		},

		setData : function(params) {
			this.planningNotificationTemplates = params.planningNotificationTemplates;
			this.reload();
		},

		reload : function(params) {

			this.store.setData(this.planningNotificationTemplates);

			this.grid.set("sort", "name", false);
			this.grid.updateSortArrow(this.grid.sort);
			this.grid.refresh();
		},

		destroy : function() {
			this.inherited(arguments);

			this.grid.destroy();
		}
	});

	PlanningNotificationTemplateListWidget.AsyncOperation = {
			DELETE : "Delete"
	};

	return PlanningNotificationTemplateListWidget;
});
