/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

////css-prefix = reviewProtocol
////i18n-prefix = reviewProtocol


define(["cdes/planning/order/PlanningNotificationOrderListWidget",
        "cdes/planning/workflow/WorkflowActivityResultListWidget",
        "cdes/util/JobHelper",
        "cdes/widget/ContextBar",
        "clazzes/ClazzesVoc",
        "clazzes/TinyLog",
        "clazzes/form/FancyButton",
        "clazzes/topic",
        "clazzes/util/DOMHelper",
        "clazzes/util/ErrorHelper",
        "clazzes/widgets/layout/ContentWidget",
        "clazzes/widgets/layout/FancyContentPane",
        "dijit/form/Button",
        "dijit/layout/BorderContainer",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/dom-style",
        "dojo/io-query",
        "dojo/on",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(PlanningNotificationOrderListWidget,
         WorkflowActivityResultListWidget,
         JobHelper,
         ContextBar,
         ClazzesVoc,
         TinyLog,                
         FancyButton,
         topic,
         DOMHelper,
         ErrorHelper,
         ContentWidget,
         FancyContentPane,
         Button,
         BorderContainer,
         domClass,
         domConstruct,
         domStyle,
         ioQuery,
         on,
         declare,
         lang,
         i18n) {

    var className = "at.cdes.web.planning.task.ReviewProtocolPage";

    var log = new TinyLog(className);

    var ReviewProtocolPage = declare(className, ContentWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.changed = true;
            this.orderColumnSettings = this.getOrderColumnSettings();
            this.allFieldsValid = true;            
            this.topDiv = this.constructTopDiv();

            if (this.workflowEntityIds == null) {
                if (document.readyState === 'complete') {
                    if (log.isDebugEnabled()) {
                        log.debug("Document already loaded, fetching workflowEntityIds directly.");
                    }
                    this.fetchWorkflowEntityIdsFromHiddenField();
                    this.initialize();
                } else {
                    window.addEventListener("load", lang.hitch(this, function() {
                        if (log.isDebugEnabled()) {
                            log.debug("Document not yet loaded, fetching workflowEntityIds using onLoad handler.");
                        }
                        this.fetchWorkflowEntityIdsFromHiddenField();
                        this.initialize();
                    }));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("ReviewProtocol called with workflowEntityIds in variable, not attempting to read hidden field.");
                }
                this.initialize();
            }
        },

        initialize : function() {
            this.reload();
        },

        fetchWorkflowEntityIdsFromHiddenField : function() {
            var childNodes = document.body.childNodes;
            for (var n = 0; n < childNodes.length; n++) {
                if (childNodes[n].name == "workflowEntityIds") {
                    var value = childNodes[n].value;
                    log.info("value is ", value);
                    if (value != null) {
                        var tokens = value.split(",");
                        this.workflowEntityIds = [];
                        for (var z = 0; z < tokens.length; z++) {
                            this.workflowEntityIds.push(parseInt(tokens[z]));
                        }
                    }
                    log.info("workflowEntityIds are", this.workflowEntityIds);
                    break;
                }
            }            
        },

        getWidgetId : function() {
            return "ReviewProtocolPage";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);

            // Caption Bar
            this.captionBarDiv = this.constructCaptionBar();
            domClass.add(this.captionBarDiv, "cdesGeneralPageCaptionBar");
            domConstruct.place(this.captionBarDiv, topDiv);

            // Content
            this.contentDiv = this.constructContentDiv();
            domConstruct.place(this.contentDiv, topDiv);

            return topDiv;
        },

        constructCaptionBar : function() {
            var captionBarDiv = domConstruct.create("div", null, null);

            // Caption
            this.captionDiv = DOMHelper.createTextNode("h1", i18n.workflowReviewProtocolPageCaption, captionBarDiv, "cdesGeneralPageCaption");

            // Export to pdf button
            this.constructExportToPdfButton(captionBarDiv);

            // Close button
            if (this.backPage != null) {
                this.backButton = new Button({
                    label : i18n.closeButtonCaption,
                    title : i18n.closeButtonCaption 
                });
                domClass.add(this.backButton.domNode, "reviewProtocolBackButton");
                domConstruct.place(this.backButton.domNode, captionBarDiv);
                on(this.backButton, "click", lang.hitch(this, this.goBack));
            }

            this.previousOrderButton = new Button({
                label : i18n.reviewProtocolPreviousOrderCaption,
                title : i18n.reviewProtocolPreviousOrderCaption
            });
            domClass.add(this.previousOrderButton.domNode, "reviewProtocolPreviousButton");
            domConstruct.place(this.previousOrderButton.domNode, captionBarDiv);
            on(this.previousOrderButton.domNode, "click", lang.hitch(this, this.goPreviousOrder));

            this.nextOrderButton = new Button({
                  label : i18n.reviewProtocolNextOrderCaption,
                  title : i18n.reviewProtocolNextOrderCaption
//                onClick : lang.hitch(this, this.goNextOrder)
            });
            domClass.add(this.nextOrderButton.domNode, "reviewProtocolNextButton");
            domConstruct.place(this.nextOrderButton.domNode, captionBarDiv);
            on(this.nextOrderButton, "click", lang.hitch(this, this.goNextOrder));

//            on(this.nextOrderButton.domNode, "click", lang.hitch(this, this.goNextOrder));


            /* Use this code if an icon is desired.
            // Export to pdf button
            this.exportToPdfButton = this.constructExportToPdfButton();
            domConstruct.place(this.exportToPdfButton.domNode, captionBarDiv);*/

            return captionBarDiv;
        },

        constructExportToPdfButton : function(captionBarDiv) {
            var button = new FancyButton({
                    title : i18n.reviewProtocolExportToPdfToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 exportToPdfButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, this.exportToPdf));

            domConstruct.place(button.domNode, captionBarDiv);          

            return button;
        },          

        exportToPdf : function() {
            var orderColumnToWidth = new Object();
            var orderColumns = this.orderListWidget.grid.get("columns");
            for (var n = 0; n < orderColumns.length; n++) {
                var orderColumn = orderColumns[n];
                if (!orderColumn.hidden) {
                    orderColumnToWidth[orderColumn.id] = (orderColumn.headerNode != null ? orderColumn.headerNode.clientWidth : null);
                }                   
            }               
            /*          for (var columnId in gridColumns) {
            log.info("Width of column [" + columnId + "] is: [" + gridColumns[columnId].headerNode.clientWidth + "]");
        }*/

            var historyColumnToWidth = new Object();
            var historyColumns = this.historyListWidget.grid.get("columns");
            for (var n = 0; n < historyColumns.length; n++) {
                var historyColumn = historyColumns[n];
                if (!historyColumn.hidden) {
                    historyColumnToWidth[historyColumn.id] = (historyColumn.headerNode != null ? historyColumn.headerNode.clientWidth : null);
                }                   
            }

            var planningNotificationService = this.applicationContext.getService("planningNotificationService");

            var orderSortSpecs = this.orderListWidget.getSortSpecs();
            var historySortSpecs = this.historyListWidget.getSortSpecs();

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

            topic.publish("message/info", i18n.reviewProtocolPdfExportStarted);

            this.registerAsyncOperationStarted(ReviewProtocolPage.AsyncOperation.EXPORT_TO_PDF);
            planningNotificationService.triggerExportReviewProtocol(organisationPersonId, this.id, orderColumnToWidth, historyColumnToWidth,
                orderSortSpecs, historySortSpecs).then(lang.hitch(this, function(jobId) {
                    JobHelper.registerJobStatusQueryForDownload(this.applicationContext, jobId, function(jobId) {
                        topic.publish("message/info", i18n.reviewProtocolPdfExportFinished);

                        var parameterString = ioQuery.objectToQuery({
                            jobId : jobId
                        });
                        return "/cdes-dojo-impl/download?" + parameterString;
                    });

                    this.registerAsyncOperationFinished(ReviewProtocolPage.AsyncOperation.EXPORT_TO_PDF);
                }), lang.hitch(this, function(err){                             
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : ReviewProtocolPage.AsyncOperation.EXPORT_TO_PDF,
                                opName : "triggerExportReviewProtocol",
                               message : i18n.reviewProtocolExportFailed
                    });                             
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Handling the results of executing triggerExportReviewProtocol failed", err);
                    }));                                
        },

        abort : function() {
            if (this.backPage != null) {
                this.applicationContext.setPage(this.backPage, new Object(), this.backParams);
            }            
        },      

        goBack : function() {
            this.applicationContext.setPage(this.backPage, new Object(), this.backParams);
        },

        goPreviousOrder : function() {
            this.goToPlanningNotificationOrder(-1);
        },

        goNextOrder : function() {
            this.goToPlanningNotificationOrder(1);
        },        

        goToPlanningNotificationOrder : function(offset) {
            var desiredIndex = this.currIndex != null ? this.currIndex + offset : null;

            if (desiredIndex != null && this.workflowEntityIds != null && desiredIndex >= 0 && desiredIndex < this.workflowEntityIds.length) {
                var desiredId = this.workflowEntityIds[desiredIndex];

                if (desiredId != null) {
                    this.applicationContext.setPage("workflowReviewProtocol",
                                                    { id : desiredId },
                                                    {            backPage : this.backPage,
                                                               backParams : this.backParams,
                                                        workflowEntityIds : this.workflowEntityIds
                                                    });
                }
            }
        },

        /* Use this code if an icon is desired
        constructExportToPdfButton : function(taskJoin) {
        var button = new FancyButton({
        title : i18n.reviewProtocolExportToPdfToolTip,
        iconClass : "fancyButtonIcon17x18 fancyButton17x18 exportToPdfButton"
    });

        domClass.add(button.domNode, "listButton");

        on(button, "click", lang.hitch(this, function() {

    }));
        return button;
    },*/

        constructContentDiv : function() {
            var contentDiv = domConstruct.create("div", null, null);
            domClass.add(contentDiv, "refNodeOfPositionAbsolute reviewProtocolPageContentDiv");

            this.borderContainer = new BorderContainer({
                design  : "headline",
                "class" : "occupyWholeParent"
            });


            this.constructOrderListWidget();
            this.orderListContentPane.set("region", "top");
            this.orderListContentPane.set("splitter", true);
            this.borderContainer.addChild(this.orderListContentPane);           

            this.constructHistoryListWidget();
            this.historyContentPane.set("region", "center");
            this.borderContainer.addChild(this.historyContentPane);     

            domConstruct.place(this.borderContainer.domNode, contentDiv);
            this.borderContainer.startup();
            this.orderListContentPane.resize({ h : 180 });

            return contentDiv;
        },

        constructOrderListWidget : function() {
            // List Widget
            this.orderListWidget = new PlanningNotificationOrderListWidget({
                  applicationContext : this.applicationContext,
                              gridId : "ReviewProtocolPlanningNotificationOrderGrid",
                referenceDestination : "ReviewProtocol",                 
                         showActions : false,
                            idSuffix : this.id               
            });
            this.orderListWidgetDiv = this.orderListWidget.getContainer();
            domClass.add(this.orderListWidgetDiv, "reviewProtocolOrderListDiv");

            this.orderListContentPane = new FancyContentPane({
                content : this.orderListWidget.getContainer()
            });

            on(this.orderListWidget, "finished", lang.hitch(this, function() {
                on.emit(this, "finished");
            }));            
        },          

        constructHistoryListWidget : function() {
            this.historyDiv = domConstruct.create("div", null, null);
            domClass.add(this.historyDiv, "refNodeOfPositionAbsolute");

            DOMHelper.createTextNode("h3", i18n.reviewProtocolHistoryCaption, this.historyDiv, "fixedDialogWidget reviewProtocolHistoryCaption");

            // History Widget
            this.historyListWidget = new WorkflowActivityResultListWidget({
                applicationContext : this.applicationContext,
                          idSuffix : this.id
            });
            this.historyListWidgetDiv = this.historyListWidget.getContainer();
            domClass.add(this.historyListWidgetDiv, "fixedDialogWidget reviewProtocolHistoryListDiv");
            domConstruct.place(this.historyListWidgetDiv, this.historyDiv);     
            on(this.historyListWidget, "reloadRequested", lang.hitch(this, function() {
                this.reload();
            }));

            this.historyContentPane = new FancyContentPane({
                           content : this.historyDiv,
                postResizeFunction : lang.hitch(this, this.historyPostResize)
            });
        },          

        historyPostResize : function(newSize) {
            this.historyListWidget.resize({ w : newSize.w - 25, h : newSize.h - 50 });
        },

        postResizeFunction : function(newSize) {
            // AbstractEditWidget.constructTopContainer configures calls to postResizeFunction,
            // thus we need this delegate when using the page inside a Dialog.          
            this.resize(newSize);
        },

        resize : function(newSize) {
            var totalHeight = newSize.h;

            var contentWidth = this.captionBarDiv.offsetWidth - 15;
            var contentHeight = totalHeight
                              - this.captionBarDiv.offsetHeight
                              - 16;

            domStyle.set(this.contentDiv, "height", contentHeight + "px");
            this.borderContainer.resize({ w : contentWidth, h : contentHeight });
        },

        setData : function() {

        },

        reload : function() {
            this.currIndex = null;
            if (this.workflowEntityIds != null) {
                for (var n = 0; n < this.workflowEntityIds.length; n++) {
                    if (this.workflowEntityIds[n] == this.id) {
                        this.currIndex = n;
                        break;
                    }
                }
            }

            this.orderListWidget.setData({ planningNotificationOrderInfos : [], columnSettings : this.orderColumnSettings });

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

            this.registerAsyncOperationStarted(ReviewProtocolPage.AsyncOperation.LOAD_DATA);
            var planningNotificationService = this.applicationContext.getService("planningNotificationService");
            planningNotificationService.getTaskResultInfo(organisationPersonId, this.id).then(
                lang.hitch(this, function(workflowActivityResultInfo) {
                    this.orderInfos = workflowActivityResultInfo.orderInfo != null ? [ workflowActivityResultInfo.orderInfo ] : [];

                    this.registerAsyncOperationFinished(ReviewProtocolPage.AsyncOperation.LOAD_DATA);

                    this.orderListWidget.setData({ 
                        planningNotificationOrderInfos : this.orderInfos,
                                        columnSettings : this.orderColumnSettings
                    });
                    // Transform from List to Set, for easier handling lateron.
                    var allowedGlobalActionsList = workflowActivityResultInfo.globalActions;
                    var allowedGlobalActionsSet = new Object();
                    for (var v = 0; v < allowedGlobalActionsList.length; v++) {
                        allowedGlobalActionsSet[allowedGlobalActionsList[v]] = true;
                    }
                    workflowActivityResultInfo.globalActions = allowedGlobalActionsSet;

                    this.historyListWidget.setData({
                                            resultJoins : workflowActivityResultInfo.resultJoins,
                            workflowActivityIdToBaulose : workflowActivityResultInfo.workflowActivityIdToBaulose,
                        workflowActivityIdToAttachments : workflowActivityResultInfo.workflowActivityIdToAttachments,
                                          globalActions : workflowActivityResultInfo.globalActions
                    });                     
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : ReviewProtocolPage.AsyncOperation.LOAD_DATA,
                                opName : "getTaskResultInfo",
                               message : i18n.reviewProtocolGetTaskResultInfoFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getTaskResultInfo]", err);
                    }));
        },

        updateWidgetState : function() {
            var previousDisabled = this.currIndex <= 0;
            var nextDisabled = this.workflowEntityIds == null || this.currIndex >= this.workflowEntityIds.length - 1;

            this.previousOrderButton.set("disabled", previousDisabled);
            this.nextOrderButton.set("disabled", nextDisabled);
        },

        getOrderColumnSettings : function(searchModel) {
            return {
                         showSerialNumber : true,
                                 showText : true,
                 showPlanningNotification : true,
                              showProject : true,
                          showSubjectArea : false,
                  showAuthorizedInspector : true,
                            showReference : true,
                        showStatutoryDuty : true,
                          showInvalidated : false,
                         showWorkflowNode : true,
                                showState : true,
                         showDocumentPage : false,
                     showDocumentPosition : true,
                               showSource : false,
                       showPersonInCharge : false,
                    showStatutoryDutyFrom : false,
                      showStatutoryDutyTo : false,
                showStatutoryDutyInterval : false,
                showStatutoryDutyLeadTime : false,
                 showStatutoryDutyExpired : false,
                      showSubmitAuthority : false,
                                  showTag : false,
                              showComment : false,
                              showActions : false             
            };                
        },

        destroy : function() {
            if (!this.destroyCalled) {
                this.inherited(arguments);
                this.orderListWidget.destroy();
                this.historyListWidget.destroy();
                this.destroyCalled = true;              
            }
        }
    });

    ReviewProtocolPage.AsyncOperation = {
        EXPORT_TO_PDF : "ExportTopPdf",
        LOAD_DATA : "LoadData"
    };

    return ReviewProtocolPage;
});
