define([ 
         "cdes/plot/PlotOrderListWidget",
         "cdes/util/ActionHelper",
         "cdes/util/SaveLoadHelper",
         "cdes/widget/ContextBar",
         "clazzes/TinyLog",
         "clazzes/topic",
         "clazzes/util/DOMHelper",
         "clazzes/util/ErrorHelper",
         "clazzes/widgets/layout/ContentWidget",
         "clazzes/widgets/layout/InfoDialog",
         "dijit/form/Button",
         "dijit/form/ValidationTextBox",
         "dojo/dom-class",
         "dojo/dom-construct",
         "dojo/dom-style",
         "dojo/keys",
         "dojo/on",
         "dojo/string",
         "dojo/_base/declare",
         "dojo/_base/lang",
         "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
       ],
    function(
    		 PlotOrderListWidget,
    		 ActionHelper,
    		 SaveLoadHelper,
    		 ContextBar,
    		 TinyLog,
    		 topic,
    		 DOMHelper,
    		 ErrorHelper,
    		 ContentWidget,
    		 InfoDialog,
    		 Button,
    		 ValidationTextBox,
    		 domClass,
    		 domConstruct,
    		 domStyle,
       		 Keys,
    		 on,
    		 string,
    		 declare,
    		 lang,
    		 i18n
    		 ) {
	
	var className = "at.cdes.web.plan.PlanDeliverReleasePage";

	var log = new TinyLog(className);
	
    var PlotOrderChargePage = declare(className, ContentWidget, {
    	
    	constructor : function(params) {
    		lang.mixin(this,params);
    		
    		this.topDiv = this.constructTopDiv();
    		
			this.updateWidgetState();
    		
    		this.allFieldsValid = true;
    		
    		this.reload();
    	},
    	
    	getWidgetId : function() {
    		return "PlotOrderChargePage";
    	},
    	
    	getDataId : function() {
    		return null;
    	},
    	
    	getContainer : function() {
    		return this.topDiv;
    	},
    	
    	constructTopDiv : function() {    		
    		var topDiv = domConstruct.create("div", null, null);
    		
    		// Caption Bar
    		this.captionBarDiv = this.constructCaptionBar();
    		domClass.add(this.captionBarDiv, "plotOrderChargePageCaptionBar");
    		domConstruct.place(this.captionBarDiv, topDiv);

    		// Button Bar
    		this.buttonBarDiv = this.constructButtonBar();
    		domClass.add(this.buttonBarDiv, "plotOrderChargePageButtonBar");
    		domConstruct.place(this.buttonBarDiv, topDiv);

    		// PlotOrderListWidget
    		this.listWidget = new PlotOrderListWidget({
    			applicationContext : this.applicationContext,
	                          mode : PlotOrderListWidget.Mode.CHARGE
    		});
    		this.listWidgetDiv = this.listWidget.getContainer();
    		domConstruct.place(this.listWidgetDiv, topDiv);

    		return topDiv;
    	},
    	
    	constructCaptionBar : function() {
    		// Caption Bar consisting of caption and context bar right of the caption
    		var captionBarDiv = domConstruct.create("div", null, null);
    		
    		// Caption
    		this.captionDiv = DOMHelper.createTextNode("h1", i18n.plotOrderChargePageCaption, captionBarDiv, "plotOrderChargeCaption");
    		
    		DOMHelper.createTextNode("div", i18n.plotOrderChargeSubCaption, captionBarDiv, "plotOrderChargeSubCaption");

    		return captionBarDiv;
    	},

    	constructButtonBar : function() {
    		// summary:
    		//     Constructs the button bar with buttons like "Abort editing", "Save", "Save and quit editing", etc. 
    		//     which is only visible in modes EDITING and RELEASING.  The bar is located below the status bar.
    		
    		var buttonBarDiv = domConstruct.create("div", null, null);
    		domClass.add(buttonBarDiv, "refNodeOfPositionAbsolute");
    		
    		DOMHelper.createTextNode("span", i18n.passwordLabel, buttonBarDiv, "plotOrderChargePasswordLabel");
    		
    		this.passwordTextBox = new ValidationTextBox({
    			label : i18n.passwordLabel,
    			title : i18n.plotOrderChargePasswordToolTip,
    			 type : "password"
    		});
    		domClass.add(this.passwordTextBox.domNode, "plotOrderChargePasswordTextBox");
    		domConstruct.place(this.passwordTextBox.domNode, buttonBarDiv);
     		on(this.passwordTextBox.domNode, "keyup", lang.hitch(this, this.proceedIfEnter));
    		
    		// SignButton
    		this.signButton = new Button({
    			  label : i18n.signButtonLabel,
    			  title : i18n.plotOrderChargeSignButtonToolTip,
    			onClick : lang.hitch(this, this.sign)
    		});
    		domConstruct.place(this.signButton.domNode, buttonBarDiv);
    		
    		// AbortButton
    		this.abortButton = new Button({
			     label : i18n.abortButtonCaption,
		         title : i18n.plotOrderChargeAbortButtonToolTip,
		       onClick : lang.hitch(this, this.abort) 
    		});    		
    		domClass.add(this.abortButton.domNode, "plotOrderChargeAbortButton");
    		domConstruct.place(this.abortButton.domNode, buttonBarDiv);     		

    		return buttonBarDiv;    		
    	},
    	
     	proceedIfEnter : function(e) {
 			if (e.keyCode == Keys.ENTER) {
 				this.sign();
 			}
     	},    	
    	
    	resize : function(newSize) {
    		
    		var totalHeight = newSize.h;  

    		var tableWidth = this.captionBarDiv.offsetWidth - 15;
    		var tableHeight = totalHeight
    					//- this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")
    					- this.captionBarDiv.offsetHeight
    					- this.buttonBarDiv.offsetHeight
    					- 16;
    		
    		this.listWidget.resize({ w : tableWidth, h : tableHeight });
    	},
    	
    	setData : function() {

    	},
    	
    	getPlotOrderIds : function() {
    		var plotOrderIds = [];
    		var n = 1;
    		var paramFound = true;
    		while (paramFound) {
    			var paramName = "id" + n.toString();
    			if (this[paramName]) {
    				plotOrderIds.push(this[paramName]);
    				n++;
    			} else {
    				paramFound = false;
    			}
    		}
    		return plotOrderIds;
    	},
    	
    	reload : function() {
    		//this.contextBar.reload();
    		
    		var plotService = this.applicationContext.getService("plotService");

    		// If the previous search still runs, cancel it
    		if (this.joinDeferred != null) {
    			this.joinDeferred.cancel();
    		}
    		
    		// Trigger async search request
    		var plotOrderIds = this.getPlotOrderIds();
			var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
    		this.joinDeferred = plotService.getPlotOrderJoinByIds(organisationPersonId, plotOrderIds);
    		
    		// Print out that a search is running, discard the previous data immediately, to avoid disturbing the user
    		// TODO DOMHelper.setInnerText(this.statusDiv, i18n.planDeliverCatalogueSearchRuns);
    		this.listWidget.setData({ data : [] });
    		
    		// Update button state etc.
    		this.registerAsyncOperationStarted(PlotOrderChargePage.AsyncOperation.GET_DATA);
    		this.updateWidgetState();
    		this.joinDeferred.then(lang.hitch(this, function(plotOrderJoins) {
    				// Filter out plot orders that may not be charged.
    				this.plotOrderJoins = [];
    				for (var n = 0; n < plotOrderJoins.length; n++) {
    					var plotOrderJoin = plotOrderJoins[n]; // TODO: Check condition countSigned == countTotal
    					if (plotOrderJoin.chargedStepSignatureId == null && plotOrderJoin.plotOrderCountsCountSigned != null && plotOrderJoin.plotOrderCountsCountTotal != null
    							&& plotOrderJoin.plotOrderCountsCountSigned == plotOrderJoin.plotOrderCountsCountTotal) {
    						this.plotOrderJoins.push(plotOrderJoin);
    					}
    				}
    				
    				this.listWidget.setData({ data : this.plotOrderJoins });
    				
    				topic.publish("message/ok", string.substitute(i18n.plotOrderChargeGetDataOk, {
    					numberOfPlotOrders : this.plotOrderJoins.length
    				}));
    			
    				delete this.joinDeferred;
    				
    	    		this.registerAsyncOperationFinished(PlotOrderChargePage.AsyncOperation.GET_DATA);
    				this.updateWidgetState();
    				this.passwordTextBox.focus();
   			}),
   			lang.hitch(this, function(err) {    			
				delete this.joinDeferred;
				
   				ErrorHelper.processAsyncError({
                                err : err,
                             widget : this,
                     asyncOperation : PlotOrderChargePage.AsyncOperation.GET_DATA,
                             opName : "getPlotOrderJoinById",
                            message : i18n.plotOrderChargeGetDataFailed
   				}); 				
			})
    		).otherwise(lang.hitch(this, function(err) {
    			log.error("Error while processing the results of calling getPlotOrderJoinByIds: ", err);
    		}));  
    	},
    	
    	updateWidgetState : function() {
    		/*
    		var versionString = (this.documentListVersion != null ? this.documentListVersion.toString() : "---");
    		var captionString = string.substitute(i18n.planDeliverReleasePageCaption, {
    			version : versionString
    		});
    		DOMHelper.setInnerText(this.captionDiv, captionString);
    		*/
    		var operationRunning = this.isAsyncOperationRunning();
    		this.passwordTextBox.set("disabled", operationRunning);
    		this.signButton.set("disabled", operationRunning);
    	},
    	
    	sign : function() {

    		var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
    		var projectId = this.applicationContext.getPageContextProjectId();
    		
    		var plotOrderIds = [];
    		for (var n = 0; n < this.plotOrderJoins.length; n++) {
    			plotOrderIds.push(this.plotOrderJoins[n].plotOrderId);
    		}
    		
    		var password = this.passwordTextBox.get("value");
    		
    		var plotService = this.applicationContext.getService("plotService");
    		this.signDeferred = plotService.declarePlotOrdersCharged(organisationPersonId, projectId, plotOrderIds, password);
    		
    		// Update button state etc.
    		this.registerAsyncOperationStarted(PlotOrderChargePage.AsyncOperation.SIGN);
    		this.updateWidgetState();
    		this.signDeferred.then(lang.hitch(this, function() {

    				if (log.isDebugEnabled()) {
    					log.debug("Successfully declared plot order(s) charged");	
    				}
    				
    				delete this.signDeferred;
    				
    				topic.publish("message/ok", string.substitute(i18n.plotOrderChargeSignOk, {
    					numberOfPlotOrders : plotOrderIds.length
    				}));
    				
    	    		this.registerAsyncOperationFinished(PlotOrderChargePage.AsyncOperation.SIGN);
    	    		
   	     			this.applicationContext.setPage("plotOrders", {}, {
   	     			});    	    		
   			}),
   			lang.hitch(this, function(err) {    			
				delete this.signDeferred;
				
   				ErrorHelper.processAsyncError({
                                err : err,
                             widget : this,
                     asyncOperation : PlotOrderChargePage.AsyncOperation.SIGN,
                             opName : "declarePlotOrdersCharged",
                            message : i18n.plotOrderChargeSignFailed
   				}); 				
			})
    		).otherwise(lang.hitch(this, function(err) {
    			log.error("Error while processing the results of calling releasePlanDeliverCatalogue: ", err);
    		}));    

    	},
    	
    	abort : function() {
    		this.applicationContext.setPage("plotOrders", {}, {});
    	},    	
     	
     	destroy : function() {
     		this.inherited(arguments);
     		this.listWidget.destroy();
     	}
    });
    
    PlotOrderChargePage.AsyncOperation = {
    	          GET_DATA : "GetData",
    	              SIGN : "Sign"
    };
    
    return PlotOrderChargePage;
});