define(["clazzes/TinyLog"
        //"clazzes/util/JoinHelper"
],
function(TinyLog
         // ClazzesJoinHelper
         ) {
    
    var className = "at.cdes.web.util.JoinHelper";

    var log = new TinyLog(className);       
    
    var JoinHelper = {
        
        // TODO: Method implemented in clazzes JoinHelper.  Once the next version is accessible from here, use it.
        copyJoinComponent : function(sourceJoin, destJoin, prefix, attributes) {
            for (var n = 0; n < attributes.length; n++) {
                var attribute = attributes[n];
                var fullAttributeName = prefix + attribute.substring(0, 1).toUpperCase() + attribute.substring(1); 
                destJoin[fullAttributeName] = sourceJoin[fullAttributeName];
            }
        },
        
        copyCa : function(sourceJoin, destJoin, prefix) {
            this.copyJoinComponent(sourceJoin, destJoin, prefix, 
                                   ["id", 
                                    "organisationPersonId",
                                    "caCertId",
                                    "subjectDn",
                                    "certificate",
                                    "certSerial",
                                    "certCaDn",
                                    "certValidFrom",
                                    "certValidTo",
                                    "mayIssue",
                                    "mayAuthenticate",
                                    "networkId",
                                    "privateKey"]);
        },                      

        copyCertificate : function(sourceJoin, destJoin, prefix) {
            this.copyJoinComponent(sourceJoin, destJoin, prefix, ["id", 
                                                                  "organisationPersonId", 
                                                                  "caCertId", 
                                                                  "certificateRequestId", 
                                                                  "subjectDn", 
                                                                  "certificate",
                                                                  "certSerial",
                                                                  "certValidFrom",
                                                                  "certValidTo",
                                                                  "logname",
                                                                  "privateKey",
                                                                  "mayLogin",
                                                                  "maySign",
                                                                  "createdById"]);
        },
        
        copyNetwork : function(sourceJoin, destJoin, prefix) {
            this.copyJoinComponent(sourceJoin, destJoin, prefix, 
                                   ["id",
                                    "name",
                                    "networkTypeId",
                                    "description",
                                    "maintainerId",
                                    "digestCalculatorId",
                                    "signatureCalculatorId",
                                    "ambiguousProjectCodes"]);
        },
        
        copyOrganisation : function(sourceJoin, destJoin, prefix) {
            this.copyJoinComponent(sourceJoin, destJoin, prefix, 
                                   ["id",
                                    "name",
                                    "postalAddress",
                                    "postalCode",
                                    "localityName",
                                    "stateOrProvinceName",
                                    "telephoneNumber",
                                    "mobileTelephoneNumber",
                                    "facsimileTelephoneNumber",
                                    "emailAddress",
                                    "consortiumFlag",
                                    "countryId"]);
        },      
        
        copyOrganisationPerson : function(sourceJoin, destJoin, prefix) {
            this.copyJoinComponent(sourceJoin, destJoin, prefix, 
                                   ["id",
                                    "organisationalUnitName",
                                    "personId",
                                    "organisationId",
                                    "postalAddress",
                                    "postalCode",
                                    "localityName",
                                    "stateOrProvinceName",
                                    "telephoneNumber",
                                    "mobileTelephoneNumber",
                                    "facsimileTelephoneNumber",
                                    "emailAddress",
                                    "retiredFlag",
                                    "retiredComment",
                                    "emailSendTime",
                                    "emailSendMode",
                                    "countryId",
                                    "directCertificationRequestIssuer"
                                   ]);
        },

        groupOrganisationPersonJoinsByPerson  : function(organisationPersonJoins) {
            var personIdToJoins = new Object();
            for (var n = 0; n < organisationPersonJoins.length; n++) {
                var organisationPersonJoin = organisationPersonJoins[n];
                var personId = organisationPersonJoin.personId;

                if (!(personId in personIdToJoins)) {
                    personIdToJoins[personId] = [];
                }
                personIdToJoins[personId].push(organisationPersonJoin);
            }
            return personIdToJoins;
        }
    };
    
    return JoinHelper;
});
