/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

////css-prefix = organisationPage
////i18n-prefix = organisationPage

define(["cdes/core/CdesVoc",
        "cdes/organisation/OrganisationListWidget",
        "cdes/organisation/OrganisationSearchWidget",
        "cdes/util/SearchPageHelper",
        "cdes/widget/ContextBar",
        "cdes/widget/choose/ItemChooseDialog",
        "clazzes/TinyLog",
        "clazzes/form/FancyButton",
        "clazzes/util/DOMHelper",
        "clazzes/util/ErrorHelper",
        "clazzes/util/GridHelper",
        "clazzes/util/JobHelper",
        "clazzes/widgets/layout/ChooseDialog",
        "clazzes/widgets/layout/ContentWidget",
        "clazzes/widgets/layout/InfoDialog",
        "dijit/form/Button",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/dom-style",
        "dojo/io-query",
        "dojo/on",       
        "dojo/string",
        "dojo/topic",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(
         CdesVoc,
         OrganisationListWidget,
         OrganisationSearchWidget,
         SearchPageHelper,
         ContextBar,
         ItemChooseDialog,
         TinyLog,
         FancyButton,
         DOMHelper,
         ErrorHelper,
         GridHelper,
         JobHelper,
         ChooseDialog,
         ContentWidget,
         InfoDialog,
         Button,
         domClass,
         domConstruct,
         domStyle,
         ioQuery,
         on,             
         string,
         topic,
         declare,
         lang,
         i18n) {

    var className = "at.cdes.web.organisation.OrganisationPage";

    var log = new TinyLog(className);

    var OrganisationPage = declare(className, ContentWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();
            this.allFieldsValid = true;
						
            var networkService = this.applicationContext.getService("networkService");
            networkService.getAllNetworks().then(
                lang.hitch(this, function(networks) {
                    this.registerAsyncOperationFinished(OrganisationPage.AsyncOperation.GET_NETWORKS);

                    this.searchWidget.setNetworks(networks);

	            	this.loadSearchInfo();
                }), lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : OrganisationPage.AsyncOperation.GET_NETWORKS,
                                opName : "getAllNetworks",
                               message : i18n.consortiumPageGetAllNetworksFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getAllNetworks]", err);
                    }));            
        },

        getWidgetId : function() {
            return "OrganisationPage";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);

            // Context Bar
/*            this.contextBar = new ContextBar({
                applicationContext : this.applicationContext,
                              mode : ContextBar.Mode.DEFAULT
            });
            this.contextBar.setData({ depth : ContextBar.Depth.NETWORK });
            this.contextBarDiv = this.contextBar.getContainer();
            domClass.add(this.contextBarDiv, "organisationPageContextBarDiv");
            domConstruct.place(this.contextBarDiv, topDiv); 
*/
            // Caption Bar
            this.captionBarDiv = this.constructCaptionBar();
            domClass.add(this.captionBarDiv, "cdesGeneralPageCaptionBar");
            domConstruct.place(this.captionBarDiv, topDiv);

            // Content
            this.contentDiv = this.constructContentDiv();
            domConstruct.place(this.contentDiv, topDiv);

            return topDiv;
        },

        constructCaptionBar : function() {
            var captionBarDiv = domConstruct.create("div", null, null);

            // Caption
            this.captionDiv = DOMHelper.createTextNode("h1", i18n.organisationPageCaption, captionBarDiv, "cdesGeneralPageCaption");

            return captionBarDiv;
        },

        constructExportToPdfButton : function(captionBarDiv) {
            var button = new FancyButton({
                    title : i18n.exportToPdfButtonCaption,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 exportToPdfButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, this.exportToPdf));

            domConstruct.place(button.domNode, captionBarDiv);

            return button;
        },

        constructNewButton : function(captionBarDiv) {
            var newButton = new FancyButton({ 
                label : i18n.organisationPageNewButtonCaption,
                title : i18n.organisationPageNewButtonToolTip
            });
            domClass.add(newButton.domNode, "textButton organisationPageNewOrganisationButton");
            domConstruct.place(newButton.domNode, captionBarDiv);

            on(newButton, "click", lang.hitch(this, this.addNewOrganisation));
            return newButton;
        },        

        addNewOrganisation : function() {
            if (log.isDebugEnabled()) {
                log.debug("About to call addNewOrganisation, administratedNetworks are: ");
                for (var n = 0; n < this.administratedNetworks.length; n++) {
                    var administratedNetwork = this.administratedNetworks[n];
                    log.debug("- [id = " + administratedNetwork.id + "] " + administratedNetwork.name);
                }
            }
            if (this.administratedNetworks.length == 1) {
                this.applicationContext.setPage("organisationEdit",
                                                {        mode : ContentWidget.Mode.CREATE,
                                                    networkId : this.administratedNetworks[0].id },
                                                null, "organisationList", null);
            } else if (this.administratedNetworks.length > 1) {
                this.chooseNetworkAndCreateOrganisation();
            }
        },

        chooseNetworkAndCreateOrganisation : function() {
            var columns = [];
            columns.push({
                   field : "name",
                      id : "name",
                sortable : true,
                   label : i18n.nameLabel
            });

            var chooseDialog = new ItemChooseDialog({
                applicationContext : this.applicationContext,
                             title : i18n.organisationPageChooseNetworkCaption,
                           columns : columns,
                     selectionMode : "single",
                        idProperty : "id",
                           buttons : [ 
                                      { type : ChooseDialog.Button.CHOOSE,
                                          name : "selectButton"
                                      },
                                      { type : InfoDialog.Button.ABORT,
                                          title : i18n.abortToolTip }
                           ],
                      defaultWidth : 500,
                     defaultHeight : 200,
                             items : this.administratedNetworks
            });
            on(chooseDialog, "valueChosen", lang.hitch(this, function(networks) {
                this.applicationContext.setPage("organisationEdit",
                                                {        mode : ContentWidget.Mode.CREATE,
                                                    networkId : networks[0].id },
                                                null, "organisationList", null);
            }));
            chooseDialog.show(null);            
        },

        constructContentDiv : function() {
            var contentDiv = domConstruct.create("div", null, null);
            domClass.add(contentDiv, "refNodeOfPositionAbsolute wholeRegion");

		    // Search Widget
		    this.searchWidget = new OrganisationSearchWidget({
				applicationContext : this.applicationContext
		    });
		    this.searchWidgetDiv = this.searchWidget.getContainer();
		    domConstruct.place(this.searchWidgetDiv, contentDiv);
		    on(this.searchWidget, "titlePaneToggled", lang.hitch(this, this.resize));                   
		    on(this.searchWidget, "doSearch", lang.hitch(this, this.setData));
            on(this.searchWidget, "doReloadSearchInfo", lang.hitch(this, this.doReloadSearchInfo));

    	    // Status Bar
            this.statusBarDiv = SearchPageHelper.constructSingleLineStatusBarWithQuickSearch({
                                 baseWidget : this,
                processQuickSearchChangeFct : lang.hitch(this, this.processQuickSearchChange),
                        clearQuickSearchFct : lang.hitch(this, this.clearQuickSearch)
            });
    	    domClass.add(this.statusBarDiv, "personPageStatusBar");
    	    domConstruct.place(this.statusBarDiv, contentDiv);

            // List Widget
            this.listWidget = new OrganisationListWidget({
                applicationContext : this.applicationContext,
                          backPage : "organisationList",
                        backParams : new Object()
            });
            this.listWidgetDiv = this.listWidget.getContainer();
            domClass.add(this.listWidgetDiv, "fixedDialogWidget wholeRegion");       
            domConstruct.place(this.listWidgetDiv, contentDiv);
            // Reload data after certain operations which change state have been performed
            on(this.listWidget, "discardSearchData", lang.hitch(this, this.discardSearchData));
            on(this.listWidget, "doReloadSearchInfo", lang.hitch(this, this.doReloadSearchInfo));
            on(this.listWidget, "doSearch", lang.hitch(this, this.reload));

            //this.listWidget.restoreColumnWidths();

            return contentDiv;
        },

        resize : function(newSize) {
            if (newSize) {
                this.lastNewSize = newSize;
            }

            var totalHeight = this.lastNewSize.h;                   

            var tableWidth = this.captionBarDiv.offsetWidth - 15;
            //var tableWidth = this.searchWidgetDiv.offsetWidth;
            var tableHeight = totalHeight
                            - this.captionBarDiv.offsetHeight
                            - this.searchWidgetDiv.offsetHeight - domStyle.get(this.searchWidgetDiv, "margin-top") - domStyle.get(this.searchWidgetDiv, "margin-bottom") 
            //      - this.columnWidgetDiv.offsetHeight - domStyle.get(this.columnWidgetDiv, "margin-top") - domStyle.get(this.columnWidgetDiv, "margin-bottom")
            - this.statusBarDiv.offsetHeight
            - 16;
            this.listWidget.resize({ w : tableWidth, h : tableHeight });

            /*            
            var contentHeight = totalHeight
                              - this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")
                              - this.captionBarDiv.offsetHeight
                              - 16;

            domStyle.set(this.contentDiv, "height", contentHeight + "px");
                                                                  */
        },

        discardSearchData : function() {
            this.searchWidget.discardSearchData();
        },

		loadSearchInfo : function() {
            this.doReloadSearchInfo(true);
        },

        doReloadSearchInfo : function(checkAutoLoad) {
            var networkId = this.searchWidget.getSelectedNetworkId();
            if (networkId == CdesVoc.MagicSelectOption.ALL) {
                networkId = null;
            }

            if (log.isDebugEnabled()) {
                log.debug("About to reloadSearchInfo for networkId [" + networkId + "]");
            }            

            DOMHelper.setInnerText(this.statusDiv, i18n.searchBeingInitialized);

		    var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
		    this.registerAsyncOperationStarted(OrganisationPage.AsyncOperation.LOAD_SEARCH_INFO);
		    var organisationService = this.applicationContext.getService("organisationService");
		    organisationService.getOrganisationSearchInfo(organisationPersonId, networkId).then(
				lang.hitch(this, function(searchInfo) {
				    this.registerAsyncOperationFinished(OrganisationPage.AsyncOperation.LOAD_SEARCH_INFO);
                    this.networksLoaded = true;
                    
	                if (log.isDebugEnabled()) {
	                    log.debug("Successfully queried organisationSearchInfo for networkId [" + networkId + "]");
	                }
	
	                this.administratedNetworks = searchInfo.administratedNetworks;
		    		this.searchWidget.setSearchInfo(searchInfo);
	                this.listWidget.setAdministratedNetworks(searchInfo.administratedNetworks);
	                this.networkActions = searchInfo.networkActions;
                    this.certificateAdministrationGlobal = searchInfo.certificateAdministrationGlobal;
					this.globalActions = new Object();
					for (var n = 0; n < searchInfo.globalActions.length; n++) {
						this.globalActions[searchInfo.globalActions[n]] = true;
					}                        
	
	                if (this.exportToPdfButton == null && this.networkActions != null) {
	                    this.exportToPdfButton = this.constructExportToPdfButton(this.captionBarDiv);
	                }
	                
		            if (this.newButton == null && (this.certificateAdministrationGlobal && "administrateCertificate" in this.globalActions 
                 		|| !this.certificateAdministrationGlobal && this.administratedNetworks != null && this.administratedNetworks.length > 0)) {
	                    this.newButton = this.constructNewButton(this.captionBarDiv);
	                }                    
                    //cameBack is set via this.applicationContext.popLastPageHistoryPage({ cameBack : true});
					if (checkAutoLoad && (searchInfo.enableAutoInitSearch || this.cameBack))
				    	this.reload();
			    	else if (checkAutoLoad)
						DOMHelper.setInnerText(this.statusDiv, i18n.notYetSearched);
			    	
				}),
				lang.hitch(this, function(err) {
				    ErrorHelper.processAsyncError({
						   err : err,
						widget : this,
					asyncOperation : OrganisationPage.AsyncOperation.LOAD_SEARCH_INFO,
						opName : "getOrganisationSearchInfo",
					       message : i18n.organisationPageGetSearchInfoFailed
				    });
				})).otherwise(
				    lang.hitch(this, function(err) {
						log.error("Error while calling function [getOrganisationSearchInfo]", err);
			    }));
		},

        setData : function() {
            this.reload();
            if (this.searchWidget.getNetworkChanged())
           		this.doReloadSearchInfo();
        },

        cloneAndConvertSearchModelForServer : function(searchModel) {
            return {
                organisationPersonId : searchModel.organisationPersonId,
                                  id : searchModel.id != CdesVoc.MagicSelectOption.ALL ? searchModel.id : null,
                                name : searchModel.name,
                           networkId : searchModel.networkId != CdesVoc.MagicSelectOption.ALL ? searchModel.networkId : null,
                         networkName : searchModel.networkName
            };
        },        

        reload : function() {
            this.registerAsyncOperationStarted(OrganisationPage.AsyncOperation.LOAD);

    	    DOMHelper.setInnerText(this.statusDiv, i18n.searchRuns);
            this.quickSearchTextBox.set("value", "");

            var searchModel = this.searchWidget.getSearchModel();
		    var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
		    this.applicationContext.storeInLocalStorage([organisationPersonId], "/organisationList/search", searchModel);

            searchModel = this.cloneAndConvertSearchModelForServer(searchModel);
            var organisationService = this.applicationContext.getService("organisationService");
            organisationService.getOrganisationJoins(searchModel).then(
                lang.hitch(this, function(organisationInfos) {
                    this.registerAsyncOperationFinished(OrganisationPage.AsyncOperation.LOAD);

				    var searchInfoString = this.getSearchInfoString(organisationInfos);
				    topic.publish("message/ok", searchInfoString);
				    DOMHelper.setInnerText(this.statusDiv, searchInfoString);

                    this.listWidget.setData({
                        organisationInfos : organisationInfos
                    });                 
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : OrganisationPage.AsyncOperation.LOAD,
                                opName : "getOrganisationJoins",
                               message : i18n.organisationPageLoadDataFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getOrganisationJoins]", err);
                    }));
        },

        getSearchInfoString : function(organisationInfos) {
            var numberOfOrganisations = (organisationInfos != null ? organisationInfos.length : 0);
            return string.substitute(i18n.organisationPageSearchResult, {
                count : numberOfOrganisations
            });
        },

    	processQuickSearchChange : function(force) {
    	    var newSearch = this.quickSearchTextBox.get("value");
    	    if (force || newSearch != this.lastQuickSearch) {
    		this.listWidget.filter(newSearch);
    		this.lastQuickSearch = newSearch;
    	    }
    	},
    	
    	clearQuickSearch : function() {
    	    this.quickSearchTextBox.set("value", "", false);
    	    this.processQuickSearchChange();
    	},

        updateWidgetState : function() {
            var asyncRunning = this.isAsyncOperationRunning();
            if (this.searchWidget != null) {
                this.searchWidget.setAsyncRunning(asyncRunning);
            }
        },

        exportToPdf : function() {
            var columnToWidth = this.listWidget.getColumnToWidth();
            var organisationService = this.applicationContext.getService("organisationService");
            var sortSpecs = this.listWidget.getSortSpecs({ pdf : true });
            var searchModel = this.searchWidget.getSearchModel();
            topic.publish("message/info", i18n.organisationPagePdfExportStarted);

            searchModel = this.cloneAndConvertSearchModelForServer(searchModel);

            this.registerAsyncOperationStarted(OrganisationPage.AsyncOperation.EXPORT_TO_PDF);
            organisationService.triggerExportOrganisationList(searchModel, columnToWidth, sortSpecs).then(lang.hitch(this, function(jobId) {
                JobHelper.registerJobStatusQueryForDownload(this.applicationContext, jobId, function(jobId) {
                    topic.publish("message/ok", i18n.organisationPagePdfExportFinished);

                    var parameterString = ioQuery.objectToQuery({
                        jobId : jobId
                    });
                    return "/cdes-dojo-impl/download?" + parameterString;
                });

                this.registerAsyncOperationFinished(OrganisationPage.AsyncOperation.EXPORT_TO_PDF);
            }), lang.hitch(this, function(err) { 
                ErrorHelper.processAsyncError({
                               err : err,
                            widget : this,
                    asyncOperation : OrganisationPage.AsyncOperation.EXPORT_TO_PDF,
                            opName : "triggerExportOrganisationList",
                           message : i18n.organisatonPagePdfExportFailed
                });                             
            })).otherwise(
                lang.hitch(this, function(err) {
                    log.error("Handling the results of executing triggerExportOrganisationList failed", err);
                }));
        },

        destroy : function() {
            this.inherited(arguments);
            this.listWidget.destroy();
        }
    });

    OrganisationPage.AsyncOperation = {
        EXPORT_TO_PDF : "ExportToPdf",
        GET_NETWORKS : "GetNetworks",
        LOAD : "Load",
        LOAD_SEARCH_INFO : "LoadSearchInfo"
    };

    return OrganisationPage;
});
