define([ 
         "cdes/pdc/PlanDeliverHelper",
         "cdes/pdc/PlanDeliverNewWidget",
         "clazzes/TinyLog",
         "clazzes/util/DOMHelper",
         "clazzes/util/ErrorHelper",
         "clazzes/util/JoinHelper",
         "clazzes/util/StringHelper",
         "clazzes/util/WidgetHelper",
         "clazzes/widgets/layout/ContentWidget",
         "dijit/form/Button",
         "dijit/form/Select",
         "dojo/dom-class",
         "dojo/dom-construct",
         "dojo/dom-style",
         "dojo/on",
         "dojo/string",
         "dojo/_base/declare",
         "dojo/_base/lang",
         "dojo/promise/all",
         "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
       ],
    function(
    		 PlanDeliverHelper,
    		 PlanDeliverNewWidget,
    		 TinyLog,
    		 DOMHelper,
    		 ErrorHelper,
    		 JoinHelper,
    		 StringHelper,	
    		 WidgetHelper,
    		 ContentWidget,
    		 Button,
    		 Select,
    		 domClass,
    		 domConstruct,
    		 domStyle,
    		 on,
    		 string,
    		 declare,
    		 lang,
    		 promiseAll,
    		 i18n
    		 ) {
	
	var className = "at.cdes.web.plan.PlanDeliverNewPage";

	var log = new TinyLog(className);
	
    var PlanDeliverNewPage = declare(className, ContentWidget, {
    	
    	constructor : function(params) {
    		lang.mixin(this,params);
    		
    		this.topDiv = this.constructTopDiv();
    		
			if (this.documentListReleaseVersions) {
				this.setupVersionSelect(this.documentListReleaseVersions);
				this.reload();
			} else {
	    		var subProjectId = this.applicationContext.getPageContextSubProjectId();
	    		
	    		var planDeliverService = this.applicationContext.getService("planDeliverService");
	    		
				var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
	    		this.registerAsyncOperationStarted(PlanDeliverNewPage.AsyncOperation.GET_DOCUMENT_LISTS);
	    		planDeliverService.getDocumentListReleaseVersions(organisationPersonId, subProjectId).then(lang.hitch(this, function(documentListReleaseVersions) {

	    				this.setupVersionSelect(documentListReleaseVersions);
	    				this.reload();
	    				
	    				this.registerAsyncOperationFinished(PlanDeliverNewPage.AsyncOperation.GET_DOCUMENT_LISTS);
	    			}),
	    			lang.hitch(this, function(err) {  
	       				ErrorHelper.processAsyncError({
                                        err : err,
                                     widget : this,
                             asyncOperation : PlanDeliverNewPage.AsyncOperation.GET_DOCUMENT_LISTS,
                                     opName : "getDocumentListReleaseVersions",
                                    message : i18n.planDeliverCatalogueGetVersionsFailed
	       				});  	    				
					})
	    		).otherwise(lang.hitch(this, function(err) {
	    			log.error("Error while processing the results of a call to getDocumentListReleaseVersions: ", err);
	    		}));				
			}

    		this.allFieldsValid = true;
    	},
    	
    	getWidgetId : function() {
    		return "PlanDeliverNewPage";
    	},
    	
    	getDataId : function() {
    		return null;
    	},
    	
    	getContainer : function() {
    		return this.topDiv;
    	},
    	
    	constructTopDiv : function() {
    		var topDiv = domConstruct.create("div", null, null);
    		
    		// Caption Bar
    		this.captionBarDiv = this.constructCaptionBar();
    		domConstruct.place(this.captionBarDiv, topDiv);

			// Hint Bar
			this.hintBarDiv = this.constructHintBar();
			domClass.add(this.hintBarDiv, "planDeliverNewPageHintBar");
			domConstruct.place(this.hintBarDiv, topDiv);

    		// PlanDeliverNewWidget
			this.newWidget = new PlanDeliverNewWidget({
				applicationContext : this.applicationContext,
				oldPlanDeliverJoin : this.oldPlanDeliverJoin,
				    presetObjectId : null,
			 presetObjectPlannerId : null,
		  objectPlannerIdToActions : this.objectPlannerIdToActions,
				    contentLocales : this.contentLocales
			});
			this.newWidgetDiv = this.newWidget.getContainer();
			domConstruct.place(this.newWidgetDiv, topDiv);
			
			on(this.newWidget, "warnMessage", lang.hitch(this, function(msg) {
				DOMHelper.setInnerText(this.statusBarDiv, msg);
			}));
			on(this.newWidget, "infoMessage", lang.hitch(this, function(msg) {
				DOMHelper.setInnerText(this.statusBarDiv, msg);
			}));
			on(this.newWidget, "validStateChange", lang.hitch(this, this.updateWidgetState));
			
            this.newWidget.restoreColumnWidths();

    		return topDiv;
    	},
    	
    	constructCaptionBar : function() {
    		// Caption Bar consisting of caption and context bar right of the caption
    		var captionBarDiv = domConstruct.create("div", null, null);
    		domClass.add(captionBarDiv, "cdesGeneralPageCaptionBar");
    		
    		// Caption
    		this.captionDiv = DOMHelper.createTextNode("h1", i18n.planDeliverCatalogueNewEntriesCaption, captionBarDiv, "planDeliverCatalogueCaption");

	 		// Version
	 		var options = [];
	 		
	 		this.versionSelect = new Select({
	 			   label : i18n.planDeliverCatalogueVersionLabel,
	 			   title : i18n.planDeliverCatalogueVersionToolTip,
	 			 options : options,
	 			disabled : true
	 		});
	 		domClass.add(this.versionSelect.domNode, "planDeliverCatalogueVersionSelect");
	 		domConstruct.place(this.versionSelect.domNode, captionBarDiv);
	 		WidgetHelper.handleSelectEvents(this.versionSelect, lang.hitch(this, function() {
	 			// Trigger new search, if and only if the value in the dropdown has actually changed
	 			var selectedDocumentListId = this.versionSelect.get("value");
	 			if (!this.lastSearchedDocumentListId || selectedDocumentListId != this.lastSearchedDocumentListId) {
	 				this.reload();
	 			}
	 		}));

			this.captionButtonDiv = domConstruct.create("div", null, null);
			domClass.add(this.captionButtonDiv, "planDeliverCatalogueCaptionButtonDiv");
			domConstruct.place(this.captionButtonDiv, captionBarDiv);
			
			// Save Button
			this.saveButton = new Button({
				label : i18n.planDeliverNewSaveButtonCaption,
				title : i18n.planDeliverNewSaveButtonToolTip,
				onClick : lang.hitch(this, this.save) 
			});
			domClass.add(this.saveButton.domNode, "planDeliverCatalogueSaveButton");
			domConstruct.place(this.saveButton.domNode, this.captionButtonDiv);

			// Abort Edit Button
			this.abortEditButton = new Button({
				label : i18n.planDeliverNewAbortButtonCaption,
				title : i18n.planDeliverNewAbortButtonToolTip,
				onClick : lang.hitch(this, this.abort)
			});
			domClass.add(this.abortEditButton.domNode, "planDeliverCatalogueAbortEditButton");
			domConstruct.place(this.abortEditButton.domNode, this.captionButtonDiv);

			return captionBarDiv;
    	},
    	
    	constructStatusBar : function() {
    		var statusBarDiv = domConstruct.create("div", null, null);
    		domClass.add(statusBarDiv, "refNodeOfPositionAbsolute");
    		
    		this.statusDiv = DOMHelper.createTextNode("div", "", statusBarDiv, "fixedDialogWidget planDeliverNewPageStatusDiv");
    		
    		return statusBarDiv;
    	},

		constructHintBar : function() {
			// Constructs the status bar for errors
			var hintBarDiv = domConstruct.create("div", null, null);
			domClass.add(hintBarDiv, "refNodeOfPositionAbsolute");
			domClass.add(hintBarDiv, "hidden");

			// Hint Icon
			this.hintIcon = domConstruct.create("div", null, hintBarDiv);
			domClass.add(this.hintIcon, "planDeliverCatalogueHintIcon clazzesWarnIcon32");    		
			// Hint Div
			this.hintSpan = DOMHelper.createTextNode("span", "", hintBarDiv, "planDeliverCatalogueHintSpan");

			return hintBarDiv;    		
		},

    	resize : function(newSize) {
			var totalHeight;
			if (newSize) {
				totalHeight = newSize.h;
				this.lastExternalSize = newSize;	
			} else if (this.lastExternalSize) {
				totalHeight = this.lastExternalSize.h;
			} else {
				totalHeight = window.innerHeight;
			}
			var hintBarHeight = this.hintBarDiv.offsetHeight + domStyle.get(this.hintBarDiv, "margin-top") + domStyle.get(this.hintBarDiv, "margin-bottom");
    		
    		var tableWidth = this.captionBarDiv.offsetWidth - 15;
    		var tableHeight = totalHeight
    					- this.captionBarDiv.offsetHeight
						- hintBarHeight
    					- 16;
    		
    		this.newWidget.resize({ w : tableWidth, h : tableHeight });
    	},
    	
    	setData : function() {

    	},
    	
    	reload : function() {
    		this.newWidget.reload();
    	},
    	
    	updateWidgetState : function() {
			var allFieldsOk = this.newWidget.checkFieldsOk();
			this.hint = /*allFieldsOk ? null :*/ this.newWidget.calculateHint();

			this.saveButton.set("disabled", !allFieldsOk);

			if (this.hint != null) {
				domClass.remove(this.hintBarDiv, "hidden");
				DOMHelper.setInnerText(this.hintSpan, this.hint);	
			} else {
				domClass.add(this.hintBarDiv, "hidden");
				DOMHelper.setInnerText(this.hintSpan, "");	
			}
			this.resize();
    	},
    	
     	setupVersionSelect : function(documentListReleaseVersions) {
     		var versionSelectInfo = PlanDeliverHelper.constructVersionOptions({
		                 applicationContext : this.applicationContext,
		        documentListReleaseVersions : documentListReleaseVersions
     		});
	
     		var options = versionSelectInfo.options;
     		this.unreleasedDocumentId = versionSelectInfo.unreleasedDocumentId;
	
     		this.versionSelect.set("options", options);
     		
     		// Select always the unreleased version
     		if (options.length > 0) {
     			this.versionSelect.set("value", options[0].value);
     		}
     	},

		save: function() {
			this.newWidget.save();
		},

		abort: function() {
			this.applicationContext.setPage("planDeliverCatalogue", {}, {
				gotoUnreleasedVersion: true,
				mode: PlanDeliverNewWidget.Mode.EDITING,
				cameBack: true
			});
		},
     	
     	destroy : function() {
     		this.inherited(arguments);
     		this.newWidget.destroy();
     	}
    });
    
    PlanDeliverNewPage.AsyncOperation = {
    	GET_DOCUMENT_LISTS : "GetDocumentLists"
    };
    
    return PlanDeliverNewPage;
});
