/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

////css-prefix = documentPage
////i18n-prefix = documentPage

define([
        "cdes/core/CdesVoc",
        "cdes/document/ArchiveOptionWidget",
        "cdes/document/AsBuiltSignWidget",
        "cdes/document/DocumentListWidget",
        "cdes/document/DocumentSearchWidget",
        "cdes/util/ActionHelper",
        "cdes/util/MspHelper",
//        "cdes/widget/ContextBar",
        "cdes/widget/base/SearchControllingWidget",
        "cdes/widget/msp/AnlagentypImportDialog",
        "cdes/widget/msp/MspTreeUrlChooseDialog",
        "clazzes/ClazzesVoc",
        "clazzes/TinyLog",
        "clazzes/dateTime/DateHelper",
        "clazzes/form/FancyButton",
        "clazzes/topic",
        "clazzes/util/DOMHelper",
        "clazzes/util/ErrorHelper",
        "clazzes/util/GridHelper",
        "clazzes/util/JobHelper",
        "clazzes/util/WidgetHelper",
        "clazzes/widgets/layout/ChooseDialog",
        "clazzes/widgets/layout/ContentWidget",
        "clazzes/widgets/layout/EditDialog",
        "clazzes/widgets/layout/InfoDialog",
        "dijit/form/Button",
        "dijit/form/Select",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/dom-style",
        "dojo/io-query",
        "dojo/json",
        "dojo/on",
        "dojo/string",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
], function(
            CdesVoc,
            ArchiveOptionWidget,
            AsBuiltSignWidget,
            DocumentListWidget,
            DocumentSearchWidget,
            ActionHelper,
            MspHelper,
//            ContextBar,
            SearchControllingWidget,
            AnlagentypImportDialog,
            MspTreeUrlChooseDialog,
            ClazzesVoc,
            TinyLog,
            DateHelper,
            FancyButton,
            topic,
            DOMHelper,
            ErrorHelper,
            GridHelper,
            JobHelper,
            WidgetHelper,
            ChooseDialog,
            ContentWidget,
            EditDialog,
            InfoDialog,
            Button,
            Select,
            domClass,
            domConstruct,
            domStyle,
            ioQuery,
            json,
            on,
            string,
            declare,
            lang,
            i18n
            ) {

    var className = "at.cdes.web.document.DocumentPage";

    var log = new TinyLog(className);

    var DocumentPage = declare(className, SearchControllingWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.searchSelectLabel = i18n.documentPageSearchLabel;
            this.searchSelectToolTip = i18n.documentPageSearchToolTip;
            this.searchCreateCaption = i18n.documentPageCreateSearchCaption;
            this.searchCreateToolTip = i18n.documentPageCreateButtonToolTip,
            this.searchCreateRefusedMessage = i18n.documentPageCreateRefusedMessage;
            this.searchEditCaption = i18n.documentPageEditSearchCaption;
            this.searchEditToolTip = i18n.documentPageEditButtonToolTip;
            this.searchRenameToolTip = i18n.documentPageRenameButtonToolTip;
            this.searchDeleteQuestionDialogCaption = i18n.documentPageAskDeleteDialogCaption;
            this.searchDeleteQuestionDialogText = i18n.documentPageAskDeleteDialogQuestion;
            this.searchDeleteToolTip = i18n.documentPageDeleteButtonToolTip;

            this.searchSelectCssClass = "listButton documentPageSearchSelect";
            this.searchPageName = CdesVoc.SearchPageName.DOCUMENT_LIST;

            this.allFieldsValid = true;

            this.topDiv = this.constructTopDiv();

            //                      Disabled to prevent endless loading while testing under mysql
            //                      this.reload();
            this.loadSearch();
        },

        callSearchQuery : function() {
            var projectId = this.applicationContext.getPageContextProjectId();
            var utilService = this.applicationContext.getService("utilService");
            return utilService.getAllOwnSearchJoinsByProject(projectId, this.searchPageName);
        },

        storeParsedSearchJsonContent : function(parsedJsonContent) {
            this.searchWidget.setData(parsedJsonContent);
        },

        fetchSearchContentAsJson : function() {
            var searchModel = this.searchWidget.getSearchModel();
            return json.stringify(searchModel);
        },

        updateSearchDataWithSelectedSearchProperties : function(currSearch) {
        },

        processSearchSelectionReset : function() {
        },

        getNetworkIdFromPageContext : function() {
            return this.applicationContext.getPageContextNetworkId();
        },

        getProjectIdFromPageContext : function() {
            return this.applicationContext.getPageContextProjectId();
        },

        getWidgetId : function() {
            return "DocumentPage";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);

            // Caption Bar
            this.captionBarDiv = this.constructCaptionBar();
            domConstruct.place(this.captionBarDiv, topDiv);

            // Search Widget
            this.searchWidget = new DocumentSearchWidget({
                applicationContext : this.applicationContext,
                		  cameBack : this.cameBack
            });
            this.searchWidgetDiv = this.searchWidget.getContainer();
            domConstruct.place(this.searchWidgetDiv, topDiv);
            on(this.searchWidget, "titlePaneToggled", lang.hitch(this, this.resize));
            on(this.searchWidget, "doSearch", lang.hitch(this, this.reload));

			// Status Bar
//			this.statusBarDiv = this.constructStatusBar();
//			domClass.add(this.statusBarDiv, "planDeliverCatalogueStatusBar");
//			domConstruct.place(this.statusBarDiv, topDiv);

            // List Widget
            this.listWidget = new DocumentListWidget({
                applicationContext : this.applicationContext,
                          backPage : "documentList",
                        backParams : new Object({ cameBack : true}),
                			  mode : this.mode
            });
            this.listWidgetDiv = this.listWidget.getContainer();
            domConstruct.place(this.listWidgetDiv, topDiv);

            // Reload data after certain operations which change state have been performed
            on(this.listWidget, "doSearch", lang.hitch(this, this.reload));

            // Legend
            this.legendDiv = this.constructLegendDiv();
            domConstruct.place(this.legendDiv, topDiv);

            this.initialize();

            this.listWidget.restoreColumnWidths();

            return topDiv;
        },

        constructCaptionBar : function() {
            var captionBarDiv = domConstruct.create("div", null, null);
			domClass.add(captionBarDiv, "cdesGeneralPageCaptionBar");

            // Caption
            this.captionDiv = DOMHelper.createTextNode("h1", i18n.documentPageCaption, captionBarDiv, "cdesGeneralPageCaption");

            this.constructExportToPdfButton(captionBarDiv);
			if (this.applicationContext.isActionAllowedForProject("exportReviewCycleStatus")) {
			    this.constructExportToXlsButton(captionBarDiv);
            }

            DOMHelper.createTextNode("span", i18n.documentPageSearchLabel, captionBarDiv, "documentPageSearchLabel");
            this.searchSelect = this.constructSearchSelect(captionBarDiv);

            this.newSearchButton = this.constructNewSearchButton(captionBarDiv);
            this.saveButton = this.constructSaveSearchButton(captionBarDiv);
            this.editSearchButton = this.constructEditSearchButton(captionBarDiv);
            this.deleteSearchButton = this.constructDeleteSearchButton(captionBarDiv);
            domClass.add(this.newSearchButton.domNode, "invisible");
            domClass.add(this.saveButton.domNode, "invisible");
            domClass.add(this.editSearchButton.domNode, "invisible");
            domClass.add(this.deleteSearchButton.domNode, "invisible");

/*            this.additionalButtonsDiv = domConstruct.create("div", null, null);
            domClass.add(this.additionalButtonsDiv, "fixedDialogWidget documentPageAdditionalButtonsDiv");            
            domConstruct.place(this.additionalButtonsDiv, captionBarDiv);*/
            
            this.openBPAsBuildDocumentsButton = this.constructOpenBPAsBuildDocumentsButton(captionBarDiv);

            if (this.applicationContext.isActionAllowedForProject("archiveDocumentSearch")) {
                this.createArchiveButton = this.constructCreateArchiveButton(captionBarDiv);
            }
/*            this.exportToMspButton = this.constructExportToMspButton(captionBarDiv);

            var pageContext = this.applicationContext.getPageContext();
            this.runMspNowButton = MspHelper.constructRunMspExportNowButton({
                         parentDiv : captionBarDiv,
                       buttonClass : "documentPageRunMspExportNowButton hidden",
                            widget : this,
                applicationContext : this.applicationContext
            });*/

            return captionBarDiv;
        },

        constructExportToPdfButton : function(captionBarDiv) {
            var button = new FancyButton({
                    title : i18n.documentPageExportToPdfButtonToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 exportToPdfButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, this.exportToPdf));

            domConstruct.place(button.domNode, captionBarDiv);

            return button;
        },

        constructExportToXlsButton : function(captionBarDiv) {
            var button = new FancyButton({
                    title : i18n.documentPageExportToXlsButtonToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 exportToXlsButton"
            });

            domClass.add(button.domNode, "listButton");

            on(button, "click", lang.hitch(this, this.exportToXls));

            domConstruct.place(button.domNode, captionBarDiv);

            return button;
        },

        constructCreateArchiveButton : function(captionBarDiv) {
            this.createArchiveButton = new Button({
                label : i18n.documentPageCreateArchiveButtonCaption,
                title : i18n.documentPageCreateArchiveButtonCaption
            });
            domClass.add(this.createArchiveButton.domNode, "documentPageCreateArchiveButton");
            domConstruct.place(this.createArchiveButton.domNode, captionBarDiv);
            on(this.createArchiveButton, "click", lang.hitch(this, function() {
                if (this.searchWidget.isChanged()) {
                    this.reload(lang.hitch(this, this.showArchiveCreateDialog));
                } else {
                    this.showArchiveCreateDialog();
                }
            }));
        },

/*        constructExportToMspButton : function(captionBarDiv) {
            var exportToMspButton = new Button({
                label : i18n.documentPageExportToMspButtonCaption,
                title : i18n.documentPageExportToMspButtonToolTip
            });
            domClass.add(exportToMspButton.domNode, "documentPageExportToMspButton hidden");
            domConstruct.place(exportToMspButton.domNode, captionBarDiv);
            on(exportToMspButton, "click", lang.hitch(this, function() {
                this.uploadAnlagentypenXls();
            }));
            return exportToMspButton;
        },*/

	    //jumpToBPDocList
        constructOpenBPAsBuildDocumentsButton : function(captionBarDiv) {
            var jumpToBPDocList = new Button({
                label : i18n.documentPageJumpToBPDocListButtonCaption,
                title : i18n.documentPageJumpToBPDocListButtonToolTip
            });
            domClass.add(jumpToBPDocList.domNode, "documentPageJumpToBPDocListButton hidden");
            domConstruct.place(jumpToBPDocList.domNode, captionBarDiv);
            on(jumpToBPDocList, "click", lang.hitch(this, function() {
                this.loadBPDocList();
            }));
            return jumpToBPDocList;
        },

		constructStatusBar : function() {
			var statusBarDiv = domConstruct.create("div", null, null);
			domClass.add(statusBarDiv, "refNodeOfPositionAbsolute");

			this.statusDiv = DOMHelper.createTextNode("div", i18n.notYetSearched, statusBarDiv, "fixedDialogWidget planDeliverCatalogueStatusDiv");

			return statusBarDiv;
		},

        initialize : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var subProjectId = this.applicationContext.getPageContextSubProjectId();

            //registerBasePage
            var tabSessionContextService = this.applicationContext.getService("tabSessionContextService");
            var pageName = "documentList";

            tabSessionContextService.addToPageList(dojoConfig.tabSessionId, pageName, true).then(
                lang.hitch(this, function() {
                    if (log.isDebugEnabled()) {
                        log.debug("Called UpdatePageContextService");
                    }
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : null,
                                opName : "UpdatePageContextService",
                               message : i18n.updatePageContextServiceFailedMessage
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while processing UpdatePageContextService: ", err);
                    }));

            this.registerAsyncOperationStarted(DocumentPage.AsyncOperation.LOAD_INFO);

			var documentService = this.applicationContext.getService("documentService");
			documentService.getDocumentPageInfo(organisationPersonId, subProjectId).then(
				lang.hitch(this, function(documentPageInfo) {
					this.registerAsyncOperationFinished(DocumentPage.AsyncOperation.LOAD_INFO);
					this.searchWidget.initialize(documentPageInfo);
                    this.listWidget.setContentLocales(documentPageInfo.contentLocales);

					this.enableCustomerLogo = documentPageInfo.enableCustomerLogo;
					this.isSubProjectAsBuiltType = documentPageInfo.isSubProjectAsBuiltType;
					this.subProjectAsBuiltName = documentPageInfo.subProjectAsBuiltName;

					this.globalActions = new Object();
					for (var n = 0; n < documentPageInfo.globalActions.length; n++) {
						this.globalActions[documentPageInfo.globalActions[n]] = true;
					}

                    var searchButtonClass = ("editPersonalData" in this.globalActions ? "" : "invisible");
                    domClass.replace(this.newSearchButton.domNode, searchButtonClass, "invisible");
                    domClass.replace(this.saveButton.domNode, searchButtonClass, "invisible");
                    domClass.replace(this.editSearchButton.domNode, searchButtonClass, "invisible");
                    domClass.replace(this.deleteSearchButton.domNode, searchButtonClass, "invisible");

                    var projectActions = documentPageInfo.projectActions;
/*                    var mspActionFound = false;
                    for (var n = 0; n < projectActions.length; n++) {
                        mspActionFound |= (projectActions[n] == "exportDocumentsMSP");
                    }
                    if (mspActionFound) {
                        domClass.remove(this.exportToMspButton.domNode, "hidden");
                        domClass.remove(this.runMspNowButton.domNode, "hidden");
                    } else {
                        domClass.add(this.exportToMspButton.domNode, "hidden");
                        domClass.add(this.runMspNowButton.domNode, "hidden");
                    }*/
                    if (this.isSubProjectAsBuiltType) {
            			this.openBPAsBuildDocumentsButton.set('label', string.substitute(i18n.documentPageJumpToBPDocListButtonCaption, {
                														status : this.subProjectAsBuiltName}));
                        domClass.remove(this.openBPAsBuildDocumentsButton.domNode, "hidden");
                    } else {
                        domClass.add(this.openBPAsBuildDocumentsButton.domNode, "hidden");
                    }
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : DocumentPage.AsyncOperation.LOAD_INFO,
                                opName : "getDocumentPageInfo",
                               message : i18n.documentPageGetInfoFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getDocumentPageInfo]", err);
                    }));

        },

        constructLegendDiv : function() {
            var legendDiv = domConstruct.create("div", null, null);
            domClass.add(legendDiv, "refNodeOfPositionAbsolute documentPageLegendDiv");

            DOMHelper.createTextNode("span", i18n.documentPageLegendSampleNumber, legendDiv, "documentVersionStatusU documentVersionLegend");
            DOMHelper.createTextNode("span", i18n.documentVersionStatusULegendLabel, legendDiv, "documentVersionLegend documentVersionLegendStatusULabel");
            DOMHelper.createTextNode("span", i18n.documentPageLegendSampleNumber, legendDiv, "documentVersionStatusX documentVersionLegend");
            DOMHelper.createTextNode("span", i18n.documentVersionStatusXLegendLabel, legendDiv, "documentVersionLegend documentVersionLegendStatusXLabel");
            DOMHelper.createTextNode("span", i18n.documentPageLegendSampleNumber, legendDiv, "documentVersionStatusUObjectPlannerDeleted documentVersionLegend");
            DOMHelper.createTextNode("span", i18n.documentVersionStatusUObjectPlannerDeletedLegendLabel, legendDiv, "documentVersionLegend documentVersionLegendStatusUObjectPlannerDeletedLabel");

            return legendDiv;
        },
        
		loadBPDocList : function() {

			this.mode = "asBuiltMode";
			this.openBPAsBuildDocumentsButton.set("disabled", true);
				
            // Set up searchmodel
            var searchModel = this.searchWidget.getSearchModel();
			//this.storeInLocalStorage(searchModel);
			//we have to replace the subProjectId by as_built_reference

            var documentService = this.applicationContext.getService("documentService");

            // If the previous search still runs, cancel it
            if (this.joinDeferred != null) {
                this.joinDeferred.cancel();
            }

            var prevSeconds = DateHelper.getCurrentTimeSeconds();
            topic.publish("message/info", i18n.documentPageLoadDataRunning);

            searchModel = this.cloneAndConvertSearchModelForServer(searchModel);

            this.registerAsyncOperationStarted(DocumentPage.AsyncOperation.LOAD_DATA_BP);
            this.joinDeferred = documentService.getDocumentListAsBuiltJoin(searchModel);

            this.joinDeferred.then(lang.hitch(this, function(documentData) {
                var documentListRowsAsBuilt = documentData.documentListRows;
                var objectPlannerIdToActionsAsBuilt = documentData.objectPlannerIdToActions;
                var cycleInfo = documentData.cycleInfo;

                var postSeconds = DateHelper.getCurrentTimeSeconds();
                var searchInfoString = this.getSearchInfoString(documentListRowsAsBuilt, (postSeconds - prevSeconds));
                topic.publish("message/ok", searchInfoString);
                DOMHelper.setInnerText(this.searchWidget.statusDiv, searchInfoString);

                delete this.joinDeferred;
                this.registerAsyncOperationFinished(DocumentPage.AsyncOperation.LOAD_DATA_BP);
                
                this.loadAsBuiltModeDialog(documentListRowsAsBuilt, objectPlannerIdToActionsAsBuilt, cycleInfo, this.mode);
	                
            }), lang.hitch(this, function(err) {
                delete this.joinDeferred;

                ErrorHelper.processAsyncError({
                               err : err,
                            widget : this,
                    asyncOperation : DocumentPage.AsyncOperation.LOAD_DATA_BP,
                            opName : "getDocumentListJoin",
                           message : i18n.documentPageLoadDataFailed
                });
            })
                ).otherwise(lang.hitch(this, function(err) {
                    log.error("Error while processing the results of calling getDocumentListJoin: ", err);
                }));			
				
		},

		loadAsBuiltModeDialog : function (documentListRowsToMove, objectPlannerIdToActions, cycleInfo, mode) {
			
		    contentWidgetAsBuilt = new AsBuiltSignWidget({
					applicationContext : this.applicationContext,
							  backPage : this.backPage,
							backParams : this.backParams,
	                              mode : mode                
		    });
	
		    var editDialogAsBuilt = new EditDialog({
					contentWidget : contentWidgetAsBuilt,
					defaultWidth  : 1600,  // Should be in sync with corresponding rules in CSS
					defaultHeight : 800,
							title : string.substitute(i18n.documentPageAsBuiltCaption, {status : this.subProjectAsBuiltName}),
		      			  buttons : [ { type : ClazzesVoc.Button.SAVE, label : i18n.documentPageAsBuiltSaveLabel, title : i18n.documentPageAsBuiltSaveToolTip },
//		      			  			  { type : ClazzesVoc.Button.CUSTOM, name : "createAsBuiltButton", label : i18n.documentPageAsBuiltSaveOnlyDocumentReferenceLabel, title : i18n.documentPageAsBuiltSaveOnlyDocumentReferenceToolTip, fct : contentWidgetAsBuilt.createAsBuilt },
		      			  			  { type : ClazzesVoc.Button.REVERT, label : i18n.documentPageAsBuiltSaveOnlyDocumentReferenceLabel, title : i18n.documentPageAsBuiltSaveOnlyDocumentReferenceToolTip },
    				  				  { type : ClazzesVoc.Button.ABORT, title : i18n.documentPageAsBuiltAbortLabelToolTip } ]
		    });
		    editDialogAsBuilt.setData({
                        documentListRows : documentListRowsToMove,
                objectPlannerIdToActions : objectPlannerIdToActions,
                			   cycleInfo : cycleInfo
            });                
	    	editDialogAsBuilt.show();            

            on(contentWidgetAsBuilt, "batchSignCompleted", lang.hitch(this, function() {
				editDialogAsBuilt.destroy();
				this.openBPAsBuildDocumentsButton.set("disabled", false);
                this.reload();
            }));

			on(contentWidgetAsBuilt, "batchAborted", lang.hitch(this, function() {
				this.openBPAsBuildDocumentsButton.set("disabled", false);
			}));
			
		},
		
        exportToPdf : function() {
            var documentService = this.applicationContext.getService("documentService");

            var columnToWidth = GridHelper.getColumnToWidth(this.listWidget.grid);
            var sortSpecs = this.listWidget.getSortSpecs();

            var searchModel = this.searchWidget.getSearchModel();

			topic.publish("message/info", i18n.documentPageExportToPdfStarted);

            searchModel = this.cloneAndConvertSearchModelForServer(searchModel);

			this.registerAsyncOperationStarted(DocumentPage.AsyncOperation.EXPORT_TO_PDF);
			documentService.triggerExportDocumentPage(searchModel, columnToWidth, sortSpecs).then(lang.hitch(this, function(jobId) {
				JobHelper.registerJobStatusQueryForDownload(this.applicationContext, jobId, function(jobId) {
					topic.publish("message/ok", i18n.documentPageExportToPdfFinished);

                    var parameterString = ioQuery.objectToQuery({
                        jobId : jobId
                    });
                    return "/cdes-dojo-impl/download?" + parameterString;
                });

                this.registerAsyncOperationFinished(DocumentPage.AsyncOperation.EXPORT_TO_PDF);
            }), lang.hitch(this, function(err){
                ErrorHelper.processAsyncError({
                               err : err,
                            widget : this,
                    asyncOperation : DocumentPage.AsyncOperation.EXPORT_TO_PDF,
                            opName : "triggerExportDocumentPage",
                           message : i18n.documentPageExportFailed
                });
            })
                ).otherwise(lang.hitch(this, function(err) {
                    log.error("Handling the results of executing triggerExportDocumentPage failed", err);
                }));
        },

        exportToXls : function() {
            var documentService = this.applicationContext.getService("documentService");

            var columnToWidth = GridHelper.getColumnToWidth(this.listWidget.grid);
            var sortSpecs = this.listWidget.getSortSpecs();

            var searchModel = this.searchWidget.getSearchModel();

			topic.publish("message/info", i18n.documentPageExportToXlsStarted);

            searchModel = this.cloneAndConvertSearchModelForServer(searchModel);

			this.registerAsyncOperationStarted(DocumentPage.AsyncOperation.EXPORT_TO_XLS);
			documentService.triggerExportDocumentPageXls(searchModel, columnToWidth, sortSpecs).then(lang.hitch(this, function(jobId) {
				JobHelper.registerJobStatusQueryForDownload(this.applicationContext, jobId, function(jobId) {
					topic.publish("message/ok", i18n.documentPageExportToXlsFinished);

                    var parameterString = ioQuery.objectToQuery({
                        jobId : jobId
                    });
                    return "/cdes-dojo-impl/download?" + parameterString;
                });

                this.registerAsyncOperationFinished(DocumentPage.AsyncOperation.EXPORT_TO_XLS);
            }), lang.hitch(this, function(err){
                ErrorHelper.processAsyncError({
                               err : err,
                            widget : this,
                    asyncOperation : DocumentPage.AsyncOperation.EXPORT_TO_XLS,
                            opName : "triggerExportDocumentPageXls",
                           message : i18n.documentPageExportFailed
                });
            })
                ).otherwise(lang.hitch(this, function(err) {
                    log.error("Handling the results of executing triggerExportDocumentPage failed", err);
                }));	
		},

        showArchiveCreateDialog : function() {
            var searchModel = this.searchWidget.getSearchModel();
            searchModel = this.cloneAndConvertSearchModelForServer(searchModel);

            this.registerAsyncOperationStarted(DocumentPage.AsyncOperation.GET_ARCHIVE_CREATE_DATA);
            var documentService = this.applicationContext.getService("documentService");

            documentService.getArchiveCreateData(searchModel).then(
                lang.hitch(this, function(archiveCreateData) {
                    this.doShowArchiveCreateDialog(archiveCreateData);
                    this.registerAsyncOperationFinished(DocumentPage.AsyncOperation.GET_ARCHIVE_CREATE_DATA);
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : DocumentPage.AsyncOperation.GET_ARCHIVE_CREATE_DATA,
                                opName : "getArchiveCreateData",
                               message : i18n.documentPageGetArchiveCreateDataFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getArchiveCreateData]", err);
                    }));
        },

        doShowArchiveCreateDialog : function(archiveCreateData) {
            var contentWidget = new ArchiveOptionWidget({
                applicationContext : this.applicationContext,
                 numberOfDocuments : this.documentListRows.length,
                 archiveCreateData : archiveCreateData
            });

            var editDialog = new EditDialog({
                contentWidget : contentWidget,
                 defaultWidth : 420,
                defaultHeight : 180,
                        title : i18n.documentPageCreateArchiveDialogCaption,
                      buttons : [
                                 {
                                      type : ClazzesVoc.Button.CREATE_AND_CLOSE,
                                     label : i18n.documentPageCreateArchiveButtonCaption,
                                     title : i18n.documentPageCreateArchiveButtonCaption
                                 },
                                 { type : InfoDialog.Button.ABORT, title : i18n.abortToolTip }
                      ]
            });
            	editDialog.setData({
            });
            on(editDialog, "created", lang.hitch(this, function() {
                var searchModel = this.searchWidget.getSearchModel();
                searchModel = this.cloneAndConvertSearchModelForServer(searchModel);

                var archiveFileFormat = contentWidget.getArchiveFileFormat();
                var archiveScope = contentWidget.getArchiveScope();
                var doIncludeReviewHistory = contentWidget.doIncludeReviewHistory();

                var prevSeconds = DateHelper.getCurrentTimeSeconds();
                this.registerAsyncOperationStarted(DocumentPage.AsyncOperation.EXPORT_ARCHIVE);
                var documentService = this.applicationContext.getService("documentService");
                documentService.triggerExportDocumentVersionArchive(searchModel, archiveFileFormat, archiveScope, doIncludeReviewHistory).then(lang.hitch(this, function(jobId) {
                    topic.publish("message/message", i18n.documentPageExportArchiveStarted);

                    JobHelper.registerJobStatusQueryForDownload(this.applicationContext, jobId, lang.hitch(this, function(jobId) {
                        var postSeconds = DateHelper.getCurrentTimeSeconds();

                        topic.publish("message/ok", string.substitute(i18n.documentPageExportArchiveFinished, {
                            duration : (postSeconds - prevSeconds).toFixed(2)
                        }));

                        var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
                        var parameterString = ioQuery.objectToQuery({
                            jobId : jobId,
                             opId : organisationPersonId
                        });
                        return "/cdes-dojo-impl/repositoryDownload?" + parameterString;
                    }));

                    this.registerAsyncOperationFinished(DocumentPage.AsyncOperation.EXPORT_ARCHIVE);
                }), lang.hitch(this, function(err){
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : DocumentPage.AsyncOperation.EXPORT_ARCHIVE,
                                opName : "triggerExportDocumentVersionArchive",
                               message : i18n.documentPageExportArchiveFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Handling the results of executing triggerExportDocumentVersionArchive failed", err);
                    }));
            }));
            editDialog.show();

            on(editDialog, "dialogClosed", function() {
                contentWidget.destroy();
            });
        },

        uploadAnlagentypenXls : function() {
            var chooseDialog = new AnlagentypImportDialog({
                applicationContext : this.applicationContext,
                             title : i18n.documentPageAnlagentypImportDialogCaption,
                           buttons : [
                                      { type : ChooseDialog.Button.CHOOSE,
                                           name : "selectButton",
                                          label : i18n.forward
                                      },
                                      { type : InfoDialog.Button.ABORT,
                                          title : i18n.abortToolTip }
                           ],
                      defaultWidth : 440,
                     defaultHeight : 180
            });

            on(chooseDialog, "valueChosen", lang.hitch(this, function(result) {
                this.readAndCheckAnlagentypFile(result.tempFileName);

            }));
            chooseDialog.show(null);
        },

        readAndCheckAnlagentypFile : function(tempFileName) {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            this.registerAsyncOperationStarted(DocumentPage.AsyncOperation.CHECK_ANLAGENTYPEN);
            var documentService = this.applicationContext.getService("documentService");
            documentService.readAndCheckAnlagentypFile(organisationPersonId, tempFileName).then(lang.hitch(this, function(fileInfo) {
                //                              topic.publish("message/ok", i18n.documentPageRegisterMspExportSuccess);
                if (fileInfo.errorMessages.length == 0) {
                    this.chooseMspItemForExport({
                               anlagentypTempFileName : tempFileName,
                        objectPlannerIdToAnlagentypen : fileInfo.objectPlannerIdToAnlagentypen
                    });
                } else {
                    var infoDialog = new InfoDialog({
                         defaultWidth : 600,
                        defaultHeight : 450,
                                title : i18n.documentPageAnlagentypXlsProblemCaption,
                              content : this.constructFileInfoMessageDiv(fileInfo.errorMessages),
                              buttons : [ { type : InfoDialog.Button.OK }
                              ]
                    });
                    infoDialog.show();
                }

                this.registerAsyncOperationFinished(DocumentPage.AsyncOperation.CHECK_ANLAGENTYPEN);
            }), lang.hitch(this, function(err) {
                delete this.joinDeferred;

                ErrorHelper.processAsyncError({
                               err : err,
                            widget : this,
                    asyncOperation : DocumentPage.AsyncOperation.CHECK_ANLAGENTYPEN,
                            opName : "readAndCheckAnlagentypFile",
                           message : i18n.documentPageReadAndCheckAnlagentypFileFailed
                });
            })
                ).otherwise(lang.hitch(this, function(err) {
                    log.error("Error while processing the results of calling [readAndCheckAnlagentypFile]: ", err);
                }));
        },

        constructFileInfoMessageDiv : function(messages) {
            var topDiv = domConstruct.create("div", null, null);
            domClass.add(topDiv, "resultSummaryTopDiv occupyWholeParent");

            DOMHelper.createTextNode("h4", i18n.documentPageAnlagentypXlsHasErrorsCaption, topDiv, "");

            var     enumerationNode = DOMHelper.constructEnumeration(messages);
            domConstruct.place(enumerationNode, topDiv);

            return topDiv;
        },

        chooseMspItemForExport : function(params) {
            var chooseDialog = new MspTreeUrlChooseDialog({
                applicationContext : this.applicationContext,
                             title : i18n.planningNotificationHelperChooseMspItemForExportCaption,
                           buttons : [
                                      { type : ChooseDialog.Button.CHOOSE,
                                          name : "selectButton"
                                      },
                                      { type : InfoDialog.Button.ABORT,
                                          title : i18n.abortToolTip }
                           ],
                      defaultWidth : 800,
                     defaultHeight : 400
            });

            on(chooseDialog, "valueChosen", lang.hitch(this, function(result) {
                var newParams = {
                           anlagentypTempFileName : params.anlagentypTempFileName,
                    objectPlannerIdToAnlagentypen : params.objectPlannerIdToAnlagentypen
                };
                lang.mixin(newParams, result);

                this.askExportToMsp(newParams);
            }));
            chooseDialog.show(null);
        },

        askExportToMsp : function(result) {
            var mspItem = result.mspItem;
            var url = result.url;
            var mspTitle = mspItem != null && mspItem.title != null ? mspItem.title : url;
            var documentVersionIds = [];
            for (var n = 0; n < this.documentListRows.length; n++) {
                if (this.documentListRows[n].documentVersion != null && this.documentListRows[n].documentVersion.id != null) {
                    documentVersionIds.push(this.documentListRows[n].documentVersion.id);
                }
            }

            var message = string.substitute(i18n.documentPageAskExportToMspMessage, {
                   count : documentVersionIds.length,
                mspTitle : mspTitle
            });

            InfoDialog.showQuestion({
                       title : i18n.documentPageAskExportToMspCaption,
                     message : message,
                defaultWidth : 750,
                     buttons : [
                                { type : InfoDialog.Button.YES,
                                    fct : lang.hitch(this, function() {
                                        this.doExportToMsp(result);
                                    })
                                },
                                { type : InfoDialog.Button.NO }
                     ]
            });
        },

        doExportToMsp : function(result) {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var projectId = this.applicationContext.getPageContextProjectId();
            var url = result.url;
            var anlagentypTempFileName = result.anlagentypTempFileName;
            var objectPlannerIdToAnlagentypen = result.objectPlannerIdToAnlagentypen;
            var documentVersionIds = [];
            for (var n = 0; n < this.documentListRows.length; n++) {
                if (this.documentListRows[n].documentVersion != null && this.documentListRows[n].documentVersion.id != null) {
                    documentVersionIds.push(this.documentListRows[n].documentVersion.id);
                }
            }

            this.registerAsyncOperationStarted(DocumentPage.AsyncOperation.REGISTER_EXPORT_TO_MSP);
            var documentService = this.applicationContext.getService("documentService");
            documentService.registerMspExportJob(organisationPersonId, projectId, anlagentypTempFileName, objectPlannerIdToAnlagentypen,
                url, documentVersionIds).then(lang.hitch(this, function(documentData) {
                    topic.publish("message/ok", i18n.documentPageRegisterMspExportSuccess);
                    this.registerAsyncOperationFinished(DocumentPage.AsyncOperation.REGISTER_EXPORT_TO_MSP);
                }), lang.hitch(this, function(err) {
                    delete this.joinDeferred;

                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : DocumentPage.AsyncOperation.REGISTER_EXPORT_TO_MSP,
                                opName : "registerMspExportJob",
                               message : i18n.documentPageRegisterMspExportFailed
                    });
                })
                    ).otherwise(lang.hitch(this, function(err) {
                        log.error("Error while processing the results of calling registerMspExportJob: ", err);
                    }));
        },

        resize : function(newSize) {
            if (newSize) {
                this.lastNewSize = newSize;
            }

            var totalHeight = this.lastNewSize.h;

            var width = this.captionBarDiv.offsetWidth - 15;
            var contentHeight = totalHeight
                              /*- this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")*/
                              - this.captionBarDiv.offsetHeight
                              - this.searchWidgetDiv.offsetHeight - domStyle.get(this.searchWidgetDiv, "margin-top") - domStyle.get(this.searchWidgetDiv, "margin-bottom")
                              - this.legendDiv.offsetHeight - domStyle.get(this.legendDiv, "margin-top") - domStyle.get(this.legendDiv, "margin-bottom")
                              - 16;

            this.listWidget.resize({ w : width, h : contentHeight });
        },

        setData : function() {

        },

        reload : function(postProcessFunction) {
            //this.contextBar.reload();

            this.listWidget.setData({ documentListRows : [] });
			// Print out that a search is running, discard the previous data immediately, to avoid disturbing the user
			DOMHelper.setInnerText(this.searchWidget.statusDiv, i18n.searchRuns);

            this.updateWidgetState();

            if (this.searchWidget.isAlreadyInitialized()) {
                this.reloadData(postProcessFunction);
            }            
        },

        cloneAndConvertSearchModelForServer : function(searchModel) {
            return {
                           organisationPersonId : searchModel.organisationPersonId,
                                   subProjectId : searchModel.subProjectId,
                                         status : searchModel.status,
                                    delayOption : searchModel.delayOption,
                                 reviewCycleIds : searchModel.reviewCycleIds,
                             reviewCycleCellIds : searchModel.reviewCycleCellIds,
                             reviewCycleNodeIds : searchModel.reviewCycleNodeIds,
                                 documentTypeId : searchModel.documentTypeId,
                                       objectId : searchModel.objectId,
                                objectPlannerId : searchModel.objectPlannerId,
                                   uploadedFrom : searchModel.uploadedFrom,
                                     uploadedTo : searchModel.uploadedTo,
                                   releasedFrom : searchModel.releasedFrom,
                                     releasedTo : searchModel.releasedTo,
                                           name : searchModel.name,
                                        content : searchModel.content,
                  reviewCycleInstanceReleasedId : searchModel.reviewCycleInstanceReleasedId != CdesVoc.MagicSelectOption.ALL ? searchModel.reviewCycleInstanceReleasedId : null,
                reviewCycleInstanceReleasedName : searchModel.reviewCycleInstanceReleasedName,
                                     cdesRoleId : searchModel.cdesRoleId != CdesVoc.MagicSelectOption.ALL ? searchModel.cdesRoleId : null,
                                   cdesRoleName : searchModel.cdesRoleName,
                             plannerOrgPersonId : searchModel.plannerOrgPersonId != CdesVoc.MagicSelectOption.ALL ? searchModel.plannerOrgPersonId : null,
                                    plannerName : searchModel.plannerName,
                         projectParticipationId : searchModel.projectParticipationId,
                                    showDeleted : searchModel.showDeleted,
                          includeObjectPlanners : searchModel.includeObjectPlanners
            };
        },

        reloadData : function(postProcessFunction) {
			this.mode = "";
            // Set up searchmodel
            var searchModel = this.searchWidget.getSearchModel();
			this.storeInLocalStorage(searchModel);

            var documentService = this.applicationContext.getService("documentService");

            // If the previous search still runs, cancel it
            if (this.joinDeferred != null) {
                this.joinDeferred.cancel();
            }

            var prevSeconds = DateHelper.getCurrentTimeSeconds();
            topic.publish("message/info", i18n.documentPageLoadDataRunning);

            searchModel = this.cloneAndConvertSearchModelForServer(searchModel);

            this.registerAsyncOperationStarted(DocumentPage.AsyncOperation.LOAD_DATA);
            this.joinDeferred = documentService.getDocumentListSmallJoin(searchModel);
//            this.joinDeferred = documentService.getDocumentListJoin(searchModel);
            this.joinDeferred.then(lang.hitch(this, function(documentData) {
                this.documentListRows = documentData.documentListRows;
                this.documentIdToReviewStatusSvg = documentData.documentIdToReviewStatusSvg;
                this.documentIdToReviewStatusToolTip = documentData.documentIdToReviewStatusToolTip;
                this.documentIdToDelay = documentData.documentIdToDelay;
                var cycleInfo = documentData.cycleInfo;
                var resultOptions = documentData.resultOptions;
                this.objectPlannerIdToActions = documentData.objectPlannerIdToActions;
                var projectActions = documentData.projectActions;

                //                      // Server: Map<Long, Set<String>> is received here as Map<Long, List<String>> and thus we convert it back.
                //                      var networkIdToActions = ActionHelper.convertNetworkIdToActions(certificateSearchResult.networkActions);

                //                      this.certificateJoins = CertificateHelper.preprocessCertificateJoins(certificateJoins);
                //                      this.updateAuxiliaryData();

                var postSeconds = DateHelper.getCurrentTimeSeconds();
                if (log.isDebugEnabled()) {
                    log.debug("Queried [" + this.documentListRows.length + "] documents after " + (postSeconds - prevSeconds) + "s");
                }

                var searchInfoString = this.getSearchInfoString(this.documentListRows, (postSeconds - prevSeconds));
                topic.publish("message/ok", searchInfoString);
                DOMHelper.setInnerText(this.searchWidget.statusDiv, searchInfoString);

                //                  var columnSettings = this.getColumnSettingsForReload(searchModel);
                //                  this.listWidget.setSearchModel(searchModel);
                this.listWidget.setData({
                                documentListRows : this.documentListRows,
                     documentIdToReviewStatusSvg : this.documentIdToReviewStatusSvg,
                 documentIdToReviewStatusToolTip : this.documentIdToReviewStatusToolTip,
                               documentIdToDelay : this.documentIdToDelay,
                        objectPlannerIdToActions : this.objectPlannerIdToActions,
                                  projectActions : projectActions,
								   globalActions : this.globalActions,
                                   resultOptions : resultOptions,
                                       cycleInfo : cycleInfo,
                              directPlotPossible : documentData.directPlotPossible,
                              enableCustomerLogo : this.enableCustomerLogo,
                         isSubProjectAsBuiltType : this.isSubProjectAsBuiltType
                });
                delete this.joinDeferred;

                postSeconds = DateHelper.getCurrentTimeSeconds();
                if (log.isDebugEnabled()) {
                    log.debug("Populated list after " + (postSeconds - prevSeconds) + "s");
                }

                if (postProcessFunction != null) {
                    postProcessFunction();
                }
                this.searchWidget.setChanged(false);

                this.registerAsyncOperationFinished(DocumentPage.AsyncOperation.LOAD_DATA);
                this.updateWidgetState();
            }), lang.hitch(this, function(err) {
                delete this.joinDeferred;

                ErrorHelper.processAsyncError({
                               err : err,
                            widget : this,
                    asyncOperation : DocumentPage.AsyncOperation.LOAD_DATA,
                            opName : "getDocumentListJoin",
                           message : i18n.documentPageLoadDataFailed
                });
            })
                ).otherwise(lang.hitch(this, function(err) {
                    log.error("Error while processing the results of calling getDocumentListJoin: ", err);
                }));
        },

        storeInLocalStorage : function(searchModel) {

            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextNetworkId();
            this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/documentList/search", searchModel);
		},

        getSearchInfoString : function(documentRows, runningTime) {
            return string.substitute(i18n.documentPageLoadDataSuccess, {
                count : documentRows.length,
                 time : runningTime.toFixed(2)
            });
        },

        updateWidgetState : function() {
/*            if (this.mode === "asBuiltMode") {
                domClass.add(this.additionalButtonsDiv, "invisible");
                this.openBPAsBuildDocumentsButton.set('label', string.substitute(i18n.documentPageJumpToBPDocListSaveButtonCaption, {
	                														status : this.subProjectAsBuiltName}));
                this.openBPAsBuildDocumentsButton.set("disabled", !this.listWidget.isAnyTokenSelected());
				this.searchWidget.searchButton.set("disabled", true);
				this.listWidget.updateColumn("actions", false);
				this.listWidget.updateColumn("selection", true);
            } else if (this.mode === "asBuiltModeSave") {
    			this.openBPAsBuildDocumentsButton.set('label', string.substitute(i18n.documentPageJumpToBPDocListButtonCaption, {
                															status : this.subProjectAsBuiltName}));
                this.openBPAsBuildDocumentsButton.set("disabled", !this.listWidget.isAnyTokenSelected());
				this.listWidget.updateColumn("actions", false);
				this.listWidget.updateColumn("selection", true);
				
				//domClass.remove(this.signBatchDiv, "invisible");
                //this.signBatchButton.set("disabled", !this.listWidget.isAnyTokenSelected());

            } else {
                domClass.remove(this.additionalButtonsDiv, "invisible");
                this.openBPAsBuildDocumentsButton.set("disabled", false);
				this.searchWidget.searchButton.set("disabled", false);
				this.listWidget.updateColumn("actions", true);
				this.listWidget.updateColumn("selection", false);
            }                
*/
        },

        updateWidgetsFromData : function() {

        },

        updateDataFromWidgets : function() {

        },

        destroy : function() {
            this.inherited(arguments);
            this.listWidget.destroy();
        }
    });

    DocumentPage.AsyncOperation = {
        CHECK_ANLAGENTYPEN : "CheckAnlagentypen",
        EXPORT_ARCHIVE : "ExportArchive",
        EXPORT_TO_PDF : "ExportToPdf",
		EXPORT_TO_XLS : "ExportToXls",
        LOAD_DATA : "LoadData",
        LOAD_DATA_BP : "LoadDataBP",
        SAVE_DATA_BP : "SaveDataBP",
        LOAD_INFO : "LoadInfo",
        GET_ARCHIVE_CREATE_DATA : "GetArchiveCreateData",
        REGISTER_EXPORT_TO_MSP : "RegisterExportToMsp",
        RUN_MSP_EXPORT_NOW : "RunMspExportNow"
    };

    return DocumentPage;
});
