/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

//// css-prefix = personSearch
//// i18n-prefix = personSearch

define([
        "cdes/core/CdesVoc",
        "cdes/util/NameHelper",
        "cdes/util/SearchPageHelper",
        "clazzes/TinyLog",
        "clazzes/form/FancyButton",
        "clazzes/util/DOMHelper",
        "clazzes/util/WidgetHelper",
        "clazzes/widgets/IconTitlePane",
        "clazzes/widgets/layout/ContentWidget",
        "dijit/form/CheckBox",
        "dijit/form/ComboBox",
        "dijit/form/Select",
        "dijit/form/TextBox",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/keys",
        "dojo/on",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js",
        "dojo/store/Memory"
], function(
            CdesVoc,
            NameHelper,
            SearchPageHelper,
            TinyLog,
            FancyButton,
            DOMHelper,
            WidgetHelper,
            IconTitlePane,
            ContentWidget,
            CheckBox,
            ComboBox,
            Select,
            TextBox,
            domClass,
            domConstruct,
            Keys,
            on,
            declare,
            lang,
            i18n,
            Memory
            ) {

    var className = "at.cdes.web.person.PersonSearchWidget";

    var log = new TinyLog(className);

    var PersonSearchWidget = declare(className, ContentWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.loadedNetworkIds = new Object();
            this.networkIdToPersonMemoryData = new Object();
            this.networkIdToOrganisationMemoryData = new Object();
            this.networkIdToProjectMemoryData = new Object();
            this.networkIdToRoleMemoryData = new Object();

            this.searchModel = new Object();
            this.topDiv = this.constructTopDiv();
            this.allFieldsValid = true;
            this.prevNetworkId = -1;
        },

        getWidgetId : function() {
            return "PersonSearchWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);
            domClass.add(topDiv, "refNodeOfPositionAbsolute personSearchTopDivFull personSearchTopDiv");

            this.titlePane = this.constructTitlePane();
            domConstruct.place(this.titlePane.domNode, topDiv);

            return topDiv;
        },

        getSelectedNetworkId : function() {
            // The widget is set to initialized in the async handler of the getSearchInfo call.
            // But we query the network id already before, for getting the parameter networkId
            // of that getSearchInfo call.
            // Thus, if not yet initialized, return the default value for the networkSelect,
            // as set in setSearchInfo below.
            if (this.initialized) {
            	//case --all--
	            if (SearchPageHelper.isComboBoxSetToAll(this.networkComboBox)){
	            	networkId = CdesVoc.MagicSelectOption.ALL;
	            } else {
	            	var networkName = this.networkComboBox.get("value");
	            	networkId = networkName != null ? this.networkNameToId[networkName] : null;
				}
                this.prevNetworkId = networkId;
                return networkId;
            } else {
	        var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
                var oldSearchModel = this.applicationContext.getFromLocalStorage([organisationPersonId], "/personList/search");
                if (oldSearchModel != null) {
                    if (oldSearchModel.networkId != null) {
                    	this.prevNetworkId = oldSearchModel.networkId;
                        return oldSearchModel.networkId;
                    } else if (oldSearchModel.networkName != null) {
                        return this.networkNameToId[oldSearchModel.networkName];
                    } else {
                        var contextNetworkId = this.applicationContext.getPageContextNetworkId();
                    	this.prevNetworkId = contextNetworkId;
                        return contextNetworkId;
                    }
                } else {
                    var contextNetworkId = this.applicationContext.getPageContextNetworkId();
                 	this.prevNetworkId = contextNetworkId;
                    return contextNetworkId;
                }
            }
        },

        getNetworkChanged : function() {
            var networkId;
            //case --all--
            if (SearchPageHelper.isComboBoxSetToAll(this.networkComboBox)){
            	networkId = CdesVoc.MagicSelectOption.ALL;
            } else {
            	var networkName = this.networkComboBox.get("value");
            	networkId = networkName != null ? this.networkNameToId[networkName] : null;
			}
            if (this.prevNetworkId == networkId) {
                return false;
            } else {
                return true;
            }
        },

        setNetworks : function(networks) {
            this.networkMemoryData = this.getNetworkMemoryData(networks);
            this.networkNameStore = new Memory({
                data : this.networkMemoryData
            });
            this.networkNameToId = this.getNetworkNameToId(networks);
            this.networkComboBox.set("store", this.networkNameStore);
        },

        setSearchInfo : function(searchInfo, networkId) {
            var key = networkId != null ? networkId : CdesVoc.MagicSelectOption.ALL;
            this.loadedNetworkIds[key] = true;

            var personMemoryData = this.getNameMemoryData(searchInfo.persons);
            var organisationMemoryData = this.getOrganisationMemoryData(searchInfo.organisations);
            var projectMemoryData = this.getProjectMemoryData(searchInfo.projects);
            var roleMemoryData = this.getRoleMemoryData(searchInfo.roles);

            this.networkIdToPersonMemoryData[key] = personMemoryData;
            this.networkIdToOrganisationMemoryData[key] = organisationMemoryData;
            this.networkIdToProjectMemoryData[key] = projectMemoryData;
            this.networkIdToRoleMemoryData[key] = roleMemoryData;

            this.updateComboBoxes(true);

            this.initialize();
        },

        updateComboBoxes : function(forceUpdate) {
            var chosenNetworkId = this.getSelectedNetworkId();
            var key = chosenNetworkId != null ? chosenNetworkId : CdesVoc.MagicSelectOption.ALL;

            if (forceUpdate || chosenNetworkId != this.chosenNetworkId) {
                if (this.loadedNetworkIds[key]) {
                    var nameMemoryData = key in this.networkIdToPersonMemoryData ? this.networkIdToPersonMemoryData[key] : [];
                    this.nameMemory.setData(nameMemoryData);
                    this.nameComboBox.set("store", this.nameMemory);
                    var organisationMemoryData = key in this.networkIdToOrganisationMemoryData ? this.networkIdToOrganisationMemoryData[key] : [];
                    this.organisationMemory.setData(organisationMemoryData);
                    var projectMemoryData = key in this.networkIdToProjectMemoryData ? this.networkIdToProjectMemoryData[key] : [];
                    this.projectMemory.setData(projectMemoryData);
                    var roleMemoryData = key in this.networkIdToRoleMemoryData ? this.networkIdToRoleMemoryData[key] : [];
                    this.roleMemory.setData(roleMemoryData);

                    if (log.isDebugEnabled()) {
                        log.debug("Set ComboBoxes with data for chosenNetworkId [" + chosenNetworkId + "]");
                    }
                } else {
                    on.emit(this, "doReloadSearchInfo");
                }
            }

            this.chosenNetworkId = chosenNetworkId;
        },

        postTitleClick : function() {
            var open = this.titlePane.get("open");

            if (open) {
                this.titlePane.set("title", i18n.searchOpenCaption);
                domClass.replace(this.topDiv, "personSearchTopDivFull", "personSearchTopDivReduced");
            } else {
                this.titlePane.set("title", i18n.searchClosedCaption);
                domClass.replace(this.topDiv, "personSearchTopDivReduced", "personSearchTopDivFull");
            }

            on.emit(this, "titlePaneToggled");
        },

        constructTitlePane : function() {
            this.contentDiv = this.constructContentDiv();

            var titlePane = new IconTitlePane({
                       title   : i18n.searchOpenCaption,
                       content : this.contentDiv,
                    toggleable : true,
                          open : true,
                      duration : 0,
                postTitleClick : lang.hitch(this, this.postTitleClick)
            });
            domClass.add(titlePane.domNode, "personSearchTitlePane");

            return titlePane;
        },

        constructContentDiv : function() {
            var contentDiv = domConstruct.create("div", null, null);
            domClass.add(contentDiv, "refNodeOfPositionAbsolute personSearchContentDiv");

            // Name
            this.nameMemory = new Memory({
                data : this.getNameMemoryData()
            });

            DOMHelper.createTextNode("div", i18n.personSearchNameLabel, contentDiv, "propertyLabel personSearchNameLabel");
            this.nameComboBox = new ComboBox({
                       label : i18n.personSearchNameLabel,
                       title : i18n.personSearchNameToolTip,
                       store : this.nameMemory,
				   queryExpr : "*${0}*", //any search string
				autoComplete : false,
               selectOnClick : true
            });
            domClass.add(this.nameComboBox.domNode, "fixedDialogWidget personSearchNameComboBox");
            domConstruct.place(this.nameComboBox.domNode, contentDiv);
            on(this.nameComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
            //            WidgetHelper.handleComboBoxEvents(this.nameComboBox, lang.hitch(this, this.recordChanged));

            // Organisation
            this.organisationMemory = new Memory({
                data : this.getOrganisationMemoryData()
            });

            DOMHelper.createTextNode("div", i18n.personSearchOrganisationLabel, contentDiv, "propertyLabel personSearchOrganisationLabel");
            this.organisationComboBox = new ComboBox({
                       label : i18n.personSearchOrganisationLabel,
                       title : i18n.personSearchOrganisationToolTip,
                       store : this.organisationMemory,
				   queryExpr : "*${0}*",
				autoComplete : false,
               selectOnClick : true
            });
            domClass.add(this.organisationComboBox.domNode, "fixedDialogWidget personSearchOrganisationComboBox");
            domConstruct.place(this.organisationComboBox.domNode, contentDiv);
            on(this.organisationComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
            //            WidgetHelper.handleComboBoxEvents(this.organisationComboBox, lang.hitch(this, this.recordChanged));

            // Network
            this.networkMemoryData = this.getNetworkMemoryData(null);
            this.networkNameStore = new Memory({
                data : this.networkMemoryData
            });
            this.networkNameToId = this.getNetworkNameToId(null);

            DOMHelper.createTextNode("div", i18n.personSearchNetworkLabel, contentDiv, "propertyLabel personSearchNetworkLabel");
            this.networkComboBox = new ComboBox({
                       label : i18n.personSearchNetworkLabel,
                       title : i18n.personSearchNetworkToolTip,
                       store : this.networkNameStore,
				   queryExpr : "*${0}*",
				autoComplete : false,
               selectOnClick : true
            });
            domClass.add(this.networkComboBox.domNode, "fixedDialogWidget personSearchNetworkComboBox");
            domConstruct.place(this.networkComboBox.domNode, contentDiv);
            on(this.networkComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));

            /*
            // Show invalidated persons CheckBox
            this.showInvalidCheckBox = new CheckBox({
	            label : i18n.personSearchShowInvalidLabel,
	            title : i18n.personSearchShowInvalidToolTip
        	});
            domClass.add(this.showInvalidCheckBox.domNode, "fixedDialogWidget personSearchShowInvalidCheckBox");
            domConstruct.place(this.showInvalidCheckBox.domNode, contentDiv);*/
            //WidgetHelper.handleCheckBoxEvents(this.showInvalidCheckBox, lang.hitch(this, this.handleShowInvalidChange));

            // invalidated persons CheckBox label
            // DOMHelper.createTextNode("div", i18n.personSearchShowInvalidLabel, contentDiv, "propertyLabel personSearchShowInvalidLabel");

            // Project
            this.projectMemory = new Memory({
                data : this.getProjectMemoryData()
            });

            DOMHelper.createTextNode("div", i18n.personSearchProjectLabel, contentDiv, "propertyLabel personSearchProjectLabel");
            this.projectComboBox = new ComboBox({
                       label : i18n.personSearchProjectLabel,
                       title : i18n.personSearchProjectToolTip,
                       store : this.projectMemory,
				   queryExpr : "*${0}*",
				autoComplete : false,
               selectOnClick : true
            });
            domClass.add(this.projectComboBox.domNode, "fixedDialogWidget personSearchProjectComboBox");
            domConstruct.place(this.projectComboBox.domNode, contentDiv);
            on(this.projectComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
            //            WidgetHelper.handleComboBoxEvents(this.projectComboBox, lang.hitch(this, this.recordChanged));

            // Role
            this.roleMemory = new Memory({
                data : this.getRoleMemoryData()
            });

            DOMHelper.createTextNode("div", i18n.personSearchRoleLabel, contentDiv, "propertyLabel personSearchRoleLabel");
            this.roleComboBox = new ComboBox({
                       label : i18n.personSearchRoleLabel,
                       title : i18n.personSearchRoleToolTip,
                       store : this.roleMemory,
				   queryExpr : "*${0}*",
				autoComplete : false,
               selectOnClick : true
            });
            domClass.add(this.roleComboBox.domNode, "fixedDialogWidget personSearchRoleSelect");
            domConstruct.place(this.roleComboBox.domNode, contentDiv);
            on(this.roleComboBox.domNode, "keyup", lang.hitch(this, this.searchIfEnter));
            //            WidgetHelper.handleComboBoxEvents(this.projectComboBox, lang.hitch(this, this.recordChanged));

            // Buttons
            this.buttonDiv = domConstruct.create("div", null, null);
            domClass.add(this.buttonDiv, "fixedDialogWidget personSearchButtonDiv");
            domConstruct.place(this.buttonDiv, contentDiv);

            // ClearSearchFieldsButton
            this.clearSearchFieldsButton = new FancyButton({
                label : i18n.clearSearchFieldsButtonCaption,
                title : i18n.clearSearchFieldsButtonToolTip
            });
            domClass.add(this.clearSearchFieldsButton.domNode, "textButton personSearchClearSearchFieldsButton");
            domConstruct.place(this.clearSearchFieldsButton.domNode, this.buttonDiv);

            on(this.clearSearchFieldsButton, "click", lang.hitch(this, this.clearSearchFields));


            // SearchButton
            this.searchButton = new FancyButton({
                label : i18n.searchButtonCaption,
                title : i18n.searchButtonCaption
            });
            domClass.add(this.searchButton.domNode, "textButton personSearchDoSearchButton");
            domConstruct.place(this.searchButton.domNode, this.buttonDiv);

            on(this.searchButton, "click", lang.hitch(this, this.doSearch));

            return contentDiv;
        },

        recordChanged : function() {
            this.changed = true;
        },

        isAlreadyInitialized : function() {
            return this.initialized;
        },

        setAsyncRunning : function(asyncRunning) {
            var changed = (this.parentAsyncRunning != asyncRunning);
            this.parentAsyncRunning = asyncRunning;
            if (changed) {
                this.updateWidgetState();
            }
        },

        updateWidgetState : function() {
            var asyncRunning = !!(this.parentAsyncRunning || this.asyncOperationRunning);
            this.nameComboBox.set("disabled", asyncRunning);
            this.networkComboBox.set("disabled", asyncRunning);
            this.organisationComboBox.set("disabled", asyncRunning);
            this.projectComboBox.set("disabled", asyncRunning);
            this.roleComboBox.set("disabled", asyncRunning);
            //this.showInvalidCheckBox.set("disabled", asyncRunning);
            this.searchButton.set("disabled", asyncRunning);
            this.clearSearchFieldsButton.set("disabled", asyncRunning);
        },

        initialize : function(searchInfo) {
            if (!this.initialized) {
                this.populateSearchFields();
                this.initialized = true;
            }
        },

        populateSearchFields : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var oldSearchModel = this.applicationContext.getFromLocalStorage([organisationPersonId], "/personList/search");

            var contextNetworkId = this.applicationContext.getPageContextNetworkId();

            if (oldSearchModel != null) {
                this.searchModel = oldSearchModel;
                if (contextNetworkId != null && this.searchModel.networkId == null && this.searchModel.networkName == null) {
              	    this.searchModel.networkId = contextNetworkId;
                }
            } else {
            	this.searchModel = {
                    organisationPersonId : organisationPersonId,
                               networkId : contextNetworkId
            	};
            }
            this.updateWidgetsFromData();
        },

        updateWidgetsFromData : function() {
            SearchPageHelper.setSearchModelValueToAllableComboBox(this.searchModel, this.nameComboBox,
                                                                  "personId", "name");
            SearchPageHelper.setSearchModelValueToAllableComboBox(this.searchModel, this.organisationComboBox,
                                                                  "organisationId", "organisation");
            SearchPageHelper.setSearchModelValueToAllableComboBox(this.searchModel, this.networkComboBox,
                                                                  "networkId", "networkName");
            SearchPageHelper.setSearchModelValueToAllableComboBox(this.searchModel, this.projectComboBox,
                                                                  "projectId", "project");
            SearchPageHelper.setSearchModelValueToAllableComboBox(this.searchModel, this.roleComboBox,
                                                                  "cdesRoleId", "role");
        },

        updateDataFromWidgets : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();

            this.searchModel = {
                organisationPersonId : organisationPersonId,
         	      showInvalidPersons : false//this.showInvalidCheckBox.get("checked")
            };

            SearchPageHelper.setAllableComboBoxValueToSearchModel(this.nameComboBox, this.searchModel,
                                                                  "personId", "name");
            SearchPageHelper.setAllableComboBoxValueToSearchModel(this.organisationComboBox, this.searchModel,
                                                                  "organisationId", "organisation");
            SearchPageHelper.setAllableComboBoxValueToSearchModel(this.networkComboBox, this.searchModel,
                                                                  "networkId", "networkName");
            SearchPageHelper.setAllableComboBoxValueToSearchModel(this.projectComboBox, this.searchModel,
                                                                  "projectId", "project");
            SearchPageHelper.setAllableComboBoxValueToSearchModel(this.roleComboBox, this.searchModel,
                                                                  "cdesRoleId", "role");
            SearchPageHelper.setAllableComboBoxValueToSearchModel(this.roleComboBox, this.searchModel,
                                                                  "cdesRoleId", "role");
        },

        searchIfEnter : function(e) {
            if (e.keyCode == Keys.ENTER) {
                this.doSearch();
            }
        },

        doSearch : function() {
            this.changed = false;
            on.emit(this, "doSearch");
        },

        clearSearchFields : function() {
            var network = this.applicationContext.getPageContextNetwork();
            var networkName = (network != null ? network.name : null);

            SearchPageHelper.setComboBoxValue(this.nameComboBox, CdesVoc.MagicSelectOption.ALL);
            SearchPageHelper.setComboBoxValue(this.organisationComboBox, CdesVoc.MagicSelectOption.ALL);
            SearchPageHelper.setComboBoxValue(this.networkComboBox, CdesVoc.MagicSelectOption.ALL);
            SearchPageHelper.setComboBoxValue(this.projectComboBox, CdesVoc.MagicSelectOption.ALL);
            SearchPageHelper.setComboBoxValue(this.roleComboBox, CdesVoc.MagicSelectOption.ALL);
        },

        setChanged : function(changed) {
            this.changed = changed;
        },

        isChanged : function() {
            return this.changed;
        },

        setData : function(searchModel) {
            this.searchModel = searchModel != null ? searchModel : new Object();
            this.updateWidgetsFromData();
        },

        getSearchModel : function() {
            this.updateDataFromWidgets();
            return this.searchModel;
        },

        getNameMemoryData : function(persons) {
            var data = [];
            if (persons) {
                for (var n = 0; n < persons.length; n++) {
                    data.push({
                        name : NameHelper.getPersonInverseCommonName(persons[n]),
                          id : persons[n].id
                    });
                }
            }

            data.sort(lang.hitch(this, function(optionOne, optionTwo) {
                return optionOne.name.localeCompare(optionTwo.name);
            }));
            data.splice(0, 0, { name: i18n.allOption, id : CdesVoc.MagicSelectOption.ALL });
            return data;
        },

        getOrganisationMemoryData : function(organisations) {
            var data = [];
            if (organisations) {
                for (var n = 0; n < organisations.length; n++) {
                    data.push({
                        name : organisations[n].name,
                          id : organisations[n].id
                    });
                }
            }

            data.sort(lang.hitch(this, function(optionOne, optionTwo) {
                return optionOne.name.localeCompare(optionTwo.name);
            }));
            data.splice(0, 0, { name: i18n.allOption, id : CdesVoc.MagicSelectOption.ALL });
            return data;
        },

        getNetworkMemoryData : function(networks) {
            var data = [];
            if (networks) {
                for (var n = 0; n < networks.length; n++) {
                    data.push({
                        name : networks[n].name,
                          id : networks[n].id
                    });
                }
            }

            data.sort(lang.hitch(this, function(optionOne, optionTwo) {
                return optionOne.name.localeCompare(optionTwo.name);
            }));
            data.splice(0, 0, { name: i18n.allOption, id : CdesVoc.MagicSelectOption.ALL });
            return data;
        },

        getNetworkNameToId : function(networks) {
            var networkNameToId = new Object();
            if (networks) {
                for (var n = 0; n < networks.length; n++) {
                    var name = networks[n].name;
                    var id = networks[n].id;
                    networkNameToId[name] = id;
                }
            }
            return networkNameToId;
        },

        getNetworkOptions : function(networks) {
            var options = [{
                value : PersonSearchWidget.ALL_KEY,
                label : i18n.allOption
            }];
            if (networks) {
                for (var n = 0; n < networks.length; n++) {
                    options.push({
                        value : networks[n].id,
                        label : networks[n].name
                    });
                }

                options.sort(lang.hitch(this, function(optionOne, optionTwo) {
                    return optionOne.label.localeCompare(optionTwo.label);
                }));
            }
            return options;
        },

        getProjectMemoryData : function(projects) {
            var data = [];
            if (projects) {
                for (var n = 0; n < projects.length; n++) {
                    data.push({
                        name : projects[n].code + " " + projects[n].name,
                          id : projects[n].id
                    });
                }
            }

            data.sort(lang.hitch(this, function(optionOne, optionTwo) {
                return optionOne.name.localeCompare(optionTwo.name);
            }));
            data.splice(0, 0, { name: i18n.allOption, id : CdesVoc.MagicSelectOption.ALL });
            return data;
        },

        getRoleMemoryData : function(roles) {
            var data = [];
            if (roles) {
                for (var n = 0; n < roles.length; n++) {
                    data.push({
                        name : roles[n].name,
                          id : roles[n].id
                    });
                }
            }

            data.sort(lang.hitch(this, function(optionOne, optionTwo) {
                return optionOne.name.localeCompare(optionTwo.name);
            }));
            data.splice(0, 0, { name: i18n.allOption, id : CdesVoc.MagicSelectOption.ALL });
            return data;
        }
    });

    PersonSearchWidget.ALL_KEY = "__ALL__";

    return PersonSearchWidget;
});
