/***********************************************************
 * $Id$
 *
 * Copyright (C) 2017 ev-i Informationstechnologie Gmbh
 *
 **********************************************************/

define([ "clazzes/TinyLog",
	"clazzes/canvas/CanvasHelper",
	"clazzes/mouse/MouseHelper",
	"clazzes/util/DOMHelper",
	"clazzes/util/ErrorHelper",
	"clazzes/widgets/layout/ContentWidget",
	"dojo/dom-class",
	"dojo/dom-construct",
	"dojo/dom-style",
	"dojo/io-query",
	"dojo/_base/declare",
	"dojo/_base/lang",
	"dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
	function(TinyLog,
			CanvasHelper,
			MouseHelper,
			DOMHelper,
			ErrorHelper,
			ContentWidget,
			domClass,
			domConstruct,
			domStyle,
			ioQuery,
			declare,
			lang,
			i18n) {

	var className = "at.cdes.web.planning.order.PlanningNotificationOrderExtractWidget";

	var log = new TinyLog(className);

	var PlanningNotificationOrderExtractWidget = declare(className, ContentWidget, {

		constructor : function(params) {
			lang.mixin(this, params);

			this.resolution = 144;
			this.resizeAreaSize = 8;

			this.topDiv = this.constructTopDiv();

			this.mouseMoveHandler = {
					handleEvent : lang.hitch(this, this.mouseMoveHandlerFunction)
			};

			this.mouseOutHandler = {
					handleEvent : lang.hitch(this, this.mouseOutHandlerFunction)        
			};

			this.mouseOverHandler = {
					handleEvent : lang.hitch(this, this.mouseOverHandlerFunction)       
			};                  

			this.mouseUpHandler = {
					handleEvent : lang.hitch(this, this.mouseUpHandlerFunction)
			};

			this.mouseDownHandler = {
					handleEvent : lang.hitch(this, this.mouseDownHandlerFunction)
			};

			this.allFieldsValid = true;
		},

		getWidgetId : function() {
			return "PlanningNotificationOrderExtractWidget";
		},

		getDataId : function() {
			return null;
		},

		getContainer : function() {
			return this.topDiv;
		},

		constructTopDiv : function() {
			var topDiv = domConstruct.create("div", null, null);
			domClass.add(topDiv, "refNodeOfPositionAbsolute planningNotificationOrderExtractWidgetTopDiv");
			domStyle.set(topDiv, "height", "300px");

			this.eventDiv = domConstruct.create("div", null, null);
			domClass.add(topDiv, "fixedDialogWidget planningNotificationOrderExtractWidgetEventDiv");
			domConstruct.place(this.eventDiv, topDiv);

			// Content
			this.extractCanvas = CanvasHelper.getMostNativeCanvasInstance();
			domClass.add(this.extractCanvas.domNode, "fixedDialogWidget planningNotificationOrderExtractExtractCanvas");
			domConstruct.place(this.extractCanvas.domNode, this.eventDiv);
			//      this.extractCanvas.startup();

			// Overlay canvas
			this.overlayCanvas = CanvasHelper.getMostNativeCanvasInstance();
			domClass.add(this.overlayCanvas.domNode, "fixedDialogWidget planningNotificationOrderExtractOverlayCanvas");
			domConstruct.place(this.overlayCanvas.domNode, this.eventDiv);
			//      this.overlayCanvas.startup();
			/*
            this.overlayCanvas.domNode.addEventListener("mousemove", this.mouseMoveHandler, true);
            this.overlayCanvas.domNode.addEventListener("mouseout", this.mouseOutHandler, true);
            this.overlayCanvas.domNode.addEventListener("mouseover", this.mouseOverHandler, true);
            this.overlayCanvas.domNode.addEventListener("mousedown", this.mouseDownHandler, true);
            this.overlayCanvas.domNode.addEventListener("mouseup", this.mouseUpHandler, true);      
			 */

			return topDiv;
		},

		initializeEvents : function() {
			this.eventDiv.addEventListener("mousemove", this.mouseMoveHandler, true);
			this.eventDiv.addEventListener("mousedown", this.mouseDownHandler, true);
		},      

		resize : function(newSize) {
			domStyle.set(this.topDiv, "width", (newSize.w - 15) + "px");
			domStyle.set(this.topDiv, "height", newSize.h + "px");
		},      

		setData : function(params) {
			this.urlPrefix = params.urlPrefix;
			this.planningNotificationId = params.planningNotificationId;        
			this.page = params.page;
			log.info("width = " + params.width + "; height = " + params.height);

			this.canvasWidth = params.width * (this.resolution / 72);
			this.canvasHeight = params.height * (this.resolution / 72);         
			this.x0 = params.x0;
			this.y0 = params.y0;            
			this.angle = params.angle;

			this.dragX1 = null;
			this.dragY1 = null;
			this.dragX2 = null;
			this.dragY2 = null;
			this.topDiv.scrollTop = 0;

			this.reload();

			/*          this.overlayCanvas.domNode.addEventListener("mousemove", this.mouseMoveHandler, true);
            this.overlayCanvas.domNode.addEventListener("mouseout", this.mouseOutHandler, true);
            this.overlayCanvas.domNode.addEventListener("mouseover", this.mouseOverHandler, true);
            this.overlayCanvas.domNode.addEventListener("mousedown", this.mouseDownHandler, true);
            this.overlayCanvas.domNode.addEventListener("mouseup", this.mouseUpHandler, true);      */
			/*
            this.topDiv.addEventListener("mousemove", this.mouseMoveHandler, true);
            this.topDiv.addEventListener("mouseout", this.mouseOutHandler, true);
            this.topDiv.addEventListener("mouseover", this.mouseOverHandler, true);
            this.topDiv.addEventListener("mousedown", this.mouseDownHandler, true);
            this.topDiv.addEventListener("mouseup", this.mouseUpHandler, true);     
			 */
		},

		reload : function() {
			var urlParams = ioQuery.objectToQuery({
				service : "CDESMimeService/4/planningNotificationPngMimeSource",
				sp : [ this.planningNotificationId, this.resolution, this.page, this.angle ],
				ts : dojoConfig.tabSessionId               
			});
			var url = this.urlPrefix + "?" + urlParams;

			// url like:
			// var url = "http://localhost:8081/cdes/app?service=CDESMimeService/4/planningNotificationPngMimeSource&sp=161907&sp=144&sp=0&ts=Admin";

			var context = this.extractCanvas.getContext2D();

			var overlayContext = this.overlayCanvas.getContext2D();
			overlayContext.clear();

			if (this.page == null) {
				this.extractCanvas.resize({ w : 10, h : 10 });
				this.overlayCanvas.resize({ w : 10, h : 10 });
				context.clear();                
			} else {
				domStyle.set(this.eventDiv, "width", this.canvasWidth + "px");
				domStyle.set(this.eventDiv, "height", this.canvasHeight + "px");
				this.extractCanvas.resize({ w : this.canvasWidth, h : this.canvasHeight });
				this.overlayCanvas.resize({ w : this.canvasWidth, h : this.canvasHeight });

				this.drawSelectionRect();

				//              domStyle.set(this.topDiv, "width", (this.width / 2) + "px");
				//              domStyle.set(this.topDiv, "height", (this.height / 2) + "px");
				context.clear();

				this.imageObj = new Image();
				this.imageObj.src = url;
				this.imageObj.onload = lang.hitch(this, this.drawImage);
				this.imageObj.onabort = lang.hitch(this, this.processImageFail);
				this.imageObj.onerror = lang.hitch(this, this.processImageFail);                
			}               
		},

		drawImage : function() {
			var context = this.extractCanvas.getContext2D();
			context.drawImage(this.imageObj, 0, 0);//, this.width, this.height);            
		},

		drawSelectionRect : function() {
			if (this.dragX1 != null && this.dragX2 != null && this.dragY1 != null && this.dragY2 != null) {
				var x1 = this.dragX1;
				var y1 = this.dragY1;
				var x2 = this.dragX2;
				var y2 = this.dragY2;                

				var context = this.overlayCanvas.getContext2D();
				context.clear();
				context.setFillStyle("rgba(50,50,50,0.1)");
				context.fillRect(x1, y1, x2 - x1, y2 - y1);

				//                      context.setLineWidth(0.5);
				context.setStrokeStyle("rgba(130,130,130,1)");

				context.beginPath();
				context.rect(x1, y1, x2 - x1, y2 - y1);
				context.stroke();

				var lowerRightX = Math.max(x1, x2);
				var lowerRightY = Math.max(y1, y2);                

				context.setFillStyle("rgba(130,130,130,1)");
				context.fillRect(lowerRightX - 3, lowerRightY - 3, 6, 6);                
			}               
		},      

		processImageFail : function() {
			log.error("Loading the image has failed.");
		},      

		updateWidgetState : function() {

		},

		// TODO: Modify this.topDiv.scrollTop, this.topDiv.scrollLeft in case the mouse is near the edge.
		mouseMoveHandlerFunction : function(e) {
			var currX = MouseHelper.getOffsetX(e);
			var currY = MouseHelper.getOffsetY(e);          

			if (this.mouseDownMode) {
				if (this.move) {
					if (this.prevCurrX != null && this.prevCurrY != null) {
						var dx = currX - this.prevCurrX;
						var dy = currY - this.prevCurrY;
						this.dragX1 += dx;
						this.dragY1 += dy;
						this.dragX2 += dx;
						this.dragY2 += dy;
					}                         

					this.prevCurrX = currX;
					this.prevCurrY = currY;
				} else {
					this.dragX2 = currX;
					this.dragY2 = currY;

					if (this.dragX1 != null && this.dragY1 != null && this.dragX2 != null && this.dragY2 != null) {
						var upperLeftX = Math.min(this.dragX1, this.dragX2);
						var upperLeftY = Math.min(this.dragY1, this.dragY2);
						var lowerRightX = Math.max(this.dragX1, this.dragX2);
						var lowerRightY = Math.max(this.dragY1, this.dragY2);            

						if (this.mouseDownMode && this.cursorMode == "se-resize" && currX >= lowerRightX - this.resizeAreaSize && currX <= lowerRightX
								&& currY >= lowerRightY - this.resizeAreaSize && currY <= lowerRightY) {
							this.cursorMode = "se-resize";
						} else {
							this.cursorMode = "auto";
						}                     
					} else {
						this.cursorMode = "auto";
					}
				}

				this.drawSelectionRect();
			} else {
				if (this.dragX1 != null && this.dragY1 != null && this.dragX2 != null && this.dragY2 != null) {
					var upperLeftX = Math.min(this.dragX1, this.dragX2);
					var upperLeftY = Math.min(this.dragY1, this.dragY2);
					var lowerRightX = Math.max(this.dragX1, this.dragX2);
					var lowerRightY = Math.max(this.dragY1, this.dragY2);            

					if (currX >= lowerRightX - this.resizeAreaSize && currX <= lowerRightX
							&& currY >= lowerRightY - this.resizeAreaSize && currY <= lowerRightY) {
						this.cursorMode = "se-resize";
					} else if (currX >= upperLeftX && currX <= lowerRightX && currY >= upperLeftY && currY <= lowerRightY) {
						this.cursorMode = "move";
					} else {
						this.cursorMode = "auto";
					}                         
				} else {
					this.cursorMode = "auto";
				}                     
			}

			domStyle.set(this.overlayCanvas.domNode, "cursor", this.cursorMode);
		},

		mouseOutHandlerFunction : function(e) {
			this.cursorMode = "auto";
			domStyle.set(this.overlayCanvas.domNode, "cursor", this.cursorMode);
			this.move = false;
			this.prevCurrX = null;
			this.prevCurrY = null;

			this.mouseDownMode = false;
			this.overlayCanvas.domNode.removeEventListener("mouseout", this.mouseOutHandler, true);
			this.overlayCanvas.domNode.removeEventListener("mouseup", this.mouseUpHandler, true);            
			this.tearDownScrollTimer();
		},

		mouseOverHandlerFunction : function(e) {
		},

		mouseUpHandlerFunction : function(e) {
			this.cursorMode = "auto";
			domStyle.set(this.overlayCanvas.domNode, "cursor", this.cursorMode);
			this.move = false;
			this.prevCurrX = null;
			this.prevCurrY = null;

			this.mouseDownMode = false;
			this.overlayCanvas.domNode.removeEventListener("mouseout", this.mouseOutHandler, true);
			this.overlayCanvas.domNode.removeEventListener("mouseup", this.mouseUpHandler, true);            
			this.tearDownScrollTimer();
		},

		mouseDownHandlerFunction : function(e) {
			if (!MouseHelper.isLeftButtonPressed(e)) {
				return;
			}

			e.stopPropagation();
			e.preventDefault();

			var currX = MouseHelper.getOffsetX(e);
			var currY = MouseHelper.getOffsetY(e);          

			var resize = false;
			if (this.dragX1 != null && this.dragY1 != null && this.dragX2 != null && this.dragY2 != null) {
				var upperLeftX = Math.min(this.dragX1, this.dragX2);
				var upperLeftY = Math.min(this.dragY1, this.dragY2);
				var lowerRightX = Math.max(this.dragX1, this.dragX2);
				var lowerRightY = Math.max(this.dragY1, this.dragY2);            
				this.dragX1 = upperLeftX;
				this.dragY1 = upperLeftY;
				this.dragX2 = lowerRightX;
				this.dragY2 = lowerRightY;                    

				if (currX >= lowerRightX - this.resizeAreaSize && currX <= lowerRightX
						&& currY >= lowerRightY - this.resizeAreaSize && currY <= lowerRightY) {
					resize = true;
					this.cursorMode = "se-resize";
					domStyle.set(this.overlayCanvas.domNode, "cursor", this.cursorMode);
				} else if (currX >= upperLeftX && currX <= lowerRightX && currY >= upperLeftY && currY <= lowerRightY) {
					this.move = true;
				}                    
			}

			if (!this.move) {
				if (!resize) {
					this.dragX1 = currX;
					this.dragY1 = currY;
				}

				this.dragX2 = currX;
				this.dragY2 = currY;
			}

			log.info("mouseDown: Setting dragX1 = [" + this.dragX1 + "], dragY1 = [" + this.dragY1 + "]; dragX2 = [" + this.dragX2 + "]; dragY2 = [" + this.dragY2 + "]");

			this.mouseDownMode = true;
			this.overlayCanvas.domNode.addEventListener("mouseout", this.mouseOutHandler, true);
			this.overlayCanvas.domNode.addEventListener("mouseup", this.mouseUpHandler, true);
			this.setupScrollTimer();        
		},        

		setupScrollTimer : function() {
			if (this.scrollTimerHandle == null) {
				this.scrollTimerHandle = window.setInterval(lang.hitch(this, this.processPotentialScroll), this.autoScrollTimerMillis);  
			}
		},

		tearDownScrollTimer : function() {
			if (this.scrollTimerHandle != null) {
				window.clearInterval(this.scrollTimerHandle);
				this.scrollTimerHandle = null;
			}
		},            

		autoScrollTimerMillis : 10,
		autoScrollStep : 2,
		autoScrollEdgeSize : 30,

		processPotentialScroll : function() {
			var upperY = this.topDiv.scrollTop;
			var upperRelY = Math.abs(this.dragY2 - upperY);
			if (upperRelY <= this.autoScrollEdgeSize) {
				var oldScrollTop = this.topDiv.scrollTop;
				this.topDiv.scrollTop = Math.max(this.topDiv.scrollTop - this.autoScrollStep, 0);
				this.dragY2 -= (oldScrollTop - this.topDiv.scrollTop);
				this.drawSelectionRect();
			}

			var leftX = this.topDiv.scrollLeft;
			var leftRelX = Math.abs(this.dragX2 - leftX);
			if (leftRelX <= this.autoScrollEdgeSize) {
				var oldScrollLeft = this.topDiv.scrollLeft;
				this.topDiv.scrollLeft = Math.max(this.topDiv.scrollLeft - this.autoScrollStep, 0);
				this.dragX2 -= (oldScrollLeft - this.topDiv.scrollLeft);
				this.drawSelectionRect();
			}

			var rightX = this.topDiv.scrollLeft + this.topDiv.offsetWidth;
			var rightRelX = Math.abs(this.dragX2 - rightX);
			if (rightRelX <= this.autoScrollEdgeSize) {
				var oldScrollLeft = this.topDiv.scrollLeft;
				this.topDiv.scrollLeft = Math.min(this.topDiv.scrollLeft + this.autoScrollStep, this.canvasWidth - this.topDiv.offsetWidth);
				this.dragX2 += (this.topDiv.scrollLeft - oldScrollLeft);
				this.drawSelectionRect();
			}                

			var lowerY = this.topDiv.scrollTop + this.topDiv.offsetHeight;
			var lowerRelY = Math.abs(this.dragY2 - lowerY);
			if (lowerRelY <= this.autoScrollEdgeSize) {
				var oldScrollTop = this.topDiv.scrollTop;
				this.topDiv.scrollTop = Math.min(this.topDiv.scrollTop + this.autoScrollStep, this.canvasHeight - this.topDiv.offsetHeight);
				this.dragY2 += (this.topDiv.scrollTop - oldScrollTop);
				this.drawSelectionRect();
			}                

			var relY = this.dragY2 - this.topDiv.scrollTop;
			if (log.isDebugEnabled()) {
				log.debug("dragY2 = [" + this.dragY2 + "]; topDiv.scrolTop = [" + this.topDiv.scrollTop + "] canvasHeight = [" + this.canvasHeight + "]");      
				log.debug("height = [" + this.topDiv.offsetHeight + "]");
			}                
		},

		getBoundingBox : function() {
			var factor = this.resolution / 72;

			var x1 = Math.min(this.dragX1, this.dragX2);
			var y1 = Math.min(this.dragY1, this.dragY2);
			var x2 = Math.max(this.dragX1, this.dragX2);
			var y2 = Math.max(this.dragY1, this.dragY2);

			var canvasHeight = (this.angle == 90 || this.angle == 270 ? this.canvasWidth : this.canvasHeight);
			var x0 = (this.angle == 90 || this.angle == 270 ? this.y0 : this.x0);            
			var y0 = (this.angle == 90 || this.angle == 270 ? this.x0 : this.y0);            

			var boundingBox = {
					lowerLeftX : x1 / factor + x0,
					lowerLeftY : (canvasHeight - y2) / factor + y0,
					upperRightX : x2 / factor + x0,
					upperRightY : (canvasHeight - y1) / factor + y0
			};                  

			return boundingBox;
		},

		getPage : function() {
			return this.page;
		},

		destroy : function() {
			this.inherited(arguments);

			this.eventDiv.removeEventListener("mousedown", this.mouseDownHandler, true);
			this.eventDiv.removeEventListener("mousemove", this.mouseMoveHandler, true);
		}
	});

	PlanningNotificationOrderExtractWidget.AsyncOperation = {

	};

	return PlanningNotificationOrderExtractWidget;
});
