define([
        "cdes/core/CdesVoc",
        "cdes/util/NameHelper",
        "clazzes/FancyIFrame",
        "clazzes/TinyLog",
        "clazzes/topic",
        "clazzes/util/DOMHelper",
        "clazzes/util/ErrorHelper",
        "clazzes/util/WidgetHelper",
        "clazzes/widgets/ImportHelper",
        "clazzes/widgets/layout/ContentWidget",
        "clazzes/widgets/layout/InfoDialog",
        "dijit/form/Form",
        "dijit/form/Select",
        "dijit/form/TextBox",
        "dijit/form/ValidationTextBox",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/Evented",
        "dojo/io-query",
        "dojo/keys",
        "dojo/on",
        "dojo/string",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojox/form/Uploader",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
],
function(
         CdesVoc,
         NameHelper,
         FancyIFrame,
         TinyLog,
         topic,
         DOMHelper,
         ErrorHelper,
         WidgetHelper,
         ImportHelper,
         ContentWidget,
         InfoDialog,
         Form,
         Select,
         TextBox,
         ValidationTextBox,
         domClass,
         domConstruct,
         Evented,
         ioQuery,
         Keys,
         on,
         string,
         declare,
         lang,
         Uploader,
         i18n
         ) {

    var className = "at.cdes.web.certificate.CertificateCreateWidget";

    var log = new TinyLog(className);

    var CertificateCreateWidget = declare(className, ContentWidget, {

        constructor : function(params) {
            lang.mixin(this,params);

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;
            this.anyFileSelected = false;
        },

        getWidgetId : function() {
            return "CertificateCreateWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);
            domClass.add(topDiv, "refNodeOfPositionAbsolute certificateCreateTopDiv");

            // Person TextBox
            DOMHelper.createTextNode("div", i18n.certificateCreatePersonLabel, topDiv, "propertyLabel certificateCreatePersonLabel");
            this.personTextBox = new TextBox({
                   label : i18n.certificateCreatePersonLabel,
                   title : i18n.certificateCreatePersonToolTip,
                disabled : true
            });
            domClass.add(this.personTextBox.domNode, "fixedDialogWidget certificateCreatePersonTextBox");
            domConstruct.place(this.personTextBox.domNode, topDiv);

            // UserCA Select
            DOMHelper.createTextNode("div", i18n.certificateCreateUserCaLabel, topDiv, "propertyLabel certificateCreateUserCaLabel");
            this.userCaSelect = new Select({
                   label : i18n.certificateCreateUserCaLabel,
                   title : i18n.certificateCreateUserCaToolTip,
                 options : [],
                tabIndex : 3,
            });
            domClass.add(this.userCaSelect.domNode, "fixedDialogWidget certificateCreateUserCaSelect");
            domConstruct.place(this.userCaSelect.domNode, topDiv);

            // UserCA Password TextBox
            DOMHelper.createTextNode("div", i18n.certificateCreateUserCaPasswordLabel, topDiv, "propertyLabel certificateCreateUserCaPasswordLabel");
            this.passwordTextBox = new ValidationTextBox({
                   label : i18n.certificateCreateUserCaPasswordLabel,
                   title : i18n.certificateCreateUserCaPasswordToolTip,
                    type : "password",
                tabIndex : 1
            });
            domClass.add(this.passwordTextBox.domNode, "fixedDialogWidget certificateCreateUserCaPasswordTextBox");
            domConstruct.place(this.passwordTextBox.domNode, topDiv);
            on(this.passwordTextBox.domNode, "keyup", lang.hitch(this, this.proceedIfEnter));

            // Upload
            this.uploadDiv = domConstruct.create("div", null, null);
            domClass.add(this.uploadDiv, "fixedDialogWidget certificateCreateUploadDiv");
            domConstruct.place(this.uploadDiv, topDiv);

            DOMHelper.createTextNode("div", i18n.certificateCreateUploadLabel, this.uploadDiv, "propertyLabel certificateCreateUploadLabel");

            this.form = new Form({method : "post", encType : "multipart/form-data"});
            this.uploader = new dojox.form.Uploader({name : "uploadedFile",
                multiple : false,
                    type : "file",
                   label : i18n.chooseFile,
                tabIndex : 2
            });
            domClass.add(this.uploader.domNode, "fixedDialogWidget certificateCreateUploader");
            this.form.domNode.appendChild(this.uploader.domNode);

            domConstruct.place(this.form.domNode, this.uploadDiv);

            this.importFrame = this.applicationContext.getFancyIFrame();
            //this.importFrame = new FancyIFrame({hidden : true});
            //domConstruct.place(this.importFrame.domNode, topDiv);

            this.form.set("target", this.importFrame.id);

            ImportHelper.installUploaderChangeHandler(this.uploader, this.fileInfoSpan, lang.hitch(this, this.uploaderChangeCallback));

            this.fileInfoSpan = domConstruct.create("span", null, null);
            domClass.add(this.fileInfoSpan, "fixedDialogWidget certificateCreateFileInfoSpan");
            domConstruct.place(this.fileInfoSpan, this.uploadDiv);



            return topDiv;
        },

        proceedIfEnter : function(e) {
            if (e.keyCode == Keys.ENTER && this.anyFileSelected) {
                this.doCreateCertificate();
            }
        },

        uploaderChangeCallback : function(anyFileSelected, fileSize, fileName) {
            this.anyFileSelected = anyFileSelected;
            this.fileSize = fileSize;
            this.fileName = fileName;

            this.updateWidgetState();
        },

        setData : function(params) {

            var certificateJoin = params.certificateJoin;               // CertificateJoin, for usage from CertificateListWidget
            var certificateRequestJoin = params.certificateRequestJoin; // CertificateRequestJoin, for usage from OrganisationPersonEditWidget
            this.personJoin = params.personJoin;                        // Join containing person attributes (givenName, surName) under name 'person'
            this.userPolicyPath = params.userPolicyPath; 
            this.successCallback = params.successCallback;

            if (certificateJoin != null) {
                this.setCertificateJoin(certificateJoin);
            } else if (certificateRequestJoin != null) {
                this.setCertificateRequestJoin(certificateRequestJoin);
            }


            this.reload();
        },

        setCertificateJoin : function(certificateJoin) {
            var unionClause = certificateJoin.unionClause;
            var requestType = certificateJoin.certificateRequestRequestType;
            if (unionClause == CdesVoc.CertificateJoinComponent.INVITATIONS && requestType != null && requestType.toLowerCase() == "request") {
                // Based on a CertificateRequest
                this.mode = CertificateCreateWidget.Mode.REQUEST;
            } else if (certificateJoin.certificateId != null) {
                // No currently valid certificate, but some existed in the past, and is expired by now
                this.mode = CertificateCreateWidget.Mode.CERTIFICATE;
            } else {
                this.mode = null;
                topic.publish("message/error", i18n.certificateCreateInvalidCertificate, true);
            }
            this.certificateJoin = certificateJoin;
            this.certificateId = certificateJoin.certificateId;
            this.certificateRequestId = certificateJoin.certificateRequestId;
        },

        setCertificateRequestJoin : function(certificateRequestJoin) {
            if (certificateRequestJoin.certificateId != null && certificateRequestJoin.certificateRequestId != null) {
                this.mode = CertificateCreateWidget.Mode.CERTIFICATE;
            } else if (certificateRequestJoin.certificateRequestId != null) {
                this.mode = CertificateCreateWidget.Mode.REQUEST;
            } else {
                this.mode = null;
                topic.publish("message/error", i18n.certificateCreateInvalidCertificate, true);
            }
            this.certificateRequestJoin = certificateRequestJoin;
            this.certificateId = certificateRequestJoin.certificateId;
            this.certificateRequestId = certificateRequestJoin.certificateRequestId;
        },

        reload : function() {

            if (this.mode == CertificateCreateWidget.Mode.REQUEST || this.mode == CertificateCreateWidget.Mode.CERTIFICATE) {
                var parameters = {
                                  type : "request",
                    certificateRequest : this.certificateRequestId,
                    organisationPerson: this.applicationContext.getPageContextOrganisationPersonId(),
                };
                var parameterString = ioQuery.objectToQuery(parameters);

                this.uploadUrl = "/cdes/svc/repositoryUpload?" + parameterString;

                this.uploader.set("url", this.uploadUrl);
                this.form.set("action", this.uploadUrl);
            }

            var certificateService = this.applicationContext.getService("certificateService");

            this.registerAsyncOperationStarted(CertificateCreateWidget.AsyncOperation.GET_USER_CAS);
            var deferred;
            if (this.mode == CertificateCreateWidget.Mode.CERTIFICATE) { // expired certificate to signCertificateRequestDirectly
                deferred = certificateService.getValidUserCas(this.applicationContext.getPageContextOrganisationPersonId(), null);
            } else { //REQUESTS
                deferred = certificateService.getValidUserCas(this.applicationContext.getPageContextOrganisationPersonId(), this.certificateRequestId);
            }

            deferred.then(lang.hitch(this, function(userCas) {

                this.userCas = userCas;
                this.registerAsyncOperationFinished(CertificateCreateWidget.AsyncOperation.GET_USER_CAS);

                this.updateWidgetsFromData();
                this.updateWidgetState();

                delete deferred;
            }),
                lang.hitch(this, function(err) {
                    delete deferred;

                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : CertificateCreateWidget.AsyncOperation.GET_USER_CAS,
                                opName : "getValidUserCas",
                               message : i18n.renewCertificateGetUserCasFailedMessage
                    });
                })
                ).otherwise(lang.hitch(this, function(err) {
                    log.error("Error while processing the results of calling getValidUserCas: ", err);
                }));
        },

        updateWidgetsFromData : function() {
            var personCommonName = NameHelper.getPersonCommonName(this.personJoin, "person");
            this.personTextBox.set("value", personCommonName);

            var options = [];
            for (var n = 0; n < this.userCas.length; n++) {
                var ca = this.userCas[n];
                options.push({ value : ca.id, label : ca.subjectDn });
            }
            options.sort(function(optionOne, optionTwo) {
                return optionOne.label.localeCompare(optionTwo.label);
            });                

            this.userCaSelect.set("options", options);
            if (options.length > 0) {
                this.userCaSelect.set("value", options[0].value);
            }
        },

        updateDataFromWidgets : function() {
            // Nothing to do here
        },

        updateWidgetState : function() {
            const d = this.dialog;
            if (d != null) {
                const b = d.createCertificateButton;
                if (b != null) {
                    b.set("disabled", (this.userPolicyPath != null && this.userPolicyPath.length>0) && !this.anyFileSelected);
                }
            }

            if (this.anyFileSelected) {
                var fileInfoString = ImportHelper.getFileInfoString(i18n.fileUploadFileSelected, this.fileName, this.fileSize);
                DOMHelper.setInnerText(this.fileInfoSpan, fileInfoString);
            } else {
                DOMHelper.setInnerText(this.fileInfoSpan, i18n.fileUploadNoFileSelected);
            }
        },

        doCreateCertificate : function() {
            var certificateService = this.applicationContext.getService("certificateService");

            var signerId = this.applicationContext.getPageContextOrganisationPersonId();
            this.registerAsyncOperationStarted(CertificateCreateWidget.AsyncOperation.SIGN);
            // TODO: No CertificateRequestId at this point

            if (this.anyFileSelected) {
                this.form.submit();

                if (this.documentLoadHandle == null) {
                    this.documentLoadHandle = on(this.importFrame, "documentLoad", lang.hitch(this, function(e) {
                        if (e.document.title != null && e.document.title.indexOf("Error") != -1) {
                            topic.publish("message/error", i18n.uploadFailed, true);
                        } else {
                            var deferred;
                            if (this.mode == CertificateCreateWidget.Mode.CERTIFICATE) {
                                deferred = certificateService.signCertificateRequestDirectly(this.certificateId, this.personJoin.organisationPersonId,
                                                                                             this.userCaSelect.get("value"), signerId,
                                                                                             this.passwordTextBox.get("value"));
                            } else if (this.mode == CertificateCreateWidget.Mode.REQUEST) {
                                deferred = certificateService.signCertificateRequest(this.certificateRequestId, this.userCaSelect.get("value"), signerId,
                                                                                     this.passwordTextBox.get("value"));
                            }
                            this.registerDeferredHandlers(deferred);
                        }
                    }));
                }
            } else {
                var deferred;
                if (this.mode == CertificateCreateWidget.Mode.CERTIFICATE) {
                    deferred = certificateService.signCertificateRequestDirectly(this.certificateId, this.personJoin.organisationPersonId,
                                                                                 this.userCaSelect.get("value"), signerId, this.passwordTextBox.get("value"));
                } else if (this.mode == CertificateCreateWidget.Mode.REQUEST) {
                    deferred = certificateService.signCertificateRequest(this.certificateRequestId, this.userCaSelect.get("value"), signerId,
                                                                         this.passwordTextBox.get("value"));
                }
                this.registerDeferredHandlers(deferred);
            }
        },

        registerDeferredHandlers : function(deferred) {
            deferred.then(lang.hitch(this, function() {

                this.registerAsyncOperationFinished(CertificateCreateWidget.AsyncOperation.SIGN);
                topic.publish("message/ok", string.substitute(i18n.certificateCreateSignOk, {
                    givenName : this.personJoin.personGivenName,
                      surName : this.personJoin.personSurName
                }));
                this.updateWidgetsFromData();

                on.emit(this, "certificateCreated");

                delete deferred;
            }),
                lang.hitch(this, function(err) {
                    delete deferred;

                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : CertificateCreateWidget.AsyncOperation.SIGN,
                                opName : "signCertificateRequest",
                               message : i18n.certificateCreateSignFailed
                    });
                })
                ).otherwise(lang.hitch(this, function(err) {
                    log.error("Error while processing the results of calling signCertificateRequest: ", err);
                }));
        },

        destroy : function() {
            this.inherited(arguments);
            log.info("destroy()");

            if (this.documentLoadHandle != null) {
                this.documentLoadHandle.remove();
                delete this.documentLoadHandle;
            }
        }
    });

    CertificateCreateWidget.AsyncOperation = {
        GET_USER_CAS : "GetUserCas",
        SIGN : "Sign"
    };

    CertificateCreateWidget.Mode = {
        REQUEST : "Request",      // Based on new CertificateRequest
        CERTIFICATE : "Certificate"   // Based on existing, but usually no longer valid, Certificate
    };

    return CertificateCreateWidget;
});
