/*
* $Id: ValueEditDialog.js 1321 2013-06-25 16:29:25Z mda $
*
* Copyright (C) 2016 ev-i IT GmbH
*/

define([
        "cdes/certificate/CertificateHelper",
        "clazzes/TinyLog",
        "clazzes/topic",
        "clazzes/util/DOMHelper",
        "clazzes/util/ErrorHelper",
        "clazzes/util/StringHelper",
        "clazzes/util/WidgetHelper",
        "clazzes/widgets/layout/DialogHelper",
        "clazzes/widgets/layout/InfoDialog",
        "dijit/form/Select",
        "dijit/form/TextBox",
        "dijit/form/ValidationTextBox",
        "dijit/layout/ContentPane",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/on",      
        "dojo/string",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
],
function(
         CertificateHelper,
         TinyLog,
         topic,
         DOMHelper,
         ErrorHelper,
         StringHelper,
         WidgetHelper,
         DialogHelper,
         InfoDialog,
         Select,
         TextBox,
         ValidationTextBox,
         ContentPane,
         domClass,
         domConstruct,
         on,
         string,
         declare,
         lang,
         i18n
         ) {

    var className = "at.cdes.web.certificate.RenewCertificateDialog";

    var log = new TinyLog(className);

    var RenewCertificateDialog = declare(className, InfoDialog, {
        
        constructor : function(params) {
            
            params.buttons = [ {          type : InfoDialog.Button.CUSTOM,
                       name : "renewButton",
                manualClose : true,
                      label : i18n.renewCertificateSignButtonCaption, 
                      title : i18n.renewCertificateSignButtonToolTip,
                        fct : lang.hitch(this, this.doRenew) },
                              {          type : InfoDialog.Button.ABORT }
            ];
            
            
            lang.mixin(this, params);
            if (this.personJoin == null) {
                this.personJoin = this.joinDto;
            }
            
            this.defaultWidth = DialogHelper.getBottomButtonDialogWidth(this.defaultWidth ? this.defaultWidth : 400);
            this.defaultHeight = DialogHelper.getBottomButtonDialogHeight(this.defaultHeight ? this.defaultHeight : 125);
            
            this.minWidth = DialogHelper.getBottomButtonDialogWidth(this.minWidth ? this.minWidth : 10);
            this.minHeight = DialogHelper.getBottomButtonDialogHeight(this.minHeight ? this.minHeight : 10);
        },              

        constructOptionWidget : function() {
            var topDiv = domConstruct.create("div", null, null);
            domClass.add(topDiv, "refNodeOfPositionAbsolute renewCertificateTopDiv");

            // Certificate for person
            DOMHelper.createTextNode("div", i18n.renewCertificatePersonLabel, topDiv, "propertyLabel renewCertificatePersonLabel");
            this.personNameTextBox = new TextBox({
                   label : i18n.renewCertificatePersonLabel,
                   title : i18n.renewCertificatePersonToolTip,
                disabled : true
            });
            this.personNameTextBox.set("value", this.personJoin.personGivenName + " " + this.personJoin.personSurName);
            domClass.add(this.personNameTextBox.domNode, "fixedDialogWidget renewCertificatePersonTextBox");                
            domConstruct.place(this.personNameTextBox.domNode, topDiv);                     
            
            // Certificate for organisation
            DOMHelper.createTextNode("div", i18n.renewCertificateOrganisationLabel, topDiv, "propertyLabel renewCertificateOrganisationLabel");
            this.organisationNameTextBox = new TextBox({
                   label : i18n.renewCertificateOrganisationLabel,
                   title : i18n.renewCertificateOrganisationToolTip,
                disabled : true
            });
            this.organisationNameTextBox.set("value", this.personJoin.organisationName);
            domClass.add(this.organisationNameTextBox.domNode, "fixedDialogWidget renewCertificateOrganisationTextBox");                    
            domConstruct.place(this.organisationNameTextBox.domNode, topDiv);               
            
            // UserCA Select
            DOMHelper.createTextNode("div", i18n.renewCertificateUserCALabel, topDiv, "propertyLabel renewCertificateUserCALabel");
            
            var options = [];

            this.userCASelect = new Select({
                   label : i18n.renewCertificateUserCALabel,
                   title : i18n.renewCertificateUserCAToolTip,
                "class" : "fixedDialogWidget renewCertificateUserCASelect",
                 options : options,
                disabled : true
            });
            domConstruct.place(this.userCASelect.domNode, topDiv);
            WidgetHelper.handleSelectEvents(this.userCASelect, lang.hitch(this, this.updateWidgetState));
            
            // CA Password Box
            DOMHelper.createTextNode("div", i18n.renewCertificateCAPasswordLabel, topDiv, "propertyLabel renewCertificateCAPasswordLabel");                 
            this.passwordTextBox = new ValidationTextBox({
                label : i18n.renewCertificateCAPasswordLabel,
                title : i18n.renewCertificateCAPasswordToolTip,
                 type : "password"
            });
            domClass.add(this.passwordTextBox.domNode, "fixedDialogWidget renewCertificateCAPasswordBox");
            domConstruct.place(this.passwordTextBox.domNode, topDiv);
            WidgetHelper.handleTextBoxEvents(this.passwordTextBox, lang.hitch(this, this.updateWidgetState));
            
            this.failedLabel = DOMHelper.createTextNode("div", "", topDiv, "fixedDialogWidget renewCertificateFailedLabel");
            
            this.content = new ContentPane({ content : topDiv}); 
            
            // Finally fill the userCaSelect with data; do not activate it before
            var certificateService = this.applicationContext.getService("certificateService");
            var caDeferred = certificateService.getValidUserCas(this.applicationContext.getPageContextOrganisationPersonId(), null);
            caDeferred.then(lang.hitch(this, function(validUserCas) {
                
                var options = [];
                var networkIdToUserCAId = new Object();
                for (var n = 0; n < validUserCas.length; n++) {
                    var ca = validUserCas[n];
                    options.push({ value : ca.id, label : ca.subjectDn });
                    networkIdToUserCAId[ca.networkId] = ca;
                }
	            options.sort(function(optionOne, optionTwo) {
	                return optionOne.label.localeCompare(optionTwo.label);
	            });                
                
                this.userCASelect.set("options", options);
                this.userCASelect.set("disabled", false);
                if (options.length > 0) {
					var requestsCAId =networkIdToUserCAId[this.personJoin.certificateRequestNetworkId].id;
                    this.userCASelect.set("value", requestsCAId);
                }

                delete caDeferred;
            }),
                lang.hitch(this, function(err) {                        
                    delete caDeferred;
                    
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : null,
                                opName : "getValidUserCas",
                               message : i18n.renewCertificateGetUserCasFailedMessage
                    }); 
                })
                ).otherwise(lang.hitch(this, function(err) {
                    log.error("Error while processing the results of calling getValidUserCas: ", err);
                }));                    
        },      
        
        updateWidgetState : function() {
            
            var allFieldsValid = this.userCASelect.get("value") != null && !StringHelper.isEmpty(this.passwordTextBox.get("value"));
            this.renewButton.set("disabled", !allFieldsValid);
        },
        
        show: function(chosenItem) {
            
            this.constructOptionWidget();
            this.constructWidgets();
            this.updateWidgetState();
            
            this.dialog.show();
        },
        
        doRenew : function() {
            var certificateService = this.applicationContext.getService("certificateService");
            
            log.info("Will renewCertificate; ca = " + this.userCASelect.get("value"));
            
            var password = this.passwordTextBox.get("value");
            var renewDeferred = certificateService.renewCertificate(this.joinDto.certificateId, this.userCASelect.get("value"), password, this.applicationContext.getPageContextOrganisationPersonId());
            renewDeferred.then(lang.hitch(this, function(touchedCertificateJoins) {
                if (touchedCertificateJoins != null) {
                    topic.publish("message/ok", string.substitute(i18n.renewCertificateOk, {
                               givenName : this.personJoin.personGivenName,
                                 surName : this.personJoin.personSurName,
                        organisationName : this.personJoin.organisationName
                    }));
                    
                    touchedCertificateJoins = CertificateHelper.preprocessCertificateJoins(touchedCertificateJoins);
                    
                    this.close();
                    this.successCallback(touchedCertificateJoins);
                } else {
                    DOMHelper.setInnerText(this.failedLabel, i18n.renewCertificateFailedMessage);                                           
                }                       
            }),
                lang.hitch(this, function(err) {    
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : null,
                                opName : "renewCertificate",
                               message : i18n.renewCertificateFailedMessage
                    });                             
                })
                ).otherwise(lang.hitch(this, function(err) {
                    log.error("Error while processing the results of calling renewCertificate", err);
                }));            
            
            // joinDto.certificateId
            // userCa aus Select
            // password aus Textfeld
            // organisationPerson aus context
            // Anzahl Jahre aus Service, d.h. nicht vom Client
        }
    });
    
    return RenewCertificateDialog;
});
