/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

define([ 
    "cdes/core/CdesVoc",
    "cdes/util/NameHelper",
    "cdes/util/I18nHelper",
    "clazzes/TinyLog",
    "clazzes/util/UnitHelper",
    "dojo/string",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"    
], function(
    CdesVoc,
    NameHelper,
    I18nHelper,
    TinyLog,
    UnitHelper,
    string,    
    i18n    
) {

    var className = "at.cdes.web.plot.PlotHelepr";
	
    var log = new TinyLog(className);
	
    var PlotHelper = {

        getColorString : function(isInColor) {
    	    if (isInColor == 0) {
    		return i18n.plotOrderItemListBlackWhiteLabel;
    	    } else if (isInColor == 1) {
    		return i18n.plotOrderItemListColorLabel;
    	    } else {
    		return i18n.plotOrderItemListAsDisplayedLabel;
    	    }            
        },

        getCountString : function(count) {
            return string.substitute(i18n.plotOrderItemListCountLabel, {
    	  count : count
    	    });
        },

    	getArea : function(params) {
            var llx = params.llx;
            var lly = params.lly;
            var urx = params.urx;
            var ury = params.ury;
            var scale = params.scale;
            var count = params.count;            

	    var area = null;
	    if (llx != null && lly != null && urx != null && ury != null) {
		    var llxMM = UnitHelper.convertPtToMM(llx);
		    var llyMM = UnitHelper.convertPtToMM(lly);    				
		    var urxMM = UnitHelper.convertPtToMM(urx);
		    var uryMM = UnitHelper.convertPtToMM(ury);
		    
		    area = (Math.abs(uryMM - llyMM) / 1000.0) * (Math.abs(urxMM - llxMM) / 1000.0);
		} else if (scale != null) {
		    area = UnitHelper.getPaperFormatMArea(scale);
		}
	    
	    if (area && count != null) {
		area *= count;
	    }
	    return area;
    	},
    	
    	getAreaString : function(area) {
    		return area.toFixed(2);
    	},        

        getLongAreaString : function(areaValue) {
    	    if (areaValue != null) {
    		return string.substitute(i18n.plotOrderItemListAreaLabel, {
    		    area : PlotHelper.getAreaString(areaValue)
    		});
    	    } else {
    		return "";
    	    }
        },

        getType : function(params) {
            var reviewCycleNodeId = params.reviewCycleNodeId;
            var reviewCycleNodeName = params.reviewCycleNodeName;
            var personId = params.personId;
            var personName = params.personName;            
            var locale = params.locale;            
            var reviewCycleNodeName = I18nHelper.getCurrentLocaleString(reviewCycleNodeName, locale);

    	    if (reviewCycleNodeId != null) {
    		return string.substitute(i18n.plotOrderItemListAutomaticallyGeneratedLabel, {
    		    reviewCycleNodeName : (reviewCycleNodeName ? reviewCycleNodeName : "")
    		});
    	    } else if (personId != null) {
    		return string.substitute(i18n.plotOrderItemListManuallyGeneratedLabel, {
    		    personName : (personName ? personName : "")
    		});
    	    } else {
    		return "";
    	    }
        },

        getPaperQualityOptions : function() {
            return [
                { value : i18n.plotPaperQualityLaser80, label : i18n.plotPaperQualityLaser80 },
                { value : i18n.plotPaperQualityInkjet80, label : i18n.plotPaperQualityInkjet80 },
                { value : i18n.plotPaperQualityLaser90, label : i18n.plotPaperQualityLaser90 },
                { value : i18n.plotPaperQualityInkjet90, label : i18n.plotPaperQualityInkjet90 }
            ];          
        },

        getChromaticityOptions : function() {
            return  [
                { value : CdesVoc.PlotPropertyColor.CHROMATICITY_MONOCHROME, label : i18n.plotColorMonochrome },
                { value : CdesVoc.PlotPropertyColor.CHROMATICITY_IN_COLOR, label : i18n.plotColorInColor },
                { value : CdesVoc.PlotPropertyColor.CHROMATICITY_LIKE_TEMPLATE, label : i18n.plotColorLikeTemplate }                
            ];                
        },

        getMarginOptions : function() {
            return [
                { value : i18n.plotMarginNotFold, label : i18n.plotMarginNotFold },
                { value : i18n.plotMarginFoldWithEdge, label : i18n.plotMarginFoldWithEdge },
                { value : i18n.plotMarginFoldWithoutEdge, label : i18n.plotMarginFoldWithoutEdge }                
            ];                
        },

        getScaleOptions : function() {
            return [
                { value : i18n.plotScaleNone, label : i18n.plotScaleNone },
                { value : i18n.plotScaleA4, label : i18n.plotScaleA4 },
                { value : i18n.plotScaleA3, label : i18n.plotScaleA3 },
                { value : i18n.plotScaleA2, label : i18n.plotScaleA2 },
                { value : i18n.plotScaleA1, label : i18n.plotScaleA1 },
                { value : i18n.plotScaleA0, label : i18n.plotScaleA0 }
            ];                
        }
    };

    return PlotHelper;    
});
