define([ 
    "cdes/core/CdesVoc",
    "cdes/plot/PlotHelper",
    "cdes/plot/PlotOrderItemListSummaryRow",
    "cdes/util/CodeHelper",
    "cdes/util/FancyColumnResizer",
    "cdes/util/NameHelper",
    "cdes/util/StyleHelper",
    "cdes/widget/base/ListWidget",
    "clazzes/TinyLog",
    "clazzes/util/DOMHelper",
    "clazzes/util/ErrorHelper",
    "clazzes/util/GridHelper",
    "clazzes/util/UnitHelper",
    "cdes/util/I18nHelper",
    "clazzes/widgets/DisableButton",
    "clazzes/widgets/layout/ContentWidget",
    "clazzes/widgets/layout/InfoDialog",
    "dgrid/OnDemandGrid",
    "dgrid/extensions/ColumnResizer",
    "dgrid/extensions/DijitRegistry",
    "dgrid/util/misc",
    "dojo/aspect",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/on",
    "dojo/string",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dstore/Memory",
    "clazzes/dateTime/DateHelper",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
],
function(
    CdesVoc,
    PlotHelper,
    PlotOrderItemListSummaryRow,
    CodeHelper,
    FancyColumnResizer,
    NameHelper,
    StyleHelper,
    ListWidget,
    TinyLog,
    DOMHelper,
    ErrorHelper,
    GridHelper,
    UnitHelper,
    I18nHelper,
    DisableButton,
    ContentWidget,
    InfoDialog,
    OnDemandGrid,
    ColumnResizer,
    DijitRegistry,
    dgridMiscUtil,
    aspect,
    domClass,
    domConstruct,
    domStyle,
    on,
    string,
    declare,
    lang,
    Memory,
    DateHelper,
    i18n
) {
    
    var className = "at.cdes.web.plot.PlotOrderItemListWidgetOld";

    var log = new TinyLog(className);
    
    var PlotOrderItemListWidgetOld = declare(className, ListWidget, {
        
        constructor : function(params) {
            lang.mixin(this,params);
            
            this.columnVisibility = new Object();
            this.columnHiderRules = new Object();
            
            this.topDiv = this.constructTopDiv();
            
            this.allFieldsValid = true;
        },
        
        getWidgetId : function() {
            return "PlotOrderItemListWidgetOld";
        },
        
        getDataId : function() {
            return null;
        },
        
        getContainer : function() {
            return this.topDiv;
        },
        
        columnWidthKey : "plotOrderItemListOld/columnWidths",

        getLocalStorageContextKeys : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextNetworkId();
            return [organisationPersonId, networkId];
        },

        constructColumns : function() {
            
            var columns = [];
            
            columns.push({
                    field : "_documentNumber",
                       id : "documentNumber",
                formatter : lang.hitch(this, this.documentNumberFormatter),
                 sortable : true,
                    label : i18n.plotOrderItemListDocumentNumberColumnCaption 
            });
            
            columns.push({
                    field : "_paperQuality",
                       id : "plotPropertiesPaperQuality",
                formatter : lang.hitch(this, this.paperQualityFormatter),
                 sortable : true,
                    label : i18n.plotOrderItemListPaperColumnCaption 
            });
            
            columns.push({
                   field : "_color",
                      id : "color",
                sortable : true,
                   label : i18n.plotOrderItemListColorColumnCaption 
            });
            
            columns.push({
                    field : "_margin",
                       id : "plotPropertiesMargin",
                formatter : lang.hitch(this, this.marginFormatter),
                 sortable : true,
                    label : i18n.plotOrderItemListMarginColumnCaption 
            });
            
            columns.push({
                   field : "_mirror",
                      id : "mirror",
                sortable : true,
                   label : i18n.plotOrderItemListMirrorColumnCaption 
            });
            
            columns.push({
                   field : "plotPropertiesScale",
                      id : "plotPropertiesScale",
                sortable : true,
                   label : i18n.plotOrderItemListScaleColumnCaption 
            });

            columns.push({
                   field : "_area",
                      id : "area",
                sortable : true,
                   label : i18n.plotOrderItemListAreaColumnCaption 
            });

            columns.push({
                   field : "_pages",
                      id : "pages",
               formatter : lang.hitch(this, this.pagesFormatter),
                sortable : true,
                   label : i18n.plotOrderItemListPagesColumnCaption 
            });
            
            columns.push({
                   field : "_type",
                      id : "type",
               formatter : lang.hitch(this, this.typeFormatter),
                sortable : true,
                   label : i18n.plotOrderItemListTypeColumnCaption 
            });             
            
            
            columns.push({
                   field : "_count",
                      id : "count",
                sortable : true,
                   label : i18n.plotOrderItemListCountColumnCaption 
            });     

            columns.push({
                    field : "_delivery",
                       id : "delivery",
                formatter : lang.hitch(this, this.deliveryFormatter),                       
                 sortable : true,
                    label : i18n.plotOrderItemListDeliveryColumnCaption 
            });  
            
            columns.push({
                    field : "_received",
                       id : "received",
                formatter : lang.hitch(this, this.receivedFormatter),
                 sortable : true,
                    label : i18n.plotOrderItemListReceivedColumnCaption 
            });
            
            columns.push({
                     field : "plotOrderId",
                        id : "actions",
                renderCell : lang.hitch(this, this.renderActionCell),
                  sortable : false,
                     label : ""//i18n.actionColumnCaption
            });
            
            return columns;
        },

        documentNumberFormatter : function(_documentNumber, joinDto) {
        
        	var documentContent = joinDto.documentReleaseContent!=null ? joinDto.documentReleaseContent : joinDto.documentContent;
            var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();
            var documentContent = I18nHelper.getCurrentLocaleString(documentContent, locale);
        
            return joinDto.documentVersionName + "<br>" + documentContent;
        },
        
        paperQualityFormatter : function(_paperQuality, joinDto) {
            return _paperQuality;
        },
        
        marginFormatter : function(_margin, joinDto) {
            return _margin;
        },
        
        pagesFormatter : function(_pages, joinDto) {
        	var res = _pages==0?"-":_pages
            return res;
        },
        
        typeFormatter : function(_type, joinDto) {
			var resultString = joinDto._type;
            if (joinDto.plotOrderItemCreated != null) {
                resultString += "<br>"+DateHelper.formatUtcSecondsWithTimeZone(joinDto.plotOrderItemCreated, this.applicationContext.getTimeZone(), i18n.dateWithSecondsPattern);
            }
			return resultString;
        },
        
        deliveryFormatter : function(_delivery, joinDto) {
            return joinDto.deliveryAddressOrganisationName + "<br>"
                + string.substitute(i18n.deliverDirectly, {
                    destination : joinDto.deliveryAddressGivenName + " " + joinDto.deliveryAddressSurName
                })
                + "<br>"
                + joinDto.deliveryAddressPostalAddress + "<br>"
                + joinDto.deliveryAddressPostalCode + " " + joinDto.deliveryAddressLocalityName + "<br>"
                + joinDto.deliveryCountryDescDe;
        },
        
        receivedFormatter : function(_received, joinDto) {

            
            if (joinDto.receivedStepAcceptedMode == null) {
                return "";
            } else {
                var resultString = "";

                if (joinDto.receivedStepFinished != null) {
                    resultString += DateHelper.formatUtcSecondsWithTimeZone(joinDto.receivedStepFinished, this.applicationContext.getTimeZone(), i18n.dateWithSecondsPattern);
                    resultString += "<br>";
                }
                if (joinDto.signaturePersonId != null) {
                    resultString += NameHelper.getPersonCommonName(joinDto, "signaturePerson");
                    resultString += "<br>";
                }
                if (joinDto.receivedStepAcceptedMode == CdesVoc.OrderStepMode.ACCEPTED) {
                    resultString += i18n.ok + "<br>";
                } else if (joinDto.receivedStepAcceptedMode == CdesVoc.OrderStepMode.DECLINED) {
                    resultString += i18n.notOk + "<br>";
                } else {
                    resultString += "-" + "<br>";
                }
                if (joinDto.receivedStepComment != null) {
                    resultString += joinDto.receivedStepComment;
                    resultString += "<br>";
                }                       

                return resultString;                    
            }
        },
        
        renderActionCell : function(joinDto, data, cell) {
            var buttonDiv = domConstruct.create("div", null, null);
            
            var previewButton = this.constructPreviewButton(joinDto);
            domConstruct.place(previewButton.domNode, buttonDiv);
            
            if (joinDto.acceptanceStepSignatureId == null
                && this.applicationContext.isActionAllowedForProject("editProject")) {
                    var deleteButton = this.constructDeleteButton(joinDto);
                    domConstruct.place(deleteButton.domNode, buttonDiv);                            
                }               
            
            return buttonDiv;
        },
        
        constructPreviewButton : function(joinDto) {
            return new DisableButton({
                           label : i18n.previewButtonCaption,
                       showLabel : false,
                         tooltip : i18n.plotOrderItemListPreviewButtonToolTip,
                         onClick : lang.hitch(this, this.showPreview, joinDto),
                       iconClass : "previewButton",
                "class" : "cdesWebButton17x18 gridButton",
                controllerWidget : this,
                    disableEvent : "disableButtons",
                _destroyOnRemove : true
            });             
        },
        
        constructDeleteButton : function(joinDto) {
            return new DisableButton({
                           label : i18n.deleteButtonCaption,
                       showLabel : false,
                         tooltip : i18n.plotOrderItemListDeleteButtonToolTip,
                         onClick : lang.hitch(this, this.deletePlotOrderItem, joinDto),
                       iconClass : "deleteButton",
                "class" : "cdesWebButton17x18 gridButton",
                controllerWidget : this,
                    disableEvent : "disableButtons",
                _destroyOnRemove : true
            });
        },
        
        showPreview : function(joinDto) {
            var documentVersionId = joinDto.documentVersionId;
            var imageTag = domConstruct.create("img", null, null);
            
            imageTag.src = "/cdes/app?service=CDESMimeService/4/documentVersionPngMimeSource&sp=" + documentVersionId + "&sp=320&sp=T&rand=" + Math.random()
                + "&ts=" + dojoConfig.tabSessionId;
            
            var infoDialog = new InfoDialog({
                 defaultWidth : 320,
                defaultHeight : 320, 
                        title : string.substitute(i18n.plotOrderItemListPreviewTitle, { documentName : joinDto.documentName}),
                      content : imageTag,
                      buttons : [ { type : InfoDialog.Button.OK },
                      ]                             
            });
            infoDialog.show();              
        },
        
        deletePlotOrderItem : function(joinDto) {
            InfoDialog.showQuestion({
                  title : i18n.plotOrderItemListReallyDeleteCaption,
                message : string.substitute(i18n.plotOrderItemListReallyDeleteText, {
                      documentName : (joinDto.documentReleaseContent!=null ? joinDto.documentReleaseContent : joinDto.documentContent),
                    documentNumber : joinDto.documentVersionName
                }),
                buttons : [
                    { type : InfoDialog.Button.YES, fct : lang.hitch(this, function() {
                        this.doDeletePlotOrderItem(joinDto);
                    })},                                    
                    { type : InfoDialog.Button.NO }
                ]
            });             
        },
        
        doDeletePlotOrderItem : function(joinDto) {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var projectId = this.applicationContext.getPageContextProjectId();
            
            var plotService = this.applicationContext.getService("plotService");
            
            this.registerAsyncOperationStarted(PlotOrderItemListWidgetOld.AsyncOperation.DELETE_PLOT_ORDER_ITEM);
            plotService.deletePlotOrderItem(joinDto.plotOrderItemId, organisationPersonId, projectId).then(lang.hitch(this, function() {

                topic.publish("message/ok", string.substitute(i18n.plotOrderItemListDeleteItemOk, {
                       documentName : joinDto.documentName,
                    documentContent : (joinDto.documentReleaseContent!=null ? joinDto.documentReleaseContent : joinDto.documentContent)
                }));
                
                // Remove the deleted document from the grid, and update its contents without reloading data from the server
                var newJoinDtos = [];
                for (var n = 0; n < this.joinDtos.length; n++) {
                    if (this.joinDtos[n].plotOrderItemId != joinDto.plotOrderItemId) {
                        newJoinDtos.push(this.joinDtos[n]);
                    }
                }
                this.joinDtos = newJoinDtos;

                this.reload();
                
                this.registerAsyncOperationFinished(PlotOrderItemListWidgetOld.AsyncOperation.DELETE_PLOT_ORDER_ITEM);
            }),
                lang.hitch(this, function(err) {                        
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : PlotOrderItemListWidgetOld.AsyncOperation.DELETE_PLOT_ORDER_ITEM,
                                opName : "deletePlotOrderItem",
                               message : i18n.plotOrderItemListDeleteItemFailed
                    });                             
                })
            ).otherwise(lang.hitch(this, function(err) {
                log.error("Error while processing the results of a call to deletePlotOrderItem: ", err);
            }));                    
        },
        
        constructTopDiv : function() {

            //var columns = this.constructColumns();
            var columns = this.constructColumns();
            this.store = new Memory({data : [], idProperty : "plotOrderItemId"}); // TODO
            
            var MyGrid = declare([OnDemandGrid, PlotOrderItemListSummaryRow, FancyColumnResizer, DijitRegistry ]);
            this.grid = new MyGrid({
                collection : this.store,
                   columns : columns
            });
            
            domClass.add(this.grid.domNode, "dgrid-autoheight plotOrderItemListGrid");
            
            this.grid.afterResizeMouseUp = lang.hitch(this, this.handleColumnResize);

            this.grid.startup();
            
            aspect.after(this.grid, "renderRow", function(row, args) {
                
                domClass.add(row, StyleHelper.getDocumentVersionStatusCSS(args[0]));
                
                return row;
            });
            
            return this.grid.domNode;
        },
        
        setData : function(params) {
            
            this.joinDtos = params.data;
            this.updateAuxiliaryData();
            
            this.reload();
        },
        
        updateAuxiliaryData : function() {
            for (var n = 0; n < this.joinDtos.length; n++) {
                var joinDto = this.joinDtos[n];
                joinDto._documentNumber = this.documentNumberFormatter(null, joinDto).replace("<br>", " ");
                joinDto._color = PlotHelper.getColorString(joinDto.plotPropertiesIsInColor);                    
                joinDto._paperQuality = joinDto.plotPropertiesPaperQuality;
                joinDto._margin = joinDto.plotPropertiesMargin;
                
                joinDto._mirror = CodeHelper.getBooleanYesNo(joinDto.plotPropertiesMirror);
                joinDto._count = PlotHelper.getCountString(joinDto.plotPropertiesCount);
                joinDto._areaValue = PlotHelper.getArea({
                      llx : joinDto.plotPropertiesLlx,
                      lly : joinDto.plotPropertiesLly,
                      urx : joinDto.plotPropertiesUrx,
                      ury : joinDto.plotPropertiesUry,
                    scale : joinDto.plotPropertiesScale,
                    count : joinDto.plotPropertiesCount                        
                });
                joinDto._pages = joinDto.documentVersionNumberOfPages;
                joinDto._area = PlotHelper.getLongAreaString(joinDto._areaValue);
                joinDto._type = PlotHelper.getType({
                      reviewCycleNodeId : joinDto.reviewCycleNodeId,
                    reviewCycleNodeName : joinDto.reviewCycleNodeName,
                               personId : joinDto.personId,
                             personName : NameHelper.getPersonCommonName(joinDto, "person"),
                                 locale : this.applicationContext.getPageContextPersonVariablesUserLocale()
                });                        
                
                joinDto._delivery = this.deliveryFormatter(null, joinDto).replace("<br>", " ");
                joinDto._received = this.receivedFormatter(null, joinDto).replace("<br>", " ");
            }
            
            this.calculateAreaSums();
            
            var colorString = "";
            if (this.totalColorArea > 0) {
                colorString += string.substitute(i18n.plotOrderItemListColorSumLabel, { 
                    area : this.getAreaString(this.totalColorArea) 
                });
            }
            if (this.totalBlackWhiteArea > 0) {
                colorString += (colorString.length > 0 ? "<br>" : "") + string.substitute(i18n.plotOrderItemListBlackWhiteSumLabel, { 
                    area : this.getAreaString(this.totalBlackWhiteArea)
                });
            }
            if (this.totalLikeTemplateArea > 0) {
                colorString += (colorString.length > 0 ? "<br>" : "") + string.substitute(i18n.plotOrderItemListLikeTemplateSumLabel, { 
                    area : this.getAreaString(this.totalLikeTemplateArea) 
                });
            }               
            
            var paperQualityString = "";
            for (var paperQuality in this.paperQualitySums) {
                paperQualityString += (paperQualityString.length > 0 ? "<br>" : "") + string.substitute(i18n.plotOrderItemListItemLabel, { 
                    item : paperQuality,
                    area : this.getAreaString(this.paperQualitySums[paperQuality]) 
                });
            }
            
            var paperMarginString = "";
            for (var paperMargin in this.paperMarginSums) {
                paperMarginString += (paperMarginString.length > 0 ? "<br>" : "") + string.substitute(i18n.plotOrderItemListItemLabel, {
                    item : paperMargin,
                    area : this.getAreaString(this.paperMarginSums[paperMargin]) 
                });
            }       
            
            var totalAreaString = string.substitute(i18n.plotOrderItemListTotalSumLabel, {
                area : this.getAreaString(this.totalArea)
            });
             
            var totalPagesString = string.substitute(i18n.plotOrderItemListPagesSumLabel, {
                pages : this.totalPages==0?"-":this.totalPages
            });
           
            this.grid.set("summary", {
                _documentNumber : i18n.plotOrderItemListAreaSum,
                _color : colorString,
                _paperQuality : paperQualityString,
                _margin : paperMarginString,
                _area : totalAreaString,
                _pages : totalPagesString
            });
        },
        
        getArea : function(joinDto) {
            var area = null;
            if (joinDto.plotPropertiesLlx != null && joinDto.plotPropertiesLly != null
                && joinDto.plotPropertiesUrx != null && joinDto.plotPropertiesUry != null) {
                    
                    var llxMM = UnitHelper.convertPtToMM(joinDto.plotPropertiesLlx);
                    var llyMM = UnitHelper.convertPtToMM(joinDto.plotPropertiesLly);                                
                    var urxMM = UnitHelper.convertPtToMM(joinDto.plotPropertiesUrx);
                    var uryMM = UnitHelper.convertPtToMM(joinDto.plotPropertiesUry);
                    
                    area = (Math.abs(uryMM - llyMM) / 1000.0) * (Math.abs(urxMM - llxMM) / 1000.0);
                } else if (joinDto.plotPropertiesScale != null) {
                    area = UnitHelper.getPaperFormatMArea(joinDto.plotPropertiesScale);
                }
            
            if (area && joinDto.plotPropertiesCount != null) {
                area *= joinDto.plotPropertiesCount;
            }
            return area;
        },
        
        getAreaString : function(area) {
            return area.toFixed(2);
        },
        
        calculateAreaSums : function() {
            
            this.totalArea = 0;
            this.totalColorArea = 0;
            this.totalBlackWhiteArea = 0;
            this.totalLikeTemplateArea = 0;
            this.totalPages = 0;
            this.paperQualitySums = new Object();
            this.paperMarginSums = new Object();

            for (var n = 0; n < this.joinDtos.length; n++) {
                var joinDto = this.joinDtos[n];
                
                if (joinDto.documentVersionStatus != CdesVoc.DocumentVersionStatus.INVALIDATEDVERSION
                    &&  joinDto.documentVersionStatus != CdesVoc.DocumentVersionStatus.INVALIDATEDALL
                    &&  joinDto.documentVersionStatus != CdesVoc.DocumentVersionStatus.DELETED
                    && (joinDto.subProjectInvalidated == null || joinDto.subProjectInvalidated == 0)
                    &&  joinDto.plotPropertiesLlx != null
                    &&  joinDto.plotPropertiesLly != null
                    &&  joinDto.plotPropertiesUrx != null
                    &&  joinDto.plotPropertiesUry != null
                    &&  joinDto._areaValue != null) {
                        
                        var area = joinDto._areaValue;
                        this.totalArea += area;
                        
                        if (joinDto.plotPropertiesIsInColor == CdesVoc.PlotPropertyColor.CHROMATICITY_IN_COLOR) {
                            this.totalColorArea += area;
                        } else if (joinDto.plotPropertiesIsInColor == CdesVoc.PlotPropertyColor.CHROMATICITY_MONOCHROME) {
                            this.totalBlackWhiteArea += area;
                        } else if (joinDto.plotPropertiesIsInColor == CdesVoc.PlotPropertyColor.CHROMATICITY_LIKE_TEMPLATE) {
                            this.totalLikeTemplateArea += area;
                        }
                        
                        if (!(joinDto.plotPropertiesPaperQuality in this.paperQualitySums)) {
                            this.paperQualitySums[joinDto.plotPropertiesPaperQuality] = 0;
                        }
                        this.paperQualitySums[joinDto.plotPropertiesPaperQuality] += area;
                        
                        if (!(joinDto.plotPropertiesMargin in this.paperMarginSums)) {
                            this.paperMarginSums[joinDto.plotPropertiesMargin] = 0;
                        }
                        this.paperMarginSums[joinDto.plotPropertiesMargin] += area;
                        
                        var pages = joinDto._pages;
                        this.totalPages += pages;

                    }                       
            }               
        },
        
        //PLAN_DELIVER_SORT_PROPERTIES : [{ attribute : "documentName", descending : false}],
        
        reload : function() {
            this.store.setData(this.joinDtos);
            
            var joinDto = this.joinDtos.length > 0 ? this.joinDtos[0] : null;
            GridHelper.updateColumnVisibility({
                                      id : "actions",
                                    show : joinDto && joinDto.acceptanceStepSignatureId == null,
                triggerStateChangeAlways : false,
                        columnVisibility : this.columnVisibility,
                                    grid : this.grid,
                        columnHiderRules : this.columnHiderRules
            });
            
            this.grid.refresh();
        },

        /***************************************** Filter *******************************************/
        
        filter : function(searchString) {
            
        },
        
        filterRow : function(joinDto, rowNode, searchStrings) {
            
        },
        
        destroy : function() {
            this.inherited(arguments);
            this.grid.destroy();
        }
    });
    
    PlotOrderItemListWidgetOld.AsyncOperation = {
        DELETE_PLOT_ORDER_ITEM : "DeletePlotOrderItem"  
    };    
    
    return PlotOrderItemListWidgetOld;
});
