/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

define([ 
    "cdes/review/ReviewProtocolPositionListWidget",
    "cdes/util/I18nHelper",
    "cdes/util/NameHelper",
    "cdes/widget/base/ListWidget",
    "clazzes/TinyLog",
    "clazzes/dateTime/DateHelper",
    "clazzes/util/DOMHelper",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/on",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js",
    "dojo/string"
], function(
    ReviewProtocolPositionListWidget,
    I18nHelper,
    NameHelper,
    ListWidget,
    TinyLog,
    DateHelper,
    DOMHelper,
    domClass,
    domConstruct,
    domStyle,
    on,    
    declare,
    lang,
    i18n,
    string
) {

    var className = "at.cdes.review.ReviewProtocolCrossCommentListWidget";

    var log = new TinyLog(className);

    var ReviewProtocolCrossCommentListWidget = declare(className, ListWidget, {

        constructor : function(params) {
            lang.mixin(this, params);

            this.topDiv = this.constructTopDiv();

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "ReviewProtocolCrossCommentListWidget";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        columnWidthKey : "reviewProtocolCrossCommentList/columnWidths",

        getLocalStorageContextKeys : function() {
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var networkId = this.applicationContext.getPageContextNetworkId();
            return [organisationPersonId, networkId];
        },

        constructColumns : function() {
            var columns = [];

            columns.push({
		     field : "_nodeName",
		        id : "nodeName",
    	renderCell : lang.hitch(this, this.renderNode),
		  sortable : true,
  		     label : i18n.reviewProtocolCrossCommentNodeCaption
            });                

	    columns.push({
		     field : "_reviewer",
		        id : "reviewer",
                renderCell : lang.hitch(this, this.renderReviewer),
		  sortable : true,
  		     label : i18n.reviewProtocolCrossCommentReviewerCaption
	    });

	    columns.push({
		     field : "_realm",
		        id : "realm",
                renderCell : lang.hitch(this, this.renderRealm),
		  sortable : true,
		     label : i18n.reviewProtocolCrossCommentRealmCaption
	    });

	    columns.push({
		    field : "_reviewDate",
		       id : "reviewDate",
                formatter : lang.hitch(this, this.formatReviewDate),
		 sortable : true,
		    label : i18n.reviewProtocolCrossCommentResultDateCaption
	    });

	    columns.push({
		     field : "_review",
		        id : "review",
                renderCell : lang.hitch(this, this.renderReview),
		  sortable : true,
		     label : i18n.reviewProtocolCrossCommentReviewCaption
	    });

	    columns.push({
		     field : "_oldResult",
		        id : "oldResult",
                renderCell : lang.hitch(this, this.renderOldResult),
		  sortable : true,
		     label : i18n.reviewProtocolCrossCommentResultCaption
	    });

	    columns.push({
		     field : "_comment",
		        id : "comment",
                renderCell : lang.hitch(this, this.renderComment),
		  sortable : true,
		     label : i18n.reviewProtocolCrossCommentCommentCaption
	    });                        

	    columns.push({
		     field : "_result",
		        id : "result",
                renderCell : lang.hitch(this, this.renderResult),                
		  sortable : true,
		     label : i18n.reviewProtocolCrossCommentResultCaption
	    });

            return columns;            
        },

		getPositionMainPersonWithOrganisationString : function(positionJoin) {
		    var organisationName = positionJoin.positionMainOrganisationName;
		    var personCommonName = NameHelper.getPersonCommonName(positionJoin, "positionMainPerson");
		    var result = string.substitute(i18n.deputyPersonWithOrganisation, {
		        person : personCommonName,
		        organisation : organisationName                
		    });
		    return result;            
		},

        getPositionMainPersonString : function(positionJoin) {
            var personCommonName = NameHelper.getPersonCommonName(positionJoin, "positionMainPerson");
			var result = string.substitute(i18n.deputyPerson, {
			    person : personCommonName
			});
            return result;            
        },

        getPositionPersonString : function(positionJoin) {
			var organisationName = positionJoin.positionOrganisationName;
            var personCommonName = NameHelper.getPersonCommonName(positionJoin, "positionPerson");
			var result = string.substitute(i18n.organisationCommonName, {
			    organisationName : organisationName,
			    personCommonName : personCommonName                
			});
            return result;
        },            


        getLineClass : function(positionJoin) {
            if (positionJoin._striked != null && positionJoin._striked) {
                return "reviewProtocolCrossCommentInvalidated";
            } else {
                return "";
            }                
        },  
                  
        renderNode : function(positionJoin, data, cell) {
            var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();
            var nodeName = I18nHelper.getCurrentLocaleString(positionJoin._nodeName, locale);
            var cellDiv = domConstruct.create("div", null, null);
            var lineClass = this.getLineClass(positionJoin);
            DOMHelper.createTextNode("div", nodeName, cellDiv, lineClass);
            return cellDiv;
        },

        renderReviewer : function(positionJoin, data, cell) {
            var commentReferenceId = positionJoin.reviewCyclePositionResultCommentReferenceId;
            var oldPositionJoin = this.reviewContext.getPositionResultJoin(commentReferenceId);            

            var cellDiv = domConstruct.create("div", null, null);
            var lineClass = this.getLineClass(positionJoin);
            DOMHelper.createTextNode("div", this.getPositionPersonString(oldPositionJoin), cellDiv, lineClass);
            if (!oldPositionJoin.positionParticipantMainParticipantFlag || oldPositionJoin.positionParticipantInactiveFlag) {
				if (oldPositionJoin.positionOrganisationId != oldPositionJoin.positionMainOrganisationId) {
				    DOMHelper.createTextNode("div", this.getPositionMainPersonWithOrganisationString(oldPositionJoin), cellDiv, "reviewProtocolPositionDeputy");
				} else if (oldPositionJoin.positionPersonId != oldPositionJoin.positionMainPersonId) {
				    DOMHelper.createTextNode("div", this.getPositionMainPersonString(oldPositionJoin), cellDiv, "reviewProtocolPositionDeputy");
				}
            }

            return cellDiv;
        },

        renderRealm : function(positionJoin, data, cell) {
            var commentReferenceId = positionJoin.reviewCyclePositionResultCommentReferenceId;
            var oldPositionJoin = this.reviewContext.getPositionResultJoin(commentReferenceId);

            var cellDiv = domConstruct.create("div", null, null);
            if (oldPositionJoin.realmCode != null) {
                DOMHelper.createTextNode("span", oldPositionJoin.realmCode, cellDiv, "reviewProtocolCrossCommentRealmCodeLabel");
            }
            if (oldPositionJoin.realmName != null) {
                var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();
                var realmName = I18nHelper.getCurrentLocaleString(oldPositionJoin.realmName, locale);
                DOMHelper.createTextNode("span", realmName, cellDiv, "reviewProtocolCrossCommentRealmNameLabel");
            }                
            return cellDiv;            
        },

        renderReview : function(positionJoin, data, cell) {
            var commentReferenceId = positionJoin.reviewCyclePositionResultCommentReferenceId;
            var oldPositionJoin = this.reviewContext.getPositionResultJoin(commentReferenceId);            

            var cellDiv = domConstruct.create("div", null, null);
            var resultOptionId = positionJoin.reviewCycleNodeResultReviewCycleResultOptionId;
            var resultOption = this.reviewContext.getResultOption(resultOptionId);
            if (resultOption != null && resultOption.value == -7) {
                DOMHelper.createTextNode("span", i18n.reviewProtocolPositionNotReviewedLabel, cellDiv, "reviewProtocolPositionNotReviewedLabel");
            }
            if (positionJoin.positionOverridingPersonId != null) {
                var overridingPersonCommonName = NameHelper.getPersonCommonName(positionJoin, "positionOverridingPerson");
                var overridingLabel = string.substitute(i18n.reviewProtocolPositionOverridingLabel, {
                    personCommonName : overridingPersonCommonName
                });                        
                DOMHelper.createTextNode("span", overridingLabel, cellDiv, "reviewProtocolPositionOverridingPersonLabel");
            }
            if (oldPositionJoin.reviewCyclePositionResultComment != null) {
                // Safe html according to the conversion in DocumentService.getReviewProtocolData (utilService.getSafeHtml) at server side
	        var node = domConstruct.create("div", { innerHTML : oldPositionJoin.reviewCyclePositionResultComment });
                domConstruct.place(node, cellDiv);                
//                DOMHelper.createTextNode("span", oldPositionJoin.reviewCyclePositionResultComment, cellDiv, null);
            }                

            return cellDiv;
        },

        formatReviewDate : function(date, positionJoin) {
            var commentReferenceId = positionJoin.reviewCyclePositionResultCommentReferenceId;
            var oldPositionJoin = this.reviewContext.getPositionResultJoin(commentReferenceId);

            var resultDate = oldPositionJoin.reviewCyclePositionResultResultDate;
    	    if (resultDate != null) {
    		return DateHelper.formatUtcSecondsWithTimeZone(resultDate, this.applicationContext.getTimeZone(), i18n.dateWithSecondsPattern); 
    	    } else {
    		return "";
    	    }
        },

        renderOldResult : function(positionJoin, data, cell) {
            var commentReferenceId = positionJoin.reviewCyclePositionResultCommentReferenceId;
            var oldPositionJoin = this.reviewContext.getPositionResultJoin(commentReferenceId);


            var resultOptionId = oldPositionJoin.reviewCyclePositionResultReviewCycleResultOptionId;
            var resultOption = resultOptionId != null ? this.reviewContext.getResultOption(resultOptionId) : null;
            var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();
            var resultOptionName = resultOption != null ? I18nHelper.getCurrentLocaleString(resultOption.name, locale) : "";            

            var cssClass = resultOption.value == 0 ? "reviewProtocolNegativeReview" : null;
            var cellDiv = domConstruct.create("div", null, null);
            if (resultOption.value == 0) {
                domClass.add(cell, cssClass);
            }                
            DOMHelper.createTextNode("span", resultOptionName, cellDiv, null);
            return cellDiv;            
        },

        renderComment : function(positionJoin, data, cell) {
            var cellTable = domConstruct.create("table", null, null);
            var row = domConstruct.create("tr", null, cellTable);

            var commentCell = domConstruct.create("td", null, row);
            var comment = positionJoin.reviewCyclePositionResultComment;
            if (comment != null) {
	        var node = domConstruct.create("div", { innerHTML : comment });
                domClass.add(node, "reviewProtocolPositionComment");                
                domConstruct.place(node, commentCell);                
//                DOMHelper.createTextNode("div", comment, commentCell, "reviewProtocolPositionComment");                
            }

            var positionResultId = positionJoin.reviewCyclePositionResultId;
            var attachments = this.reviewContext.getPositionResultAttachments(positionResultId);
            var attachmentCell = domConstruct.create("td", null, row);
            for (var n = 0; n < attachments.length; n++) {
                var attachment = attachments[n];
                var attachmentButton = ReviewProtocolPositionListWidget.constructAttachmentButton({
                            attachment : attachment,
                     documentVersionId : positionJoin.documentVersionId,
                    applicationContext : this.applicationContext                    
                });
                domConstruct.place(attachmentButton.domNode, attachmentCell);                    
            }
            
            return cellTable;
        },

        renderResult : function(positionJoin, data, cell) {
            var cellDiv = domConstruct.create("div", null, null);
            var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();
            var name = I18nHelper.getCurrentLocaleString(positionJoin.reviewCycleCommentOptionName, locale);
            var nameLabel = name != null ? name : "\u2015";
            if (positionJoin.reviewCycleCommentOptionName == 0) {
                domClass.add(cell, "reviewProtocolNegativeReview");
            }                

            DOMHelper.createTextNode("span", nameLabel, cellDiv, null);
            return cellDiv;                        
        },

        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);

            this.captionDiv = DOMHelper.createTextNode("div", "", topDiv, "reviewProtocolCrossCommentCaption");

	    var grid = this.constructGrid({
		idProperty : "_id", 
		    gridId : "ReviewProtocolCrossCommentGrid",
                 gridClass : "Grid"
	    });
            /*            
	    on(grid, "dgrid-sort", lang.hitch(this, function(e) {
		var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
		var networkId = this.applicationContext.getPageContextPnNetworkId();
		this.applicationContext.storeInLocalStorage([organisationPersonId, networkId], "/planningNotification/sort", e.sort);
	    }));
            */
            domConstruct.place(grid, topDiv);

            return topDiv;
        },

        setData : function(params) {
            this.nodeResultJoin = params.nodeResultJoin;
            this.crossCommentNodeResultJoins = params.crossCommentNodeResultJoins;
            this.reviewContext = params.reviewContext;

            this.reload();
        },

        reload : function() {
            var nodeResultId = this.nodeResultJoin.reviewCycleNodeResultId;
            var locale = this.applicationContext.getPageContextPersonVariablesUserLocale();
            //this is the position_result owning the comments
            //get the reviewer and the NodeResultDepartureDate
            var reviewer = this.nodeResultJoin.positionOrganisationName + ' (' + this.nodeResultJoin.positionPersonSurName + ' ' + this.nodeResultJoin.positionPersonGivenName + ')';
            var reviewDate = DateHelper.formatUtcSecondsWithTimeZone(this.nodeResultJoin.reviewCycleNodeResultDepartureDate, this.applicationContext.getTimeZone(), i18n.dateWithSecondsPattern);

            var caption = string.substitute(i18n.reviewProtocolCrossCommentCaption, {
                nodeName : I18nHelper.getCurrentLocaleString(/*this.nodeResultJoin.reviewCycleNodeName+' '+*/reviewer+' '+reviewDate, locale)
            });
            DOMHelper.setInnerText(this.captionDiv, caption);

            this.updateAuxiliaryData();
            this.setStoreData(this.crossCommentNodeResultJoins);
            this.grid.resize();
        },

	updateAuxiliaryData : function() {
            for (var n = 0; n < this.crossCommentNodeResultJoins.length; n++) {
                var positionJoin = this.crossCommentNodeResultJoins[n];

                var commentReferenceId = positionJoin.reviewCyclePositionResultCommentReferenceId;
                var oldPositionJoin = this.reviewContext.getPositionResultJoin(commentReferenceId);            

                positionJoin._nodeName = oldPositionJoin.reviewCycleNodeName;

                positionJoin._reviewer = this.getPositionPersonString(oldPositionJoin);
                if (!oldPositionJoin.positionParticipantMainParticipantFlag || oldPositionJoin.positionParticipantInactiveFlag) {
					if (oldPositionJoin.positionOrganisationId != oldPositionJoin.positionMainOrganisationId) {
						positionJoin._reviewer += this.getPositionMainPersonWithOrganisationString(oldPositionJoin);
					} else if (oldPositionJoin.positionPersonId != oldPositionJoin.positionMainPersonId) {
						positionJoin._reviewer += this.getPositionMainPersonString(oldPositionJoin);
					}
                }

                positionJoin._reviewDate = this.formatReviewDate(null, positionJoin);

                positionJoin._realm = "";
                if (oldPositionJoin.realmCode != null) {
                    positionJoin._realm += oldPositionJoin.realmCode;
                }
                if (oldPositionJoin.realmName != null) {
                    positionJoin._realm += oldPositionJoin.realmName;
                }                

                positionJoin._review = "";
                var resultOptionId = positionJoin.reviewCycleNodeResultReviewCycleResultOptionId;
                var resultOption = this.reviewContext.getResultOption(resultOptionId);
                if (resultOption != null && resultOption.value == -7) {
                    positionJoin._review += i18n.reviewProtocolPositionNotReviewedLabel;
                }
                if (positionJoin.positionOverridingPersonId != null) {
                    var overridingPersonCommonName = NameHelper.getPersonCommonName(positionJoin, "positionOverridingPerson");
                    var overridingLabel = string.substitute(i18n.reviewProtocolPositionOverridingLabel, {
                        personCommonName : overridingPersonCommonName
                    });                        
                    positionJoin._review += overridingLabel;
                }
                if (oldPositionJoin.reviewCyclePositionResultComment != null) {
                    positionJoin._review += oldPositionJoin.reviewCyclePositionResultComment;
                }

                var oldResultOptionId = oldPositionJoin.reviewCyclePositionResultReviewCycleResultOptionId;
                var oldResultOption = oldResultOptionId != null ? this.reviewContext.getResultOption(oldResultOptionId) : null;
                var oldResultOptionName = oldResultOption != null ? oldResultOption.name : "";            
                positionJoin._oldResult = oldResultOptionName;

                positionJoin._comment = "";
                var comment = positionJoin.reviewCyclePositionResultComment;
                if (comment != null) {
                    positionJoin._comment += comment;
                }                

                positionJoin._result = "";
                var name = positionJoin.reviewCyclePositionResultReviewCycleCommentOptionName;
                positionJoin._result = name != null ? name : "\u2015";
            }
	},

        updateWidgetState : function() {

        },

        resize : function(newSize) {
            // We need to perform the resize in two steps.
            // First set the desired width, and some arbitrary height.
            var width = newSize.w + 0.01;
            var height = this.getActualHeight();
            this.grid.resize({ w : width, h : height });
        },

        destroy : function() {
            this.inherited(arguments);
            this.grid.destroy();
        }
    });

    ReviewProtocolCrossCommentListWidget.AsyncOperation = {
        DELETE : "Delete"
    };        

    return ReviewProtocolCrossCommentListWidget;
});
