define([ 
        "cdes/pdc/PlanDeliverHelper",         
        "cdes/pdc/PlanDeliverListWidget",
        "cdes/util/ActionHelper",
        "cdes/util/SaveLoadHelper",
        //"cdes/widget/ContextBar",
        "clazzes/TinyLog",
        "clazzes/topic",
        "clazzes/util/DOMHelper",
        "clazzes/util/ErrorHelper",
        "clazzes/widgets/layout/ContentWidget",
        "clazzes/widgets/layout/InfoDialog",
        "dijit/form/Button",
        "dijit/form/ValidationTextBox",
        "dijit/form/CheckBox",
        "dojo/dom-class",
        "dojo/dom-construct",
        "dojo/dom-style",
        "dojo/keys",
        "dojo/on",
        "dojo/string",
        "dojo/_base/declare",
        "dojo/_base/lang",
        "dojo/i18n!/cdes/nls/cdes-web-i18n.js"
],
function(
         PlanDeliverHelper,
         PlanDeliverListWidget,
         ActionHelper,
         SaveLoadHelper,
         //ContextBar,
         TinyLog,
         topic,
         DOMHelper,
         ErrorHelper,
         ContentWidget,
         InfoDialog,
         Button,
         ValidationTextBox,
         CheckBox,
         domClass,
         domConstruct,
         domStyle,
         Keys,
         on,
         string,
         declare,
         lang,
         i18n
         ) {
    
    var className = "at.cdes.web.plan.PlanDeliverReleasePage";

    var log = new TinyLog(className);
    
    var PlanDeliverReleasePage = declare(className, ContentWidget, {
        
        constructor : function(params) {
            lang.mixin(this,params);
            
            this.topDiv = this.constructTopDiv();
            
            
            this.updateWidgetState();
            this.allFieldsValid = true;
            
            this.initialize();
        },

        initialize : function() {
            var planDeliverService = this.applicationContext.getService("planDeliverService");

	    var subProjectId = this.applicationContext.getPageContextSubProjectId();
            this.registerAsyncOperationStarted(PlanDeliverReleasePage.AsyncOperation.GET_RELEASE_DATA);
            planDeliverService.getPlanDeliverReleaseData(subProjectId).then(lang.hitch(this, function(contentLocales) {
                this.listWidget.setContentLocales(contentLocales);
                this.reload();

                this.registerAsyncOperationFinished(PlanDeliverReleasePage.AsyncOperation.GET_RELEASE_DATA);
            }),
                lang.hitch(this, function(err) {                        
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : PlanDeliverReleasePage.AsyncOperation.GET_RELEASE_DATA,
                                opName : "getPlanDeliverReleaseData",
                               message : i18n.planDeliverReleaseGetReleaseDataFailed
                    });                                     
                })
                ).otherwise(lang.hitch(this, function(err) {
                    log.error("Error while processing the results of a call to getPlanDeliverReleaseData: ", err);
                }));                                
        },        
        
        getWidgetId : function() {
            return "PlanDeliverReleasePage";
        },
        
        getDataId : function() {
            return null;
        },
        
        getContainer : function() {
            return this.topDiv;
        },
        
        constructTopDiv : function() {                  
            var topDiv = domConstruct.create("div", null, null);
            
            // Caption Bar
            this.captionBarDiv = this.constructCaptionBar();
            domClass.add(this.captionBarDiv, "planDeliverReleasePageCaptionBar");
            domConstruct.place(this.captionBarDiv, topDiv);

            // PlanDeliverListWidget
            this.listWidget = new PlanDeliverListWidget({
                applicationContext : this.applicationContext,
                              mode : PlanDeliverListWidget.Mode.RELEASE
            });
            this.listWidgetDiv = this.listWidget.getContainer();
            domConstruct.place(this.listWidgetDiv, topDiv);
            
            // Legend below List Widget
            this.legendDiv = PlanDeliverHelper.constructPlanDeliverLegend(topDiv);
            domConstruct.place(this.legendDiv, topDiv);             

            return topDiv;
        },
        
        constructCaptionBar : function() {
            // Caption Bar consisting of caption and context bar right of the caption
            var captionBarDiv = domConstruct.create("div", null, null);
            domClass.add(captionBarDiv, "planDeliverCatalogueCaptionBar");
            
            // Caption
            this.captionDiv = DOMHelper.createTextNode("h1", i18n.planDeliverReleasePageCaption, captionBarDiv, "planDeliverCatalogueCaption");

			this.captionButtonDiv = domConstruct.create("div", null, null);
			domClass.add(this.captionButtonDiv, "planDeliverCatalogueCaptionButtonDiv");
			domConstruct.place(this.captionButtonDiv, captionBarDiv);

			DOMHelper.createTextNode("span", i18n.planDeliverReleasePasswordLabel, this.captionButtonDiv, "planDeliverReleasePasswordLabel");
			// Password TextBox
			this.passwordTextBox = new ValidationTextBox({
			    label : i18n.planDeliverReleasePasswordLabel,
			    title : i18n.planDeliverReleasePasswordToolTip,
			     type : "password"
			});
			domClass.add(this.passwordTextBox.domNode, "planDeliverReleasePasswordTextBox");
			domConstruct.place(this.passwordTextBox.domNode, this.captionButtonDiv);
			on(this.passwordTextBox.domNode, "keyup", lang.hitch(this, this.releaseIfEnter));               

			// SignButton
			this.signButton = new Button({
			      label : i18n.planDeliverReleaseSignButtonLabel,
			      title : i18n.planDeliverReleaseSignButtonToolTip,
			    onClick : lang.hitch(this, this.sign)
			});
			domClass.add(this.signButton.domNode, "planDeliverReleaseSignButton");
			domConstruct.place(this.signButton.domNode, this.captionButtonDiv);

			// AbortButton
			this.abortButton = new Button({
			      label : i18n.planDeliverReleaseAbortButtonLabel,
			      title : i18n.planDeliverReleaseAbortButtonToolTip,
			    onClick : lang.hitch(this, this.abort) 
			});             
			domClass.add(this.abortButton.domNode, "planDeliverReleaseAbortButton");
			domConstruct.place(this.abortButton.domNode, this.captionButtonDiv);             

			// updateAllDocumentsCheckBox
			if (this.applicationContext.isActionAllowedForProject("superAdminRight")) {
			    DOMHelper.createTextNode("span", i18n.planDeliverReleaseUpdateAllDocumentsCheckBoxLabel, this.captionButtonDiv, "planDeliverReleaseUpdateAllDocumentsCheckBoxLabel");
			    this.updateAllDocumentsCheckBox = new CheckBox({
			        label : i18n.planDeliverReleaseUpdateAllDocumentsCheckBoxLabel,
			        title : i18n.planDeliverReleaseUpdateAllDocumentsCheckBoxToolTip
			    });
			    domClass.add(this.updateAllDocumentsCheckBox.domNode, "planDeliverReleaseUpdateAllDocumentsCheckBox"); 
			    domConstruct.place(this.updateAllDocumentsCheckBox.domNode, this.captionButtonDiv);            
			}
			
            return captionBarDiv;
        },

        resize : function(newSize) {
            
            var totalHeight = newSize.h;                    

            var tableWidth = this.captionBarDiv.offsetWidth - 15;
            var tableHeight = totalHeight
                            //- this.contextBarDiv.offsetHeight - domStyle.get(this.contextBarDiv, "margin-top") - domStyle.get(this.contextBarDiv, "margin-bottom")
                            - this.captionBarDiv.offsetHeight
                            - (this.legendDiv.offsetHeight + 5)
                            - 16;
            
            this.listWidget.resize({ w : tableWidth, h : tableHeight });
        },
        
        setData : function() {

        },
        
        reload : function() {
            //this.contextBar.reload();
            
            var planDeliverService = this.applicationContext.getService("planDeliverService");
            var project = this.applicationContext.getPageContextProject();
            
            // Deliberately empty search model (beside the page context), as we want to show everything on release.
            var searchModel = {
                organisationPersonId : this.applicationContext.getPageContextOrganisationPersonId(),
                           projectId : this.applicationContext.getPageContextProjectId(),
                        subProjectId : this.applicationContext.getPageContextSubProjectId()
            };
            
            // If the previous search still runs, cancel it
            if (this.joinDeferred != null) {
                this.joinDeferred.cancel();
            }
            
            // Trigger async search request
            this.joinDeferred = planDeliverService.getPlanDeliverUnreleasedJoin(searchModel);
            this.listWidget.setData({ data : [] });
            
            // Update button state etc.
            this.registerAsyncOperationStarted(PlanDeliverReleasePage.AsyncOperation.GET_DATA);
            this.updateWidgetState();
            this.joinDeferred.then(lang.hitch(this, function(planDeliverJoin) {
                this.planDeliverJoin = planDeliverJoin;
                
                if (this.planDeliverJoin.joinDtos.length > 0) {
                    this.documentListVersion = this.planDeliverJoin.joinDtos[0].documentListVersion;
                }                       
                
                this.planDeliverJoin.joinDtos = PlanDeliverHelper.filterForNonEmptyDocuments(this.planDeliverJoin.joinDtos);

                // Probably not really needed here, as we offer no actions for showing them here
                var documentIdToHistoryItems = planDeliverJoin.documentIdToHistoryItems;
                
                this.objectPlannerIdToActions = ActionHelper.transformObjectPlannerIdToActions(planDeliverJoin.objectPlannerIdToActions);
                
                var plannerMap = PlanDeliverHelper.getPlannerMap(this.planDeliverJoin.joinDtos);
                var objectMap = PlanDeliverHelper.getObjectMap(this.planDeliverJoin.joinDtos);
                var objectPlannerMap = PlanDeliverHelper.getObjectPlannerMap(this.planDeliverJoin.joinDtos);
                
                var searchInfoString = PlanDeliverHelper.getSearchInfoString(this.planDeliverJoin.joinDtos, plannerMap, objectMap, objectPlannerMap);
                topic.publish("message/ok", searchInfoString);
                
                var columnSettings = this.getColumnSettings();
                this.listWidget.setData({             data : this.planDeliverJoin.joinDtos,
                                     columns : columnSettings,
                    documentIdToHistoryItems : documentIdToHistoryItems,
                    objectPlannerIdToActions : this.objectPlannerIdToActions,
                                  unreleased : true
                });
                
                delete this.joinDeferred;
                
                this.registerAsyncOperationFinished(PlanDeliverReleasePage.AsyncOperation.GET_DATA);
                this.updateWidgetState();
                
                this.passwordTextBox.focus();
            }),
                lang.hitch(this, function(err) {                        
                    delete this.joinDeferred;
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : PlanDeliverReleasePage.AsyncOperation.GET_DATA,
                                opName : "getPlanDeliverUnreleasedJoin",
                               message : i18n.planDeliverReleaseGetDataFailed
                    });
                })
                ).otherwise(lang.hitch(this, function(err) {
                    log.error("Error while processing the results of calling getPlanDeliverJoin: ", err);
                }));  
        },
        
        getColumnSettings : function() {
            return {
                      showPlannerPerson : true,
                showPlannerOrganisation : true,
                            showComment : true,
                       showObjectNumber : true,
                         showObjectName : true,
                  showObjectPlannerCode : true,
                  showObjectPlannerName : true,
                     showDocumentNumber : true,
                       showDocumentName : true,
                              showStart : true,
                                showEnd : true,
                              showScale : true,
                             showPeriod : true
            };              
        },
        
        updateWidgetState : function() {
            
            var versionString = (this.documentListVersion != null ? this.documentListVersion.toString() : "---");
            var captionString = string.substitute(i18n.planDeliverReleasePageCaption, {
                version : versionString
            });
            DOMHelper.setInnerText(this.captionDiv, captionString);
            
            var operationRunning = this.isAsyncOperationRunning();
            this.passwordTextBox.set("disabled", operationRunning);
            this.signButton.set("disabled", operationRunning);
            this.abortButton.set("disabled", false);
        },
        
        releaseIfEnter : function(e) {
            if (e.keyCode == Keys.ENTER) {
                this.sign();
            }
        },      
        
        sign : function() {
            
            var organisationPersonId = this.applicationContext.getPageContextOrganisationPersonId();
            var projectId = this.applicationContext.getPageContextProjectId();
            var subProjectId = this.applicationContext.getPageContextSubProjectId();
            var password = this.passwordTextBox.get("value");
            var updateAllDocuments = false;
            if (this.updateAllDocumentsCheckBox != null)
            updateAllDocuments = this.updateAllDocumentsCheckBox.get("checked");
            
            var planDeliverService = this.applicationContext.getService("planDeliverService");
            this.signDeferred = planDeliverService.releasePlanDeliverCatalogue(organisationPersonId, projectId, subProjectId, password, updateAllDocuments);
            
            // Update button state etc.
            this.registerAsyncOperationStarted(PlanDeliverReleasePage.AsyncOperation.SIGN);
            this.updateWidgetState();
            this.signDeferred.then(lang.hitch(this, function(resultSummary) {

                if (log.isDebugEnabled()) {
                    log.debug("Successfully released; result: ", resultSummary);    
                }                               
                
                delete this.signDeferred;
                
                topic.publish("message/ok", i18n.planDeliverReleaseSignOk);
                
                this.registerAsyncOperationFinished(PlanDeliverReleasePage.AsyncOperation.SIGN);
                
                var givenReleasedData = {
                    resultSummary : resultSummary
                };
                lang.mixin(givenReleasedData, this.planDeliverJoin);
                
                SaveLoadHelper.constructResultSummaryDialogIfDebug(log, resultSummary, lang.hitch(this, function() {
                    this.applicationContext.setPage("planDeliverCatalogue", {}, {
                        gotoFirstReleasedVersion : true,
											 mode: PlanDeliverReleasePage.Mode.DEFAULT,
	     						 		cameBack : true
                        
                        // Uncomment this line to jump to the just released documents, instead of initiating a new query:                                       
                        //givenReleasedData : givenReleasedData
                    });
                }));
                /*                      
                if (log.isDebugEnabled()) {
                var infoDialog = new InfoDialog({
                title : i18n.resultSummaryCaption,
                content : SaveLoadHelper.constructResultSummaryDiv(resultSummary),
                buttons : [ { type : InfoDialog.Button.YES },
                { type : InfoDialog.Button.NO }
            ]                             
            });
                on(infoDialog, "confirm", lang.hitch(this, function() {
                this.applicationContext.setPage("planDeliverCatalogue", {
                givenReleasedData : givenReleasedData
            });                             
            }));
                infoDialog.show();                              
            } else {
                this.applicationContext.setPage("planDeliverCatalogue", {
                givenReleasedData : givenReleasedData
            });                             
            }
                */                                              
            }),
                lang.hitch(this, function(err) {
                delete this.signDeferred;
                ErrorHelper.processAsyncError({
	                err : err,
	                widget : this,
	                asyncOperation : PlanDeliverReleasePage.AsyncOperation.SIGN,
	                opName : "releasePlanDeliverCatalogue",
	                message : i18n.planDeliverReleaseSignFailed,
	                securityExceptionError : i18n.wrongPasswordOrMissingPrivilegesMessage
            	});                             
            })
            ).otherwise(lang.hitch(this, function(err) {
                log.error("Error while processing the results of calling releasePlanDeliverCatalogue: ", err);
            }));                    
            },
                
                abort : function() {
                this.applicationContext.setPage("planDeliverCatalogue", {}, {
                	gotoUnreleasedVersion : true,
									  mode: PlanDeliverReleasePage.Mode.DEFAULT,
	     						 cameBack : true
            	});
            },
                
                destroy : function() {
	                this.inherited(arguments);
	                this.listWidget.destroy();
            	}
            });
                
                PlanDeliverReleasePage.AsyncOperation = {
                    GET_DATA : "GetData",
                    GET_RELEASE_DATA : "GetReleaseData",
                    SIGN : "Sign"
            };

			PlanDeliverReleasePage.Mode = {
					DEFAULT : "Default",
					EDITING : "Editing",
					RELEASING : "Releasing"
			};
                                              
          return PlanDeliverReleasePage;
          });
