/***********************************************************
* $Id$
*
* Copyright (C) 2017 ev-i Informationstechnologie Gmbh
*
**********************************************************/

//// css-prefix = planningNotificationTaskPage
//// i18n-prefix = planningNotificationTaskPage         

define([ "cdes/core/CdesVoc",
    "cdes/planning/task/PlanningNotificationTaskColumnWidget",
    "cdes/planning/task/PlanningNotificationTaskListWidget",
    "cdes/planning/task/ReviewSignWidget",
    "cdes/task/TaskSearchWidget",
    "cdes/util/ColumnHelper",
    "clazzes/ClazzesVoc",
    "clazzes/TinyLog",
    "clazzes/form/FancyButton",
    "clazzes/topic",
    "clazzes/util/DOMHelper",
    "clazzes/util/ErrorHelper",
    "clazzes/util/GridHelper",
    "clazzes/util/JobHelper",
    "clazzes/util/WidgetHelper",
    "clazzes/widgets/layout/ContentWidget",
    "clazzes/widgets/layout/EditDialog",
    "dijit/form/Button",
    "dijit/form/CheckBox",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "dojo/io-query",
    "dojo/json",
    "dojo/on",      
    "dojo/string",
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/i18n!/cdes/nls/cdes-web-i18n.js"],
function(
    CdesVoc,
    PlanningNotificationTaskColumnWidget,
    PlanningNotificationTaskListWidget,
    ReviewSignWidget,
    TaskSearchWidget,
    ColumnHelper,
    ClazzesVoc,
    TinyLog,
    FancyButton,
    topic,
    DOMHelper,
    ErrorHelper,
    GridHelper,
    JobHelper,
    WidgetHelper,
    ContentWidget,
    EditDialog,
    Button,
    CheckBox,
    domClass,
    domConstruct,
    domStyle,
    ioQuery,
    json,
    on,
    string,         
    declare,
    lang,
    i18n) {

    var className = "at.cdes.web.planning.task.PlanningNotificationTaskPage";

    var log = new TinyLog(className);

    var PlanningNotificationTaskPage = declare(className, ContentWidget, {

        constructor : function(params) {
            // Remaining TODOs:
            // - disabling quick search filter while async operations are running
            // - sorting in grid, especially dueDate
            // - line feed in grid cells vs. quick search
            //        --> e.g. "Durchführung<line feed>BK Tunnel ARGE" isn't found by "DurchführungBK" or "Durchführung BK"         
            // - quickSearch changes order; e.g. having "serialNumber=1,serialNumber2, ... " and then quick search for "2"
            //        leads to the second serialNumber = 1 (and the serialNumber=2 line is somewhere below)
            // - Refactor CertificatePage to use the quick search code migrated to ListWidget       

            lang.mixin(this, params);
            this.planningNotificationTaskInfos = [];

            this.topDiv = this.constructTopDiv();
//            this.setTabSessionContext();
            this.reload();

            this.allFieldsValid = true;
        },

        getWidgetId : function() {
            return "PlanningNotificationTaskPage";
        },

        getDataId : function() {
            return null;
        },

        getContainer : function() {
            return this.topDiv;
        },

        setTabSessionContext : function() {
			this.registerAsyncOperationStarted(PlanningNotificationTaskPage.AsyncOperation.UPDATE_NETWORK);
			var tabSessionContextService = this.applicationContext.getService("tabSessionContextService");
			tabSessionContextService.setPlanningNotificationNetworkToTabSession(dojoConfig.tabSessionId, -1, true).then(			
					lang.hitch(this, function(pageContext) {
						if (log.isDebugEnabled()) {
							log.debug("Completed setPlanningNotificationNetworkToTabSession with networkId = -1");
						}

						this.applicationContext.setPageContext(pageContext);
						topic.publish("context/change");				
						this.registerAsyncOperationFinished(PlanningNotificationTaskPage.AsyncOperation.UPDATE_NETWORK);
					}),
					lang.hitch(this, function(err) {
						ErrorHelper.processAsyncError({
							err : err,
							widget : this,
							asyncOperation : PlanningNotificationTaskPage.AsyncOperation.UPDATE_NETWORK,
							opName : "setPlanningNotificationNetworkToTabSession",
							message : i18n.contextBarSetPlanningNotificationNetworkToTabSessionFailed
						});
					})).otherwise(
							lang.hitch(this, function(err) {
								log.err("Error while calling function [setPlanningNotificationNetworkToTabSession]", err);
							}));
        },
        
        constructTopDiv : function() {
            var topDiv = domConstruct.create("div", null, null);

            // Caption Bar
            this.captionBarDiv = this.constructCaptionBar();
            domClass.add(this.captionBarDiv, "cdesGeneralPageCaptionBar");
            domConstruct.place(this.captionBarDiv, topDiv);

            // Column Widget
            this.columnWidget = new PlanningNotificationTaskColumnWidget({
                applicationContext : this.applicationContext
            });
            this.columnWidgetDiv = this.columnWidget.getContainer();
            domConstruct.place(this.columnWidgetDiv, topDiv);
            on(this.columnWidget, "titlePaneToggled", lang.hitch(this, this.resize));
            on(this.columnWidget, "columnsChanged", lang.hitch(this, this.processColumnsChanged));
            var defaultColumnSettings = ColumnHelper.getDefaultColumnSettings(this.applicationContext, this, null, "planningNotificationTask/columns");
            this.columnWidget.setData(defaultColumnSettings);

            // Content
            this.contentDiv = this.constructContentDiv();
            domConstruct.place(this.contentDiv, topDiv);

            // List Widget
            this.listWidget = new PlanningNotificationTaskListWidget({
                applicationContext : this.applicationContext,
                          backPage : "planningNotificationTaskList",
                        backParams : new Object(),
                       showActions : true               
            });
            this.listWidgetDiv = this.listWidget.getContainer();
            domConstruct.place(this.listWidgetDiv, topDiv);
            on(this.listWidget, "selectionChanged", lang.hitch(this, this.updateWidgetState));
            
            // Reload data after certain operations which change state have been performed
            on(this.searchWidget, "doSearch", lang.hitch(this, this.reload));
            on(this.listWidget, "doSearch", lang.hitch(this, function() {
                this.reload();
                this.searchWidget.reloadCounts();
            }));                

            return topDiv;
        },

        getColumnWidget : function() {
            return this.columnWidget;       
        },          

        constructCaptionBar : function() {
            var captionBarDiv = domConstruct.create("div", null, null);
            domClass.add(captionBarDiv, "refNodeOfPositionAbsolute planningNotificationTaskPageCaptionBarDiv");            

            // Caption
            this.captionDiv = DOMHelper.createTextNode("h1", i18n.planningNotificationTaskPageCaption, captionBarDiv,
                "fixedDialogWidget cdesGeneralPageCaption taskSearchPageCaption");

            this.constructExportToPdfButton(captionBarDiv);

            //signBatchDiv for SignBatchButton and selectAllCheckBox (only visible in signature map)
            this.signBatchDiv = domConstruct.create("div", null, null);
            domClass.add(this.signBatchDiv, "fixedDialogWidget planningNotificationTaskPageSignBatchDiv");            

            // SignBatchButton
            this.signBatchButton = new Button({
                label : i18n.planningNotificationTaskSignBatchCaption,
                title : i18n.planningNotificationTaskSignBatchToolTip
            });            
            domClass.add(this.signBatchButton.domNode, "fixedDialogWidget planningNotificationTaskSignBatchButton");
            domConstruct.place(this.signBatchButton.domNode, this.signBatchDiv);
            on(this.signBatchButton, "click", lang.hitch(this, this.signBatch));

            this.selectCheckBox = new CheckBox({
                label : i18n.planningNotificationTaskSelectLabel
            });
            domClass.add(this.selectCheckBox.domNode, "fixedDialogWidget planningNotificationTaskSelectCheckBox");
            domConstruct.place(this.selectCheckBox.domNode, this.signBatchDiv);
            WidgetHelper.handleCheckBoxEvents(this.selectCheckBox, lang.hitch(this, this.selectUsingCheckBox));            

            this.selectLabel = DOMHelper.createTextNode("div", i18n.planningNotificationTaskSelectLabel, this.signBatchDiv, "propertyLabel planningNotificationTaskSelectLabel");
            domConstruct.place(this.signBatchDiv, captionBarDiv);

            // Search Widget
            this.searchWidget = new TaskSearchWidget({
                applicationContext : this.applicationContext,
                       initialMode : this.initialMode                
            });
            this.searchWidgetDiv = this.searchWidget.getContainer();
            domClass.add(this.searchWidgetDiv, "fixedDialogWidget planningNotificationTaskPageSearchWidget");            
            domConstruct.place(this.searchWidgetDiv, captionBarDiv);
            on(this.searchWidget, "quickSearchChange", lang.hitch(this, this.processQuickSearchChange));

            return captionBarDiv;
        },

        constructContentDiv : function() {
            var contentDiv = domConstruct.create("div", null, null);
            domClass.add(contentDiv, "refNodeOfPositionAbsolute planningNotificationTaskPageContentDiv");

            return contentDiv;
        },

        constructExportToPdfButton : function(captionBarDiv) {
            var button = new FancyButton({
                    title : i18n.planningNotificationTaskExportToPdfButtonToolTip,
                iconClass : "fancyButtonIcon17x18 fancyButton17x18 exportToPdfButton"
            });
            
            domClass.add(button.domNode, "fixedDialogWidget planningNotificationTaskPageExportToPdfButton");
            
            on(button, "click", lang.hitch(this, this.exportToPdf));

            domConstruct.place(button.domNode, captionBarDiv);
            
            return button;
        },

        exportToPdf : function() {
            var columnToWidth = GridHelper.getColumnToWidth(this.listWidget.grid);

            var planningNotificationService = this.applicationContext.getService("planningNotificationService");

            var sortSpecs = this.listWidget.getSortSpecs();
            
            var searchModel = this.searchWidget.getSearchModel();

            topic.publish("message/info", i18n.planningNotificationTaskPdfExportStarted);

            this.registerAsyncOperationStarted(PlanningNotificationTaskPage.AsyncOperation.EXPORT_TO_PDF);
            planningNotificationService.triggerExportPlanningNotificationTaskList(searchModel, columnToWidth, sortSpecs).then(lang.hitch(this, function(jobId) {
                JobHelper.registerJobStatusQueryForDownload(this.applicationContext, jobId, function(jobId) {
                    topic.publish("message/ok", i18n.planningNotificationTaskPdfExportFinished);

                    var parameterString = ioQuery.objectToQuery({
                        jobId : jobId
                    });
                    return "/cdes-dojo-impl/download?" + parameterString;
                });
                
                this.registerAsyncOperationFinished(PlanningNotificationTaskPage.AsyncOperation.EXPORT_TO_PDF);
            }), lang.hitch(this, function(err){                             
                ErrorHelper.processAsyncError({
                               err : err,
                            widget : this,
                    asyncOperation : PlanningNotificationTaskPage.AsyncOperation.EXPORT_TO_PDF,
                            opName : "triggerExportPlanningNotificationTaskList",
                           message : i18n.planningNotificationTaskExportListFailed
                });                             
            })).otherwise(
                lang.hitch(this, function(err) {
                    log.error("Handling the results of executing triggerExportPlanningNotificationTaskList failed", err);
                }));
        },

        resize : function(newSize) {
            if (newSize) {
                this.lastNewSize = newSize;
            }
            
            var totalHeight = this.lastNewSize.h;               
            var totalWidth = this.lastNewSize.w;               

            var tableHeight = totalHeight
            - this.captionBarDiv.offsetHeight
            - this.columnWidgetDiv.offsetHeight - domStyle.get(this.columnWidgetDiv, "margin-top") - domStyle.get(this.columnWidgetDiv, "margin-bottom")
            - 16;
            this.listWidget.resize({ h : tableHeight });

            domStyle.set(this.signBatchDiv, "left", (totalWidth - 367) + "px");
        },

        processQuickSearchChange : function(newSearch) {
            if (newSearch != this.lastQuickSearch) {
                this.listWidget.filter(newSearch);
                this.lastQuickSearch = newSearch;
            }
        },

        processColumnsChanged : function(columnId) {
            var columnSettings = this.columnWidget.getColumnSettings();
            this.listWidget.setColumns(columnSettings, columnId);
            this.manualColumns = true;
        },

        signBatch : function() {
            var signInfos = [];

            for (var n = 0; n < this.planningNotificationTaskInfos.length; n++) {
                var taskInfo = this.planningNotificationTaskInfos[n];
                var taskJoin = taskInfo.taskJoin;
                var workflowTokenId = taskJoin.workflowTokenId;
                if (this.listWidget.isSelected(workflowTokenId)) {
                    log.info("WorkflowTokenId [" + workflowTokenId + "] is selected, and will be signed.");

                    var attachmentsJson = taskJoin.workflowTokenReviewAttachments;
                    var attachments = json.parse(attachmentsJson);
                    var fileInfos = [];
                    for (var z = 0; z < attachments.length; z++) {
                        fileInfos.push({ fileName : attachments[z].file, label : attachments[z].original });
                    }

                    var signInfo = {
                                                      comment : taskJoin.workflowTokenReviewComment,
	                   workflowNodePositionResultOptionId : taskJoin.workflowTokenReviewOptionId,
	                workflowNodePositionResultOptionTitle : taskJoin.workflowTokenReviewOptionTitle,                        
	                planningNotificationOrderSerialNumber : taskJoin.planningNotificationOrderSerialNumber,                        
                                                fileInfos : fileInfos
                    };
                    lang.mixin(signInfo, taskJoin);                    

                    signInfos.push(signInfo);
                }                    
            }

		    var contentWidget = new ReviewSignWidget({
			applicationContext : this.applicationContext,
				  backPage : this.backPage,
				backParams : this.backParams,
	                             batch : true                
		    });
	
		    var editDialog = new EditDialog({
			contentWidget : contentWidget,
			defaultWidth  : 1100,  // Should be in sync with corresponding rules in CSS
			defaultHeight : 400,
				title : i18n.reviewSignWidgetCaption,
	    		      buttons : [ { type : ClazzesVoc.Button.SAVE, label : i18n.signButtonCaption, title : i18n.reviewSignSignButtonToolTip },
	    				  { type : ClazzesVoc.Button.ABORT, title : i18n.workflowReviewResultAbortButtonToolTip } ]
		    });
		    editDialog.setData({
                tokenInfos : signInfos
            });                
	    	editDialog.show();            

            on(contentWidget, "batchSignCompleted", lang.hitch(this, function() {
                this.reload();
                this.searchWidget.reloadCounts();
            }));

		    on(editDialog, "dialogClosed", lang.hitch(this, function() {
			contentWidget.destroy();
	                this.reload();
            }));
        },

        selectAll : function() {
            this.listWidget.selectAll(true);            
        },            

        selectNone : function() {
            this.listWidget.selectAll(false);
        },            

        selectUsingCheckBox : function() {
            var checked = this.selectCheckBox.get("checked");
            if (checked) {
                this.selectAll();
            } else {
                this.selectNone();
            }                
        },            

        setData : function() {

        },

        reload : function() {
            this.listWidget.setData({
                planningNotificationTaskInfos : [],
                               columnSettings : this.columnWidget.getColumnSettings(),
                                showSelection : false
            });                

            var searchModel = this.searchWidget.getSearchModel();
            
            topic.publish("message/info", i18n.searchRuns);

            this.registerAsyncOperationStarted(PlanningNotificationTaskPage.AsyncOperation.LOAD_DATA);
            var planningNotificationService = this.applicationContext.getService("planningNotificationService");
            planningNotificationService.getPlanningNotificationTaskJoins(searchModel).then(
                lang.hitch(this, function(planningNotificationTaskInfos) {
                    this.registerAsyncOperationFinished(PlanningNotificationTaskPage.AsyncOperation.LOAD_DATA);

                    // Transform from List to Set, for easier handling lateron.
                    for (var n = 0; n < planningNotificationTaskInfos.length; n++) {
                        var planningNotificationInfo = planningNotificationTaskInfos[n];
                        var allowedProjectActionsList = planningNotificationInfo.allowedProjectActions;
                        var allowedProjectActionsSet = new Object();
                        for (var v = 0; v < allowedProjectActionsList.length; v++) {
                            allowedProjectActionsSet[allowedProjectActionsList[v]] = true;
                        }

                        planningNotificationInfo.allowedProjectActions = allowedProjectActionsSet;
                    }                      

                    log.info("... Successfully loaded [" + planningNotificationTaskInfos.length + "] tasks.");

                    var columnSettings = ColumnHelper.getColumnSettingsForReload(this, searchModel.organisationPersonId);

                    var showSelection = this.searchWidget.getMode() == CdesVoc.TaskSearchMode.BATCH;
                    this.planningNotificationTaskInfos = planningNotificationTaskInfos;
                    this.listWidget.setData({ 
                        planningNotificationTaskInfos : planningNotificationTaskInfos,
                                       columnSettings : columnSettings,
                                        showSelection : showSelection,
                                                 mode : searchModel.mode                        
                    });

                    var message;
                    if (this.listWidget.gridClass == "Grid" && this.listWidget.maxGridItems != null && planningNotificationTaskInfos.length > this.listWidget.maxGridItems) {
                        message = string.substitute(i18n.planningNotificationTaskSearchSuccessfulMaxItems, {
                               count : planningNotificationTaskInfos.length,
                            maxItems : this.listWidget.maxGridItems                            
                        });
                    } else {
                        message = string.substitute(i18n.planningNotificationTaskSearchSuccessful, {
                            count : planningNotificationTaskInfos.length
                        });
                    }                        

                    topic.publish("message/ok", message);
                }),
                lang.hitch(this, function(err) {
                    ErrorHelper.processAsyncError({
                                   err : err,
                                widget : this,
                        asyncOperation : PlanningNotificationTaskPage.AsyncOperation.LOAD_DATA,
                                opName : "getPlanningNotificationTaskJoin",
                               message : i18n.planningNotificationTaskPageGetJoinsFailed
                    });
                })).otherwise(
                    lang.hitch(this, function(err) {
                        log.error("Error while calling function [getPlanningNotificationTaskJoins]", err);
                    }));
        },

        updateWidgetState : function() {
            if (this.searchWidget.getMode() == CdesVoc.TaskSearchMode.BATCH) {
                domClass.remove(this.signBatchDiv, "invisible");
                this.signBatchButton.set("disabled", !this.listWidget.isAnyTokenSelected());
            } else {
                domClass.add(this.signBatchDiv, "invisible");
            }                
        },

        getAutomaticColumnSettings : function(searchModel) {
            return {
                                showTask : true,
                        showSerialNumber : true,
                                showText : true,
                showPlanningNotification : true,
                			  showBaulos : true,
                             showProject : true,
                         showSubjectArea : false,
                 showAuthorizedInspector : true,
                       showStatutoryDuty : true,
                        showDocumentPage : true,
                    showDocumentPosition : true,
                      showPersonInCharge : false,
                             showDueDate : true,
                               showState : true         
            };          
        },          

        destroy : function() {
            this.inherited(arguments);
            this.listWidget.destroy();
        }
    });

    PlanningNotificationTaskPage.AsyncOperation = {
        EXPORT_TO_PDF : "ExportToPdf",
        LOAD_DATA : "LoadData"
    };

    PlanningNotificationTaskPage.AsyncOperation = {
			LOAD: "Load",
			UPDATE_NETWORK : "UpdateNetwork"	
	};	

    return PlanningNotificationTaskPage;
});
